/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;

abstract class MutableRoutine
extends AbstractDatabaseObject
implements Routine {
    private static final long serialVersionUID = 3906925686089134130L;
    private transient NamedObjectKey key;
    private final String specificName;
    private RoutineBodyType routineBodyType;
    private final Collection<DatabaseObject> referencedObjects;
    private String definition;

    MutableRoutine(Schema schema, String name, String specificName) {
        super(schema, name);
        Utility.requireNotBlank(name, "No routine name provided");
        this.specificName = specificName;
        this.routineBodyType = RoutineBodyType.unknown;
        this.referencedObjects = new HashSet<DatabaseObject>();
        this.definition = "";
    }

    @Override
    public int compareTo(NamedObject obj) {
        int comparison = super.compareTo(obj);
        if (obj instanceof Routine) {
            Routine other = (Routine)obj;
            if (comparison == 0) {
                List thisParameters = this.getParameters();
                List otherParameters = other.getParameters();
                comparison = CollectionsUtility.compareLists(thisParameters, otherParameters);
            }
            if (comparison == 0) {
                comparison = this.getSpecificName().compareTo(other.getSpecificName());
            }
        }
        return comparison;
    }

    @Override
    public final String getDefinition() {
        return this.definition;
    }

    public Collection<DatabaseObject> getReferencedObjects() {
        return Set.copyOf(this.referencedObjects);
    }

    @Override
    public final RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public RoutineType getRoutineType() {
        return null;
    }

    @Override
    public final String getSpecificName() {
        if (Utility.isBlank(this.specificName)) {
            return this.getName();
        }
        return this.specificName;
    }

    @Override
    public final RoutineType getType() {
        return this.getRoutineType();
    }

    @Override
    public final boolean hasDefinition() {
        return !Utility.isBlank(this.definition);
    }

    @Override
    public final NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    final void addReferencedObject(DatabaseObject referencedObject) {
        if (referencedObject != null) {
            this.referencedObjects.add(referencedObject);
        }
    }

    final void setDefinition(String definition) {
        if (!this.hasDefinition() && !Utility.isBlank(definition)) {
            this.definition = definition;
        }
    }

    final void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = super.key().with(this.specificName);
    }
}

