/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.util.JsonpCharacterEscapes;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;

public class JSONPObject
implements JacksonSerializable {
    protected final String _function;
    protected final Object _value;
    protected final JavaType _serializationType;

    public JSONPObject(String function, Object value) {
        this(function, value, null);
    }

    public JSONPObject(String function, Object value, JavaType asType) {
        this._function = function;
        this._value = value;
        this._serializationType = asType;
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        this.serialize(gen, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(JsonGenerator gen, SerializationContext provider) throws JacksonException {
        gen.writeRaw(this._function);
        gen.writeRaw('(');
        if (this._value == null) {
            provider.defaultSerializeNullValue(gen);
        } else {
            boolean override;
            boolean bl = override = gen.getCharacterEscapes() == null;
            if (override) {
                gen.setCharacterEscapes((CharacterEscapes)JsonpCharacterEscapes.instance());
            }
            try {
                if (this._serializationType != null) {
                    provider.findTypedValueSerializer(this._serializationType, true).serialize(this._value, gen, provider);
                } else {
                    provider.findTypedValueSerializer(this._value.getClass(), true).serialize(this._value, gen, provider);
                }
            }
            finally {
                if (override) {
                    gen.setCharacterEscapes(null);
                }
            }
        }
        gen.writeRaw(')');
    }

    public String getFunction() {
        return this._function;
    }

    public Object getValue() {
        return this._value;
    }

    public JavaType getSerializationType() {
        return this._serializationType;
    }
}

