/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotNbPower;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotVarargs;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.nfi.api.SignatureLibrary;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PyProcsWrapper
extends PythonNativeWrapper.PythonStructNativeWrapper {
    protected final CApiTiming timing;

    public PyProcsWrapper(Object delegate) {
        super(delegate, false);
        this.timing = CApiTiming.create(false, delegate);
    }

    @ExportMessage
    protected boolean isExecutable() {
        return true;
    }

    @ExportMessage
    protected Object execute(Object[] arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw CompilerDirectives.shouldNotReachHere((String)"abstract class");
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    protected long asPointer() {
        return this.getNativePointer();
    }

    protected abstract String getSignature();

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected void toNative(@CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
        if (!this.isPointer()) {
            CApiContext cApiContext = PythonContext.get(null).getCApiContext();
            this.setNativePointer(cApiContext.registerClosure(this.getSignature(), this, this.getDelegate(), signatureLibrary));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class DescrGetFunctionWrapper
    extends TpSlotWrapper {
        public DescrGetFunctionWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new DescrGetFunctionWrapper(slot);
        }

        @ExportMessage(name="execute")
        static class Execute {
            Execute() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization(guards={"arguments.length == 3"})
            static Object call(DescrGetFunctionWrapper self, Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotDescrGet.CallSlotDescrGet callGetNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) {
                boolean mustRelease = gil.acquire();
                CApiTiming.enter();
                try {
                    if (arguments.length < 3) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw ArityException.create((int)3, (int)-1, (int)arguments.length);
                    }
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object obj = toJavaNode.execute(arguments[1]);
                    Object cls = toJavaNode.execute(arguments[2]);
                    Object result = callGetNode.execute(null, inliningTarget, self.getSlot(), receiver, obj, cls);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "DescrGetFunctionWrapper", self.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
                finally {
                    CApiTiming.exit(self.timing);
                    gil.release(mustRelease);
                }
            }

            @Specialization(guards={"arguments.length != 3"})
            static Object error(DescrGetFunctionWrapper self, Object[] arguments) throws ArityException {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)3, (int)3, (int)arguments.length);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class HashfuncWrapper
    extends TpSlotWrapper {
        public HashfuncWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        long execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotHashFun.CallSlotHashFunNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length > 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)2, (int)arguments.length);
                }
                try {
                    long l = callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]));
                    return l;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "HashfuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        long l = -1L;
                        return l;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):SINT64";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new HashfuncWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class LenfuncWrapper
    extends TpSlotWrapper {
        public LenfuncWrapper(TpSlot.TpSlotManaged managedSlot) {
            super(managedSlot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        long execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotLen.CallSlotLenNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length < 1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)-1, (int)arguments.length);
                }
                try {
                    long l = callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]));
                    return l;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "LenfuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        long l = -1L;
                        return l;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):SINT64";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new LenfuncWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class SsizeobjargprocWrapper
    extends TpSlotWrapper {
        public SsizeobjargprocWrapper(TpSlot.TpSlotManaged slot) {
            super(slot);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new SsizeobjargprocWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        int execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotSqAssItem.CallSlotSqAssItemNode executeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached SsizeAsIntNode asIntNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                assert (arguments[1] instanceof Number);
                try {
                    Object self = toJavaNode.execute(arguments[0]);
                    int key = asIntNode.execute(inliningTarget, arguments[1]);
                    Object value = toJavaNode.execute(arguments[2]);
                    executeNode2.execute(null, inliningTarget, this.getSlot(), self, key, value);
                    int n = 0;
                    return n;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SsizeobjargprocWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        int n = -1;
                        return n;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,SINT64,POINTER):SINT32";
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class SsizeAsIntNode
    extends Node {
        SsizeAsIntNode() {
        }

        public abstract int execute(Node var1, Object var2);

        @Specialization
        static int doI(int i) {
            return i;
        }

        @Specialization
        static int doL(Node inliningTarget, long l, @Cached InlinedBranchProfile errorBranch) {
            if (PInt.isIntRange(l)) {
                return (int)l;
            }
            errorBranch.enter(inliningTarget);
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, l);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static int doOthers(Object value) {
            throw CompilerDirectives.shouldNotReachHere((String)"Unexpected value passed to upcall as Py_ssize_t");
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class SsizeargfuncSlotWrapper
    extends TpSlotWrapper {
        public SsizeargfuncSlotWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new SsizeargfuncSlotWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSlotNode, @Cached SsizeAsIntNode asIntNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                assert (arguments[1] instanceof Number);
                try {
                    Object result = callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), asIntNode.execute(inliningTarget, arguments[1]));
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SsizeargfuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(toJavaNode).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,SINT64):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class SsizeargfuncWrapper
    extends PyProcsWrapper {
        public SsizeargfuncWrapper(Object delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallBinaryMethodNode executeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                assert (arguments[1] instanceof Number);
                try {
                    Object result = executeNode2.executeObject(null, this.getDelegate(), toJavaNode.execute(arguments[0]), arguments[1]);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SsizeargfuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(toJavaNode).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,SINT64):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RichcmpFunctionWrapper
    extends TpSlotWrapper {
        public RichcmpFunctionWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new RichcmpFunctionWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached TpSlotRichCompare.CallSlotRichCmpNode callNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @CachedLibrary(limit="1") InteropLibrary opInterop, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                try {
                    Object arg0 = toJavaNode.execute(arguments[0]);
                    Object arg1 = toJavaNode.execute(arguments[1]);
                    RichCmpOp op = RichCmpOp.fromNative(opInterop.asInt(arguments[2]));
                    Object result = callNode.execute(null, inliningTarget, this.getSlot(), arg0, arg1, op);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "RichcmpFunctionWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,SINT32):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class NbInPlacePowerWrapper
    extends TpSlotWrapper {
        public NbInPlacePowerWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new NbInPlacePowerWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        static Object execute(NbInPlacePowerWrapper self, Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached TpSlotNbPower.CallSlotNbInPlacePowerNode callSlot, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object v = toJavaNode.execute(arguments[0]);
                Object w = toJavaNode.execute(arguments[1]);
                Object z = toJavaNode.execute(arguments[2]);
                Object result = callSlot.execute(null, inliningTarget, self.getSlot(), v, w, z);
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "NbInPlacePowerWrapper", self.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                CApiTiming.exit(self.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class NbPowerWrapper
    extends TpSlotWrapper {
        public NbPowerWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new NbPowerWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        static Object execute(NbPowerWrapper self, Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached GetClassNode vGetClassNode, @Cached GetClassNode wGetClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TpSlots.GetCachedTpSlotsNode wGetSlots, @Cached TpSlotNbPower.CallSlotNbPowerNode callSlot, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object v = toJavaNode.execute(arguments[0]);
                Object w = toJavaNode.execute(arguments[1]);
                Object z = toJavaNode.execute(arguments[2]);
                Object vType = vGetClassNode.execute(inliningTarget, v);
                Object wType = wGetClassNode.execute(inliningTarget, w);
                TpSlots wSlots = wGetSlots.execute(inliningTarget, wType);
                boolean sameTypes = isSameTypeNode.execute(inliningTarget, vType, wType);
                Object result = callSlot.execute(null, inliningTarget, self.getSlot(), v, vType, w, wSlots.nb_power(), wType, z, sameTypes);
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "NbPowerWrapper", self.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                CApiTiming.exit(self.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CallWrapper
    extends TpSlotWrapper {
        public CallWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new CallWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached TpSlotVarargs.CallSlotTpCallNode callNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object receiver = toJavaNode.execute(arguments[0]);
                Object starArgs = toJavaNode.execute(arguments[1]);
                Object kwArgs = toJavaNode.execute(arguments[2]);
                Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                Object result = callNode.execute(null, inliningTarget, this.getSlot(), receiver, starArgsArray, kwArgsArray);
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "CallWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class NewWrapper
    extends TpSlotWrapper {
        public NewWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new NewWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotVarargs.CallSlotTpNewNode callNew, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            try {
                Object receiver = toJavaNode.execute(arguments[0]);
                Object starArgs = toJavaNode.execute(arguments[1]);
                Object kwArgs = toJavaNode.execute(arguments[2]);
                Object[] pArgs = starArgs != PNone.NO_VALUE ? posStarargsNode.executeWith(null, starArgs) : PythonUtils.EMPTY_OBJECT_ARRAY;
                PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                Object result = callNew.execute(null, inliningTarget, this.getSlot(), receiver, pArgs, kwArgsArray);
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "NewWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(inliningTarget).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class InitWrapper
    extends TpSlotWrapper {
        public InitWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new InitWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        int execute(Object[] arguments, @Bind Node inliningTarget, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached TpSlotVarargs.CallSlotTpInitNode callSlot, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object receiver = toJavaNode.execute(arguments[0]);
                Object starArgs = toJavaNode.execute(arguments[1]);
                Object kwArgs = toJavaNode.execute(arguments[2]);
                Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                callSlot.execute(null, inliningTarget, this.getSlot(), receiver, starArgsArray, kwArgsArray);
                int n = 0;
                return n;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "InitWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    int n = -1;
                    return n;
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):SINT32";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class DescrSetFunctionWrapper
    extends TpSlotWrapper {
        public DescrSetFunctionWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        int execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotDescrSet.CallSlotDescrSet callSetNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length < 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)-1, (int)arguments.length);
                }
                try {
                    callSetNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1]), toJavaNode.execute(arguments[2]));
                    int n = 0;
                    return n;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SetAttrWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        int n = -1;
                        return n;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):SINT32";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new DescrSetFunctionWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class SetattrWrapper
    extends TpSlotWrapper {
        public SetattrWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        int execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotSetAttr.CallManagedSlotSetAttrNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached InlinedConditionProfile arityProfile, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arityProfile.profile(inliningTarget, arguments.length < 3)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)-1, (int)arguments.length);
                }
                try {
                    callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1]), toJavaNode.execute(arguments[2]));
                    int n = 0;
                    return n;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SetattrWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        int n = -1;
                        return n;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):SINT32";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new SetattrWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class ObjobjargWrapper
    extends TpSlotWrapper {
        public ObjobjargWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new ObjobjargWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        int execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotMpAssSubscript.CallSlotMpAssSubscriptNode callNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached InlinedConditionProfile arityProfile, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arityProfile.profile(inliningTarget, arguments.length != 3)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                try {
                    callNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1]), toJavaNode.execute(arguments[2]));
                    int n = 0;
                    return n;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "ObjobjargWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        int n = -1;
                        return n;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):SINT32";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class SqContainsWrapper
    extends TpSlotWrapper {
        public SqContainsWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotSqContains.CallSlotSqContainsNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Boolean bl = callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1]));
                return bl;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SqContainsWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    Integer n = -1;
                    return n;
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):SINT32";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new SqContainsWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class InquiryWrapper
    extends TpSlotWrapper {
        public InquiryWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached TpSlotInquiry.CallSlotNbBoolNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length < 1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)-1, (int)arguments.length);
                }
                try {
                    Boolean bl = callSlotNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]));
                    return bl;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "InquiryWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        Integer n = -1;
                        return n;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):SINT32";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new InquiryWrapper(slot);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class IterNextWrapper
    extends TpSlotWrapper {
        public IterNextWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new IterNextWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotIterNext.CallSlotTpIterNextNode callNextNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object result;
                try {
                    result = callNextNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]));
                }
                catch (IteratorExhausted e) {
                    NativePointer nativePointer = PythonContext.get(inliningTarget).getNativeNull();
                    CApiTiming.exit(this.timing);
                    gil.release(mustRelease);
                    return nativePointer;
                }
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "UnaryFuncWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class UnaryFuncWrapper
    extends TpSlotWrapper {
        public UnaryFuncWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new UnaryFuncWrapper(slot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                Object result = callNode.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]));
                Object object = toNativeNode.execute(result);
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "UnaryFuncWrapper", this.getDelegate());
                }
                catch (PException e) {
                    transformExceptionToNativeNode.execute(inliningTarget, e);
                    NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                    return nativePointer;
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class UnaryFuncLegacyWrapper
    extends PyProcsWrapper {
        public UnaryFuncLegacyWrapper(Object delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallUnaryMethodNode executeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length > 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)2, (int)arguments.length);
                }
                try {
                    Object object = toNativeNode.execute(executeNode2.executeObject(null, this.getDelegate(), toJavaNode.execute(arguments[0])));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "UnaryFuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class BinaryOpSlotFuncWrapper
    extends TpSlotWrapper {
        private final TpSlotBinaryOp.ReversibleSlot binaryOp;

        public BinaryOpSlotFuncWrapper(TpSlot.TpSlotManaged delegate, TpSlotBinaryOp.ReversibleSlot binaryOp) {
            super(delegate);
            this.binaryOp = binaryOp;
        }

        public static BinaryOpSlotFuncWrapper createAdd(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_ADD);
        }

        public static BinaryOpSlotFuncWrapper createSubtract(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_SUBTRACT);
        }

        public static BinaryOpSlotFuncWrapper createMultiply(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_MULTIPLY);
        }

        public static BinaryOpSlotFuncWrapper createRemainder(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_REMAINDER);
        }

        public static BinaryOpSlotFuncWrapper createLShift(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_LSHIFT);
        }

        public static BinaryOpSlotFuncWrapper createRShift(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_RSHIFT);
        }

        public static BinaryOpSlotFuncWrapper createAnd(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_AND);
        }

        public static BinaryOpSlotFuncWrapper createXor(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_XOR);
        }

        public static BinaryOpSlotFuncWrapper createOr(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_OR);
        }

        public static BinaryOpSlotFuncWrapper createFloorDivide(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_FLOOR_DIVIDE);
        }

        public static BinaryOpSlotFuncWrapper createTrueDivide(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_TRUE_DIVIDE);
        }

        public static BinaryOpSlotFuncWrapper createDivMod(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_DIVMOD);
        }

        public static BinaryOpSlotFuncWrapper createMatrixMultiply(TpSlot.TpSlotManaged delegate) {
            return new BinaryOpSlotFuncWrapper(delegate, TpSlotBinaryOp.ReversibleSlot.NB_MATRIX_MULTIPLY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotBinaryOp.CallSlotBinaryOpNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode selfToJavaNode, @Cached CApiTransitions.NativeToPythonNode argTtoJavaNode, @Cached GetClassNode getSelfClassNode, @Cached GetClassNode getOtherClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached TpSlots.GetCachedTpSlotsNode getOtherSlots, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object self = selfToJavaNode.execute(arguments[0]);
                    Object other = argTtoJavaNode.execute(arguments[1]);
                    Object otherType = getOtherClassNode.execute(inliningTarget, other);
                    Object selfType = getSelfClassNode.execute(inliningTarget, self);
                    TpSlot otherSlot = this.binaryOp.getSlotValue(getOtherSlots.execute(inliningTarget, otherType));
                    boolean sameTypes = isSameTypeNode.execute(inliningTarget, selfType, otherType);
                    Object object = toNativeNode.execute(callSlotNode.execute(null, inliningTarget, this.getSlot(), self, selfType, other, otherSlot, otherType, sameTypes, this.binaryOp));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "BinaryFuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new BinaryOpSlotFuncWrapper(slot, this.binaryOp);
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class BinarySlotFuncWrapper
    extends TpSlotWrapper {
        public BinarySlotFuncWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callSlotNode, @Cached CApiTransitions.NativeToPythonNode selfToJavaNode, @Cached CApiTransitions.NativeToPythonNode argTtoJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object object = toNativeNode.execute(callSlotNode.execute(null, inliningTarget, this.getSlot(), selfToJavaNode.execute(arguments[0]), argTtoJavaNode.execute(arguments[1])));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "BinaryFuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new BinarySlotFuncWrapper(slot);
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class BinaryFuncWrapper
    extends PyProcsWrapper {
        public BinaryFuncWrapper(Object delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallBinaryMethodNode executeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object object = toNativeNode.execute(executeNode2.executeObject(null, this.getDelegate(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1])));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "BinaryFuncWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class GetAttrWrapper
    extends TpSlotWrapper {
        public GetAttrWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached TpSlotGetAttr.CallManagedSlotGetAttrNode callGetAttr, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length < 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)-1, (int)arguments.length);
                }
                try {
                    Object object = toNativeNode.execute(callGetAttr.execute(null, inliningTarget, this.getSlot(), toJavaNode.execute(arguments[0]), toJavaNode.execute(arguments[1])));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "GetAttrWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }

        @Override
        public TpSlotWrapper cloneWith(TpSlot.TpSlotManaged slot) {
            return new GetAttrWrapper(slot);
        }
    }

    public static abstract class TpSlotWrapper
    extends PyProcsWrapper {
        public TpSlotWrapper(TpSlot.TpSlotManaged delegate) {
            super(delegate);
        }

        public final TpSlot.TpSlotManaged getSlot() {
            return (TpSlot.TpSlotManaged)this.getDelegate();
        }

        public abstract TpSlotWrapper cloneWith(TpSlot.TpSlotManaged var1);
    }
}

