/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PosixSubprocessModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PosixSubprocessModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="_posixsubprocess")
public final class PosixSubprocessModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PosixSubprocessModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="fork_exec", parameterNames={"args", "executable_list", "close_fds", "fds_to_keep", "cwd", "env", "p2cread", "p2cwrite", "c2pread", "c2pwrite", "errread", "errwrite", "errpipe_read", "errpipe_write", "restore_signals", "call_setsid", "pgid_to_set", "gid_object", "groups_list", "uid_object", "child_umask", "preexec_fn", "allow_vfork"})
    @ArgumentsClinic(value={@ArgumentClinic(name="args", conversionClass=ProcessArgsConversionNode.class), @ArgumentClinic(name="close_fds", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="env", conversionClass=EnvConversionNode.class), @ArgumentClinic(name="p2cread", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="p2cwrite", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="c2pread", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="c2pwrite", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="errread", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="errwrite", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="errpipe_read", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="errpipe_write", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="restore_signals", conversion=ArgumentClinic.ClinicConversion.IntToBoolean), @ArgumentClinic(name="call_setsid", conversion=ArgumentClinic.ClinicConversion.IntToBoolean), @ArgumentClinic(name="pgid_to_set", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="child_umask", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="allow_vfork", conversion=ArgumentClinic.ClinicConversion.Boolean)})
    @GenerateNodeFactory
    static abstract class NewForkExecNode
    extends PythonClinicBuiltinNode {
        NewForkExecNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PosixSubprocessModuleBuiltinsClinicProviders.NewForkExecNodeClinicProviderGen.INSTANCE;
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] fsEncode(String s) {
            return s.getBytes();
        }

        private static Object createPathFromBytes(Node inliningTarget, byte[] bytes, PosixSupportLibrary posixLib, PRaiseNode raiseNode) {
            Object o = posixLib.createPathFromBytes(PosixSupport.get(inliningTarget), bytes);
            if (o == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            return o;
        }

        @Specialization
        static int forkExec(VirtualFrame frame, Object[] args, Object executableList, boolean closeFds, Object fdsToKeepObj, Object cwdObj, Object env, int stdinRead, int stdinWrite, int stdoutRead, int stdoutWrite, int stderrRead, int stderrWrite, int errPipeRead, int errPipeWrite, boolean restoreSignals, boolean callSetsid, int pgidToSet, Object gidObject, Object groupsList, Object uidObject, int childUmask, Object preexecFn, boolean allowVFork, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode tupleGetItem, @Cached PyObjectGetItem getItem, @Cached CastToJavaIntExactNode castToIntNode, @Cached PosixModuleBuiltins.ObjectToOpaquePathNode objectToOpaquePathNode, @Cached PyObjectSizeNode sizeNode, @Cached GilNode gil, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            int i;
            if (!(preexecFn instanceof PNone)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.S_NOT_SUPPORTED, "preexec_fn");
            }
            if (closeFds && errPipeWrite < 3) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.S_MUST_BE_S, "errpipe_write", ">= 3");
            }
            if (!(fdsToKeepObj instanceof PTuple)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "fork_exec()", 4, "tuple", fdsToKeepObj);
            }
            Object[] processArgs = args;
            int[] fdsToKeep = NewForkExecNode.convertFdSequence(inliningTarget, (PTuple)fdsToKeepObj, tupleGetItem, castToIntNode, raiseNode);
            Object cwd = PGuards.isPNone(cwdObj) ? null : objectToOpaquePathNode.execute(frame, inliningTarget, cwdObj, false);
            PythonContext context = PythonContext.get(inliningTarget);
            byte[] sysExecutable = NewForkExecNode.fsEncode(context.getOption(PythonOptions.Executable).toJavaStringUncached());
            int length = sizeNode.execute((Frame)frame, inliningTarget, executableList);
            Object[] executables = new Object[length];
            for (i = 0; i < length; ++i) {
                byte[] bytes = toBytesNode.execute(frame, getItem.execute((Frame)frame, inliningTarget, executableList, i));
                if (Arrays.equals(bytes, sysExecutable) || NewForkExecNode.isBytecodeDSLJvmVenvLauncher(context, bytes)) {
                    TruffleString[] additionalArgs = PythonOptions.getExecutableList(context);
                    if (length != 1 && additionalArgs.length != 1) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_USE_OF_SYS_EXECUTABLE);
                    }
                    Object[] extendedArgs = new Object[additionalArgs.length + (processArgs.length == 0 ? 0 : processArgs.length - 1)];
                    for (int j = 0; j < additionalArgs.length; ++j) {
                        extendedArgs[j] = NewForkExecNode.createPathFromBytes(inliningTarget, NewForkExecNode.fsEncode(additionalArgs[j].toJavaStringUncached()), posixLib, raiseNode);
                    }
                    if (processArgs.length > 1) {
                        PythonUtils.arraycopy(processArgs, 1, extendedArgs, additionalArgs.length, processArgs.length - 1);
                    }
                    processArgs = extendedArgs;
                    executables[i] = extendedArgs[0];
                    continue;
                }
                executables[i] = NewForkExecNode.createPathFromBytes(inliningTarget, bytes, posixLib, raiseNode);
            }
            gil.release(true);
            try {
                i = posixLib.forkExec(context.getPosixSupport(), executables, processArgs, cwd, env == null ? null : (Object[])env, stdinRead, stdinWrite, stdoutRead, stdoutWrite, stderrRead, stderrWrite, errPipeRead, errPipeWrite, closeFds, restoreSignals, callSetsid, fdsToKeep);
                return i;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (SecurityException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.EPERM);
            }
            finally {
                gil.acquire();
            }
        }

        private static boolean isBytecodeDSLJvmVenvLauncher(PythonContext context, byte[] bytes) {
            if (!PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER || ImageInfo.inImageRuntimeCode()) {
                return false;
            }
            Path executablePath = Path.of(context.getOption(PythonOptions.Executable).toJavaStringUncached(), new String[0]).toAbsolutePath();
            Path path = Path.of(new String(bytes), new String[0]);
            Path parent = path.getParent();
            while (Files.isSymbolicLink(path) && parent != null) {
                try {
                    Path symlink = Files.readSymbolicLink(path);
                    path = parent.resolve(symlink).toAbsolutePath();
                }
                catch (IOException ignore) {
                    return false;
                }
                if (path.equals(executablePath)) {
                    return true;
                }
                parent = path.getParent();
            }
            return false;
        }

        private static int[] convertFdSequence(Node inliningTarget, PTuple fdSequence, SequenceStorageNodes.GetItemNode getItemNode, CastToJavaIntExactNode castToIntNode, PRaiseNode raiseNode) {
            SequenceStorage storage = fdSequence.getSequenceStorage();
            int len = storage.length();
            int[] fds = new int[len];
            int prevFd = -1;
            for (int i = 0; i < len; ++i) {
                try {
                    int fd = castToIntNode.execute(inliningTarget, getItemNode.execute(storage, i));
                    if (fd > prevFd) {
                        prevFd = fds[i] = fd;
                        continue;
                    }
                }
                catch (CannotCastException | PException object) {
                    // empty catch block
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BAD_VALUES_IN_FDS_TO_KEEP);
            }
            return fds;
        }
    }

    static abstract class EnvConversionNode
    extends ArgumentCastNode {
        EnvConversionNode() {
        }

        @Specialization
        static Object doNone(PNone env) {
            return null;
        }

        @Specialization(guards={"!isPNone(env)"})
        static Object doSequence(VirtualFrame frame, Object env, @Bind Node inliningTarget, @Bind PythonContext context, @Cached PyObjectSizeNode sizeNode, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PyObjectGetItem getItem, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PRaiseNode raiseNode) {
            int length = sizeNode.execute((Frame)frame, inliningTarget, env);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object o = getItem.execute((Frame)frame, inliningTarget, env, i);
                byte[] bytes = toBytesNode.execute(frame, o);
                Object o1 = posixLib.createPathFromBytes(context.getPosixSupport(), bytes);
                if (o1 == null) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
                }
                result[i] = o1;
            }
            return result;
        }

        @ClinicConverterFactory
        @NeverDefault
        static EnvConversionNode create() {
            return PosixSubprocessModuleBuiltinsFactory.EnvConversionNodeGen.create();
        }
    }

    static abstract class ProcessArgsConversionNode
    extends ArgumentCastNode {
        ProcessArgsConversionNode() {
        }

        @Specialization
        static Object[] doNone(PNone processArgs) {
            return new Object[0];
        }

        @Specialization
        static Object[] doSequence(VirtualFrame frame, Object processArgs, @Bind Node inliningTarget, @Cached ListNodes.FastConstructListNode fastConstructListNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached PosixModuleBuiltins.ObjectToOpaquePathNode objectToOpaquePathNode, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PRaiseNode raiseNode) {
            PList argsSequence;
            try {
                argsSequence = fastConstructListNode.execute((Frame)frame, inliningTarget, processArgs);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.TypeError, isBuiltinClassProfile);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_MUST_BE_S, "argv", "a tuple");
            }
            SequenceStorage argsStorage = getSequenceStorageNode.execute(inliningTarget, argsSequence);
            int len = argsStorage.length();
            Object[] argsArray = new Object[len];
            for (int i = 0; i < len; ++i) {
                SequenceStorage newStorage = getSequenceStorageNode.execute(inliningTarget, argsSequence);
                if (newStorage != argsStorage || newStorage.length() != len) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.ARGS_CHANGED_DURING_ITERATION);
                }
                Object o = getItemNode.execute(argsStorage, i);
                argsArray[i] = objectToOpaquePathNode.execute(frame, inliningTarget, o, false);
            }
            return argsArray;
        }

        @ClinicConverterFactory
        @NeverDefault
        static ProcessArgsConversionNode create() {
            return PosixSubprocessModuleBuiltinsFactory.ProcessArgsConversionNodeGen.create();
        }
    }
}

