/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.data.handlers.BeanRowHandler;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.generator.CompositeKeyPDQ;
import com.ibm.db2.cmx.runtime.generator.ListHashMapPDQ;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NestedBeanResultHandler<T>
implements ResultHandler<List<T>> {
    static Logger logger__ = Log.getAPILogger();
    private Class beanClass_;
    protected String[] columnLabels_;
    protected String[] tableNames_;
    protected ResultSet resultSet_;
    protected HashSet<BeanPropertyInformation> joinPointsToProcess_ = new HashSet();
    protected BeanRowHandler[] rowHandlers_;
    protected HashMap<BeanInformation, BeanInfoHolder> beanInfoToRowHandlerMap_ = new HashMap();

    private NestedBeanResultHandler() {
    }

    public NestedBeanResultHandler(Class<T> clazz) {
        this.beanClass_ = clazz;
    }

    @Override
    public List<T> handle(ResultSet resultSet) {
        try {
            ListHashMapPDQ<Object, Object> listHashMapPDQ;
            this.resultSet_ = resultSet;
            this.initResultSetData(resultSet);
            BeanInformation beanInformation = BeanInformationCache.getBeanInformation(this.beanClass_);
            this.breadthFirstJoinPoints(beanInformation);
            ListHashMapPDQ<Object, Object> listHashMapPDQ2 = listHashMapPDQ = this.populateTopLevel(beanInformation, new ListHashMapPDQ<Object, Object>());
            return listHashMapPDQ2;
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_HAND_ROW", new Object[0]), exception, 11243);
        }
        finally {
            this.close(resultSet);
        }
    }

    protected ListHashMapPDQ<Object, Object> populateTopLevel(BeanInformation beanInformation, ListHashMapPDQ<Object, Object> listHashMapPDQ) throws SQLException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[1];
        Object object = null;
        this.rowHandlers_ = this.getBeanRowHandlerArray();
        BeanInfoHolder beanInfoHolder = this.beanInfoToRowHandlerMap_.get(beanInformation);
        while (this.resultSet_.next()) {
            this.resetBeanRowHandlersForNewRow();
            Object object2 = this.handleBean(this.resultSet_, beanInformation, beanInfoHolder.rowHandler_, object, objectArray, listHashMapPDQ);
            if (object2 == null) continue;
            if (object2 != object) {
                object = object2;
            }
            if (!beanInformation.isNestedBean()) continue;
            this.populateChildren(beanInformation, object2);
        }
        return listHashMapPDQ;
    }

    private void populateChildren(BeanInformation beanInformation, Object object) throws InvocationTargetException, IllegalAccessException, SQLException {
        List<BeanPropertyInformation> list = beanInformation.getJoinPointProperties();
        for (BeanPropertyInformation beanPropertyInformation : list) {
            ListHashMapPDQ<Object, Object> listHashMapPDQ;
            BeanInformation beanInformation2;
            if (!this.joinPointsToProcess_.contains(beanPropertyInformation) || (beanInformation2 = beanPropertyInformation.nestedBeanReturnInfo_) == null) continue;
            BeanInfoHolder beanInfoHolder = null;
            beanInfoHolder = this.beanInfoToRowHandlerMap_.get(beanInformation2);
            JavaType javaType = beanPropertyInformation.getPropertyType();
            if (javaType == JavaType.LIST) {
                listHashMapPDQ = (ListHashMapPDQ<Object, Object>)beanPropertyInformation.getValue(object);
                ListHashMapPDQ<Object, Object> listHashMapPDQ2 = this.populateNestedBeans(beanInfoHolder, listHashMapPDQ);
                beanPropertyInformation.setValue(object, listHashMapPDQ2);
                continue;
            }
            if (javaType != JavaType.OBJECT) continue;
            listHashMapPDQ = this.populateNestedBeans(beanInfoHolder, null);
            if (listHashMapPDQ.size() == 1) {
                beanPropertyInformation.setValue(object, listHashMapPDQ.get(0));
                continue;
            }
            if (listHashMapPDQ.size() <= 1) continue;
            beanPropertyInformation.setValue(object, listHashMapPDQ.get(0));
            if (!logger__.isLoggable(Level.FINEST)) continue;
            logger__.logp(Level.FINEST, "NestedBeanResultHandler", "populateChildren", "Property " + beanPropertyInformation.getCaseSensitivePropertyName() + " can hold only 1 Object, but " + listHashMapPDQ.size() + " rows were returned to be placed in it.");
        }
    }

    protected ListHashMapPDQ<Object, Object> populateNestedBeans(BeanInfoHolder beanInfoHolder, ListHashMapPDQ<Object, Object> listHashMapPDQ) throws SQLException, IllegalAccessException, InvocationTargetException {
        BeanRowHandler beanRowHandler;
        BeanInformation beanInformation;
        Object object;
        if (listHashMapPDQ == null) {
            listHashMapPDQ = new ListHashMapPDQ();
        }
        if ((object = this.handleBean(this.resultSet_, beanInformation = beanInfoHolder.beanInfo_, beanRowHandler = beanInfoHolder.rowHandler_, null, null, listHashMapPDQ)) != null && beanInformation.isNestedBean()) {
            this.populateChildren(beanInformation, object);
        }
        return listHashMapPDQ;
    }

    private void resetBeanRowHandlersForNewRow() {
        int n2 = this.rowHandlers_.length;
        for (int i10 = 0; i10 < n2; ++i10) {
            this.rowHandlers_[i10].usedRow_ = false;
        }
    }

    private BeanRowHandler[] getBeanRowHandlerArray() {
        ArrayList<BeanRowHandler> arrayList = new ArrayList<BeanRowHandler>();
        for (BeanInfoHolder beanInfoHolder : this.beanInfoToRowHandlerMap_.values()) {
            arrayList.add(beanInfoHolder.rowHandler_);
        }
        return arrayList.toArray(new BeanRowHandler[arrayList.size()]);
    }

    private Object handleBean(ResultSet resultSet, BeanInformation beanInformation, BeanRowHandler beanRowHandler, Object object, Object[] objectArray, ListHashMapPDQ<Object, Object> listHashMapPDQ) throws SQLException, IllegalAccessException, InvocationTargetException {
        if (beanRowHandler.usedRow_) {
            return null;
        }
        beanRowHandler.usedRow_ = true;
        beanRowHandler.mapResultSetToBean(resultSet);
        Object[] objectArray2 = beanRowHandler.getIdValuesOnly(resultSet);
        int n2 = objectArray2.length;
        boolean bl2 = false;
        for (int i10 = 0; i10 < n2; ++i10) {
            if (objectArray2[i10] == null) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return null;
        }
        Object object2 = n2 == 1 ? objectArray2[0] : new CompositeKeyPDQ(objectArray2);
        if (objectArray != null && object2.equals(objectArray[0])) {
            return object;
        }
        Object object3 = listHashMapPDQ.get(object2);
        if (object3 != null) {
            if (objectArray != null) {
                objectArray[0] = object2;
            }
            return object3;
        }
        Object v2 = beanRowHandler.handle(resultSet, null);
        if (v2 == null) {
            return null;
        }
        if (object3 == null) {
            listHashMapPDQ.put(object2, v2);
        }
        if (objectArray != null) {
            objectArray[0] = object2;
        }
        return v2;
    }

    protected void breadthFirstJoinPoints(BeanInformation beanInformation) throws SQLException {
        Object object;
        List<BeanPropertyInformation> list = beanInformation.getJoinPointProperties();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(beanInformation.getBeanClass().getCanonicalName());
        if (logger__.isLoggable(Level.ALL)) {
            object = "top-level-class: " + beanInformation.getBeanClass().getCanonicalName();
            logger__.logp(Level.ALL, "NestedBeanResultHandler", "breadthFirstJoinPoints", (String)object);
        }
        object = new BeanInfoHolder(beanInformation);
        BeanRowHandler beanRowHandler = ((BeanInfoHolder)object).rowHandler_;
        beanRowHandler.mapResultSetToBean(this.resultSet_);
        this.beanInfoToRowHandlerMap_.put(beanInformation, (BeanInfoHolder)object);
        LinkedList<BeanPropertyInformation> linkedList = new LinkedList<BeanPropertyInformation>();
        linkedList.addAll(list);
        while (!linkedList.isEmpty()) {
            String string;
            Object object2;
            Object object3;
            BeanPropertyInformation beanPropertyInformation = (BeanPropertyInformation)linkedList.poll();
            String string2 = beanPropertyInformation.parentBeanInfo_.columnPrefix_;
            if (logger__.isLoggable(Level.ALL)) {
                object3 = "parent-class: " + beanPropertyInformation.parentBeanInfo_.getBeanClass().getCanonicalName() + "\nparent-prefix: " + string2;
                logger__.logp(Level.ALL, "NestedBeanResultHandler", "breadthFirstJoinPoints", (String)object3);
            }
            object3 = beanPropertyInformation.getNestedBeanReturnInfo();
            if (logger__.isLoggable(Level.ALL)) {
                object2 = "nested-class: " + ((BeanInformation)object3).getBeanClass().getCanonicalName() + "\nnested-class-prefix: " + ((BeanInformation)object3).columnPrefix_;
                logger__.logp(Level.ALL, "NestedBeanResultHandler", "breadthFirstJoinPoints", (String)object2);
            }
            if (object3 == null) continue;
            object2 = ((BeanInformation)object3).getBeanClass();
            String string3 = ((Class)object2).getCanonicalName();
            if (((BeanInformation)object3).columnPrefix_ != null) {
                string3 = string3 + "~" + ((BeanInformation)object3).columnPrefix_;
            }
            if (hashSet.contains(string3)) {
                if (!logger__.isLoggable(Level.FINER)) continue;
                logger__.logp(Level.FINER, "NestedBeanResultHandler", "breadthFirstJoinPoints", Messages.getText("ERR_NESTED_BEAN_MORE_THAN_ONE", beanInformation.getBeanClass().getCanonicalName(), ((Class)object2).getCanonicalName(), "Nested bean hierarchy of " + beanInformation.getBeanClass().getCanonicalName(), ((BeanInformation)object3).columnPrefix_));
                continue;
            }
            hashSet.add(string3);
            object = new BeanInfoHolder((BeanInformation)object3);
            beanRowHandler = ((BeanInfoHolder)object).rowHandler_;
            beanRowHandler.mapResultSetToBean(this.resultSet_);
            if (beanRowHandler.idColumns_.length > 0) {
                if (logger__.isLoggable(Level.FINEST)) {
                    string = "\n" + Messages.getText("MSG_RS_CONTAINS_NESTED_BEAN", ((BeanInformation)object3).getBeanClass().getCanonicalName() + " for \n     @JoinPoint: " + beanPropertyInformation.getCaseSensitivePropertyName() + "\n       columnPrefix: " + ((BeanInformation)object3).columnPrefix_ + "\n");
                    logger__.logp(Level.FINEST, "NestedBeanResultHandler", "breadthFirstJoinPoints", string);
                }
                this.joinPointsToProcess_.add(beanPropertyInformation);
                list = ((BeanInformation)object3).getJoinPointProperties();
                this.beanInfoToRowHandlerMap_.put((BeanInformation)object3, (BeanInfoHolder)object);
                if (list == null) continue;
                linkedList.addAll(list);
                continue;
            }
            if (!logger__.isLoggable(Level.FINEST)) continue;
            string = "\n" + Messages.getText("MSG_RS_DOESNOT_CONTAIN_NESTED_BEAN", ((BeanInformation)object3).getBeanClass().getCanonicalName() + " for \n     @JoinPoint: " + beanPropertyInformation.getCaseSensitivePropertyName() + "\n       columnPrefix: " + ((BeanInformation)object3).columnPrefix_ + "\n");
            logger__.logp(Level.FINEST, "NestedBeanResultHandler", "breadthFirstJoinPoints", string);
        }
    }

    protected void initResultSetData(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        this.columnLabels_ = new String[n2];
        this.tableNames_ = new String[n2];
        for (int i10 = 1; i10 <= n2; ++i10) {
            this.columnLabels_[i10 - 1] = resultSetMetaData.getColumnLabel(i10).toLowerCase();
            if (resultSetMetaData.getTableName(i10) == null) continue;
            this.tableNames_[i10 - 1] = resultSetMetaData.getTableName(i10).toLowerCase();
        }
    }

    public void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                Statement statement = null;
                try {
                    statement = resultSet.getStatement();
                }
                catch (DataRuntimeException dataRuntimeException) {
                    // empty catch block
                }
                resultSet.close();
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    class BeanInfoHolder {
        BeanInformation beanInfo_;
        BeanRowHandler rowHandler_;

        BeanInfoHolder(BeanInformation beanInformation) {
            this.beanInfo_ = beanInformation;
            this.rowHandler_ = new BeanRowHandler(beanInformation.getBeanClass(), beanInformation);
            this.rowHandler_.columnLabels_ = NestedBeanResultHandler.this.columnLabels_;
            this.rowHandler_.tableNames_ = NestedBeanResultHandler.this.tableNames_;
        }
    }
}

