/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Constructor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.EncryptedPart;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SignedPart;

public class CompoundBeacon {
    private final String name;
    private final String split;
    private final List<EncryptedPart> encrypted;
    private final List<SignedPart> signed;
    private final List<Constructor> constructors;

    protected CompoundBeacon(BuilderImpl builder) {
        this.name = builder.name();
        this.split = builder.split();
        this.encrypted = builder.encrypted();
        this.signed = builder.signed();
        this.constructors = builder.constructors();
    }

    public String name() {
        return this.name;
    }

    public String split() {
        return this.split;
    }

    public List<EncryptedPart> encrypted() {
        return this.encrypted;
    }

    public List<SignedPart> signed() {
        return this.signed;
    }

    public List<Constructor> constructors() {
        return this.constructors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected String split;
        protected List<EncryptedPart> encrypted;
        protected List<SignedPart> signed;
        protected List<Constructor> constructors;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CompoundBeacon model) {
            this.name = model.name();
            this.split = model.split();
            this.encrypted = model.encrypted();
            this.signed = model.signed();
            this.constructors = model.constructors();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder split(String split) {
            this.split = split;
            return this;
        }

        @Override
        public String split() {
            return this.split;
        }

        @Override
        public Builder encrypted(List<EncryptedPart> encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        @Override
        public List<EncryptedPart> encrypted() {
            return this.encrypted;
        }

        @Override
        public Builder signed(List<SignedPart> signed) {
            this.signed = signed;
            return this;
        }

        @Override
        public List<SignedPart> signed() {
            return this.signed;
        }

        @Override
        public Builder constructors(List<Constructor> constructors) {
            this.constructors = constructors;
            return this;
        }

        @Override
        public List<Constructor> constructors() {
            return this.constructors;
        }

        @Override
        public CompoundBeacon build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (Objects.isNull(this.split())) {
                throw new IllegalArgumentException("Missing value for required field `split`");
            }
            if (Objects.nonNull(this.split()) && this.split().length() < 1) {
                throw new IllegalArgumentException("The size of `split` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.split()) && this.split().length() > 1) {
                throw new IllegalArgumentException("The size of `split` must be less than or equal to 1");
            }
            if (Objects.nonNull(this.encrypted()) && this.encrypted().size() < 1) {
                throw new IllegalArgumentException("The size of `encrypted` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.signed()) && this.signed().size() < 1) {
                throw new IllegalArgumentException("The size of `signed` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.constructors()) && this.constructors().size() < 1) {
                throw new IllegalArgumentException("The size of `constructors` must be greater than or equal to 1");
            }
            return new CompoundBeacon(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder split(String var1);

        public String split();

        public Builder encrypted(List<EncryptedPart> var1);

        public List<EncryptedPart> encrypted();

        public Builder signed(List<SignedPart> var1);

        public List<SignedPart> signed();

        public Builder constructors(List<Constructor> var1);

        public List<Constructor> constructors();

        public CompoundBeacon build();
    }
}

