/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.common;

import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.protobufs.DoubleArray;
import org.opensearch.protobufs.GeoHashLocation;
import org.opensearch.protobufs.GeoLocation;
import org.opensearch.protobufs.LatLonGeoLocation;

public class GeoPointProtoUtils {
    private GeoPointProtoUtils() {
    }

    public static GeoPoint parseGeoPoint(GeoLocation geoLocation) {
        GeoPoint point = new GeoPoint();
        return GeoPointProtoUtils.parseGeoPoint(geoLocation, point, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
    }

    public static GeoPoint parseGeoPoint(GeoLocation geoLocation, GeoPoint point, boolean ignoreZValue, GeoUtils.EffectivePoint effectivePoint) {
        if (geoLocation.hasLatlon()) {
            LatLonGeoLocation latLon = geoLocation.getLatlon();
            point.resetLat(latLon.getLat());
            point.resetLon(latLon.getLon());
        } else if (geoLocation.hasCoords()) {
            DoubleArray doubleArray = geoLocation.getCoords();
            int count = doubleArray.getDoubleArrayCount();
            if (count < 2) {
                throw new IllegalArgumentException("[geo_point] field type should have at least two dimensions");
            }
            if (count > 3) {
                throw new IllegalArgumentException("[geo_point] field type does not accept more than 3 values");
            }
            double lon = doubleArray.getDoubleArray(0);
            double lat = doubleArray.getDoubleArray(1);
            point.resetLat(lat);
            point.resetLon(lon);
            if (count == 3 && !ignoreZValue) {
                GeoPoint.assertZValue((boolean)ignoreZValue, (double)doubleArray.getDoubleArray(2));
            }
        } else if (geoLocation.hasText()) {
            String val = geoLocation.getText();
            point.resetFromString(val, ignoreZValue, effectivePoint);
        } else if (geoLocation.hasGeohash()) {
            GeoHashLocation geohashLocation = geoLocation.getGeohash();
            point.resetFromGeoHash(geohashLocation.getGeohash());
        } else {
            throw new IllegalArgumentException("geo_point expected");
        }
        return point;
    }
}

