/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

public class IracUpdateVersionCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 32;
    private final ByteString cacheName;
    private Map<Integer, IracEntryVersion> versions;

    public IracUpdateVersionCommand() {
        this(null);
    }

    public IracUpdateVersionCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracUpdateVersionCommand(ByteString cacheName, Map<Integer, IracEntryVersion> segmentsVersion) {
        this(cacheName);
        this.versions = segmentsVersion;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        IracVersionGenerator versionGenerator = registry.getIracVersionGenerator().running();
        this.versions.forEach(versionGenerator::updateVersion);
        return CompletableFutures.completedNull();
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public byte getCommandId() {
        return 32;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallMap(this.versions, DataOutput::writeInt, ObjectOutput::writeObject, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.versions = MarshallUtil.unmarshallMap((ObjectInput)input, DataInput::readInt, IracUpdateVersionCommand::read, HashMap::new);
    }

    private static IracEntryVersion read(ObjectInput input) throws IOException, ClassNotFoundException {
        return (IracEntryVersion)input.readObject();
    }

    public String toString() {
        return "IracUpdateVersionCommand{cacheName=" + String.valueOf(this.cacheName) + ", versions=" + String.valueOf(this.versions) + "}";
    }
}

