/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.sql.Connection;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public abstract class AbstractDelegatingSessionBuilder
implements SessionBuilder {
    private final SessionBuilder delegate;

    public AbstractDelegatingSessionBuilder(SessionBuilder delegate) {
        this.delegate = delegate;
    }

    protected SessionBuilder getThis() {
        return this;
    }

    protected SessionBuilder delegate() {
        return this.delegate;
    }

    @Override
    public Session openSession() {
        return this.delegate.openSession();
    }

    @Override
    public SessionBuilder interceptor(Interceptor interceptor) {
        this.delegate.interceptor(interceptor);
        return this;
    }

    @Override
    public SessionBuilder noInterceptor() {
        this.delegate.noInterceptor();
        return this;
    }

    @Override
    @Deprecated
    public SessionBuilder statementInspector(StatementInspector statementInspector) {
        this.delegate.statementInspector(statementInspector);
        return this;
    }

    @Override
    public SessionBuilder statementInspector(UnaryOperator<String> operator) {
        this.delegate.statementInspector(operator);
        return this;
    }

    @Override
    public SessionBuilder connection(Connection connection) {
        this.delegate.connection(connection);
        return this;
    }

    @Override
    public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.delegate.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    @Override
    public SessionBuilder autoClose(boolean autoClose) {
        this.delegate.autoClose(autoClose);
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public SessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.delegate.tenantIdentifier(tenantIdentifier);
        return this;
    }

    @Override
    public SessionBuilder tenantIdentifier(Object tenantIdentifier) {
        this.delegate.tenantIdentifier(tenantIdentifier);
        return this;
    }

    @Override
    public SessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.delegate.eventListeners(listeners);
        return this;
    }

    @Override
    public SessionBuilder clearEventListeners() {
        this.delegate.clearEventListeners();
        return this;
    }

    @Override
    public SessionBuilder jdbcTimeZone(TimeZone timeZone) {
        this.delegate.jdbcTimeZone(timeZone);
        return this;
    }

    @Override
    @Deprecated
    public SessionBuilder connectionHandlingMode(PhysicalConnectionHandlingMode mode) {
        this.delegate.connectionHandlingMode(mode);
        return this;
    }

    @Override
    public SessionBuilder connectionHandling(ConnectionAcquisitionMode acquisitionMode, ConnectionReleaseMode releaseMode) {
        this.delegate.connectionHandling(acquisitionMode, releaseMode);
        return this;
    }

    @Override
    public SessionBuilder autoClear(boolean autoClear) {
        this.delegate.autoClear(autoClear);
        return this;
    }

    @Override
    public SessionBuilder flushMode(FlushMode flushMode) {
        this.delegate.flushMode(flushMode);
        return this;
    }

    @Override
    public SessionBuilder identifierRollback(boolean identifierRollback) {
        this.delegate.identifierRollback(identifierRollback);
        return this;
    }
}

