/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.util.Consumer;
import com.intellij.util.io.URLUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextSplitter
extends BaseSplitter {
    private static final PlainTextSplitter INSTANCE = new PlainTextSplitter();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(\\s|\b|\\(|\\))");
    private static final Pattern MAIL = Pattern.compile("([\\p{L}0-9\\.\\-\\_\\+]+@([\\p{L}0-9\\-\\_]+(\\.)?)+(com|net|[a-z]{2})?)");
    private static final Pattern JVM_KEY_PATTERN = Pattern.compile("(-[DJPX]\\w+(\\.\\w+)*.*|-[DJPX])");
    private static final int UUID_V4_HEX_STRING_LENGTH = 36;
    private static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}(-[a-fA-F0-9]{4}){3}-[a-fA-F0-9]{12}");
    private static final int MD5_HEX_LENGTH = 32;
    private static final int SHA1_HEX_LENGTH = 40;
    private static final int SHA256_HEX_LENGTH = 64;
    private static final int SHA512_HEX_LENGTH = 128;
    private static final String HEX_SYMBOLS = "[0-9A-Fa-f]";
    private static final Pattern MD5_HEX_PATTERN = Pattern.compile("[0-9A-Fa-f]{32}");
    private static final Pattern SHA1_HEX_PATTERN = Pattern.compile("[0-9A-Fa-f]{40}");
    private static final Pattern SHA256_HEX_PATTERN = Pattern.compile("[0-9A-Fa-f]{64}");
    private static final Pattern SHA512_HEX_PATTERN = Pattern.compile("[0-9A-Fa-f]{128}");
    private static final int SHA384_BASE64_LENGTH = 64;
    private static final String SHA384_PREFIX = "sha384-";
    private static final Pattern SHA384_PREFIXED_VALUE_PATTERN = Pattern.compile("sha384-[A-Za-z0-9+=/]{64}");
    private static final int SHA512_BASE64_LENGTH = 88;
    private static final String SHA512_PREFIX = "sha512-";
    private static final Pattern SHA512_PREFIXED_VALUE_PATTERN = Pattern.compile("sha512-[A-Za-z0-9+=/]{88}");
    private static final String JWT_COMMON_PREFIX = "eyJhbGci";
    private static final Pattern JWT_PATTERN = Pattern.compile("[A-Za-z0-9+=/_\\-.]+");

    public static PlainTextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            PlainTextSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PlainTextSplitter.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        Splitter ws = this.getTextSplitter();
        int from = range.getStartOffset();
        try {
            String substring = range.substring(text).replace('\b', '\n').replace('\f', '\n');
            if (Verifier.checkCharacterData((String)SPLIT_PATTERN.matcher(PlainTextSplitter.newBombedCharSequence(substring)).replaceAll("")) != null) {
                return;
            }
            Matcher matcher = SPLIT_PATTERN.matcher(PlainTextSplitter.newBombedCharSequence(text, range));
            while (true) {
                String word;
                TextRange wRange;
                ProgressManager.checkCanceled();
                if (matcher.find()) {
                    TextRange found = PlainTextSplitter.matcherRange(range, matcher);
                    int till = found.getStartOffset();
                    if (PlainTextSplitter.badSize(from, till)) {
                        from = found.getEndOffset();
                        continue;
                    }
                    wRange = new TextRange(from, till);
                    word = wRange.substring(text);
                    from = found.getEndOffset();
                } else {
                    wRange = new TextRange(from, range.getEndOffset());
                    word = wRange.substring(text);
                }
                int wordLength = word.length();
                List<Object> toCheck = word.contains("@") ? PlainTextSplitter.excludeByPattern(text, wRange, MAIL, 0) : (word.contains("://") ? PlainTextSplitter.excludeByPattern(text, wRange, URLUtil.URL_PATTERN, 0) : (word.startsWith(JWT_COMMON_PREFIX) && JWT_PATTERN.matcher(word).matches() ? Collections.emptyList() : (PlainTextSplitter.startsWithAny(word, "-D", "-J", "-P", "-X") ? PlainTextSplitter.excludeByPattern(text, wRange, JVM_KEY_PATTERN, 0) : (word.startsWith("f'") ? List.of(new TextRange(wRange.getStartOffset() + 2, wRange.getEndOffset())) : (wordLength == 32 && MD5_HEX_PATTERN.matcher(word).matches() || wordLength == 40 && SHA1_HEX_PATTERN.matcher(word).matches() || wordLength == 64 && SHA256_HEX_PATTERN.matcher(word).matches() || wordLength == 128 && SHA512_HEX_PATTERN.matcher(word).matches() ? Collections.emptyList() : (wordLength == 36 && UUID_PATTERN.matcher(word).matches() ? Collections.emptyList() : (PlainTextSplitter.isHashPrefixed(word, SHA384_PREFIX, 64) && SHA384_PREFIXED_VALUE_PATTERN.matcher(word).matches() || PlainTextSplitter.isHashPrefixed(word, SHA512_PREFIX, 88) && SHA512_PREFIXED_VALUE_PATTERN.matcher(word).matches() ? Collections.emptyList() : Collections.singletonList(wRange))))))));
                for (TextRange r : toCheck) {
                    ws.split(text, r, consumer);
                }
                if (matcher.hitEnd()) break;
            }
        }
        catch (BaseSplitter.TooLongBombedMatchingException tooLongBombedMatchingException) {
            // empty catch block
        }
    }

    private static boolean startsWithAny(String word, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!word.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Splitter getTextSplitter() {
        TextSplitter textSplitter = TextSplitter.getInstance();
        if (textSplitter == null) {
            PlainTextSplitter.$$$reportNull$$$0(2);
        }
        return textSplitter;
    }

    private static boolean isHashPrefixed(String text, String hashPrefix, int expectedHashSize) {
        return text.length() == expectedHashSize + hashPrefix.length() && text.startsWith(hashPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/PlainTextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/PlainTextSplitter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

