/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DefaultFilesToSendProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.FilesToSendProvider;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalSendConfig
implements EventLogSendConfig {
    private final String myRecorderId;
    private final String myDeviceId;
    private final int myBucket;
    private final MachineId myMachineId;
    private final boolean myFilterActiveFile;

    private EventLogInternalSendConfig(@NotNull String recorderId, @NotNull EventLogRecorderConfiguration config, boolean filterActiveFile) {
        if (recorderId == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(0);
        }
        if (config == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(1);
        }
        this.myRecorderId = recorderId;
        this.myDeviceId = config.getDeviceId();
        this.myBucket = config.getBucket();
        this.myMachineId = config.getMachineId();
        this.myFilterActiveFile = filterActiveFile;
    }

    @NotNull
    public static EventLogInternalSendConfig createByRecorder(@NotNull String recorderId, boolean filterActiveFile) {
        if (recorderId == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(2);
        }
        EventLogRecorderConfiguration config = EventLogConfiguration.getInstance().getOrCreate(recorderId);
        return new EventLogInternalSendConfig(recorderId, config, filterActiveFile);
    }

    @Override
    @NotNull
    public String getDeviceId() {
        String string = this.myDeviceId;
        if (string == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public int getBucket() {
        return this.myBucket;
    }

    @Override
    @NotNull
    public MachineId getMachineId() {
        MachineId machineId = this.myMachineId;
        if (machineId == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(4);
        }
        return machineId;
    }

    @Override
    @NotNull
    public String getRecorderId() {
        String string = this.myRecorderId;
        if (string == null) {
            EventLogInternalSendConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isSendEnabled() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).isSendEnabled();
    }

    @Override
    public boolean isEscapingEnabled() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).isCharsEscapingRequired();
    }

    @Override
    @NotNull
    public FilesToSendProvider getFilesToSendProvider() {
        int maxFilesToSend = EventLogConfiguration.getInstance().getOrCreate(this.myRecorderId).getMaxFilesToSend();
        return new DefaultFilesToSendProvider(this.myRecorderId, maxFilesToSend, this.myFilterActiveFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogInternalSendConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogInternalSendConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMachineId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecorderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createByRecorder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

