/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.toolkit;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Selectioner {
    public List<TextRange> calcExtendSelectionRanges(Tree tree, int startOffset, int endOffset) {
        Node node = tree.findNodeAt(startOffset);
        if (node == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<TextRange> allRanges = new LinkedHashSet<TextRange>();
        allRanges.add(node.textRange());
        while (node != null) {
            List<TextRange> forHead = this.calcRangesForHead(node);
            forHead.sort(Comparator.comparing(r -> r.end() - r.start()));
            allRanges.addAll(forHead);
            node = node.head();
        }
        TextRange last = new TextRange(startOffset, endOffset);
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (TextRange range : allRanges) {
            if (!range.encloses(last) || range.equals(last)) continue;
            result.add(range);
            last = range;
        }
        return result;
    }

    @NotNull
    protected List<TextRange> calcRangesForHead(Node head) {
        Node last;
        Node afterLast;
        Node phraseStart = head.phraseStart();
        Node phraseEnd = head.phraseEnd();
        if ((phraseStart = phraseStart.skipForward(n -> "punct".equals(n.headRelation()))) == null || phraseStart.isAfter(phraseEnd)) {
            return Collections.emptyList();
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        phraseEnd = phraseEnd.skipBack(n -> "punct".equals(n.headRelation()));
        if (phraseEnd == null || phraseStart.isAfter(phraseEnd)) {
            return result;
        }
        for (Node node : head.findDependents("case|cc|cop")) {
            if (!node.isBefore(head)) continue;
            phraseStart = Objects.requireNonNull(node.nextNode());
            result.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        }
        for (Node node : head.findDependents("flat|appos")) {
            if (!node.isAfter(head)) continue;
            result.add(new TextRange(phraseStart.startOffset(), node.phraseEnd().endOffset()));
        }
        SentenceWithNERAnnotations.Annotation ner = head.nerAnnotation();
        if (ner != null) {
            result.add(new TextRange(ner.getRange().getStart(), ner.getRange().getEndExclusive()));
        }
        for (Node relClause : head.findDependents("acl:relcl|advcl|conj")) {
            Node prev = relClause.phraseStart().prevNode();
            if (prev == null || !prev.isAfter(phraseStart)) continue;
            phraseEnd = prev;
            result.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        }
        List list = head.findDependents("advmod").stream().filter(n -> n.isBefore(head)).collect(Collectors.toList());
        if (!list.isEmpty() && (afterLast = (last = (Node)Iterables.getLast(list)).phraseEnd().nextNode()) != null && afterLast.isBefore(phraseEnd)) {
            result.add(new TextRange(afterLast.startOffset(), phraseEnd.endOffset()));
        }
        return result;
    }
}

