/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared.roots;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleImportHelperKt;
import org.jetbrains.kotlin.gradle.scripting.shared.LastModifiedFiles;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.importing.KotlinDslGradleBuildSync;
import org.jetbrains.kotlin.gradle.scripting.shared.importing.KotlinDslScriptModel;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootData;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootDataSerializer;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleScriptInfo;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Legacy;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.New;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.StandaloneScriptsUpdater;
import org.jetbrains.kotlin.idea.core.script.shared.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 _2\u00020\u0001:\u0003]^_B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000fH&J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH&J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020%J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\u000f2\b\b\u0002\u00105\u001a\u00020,J\u0010\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\u001cH&J\u001c\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00104\u001a\u00020\u000f2\b\u00109\u001a\u0004\u0018\u00010\u000fH\u0004J\u0016\u0010:\u001a\u00020,*\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u001c2\u0006\u0010<\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010=\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u000fH&J\u0010\u0010>\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u000fH\u0004J\u000e\u0010?\u001a\u00020,2\u0006\u0010$\u001a\u00020%J&\u0010@\u001a\u00020\r2\b\b\u0002\u0010A\u001a\u00020,2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020,0CH&J\u0012\u0010D\u001a\u0004\u0018\u00010\u001e2\u0006\u00104\u001a\u00020\u000fH\u0002J\u001a\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u001c2\u0006\u00101\u001a\u000202H\u0002JA\u0010H\u001a\u0004\u0018\u00010F2\u0006\u0010I\u001a\u00020\u000f2\b\b\u0002\u0010J\u001a\u00020K2#\u0010L\u001a\u001f\u0012\u0013\u0012\u00110%\u00a2\u0006\f\bM\u0012\b\bN\u0012\u0004\b\b(O\u0012\u0006\u0012\u0004\u0018\u00010P0CH\u0004J\u0018\u0010Q\u001a\u00020P2\u0006\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020PH\u0002J\u0010\u0010T\u001a\u00020\u00112\u0006\u0010U\u001a\u00020\u000fH\u0016J!\u0010V\u001a\u00020\r2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\r0C\u00a2\u0006\u0002\bXH\u0016J\u0014\u0010Y\u001a\b\u0018\u00010ZR\u00020\u00002\u0006\u0010[\u001a\u00020%J\u001e\u0010Y\u001a\b\u0018\u00010ZR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\\\u001a\u00020,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\f0\u000f\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\b'*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "roots", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootIndex;", "getRoots", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootIndex;", "fileChanged", "", "filePath", "", "ts", "", "modifiedFilesCheckScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "modifiedFiles", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "scheduleModifiedFilesCheck", "checkModifiedFiles", "getScriptInfo", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;", "localPath", "loadLinkedRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "version", "getAllRoots", "", "getBuildRootByWorkingDir", "gradleWorkingDir", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "getLocalPath", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "gradleWrapperEnding", "maybeAffectedGradleProjectFile", "", "isAffectedGradleProjectFile", "findAffectedFileRoot", "findGradleWrapperPropertiesBuildDir", "update", "sync", "Lorg/jetbrains/kotlin/gradle/scripting/shared/importing/KotlinDslGradleBuildSync;", "markImportingInProgress", "workingDir", "inProgress", "add", "newRoot", "actualizeBuildRoot", "gradleVersion", "checkActual", "reloadBuildRoot", "rootPath", "remove", "removeData", "isConfigurationOutOfDate", "updateNotifications", "restartAnalyzer", "shouldUpdatePath", "Lkotlin/Function1;", "getGradleProjectSettings", "updateRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/Imported;", "oldRoot", "tryCreateImportedRoot", "externalProjectPath", "lastModifiedFiles", "Lorg/jetbrains/kotlin/gradle/scripting/shared/LastModifiedFiles;", "dataProvider", "Lkotlin/ParameterName;", "name", "buildRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "merge", "old", "new", "getScriptFirstSeenTs", "path", "updateStandaloneScripts", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/StandaloneScriptsUpdater;", "Lkotlin/ExtensionFunctionType;", "findScriptBuildRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "gradleKtsFile", "searchNearestLegacy", "NotificationKind", "ScriptUnderRoot", "Companion", "kotlin.gradle.scripting.shared"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1869#2,2:396\n1236#2,4:399\n1236#2,4:403\n1#3:398\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator\n*L\n56#1:396,2\n275#1:399,4\n276#1:403,4\n*E\n"})
public abstract class GradleBuildRootsLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final GradleBuildRootIndex roots;
    @NotNull
    private final AtomicBoolean modifiedFilesCheckScheduled;
    @NotNull
    private final ConcurrentLinkedQueue<String> modifiedFiles;
    @NotNull
    private final String gradleWrapperEnding;

    public GradleBuildRootsLocator(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.roots = new GradleBuildRootIndex(this.project);
        this.modifiedFilesCheckScheduled = new AtomicBoolean();
        this.modifiedFiles = new ConcurrentLinkedQueue();
        this.gradleWrapperEnding = "/gradle/wrapper/gradle-wrapper.properties";
    }

    @NotNull
    public final GradleBuildRootIndex getRoots() {
        return this.roots;
    }

    public final void fileChanged(@NotNull String filePath, long ts) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GradleBuildRoot gradleBuildRoot = this.findAffectedFileRoot(filePath);
        if (gradleBuildRoot != null) {
            gradleBuildRoot.fileChanged(filePath, ts);
        }
        this.scheduleModifiedFilesCheck(filePath);
    }

    public static /* synthetic */ void fileChanged$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fileChanged");
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        gradleBuildRootsLocator.fileChanged(string, l);
    }

    private final void scheduleModifiedFilesCheck(String filePath) {
        this.modifiedFiles.add(filePath);
        if (this.modifiedFilesCheckScheduled.compareAndSet(false, true)) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ GradleBuildRootsLocator this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (GradleBuildRootsLocator.access$getModifiedFilesCheckScheduled$p(this.this$0).compareAndSet(true, false)) {
                                GradleBuildRootsLocator.access$checkModifiedFiles(this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void checkModifiedFiles() {
        this.updateNotifications(false, (Function1<? super String, Boolean>)((Function1)GradleBuildRootsLocator::checkModifiedFiles$lambda$0));
        Iterable $this$forEach$iv = this.roots.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot it = (GradleBuildRoot)element$iv;
            boolean bl = false;
            it.saveLastModifiedFiles();
        }
        while (this.modifiedFiles.poll() != null) {
            String file;
            String buildDir = this.findGradleWrapperPropertiesBuildDir(file);
            if (buildDir == null) continue;
            this.actualizeBuildRoot(buildDir, null);
        }
    }

    @Nullable
    public abstract GradleScriptInfo getScriptInfo(@NotNull String var1);

    @NotNull
    public abstract GradleBuildRoot loadLinkedRoot(@NotNull GradleProjectSettings var1, @NotNull String var2);

    @NotNull
    public final Collection<GradleBuildRoot> getAllRoots() {
        return this.roots.getList();
    }

    @Nullable
    public final GradleBuildRoot getBuildRootByWorkingDir(@NotNull String gradleWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)gradleWorkingDir, (String)"gradleWorkingDir");
        return this.roots.getBuildByRootDir(gradleWorkingDir);
    }

    @Nullable
    public final GradleScriptInfo getScriptInfo(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getScriptInfo(this.getLocalPath(file));
    }

    private final String getLocalPath(VirtualFile $this$localPath) {
        String string = $this$localPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public final boolean maybeAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    public final boolean isAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.findAffectedFileRoot(filePath) != null || this.roots.isStandaloneScript(filePath);
    }

    @Nullable
    public final GradleBuildRoot findAffectedFileRoot(@NotNull String filePath) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                if (StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null)) {
                    return this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null));
                }
                object = this.findGradleWrapperPropertiesBuildDir(filePath);
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                GradleBuildRoot gradleBuildRoot = this.roots.getBuildByRootDir(it);
                object = gradleBuildRoot;
                if (gradleBuildRoot != null) break block5;
            }
            ScriptUnderRoot scriptUnderRoot = this.findScriptBuildRoot(filePath, false);
            object = scriptUnderRoot != null ? scriptUnderRoot.getRoot() : null;
        }
        return object;
    }

    @Nullable
    public final String findGradleWrapperPropertiesBuildDir(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null)) {
            String string = filePath.substring(0, filePath.length() - this.gradleWrapperEnding.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    public final void update(@NotNull KotlinDslGradleBuildSync sync) {
        Intrinsics.checkNotNullParameter((Object)sync, (String)"sync");
        GradleBuildRoot gradleBuildRoot = this.actualizeBuildRoot(sync.getWorkingDir(), sync.getGradleVersion());
        if (gradleBuildRoot == null) {
            return;
        }
        GradleBuildRoot oldRoot = gradleBuildRoot;
        try {
            Imported newRoot = this.updateRoot(oldRoot, sync);
            if (newRoot == null) {
                this.markImportingInProgress(sync.getWorkingDir(), false);
                return;
            }
            this.add(newRoot);
        }
        catch (Exception e) {
            this.markImportingInProgress(sync.getWorkingDir(), false);
            ScriptingLoggerKt.scriptingErrorLog("Couldn't update Gradle build root: " + oldRoot.getPathPrefix(), e);
            return;
        }
    }

    public final void markImportingInProgress(@NotNull String workingDir, boolean inProgress) {
        AtomicReference<GradleBuildRoot.ImportingStatus> atomicReference;
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        GradleBuildRoot gradleBuildRoot = this.actualizeBuildRoot(workingDir, null);
        if (gradleBuildRoot != null && (atomicReference = gradleBuildRoot.getImporting()) != null) {
            atomicReference.set(inProgress ? GradleBuildRoot.ImportingStatus.importing : GradleBuildRoot.ImportingStatus.updated);
        }
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocator.markImportingInProgress$lambda$0(workingDir, arg_0), 1, null);
    }

    public static /* synthetic */ void markImportingInProgress$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: markImportingInProgress");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        gradleBuildRootsLocator.markImportingInProgress(string, bl);
    }

    public abstract void add(@NotNull GradleBuildRoot var1);

    @Nullable
    protected final GradleBuildRoot actualizeBuildRoot(@NotNull String workingDir, @Nullable String gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        GradleProjectSettings actualSettings = this.getGradleProjectSettings(workingDir);
        GradleBuildRoot buildRoot = this.getBuildRootByWorkingDir(workingDir);
        String string = gradleVersion;
        if (string == null) {
            GradleProjectSettings gradleProjectSettings = actualSettings;
            if (gradleProjectSettings != null) {
                GradleProjectSettings it = gradleProjectSettings;
                boolean bl = false;
                string = GradleImportHelperKt.getGradleVersion(this.project, it);
            } else {
                string = null;
            }
        }
        String version = string;
        return buildRoot != null ? (!this.checkActual(buildRoot, version) ? this.reloadBuildRoot(workingDir, version) : buildRoot) : (actualSettings != null && version != null ? this.loadLinkedRoot(actualSettings, version) : null);
    }

    private final boolean checkActual(GradleBuildRoot $this$checkActual, String version) {
        if (version == null) {
            return false;
        }
        boolean knownAsSupported = !($this$checkActual instanceof Legacy);
        boolean shouldBeSupported = UtilsKt.kotlinDslScriptsModelImportSupported(version);
        return knownAsSupported == shouldBeSupported;
    }

    @Nullable
    public final GradleBuildRoot reloadBuildRoot(@NotNull String rootPath, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        GradleProjectSettings settings2 = this.getGradleProjectSettings(rootPath);
        if (settings2 == null) {
            this.remove(rootPath);
            return null;
        }
        String string = version;
        if (string == null) {
            string = GradleImportHelperKt.getGradleVersion(this.project, settings2);
        }
        String gradleVersion = string;
        GradleBuildRoot newRoot = this.loadLinkedRoot(settings2, gradleVersion);
        this.add(newRoot);
        return newRoot;
    }

    public abstract void remove(@NotNull String var1);

    protected final void removeData(@NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        VirtualFile buildRoot = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (buildRoot != null) {
            GradleBuildRootDataSerializer.Companion.getInstance().remove(buildRoot);
            LastModifiedFiles.Companion.remove(buildRoot);
        }
    }

    public final boolean isConfigurationOutOfDate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GradleScriptInfo gradleScriptInfo = this.getScriptInfo(file);
        if (gradleScriptInfo == null) {
            return false;
        }
        GradleScriptInfo script = gradleScriptInfo;
        if (script.getBuildRoot().isImportingInProgress()) {
            return false;
        }
        return !CachedConfigurationInputs.isUpToDate$default(script.getModel().getInputs(), this.project, file, null, 4, null);
    }

    public abstract void updateNotifications(boolean var1, @NotNull Function1<? super String, Boolean> var2);

    public static /* synthetic */ void updateNotifications$default(GradleBuildRootsLocator gradleBuildRootsLocator, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateNotifications");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        gradleBuildRootsLocator.updateNotifications(bl, (Function1<? super String, Boolean>)function1);
    }

    private final GradleProjectSettings getGradleProjectSettings(String workingDir) {
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)abstractExternalSystemSettings, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.settings.GradleSettings");
        return (GradleProjectSettings)((GradleSettings)abstractExternalSystemSettings).getLinkedProjectSettings(workingDir);
    }

    private final Imported updateRoot(GradleBuildRoot oldRoot, KotlinDslGradleBuildSync sync) {
        if (sync.getModels().isEmpty() && oldRoot instanceof Imported && ((Imported)oldRoot).getData().getModels().isEmpty()) {
            return null;
        }
        if (oldRoot instanceof Legacy) {
            return null;
        }
        ScriptingLoggerKt.scriptingDebugLog$default(null, () -> GradleBuildRootsLocator.updateRoot$lambda$0(sync), 1, null);
        String gradleHome = sync.getGradleHome();
        if (gradleHome == null) {
            ScriptingLoggerKt.scriptingInfoLog("Cannot find valid gradle home with version = " + sync.getGradleVersion() + ", script models cannot be saved");
            return null;
        }
        oldRoot.getImporting().set(GradleBuildRoot.ImportingStatus.updatingCaches);
        ScriptingLoggerKt.scriptingDebugLog$default(null, () -> GradleBuildRootsLocator.updateRoot$lambda$1(sync), 1, null);
        GradleBuildRootData newData = new GradleBuildRootData(sync.getCreationTimestamp(), (Collection<String>)sync.getProjectRoots(), gradleHome, sync.getJavaHome(), (Collection<KotlinDslScriptModel>)sync.getModels());
        GradleBuildRootData mergedData = sync.getFailed() && oldRoot instanceof Imported ? this.merge(((Imported)oldRoot).getData(), newData) : newData;
        Imported imported = this.tryCreateImportedRoot(sync.getWorkingDir(), new LastModifiedFiles(null, null, 3, null), (Function1<? super VirtualFile, GradleBuildRootData>)((Function1)arg_0 -> GradleBuildRootsLocator.updateRoot$lambda$2(mergedData, arg_0)));
        if (imported == null) {
            return null;
        }
        Imported newRoot = imported;
        VirtualFile virtualFile = newRoot.getDir();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile buildRootDir = virtualFile;
        GradleBuildRootDataSerializer.Companion.getInstance().write(buildRootDir, mergedData);
        newRoot.saveLastModifiedFiles();
        return newRoot;
    }

    @Nullable
    protected final Imported tryCreateImportedRoot(@NotNull String externalProjectPath, @NotNull LastModifiedFiles lastModifiedFiles, @NotNull Function1<? super VirtualFile, GradleBuildRootData> dataProvider) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)lastModifiedFiles, (String)"lastModifiedFiles");
        Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
        try {
            VirtualFile virtualFile = VfsUtil.findFile((Path)Paths.get(externalProjectPath, new String[0]), (boolean)true);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile buildRoot = virtualFile;
            GradleBuildRootData gradleBuildRootData = (GradleBuildRootData)dataProvider.invoke((Object)buildRoot);
            if (gradleBuildRootData == null) {
                return null;
            }
            GradleBuildRootData data = gradleBuildRootData;
            return new Imported(externalProjectPath, data, lastModifiedFiles);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            ScriptingLoggerKt.scriptingErrorLog("Cannot load script configurations from file attributes for " + externalProjectPath, e);
            return null;
        }
    }

    public static /* synthetic */ Imported tryCreateImportedRoot$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, LastModifiedFiles lastModifiedFiles, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryCreateImportedRoot");
        }
        if ((n & 2) != 0) {
            LastModifiedFiles lastModifiedFiles2 = GradleBuildRootKt.loadLastModifiedFiles(string);
            if (lastModifiedFiles2 == null) {
                lastModifiedFiles2 = new LastModifiedFiles(null, null, 3, null);
            }
            lastModifiedFiles = lastModifiedFiles2;
        }
        return gradleBuildRootsLocator.tryCreateImportedRoot(string, lastModifiedFiles, (Function1<? super VirtualFile, GradleBuildRootData>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final GradleBuildRootData merge(GradleBuildRootData old, GradleBuildRootData gradleBuildRootData) {
        KotlinDslScriptModel it;
        void var12_11;
        void destination$iv;
        Iterable $this$associateByTo$iv;
        Set roots = CollectionsKt.toMutableSet((Iterable)old.getProjectRoots());
        roots.addAll(gradleBuildRootData.getProjectRoots());
        Iterable iterable = old.getModels();
        Map map2 = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            KotlinDslScriptModel kotlinDslScriptModel = (KotlinDslScriptModel)element$iv;
            var12_11 = destination$iv;
            boolean bl = false;
            var12_11.put(it.getFile(), element$iv);
        }
        void models = destination$iv;
        $this$associateByTo$iv = gradleBuildRootData.getModels();
        destination$iv = models;
        $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            it = (KotlinDslScriptModel)element$iv;
            var12_11 = destination$iv;
            boolean bl = false;
            var12_11.put(it.getFile(), element$iv);
        }
        return new GradleBuildRootData(gradleBuildRootData.getImportTs(), roots, gradleBuildRootData.getGradleHome(), gradleBuildRootData.getJavaHome(), models.values());
    }

    public long getScriptFirstSeenTs(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path nioPath = FileSystems.getDefault().getPath(path2, new String[0]);
        FileTime fileTime = Files.readAttributes(nioPath, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        return fileTime != null ? fileTime.toMillis() : Long.MAX_VALUE;
    }

    public void updateStandaloneScripts(@NotNull Function1<? super StandaloneScriptsUpdater, Unit> update2) {
        Intrinsics.checkNotNullParameter(update2, (String)"update");
    }

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull VirtualFile gradleKtsFile) {
        Intrinsics.checkNotNullParameter((Object)gradleKtsFile, (String)"gradleKtsFile");
        String string = gradleKtsFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return GradleBuildRootsLocator.findScriptBuildRoot$default(this, string, false, 2, null);
    }

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull String filePath, boolean searchNearestLegacy) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.project.isDisposed()) {
            return null;
        }
        if (!StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null)) {
            return null;
        }
        GradleScriptInfo scriptInfo = this.getScriptInfo(filePath);
        if (scriptInfo != null && (gradleBuildRoot = scriptInfo.getBuildRoot()) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, scriptInfo, false, null, 24, null);
        }
        gradleBuildRoot = this.roots.getStandaloneScriptRoot(filePath);
        if (gradleBuildRoot != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, null, true, null, 20, null);
        }
        if ((StringsKt.endsWith$default((String)filePath, (String)"/build.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/settings.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/init.gradle.kts", (boolean)false, (int)2, null)) && (gradleBuildRoot = this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null))) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, null, false, null, 28, null);
        }
        GradleBuildRoot nearest = searchNearestLegacy ? this.roots.findNearestRoot(filePath) : null;
        return new ScriptUnderRoot(this, filePath, null, null, false, nearest, 12, null);
    }

    public static /* synthetic */ ScriptUnderRoot findScriptBuildRoot$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findScriptBuildRoot");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleBuildRootsLocator.findScriptBuildRoot(string, bl);
    }

    private static final boolean checkModifiedFiles$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean markImportingInProgress$lambda$0(String $workingDir, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$workingDir, (boolean)false, (int)2, null);
    }

    private static final String updateRoot$lambda$0(KotlinDslGradleBuildSync $sync) {
        return "gradle project info after import: " + $sync;
    }

    private static final String updateRoot$lambda$1(KotlinDslGradleBuildSync $sync) {
        return "save script models after import: " + $sync.getModels();
    }

    private static final GradleBuildRootData updateRoot$lambda$2(GradleBuildRootData $mergedData, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $mergedData;
    }

    @JvmStatic
    @NotNull
    public static final GradleBuildRootsLocator getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ AtomicBoolean access$getModifiedFilesCheckScheduled$p(GradleBuildRootsLocator $this) {
        return $this.modifiedFilesCheckScheduled;
    }

    public static final /* synthetic */ void access$checkModifiedFiles(GradleBuildRootsLocator $this) {
        $this.checkModifiedFiles();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.gradle.scripting.shared"})
    @SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,395:1\n30#2,2:396\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$Companion\n*L\n393#1:396,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleBuildRootsLocator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GradleBuildRootsLocator> serviceClass$iv = GradleBuildRootsLocator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GradleBuildRootsLocator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$NotificationKind;", "", "<init>", "(Ljava/lang/String;I)V", "dontCare", "legacy", "legacyOutside", "outsideAnything", "wasNotImportedAfterCreation", "notEvaluatedInLastImport", "standalone", "standaloneLegacy", "kotlin.gradle.scripting.shared"})
    public static final class NotificationKind
    extends Enum<NotificationKind> {
        public static final /* enum */ NotificationKind dontCare = new NotificationKind();
        public static final /* enum */ NotificationKind legacy = new NotificationKind();
        public static final /* enum */ NotificationKind legacyOutside = new NotificationKind();
        public static final /* enum */ NotificationKind outsideAnything = new NotificationKind();
        public static final /* enum */ NotificationKind wasNotImportedAfterCreation = new NotificationKind();
        public static final /* enum */ NotificationKind notEvaluatedInLastImport = new NotificationKind();
        public static final /* enum */ NotificationKind standalone = new NotificationKind();
        public static final /* enum */ NotificationKind standaloneLegacy = new NotificationKind();
        private static final /* synthetic */ NotificationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NotificationKind[] values() {
            return (NotificationKind[])$VALUES.clone();
        }

        public static NotificationKind valueOf(String value) {
            return Enum.valueOf(NotificationKind.class, value);
        }

        @NotNull
        public static EnumEntries<NotificationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = notificationKindArray = new NotificationKind[]{NotificationKind.dontCare, NotificationKind.legacy, NotificationKind.legacyOutside, NotificationKind.outsideAnything, NotificationKind.wasNotImportedAfterCreation, NotificationKind.notEvaluatedInLastImport, NotificationKind.standalone, NotificationKind.standaloneLegacy};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0014\u0010\u001c\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "", "filePath", "", "root", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "script", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;", "standalone", "", "nearest", "<init>", "(Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;ZLorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;)V", "getFilePath", "()Ljava/lang/String;", "getRoot", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "getScript", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;", "getStandalone", "()Z", "getNearest", "notificationKind", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$NotificationKind;", "getNotificationKind", "()Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$NotificationKind;", "importing", "getImporting", "isImported", "wasImportedAndNotEvaluated", "getWasImportedAndNotEvaluated", "toString", "kotlin.gradle.scripting.shared"})
    public final class ScriptUnderRoot {
        @NotNull
        private final String filePath;
        @Nullable
        private final GradleBuildRoot root;
        @Nullable
        private final GradleScriptInfo script;
        private final boolean standalone;
        @Nullable
        private final GradleBuildRoot nearest;
        final /* synthetic */ GradleBuildRootsLocator this$0;

        public ScriptUnderRoot(@NotNull GradleBuildRootsLocator this$0, @Nullable String filePath, @Nullable GradleBuildRoot root, GradleScriptInfo script, @Nullable boolean standalone, GradleBuildRoot nearest) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.this$0 = this$0;
            this.filePath = filePath;
            this.root = root;
            this.script = script;
            this.standalone = standalone;
            this.nearest = nearest;
        }

        public /* synthetic */ ScriptUnderRoot(GradleBuildRootsLocator gradleBuildRootsLocator, String string, GradleBuildRoot gradleBuildRoot, GradleScriptInfo gradleScriptInfo, boolean bl, GradleBuildRoot gradleBuildRoot2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                gradleScriptInfo = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                gradleBuildRoot2 = gradleBuildRoot;
            }
            this(gradleBuildRootsLocator, string, gradleBuildRoot, gradleScriptInfo, bl, gradleBuildRoot2);
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final GradleBuildRoot getRoot() {
            return this.root;
        }

        @Nullable
        public final GradleScriptInfo getScript() {
            return this.script;
        }

        public final boolean getStandalone() {
            return this.standalone;
        }

        @Nullable
        public final GradleBuildRoot getNearest() {
            return this.nearest;
        }

        @NotNull
        public final NotificationKind getNotificationKind() {
            NotificationKind notificationKind;
            if (this.isImported()) {
                notificationKind = NotificationKind.dontCare;
            } else if (this.standalone) {
                notificationKind = this.nearest instanceof Legacy ? NotificationKind.standaloneLegacy : NotificationKind.standalone;
            } else if (this.nearest == null) {
                notificationKind = NotificationKind.outsideAnything;
            } else if (this.getImporting()) {
                notificationKind = NotificationKind.dontCare;
            } else {
                GradleBuildRoot gradleBuildRoot = this.nearest;
                if (gradleBuildRoot instanceof Legacy) {
                    notificationKind = this.root == null ? NotificationKind.legacyOutside : NotificationKind.legacy;
                } else if (gradleBuildRoot instanceof New) {
                    notificationKind = NotificationKind.wasNotImportedAfterCreation;
                } else if (gradleBuildRoot instanceof Imported) {
                    notificationKind = this.getWasImportedAndNotEvaluated() ? NotificationKind.notEvaluatedInLastImport : NotificationKind.wasNotImportedAfterCreation;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return notificationKind;
        }

        private final boolean getImporting() {
            return this.nearest != null && this.nearest.isImportingInProgress();
        }

        private final boolean isImported() {
            return this.script != null;
        }

        private final boolean getWasImportedAndNotEvaluated() {
            return this.nearest instanceof Imported && this.this$0.getScriptFirstSeenTs(this.filePath) < ((Imported)this.nearest).getData().getImportTs();
        }

        @NotNull
        public String toString() {
            return "ScriptUnderRoot(root=" + this.root + ", script=" + this.script + ", standalone=" + this.standalone + ", nearest=" + this.nearest + ")";
        }
    }
}

