/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaSamConstructorNullabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n+ 2 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n291#2:73\n282#2,11:74\n71#3,4:85\n1#4:89\n*S KotlinDebug\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n*L\n37#1:73\n37#1:74,11\n39#1:85,4\n*E\n"})
public final class FirJavaSamConstructorNullabilityChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJavaSamConstructorNullabilityChecker INSTANCE = new FirJavaSamConstructorNullabilityChecker();

    private FirJavaSamConstructorNullabilityChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        boolean reportError = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ProhibitReturningIncorrectNullabilityValuesFromSamConstructorLambdaOfJdkInterfaces);
        FirNamedReference calleeReference = expression.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            return;
        }
        FirFunctionSymbol firFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(calleeReference, false, 1, null);
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol symbol = firFunctionSymbol;
        if (!Intrinsics.areEqual((Object)symbol.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, symbol.getResolvedReturnType());
        if (firRegularClassSymbol == null) return;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = firRegularClassSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement22 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object $i$f$isJavaOrEnhancement22 = $this$isJavaOrEnhancement$iv.getFir();
            if (!($i$f$isJavaOrEnhancement22 instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)$i$f$isJavaOrEnhancement22;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) return;
        boolean bl2 = true;
        if (!bl2) {
            return;
        }
        FirCall $this$resolvedArgumentMapping$iv = expression;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        if (!(argumentList$iv instanceof FirResolvedArgumentList)) return;
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = ((FirResolvedArgumentList)argumentList$iv).getMapping();
        Object object = linkedHashMap;
        if (linkedHashMap == null) return;
        Set<Map.Entry<FirExpression, FirValueParameter>> set = ((LinkedHashMap)object).entrySet();
        object = set;
        if (set == null) return;
        if ((object = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) {
            return;
        }
        Object object2 = object;
        Object k = object2.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        FirExpression lambda2 = (FirExpression)k;
        Object v = object2.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        FirValueParameter parameter = (FirValueParameter)v;
        if (!(lambda2 instanceof FirAnonymousFunctionExpression)) {
            return;
        }
        ConeKotlinType parameterFunctionType = FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        ConeSubstitutor substitutor2 = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default(expression, symbol, context2.getSession(), false, true, 4, null);
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.lastOrNull((Object[])parameterFunctionType.getTypeArguments());
        ConeTypeProjection coneTypeProjection2 = coneTypeProjection;
        if (coneTypeProjection == null) return;
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(coneTypeProjection2);
        coneTypeProjection2 = coneKotlinType;
        if (coneKotlinType == null) return;
        ConeTypeProjection p0 = coneTypeProjection2;
        boolean bl3 = false;
        ConeKotlinType coneKotlinType2 = substitutor2.substituteOrSelf((ConeKotlinType)p0);
        coneTypeProjection2 = coneKotlinType2;
        if (coneKotlinType2 == null) {
            return;
        }
        ConeTypeProjection expectedReturnType = coneTypeProjection2;
        Iterator<FirExpression> iterator2 = FirHelpersKt.getReturnedExpressions(((FirAnonymousFunctionExpression)lambda2).getAnonymousFunction().getSymbol()).iterator();
        while (iterator2.hasNext()) {
            FirExpression returnedExpression = iterator2.next();
            ConeKotlinType returnedExpressionType = FirTypeUtilsKt.getResolvedType(returnedExpression);
            if (AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)returnedExpressionType, (KotlinTypeMarker)((KotlinTypeMarker)expectedReturnType), (boolean)false, (int)8, null)) continue;
            if (reportError) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)returnedExpression.getSource()), FirErrors.INSTANCE.getARGUMENT_TYPE_MISMATCH(), (Object)returnedExpressionType, (Object)expectedReturnType, (Object)true, null, (int)64, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)returnedExpression.getSource()), FirJvmErrors.INSTANCE.getTYPE_MISMATCH_WHEN_FLEXIBILITY_CHANGES(), (Object)returnedExpressionType, (Object)expectedReturnType, null, (int)32, null);
        }
    }
}

