/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ExternalFunChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class ExternalFunChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof MemberDescriptor) || !((MemberDescriptor)descriptor).isExternal()) {
            return;
        }
        BindingTrace trace = context.getTrace();
        if (!(descriptor instanceof FunctionDescriptor)) {
            String target;
            MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
            String string = target = memberDescriptor instanceof PropertyDescriptor ? "property" : (memberDescriptor instanceof ClassDescriptor ? "class" : "non-function declaration");
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.EXTERNAL_KEYWORD)) != null) {
                KtModifierList it = ktModifierList;
                boolean bl = false;
                trace.report((Diagnostic)Errors.WRONG_MODIFIER_TARGET.on((PsiElement)it, (Object)KtTokens.EXTERNAL_KEYWORD, (Object)target));
            }
            return;
        }
        if (DescriptorUtils.isInterface((DeclarationDescriptor)((FunctionDescriptor)descriptor).getContainingDeclaration())) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_IN_INTERFACE.on((PsiElement)declaration));
        } else if (((FunctionDescriptor)descriptor).getModality() == Modality.ABSTRACT) {
            if (declaration instanceof KtPropertyAccessor) {
                trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((PsiElement)((KtPropertyAccessor)declaration).getProperty()));
            } else {
                trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((PsiElement)declaration));
            }
        }
        if (!(descriptor instanceof ConstructorDescriptor) && declaration instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration).hasBody()) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY.on((PsiElement)declaration));
        }
        if (InlineUtil.isInline((DeclarationDescriptor)descriptor)) {
            trace.report((Diagnostic)ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED.on((PsiElement)declaration));
        }
    }
}

