/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesBrowserSpecificNode<T, F>
extends ChangesBrowserNode<T> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;
    private SimpleTextAttributes myAttributes;

    protected ChangesBrowserSpecificNode(@NotNull T userObject, @NotNull Collection<F> files, int manyDirectoryCount, @NotNull Runnable shower) {
        if (userObject == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(0);
        }
        if (files == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(1);
        }
        if (shower == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(2);
        }
        super(userObject);
        this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        this.myManyDirectoryCount = manyDirectoryCount;
        this.myManyFileCount = files.size() - this.myManyDirectoryCount;
        this.myIsMany = ChangesBrowserSpecificNode.isManyFiles(files);
        this.myDialogShower = shower;
    }

    public final void setAttributes(@NotNull SimpleTextAttributes attributes) {
        if (attributes == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(3);
        }
        this.myAttributes = attributes;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(4);
        }
        renderer.append(this.getTextPresentation(), this.myAttributes);
        this.appendCount(renderer);
        if (this.isManyFiles()) {
            renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append(VcsBundle.message((String)"changes.browse", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }

    public static boolean isManyFiles(@NotNull Collection<?> files) {
        if (files == null) {
            ChangesBrowserSpecificNode.$$$reportNull$$$0(5);
        }
        return files.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shower";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isManyFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

