/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.util.xml.stubs.builder.DomStubBuilderVisitor;
import com.intellij.xml.util.XmlUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<DomFileMetaData> {
    private static final Logger LOG = Logger.getInstance(DomStubBuilder.class);

    DomStubBuilder() {
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            DomStubBuilder.$$$reportNull$$$0(0);
        }
        return (fileType = file.getFileType()) == XmlFileType.INSTANCE && !FileBasedIndexImpl.isProjectOrWorkspaceFile((VirtualFile)file, (FileType)fileType);
    }

    @NotNull
    public Stream<DomFileMetaData> getAllSubBuilders() {
        Stream<DomFileMetaData> stream = DomApplicationComponent.getInstance().getStubBuildingMetadata().stream();
        if (stream == null) {
            DomStubBuilder.$$$reportNull$$$0(1);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DomFileMetaData getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            DomStubBuilder.$$$reportNull$$$0(2);
        }
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            PsiFile psiFile = fileContent.getPsiFile();
            if (!(psiFile instanceof XmlFile)) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileDescription<?> description = DomApplicationComponent.getInstance().findDescription((XmlFile)psiFile);
            if (description == null) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(description);
            if (meta == null || !meta.hasStubs()) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData domFileMetaData = meta;
            return domFileMetaData;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable DomFileMetaData data) {
        Object object = data == null ? "<no-stub>" : data.rootTagName + ":" + data.rootTagName + ":" + data.implementation;
        if (object == null) {
            DomStubBuilder.$$$reportNull$$$0(3);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable DomFileMetaData meta) {
        if (fileContent == null) {
            DomStubBuilder.$$$reportNull$$$0(4);
        }
        if (meta == null) {
            return null;
        }
        PsiFile psiFile = fileContent.getPsiFile();
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        Project project = fileContent.getProject();
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            XmlFileHeader header = DomService.getInstance().getXmlFileHeader(xmlFile);
            if (header.getRootTagLocalName() == null) {
                LOG.error("null root tag for " + String.valueOf(fileElement) + " for " + String.valueOf(fileContent.getFile()));
            }
            FileStub fileStub = new FileStub(header);
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                new DomStubBuilderVisitor(DomManagerImpl.getDomManager(project)).visitXmlElement((XmlElement)rootTag, fileStub, 0);
            }
            FileStub fileStub2 = fileStub;
            return fileStub2;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    public int getStubVersion() {
        return 23;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/stubs/builder/DomStubBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/stubs/builder/DomStubBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

