/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@PhaseDescription(name="AdditionalClassAnnotation", prerequisite={})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001d*\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols$JavaAnnotations;", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "noNewJavaAnnotationTargets", "", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateDocumentedAnnotation", "generateRetentionAnnotation", "generateTargetAnnotation", "mapTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "generateRepeatableAnnotation", "getValueArgument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "name", "Lorg/jetbrains/kotlin/name/Name;", "applicableTargetSet", "", "loadAnnotationTargets", "targetEntry", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAdditionalClassAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdditionalClassAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1#2:152\n1#2:155\n1#2:193\n1651#3:153\n1915#3:154\n1916#3:156\n1652#3:157\n1068#3:158\n672#3,11:159\n812#3,12:170\n1642#3,10:182\n1915#3:192\n1916#3:194\n1652#3:195\n*S KotlinDebug\n*F\n+ 1 AdditionalClassAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering\n*L\n80#1:155\n146#1:193\n80#1:153\n80#1:154\n80#1:156\n80#1:157\n80#1:158\n118#1:159,11\n146#1:170,12\n146#1:182,10\n146#1:192\n146#1:194\n146#1:195\n*E\n"})
public final class AdditionalClassAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmSymbols.JavaAnnotations symbols;
    private final boolean noNewJavaAnnotationTargets;

    public AdditionalClassAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getSymbols().getJavaAnnotations();
        this.noNewJavaAnnotationTargets = this.context.getConfig().getNoNewJavaAnnotationTargets() || !this.context.isCompilingAgainstJdk8OrLater();
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isAnnotationClass((IrClass)irClass)) {
            return;
        }
        this.generateDocumentedAnnotation(irClass);
        this.generateRetentionAnnotation(irClass);
        this.generateTargetAnnotation(irClass);
        this.generateRepeatableAnnotation(irClass);
    }

    private final void generateDocumentedAnnotation(IrClass irClass) {
        block3: {
            block2: {
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)StandardNames.FqNames.mustBeDocumented)) break block2;
                IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                FqName fqName = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"DOCUMENTED_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName)) break block3;
            }
            return;
        }
        irClass.setAnnotations(CollectionsKt.plus((Collection)irClass.getAnnotations(), (Object)BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getDocumentedConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getDocumentedConstructor().getSymbol(), (int)0, null, (int)32, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRetentionAnnotation(IrClass irClass) {
        void $this$generateRetentionAnnotation_u24lambda_u241;
        IrConstructorCallImpl irConstructorCallImpl;
        KotlinRetention kotlinRetention;
        block5: {
            block4: {
                IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                FqName fqName = JvmAnnotationNames.RETENTION_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"RETENTION_ANNOTATION");
                if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName)) {
                    return;
                }
                KotlinRetention kotlinRetentionPolicy = IrUtilsKt.getAnnotationRetention((IrClass)irClass);
                kotlinRetention = kotlinRetentionPolicy;
                if (kotlinRetention == null) break block4;
                KotlinRetention it = kotlinRetention;
                boolean bl = false;
                IrEnumEntry irEnumEntry = this.symbols.getAnnotationRetentionMap().get((Object)it);
                kotlinRetention = irEnumEntry;
                if (irEnumEntry != null) break block5;
            }
            kotlinRetention = this.symbols.getRpRuntime();
        }
        KotlinRetention javaRetentionPolicy = kotlinRetention;
        IrConstructorCallImpl irConstructorCallImpl2 = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getRetentionConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getRetentionConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateRetentionAnnotation_u24lambda_u241.getArguments().set(0, (Object)BuildersKt.IrGetEnumValueImpl((int)-1, (int)-1, (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getRetentionPolicyEnum())), (IrEnumEntrySymbol)javaRetentionPolicy.getSymbol()));
        Unit unit = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTargetAnnotation(IrClass irClass) {
        void $this$generateTargetAnnotation_u24lambda_u241;
        void $this$sortedBy$iv;
        Iterable $this$mapNotNullTo$iv;
        IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
        FqName fqName = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TARGET_ANNOTATION");
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName)) {
            return;
        }
        Set<KotlinTarget> set = this.applicableTargetSet(irClass);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        Iterable iterable = targets;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinTarget p0 = (KotlinTarget)element$iv;
            boolean bl2 = false;
            if (this.mapTarget(p0) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List javaTargets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IrEnumEntry it = (IrEnumEntry)a;
                boolean bl = false;
                String string = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                it = (IrEnumEntry)b;
                Comparable comparable = (Comparable)((Object)ElementType.valueOf(string));
                bl = false;
                String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)ElementType.valueOf(string2))));
            }
        });
        Object object = new IrType[]{IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum())};
        IrVarargImpl vararg = BuildersKt.IrVarargImpl((int)-1, (int)-1, (IrType)((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])object)), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum())));
        object = javaTargets.iterator();
        while (object.hasNext()) {
            IrEnumEntry target = (IrEnumEntry)object.next();
            vararg.getElements().add(BuildersKt.IrGetEnumValueImpl((int)-1, (int)-1, (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)this.symbols.getElementTypeEnum())), (IrEnumEntrySymbol)target.getSymbol()));
        }
        Object target = object = BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getTargetConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getTargetConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateTargetAnnotation_u24lambda_u241.getArguments().set(0, (Object)vararg);
        Unit unit = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
    }

    private final IrEnumEntry mapTarget(KotlinTarget target) {
        IrEnumEntry irEnumEntry;
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                IrEnumEntry irEnumEntry2;
                IrEnumEntry it = irEnumEntry2 = this.symbols.getTypeParameterTarget();
                boolean bl = false;
                if (!this.noNewJavaAnnotationTargets) {
                    irEnumEntry = irEnumEntry2;
                    break;
                }
                irEnumEntry = null;
                break;
            }
            case 2: {
                IrEnumEntry irEnumEntry3;
                IrEnumEntry it = irEnumEntry3 = this.symbols.getTypeUseTarget();
                boolean bl = false;
                if (!this.noNewJavaAnnotationTargets) {
                    irEnumEntry = irEnumEntry3;
                    break;
                }
                irEnumEntry = null;
                break;
            }
            default: {
                irEnumEntry = this.symbols.getJvmTargetMap().get(target);
            }
        }
        return irEnumEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRepeatableAnnotation(IrClass irClass) {
        void $this$generateRepeatableAnnotation_u24lambda_u241;
        Object v2;
        block7: {
            block9: {
                block8: {
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)StandardNames.FqNames.repeatable)) break block8;
                    IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irClass;
                    FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irAnnotationContainer, (FqName)fqName)) break block9;
                }
                return;
            }
            Iterable $this$singleOrNull$iv = irClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)it).getName().asString(), (Object)"Container"))) continue;
                if (found$iv) {
                    v2 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrClass irClass2 = v2;
        if (irClass2 == null) {
            throw new IllegalStateException(("Repeatable annotation class should have a container generated: " + RenderIrElementKt.render$default((IrElement)((IrElement)irClass), null, (int)1, null)).toString());
        }
        IrClass containerClass = irClass2;
        IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl[]{IrUtilsKt.getDefaultType((IrClass)containerClass)};
        IrClassReferenceImpl containerReference = BuildersKt.IrClassReferenceImpl((int)-1, (int)-1, (IrType)((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass()), (IrType[])irConstructorCallImpl)), (IrClassifierSymbol)((IrClassifierSymbol)containerClass.getSymbol()), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)containerClass)));
        IrConstructorCallImpl $i$f$singleOrNull = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)IrConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.symbols.getRepeatableConstructor().getReturnType(), (IrConstructorSymbol)this.symbols.getRepeatableConstructor().getSymbol(), (int)0, null, (int)32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass3 = irClass;
        boolean bl = false;
        $this$generateRepeatableAnnotation_u24lambda_u241.getArguments().set(0, (Object)containerReference);
        Unit unit = Unit.INSTANCE;
        irClass3.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    private final IrExpression getValueArgument(IrConstructorCall $this$getValueArgument, Name name) {
        Object v0;
        block2: {
            Iterable iterable = ((IrConstructor)$this$getValueArgument.getSymbol().getOwner()).getParameters();
            for (Object t : iterable) {
                IrValueParameter it = (IrValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return null;
        }
        IrValueParameter parameter = irValueParameter;
        return $this$getValueArgument.getArguments().get(parameter);
    }

    private final Set<KotlinTarget> applicableTargetSet(IrClass $this$applicableTargetSet) {
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$applicableTargetSet), (FqName)StandardNames.FqNames.target);
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall targetEntry = irConstructorCall;
        return this.loadAnnotationTargets(targetEntry);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KotlinTarget> loadAnnotationTargets(IrConstructorCall targetEntry) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Name name = Name.identifier((String)"allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        IrExpression irExpression = this.getValueArgument(targetEntry, name);
        IrVararg irVararg = irExpression instanceof IrVararg ? (IrVararg)irExpression : null;
        if (irVararg == null) {
            return null;
        }
        IrVararg valueArgument = irVararg;
        Iterable $this$filterIsInstance$iv = valueArgument.getElements();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrGetEnumValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrGetEnumValue it = (IrGetEnumValue)element$iv$iv;
            boolean bl2 = false;
            String string = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            if (KotlinTarget.Companion.valueOrNull(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinTarget.values().length];
            try {
                nArray[KotlinTarget.TYPE_PARAMETER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.TYPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

