/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Attribute;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ConstantDynamic;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;
import org.jetbrains.coverage.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.InsnList;
import org.jetbrains.coverage.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.ParameterNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.TypeAnnotationNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.UnsupportedClassVersionException;
import org.jetbrains.coverage.org.objectweb.asm.tree.Util;
import org.jetbrains.coverage.org.objectweb.asm.tree.VarInsnNode;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List<String> exceptions;
    public List<ParameterNode> parameters;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public Object annotationDefault;
    public int visibleAnnotableParameterCount;
    public List<AnnotationNode>[] visibleParameterAnnotations;
    public int invisibleAnnotableParameterCount;
    public List<AnnotationNode>[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List<TryCatchBlockNode> tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List<LocalVariableNode> localVariables;
    public List<LocalVariableAnnotationNode> visibleLocalVariableAnnotations;
    public List<LocalVariableAnnotationNode> invisibleLocalVariableAnnotations;
    private boolean visited;

    public MethodNode() {
        this(589824);
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public MethodNode(int api) {
        super((int)var1_1);
        void var1_1;
        this.instructions = new InsnList();
    }

    /*
     * WARNING - void declaration
     */
    public MethodNode(int access, String name, String descriptor, String signature, String[] exceptions) {
        this(589824, (int)var1_1, (String)var2_2, (String)var3_3, signature, exceptions);
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getClass() != MethodNode.class) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public MethodNode(int api, int access, String name, String descriptor, String signature, String[] exceptions) {
        super((int)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.access = access;
        this.name = var3_3;
        this.desc = descriptor;
        this.signature = signature;
        this.exceptions = Util.asArrayList(exceptions);
        if ((var2_2 & 0x400) == 0) {
            this.localVariables = new ArrayList<LocalVariableNode>(5);
        }
        this.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        this.instructions = new InsnList();
    }

    /*
     * WARNING - void declaration
     */
    public void visitParameter(String name, int access) {
        void var2_2;
        void var1_1;
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterNode>(5);
        }
        this.parameters.add(new ParameterNode((String)var1_1, (int)var2_2));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode((List<Object>)new ArrayList<Object>(this, 0){
            final /* synthetic */ MethodNode this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean add(Object o) {
                void var1_1;
                this.this$0.annotationDefault = o;
                return super.add(var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var1_1;
        void var2_2;
        AnnotationNode annotation = new AnnotationNode(descriptor);
        if (var2_2 != false) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotation);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotation);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var1_2;
        void var3_4;
        void var2_3;
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, (TypePath)var2_3, (String)var3_4);
        if (visible) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotation);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotation);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        void var1_1;
        if (visible) {
            this.visibleAnnotableParameterCount = parameterCount;
            return;
        }
        this.invisibleAnnotableParameterCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        void var2_2;
        int params;
        AnnotationNode annotation = new AnnotationNode(descriptor);
        if (visible) {
            if (this.visibleParameterAnnotations == null) {
                params = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[params];
            }
            this.visibleParameterAnnotations[parameter] = Util.add(this.visibleParameterAnnotations[parameter], annotation);
        } else {
            void var1_1;
            if (this.invisibleParameterAnnotations == null) {
                void var3_3;
                params = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[var3_3];
            }
            this.invisibleParameterAnnotations[parameter] = Util.add(this.invisibleParameterAnnotations[var1_1], annotation);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAttribute(Attribute attribute) {
        void var1_1;
        this.attrs = Util.add(this.attrs, var1_1);
    }

    public void visitCode() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instructions.add(new FrameNode((int)var1_1, (int)var2_2, local == null ? null : this.getLabelNodes((Object[])var3_3), numStack, stack == null ? null : this.getLabelNodes(stack)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        this.instructions.add(new InsnNode((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        this.instructions.add(new IntInsnNode((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var2_2;
        void var1_1;
        this.instructions.add(new VarInsnNode((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        this.instructions.add(new TypeInsnNode((int)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instructions.add(new FieldInsnNode((int)var1_1, (String)var2_2, (String)var3_3, descriptor));
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcodeAndSource, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.api < 327680 && (opcodeAndSource & 0x100) == 0) {
            super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
            return;
        }
        int opcode = opcodeAndSource & 0xFFFFFEFF;
        this.instructions.add(new MethodInsnNode((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface));
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instructions.add(new InvokeDynamicInsnNode((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments));
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        this.instructions.add(new JumpInsnNode((int)var1_1, this.getLabelNode((Label)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        this.instructions.add(this.getLabelNode((Label)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        this.instructions.add(new LdcInsnNode(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        this.instructions.add(new IincInsnNode((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instructions.add(new TableSwitchInsnNode((int)var1_1, (int)var2_2, this.getLabelNode((Label)var3_3), this.getLabelNodes(labels)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode((Label)var1_1), (int[])var2_2, this.getLabelNodes((Label[])var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        this.instructions.add(new MultiANewArrayInsnNode((String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var1_2;
        void var3_4;
        void var2_3;
        AbstractInsnNode currentInsn = this.instructions.getLast();
        while (currentInsn.getOpcode() == -1) {
            currentInsn = currentInsn.getPrevious();
        }
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, (TypePath)var2_3, (String)var3_4);
        if (visible) {
            currentInsn.visibleTypeAnnotations = Util.add(currentInsn.visibleTypeAnnotations, typeAnnotation);
        } else {
            currentInsn.invisibleTypeAnnotations = Util.add(currentInsn.invisibleTypeAnnotations, typeAnnotation);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        void var1_1;
        void var3_3;
        void var2_2;
        TryCatchBlockNode tryCatchBlock = new TryCatchBlockNode(this.getLabelNode(start), this.getLabelNode((Label)var2_2), this.getLabelNode((Label)var3_3), type);
        this.tryCatchBlocks = Util.add(this.tryCatchBlocks, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var1_2;
        void var3_4;
        void var2_3;
        TryCatchBlockNode tryCatchBlock = this.tryCatchBlocks.get((typeRef & 0xFFFF00) >> 8);
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, (TypePath)var2_3, (String)var3_4);
        if (visible) {
            tryCatchBlock.visibleTypeAnnotations = Util.add(tryCatchBlock.visibleTypeAnnotations, typeAnnotation);
        } else {
            tryCatchBlock.invisibleTypeAnnotations = Util.add(tryCatchBlock.invisibleTypeAnnotations, typeAnnotation);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        void var1_1;
        void var3_3;
        void var2_2;
        LocalVariableNode localVariable = new LocalVariableNode(name, (String)var2_2, (String)var3_3, this.getLabelNode(start), this.getLabelNode(end), index);
        this.localVariables = Util.add(this.localVariables, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        void var1_2;
        void var3_4;
        void var2_3;
        LocalVariableAnnotationNode localVariableAnnotation = new LocalVariableAnnotationNode(typeRef, (TypePath)var2_3, this.getLabelNodes((Label[])var3_4), this.getLabelNodes(end), index, descriptor);
        if (visible) {
            this.visibleLocalVariableAnnotations = Util.add(this.visibleLocalVariableAnnotations, localVariableAnnotation);
        } else {
            this.invisibleLocalVariableAnnotations = Util.add(this.invisibleLocalVariableAnnotations, localVariableAnnotation);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.instructions.add(new LineNumberNode((int)var1_1, this.getLabelNode((Label)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitMaxs(int maxStack, int maxLocals) {
        void var2_2;
        void var1_1;
        this.maxStack = var1_1;
        this.maxLocals = var2_2;
    }

    public void visitEnd() {
    }

    /*
     * WARNING - void declaration
     */
    protected LabelNode getLabelNode(Label label) {
        void var1_1;
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode();
        }
        return (LabelNode)var1_1.info;
    }

    /*
     * WARNING - void declaration
     */
    private LabelNode[] getLabelNodes(Label[] labels) {
        void var2_2;
        LabelNode[] labelNodes = new LabelNode[labels.length];
        int n = labels.length;
        for (int i = 0; i < n; ++i) {
            labelNodes[i] = this.getLabelNode(labels[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] getLabelNodes(Object[] objects) {
        void var2_2;
        Object[] labelNodes = new Object[objects.length];
        for (Object o : objects) {
            if (o instanceof Label) {
                o = this.getLabelNode((Label)o);
            }
            labelNodes[i] = o;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void check(int api) {
        void var1_1;
        AbstractInsnNode insn;
        int i;
        if (api == 262144) {
            if (this.parameters != null && !this.parameters.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.tryCatchBlocks != null) {
                for (i = this.tryCatchBlocks.size() - 1; i >= 0; --i) {
                    TryCatchBlockNode tryCatchBlock = this.tryCatchBlocks.get(i);
                    if (tryCatchBlock.visibleTypeAnnotations != null && !tryCatchBlock.visibleTypeAnnotations.isEmpty()) {
                        throw new UnsupportedClassVersionException();
                    }
                    if (tryCatchBlock.invisibleTypeAnnotations == null || tryCatchBlock.invisibleTypeAnnotations.isEmpty()) continue;
                    throw new UnsupportedClassVersionException();
                }
            }
            for (i = this.instructions.size() - 1; i >= 0; --i) {
                Object value;
                boolean bl;
                insn = this.instructions.get(i);
                if (insn.visibleTypeAnnotations != null && !insn.visibleTypeAnnotations.isEmpty()) {
                    throw new UnsupportedClassVersionException();
                }
                if (insn.invisibleTypeAnnotations != null && !insn.invisibleTypeAnnotations.isEmpty()) {
                    throw new UnsupportedClassVersionException();
                }
                if (!(insn instanceof MethodInsnNode ? (bl = ((MethodInsnNode)insn).itf) != (insn.opcode == 185) : insn instanceof LdcInsnNode && ((value = ((LdcInsnNode)insn).cst) instanceof Handle || value instanceof Type && ((Type)value).getSort() == 11))) continue;
                throw new UnsupportedClassVersionException();
            }
            if (this.visibleLocalVariableAnnotations != null && !this.visibleLocalVariableAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleLocalVariableAnnotations != null && !this.invisibleLocalVariableAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (var1_1 < 458752) {
            for (i = this.instructions.size() - 1; i >= 0; --i) {
                void var3_3;
                Object object;
                insn = this.instructions.get(i);
                if (!(insn instanceof LdcInsnNode) || !((object = ((LdcInsnNode)var3_3).cst) instanceof ConstantDynamic)) continue;
                throw new UnsupportedClassVersionException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void accept(ClassVisitor classVisitor) {
        void var2_2;
        String[] exceptionsArray = this.exceptions == null ? null : this.exceptions.toArray(new String[0]);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, (String[])var2_2);
        if (methodVisitor != null) {
            void var1_1;
            this.accept((MethodVisitor)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void accept(MethodVisitor methodVisitor) {
        void var1_1;
        AnnotationNode annotation;
        int j;
        int m;
        List<AnnotationNode> parameterAnnotations;
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation2;
        int i;
        int n;
        if (this.parameters != null) {
            n = this.parameters.size();
            for (i = 0; i < n; ++i) {
                this.parameters.get(i).accept(methodVisitor);
            }
        }
        if (this.annotationDefault != null) {
            AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept(annotationVisitor, null, this.annotationDefault);
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
        if (this.visibleAnnotations != null) {
            n = this.visibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation2 = this.visibleAnnotations.get(i);
                annotation2.accept(methodVisitor.visitAnnotation(annotation2.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n = this.invisibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation2 = this.invisibleAnnotations.get(i);
                annotation2.accept(methodVisitor.visitAnnotation(annotation2.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.visibleTypeAnnotations.get(i);
                typeAnnotation.accept(methodVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i);
                typeAnnotation.accept(methodVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.visibleAnnotableParameterCount > 0) {
            methodVisitor.visitAnnotableParameterCount(this.visibleAnnotableParameterCount, true);
        }
        if (this.visibleParameterAnnotations != null) {
            n = this.visibleParameterAnnotations.length;
            for (i = 0; i < n; ++i) {
                parameterAnnotations = this.visibleParameterAnnotations[i];
                if (parameterAnnotations == null) continue;
                m = parameterAnnotations.size();
                for (j = 0; j < m; ++j) {
                    annotation = parameterAnnotations.get(j);
                    annotation.accept(methodVisitor.visitParameterAnnotation(i, annotation.desc, true));
                }
            }
        }
        if (this.invisibleAnnotableParameterCount > 0) {
            methodVisitor.visitAnnotableParameterCount(this.invisibleAnnotableParameterCount, false);
        }
        if (this.invisibleParameterAnnotations != null) {
            n = this.invisibleParameterAnnotations.length;
            for (i = 0; i < n; ++i) {
                parameterAnnotations = this.invisibleParameterAnnotations[i];
                if (parameterAnnotations == null) continue;
                m = parameterAnnotations.size();
                for (j = 0; j < m; ++j) {
                    annotation = parameterAnnotations.get(j);
                    annotation.accept(methodVisitor.visitParameterAnnotation(i, annotation.desc, false));
                }
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        if (this.attrs != null) {
            n = this.attrs.size();
            for (i = 0; i < n; ++i) {
                methodVisitor.visitAttribute(this.attrs.get(i));
            }
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            if (this.tryCatchBlocks != null) {
                n = this.tryCatchBlocks.size();
                for (i = 0; i < n; ++i) {
                    this.tryCatchBlocks.get(i).updateIndex(i);
                    this.tryCatchBlocks.get(i).accept(methodVisitor);
                }
            }
            this.instructions.accept(methodVisitor);
            if (this.localVariables != null) {
                n = this.localVariables.size();
                for (i = 0; i < n; ++i) {
                    this.localVariables.get(i).accept(methodVisitor);
                }
            }
            if (this.visibleLocalVariableAnnotations != null) {
                n = this.visibleLocalVariableAnnotations.size();
                for (i = 0; i < n; ++i) {
                    this.visibleLocalVariableAnnotations.get(i).accept(methodVisitor, true);
                }
            }
            if (this.invisibleLocalVariableAnnotations != null) {
                n = this.invisibleLocalVariableAnnotations.size();
                for (i = 0; i < n; ++i) {
                    this.invisibleLocalVariableAnnotations.get(i).accept(methodVisitor, false);
                }
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = true;
        }
        var1_1.visitEnd();
    }
}

