---
stage: Analytics
group: Platform Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabのアラートの理解と管理。 アラートリストの表示、ステータスの変更、アラートの割り当て、アクションのトリガー、オンコールの通知への対応などを行います。
title: アラート
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

アラートは、インシデント管理ワークフローにおける重要なエンティティです。サービス停止または中断を示す可能性のある重要なイベントを表します。GitLabは、何が起こったのかをより深く調査するためのトリアージ用のリストビューと詳細ビューを提供します。

## アラートリスト {#alert-list}

少なくともデベロッパーロールを持つユーザーは、プロジェクトのサイドバーの**モニタリング** > **アラート**でアラートリストにアクセスできます。アラートリストは、開始時刻でソートされたアラートを表示しますが、アラートリストのヘッダーを選択して、ソート順を変更できます。

アラートリストには、次の情報が表示されます:

![オープンアラートの詳細を示すアラートリスト](img/alert_list_v13_1.png)

- **検索**: アラートリストは、タイトル、説明、モニタリングツール、およびサービスフィールドでの簡単なフリーテキスト検索をサポートしています。
- **重大度**: アラートの現在の重要度と、アラートが受けるべき注意の量。すべてのステータスの一覧については、[アラート管理の重大度](#alert-severity)をお読みください。
- **開始時間**: アラートがトリガーされてからの時間。このフィールドは、標準のGitLabパターン`X time ago`を使用しますが、ユーザーのロケールに応じて、詳細な日付/時刻ツールチップでサポートされています。
- **Alert description**（アラートの説明）: 最も意味のあるデータをキャプチャしようとするアラートの説明。
- **Event count**（イベント数）: アラートがトリガーされた回数。
- **Issue**: アラートに対して作成されたインシデントイシューへのリンク。
- **ステータス**: アラートの現在のステータス:
  - **トリガー**: まだ調査が開始されていません。
  - **確認済み**: 誰かが積極的に問題を調査しています。
  - **解決済み**: これ以上の作業は必要ありません。
  - **無視済み**: アラートに対してアクションは実行されません。

## アラートの重大度 {#alert-severity}

アラートの各レベルには、特定アラートの重大度を識別するのに役立つ、独自に形作られた色分けされたアイコンが含まれています。これらの重大度アイコンは、調査を優先すべきアラートをすぐに識別するのに役立ちます:

![クリティカル、高、中、低、情報、不明のレベルに対して異なる色と形を示すアラートの重大度アイコン](img/alert_management_severity_v13_0.png)

アラートには、次のいずれかのアイコンが含まれています:

<!-- vale gitlab_base.SubstitutionWarning = NO -->

| 重大度 | アイコン                    | 色（16進数） |
|----------|-------------------------|---------------------|
| クリティカル | {{< icon name="severity-critical" >}} | `#8b2615`           |
| 高     | {{< icon name="severity-high" >}}     | `#c0341d`           |
| 中程度   | {{< icon name="severity-medium" >}}   | `#fca429`           |
| 低      | {{< icon name="severity-low" >}}      | `#fdbc60`           |
| 情報     | {{< icon name="severity-info" >}}     | `#418cd8`           |
| 不明  | {{< icon name="severity-unknown" >}}  | `#bababa`           |

<!-- vale gitlab_base.SubstitutionWarning = YES -->

## アラート詳細ページ {#alert-details-page}

[アラートリスト](#alert-list)にアクセスし、リストからアラートを選択して、アラート詳細ビューに移動します。アラートにアクセスするには、少なくともデベロッパーロールが必要です。リスト内のアラートを選択して、アラート詳細ページを確認します。

アラートには、必要な量の情報を提供するために、**概要**タブと**アラートの詳細**タブがあります。

### アラート詳細タブ {#alert-details-tab}

**アラートの詳細**タブには、2つのセクションがあります。上部のセクションには、重大度、開始時間、イベント数、および元のモニタリングツールなど、重要な詳細の短いリストが表示されます。2番目のセクションには、完全なアラートペイロードが表示されます。

### メトリクスタブ {#metrics-tab}

多くの場合、アラートはメトリクスに関連付けられています。**メトリクス**タブで、メトリクスチャートのスクリーンショットをアップロードできます。

これを行うには、次のいずれかを実行します:

- **upload**（アップロード）を選択し、ファイルブラウザから画像を選択します。
- ファイルブラウザからファイルをドラッグして、ドロップゾーンにドロップします。

画像をアップロードすると、画像にテキストを追加して、元のグラフにリンクできます。

![テキストリンクを追加するオプションを備えたインシデントメトリクスタブ](img/incident_metrics_tab_text_link_modal_v14_9.png)

リンクを追加すると、アップロードされた画像の上に表示されます。

### アクティビティーフィードタブ {#activity-feed-tab}

**アクティビティーフィード**タブは、アラートのアクティビティーのログです。アラートに対してアクションを実行すると、これはシステムノートとして記録されます。これにより、アラートの調査と割り当て履歴のリニアタイムラインが得られます。

次のアクションは、システムノートになります:

- [アラートのステータスの更新](#change-an-alerts-status)
- [アラートに基づいてインシデントを作成する](manage_incidents.md#from-an-alert)
- [ユーザーへのアラートの割り当て](#assign-an-alert)
- [オンコールのレスポンダーへのアラートのエスカレーション](paging.md#escalating-an-alert)

![3つのシステムノートを示すGitLabアラートフィードアクティビティー](img/alert_detail_activity_feed_v13_5.png)

## アラートアクション {#alert-actions}

GitLabには、トリアージを支援し、アラートに対応するためのさまざまなアクションがあります。

### アラートのステータスを変更する {#change-an-alerts-status}

アラートのステータスを変更できます。

使用可能なステータスは次のとおりです:

- トリガー（新しいアラートのデフォルト）
- 確認済み
- 解決済み

前提要件:

- デベロッパーロール以上が必要です。

アラートのステータスを変更するには:

- [アラートリスト](#alert-list)から:

  1. **ステータス**列で、アラートの横にあるステータスドロップダウンリストを選択します。
  1. ステータスを選択します。

- [アラートの詳細ページ](#alert-details-page)から:

  1. 右側のサイドバーで、**編集**を選択します。
  1. ステータスを選択します。

[メール通知が有効](paging.md#email-notifications-for-alerts)になっているプロジェクトで、アラートの繰り返しに関するメール通知を停止するには、アラートのステータスを**トリガー**から変更します。

#### リンクされたインシデントを閉じてアラートを解決する {#resolve-an-alert-by-closing-the-linked-incident}

前提要件:

- レポーターロール以上が必要です。

アラートにリンクされている[インシデントを閉じる](manage_incidents.md#close-an-incident)と、GitLabは[アラートのステータスを変更](#change-an-alerts-status)して**解決済み**にします。その後、アラートのステータス変更が評価されます。

#### オンコールのレスポンダーとして {#as-an-on-call-responder}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

オンコールのレスポンダーは、アラートのステータスを変更することにより、[アラートページ](paging.md#escalating-an-alert)に応答できます。

ステータスを変更すると、次の効果があります:

- **確認済み**へ: プロジェクトの[エスカレーションポリシー](escalation_policies.md)に基づいて、オンコールのページを制限します。
- **解決済み**へ: アラートのすべてのオンコールページを停止します。
- **解決済み**から**トリガー**へ: アラートのエスカレーションを再開します。

GitLab 15.1以前は、[関連付けられたインシデントを含むアラート](manage_incidents.md#from-an-alert)のステータスを更新すると、インシデントのステータスも更新されます。[GitLab 15.2以降](https://gitlab.com/gitlab-org/gitlab/-/issues/356057)では、インシデントのステータスは独立しており、アラートのステータスが変更されても更新されません。

### アラートを割り当てる {#assign-an-alert}

大規模なチームでは、アラートの所有権が共有されている場合、誰が調査および作業しているかを追跡するのが難しい場合があります。アラートを割り当てると、どのアラートをどのユーザーが所有しているかを示すことで、コラボレーションと委任が容易になります。GitLabは、アラートごとに1人のアサインのみをサポートしています。

アラートを割り当てるには:

1. 現在のアラートのリストを表示します:

   1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
   1. **モニタリング** > **アラート**を選択します。

1. 詳細を表示するには、目的のアラートを選択します。

   ![右側のサイドバーが展開され、ユーザーを割り当てるまたは割り当て解除するための担当者ドロップダウンリストが表示されたアラートの詳細ページ](img/alert_details_assignees_v13_1.png)

1. 右側のサイドバーが展開されていない場合は、**サイドバーを展開**（{{< icon name="chevron-double-lg-right" >}}）を選択して展開します。

1. 右側のサイドバーで、**担当者**を見つけて、**編集**を選択します。リストから、アラートに割り当てる各ユーザーを選択します。GitLabは、各ユーザーの[To-Doアイテム](../../user/todos.md)を作成します。

アラートの調査または修正の担当部分を完了すると、ユーザーは自分自身をアラートから割り当て解除できます。担当者を削除するには、**担当者**ドロップダウンリストの横にある**編集**を選択し、担当者のリストからユーザーをクリアするか、**未アサイン**を選択します。

### アラートからTo-Doアイテムを作成 {#create-a-to-do-item-from-an-alert}

アラートから手動で自分の[To-Doアイテム](../../user/todos.md)を作成し、後で**To-Doリスト**で表示できます。

To-Doアイテムを追加するには、右側のサイドバーで**To-Doアイテムを追加**を選択します。

### アラートからのトリガーアクション {#trigger-actions-from-alerts}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

アラートがトリガーされるたびに、自動的に[インシデント](incidents.md)を作成することを有効にします。

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。

アクションを設定するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **モニタリング**を選択します。
1. **アラート**セクションを展開し、**アラート設定**タブを選択します。
1. **Create an incident**（インシデントを作成する）チェックボックスを選択します。
1. オプション。インシデントをカスタマイズするには、**Incident template**（インシデントテンプレート）から、[インシデントの概要](incidents.md#summary)に追加されるテンプレートを選択します。ドロップダウンリストが空の場合は、最初に[イシューテンプレートを作成](../../user/project/description_templates.md#create-a-description-template)します。
1. オプション。[メール通知](paging.md#email-notifications-for-alerts)を送信するには、**Send a single email notification to Owners and Maintainers for new alerts**（新しいアラートのオーナーとメンテナーに単一のメール通知を送信する）チェックボックスを選択します。
1. **変更を保存**を選択します。
