/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.plugin.core.terminal.vt;

import java.nio.ByteBuffer;

/**
 * A callback for bytes generated by the terminal, e.g., to report a key press or reply to a
 * request.
 */
public interface VtOutput {
	/**
	 * Handle output from the terminal
	 * 
	 * <p>
	 * Most likely these bytes should be sent down an output stream, usually to a pty.
	 * 
	 * @param buf the buffer of bytes generated
	 */
	void out(ByteBuffer buf);
}
