/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.validator;

import docking.DialogComponentProvider;
import docking.widgets.conditiontestpanel.ConditionTestPanel;
import docking.widgets.conditiontestpanel.ConditionTester;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ValidateProgramDialog
extends DialogComponentProvider {
    private ConditionTestPanel conditionTestPanel;

    public ValidateProgramDialog(Program program, List<ConditionTester> list) {
        super(ValidateProgramDialog.getTitle(program), true, true, true, false);
        JPanel mainPanel = new JPanel();
        this.conditionTestPanel = new ConditionTestPanel(list);
        this.conditionTestPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.conditionTestPanel.getAccessibleContext().setAccessibleName("Condition Test");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        mainPanel.setLayout(new BorderLayout());
        JPanel runButtonPanel = new JPanel();
        runButtonPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        runButtonPanel.setLayout(new FlowLayout());
        runButtonPanel.getAccessibleContext().setAccessibleName("Run Tests");
        JButton runTestsButton = new JButton("Run Validators");
        runTestsButton.addActionListener(e -> this.conditionTestPanel.runTests());
        runTestsButton.getAccessibleContext().setAccessibleName("Run Tests");
        runButtonPanel.add(runTestsButton);
        mainPanel.add((Component)this.conditionTestPanel, "Center");
        mainPanel.add((Component)runButtonPanel, "South");
        mainPanel.getAccessibleContext().setAccessibleName("Validate Program");
        this.addWorkPanel(mainPanel);
        this.addOKButton();
        this.setOkEnabled(true);
        this.setHelpLocation(new HelpLocation("ValidateProgram", "top_of_page"));
    }

    private static String getTitle(Program program) {
        return "Validate: " + program.getDomainFile().getName();
    }

    protected void okCallback() {
        this.close();
    }
}

