/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.Msg;
import ghidra.util.UniversalID;
import utilities.util.reflection.ReflectionUtilities;

public class UniversalIdGenerator {
    private static UniversalIdGenerator generator;
    private long baseTime;
    private int instanceCount = Integer.MAX_VALUE;
    private int sessionID = (int)(System.currentTimeMillis() >> 4) & 0xFFFF;
    private long idBase;

    public static synchronized UniversalID nextID() {
        if (generator == null) {
            Msg.warn(UniversalIdGenerator.class, (Object)"nextID called before UniversalIdGenerator initialized!", (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
            UniversalIdGenerator.initialize();
        }
        return generator.getNextID();
    }

    public static synchronized void initialize() {
        if (generator == null) {
            generator = new UniversalIdGenerator();
        }
    }

    static void installGenerator(UniversalIdGenerator newGenerator) {
        generator = newGenerator;
    }

    UniversalIdGenerator() {
    }

    protected UniversalID getNextID() {
        if (this.instanceCount >= 32) {
            this.baseTime = this.getNewBaseTime();
            this.idBase = this.baseTime << 21 | (long)(this.sessionID << 5);
            this.instanceCount = 0;
        }
        return new UniversalID(this.idBase + (long)this.instanceCount++);
    }

    private long getNewBaseTime() {
        long newTime = System.currentTimeMillis();
        if (newTime <= this.baseTime) {
            newTime = this.baseTime + 1L;
        }
        return newTime;
    }

    public static void main(String[] args) {
        UniversalIdGenerator gen = new UniversalIdGenerator();
        UniversalIdGenerator gen2 = new UniversalIdGenerator();
        for (int i = 0; i < 500; ++i) {
            System.out.println("id = " + gen.getNextID().getValue() + " next = " + Long.toHexString(gen.getNextID().getValue()));
            System.out.println("id2 = " + gen2.getNextID().getValue() + " next = " + Long.toHexString(gen2.getNextID().getValue()));
        }
    }
}

