/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.gui.editors.DisplayableOffset;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import java.math.BigInteger;

public class DisplayableVariableOffset
implements DisplayableOffset {
    protected final Function function;
    protected Address parameterAddress;
    protected long offset;
    protected BigInteger offsetAsBigInteger;

    public DisplayableVariableOffset(Function function, Address parameterAddress) {
        this.function = function;
        this.parameterAddress = parameterAddress;
        this.offset = parameterAddress != null ? parameterAddress.getOffset() : 0L;
        this.offsetAsBigInteger = parameterAddress != null ? parameterAddress.getOffsetAsBigInteger() : null;
    }

    @Override
    public Address getAddress() {
        return this.parameterAddress;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public BigInteger getOffsetAsBigInteger() {
        return this.offsetAsBigInteger;
    }

    @Override
    public String getDisplayString() {
        if (this.parameterAddress == null || this.parameterAddress == Address.NO_ADDRESS) {
            return "No Offset";
        }
        return this.parameterAddress.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableOffset otherDisplayableOffset) {
        if (otherDisplayableOffset == null) {
            return 1;
        }
        Address otherAddress = otherDisplayableOffset.getAddress();
        if (this.parameterAddress == null) {
            return otherAddress == null ? 0 : -1;
        }
        if (otherAddress == null) {
            return 1;
        }
        return this.parameterAddress.compareTo((Object)otherAddress);
    }
}

