/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.MediaRule;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.w3c.dom.DOMException;

abstract class BaseCSSRule
extends AbstractCSSRule {
    private static final long serialVersionUID = 2L;
    private AbstractCSSStyleSheet parentSheet = null;
    private AbstractCSSRule parentRule = null;
    private final short ruleType;
    private final int ruleOrigin;
    private StringList precedingComments = null;
    private StringList trailingComments = null;

    protected BaseCSSRule(AbstractCSSStyleSheet parentSheet, short type, int origin) {
        this.parentSheet = parentSheet;
        this.ruleType = type;
        this.ruleOrigin = origin;
    }

    protected BaseCSSRule(BaseCSSRule copyMe) {
        this(copyMe.parentSheet, copyMe.ruleType, copyMe.ruleOrigin);
        this.precedingComments = copyMe.precedingComments;
        this.trailingComments = copyMe.trailingComments;
    }

    @Override
    public short getType() {
        return this.ruleType;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentSheet != null ? this.parentSheet : (this.parentRule != null ? this.parentRule.getParentStyleSheet() : null);
    }

    @Override
    void setParentStyleSheet(AbstractCSSStyleSheet parentSheet) {
        this.parentSheet = parentSheet;
    }

    protected Parser createSACParser() throws DOMException {
        Parser parser = this.getParentStyleSheet() != null ? this.getParentStyleSheet().getStyleSheetFactory().createSACParser() : new CSSOMParser();
        return parser;
    }

    @Override
    public AbstractCSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public void setParentRule(AbstractCSSRule parent) {
        this.parentRule = parent;
    }

    @Override
    public int getOrigin() {
        return this.ruleOrigin;
    }

    @Override
    int addToSheet(AbstractCSSStyleSheet sheet, int importCount) {
        AbstractCSSRule clone = this.clone();
        sheet.addLocalRule(clone);
        return importCount;
    }

    @Override
    int addToMediaRule(MediaRule mrule, int importCount) {
        AbstractCSSRule clon = this.clone();
        mrule.addRule(clon);
        return importCount;
    }

    @Override
    public void enablePrecedingComments() {
        if (this.precedingComments == null) {
            this.precedingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    void setPrecedingComments(StringList precedingComments) {
        this.precedingComments = precedingComments;
    }

    @Override
    public void enableTrailingComments() {
        if (this.trailingComments == null) {
            this.trailingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    void setTrailingComments(StringList trailingComments) {
        this.trailingComments = trailingComments;
    }

    void resetComments() {
        this.precedingComments = null;
        this.trailingComments = null;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return false;
    }

    @Override
    public String getMinifiedCssText() {
        return this.getCssText();
    }

    protected StyleFormattingContext getStyleFormattingContext() {
        AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
        StyleFormattingContext context = sheet != null ? sheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext() : new DefaultStyleFormattingContext();
        return context;
    }

    protected URL getURL(String uri) throws MalformedURLException {
        URI destUri;
        if (uri == null || uri.isEmpty()) {
            throw new MalformedURLException("Empty URI");
        }
        try {
            destUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        String phref = this.getParentStyleSheet().getHref();
        if (!destUri.isAbsolute()) {
            if (phref == null) {
                throw new MalformedURLException("Cannot convert to absolute URI " + uri);
            }
            try {
                URI pUri = new URI(phref);
                destUri = pUri.resolve(destUri);
            }
            catch (Exception e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        return destUri.toURL();
    }
}

