/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StyleMap {
    public static final int IMPORTANT_MASK = 1;
    public static final int COMPUTED_MASK = 2;
    public static final int NULL_CASCADED_MASK = 4;
    public static final int INHERITED_MASK = 8;
    public static final int LINE_HEIGHT_RELATIVE_MASK = 16;
    public static final int FONT_SIZE_RELATIVE_MASK = 32;
    public static final int COLOR_RELATIVE_MASK = 64;
    public static final int PARENT_RELATIVE_MASK = 128;
    public static final int BLOCK_WIDTH_RELATIVE_MASK = 256;
    public static final int BLOCK_HEIGHT_RELATIVE_MASK = 512;
    public static final int BOX_RELATIVE_MASK = 1024;
    public static final int ROOT_LINE_HEIGHT_RELATIVE_MASK = 2048;
    public static final int ROOT_FONT_SIZE_RELATIVE_MASK = 4096;
    public static final int VIEWPORT_RELATIVE_MASK = 8192;
    public static final int CUSTOM_PTY_RELATIVE_MASK = 16384;
    public static final int ATTR_TAINTED_MASK = 32768;
    public static final int ORIGIN_MASK = -536870912;
    public static final int USER_AGENT_ORIGIN = 0;
    public static final int USER_ORIGIN = 0x20000000;
    public static final int NON_CSS_ORIGIN = 0x40000000;
    public static final int AUTHOR_ORIGIN = 0x60000000;
    public static final int INLINE_AUTHOR_ORIGIN = Integer.MIN_VALUE;
    public static final int OVERRIDE_ORIGIN = -1610612736;
    protected Value[] values;
    protected int[] masks;
    private Map<String, LexicalUnit> customProperties = null;
    protected boolean fixedCascadedValues;

    public StyleMap(int size) {
        this.values = new Value[size];
        this.masks = new int[size];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean b) {
        this.fixedCascadedValues = b;
    }

    public Value getValue(int i) {
        return this.values[i];
    }

    public int getMask(int i) {
        return this.masks[i];
    }

    public boolean isImportant(int i) {
        return (this.masks[i] & 1) != 0;
    }

    public boolean isComputed(int i) {
        return (this.masks[i] & 2) != 0;
    }

    public boolean isNullCascaded(int i) {
        return (this.masks[i] & 4) != 0;
    }

    public boolean isInherited(int i) {
        return (this.masks[i] & 8) != 0;
    }

    public int getOrigin(int i) {
        return this.masks[i] & 0xE0000000;
    }

    public boolean isColorRelative(int i) {
        return (this.masks[i] & 0x40) != 0;
    }

    public boolean isParentRelative(int i) {
        return (this.masks[i] & 0x80) != 0;
    }

    public boolean isLineHeightRelative(int i) {
        return (this.masks[i] & 0x10) != 0;
    }

    public boolean isFontSizeRelative(int i) {
        return (this.masks[i] & 0x20) != 0;
    }

    public boolean isRootLineHeightRelative(int i) {
        return (this.masks[i] & 0x800) != 0;
    }

    public boolean isRootFontSizeRelative(int i) {
        return (this.masks[i] & 0x1000) != 0;
    }

    public boolean isBlockWidthRelative(int i) {
        return (this.masks[i] & 0x100) != 0;
    }

    public boolean isBlockHeightRelative(int i) {
        return (this.masks[i] & 0x200) != 0;
    }

    public boolean isViewportRelative(int i) {
        return (this.masks[i] & 0x2000) != 0;
    }

    public boolean isCustomPtyRelative(int i) {
        return (this.masks[i] & 0x4000) != 0;
    }

    public boolean isAttrTainted(int i) {
        return (this.masks[i] & 0x8000) != 0;
    }

    public void putValue(int i, Value v) {
        this.values[i] = v;
    }

    public void putMask(int i, int m) {
        this.masks[i] = m;
    }

    public void putImportant(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 1;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFFE;
        }
    }

    public void putOrigin(int i, int val) {
        int n = i;
        this.masks[n] = this.masks[n] & 0x1FFFFFFF;
        int n2 = i;
        this.masks[n2] = this.masks[n2] | val & 0xE0000000;
    }

    public void putComputed(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 2;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFFD;
        }
    }

    public void putNullCascaded(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 4;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFFB;
        }
    }

    public void putInherited(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 8;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFF7;
        }
    }

    public void putColorRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x40;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFBF;
        }
    }

    public void putParentRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x80;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFF7F;
        }
    }

    public void putLineHeightRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x10;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFEF;
        }
    }

    public void putFontSizeRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x20;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFFDF;
        }
    }

    public void putRootLineHeightRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x800;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFF7FF;
        }
    }

    public void putRootFontSizeRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x1000;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFEFFF;
        }
    }

    public void putBlockWidthRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x100;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFEFF;
        }
    }

    public void putBlockHeightRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x200;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFFDFF;
        }
    }

    public void putViewportRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x2000;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFDFFF;
        }
    }

    public void putCustomPtyRelative(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x4000;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFFBFFF;
        }
    }

    public void putAttrTainted(int i, boolean b) {
        if (b) {
            int n = i;
            this.masks[n] = this.masks[n] | 0x8000;
        } else {
            int n = i;
            this.masks[n] = this.masks[n] & 0xFFFF7FFF;
        }
    }

    public void putCustomProperty(String name, LexicalUnit value) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, LexicalUnit>();
        }
        this.customProperties.put(name, value);
    }

    public LexicalUnit getCustomProperty(String name) {
        return this.customProperties != null ? this.customProperties.get(name) : null;
    }

    public String toString(CSSEngine eng) {
        HashSet<String> pendingShorthands = null;
        int nSlots = this.values.length;
        StringBuilder sb = new StringBuilder(nSlots * 8 + 32);
        for (int i = 0; i < nSlots; ++i) {
            PendingValue pending;
            String name;
            Value v = this.values[i];
            if (v == null) continue;
            if (v.getPrimitiveType() != CSSValue.Type.INTERNAL) {
                sb.append(eng.getPropertyName(i));
                sb.append(": ");
                sb.append(v);
                if (this.isImportant(i)) {
                    sb.append(" !important");
                }
                sb.append(";\n");
                continue;
            }
            if (pendingShorthands == null) {
                pendingShorthands = new HashSet<String>();
            }
            if (!pendingShorthands.add(name = (pending = (PendingValue)v).getShorthandName())) continue;
            sb.append(name);
            sb.append(": ");
            sb.append(pending.getLexicalUnit().toString());
            if (this.isImportant(i)) {
                sb.append(" !important");
            }
            sb.append(";\n");
        }
        if (this.customProperties != null) {
            for (Map.Entry<String, LexicalUnit> entry : this.customProperties.entrySet()) {
                sb.append(entry.getKey());
                sb.append(": ");
                sb.append(entry.getValue().toString());
                sb.append(";\n");
            }
        }
        return sb.toString();
    }
}

