/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.awt.Point;
import java.io.ObjectStreamException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.UndockIcon;

public class UndockWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final UndockWindowAction INSTANCE = new UndockWindowAction();
    private static final Icon icon = new UndockIcon(10);

    private UndockWindowAction() {
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    @Override
    public String getName() {
        return "Undock";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        if (window.isUndockable()) {
            FloatingWindow fw = DockingUtil.getFloatingWindowFor(window);
            return fw == null || fw.getChildWindowCount() > 0 && fw.getChildWindow(0) != window && fw.getChildWindow(0).getChildWindowCount() > 1;
        }
        return false;
    }

    @Override
    public void perform(DockingWindow window) {
        if (this.isPerformable(window)) {
            Point p = window.getLocation();
            SwingUtilities.convertPointToScreen(p, window.getParent());
            window.undock(p);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

