/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.freeplane.core.ui.components.StyledIcon;
import org.freeplane.core.ui.components.UITools;

public class TextIcon
implements StyledIcon {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private final String text;
    private final FontMetrics fontMetrics;
    private Color iconTextColor;
    private Color iconBackgroundColor;
    private Color iconBorderColor;
    private BasicStroke borderStroke;
    private int paddingX = 0;
    private int paddingY = 0;
    private BorderType borderType = BorderType.ROUND_RECTANGLE;

    public TextIcon(String text, FontMetrics fontMetrics) {
        this.text = text;
        this.fontMetrics = fontMetrics;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        if (this.iconBackgroundColor != null) {
            g2d.setColor(this.iconBackgroundColor);
            g2d.fillRect(x, y, iconWidth, iconHeight);
        }
        Color textColor = this.iconTextColor != null ? this.iconTextColor : c.getForeground();
        int borderLineWidth = this.getBorderLineWidth(1);
        if (this.borderStroke != null) {
            Color borderColor = this.iconBorderColor != null ? this.iconBorderColor : textColor;
            g2d.setColor(borderColor);
            g2d.setStroke(this.borderStroke);
            if (this.borderType == BorderType.ROUND_RECTANGLE) {
                g2d.drawRoundRect(x + borderLineWidth, y + borderLineWidth, iconWidth - 2 * borderLineWidth - 1, iconHeight - 2 * borderLineWidth - 1, iconHeight / 8, iconHeight / 8);
            } else {
                int lineY = y + iconHeight - 2 * borderLineWidth - 1;
                g2d.drawLine(x, lineY, x + iconWidth - 1, lineY);
            }
        }
        if (this.text != null) {
            Object textHint;
            g2d.setColor(textColor);
            g2d.setFont(this.fontMetrics.getFont());
            int textX = x + this.paddingX;
            int textY = y + this.paddingY + this.fontMetrics.getAscent();
            if (borderLineWidth != 0 && this.borderType == BorderType.ROUND_RECTANGLE) {
                textX += borderLineWidth;
                textY += borderLineWidth;
            }
            if (!RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(textHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING))) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.drawString(this.text, textX, textY);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textHint);
            } else {
                g2d.drawString(this.text, textX, textY);
            }
        }
    }

    @Override
    public Color getIconTextColor() {
        return this.iconTextColor;
    }

    @Override
    public TextIcon setIconTextColor(Color iconTextColor) {
        this.iconTextColor = iconTextColor;
        return this;
    }

    @Override
    public Color getIconBackgroundColor() {
        return this.iconBackgroundColor;
    }

    @Override
    public TextIcon setIconBackgroundColor(Color iconBackgroundColor) {
        this.iconBackgroundColor = iconBackgroundColor;
        if (this.iconTextColor == null) {
            this.iconTextColor = UITools.getTextColorForBackground(iconBackgroundColor);
        }
        return this;
    }

    @Override
    public Color getIconBorderColor() {
        return this.iconBorderColor;
    }

    @Override
    public TextIcon setIconBorderColor(Color iconBorderColor) {
        this.iconBorderColor = iconBorderColor;
        if (iconBorderColor != null && this.borderStroke == null) {
            this.borderStroke = DEFAULT_STROKE;
        }
        return this;
    }

    public BorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(BorderType borderType) {
        this.borderType = borderType;
    }

    @Override
    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    @Override
    public TextIcon setBorderStroke(BasicStroke borderStroke) {
        this.borderStroke = borderStroke;
        return this;
    }

    @Override
    public int getIconWidth() {
        return (this.text == null ? 0 : this.fontMetrics.stringWidth(this.text)) + 2 * this.paddingX + (this.borderType == BorderType.ROUND_RECTANGLE ? this.getBorderLineWidth(2) : 0);
    }

    @Override
    public int getIconHeight() {
        return this.fontMetrics.getHeight() + 2 * this.paddingY + this.getBorderLineWidth(this.borderType == BorderType.ROUND_RECTANGLE ? 3 : 2);
    }

    private int getBorderLineWidth(int weight) {
        return this.borderStroke != null ? (int)(this.borderStroke.getLineWidth() * (float)weight) : 0;
    }

    @Override
    public int getPaddingX() {
        return this.paddingX;
    }

    @Override
    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    @Override
    public int getPaddingY() {
        return this.paddingY;
    }

    @Override
    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    @Override
    public void setPadding(int padding) {
        this.setPaddingX(padding);
        this.setPaddingY(padding);
    }

    public String getText() {
        return this.text;
    }

    public static enum BorderType {
        UNDERLINE,
        ROUND_RECTANGLE;

    }
}

