/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout.mindmapmode;

import java.awt.Component;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.JToolbarComponentBuilder;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.layout.LayoutModel;
import org.freeplane.features.layout.mindmapmode.ChangeChildNodesLayoutActor;
import org.freeplane.features.layout.mindmapmode.ChildNodesLayoutButtonPanelProperty;
import org.freeplane.features.layout.mindmapmode.SelectNodeChildrenLayoutAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.mindmapmode.SelectedNodeChangeListener;

public class MLayoutController
extends LayoutController {
    public MLayoutController() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new SelectNodeChildrenLayoutAction());
        modeController.registerExtensionCopier((IExtensionCopier)new StyleCopier());
        modeController.addUiBuilder(PhaseProcessor.Phase.UI, "childNodesLayout", (EntryVisitor)new JToolbarComponentBuilder(new ComponentProvider(){

            public Component createComponent(Entry entry) {
                ChildNodesLayoutButtonPanelProperty layoutSelectorPanel = new ChildNodesLayoutButtonPanelProperty();
                SelectedNodeChangeListener.onSelectedNodeChange(layoutSelectorPanel::setStyleOnExternalChange);
                layoutSelectorPanel.addPropertyChangeListener(evt -> {
                    IMapSelection selection = Controller.getCurrentController().getSelection();
                    if (selection != null) {
                        String selectedValue = layoutSelectorPanel.getValue();
                        ChildNodesLayout layout = selectedValue != null ? ChildNodesLayout.valueOf((String)selectedValue) : null;
                        selection.getSelection().forEach(node -> MLayoutController.this.setChildNodesLayout((NodeModel)node, layout));
                        if (selectedValue == null) {
                            layoutSelectorPanel.setStyleOnExternalChange(selection.getSelected());
                        }
                    }
                });
                return layoutSelectorPanel.getValueComponent();
            }
        }));
    }

    public void setChildNodesLayout(NodeModel node, ChildNodesLayout layout) {
        if (node != null) {
            ChangeChildNodesLayoutActor actor = new ChangeChildNodesLayoutActor(node, layout != null ? layout : ChildNodesLayout.NOT_SET);
            Controller.getCurrentModeController().execute((IActor)actor, node.getMap());
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private StyleCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LayoutModel source = (LayoutModel)from.getExtension(LayoutModel.class);
            if (source != null) {
                LayoutModel layoutModel = LayoutModel.createLayoutModel((NodeModel)to);
                layoutModel.setChildNodesLayout(source.getChildNodesLayout());
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LayoutModel target = (LayoutModel)from.getExtension(LayoutModel.class);
            if (target != null) {
                target.setChildNodesLayout(ChildNodesLayout.NOT_SET);
            }
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LayoutModel model = (LayoutModel)which.getExtension(LayoutModel.class);
            if (model == null) {
                return;
            }
            LayoutModel target = (LayoutModel)from.getExtension(LayoutModel.class);
            if (target == null) {
                return;
            }
            if (model.getChildNodesLayout() != ChildNodesLayout.NOT_SET) {
                target.setChildNodesLayout(ChildNodesLayout.NOT_SET);
            }
        }
    }
}

