﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf/WAF_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WAF {
namespace Model {

/**
 *  <p>This is <b>AWS WAF Classic</b> documentation. For more information,
 * see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
 * WAF Classic</a> in the developer guide.</p> <p> <b>For the latest version of AWS
 * WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS
 * WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of
 * endpoints for regional and global use. </p>  <p>The <code>Id</code> and
 * <code>Name</code> of a <code>SizeConstraintSet</code>.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/SizeConstraintSetSummary">AWS
 * API Reference</a></p>
 */
class SizeConstraintSetSummary {
 public:
  AWS_WAF_API SizeConstraintSetSummary() = default;
  AWS_WAF_API SizeConstraintSetSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_WAF_API SizeConstraintSetSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WAF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A unique identifier for a <code>SizeConstraintSet</code>. You use
   * <code>SizeConstraintSetId</code> to get information about a
   * <code>SizeConstraintSet</code> (see <a>GetSizeConstraintSet</a>), update a
   * <code>SizeConstraintSet</code> (see <a>UpdateSizeConstraintSet</a>), insert a
   * <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a
   * <code>Rule</code> (see <a>UpdateRule</a>), and delete a
   * <code>SizeConstraintSet</code> from AWS WAF (see
   * <a>DeleteSizeConstraintSet</a>).</p> <p> <code>SizeConstraintSetId</code> is
   * returned by <a>CreateSizeConstraintSet</a> and by
   * <a>ListSizeConstraintSets</a>.</p>
   */
  inline const Aws::String& GetSizeConstraintSetId() const { return m_sizeConstraintSetId; }
  inline bool SizeConstraintSetIdHasBeenSet() const { return m_sizeConstraintSetIdHasBeenSet; }
  template <typename SizeConstraintSetIdT = Aws::String>
  void SetSizeConstraintSetId(SizeConstraintSetIdT&& value) {
    m_sizeConstraintSetIdHasBeenSet = true;
    m_sizeConstraintSetId = std::forward<SizeConstraintSetIdT>(value);
  }
  template <typename SizeConstraintSetIdT = Aws::String>
  SizeConstraintSetSummary& WithSizeConstraintSetId(SizeConstraintSetIdT&& value) {
    SetSizeConstraintSetId(std::forward<SizeConstraintSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the <code>SizeConstraintSet</code>, if any.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  SizeConstraintSetSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sizeConstraintSetId;

  Aws::String m_name;
  bool m_sizeConstraintSetIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAF
}  // namespace Aws
