﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadinessRequest.h>
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Route53RecoveryReadiness {
namespace Model {

/**
 */
class GetReadinessCheckResourceStatusRequest : public Route53RecoveryReadinessRequest {
 public:
  AWS_ROUTE53RECOVERYREADINESS_API GetReadinessCheckResourceStatusRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetReadinessCheckResourceStatus"; }

  AWS_ROUTE53RECOVERYREADINESS_API Aws::String SerializePayload() const override;

  AWS_ROUTE53RECOVERYREADINESS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The number of objects that you want to return with this call.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline GetReadinessCheckResourceStatusRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that identifies which batch of results you want to see.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetReadinessCheckResourceStatusRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name of a readiness check.</p>
   */
  inline const Aws::String& GetReadinessCheckName() const { return m_readinessCheckName; }
  inline bool ReadinessCheckNameHasBeenSet() const { return m_readinessCheckNameHasBeenSet; }
  template <typename ReadinessCheckNameT = Aws::String>
  void SetReadinessCheckName(ReadinessCheckNameT&& value) {
    m_readinessCheckNameHasBeenSet = true;
    m_readinessCheckName = std::forward<ReadinessCheckNameT>(value);
  }
  template <typename ReadinessCheckNameT = Aws::String>
  GetReadinessCheckResourceStatusRequest& WithReadinessCheckName(ReadinessCheckNameT&& value) {
    SetReadinessCheckName(std::forward<ReadinessCheckNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource identifier, which is the Amazon Resource Name (ARN) or the
   * identifier generated for the resource by Application Recovery Controller (for
   * example, for a DNS target resource).</p>
   */
  inline const Aws::String& GetResourceIdentifier() const { return m_resourceIdentifier; }
  inline bool ResourceIdentifierHasBeenSet() const { return m_resourceIdentifierHasBeenSet; }
  template <typename ResourceIdentifierT = Aws::String>
  void SetResourceIdentifier(ResourceIdentifierT&& value) {
    m_resourceIdentifierHasBeenSet = true;
    m_resourceIdentifier = std::forward<ResourceIdentifierT>(value);
  }
  template <typename ResourceIdentifierT = Aws::String>
  GetReadinessCheckResourceStatusRequest& WithResourceIdentifier(ResourceIdentifierT&& value) {
    SetResourceIdentifier(std::forward<ResourceIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  int m_maxResults{0};

  Aws::String m_nextToken;

  Aws::String m_readinessCheckName;

  Aws::String m_resourceIdentifier;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_readinessCheckNameHasBeenSet = false;
  bool m_resourceIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53RecoveryReadiness
}  // namespace Aws
