﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/resiliencehub/model/ErrorDetail.h>
#include <aws/resiliencehub/model/ResourceImportStatusType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResilienceHub {
namespace Model {
class DescribeDraftAppVersionResourcesImportStatusResult {
 public:
  AWS_RESILIENCEHUB_API DescribeDraftAppVersionResourcesImportStatusResult() = default;
  AWS_RESILIENCEHUB_API DescribeDraftAppVersionResourcesImportStatusResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESILIENCEHUB_API DescribeDraftAppVersionResourcesImportStatusResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for
   * this ARN is:
   * arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
   * For more information about ARNs, see <a
   * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
   * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General
   * Reference</i> guide.</p>
   */
  inline const Aws::String& GetAppArn() const { return m_appArn; }
  template <typename AppArnT = Aws::String>
  void SetAppArn(AppArnT&& value) {
    m_appArnHasBeenSet = true;
    m_appArn = std::forward<AppArnT>(value);
  }
  template <typename AppArnT = Aws::String>
  DescribeDraftAppVersionResourcesImportStatusResult& WithAppArn(AppArnT&& value) {
    SetAppArn(std::forward<AppArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the application.</p>
   */
  inline const Aws::String& GetAppVersion() const { return m_appVersion; }
  template <typename AppVersionT = Aws::String>
  void SetAppVersion(AppVersionT&& value) {
    m_appVersionHasBeenSet = true;
    m_appVersion = std::forward<AppVersionT>(value);
  }
  template <typename AppVersionT = Aws::String>
  DescribeDraftAppVersionResourcesImportStatusResult& WithAppVersion(AppVersionT&& value) {
    SetAppVersion(std::forward<AppVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of errors that were encountered while importing resources.</p>
   */
  inline const Aws::Vector<ErrorDetail>& GetErrorDetails() const { return m_errorDetails; }
  template <typename ErrorDetailsT = Aws::Vector<ErrorDetail>>
  void SetErrorDetails(ErrorDetailsT&& value) {
    m_errorDetailsHasBeenSet = true;
    m_errorDetails = std::forward<ErrorDetailsT>(value);
  }
  template <typename ErrorDetailsT = Aws::Vector<ErrorDetail>>
  DescribeDraftAppVersionResourcesImportStatusResult& WithErrorDetails(ErrorDetailsT&& value) {
    SetErrorDetails(std::forward<ErrorDetailsT>(value));
    return *this;
  }
  template <typename ErrorDetailsT = ErrorDetail>
  DescribeDraftAppVersionResourcesImportStatusResult& AddErrorDetails(ErrorDetailsT&& value) {
    m_errorDetailsHasBeenSet = true;
    m_errorDetails.emplace_back(std::forward<ErrorDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message returned for the resource request.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  DescribeDraftAppVersionResourcesImportStatusResult& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Status of the action.</p>
   */
  inline ResourceImportStatusType GetStatus() const { return m_status; }
  inline void SetStatus(ResourceImportStatusType value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DescribeDraftAppVersionResourcesImportStatusResult& WithStatus(ResourceImportStatusType value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time when the status last changed.</p>
   */
  inline const Aws::Utils::DateTime& GetStatusChangeTime() const { return m_statusChangeTime; }
  template <typename StatusChangeTimeT = Aws::Utils::DateTime>
  void SetStatusChangeTime(StatusChangeTimeT&& value) {
    m_statusChangeTimeHasBeenSet = true;
    m_statusChangeTime = std::forward<StatusChangeTimeT>(value);
  }
  template <typename StatusChangeTimeT = Aws::Utils::DateTime>
  DescribeDraftAppVersionResourcesImportStatusResult& WithStatusChangeTime(StatusChangeTimeT&& value) {
    SetStatusChangeTime(std::forward<StatusChangeTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeDraftAppVersionResourcesImportStatusResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appArn;

  Aws::String m_appVersion;

  Aws::Vector<ErrorDetail> m_errorDetails;

  Aws::String m_errorMessage;

  ResourceImportStatusType m_status{ResourceImportStatusType::NOT_SET};

  Aws::Utils::DateTime m_statusChangeTime{};

  Aws::String m_requestId;
  bool m_appArnHasBeenSet = false;
  bool m_appVersionHasBeenSet = false;
  bool m_errorDetailsHasBeenSet = false;
  bool m_errorMessageHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_statusChangeTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResilienceHub
}  // namespace Aws
