﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PaymentCryptographyData {
namespace Model {

/**
 * <p>Parameters that are required to generate or verify dCVC (Dynamic Card
 * Verification Code).</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DiscoverDynamicCardVerificationCode">AWS
 * API Reference</a></p>
 */
class DiscoverDynamicCardVerificationCode {
 public:
  AWS_PAYMENTCRYPTOGRAPHYDATA_API DiscoverDynamicCardVerificationCode() = default;
  AWS_PAYMENTCRYPTOGRAPHYDATA_API DiscoverDynamicCardVerificationCode(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API DiscoverDynamicCardVerificationCode& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The expiry date of a payment card.</p>
   */
  inline const Aws::String& GetCardExpiryDate() const { return m_cardExpiryDate; }
  inline bool CardExpiryDateHasBeenSet() const { return m_cardExpiryDateHasBeenSet; }
  template <typename CardExpiryDateT = Aws::String>
  void SetCardExpiryDate(CardExpiryDateT&& value) {
    m_cardExpiryDateHasBeenSet = true;
    m_cardExpiryDate = std::forward<CardExpiryDateT>(value);
  }
  template <typename CardExpiryDateT = Aws::String>
  DiscoverDynamicCardVerificationCode& WithCardExpiryDate(CardExpiryDateT&& value) {
    SetCardExpiryDate(std::forward<CardExpiryDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A random number that is generated by the issuer.</p>
   */
  inline const Aws::String& GetUnpredictableNumber() const { return m_unpredictableNumber; }
  inline bool UnpredictableNumberHasBeenSet() const { return m_unpredictableNumberHasBeenSet; }
  template <typename UnpredictableNumberT = Aws::String>
  void SetUnpredictableNumber(UnpredictableNumberT&& value) {
    m_unpredictableNumberHasBeenSet = true;
    m_unpredictableNumber = std::forward<UnpredictableNumberT>(value);
  }
  template <typename UnpredictableNumberT = Aws::String>
  DiscoverDynamicCardVerificationCode& WithUnpredictableNumber(UnpredictableNumberT&& value) {
    SetUnpredictableNumber(std::forward<UnpredictableNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The transaction counter value that comes from the terminal.</p>
   */
  inline const Aws::String& GetApplicationTransactionCounter() const { return m_applicationTransactionCounter; }
  inline bool ApplicationTransactionCounterHasBeenSet() const { return m_applicationTransactionCounterHasBeenSet; }
  template <typename ApplicationTransactionCounterT = Aws::String>
  void SetApplicationTransactionCounter(ApplicationTransactionCounterT&& value) {
    m_applicationTransactionCounterHasBeenSet = true;
    m_applicationTransactionCounter = std::forward<ApplicationTransactionCounterT>(value);
  }
  template <typename ApplicationTransactionCounterT = Aws::String>
  DiscoverDynamicCardVerificationCode& WithApplicationTransactionCounter(ApplicationTransactionCounterT&& value) {
    SetApplicationTransactionCounter(std::forward<ApplicationTransactionCounterT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_cardExpiryDate;

  Aws::String m_unpredictableNumber;

  Aws::String m_applicationTransactionCounter;
  bool m_cardExpiryDateHasBeenSet = false;
  bool m_unpredictableNumberHasBeenSet = false;
  bool m_applicationTransactionCounterHasBeenSet = false;
};

}  // namespace Model
}  // namespace PaymentCryptographyData
}  // namespace Aws
