﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/osis/OSIS_EXPORTS.h>
#include <aws/osis/model/PipelineSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace OSIS {
namespace Model {
class ListPipelinesResult {
 public:
  AWS_OSIS_API ListPipelinesResult() = default;
  AWS_OSIS_API ListPipelinesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OSIS_API ListPipelinesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>When <code>nextToken</code> is returned, there are more results available.
   * The value of <code>nextToken</code> is a unique pagination token for each page.
   * Make the call again using the returned token to retrieve the next page.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPipelinesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of all existing Data Prepper pipelines.</p>
   */
  inline const Aws::Vector<PipelineSummary>& GetPipelines() const { return m_pipelines; }
  template <typename PipelinesT = Aws::Vector<PipelineSummary>>
  void SetPipelines(PipelinesT&& value) {
    m_pipelinesHasBeenSet = true;
    m_pipelines = std::forward<PipelinesT>(value);
  }
  template <typename PipelinesT = Aws::Vector<PipelineSummary>>
  ListPipelinesResult& WithPipelines(PipelinesT&& value) {
    SetPipelines(std::forward<PipelinesT>(value));
    return *this;
  }
  template <typename PipelinesT = PipelineSummary>
  ListPipelinesResult& AddPipelines(PipelinesT&& value) {
    m_pipelinesHasBeenSet = true;
    m_pipelines.emplace_back(std::forward<PipelinesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPipelinesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<PipelineSummary> m_pipelines;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_pipelinesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace OSIS
}  // namespace Aws
