﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackage-vod/MediaPackageVodRequest.h>
#include <aws/mediapackage-vod/MediaPackageVod_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace MediaPackageVod {
namespace Model {

/**
 */
class ListPackagingConfigurationsRequest : public MediaPackageVodRequest {
 public:
  AWS_MEDIAPACKAGEVOD_API ListPackagingConfigurationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListPackagingConfigurations"; }

  AWS_MEDIAPACKAGEVOD_API Aws::String SerializePayload() const override;

  AWS_MEDIAPACKAGEVOD_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * Upper bound on number of records to return.
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListPackagingConfigurationsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * A token used to resume pagination from the end of a previous request.
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPackagingConfigurationsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Returns MediaPackage VOD PackagingConfigurations associated with the specified
   * PackagingGroup.
   */
  inline const Aws::String& GetPackagingGroupId() const { return m_packagingGroupId; }
  inline bool PackagingGroupIdHasBeenSet() const { return m_packagingGroupIdHasBeenSet; }
  template <typename PackagingGroupIdT = Aws::String>
  void SetPackagingGroupId(PackagingGroupIdT&& value) {
    m_packagingGroupIdHasBeenSet = true;
    m_packagingGroupId = std::forward<PackagingGroupIdT>(value);
  }
  template <typename PackagingGroupIdT = Aws::String>
  ListPackagingConfigurationsRequest& WithPackagingGroupId(PackagingGroupIdT&& value) {
    SetPackagingGroupId(std::forward<PackagingGroupIdT>(value));
    return *this;
  }
  ///@}
 private:
  int m_maxResults{0};

  Aws::String m_nextToken;

  Aws::String m_packagingGroupId;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_packagingGroupIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
