﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>
#include <aws/frauddetector/model/ModelTypeEnum.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FraudDetector {
namespace Model {

/**
 * <p>The model version.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ModelVersion">AWS
 * API Reference</a></p>
 */
class ModelVersion {
 public:
  AWS_FRAUDDETECTOR_API ModelVersion() = default;
  AWS_FRAUDDETECTOR_API ModelVersion(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API ModelVersion& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FRAUDDETECTOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The model ID.</p>
   */
  inline const Aws::String& GetModelId() const { return m_modelId; }
  inline bool ModelIdHasBeenSet() const { return m_modelIdHasBeenSet; }
  template <typename ModelIdT = Aws::String>
  void SetModelId(ModelIdT&& value) {
    m_modelIdHasBeenSet = true;
    m_modelId = std::forward<ModelIdT>(value);
  }
  template <typename ModelIdT = Aws::String>
  ModelVersion& WithModelId(ModelIdT&& value) {
    SetModelId(std::forward<ModelIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The model type.</p>
   */
  inline ModelTypeEnum GetModelType() const { return m_modelType; }
  inline bool ModelTypeHasBeenSet() const { return m_modelTypeHasBeenSet; }
  inline void SetModelType(ModelTypeEnum value) {
    m_modelTypeHasBeenSet = true;
    m_modelType = value;
  }
  inline ModelVersion& WithModelType(ModelTypeEnum value) {
    SetModelType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The model version number.</p>
   */
  inline const Aws::String& GetModelVersionNumber() const { return m_modelVersionNumber; }
  inline bool ModelVersionNumberHasBeenSet() const { return m_modelVersionNumberHasBeenSet; }
  template <typename ModelVersionNumberT = Aws::String>
  void SetModelVersionNumber(ModelVersionNumberT&& value) {
    m_modelVersionNumberHasBeenSet = true;
    m_modelVersionNumber = std::forward<ModelVersionNumberT>(value);
  }
  template <typename ModelVersionNumberT = Aws::String>
  ModelVersion& WithModelVersionNumber(ModelVersionNumberT&& value) {
    SetModelVersionNumber(std::forward<ModelVersionNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The model version ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ModelVersion& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_modelId;

  ModelTypeEnum m_modelType{ModelTypeEnum::NOT_SET};

  Aws::String m_modelVersionNumber;

  Aws::String m_arn;
  bool m_modelIdHasBeenSet = false;
  bool m_modelTypeHasBeenSet = false;
  bool m_modelVersionNumberHasBeenSet = false;
  bool m_arnHasBeenSet = false;
};

}  // namespace Model
}  // namespace FraudDetector
}  // namespace Aws
