﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dax/DAX_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DAX {
namespace Model {

/**
 * <p>Represents the information required for client programs to connect to the
 * endpoint for a DAX cluster.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/Endpoint">AWS API
 * Reference</a></p>
 */
class Endpoint {
 public:
  AWS_DAX_API Endpoint() = default;
  AWS_DAX_API Endpoint(Aws::Utils::Json::JsonView jsonValue);
  AWS_DAX_API Endpoint& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DAX_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The DNS hostname of the endpoint.</p>
   */
  inline const Aws::String& GetAddress() const { return m_address; }
  inline bool AddressHasBeenSet() const { return m_addressHasBeenSet; }
  template <typename AddressT = Aws::String>
  void SetAddress(AddressT&& value) {
    m_addressHasBeenSet = true;
    m_address = std::forward<AddressT>(value);
  }
  template <typename AddressT = Aws::String>
  Endpoint& WithAddress(AddressT&& value) {
    SetAddress(std::forward<AddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The port number that applications should use to connect to the endpoint.</p>
   */
  inline int GetPort() const { return m_port; }
  inline bool PortHasBeenSet() const { return m_portHasBeenSet; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline Endpoint& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL that applications should use to connect to the endpoint. The default
   * ports are 8111 for the "dax" protocol and 9111 for the "daxs" protocol.</p>
   */
  inline const Aws::String& GetURL() const { return m_uRL; }
  inline bool URLHasBeenSet() const { return m_uRLHasBeenSet; }
  template <typename URLT = Aws::String>
  void SetURL(URLT&& value) {
    m_uRLHasBeenSet = true;
    m_uRL = std::forward<URLT>(value);
  }
  template <typename URLT = Aws::String>
  Endpoint& WithURL(URLT&& value) {
    SetURL(std::forward<URLT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_address;

  int m_port{0};

  Aws::String m_uRL;
  bool m_addressHasBeenSet = false;
  bool m_portHasBeenSet = false;
  bool m_uRLHasBeenSet = false;
};

}  // namespace Model
}  // namespace DAX
}  // namespace Aws
