﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/databrew/GlueDataBrew_EXPORTS.h>
#include <aws/databrew/model/Recipe.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GlueDataBrew {
namespace Model {
class ListRecipeVersionsResult {
 public:
  AWS_GLUEDATABREW_API ListRecipeVersionsResult() = default;
  AWS_GLUEDATABREW_API ListRecipeVersionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUEDATABREW_API ListRecipeVersionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A token that you can use in a subsequent call to retrieve the next set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRecipeVersionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of versions for the specified recipe.</p>
   */
  inline const Aws::Vector<Recipe>& GetRecipes() const { return m_recipes; }
  template <typename RecipesT = Aws::Vector<Recipe>>
  void SetRecipes(RecipesT&& value) {
    m_recipesHasBeenSet = true;
    m_recipes = std::forward<RecipesT>(value);
  }
  template <typename RecipesT = Aws::Vector<Recipe>>
  ListRecipeVersionsResult& WithRecipes(RecipesT&& value) {
    SetRecipes(std::forward<RecipesT>(value));
    return *this;
  }
  template <typename RecipesT = Recipe>
  ListRecipeVersionsResult& AddRecipes(RecipesT&& value) {
    m_recipesHasBeenSet = true;
    m_recipes.emplace_back(std::forward<RecipesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRecipeVersionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<Recipe> m_recipes;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_recipesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GlueDataBrew
}  // namespace Aws
