﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/ce/model/CostCategory.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CostExplorer {
namespace Model {
class DescribeCostCategoryDefinitionResult {
 public:
  AWS_COSTEXPLORER_API DescribeCostCategoryDefinitionResult() = default;
  AWS_COSTEXPLORER_API DescribeCostCategoryDefinitionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COSTEXPLORER_API DescribeCostCategoryDefinitionResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const CostCategory& GetCostCategory() const { return m_costCategory; }
  template <typename CostCategoryT = CostCategory>
  void SetCostCategory(CostCategoryT&& value) {
    m_costCategoryHasBeenSet = true;
    m_costCategory = std::forward<CostCategoryT>(value);
  }
  template <typename CostCategoryT = CostCategory>
  DescribeCostCategoryDefinitionResult& WithCostCategory(CostCategoryT&& value) {
    SetCostCategory(std::forward<CostCategoryT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCostCategoryDefinitionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  CostCategory m_costCategory;

  Aws::String m_requestId;
  bool m_costCategoryHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
