﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agentcore-control/BedrockAgentCoreControl_EXPORTS.h>
#include <aws/bedrock-agentcore-control/model/MemorySummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentCoreControl {
namespace Model {
class ListMemoriesResult {
 public:
  AWS_BEDROCKAGENTCORECONTROL_API ListMemoriesResult() = default;
  AWS_BEDROCKAGENTCORECONTROL_API ListMemoriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKAGENTCORECONTROL_API ListMemoriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of AgentCore Memory resource summaries.</p>
   */
  inline const Aws::Vector<MemorySummary>& GetMemories() const { return m_memories; }
  template <typename MemoriesT = Aws::Vector<MemorySummary>>
  void SetMemories(MemoriesT&& value) {
    m_memoriesHasBeenSet = true;
    m_memories = std::forward<MemoriesT>(value);
  }
  template <typename MemoriesT = Aws::Vector<MemorySummary>>
  ListMemoriesResult& WithMemories(MemoriesT&& value) {
    SetMemories(std::forward<MemoriesT>(value));
    return *this;
  }
  template <typename MemoriesT = MemorySummary>
  ListMemoriesResult& AddMemories(MemoriesT&& value) {
    m_memoriesHasBeenSet = true;
    m_memories.emplace_back(std::forward<MemoriesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token to retrieve the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListMemoriesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListMemoriesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<MemorySummary> m_memories;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_memoriesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentCoreControl
}  // namespace Aws
