﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/batch/Batch_EXPORTS.h>
#include <aws/batch/model/ArrayJobDependency.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Batch {
namespace Model {

/**
 * <p>An object that represents an Batch job dependency.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDependency">AWS
 * API Reference</a></p>
 */
class JobDependency {
 public:
  AWS_BATCH_API JobDependency() = default;
  AWS_BATCH_API JobDependency(Aws::Utils::Json::JsonView jsonValue);
  AWS_BATCH_API JobDependency& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BATCH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The job ID of the Batch job that's associated with this dependency.</p>
   */
  inline const Aws::String& GetJobId() const { return m_jobId; }
  inline bool JobIdHasBeenSet() const { return m_jobIdHasBeenSet; }
  template <typename JobIdT = Aws::String>
  void SetJobId(JobIdT&& value) {
    m_jobIdHasBeenSet = true;
    m_jobId = std::forward<JobIdT>(value);
  }
  template <typename JobIdT = Aws::String>
  JobDependency& WithJobId(JobIdT&& value) {
    SetJobId(std::forward<JobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the job dependency.</p>
   */
  inline ArrayJobDependency GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(ArrayJobDependency value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline JobDependency& WithType(ArrayJobDependency value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_jobId;

  ArrayJobDependency m_type{ArrayJobDependency::NOT_SET};
  bool m_jobIdHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Batch
}  // namespace Aws
