﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appintegrations/AppIntegrationsService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppIntegrationsService {
namespace Model {

/**
 * <p>Summary information about the DataIntegration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DataIntegrationSummary">AWS
 * API Reference</a></p>
 */
class DataIntegrationSummary {
 public:
  AWS_APPINTEGRATIONSSERVICE_API DataIntegrationSummary() = default;
  AWS_APPINTEGRATIONSSERVICE_API DataIntegrationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPINTEGRATIONSSERVICE_API DataIntegrationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPINTEGRATIONSSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the DataIntegration.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DataIntegrationSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the DataIntegration.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DataIntegrationSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URI of the data source.</p>
   */
  inline const Aws::String& GetSourceURI() const { return m_sourceURI; }
  inline bool SourceURIHasBeenSet() const { return m_sourceURIHasBeenSet; }
  template <typename SourceURIT = Aws::String>
  void SetSourceURI(SourceURIT&& value) {
    m_sourceURIHasBeenSet = true;
    m_sourceURI = std::forward<SourceURIT>(value);
  }
  template <typename SourceURIT = Aws::String>
  DataIntegrationSummary& WithSourceURI(SourceURIT&& value) {
    SetSourceURI(std::forward<SourceURIT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_sourceURI;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_sourceURIHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppIntegrationsService
}  // namespace Aws
