/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCloseWatcher.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortSignal.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CloseWatcher::Options>> convertDictionary<CloseWatcher::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CloseWatcher::Options result;
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!signalValue.isUndefined()) {
        auto signalConversionResult = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        if (signalConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.signal = signalConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_requestClose);
static JSC_DECLARE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_close);
static JSC_DECLARE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_destroy);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCloseWatcherConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCloseWatcher_oncancel);
static JSC_DECLARE_CUSTOM_SETTER(setJSCloseWatcher_oncancel);
static JSC_DECLARE_CUSTOM_GETTER(jsCloseWatcher_onclose);
static JSC_DECLARE_CUSTOM_SETTER(setJSCloseWatcher_onclose);

class JSCloseWatcherPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCloseWatcherPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCloseWatcherPrototype* ptr = new (NotNull, JSC::allocateCell<JSCloseWatcherPrototype>(vm)) JSCloseWatcherPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCloseWatcherPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCloseWatcherPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCloseWatcherPrototype, JSCloseWatcherPrototype::Base);

using JSCloseWatcherDOMConstructor = JSDOMConstructor<JSCloseWatcher>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCloseWatcherDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCloseWatcherDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "CloseWatcher"_s);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<CloseWatcher::Options>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = CloseWatcher::create(*context, optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CloseWatcher>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CloseWatcher>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCloseWatcherDOMConstructorConstruct, JSCloseWatcherDOMConstructor::construct);

template<> const ClassInfo JSCloseWatcherDOMConstructor::s_info = { "CloseWatcher"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCloseWatcherDOMConstructor) };

template<> JSValue JSCloseWatcherDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSCloseWatcherDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CloseWatcher"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCloseWatcher::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSCloseWatcherPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCloseWatcherConstructor, 0 } },
    HashTableValue { "oncancel"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCloseWatcher_oncancel, setJSCloseWatcher_oncancel } },
    HashTableValue { "onclose"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCloseWatcher_onclose, setJSCloseWatcher_onclose } },
    HashTableValue { "requestClose"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCloseWatcherPrototypeFunction_requestClose, 0 } },
    HashTableValue { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCloseWatcherPrototypeFunction_close, 0 } },
    HashTableValue { "destroy"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCloseWatcherPrototypeFunction_destroy, 0 } },
};

const ClassInfo JSCloseWatcherPrototype::s_info = { "CloseWatcher"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCloseWatcherPrototype) };

void JSCloseWatcherPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCloseWatcher::info(), JSCloseWatcherPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCloseWatcher::s_info = { "CloseWatcher"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCloseWatcher) };

JSCloseWatcher::JSCloseWatcher(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CloseWatcher>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<CloseWatcher> JSCloseWatcher::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, CloseWatcher>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSCloseWatcher::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCloseWatcherPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCloseWatcherPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCloseWatcher::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCloseWatcher>(vm, globalObject);
}

JSValue JSCloseWatcher::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCloseWatcherDOMConstructor, DOMConstructorID::CloseWatcher>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCloseWatcherConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCloseWatcherPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCloseWatcher::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCloseWatcher_oncancelGetter(JSGlobalObject& lexicalGlobalObject, JSCloseWatcher& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().cancelEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCloseWatcher_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCloseWatcher>::get<jsCloseWatcher_oncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCloseWatcher_oncancelSetter(JSGlobalObject& lexicalGlobalObject, JSCloseWatcher& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().cancelEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCloseWatcher_oncancel, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCloseWatcher>::set<setJSCloseWatcher_oncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCloseWatcher_oncloseGetter(JSGlobalObject& lexicalGlobalObject, JSCloseWatcher& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().closeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCloseWatcher_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCloseWatcher>::get<jsCloseWatcher_oncloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCloseWatcher_oncloseSetter(JSGlobalObject& lexicalGlobalObject, JSCloseWatcher& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().closeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCloseWatcher_onclose, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCloseWatcher>::set<setJSCloseWatcher_oncloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsCloseWatcherPrototypeFunction_requestCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCloseWatcher>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.requestClose(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_requestClose, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCloseWatcher>::call<jsCloseWatcherPrototypeFunction_requestCloseBody>(*lexicalGlobalObject, *callFrame, "requestClose");
}

static inline JSC::EncodedJSValue jsCloseWatcherPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCloseWatcher>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.close(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCloseWatcher>::call<jsCloseWatcherPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsCloseWatcherPrototypeFunction_destroyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCloseWatcher>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.destroy(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCloseWatcherPrototypeFunction_destroy, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCloseWatcher>::call<jsCloseWatcherPrototypeFunction_destroyBody>(*lexicalGlobalObject, *callFrame, "destroy");
}

JSC::GCClient::IsoSubspace* JSCloseWatcher::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCloseWatcher, UseCustomHeapCellType::No>(vm, "JSCloseWatcher"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCloseWatcher.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCloseWatcher = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCloseWatcher.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCloseWatcher = std::forward<decltype(space)>(space); }
    );
}

void JSCloseWatcher::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCloseWatcher*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCloseWatcherOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsCloseWatcher = jsCast<JSCloseWatcher*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsCloseWatcher->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCloseWatcherOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCloseWatcher = static_cast<JSCloseWatcher*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCloseWatcher->protectedWrapped().ptr(), jsCloseWatcher);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CloseWatcher@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12CloseWatcherE[]; }
#endif
template<std::same_as<CloseWatcher> T>
static inline void verifyVTable(CloseWatcher* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CloseWatcher@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12CloseWatcherE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CloseWatcher has subclasses. If CloseWatcher has subclasses that get passed
        // to toJS() we currently require CloseWatcher you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CloseWatcher>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CloseWatcher>(impl.ptr());
#endif
    return createWrapper<CloseWatcher>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CloseWatcher& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CloseWatcher* JSCloseWatcher::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCloseWatcher*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
