/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioProcessingEventInit.h"

#include "JSAudioBuffer.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AudioProcessingEventInit>> convertDictionary<AudioProcessingEventInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AudioProcessingEventInit result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue inputBufferValue;
    if (isNullOrUndefined)
        inputBufferValue = jsUndefined();
    else {
        inputBufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inputBuffer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (inputBufferValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "inputBuffer"_s, "AudioProcessingEventInit"_s, "AudioBuffer"_s);
        return ConversionResultException { };
    }
    auto inputBufferConversionResult = convert<IDLInterface<AudioBuffer>>(lexicalGlobalObject, inputBufferValue);
    if (inputBufferConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.inputBuffer = inputBufferConversionResult.releaseReturnValue();
    JSValue outputBufferValue;
    if (isNullOrUndefined)
        outputBufferValue = jsUndefined();
    else {
        outputBufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "outputBuffer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (outputBufferValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "outputBuffer"_s, "AudioProcessingEventInit"_s, "AudioBuffer"_s);
        return ConversionResultException { };
    }
    auto outputBufferConversionResult = convert<IDLInterface<AudioBuffer>>(lexicalGlobalObject, outputBufferValue);
    if (outputBufferConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.outputBuffer = outputBufferConversionResult.releaseReturnValue();
    JSValue playbackTimeValue;
    if (isNullOrUndefined)
        playbackTimeValue = jsUndefined();
    else {
        playbackTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "playbackTime"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (playbackTimeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "playbackTime"_s, "AudioProcessingEventInit"_s, "double"_s);
        return ConversionResultException { };
    }
    auto playbackTimeConversionResult = convert<IDLDouble>(lexicalGlobalObject, playbackTimeValue);
    if (playbackTimeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.playbackTime = playbackTimeConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
