// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off
#include <QJSValue>
#include <QObject>
#include <QProperty>
#include <qqmlregistration.h>


#include <properties/BackgroundProperty.h>

#include "ImagePropertyGroup.h"
// clang-format on

class QuickStyle;

/*!
 * \qmltype BackgroundPropertyGroup
 * \inqmlmodule org.kde.union.impl
 * \ingroup qtquick-properties
 *
 * \brief A group object exposing the properties of BackgroundProperty to QML.
 */
class BackgroundPropertyGroup : public QObject
{
    Q_OBJECT
    QML_ANONYMOUS

public:
    explicit BackgroundPropertyGroup(QuickStyle *style);

    void update(const std::optional<Union::Properties::BackgroundProperty> &newState);
    Q_SIGNAL void updated();

    /*!
     * \qmlproperty Union::Color BackgroundPropertyGroup::color
     *
     * Exposes BackgroundProperty::color to QML.
     */
    Q_PROPERTY(QJSValue color READ color NOTIFY colorChanged)
    QJSValue color() const;
    Q_SIGNAL void colorChanged();

    /*!
     * \qmlproperty ImagePropertyGroup BackgroundPropertyGroup::image
     *
     * Exposes BackgroundProperty::ImageProperty to QML.
     */
    Q_PROPERTY(ImagePropertyGroup *image READ image CONSTANT)
    ImagePropertyGroup *image() const;

private:
    QuickStyle *m_style = nullptr;
    std::unique_ptr<ImagePropertyGroup> m_image;

    inline static std::optional<Union::Properties::BackgroundProperty> nullValue = std::nullopt;
    std::optional<Union::Properties::BackgroundProperty> &m_state = nullValue;
};