/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "StaticComponents.h"

#include "mozilla/ArrayUtils.h"
#ifdef MOZ_BACKGROUNDTASKS
#  include "mozilla/BackgroundTasks.h"
#endif
#include "mozilla/PerfectHash.h"
#include "mozilla/ResultExtensions.h"
#include "mozilla/StaticPtr.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozJSModuleLoader.h"
#include "nsCOMPtr.h"
#include "nsComponentManager.h"
#include "nsContentUtils.h"
#include "nsIFactory.h"
#include "nsISupports.h"
#include "nsIXPConnect.h"
#include "nsString.h"
#include "nsStringEnumerator.h"
#include "nsTArray.h"
#include "xptdata.h"
#include "xptinfo.h"
#include "js/PropertyAndElement.h"  // JS_GetProperty

// Cleanup pollution from zipstruct.h
#undef UNSUPPORTED

// Public includes
#include "CacheStorageService.h"
#include "ContentHandlerService.h"
#include "GMPService.h"
#include "ImageBlocker.h"
#include "NSSErrorsService.h"
#include "PaymentRequestData.h"
#include "PaymentRequestService.h"
#include "ProcessToolsService.h"
#include "imgLoader.h"
#include "imgRequestProxy.h"
#include "mozilla/AddonContentPolicy.h"
#include "mozilla/AddonManagerStartup.h"
#include "mozilla/AlertNotification.h"
#include "mozilla/BackgroundTasks.h"
#include "mozilla/BackgroundTasksRunner.h"
#include "mozilla/CascadeFilter.h"
#include "mozilla/ContentBlockingTelemetryService.h"
#include "mozilla/DAPTelemetry.h"
#include "mozilla/ExtensionPolicyService.h"
#include "mozilla/FOG.h"
#include "mozilla/FinalizationWitnessService.h"
#include "mozilla/IdentityCredentialStorageService.h"
#include "mozilla/LoadContextInfo.h"
#include "mozilla/MediaManager.h"
#include "mozilla/Preferences.h"
#include "mozilla/RddProcessTest.h"
#include "mozilla/ScriptableContentIterator.h"
#include "mozilla/StaticPtr.h"
#include "mozilla/Telemetry.h"
#include "mozilla/TextInputProcessor.h"
#include "mozilla/URLQueryStringStripper.h"
#include "mozilla/dom/BlobURL.h"
#include "mozilla/dom/BlobURLProtocolHandler.h"
#include "mozilla/dom/EventSourceEventService.h"
#include "mozilla/dom/FakeSpeechRecognitionService.h"
#include "mozilla/dom/IndexedDatabaseManager.h"
#include "mozilla/dom/IntegrityPolicy.h"
#include "mozilla/dom/IntegrityPolicyService.h"
#include "mozilla/dom/OnlineSpeechRecognitionService.h"
#include "mozilla/dom/PolicyContainer.h"
#include "mozilla/dom/PushNotifier.h"
#include "mozilla/dom/ReferrerInfo.h"
#include "mozilla/dom/SDBConnection.h"
#include "mozilla/dom/ServiceWorkerManager.h"
#include "mozilla/dom/StorageActivityService.h"
#include "mozilla/dom/WorkerDebuggerManager.h"
#include "mozilla/dom/notification/NotificationHandler.h"
#include "mozilla/dom/nsCSPContext.h"
#include "mozilla/dom/nsCSPService.h"
#include "mozilla/dom/nsContentSecurityManager.h"
#include "mozilla/dom/nsMixedContentBlocker.h"
#include "mozilla/dom/nsSynthVoiceRegistry.h"
#include "mozilla/dom/power/PowerManagerService.h"
#include "mozilla/dom/quota/QuotaManagerService.h"
#include "mozilla/extensions/ExtensionsChild.h"
#include "mozilla/extensions/NativeMessagingPortal.h"
#include "mozilla/extensions/WebNavigationContent.h"
#include "mozilla/intl/LocaleService.h"
#include "mozilla/intl/OSPreferences.h"
#include "mozilla/ipc/UtilityProcessTest.h"
#include "mozilla/ml/MLUtils.h"
#include "mozilla/net/CachePurgeLock.h"
#include "mozilla/net/CaptivePortalService.h"
#include "mozilla/net/ChannelClassifierService.h"
#include "mozilla/net/CookieJarSettings.h"
#include "mozilla/net/Dashboard.h"
#include "mozilla/net/ExtensionProtocolHandler.h"
#include "mozilla/net/NetworkConnectivityService.h"
#include "mozilla/net/PageThumbProtocolHandler.h"
#include "mozilla/net/Predictor.h"
#include "mozilla/net/SFVService.h"
#include "mozilla/net/SubstitutingJARURI.h"
#include "mozilla/net/SubstitutingURL.h"
#include "mozilla/net/UrlClassifierExceptionList.h"
#include "mozilla/net/UrlClassifierExceptionListEntry.h"
#include "mozilla/net/WebSocketEventService.h"
#include "mozilla/net/nsFileProtocolHandler.h"
#include "mozilla/nsMemoryInfoDumper.h"
#include "mozilla/places/History.h"
#include "mozilla/places/PageIconProtocolHandler.h"
#include "mozilla/places/SyncedBookmarksMirror.h"
#include "mozilla/widget/ScreenManager.h"
#include "nsAppRunner.h"
#include "nsArray.h"
#include "nsBrowserStatusFilter.h"
#include "nsClientAuthRemember.h"
#include "nsConverterInputStream.h"
#include "nsDebugImpl.h"
#include "nsDeviceSensors.h"
#include "nsDirectoryService.h"
#include "nsDocLoader.h"
#include "nsExternalHelperAppService.h"
#include "nsFileStreams.h"
#include "nsGIOProtocolHandler.h"
#include "nsHashPropertyBag.h"
#include "nsInputStreamPump.h"
#include "nsJARURI.h"
#include "nsJSProtocolHandler.h"
#include "nsMIMEInputStream.h"
#include "nsMediaSniffer.h"
#include "nsMultiplexInputStream.h"
#include "nsNSSCertificate.h"
#include "nsNSSComponent.h"
#include "nsOSPermissionRequest.h"
#include "nsOpenWindowInfo.h"
#include "nsParserUtils.h"
#include "nsProcess.h"
#include "nsScriptSecurityManager.h"
#include "nsScriptableInputStream.h"
#include "nsSerializationHelper.h"
#include "nsSimpleNestedURI.h"
#include "nsSimpleURI.h"
#include "nsStorageStream.h"
#include "nsStructuredCloneContainer.h"
#include "nsStyleSheetService.h"
#include "nsSupportsPrimitives.h"
#include "nsSystemInfo.h"
#include "nsTerminator.h"
#include "nsURILoader.h"
#include "nsURLParsers.h"
#include "nsUrlClassifierPrefixSet.h"
#include "nsVariant.h"
#include "nsWindowWatcher.h"
#include "transport/stun_socket_filter.h"

// Relative includes
#include "../../caps/ContentPrincipal.h"
#include "../../caps/ExpandedPrincipal.h"
#include "../../caps/NullPrincipal.h"
#include "../../caps/SystemPrincipal.h"
#include "../../chrome/nsChromeProtocolHandler.h"
#include "../../chrome/nsChromeRegistry.h"
#include "../../comm/calendar/base/src/TimezoneDatabase.h"
#include "../../comm/mail/components/shell/nsGNOMEShellService.h"
#include "../../comm/mailnews/addrbook/src/nsAbBooleanExpression.h"
#include "../../comm/mailnews/addrbook/src/nsAbCardProperty.h"
#include "../../comm/mailnews/addrbook/src/nsAbDirProperty.h"
#include "../../comm/mailnews/addrbook/src/nsAbDirectoryQuery.h"
#include "../../comm/mailnews/addrbook/src/nsAbDirectoryQueryProxy.h"
#include "../../comm/mailnews/addrbook/src/nsAbLDIFService.h"
#include "../../comm/mailnews/addrbook/src/nsLDAPURL.h"
#include "../../comm/mailnews/base/src/FolderLookupService.h"
#include "../../comm/mailnews/base/src/MailNewsDLF.h"
#include "../../comm/mailnews/base/src/nsCidProtocolHandler.h"
#include "../../comm/mailnews/base/src/nsMailAuthModule.h"
#include "../../comm/mailnews/base/src/nsMailDirProvider.h"
#include "../../comm/mailnews/base/src/nsMessenger.h"
#include "../../comm/mailnews/base/src/nsMessengerBootstrap.h"
#include "../../comm/mailnews/base/src/nsMessengerUnixIntegration.h"
#include "../../comm/mailnews/base/src/nsMsgAccount.h"
#include "../../comm/mailnews/base/src/nsMsgAccountManager.h"
#include "../../comm/mailnews/base/src/nsMsgBiffManager.h"
#include "../../comm/mailnews/base/src/nsMsgContentPolicy.h"
#include "../../comm/mailnews/base/src/nsMsgCopyService.h"
#include "../../comm/mailnews/base/src/nsMsgDBFolder.h"
#include "../../comm/mailnews/base/src/nsMsgDBView.h"
#include "../../comm/mailnews/base/src/nsMsgFolderCache.h"
#include "../../comm/mailnews/base/src/nsMsgFolderNotificationService.h"
#include "../../comm/mailnews/base/src/nsMsgGroupView.h"
#include "../../comm/mailnews/base/src/nsMsgIdentity.h"
#include "../../comm/mailnews/base/src/nsMsgMailNewsUrl.h"
#include "../../comm/mailnews/base/src/nsMsgMailSession.h"
#include "../../comm/mailnews/base/src/nsMsgOfflineManager.h"
#include "../../comm/mailnews/base/src/nsMsgProgress.h"
#include "../../comm/mailnews/base/src/nsMsgPurgeService.h"
#include "../../comm/mailnews/base/src/nsMsgQuickSearchDBView.h"
#include "../../comm/mailnews/base/src/nsMsgSearchDBView.h"
#include "../../comm/mailnews/base/src/nsMsgSpecialViews.h"
#include "../../comm/mailnews/base/src/nsMsgStatusFeedback.h"
#include "../../comm/mailnews/base/src/nsMsgTagService.h"
#include "../../comm/mailnews/base/src/nsMsgThreadedDBView.h"
#include "../../comm/mailnews/base/src/nsMsgUtils.h"
#include "../../comm/mailnews/base/src/nsMsgWindow.h"
#include "../../comm/mailnews/base/src/nsMsgXFVirtualFolderDBView.h"
#include "../../comm/mailnews/base/src/nsSpamSettings.h"
#include "../../comm/mailnews/base/src/nsStopwatch.h"
#include "../../comm/mailnews/base/src/nsSubscribableServer.h"
#include "../../comm/mailnews/base/src/nsUserInfo.h"
#include "../../comm/mailnews/compose/src/nsMsgAttachment.h"
#include "../../comm/mailnews/compose/src/nsMsgAttachmentData.h"
#include "../../comm/mailnews/compose/src/nsMsgCompFields.h"
#include "../../comm/mailnews/compose/src/nsMsgCompUtils.h"
#include "../../comm/mailnews/compose/src/nsMsgCompose.h"
#include "../../comm/mailnews/compose/src/nsMsgComposeContentHandler.h"
#include "../../comm/mailnews/compose/src/nsMsgComposeParams.h"
#include "../../comm/mailnews/compose/src/nsMsgComposeProgressParams.h"
#include "../../comm/mailnews/compose/src/nsMsgComposeService.h"
#include "../../comm/mailnews/compose/src/nsMsgCopy.h"
#include "../../comm/mailnews/compose/src/nsMsgQuote.h"
#include "../../comm/mailnews/compose/src/nsMsgSendLater.h"
#include "../../comm/mailnews/compose/src/nsMsgSendReport.h"
#include "../../comm/mailnews/compose/src/nsSmtpUrl.h"
#include "../../comm/mailnews/db/mork/nsMorkFactory.h"
#include "../../comm/mailnews/db/msgdb/public/nsImapMailDatabase.h"
#include "../../comm/mailnews/db/msgdb/public/nsMailDatabase.h"
#include "../../comm/mailnews/db/msgdb/public/nsMsgDatabase.h"
#include "../../comm/mailnews/db/msgdb/public/nsNewsDatabase.h"
#include "../../comm/mailnews/extensions/bayesian-spam-filter/nsBayesianFilter.h"
#include "../../comm/mailnews/extensions/fts3/nsFts3Tokenizer.h"
#include "../../comm/mailnews/extensions/mailviews/nsMsgMailViewList.h"
#include "../../comm/mailnews/extensions/mdn/nsMsgMdnGenerator.h"
#include "../../comm/mailnews/extensions/smime/nsCMS.h"
#include "../../comm/mailnews/extensions/smime/nsCMSSecureMessage.h"
#include "../../comm/mailnews/extensions/smime/nsCertGen.h"
#include "../../comm/mailnews/extensions/smime/nsCertPicker.h"
#include "../../comm/mailnews/extensions/smime/nsEncryptedSMIMEURIsService.h"
#include "../../comm/mailnews/extensions/smime/nsMsgComposeSecure.h"
#include "../../comm/mailnews/imap/src/nsAutoSyncManager.h"
#include "../../comm/mailnews/imap/src/nsImapHostSessionList.h"
#include "../../comm/mailnews/imap/src/nsImapIncomingServer.h"
#include "../../comm/mailnews/imap/src/nsImapMailFolder.h"
#include "../../comm/mailnews/imap/src/nsImapOfflineSync.h"
#include "../../comm/mailnews/imap/src/nsImapProtocol.h"
#include "../../comm/mailnews/imap/src/nsImapService.h"
#include "../../comm/mailnews/imap/src/nsImapUrl.h"
#include "../../comm/mailnews/import/src/MorkImport.h"
#include "../../comm/mailnews/import/src/nsImportService.h"
#include "../../comm/mailnews/intl/nsCharsetConverterManager.h"
#include "../../comm/mailnews/jsaccount/src/JaAbDirectory.h"
#include "../../comm/mailnews/jsaccount/src/JaCompose.h"
#include "../../comm/mailnews/jsaccount/src/JaIncomingServer.h"
#include "../../comm/mailnews/jsaccount/src/JaMsgFolder.h"
#include "../../comm/mailnews/jsaccount/src/JaUrl.h"
#include "../../comm/mailnews/local/src/nsLocalMailFolder.h"
#include "../../comm/mailnews/local/src/nsMailboxService.h"
#include "../../comm/mailnews/local/src/nsMailboxUrl.h"
#include "../../comm/mailnews/local/src/nsMsgBrkMBoxStore.h"
#include "../../comm/mailnews/local/src/nsMsgMaildirStore.h"
#include "../../comm/mailnews/local/src/nsNoIncomingServer.h"
#include "../../comm/mailnews/local/src/nsNoneService.h"
#include "../../comm/mailnews/local/src/nsParseMailbox.h"
#include "../../comm/mailnews/local/src/nsPop3Sink.h"
#include "../../comm/mailnews/local/src/nsPop3URL.h"
#include "../../comm/mailnews/local/src/nsRssIncomingServer.h"
#include "../../comm/mailnews/local/src/nsRssService.h"
#include "../../comm/mailnews/mime/cthandlers/pgpmime/nsPgpMimeMimeContentTypeHandler.h"
#include "../../comm/mailnews/mime/cthandlers/pgpmime/nsPgpMimeProxy.h"
#include "../../comm/mailnews/mime/emitters/nsMimeHtmlEmitter.h"
#include "../../comm/mailnews/mime/emitters/nsMimePlainEmitter.h"
#include "../../comm/mailnews/mime/emitters/nsMimeRawEmitter.h"
#include "../../comm/mailnews/mime/emitters/nsMimeXmlEmitter.h"
#include "../../comm/mailnews/mime/src/nsMimeObjectClassAccess.h"
#include "../../comm/mailnews/mime/src/nsStreamConverter.h"
#include "../../comm/mailnews/news/src/nsNewsFolder.h"
#include "../../comm/mailnews/news/src/nsNntpUrl.h"
#include "../../comm/mailnews/protocols/ews/src/EwsClient.h"
#include "../../comm/mailnews/protocols/ews/src/EwsFolder.h"
#include "../../comm/mailnews/protocols/ews/src/EwsIncomingServer.h"
#include "../../comm/mailnews/protocols/ews/src/EwsProtocolHandler.h"
#include "../../comm/mailnews/protocols/ews/src/EwsProtocolInfo.h"
#include "../../comm/mailnews/protocols/ews/src/EwsService.h"
#include "../../comm/mailnews/protocols/ews/src/nsEwsOutgoingServer.h"
#include "../../comm/mailnews/search/public/nsMsgSearchAdapter.h"
#include "../../comm/mailnews/search/public/nsMsgSearchTerm.h"
#include "../../comm/mailnews/search/src/nsMsgFilterService.h"
#include "../../comm/mailnews/search/src/nsMsgSearchSession.h"
#include "../../devtools/platform/JSDebugger.h"
#include "../../devtools/platform/nsJSInspector.h"
#include "../../docshell/base/nsAboutRedirector.h"
#include "../../docshell/base/nsWebNavigationInfo.h"
#include "../../docshell/build/nsDocShellModule.h"
#include "../../dom/base/ThirdPartyUtil.h"
#include "../../dom/base/nsDataDocumentContentPolicy.h"
#include "../../dom/base/nsNoDataProtocolContentPolicy.h"
#include "../../dom/bindings/nsScriptError.h"
#include "../../dom/geolocation/Geolocation.h"
#include "../../dom/ipc/LoginDetectionService.h"
#include "../../dom/media/webspeech/synth/speechd/SpeechDispatcherService.h"
#include "../../dom/media/webspeech/synth/test/nsFakeSynthServices.h"
#include "../../dom/payments/PaymentActionResponse.h"
#include "../../dom/quota/nsIndexedDBProtocolHandler.h"
#include "../../dom/webauthn/WebAuthnService.h"
#include "../../dom/webbrowserpersist/nsWebBrowserPersist.h"
#include "../../editor/txmgr/TransactionManager.h"
#include "../../extensions/permissions/PermissionDelegateHandler.h"
#include "../../extensions/permissions/PermissionManager.h"
#include "../../extensions/pref/autoconfig/src/nsReadConfig.h"
#include "../../extensions/spellcheck/src/mozPersonalDictionary.h"
#include "../../gfx/src/nsThebesFontEnumerator.h"
#include "../../image/build/nsImageModule.h"
#include "../../image/decoders/icon/nsIconProtocolHandler.h"
#include "../../image/decoders/icon/nsIconURI.h"
#include "../../image/encoders/bmp/nsBMPEncoder.h"
#include "../../image/encoders/ico/nsICOEncoder.h"
#include "../../image/encoders/jpeg/nsJPEGEncoder.h"
#include "../../image/encoders/png/nsPNGEncoder.h"
#include "../../image/encoders/webp/nsWebPEncoder.h"
#include "../../image/imgTools.h"
#include "../../intl/strres/nsStringBundleService.h"
#include "../../intl/uconv/nsConverterOutputStream.h"
#include "../../intl/uconv/nsScriptableUConv.h"
#include "../../intl/uconv/nsTextToSubURI.h"
#include "../../js/xpconnect/loader/mozJSSubScriptLoader.h"
#include "../../layout/build/nsLayoutModule.h"
#include "../../layout/inspector/inDeepTreeWalker.h"
#include "../../modules/libjar/nsJAR.h"
#include "../../modules/libjar/nsJARProtocolHandler.h"
#include "../../modules/libjar/zipwriter/nsDeflateConverter.h"
#include "../../modules/libjar/zipwriter/nsZipWriter.h"
#include "../../netwerk/base/ArrayBufferInputStream.h"
#include "../../netwerk/base/BackgroundFileSaver.h"
#include "../../netwerk/base/DefaultURI.h"
#include "../../netwerk/base/MockNetworkLayerController.h"
#include "../../netwerk/base/TLSServerSocket.h"
#include "../../netwerk/base/ThrottleQueue.h"
#include "../../netwerk/base/nsAsyncStreamCopier.h"
#include "../../netwerk/base/nsBufferedStreams.h"
#include "../../netwerk/base/nsDownloader.h"
#include "../../netwerk/base/nsIOService.h"
#include "../../netwerk/base/nsIncrementalStreamLoader.h"
#include "../../netwerk/base/nsInputStreamChannel.h"
#include "../../netwerk/base/nsProtocolProxyService.h"
#include "../../netwerk/base/nsServerSocket.h"
#include "../../netwerk/base/nsSimpleStreamListener.h"
#include "../../netwerk/base/nsSocketTransportService2.h"
#include "../../netwerk/base/nsStandardURL.h"
#include "../../netwerk/base/nsStreamListenerTee.h"
#include "../../netwerk/base/nsStreamLoader.h"
#include "../../netwerk/base/nsStreamTransportService.h"
#include "../../netwerk/base/nsUDPSocket.h"
#include "../../netwerk/build/nsNetModule.h"
#include "../../netwerk/cookie/CookieService.h"
#include "../../netwerk/dns/GetAddrInfo.h"
#include "../../netwerk/dns/nsDNSService2.h"
#include "../../netwerk/dns/nsEffectiveTLDService.h"
#include "../../netwerk/dns/nsIDNService.h"
#include "../../netwerk/mime/nsMIMEHeaderParamImpl.h"
#include "../../netwerk/protocol/about/nsAboutBlank.h"
#include "../../netwerk/protocol/about/nsAboutCache.h"
#include "../../netwerk/protocol/about/nsAboutCacheEntry.h"
#include "../../netwerk/protocol/about/nsAboutProtocolHandler.h"
#include "../../netwerk/protocol/data/nsDataHandler.h"
#include "../../netwerk/protocol/http/ObliviousHttpService.h"
#include "../../netwerk/protocol/http/ReplacedHttpResponse.h"
#include "../../netwerk/protocol/http/binary_http/src/binary_http.h"
#include "../../netwerk/protocol/http/nsCORSListenerProxy.h"
#include "../../netwerk/protocol/http/nsHttpActivityDistributor.h"
#include "../../netwerk/protocol/http/nsHttpAuthManager.h"
#include "../../netwerk/protocol/http/oblivious_http/src/oblivious_http.h"
#include "../../netwerk/protocol/res/MozSrcProtocolHandler.h"
#include "../../netwerk/protocol/res/nsResProtocolHandler.h"
#include "../../netwerk/protocol/viewsource/nsViewSourceHandler.h"
#include "../../netwerk/streamconv/converters/nsIndexedToHTML.h"
#include "../../netwerk/system/linux/nsNetworkLinkService.h"
#include "../../netwerk/wifi/nsWifiMonitor.h"
#include "../../security/certverifier/CRLiteTimestamp.h"
#include "../../security/manager/pki/nsNSSDialogs.h"
#include "../../security/manager/ssl/DataStorageManager.h"
#include "../../security/manager/ssl/PublicKeyPinningService.h"
#include "../../security/manager/ssl/cert_storage/src/cert_storage.h"
#include "../../security/manager/ssl/crypto_hash/crypto_hash.h"
#include "../../security/manager/ssl/nsCertOverrideService.h"
#include "../../security/manager/ssl/nsNSSModule.h"
#include "../../security/manager/ssl/nsNSSVersion.h"
#include "../../security/manager/ssl/nsSiteSecurityService.h"
#include "../../storage/VacuumManager.h"
#include "../../storage/mozStorageService.h"
#include "../../toolkit/components/alerts/nsAlertsService.h"
#include "../../toolkit/components/antitracking/ContentBlockingAllowList.h"
#include "../../toolkit/components/antitracking/bouncetrackingprotection/BounceTrackingProtection.h"
#include "../../toolkit/components/autocomplete/nsAutoCompleteController.h"
#include "../../toolkit/components/autocomplete/nsAutoCompleteSimpleResult.h"
#include "../../toolkit/components/browser/nsWebBrowserContentPolicy.h"
#include "../../toolkit/components/build/nsToolkitCompsModule.h"
#include "../../toolkit/components/contentanalysis/ContentAnalysis.h"
#include "../../toolkit/components/cookiebanners/nsCookieBannerRule.h"
#include "../../toolkit/components/cookiebanners/nsCookieBannerService.h"
#include "../../toolkit/components/cookiebanners/nsCookieBannerTelemetryService.h"
#include "../../toolkit/components/ctypes/ctypes.h"
#include "../../toolkit/components/downloads/DownloadPlatform.h"
#include "../../toolkit/components/find/nsFind.h"
#include "../../toolkit/components/find/nsFindService.h"
#include "../../toolkit/components/kvstore/nsKeyValueModule.h"
#include "../../toolkit/components/mozintl/MozIntlHelper.h"
#include "../../toolkit/components/parentalcontrols/nsParentalControlsService.h"
#include "../../toolkit/components/places/nsCachedFaviconProtocolHandler.h"
#include "../../toolkit/components/places/nsFaviconService.h"
#include "../../toolkit/components/places/nsNavBookmarks.h"
#include "../../toolkit/components/places/nsNavHistory.h"
#include "../../toolkit/components/reflect/reflect.h"
#include "../../toolkit/components/reputationservice/ApplicationReputation.h"
#include "../../toolkit/components/resistfingerprinting/nsRFPService.h"
#include "../../toolkit/components/resistfingerprinting/nsRFPTargetSetIDL.h"
#include "../../toolkit/components/satchel/nsFormFillController.h"
#include "../../toolkit/components/startup/nsAppStartup.h"
#include "../../toolkit/components/typeaheadfind/nsTypeAheadFind.h"
#include "../../toolkit/components/url-classifier/nsUrlClassifierStreamUpdater.h"
#include "../../toolkit/components/url-classifier/nsUrlClassifierUtils.h"
#include "../../toolkit/components/windowwatcher/nsDialogParamBlock.h"
#include "../../toolkit/profile/nsToolkitProfileService.h"
#include "../../toolkit/system/gnome/nsGIOService.h"
#include "../../toolkit/system/gnome/nsSystemAlertsService.h"
#include "../../toolkit/xre/nsXREDirProvider.h"
#include "../../tools/profiler/gecko/nsProfiler.h"
#include "../../uriloader/exthandler/nsDBusHandlerApp.h"
#include "../../uriloader/exthandler/nsExternalProtocolHandler.h"
#include "../../uriloader/exthandler/nsLocalHandlerApp.h"
#include "../../uriloader/prefetch/nsPrefetchService.h"
#include "../../widget/gtk/GfxInfo.h"
#include "../../widget/gtk/TaskbarProgress.h"
#include "../../widget/gtk/nsApplicationChooser.h"
#include "../../widget/gtk/nsColorPicker.h"
#include "../../widget/gtk/nsDeviceContextSpecG.h"
#include "../../widget/gtk/nsDragService.h"
#include "../../widget/gtk/nsFilePicker.h"
#include "../../widget/gtk/nsPrintDialogGTK.h"
#include "../../widget/gtk/nsPrintSettingsServiceGTK.h"
#include "../../widget/gtk/nsSound.h"
#include "../../widget/gtk/nsUserIdleServiceGTK.h"
#include "../../widget/gtk/nsWidgetFactory.h"
#include "../../widget/nsClipboardHelper.h"
#include "../../widget/nsClipboardProxy.h"
#include "../../widget/nsColorPickerProxy.h"
#include "../../widget/nsContentProcessWidgetFactory.h"
#include "../../widget/nsDragServiceProxy.h"
#include "../../widget/nsFilePickerProxy.h"
#include "../../widget/nsHTMLFormatConverter.h"
#include "../../widget/nsPrinterListCUPS.h"
#include "../../widget/nsTransferable.h"
#include "../../xpcom/base/AvailableMemoryWatcher.h"
#include "../../xpcom/base/nsConsoleService.h"
#include "../../xpcom/base/nsMemoryReporterManager.h"
#include "../../xpcom/base/nsSecurityConsoleMessage.h"
#include "../../xpcom/base/nsUUIDGenerator.h"
#include "../../xpcom/base/nsVersionComparatorImpl.h"
#include "../../xpcom/build/XPCOMModule.h"
#include "../../xpcom/components/nsCategoryManager.h"
#include "../../xpcom/components/nsComponentManager.h"
#include "../../xpcom/ds/nsINIParserImpl.h"
#include "../../xpcom/ds/nsObserverService.h"
#include "../../xpcom/io/nsBinaryStream.h"
#include "../../xpcom/io/nsIOUtil.h"
#include "../../xpcom/io/nsPipe.h"
#include "../../xpcom/io/nsScriptableBase64Encoder.h"
#include "../../xpcom/threads/nsEnvironment.h"
#include "../../xpcom/threads/nsTimerImpl.h"
#include "../../xpfe/appshell/nsAppShellService.h"
#include "../../xpfe/appshell/nsWindowMediator.h"

class ContentSignatureVerifier;
class OSKeyStore;
class OSReauthenticator;
class SecretDecoderRing;
class mozHunspell;
class mozISandboxReporter;
class mozISandboxSettings;
class nsCertTree;
class nsIAccessibilityService;
class nsIClipboard;
class nsIContentSerializer;
class nsIDocumentLoaderFactory;
class nsIDocumentViewer;
class nsIEventListenerService;
class nsIFocusManager;
class nsISessionStorageService;
class nsIStartupCacheInfo;
class nsISupports;
class nsITelemetry;
class nsNSSCertificateDB;
class nsPK11TokenDB;
class nsPrefLocalizedString;
class nsPrefOverrideMap;
class nsRandomGenerator;
class nsUnixSystemProxySettings;
namespace mozilla {
class PeerConnectionImpl;
namespace net {
class nsHttpHandler;
class nsHttpsHandler;
}  // namespace net
namespace psm {
class PKCS11ModuleDB;
class TransportSecurityInfo;
}  // namespace psm
}  // namespace mozilla

namespace mozilla {

using dom::AutoJSAPI;

namespace xpcom {

static constexpr uint32_t kNoContractID = 0xffffffff;

namespace {
// Template helpers for constructor function sanity checks.
template <typename T>
struct RemoveAlreadyAddRefed {
  using Type = T;
};

template <typename T>
struct RemoveAlreadyAddRefed<already_AddRefed<T>> {
  using Type = T;
};
}  // anonymous namespace


uint8_t gInvalidContracts[kContractCount / 8 + 1];

static StaticRefPtr<nsISupports> gServiceInstances[kStaticModuleCount];

uint8_t gInitCalled[kModuleInitCount / 8 + 1];

static const char gStrings[] =
    /* 0x0 */ "@mozilla.org/streamconv;1\0"
    /* 0x1a */ "?from=application/http-index-format&to=text/html\0"
    /* 0x4b */ "\0"
    /* 0x4c */ "?from=application/x-unknown-content-type&to=*/*\0"
    /* 0x7c */ "?from=br&to=uncompressed\0"
    /* 0x95 */ "?from=compress&to=uncompressed\0"
    /* 0xb4 */ "?from=deflate&to=uncompressed\0"
    /* 0xd2 */ "?from=gzip&to=uncompressed\0"
    /* 0xed */ "?from=multipart/byteranges&to=*/*\0"
    /* 0x10f */ "?from=multipart/mixed&to=*/*\0"
    /* 0x12c */ "?from=multipart/x-mixed-replace&to=*/*\0"
    /* 0x153 */ "?from=x-compress&to=uncompressed\0"
    /* 0x174 */ "?from=x-gzip&to=uncompressed\0"
    /* 0x191 */ "Gecko-Content-Viewers\0"
    /* 0x1a7 */ "application/http-index-format\0"
    /* 0x1c5 */ "@mozilla.org/content-viewers/http-index-format\0"
    /* 0x1f4 */ "application/mathml+xml\0"
    /* 0x20b */ "@mozilla.org/content/document-loader-factory;1\0"
    /* 0x23a */ "application/rdf+xml\0"
    /* 0x24e */ "application/vnd.wap.xhtml+xml\0"
    /* 0x26c */ "application/x-view-source\0"
    /* 0x286 */ "application/xhtml+xml\0"
    /* 0x29c */ "application/xml\0"
    /* 0x2ac */ "image/apng\0"
    /* 0x2b7 */ "image/bmp\0"
    /* 0x2c1 */ "image/gif\0"
    /* 0x2cb */ "image/icon\0"
    /* 0x2d6 */ "image/jpeg\0"
    /* 0x2e1 */ "image/jpg\0"
    /* 0x2eb */ "image/pjpeg\0"
    /* 0x2f7 */ "image/png\0"
    /* 0x301 */ "image/svg+xml\0"
    /* 0x30f */ "image/vnd.microsoft.icon\0"
    /* 0x328 */ "image/webp\0"
    /* 0x333 */ "image/x-icon\0"
    /* 0x340 */ "image/x-ms-bmp\0"
    /* 0x34f */ "image/x-png\0"
    /* 0x35b */ "message/rfc822\0"
    /* 0x36a */ "@mozilla.org/mailnews/document-loader-factory;1\0"
    /* 0x39a */ "text/html\0"
    /* 0x3a4 */ "text/plain\0"
    /* 0x3af */ "text/rdf\0"
    /* 0x3b8 */ "text/vtt\0"
    /* 0x3c1 */ "text/xml\0"
    /* 0x3ca */ "app-startup\0"
    /* 0x3d6 */ "ExtensionsChild\0"
    /* 0x3e6 */ "@mozilla.org/extensions/child;1\0"
    /* 0x406 */ "FormFillController\0"
    /* 0x419 */ "@mozilla.org/satchel/form-fill-controller;1\0"
    /* 0x445 */ "WebNavigationContent\0"
    /* 0x45a */ "@mozilla.org/extensions/web-navigation-content;1\0"
    /* 0x48b */ "cal-exporters\0"
    /* 0x499 */ "cal-html-list-exporter\0"
    /* 0x4b0 */ "@mozilla.org/calendar/export;1?type=htmllist\0"
    /* 0x4dd */ "cal-ics-exporter\0"
    /* 0x4ee */ "@mozilla.org/calendar/export;1?type=ics\0"
    /* 0x516 */ "cal-importers\0"
    /* 0x524 */ "cal-ics-importer\0"
    /* 0x535 */ "@mozilla.org/calendar/import;1?type=ics\0"
    /* 0x55d */ "command-line-handler\0"
    /* 0x572 */ "m-aaa-tb-devtools\0"
    /* 0x584 */ "@mozilla.org/messenger/devtools-startup-clh;1\0"
    /* 0x5b2 */ "m-backgroundtasks\0"
    /* 0x5c4 */ "@mozilla.org/backgroundtasksmanager;1\0"
    /* 0x5ea */ "m-compose\0"
    /* 0x5f4 */ "@mozilla.org/messengercompose;1\0"
    /* 0x614 */ "m-devtools\0"
    /* 0x61f */ "@mozilla.org/devtools/startup-clh;1\0"
    /* 0x643 */ "m-marionette\0"
    /* 0x650 */ "@mozilla.org/remote/marionette;1\0"
    /* 0x671 */ "m-remote\0"
    /* 0x67a */ "@mozilla.org/remote/agent;1\0"
    /* 0x696 */ "x-default\0"
    /* 0x6a0 */ "@mozilla.org/uriloader/content-handler;1?type=text/html\0"
    /* 0x6d8 */ "y-default\0"
    /* 0x6e2 */ "@mozilla.org/toolkit/default-clh;1\0"
    /* 0x705 */ "command-line-validator\0"
    /* 0x71c */ "b-default\0"
    /* 0x726 */ "content-policy\0"
    /* 0x735 */ "@mozilla.org/data-document-content-policy;1\0"
    /* 0x761 */ "@mozilla.org/embedding/browser/content-policy;1\0"
    /* 0x791 */ "@mozilla.org/image-blocker-content-policy;1\0"
    /* 0x7bd */ "@mozilla.org/integritypolicyservice;1\0"
    /* 0x7e3 */ "@mozilla.org/messenger/content-policy;1\0"
    /* 0x80b */ "@mozilla.org/mixedcontentblocker;1\0"
    /* 0x82e */ "@mozilla.org/no-data-protocol-content-policy;1\0"
    /* 0x85d */ "CSPService\0"
    /* 0x868 */ "@mozilla.org/cspservice;1\0"
    /* 0x882 */ "content-process-ready-for-script\0"
    /* 0x8a3 */ "TelemetryControllerContent\0"
    /* 0x8be */ "@mozilla.org/base/telemetry-controller-content;1\0"
    /* 0x8ef */ "content-sniffing-services\0"
    /* 0x909 */ "@mozilla.org/image/loader;1\0"
    /* 0x925 */ "@mozilla.org/image/cache;1\0"
    /* 0x940 */ "@mozilla.org/media/sniffer;1\0"
    /* 0x95d */ "idle-daily\0"
    /* 0x968 */ "BounceTrackingProtection\0"
    /* 0x981 */ "@mozilla.org/bounce-tracking-protection;1\0"
    /* 0x9ab */ "ContentBlockingTelemetryService\0"
    /* 0x9cb */ "@mozilla.org/content-blocking-telemetry-service;1\0"
    /* 0x9fd */ "MozStorage Vacuum Manager\0"
    /* 0xa17 */ "@mozilla.org/storage/vacuum;1\0"
    /* 0xa35 */ "PlacesDBUtilsIdleMaintenance\0"
    /* 0xa52 */ "@mozilla.org/places/databaseUtilsIdleMaintenance;1\0"
    /* 0xa85 */ "QuotaManagerService\0"
    /* 0xa99 */ "@mozilla.org/dom/quota-manager-service;1\0"
    /* 0xac2 */ "UrlClassifierExceptionListService\0"
    /* 0xae4 */ "@mozilla.org/url-classifier/exception-list-service;1\0"
    /* 0xb19 */ "nsCookieBannerService\0"
    /* 0xb2f */ "@mozilla.org/cookie-banner-service;1\0"
    /* 0xb54 */ "mailnews-accountmanager-extensions\0"
    /* 0xb77 */ "e2e-account-manager-extension\0"
    /* 0xb95 */ "@mozilla.org/accountmanager/extension;1?name=e2e\0"
    /* 0xbc6 */ "mdn-account-manager-extension\0"
    /* 0xbe4 */ "@mozilla.org/accountmanager/extension;1?name=mdn\0"
    /* 0xc15 */ "newsblog\0"
    /* 0xc1e */ "@mozilla.org/accountmanager/extension;1?name=newsblog\0"
    /* 0xc54 */ "mime-emitter\0"
    /* 0xc61 */ "@mozilla.org/messenger/mimeemitter;1?type=application/x-js-mime-message\0"
    /* 0xca9 */ "@mozilla.org/gloda/jsmimeemitter;1\0"
    /* 0xccc */ "@mozilla.org/messenger/mimeemitter;1?type=raw\0"
    /* 0xcfa */ "@mozilla.org/messenger/mimeemitter;1?type=text/html\0"
    /* 0xd2e */ "@mozilla.org/messenger/mimeemitter;1?type=text/plain\0"
    /* 0xd63 */ "@mozilla.org/messenger/mimeemitter;1?type=text/xml\0"
    /* 0xd96 */ "net-and-orb-content-sniffers\0"
    /* 0xdb3 */ "JSONView\0"
    /* 0xdbc */ "@mozilla.org/devtools/jsonview-sniffer;1\0"
    /* 0xde5 */ "net-channel-event-sinks\0"
    /* 0xdfd */ "net-content-sniffers\0"
    /* 0xe12 */ "Binary Detector\0"
    /* 0xe22 */ "@mozilla.org/network/binary-detector;1\0"
    /* 0xe49 */ "orb-content-sniffers\0"
    /* 0xe5e */ "payment-request\0"
    /* 0xe6e */ "BasicCardMethodChangeDetails\0"
    /* 0xe8b */ "@mozilla.org/dom/payments/basiccard-change-details;1\0"
    /* 0xec0 */ "BasicCardResponseData\0"
    /* 0xed6 */ "@mozilla.org/dom/payments/basiccard-response-data;1\0"
    /* 0xf0a */ "GeneralMethodChangeDetails\0"
    /* 0xf25 */ "@mozilla.org/dom/payments/general-change-details;1\0"
    /* 0xf58 */ "GeneralResponseData\0"
    /* 0xf6c */ "@mozilla.org/dom/payments/general-response-data;1\0"
    /* 0xf9e */ "PaymentAbortActionResponse\0"
    /* 0xfb9 */ "@mozilla.org/dom/payments/payment-abort-action-response;1\0"
    /* 0xff3 */ "PaymentAddress\0"
    /* 0x1002 */ "@mozilla.org/dom/payments/payment-address;1\0"
    /* 0x102e */ "PaymentCanMakeActionResponse\0"
    /* 0x104b */ "@mozilla.org/dom/payments/payment-canmake-action-response;1\0"
    /* 0x1087 */ "PaymentCompleteActionResponse\0"
    /* 0x10a5 */ "@mozilla.org/dom/payments/payment-complete-action-response;1\0"
    /* 0x10e2 */ "PaymentRequestService\0"
    /* 0x10f8 */ "@mozilla.org/dom/payments/payment-request-service;1\0"
    /* 0x112c */ "PaymentShowActionResponse\0"
    /* 0x1146 */ "@mozilla.org/dom/payments/payment-show-action-response;1\0"
    /* 0x117f */ "places-init-complete\0"
    /* 0x1194 */ "PlacesFrecencyRecalculator\0"
    /* 0x11af */ "@mozilla.org/places/frecency-recalculator;1\0"
    /* 0x11db */ "nsPlacesExpiration\0"
    /* 0x11ee */ "@mozilla.org/places/expiration;1\0"
    /* 0x120f */ "pref-config-startup\0"
    /* 0x1223 */ "ReadConfig Module\0"
    /* 0x1235 */ "@mozilla.org/readconfig;1\0"
    /* 0x124f */ "profile-after-change\0"
    /* 0x1264 */ "CrashMonitor\0"
    /* 0x1271 */ "@mozilla.org/toolkit/crashmonitor;1\0"
    /* 0x1295 */ "EssentialDomainsRemoteSettings\0"
    /* 0x12b4 */ "@mozilla.org/EssentialDomainsRemoteSettings;1\0"
    /* 0x12e2 */ "Marionette\0"
    /* 0x12ed */ "Offline-startup\0"
    /* 0x12fd */ "@mozilla.org/offline-startup;1\0"
    /* 0x131c */ "PurgeTrackerService\0"
    /* 0x1330 */ "@mozilla.org/purge-tracker-service;1\0"
    /* 0x1355 */ "RemoteAgent\0"
    /* 0x1361 */ "RemotePermissionService\0"
    /* 0x1379 */ "@mozilla.org/remote-permission-service;1\0"
    /* 0x13a2 */ "SimpleURIUnknownSchemesRemoteObserver\0"
    /* 0x13c8 */ "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1\0"
    /* 0x13fd */ "URLQueryStringStripper\0"
    /* 0x1414 */ "@mozilla.org/url-query-string-stripper;1\0"
    /* 0x143d */ "calendar-startup-service\0"
    /* 0x1456 */ "@mozilla.org/calendar/startup-service;1\0"
    /* 0x147e */ "deleted-items-manager\0"
    /* 0x1494 */ "@mozilla.org/calendar/deleted-items-manager;1\0"
    /* 0x14c2 */ "formHistoryStartup\0"
    /* 0x14d5 */ "@mozilla.org/satchel/form-history-startup;1\0"
    /* 0x1501 */ "nsCookieBannerTelemetryService\0"
    /* 0x1520 */ "@mozilla.org/cookie-banner-telemetry-service;1\0"
    /* 0x154f */ "nsRFPService\0"
    /* 0x155c */ "@mozilla.org/rfp-service;1\0"
    /* 0x1577 */ "nsUpdateTimerManager\0"
    /* 0x158c */ "@mozilla.org/updates/timer-manager;1\0"
    /* 0x15b1 */ "push\0"
    /* 0x15b6 */ "chrome://fxa-device-update\0"
    /* 0x15d1 */ "@mozilla.org/fxaccounts/push;1\0"
    /* 0x15f0 */ "simple-mime-converters\0"
    /* 0x1607 */ "text/calendar\0"
    /* 0x1615 */ "@mozilla.org/calendar/mime-converter;1\0"
    /* 0x163c */ "text/vcard\0"
    /* 0x1647 */ "@mozilla.org/mimecth;1?type=text/vcard\0"
    /* 0x166e */ "text/x-vcard\0"
    /* 0x167b */ "@mozilla.org/mimecth;1?type=text/x-vcard\0"
    /* 0x16a4 */ "speech-synth-started\0"
    /* 0x16b9 */ "Fake Speech Synth\0"
    /* 0x16cb */ "@mozilla.org/fakesynth;1\0"
    /* 0x16e4 */ "SpeechDispatcher Speech Synth\0"
    /* 0x1702 */ "@mozilla.org/synthspeechdispatcher;1\0"
    /* 0x1727 */ "vacuum-participant\0"
    /* 0x173a */ "Places\0"
    /* 0x1741 */ "@mozilla.org/browser/nav-history-service;1\0"
    /* 0x176c */ "xpcom-directory-providers\0"
    /* 0x1786 */ "mail-directory-provider\0"
    /* 0x179e */ "@mozilla.org/mail/dir-provider;1\0"
    /* 0x17bf */ "xpcom-startup\0"
    /* 0x17cd */ "nsGIOProtocolHandler\0"
    /* 0x17e2 */ "@mozilla.org/network/protocol;1?name=moz-gio\0"
    /* 0x180f */ "chrome://remote/content/components/Marionette.sys.mjs\0"
    /* 0x1845 */ "chrome://remote/content/components/RemoteAgent.sys.mjs\0"
    /* 0x187c */ "moz-src:///comm/mail/components/devtools/devtools-loader.sys.mjs\0"
    /* 0x18bd */ "moz-src:///dom/notification/NotificationStorage.sys.mjs\0"
    /* 0x18f5 */ "resource:///modules/AME2E.sys.mjs\0"
    /* 0x1917 */ "resource:///modules/AbAutoCompleteMyDomain.sys.mjs\0"
    /* 0x194a */ "resource:///modules/AbAutoCompleteSearch.sys.mjs\0"
    /* 0x197b */ "resource:///modules/AbLDAPAttributeMap.sys.mjs\0"
    /* 0x19aa */ "resource:///modules/AbLDAPAutoCompleteSearch.sys.mjs\0"
    /* 0x19df */ "resource:///modules/AboutDebuggingRegistration.sys.mjs\0"
    /* 0x1a16 */ "resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs\0"
    /* 0x1a53 */ "resource:///modules/AboutRedirector.sys.mjs\0"
    /* 0x1a7f */ "resource:///modules/Activity.sys.mjs\0"
    /* 0x1aa4 */ "resource:///modules/ActivityManager.sys.mjs\0"
    /* 0x1ad0 */ "resource:///modules/ActivityManagerUI.sys.mjs\0"
    /* 0x1afe */ "resource:///modules/AddrBookCard.sys.mjs\0"
    /* 0x1b27 */ "resource:///modules/AddrBookManager.sys.mjs\0"
    /* 0x1b53 */ "resource:///modules/CalAlarm.sys.mjs\0"
    /* 0x1b78 */ "resource:///modules/CalAlarmMonitor.sys.mjs\0"
    /* 0x1ba4 */ "resource:///modules/CalAlarmService.sys.mjs\0"
    /* 0x1bd0 */ "resource:///modules/CalAttachment.sys.mjs\0"
    /* 0x1bfa */ "resource:///modules/CalAttendee.sys.mjs\0"
    /* 0x1c22 */ "resource:///modules/CalCalendarManager.sys.mjs\0"
    /* 0x1c51 */ "resource:///modules/CalCompositeCalendar.sys.mjs\0"
    /* 0x1c82 */ "resource:///modules/CalDateTime.sys.mjs\0"
    /* 0x1caa */ "resource:///modules/CalDavCalendar.sys.mjs\0"
    /* 0x1cd5 */ "resource:///modules/CalDefaultACLManager.sys.mjs\0"
    /* 0x1d06 */ "resource:///modules/CalDeletedItems.sys.mjs\0"
    /* 0x1d32 */ "resource:///modules/CalDuration.sys.mjs\0"
    /* 0x1d5a */ "resource:///modules/CalEvent.sys.mjs\0"
    /* 0x1d7f */ "resource:///modules/CalFreeBusyService.sys.mjs\0"
    /* 0x1dae */ "resource:///modules/CalHtmlExport.sys.mjs\0"
    /* 0x1dd8 */ "resource:///modules/CalICSCalendar.sys.mjs\0"
    /* 0x1e03 */ "resource:///modules/CalICSService.sys.mjs\0"
    /* 0x1e2d */ "resource:///modules/CalIcsImportExport.sys.mjs\0"
    /* 0x1e5c */ "resource:///modules/CalIcsParser.sys.mjs\0"
    /* 0x1e85 */ "resource:///modules/CalIcsSerializer.sys.mjs\0"
    /* 0x1eb2 */ "resource:///modules/CalItipEmailTransport.sys.mjs\0"
    /* 0x1ee4 */ "resource:///modules/CalItipItem.sys.mjs\0"
    /* 0x1f0c */ "resource:///modules/CalItipProtocolHandler.sys.mjs\0"
    /* 0x1f3f */ "resource:///modules/CalMemoryCalendar.sys.mjs\0"
    /* 0x1f6d */ "resource:///modules/CalMimeConverter.sys.mjs\0"
    /* 0x1f9a */ "resource:///modules/CalPeriod.sys.mjs\0"
    /* 0x1fc0 */ "resource:///modules/CalProtocolHandler.sys.mjs\0"
    /* 0x1fef */ "resource:///modules/CalRecurrenceDate.sys.mjs\0"
    /* 0x201d */ "resource:///modules/CalRecurrenceInfo.sys.mjs\0"
    /* 0x204b */ "resource:///modules/CalRecurrenceRule.sys.mjs\0"
    /* 0x2079 */ "resource:///modules/CalRelation.sys.mjs\0"
    /* 0x20a1 */ "resource:///modules/CalStartupService.sys.mjs\0"
    /* 0x20cf */ "resource:///modules/CalStorageCalendar.sys.mjs\0"
    /* 0x20fe */ "resource:///modules/CalTimezoneService.sys.mjs\0"
    /* 0x212d */ "resource:///modules/CalTodo.sys.mjs\0"
    /* 0x2151 */ "resource:///modules/CalWeekInfoService.sys.mjs\0"
    /* 0x2180 */ "resource:///modules/CardDAVDirectory.sys.mjs\0"
    /* 0x21ad */ "resource:///modules/DevToolsStartup.sys.mjs\0"
    /* 0x21d9 */ "resource:///modules/GlodaAutoComplete.sys.mjs\0"
    /* 0x2207 */ "resource:///modules/IMIncomingServer.sys.mjs\0"
    /* 0x2234 */ "resource:///modules/IMProtocolInfo.sys.mjs\0"
    /* 0x225f */ "resource:///modules/LDAPConnection.sys.mjs\0"
    /* 0x228a */ "resource:///modules/LDAPDirectory.sys.mjs\0"
    /* 0x22b4 */ "resource:///modules/LDAPDirectoryQuery.sys.mjs\0"
    /* 0x22e3 */ "resource:///modules/LDAPOperation.sys.mjs\0"
    /* 0x230d */ "resource:///modules/LDAPProtocolHandler.sys.mjs\0"
    /* 0x233d */ "resource:///modules/LDAPReplicationService.sys.mjs\0"
    /* 0x2370 */ "resource:///modules/LDAPService.sys.mjs\0"
    /* 0x2398 */ "resource:///modules/LDAPSyncQuery.sys.mjs\0"
    /* 0x23c2 */ "resource:///modules/LDAPURLParser.sys.mjs\0"
    /* 0x23ec */ "resource:///modules/MDNService.sys.mjs\0"
    /* 0x2413 */ "resource:///modules/MailGlue.sys.mjs\0"
    /* 0x2438 */ "resource:///modules/MailtoProtocolHandler.sys.mjs\0"
    /* 0x246a */ "resource:///modules/MessageSend.sys.mjs\0"
    /* 0x2492 */ "resource:///modules/MessengerContentHandler.sys.mjs\0"
    /* 0x24c6 */ "resource:///modules/MimeJSComponents.sys.mjs\0"
    /* 0x24f3 */ "resource:///modules/MimeMessageEmitter.sys.mjs\0"
    /* 0x2522 */ "resource:///modules/MsgAsyncPrompter.sys.mjs\0"
    /* 0x254f */ "resource:///modules/MsgTraitService.sys.mjs\0"
    /* 0x257b */ "resource:///modules/NewsAutoCompleteSearch.sys.mjs\0"
    /* 0x25ae */ "resource:///modules/NewsBlog.sys.mjs\0"
    /* 0x25d3 */ "resource:///modules/NntpIncomingServer.sys.mjs\0"
    /* 0x2602 */ "resource:///modules/NntpMessageService.sys.mjs\0"
    /* 0x2631 */ "resource:///modules/NntpProtocolHandler.sys.mjs\0"
    /* 0x2661 */ "resource:///modules/NntpProtocolInfo.sys.mjs\0"
    /* 0x268e */ "resource:///modules/NntpService.sys.mjs\0"
    /* 0x26b6 */ "resource:///modules/OAuth2Module.sys.mjs\0"
    /* 0x26df */ "resource:///modules/OfflineStartup.sys.mjs\0"
    /* 0x270a */ "resource:///modules/OutgoingServerService.sys.mjs\0"
    /* 0x273c */ "resource:///modules/PgpMimeHandler.sys.mjs\0"
    /* 0x2767 */ "resource:///modules/Pop3IncomingServer.sys.mjs\0"
    /* 0x2796 */ "resource:///modules/Pop3ProtocolHandler.sys.mjs\0"
    /* 0x27c6 */ "resource:///modules/Pop3ProtocolInfo.sys.mjs\0"
    /* 0x27f3 */ "resource:///modules/Pop3Service.sys.mjs\0"
    /* 0x281b */ "resource:///modules/PromptCollection.sys.mjs\0"
    /* 0x2848 */ "resource:///modules/SMTPProtocolHandler.sys.mjs\0"
    /* 0x2878 */ "resource:///modules/SQLiteDirectory.sys.mjs\0"
    /* 0x28a4 */ "resource:///modules/SmtpServer.sys.mjs\0"
    /* 0x28cb */ "resource:///modules/VCardUtils.sys.mjs\0"
    /* 0x28f2 */ "resource:///modules/VirtualFolderWrapper.sys.mjs\0"
    /* 0x2923 */ "resource:///modules/facebook.sys.mjs\0"
    /* 0x2948 */ "resource:///modules/gtalk.sys.mjs\0"
    /* 0x296a */ "resource:///modules/irc.sys.mjs\0"
    /* 0x298a */ "resource:///modules/jsaccount/TestJaMsgProtocolInfoComponent.sys.mjs\0"
    /* 0x29cf */ "resource:///modules/matrix.sys.mjs\0"
    /* 0x29f2 */ "resource:///modules/odnoklassniki.sys.mjs\0"
    /* 0x2a1c */ "resource:///modules/twitter.sys.mjs\0"
    /* 0x2a40 */ "resource:///modules/xmpp.sys.mjs\0"
    /* 0x2a61 */ "resource:///modules/yahoo.sys.mjs\0"
    /* 0x2a83 */ "resource://devtools/client/jsonview/Converter.sys.mjs\0"
    /* 0x2ab9 */ "resource://devtools/client/jsonview/Sniffer.sys.mjs\0"
    /* 0x2aed */ "resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs\0"
    /* 0x2b25 */ "resource://gre/modules/BTPRemoteExceptionList.sys.mjs\0"
    /* 0x2b5b */ "resource://gre/modules/BackgroundTasksManager.sys.mjs\0"
    /* 0x2b91 */ "resource://gre/modules/CaptiveDetect.sys.mjs\0"
    /* 0x2bbe */ "resource://gre/modules/ClearBySiteEntry.sys.mjs\0"
    /* 0x2bee */ "resource://gre/modules/ClearDataService.sys.mjs\0"
    /* 0x2c1e */ "resource://gre/modules/ConsoleAPIStorage.sys.mjs\0"
    /* 0x2c4f */ "resource://gre/modules/ContentAreaDropListener.sys.mjs\0"
    /* 0x2c86 */ "resource://gre/modules/ContentDispatchChooser.sys.mjs\0"
    /* 0x2cbc */ "resource://gre/modules/ContentPrefService2.sys.mjs\0"
    /* 0x2cef */ "resource://gre/modules/CookieBannerListService.sys.mjs\0"
    /* 0x2d26 */ "resource://gre/modules/CredentialChooserService.sys.mjs\0"
    /* 0x2d5e */ "resource://gre/modules/DefaultCLH.sys.mjs\0"
    /* 0x2d88 */ "resource://gre/modules/DownloadLegacy.sys.mjs\0"
    /* 0x2db6 */ "resource://gre/modules/EnterprisePolicies.sys.mjs\0"
    /* 0x2de8 */ "resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs\0"
    /* 0x2e26 */ "resource://gre/modules/ExtHandlerService.sys.mjs\0"
    /* 0x2e57 */ "resource://gre/modules/FingerprintingWebCompatService.sys.mjs\0"
    /* 0x2e95 */ "resource://gre/modules/FormHistoryAutoComplete.sys.mjs\0"
    /* 0x2ecc */ "resource://gre/modules/FormHistoryStartup.sys.mjs\0"
    /* 0x2efe */ "resource://gre/modules/FxAccountsPush.sys.mjs\0"
    /* 0x2f2c */ "resource://gre/modules/HelperAppDlg.sys.mjs\0"
    /* 0x2f58 */ "resource://gre/modules/IdentityCredentialPromptService.sys.mjs\0"
    /* 0x2f97 */ "resource://gre/modules/LoginAutoComplete.sys.mjs\0"
    /* 0x2fc8 */ "resource://gre/modules/LoginInfo.sys.mjs\0"
    /* 0x2ff1 */ "resource://gre/modules/LoginManager.sys.mjs\0"
    /* 0x301d */ "resource://gre/modules/LoginManagerAuthPrompter.sys.mjs\0"
    /* 0x3055 */ "resource://gre/modules/LoginManagerPrompter.sys.mjs\0"
    /* 0x3089 */ "resource://gre/modules/MainProcessSingleton.sys.mjs\0"
    /* 0x30bd */ "resource://gre/modules/MozProtocolHandler.sys.mjs\0"
    /* 0x30ef */ "resource://gre/modules/NetworkErrorLogging.sys.mjs\0"
    /* 0x3122 */ "resource://gre/modules/NetworkGeolocationProvider.sys.mjs\0"
    /* 0x315c */ "resource://gre/modules/PageThumbsStorageService.sys.mjs\0"
    /* 0x3194 */ "resource://gre/modules/PartitioningExceptionListService.sys.mjs\0"
    /* 0x31d4 */ "resource://gre/modules/PlacesDBUtils.sys.mjs\0"
    /* 0x3201 */ "resource://gre/modules/PlacesExpiration.sys.mjs\0"
    /* 0x3231 */ "resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs\0"
    /* 0x326b */ "resource://gre/modules/PlacesPreviews.sys.mjs\0"
    /* 0x3299 */ "resource://gre/modules/PrivateAttributionService.sys.mjs\0"
    /* 0x32d2 */ "resource://gre/modules/ProcessSelector.sys.mjs\0"
    /* 0x3301 */ "resource://gre/modules/Prompter.sys.mjs\0"
    /* 0x3329 */ "resource://gre/modules/PurgeTrackerService.sys.mjs\0"
    /* 0x335c */ "resource://gre/modules/Push.sys.mjs\0"
    /* 0x3380 */ "resource://gre/modules/PushComponents.sys.mjs\0"
    /* 0x33ae */ "resource://gre/modules/QuotaUtilsService.sys.mjs\0"
    /* 0x33df */ "resource://gre/modules/RemotePermissionService.sys.mjs\0"
    /* 0x3416 */ "resource://gre/modules/SearchService.sys.mjs\0"
    /* 0x3443 */ "resource://gre/modules/SearchSuggestions.sys.mjs\0"
    /* 0x3474 */ "resource://gre/modules/SimpleServices.sys.mjs\0"
    /* 0x34a2 */ "resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs\0"
    /* 0x34e7 */ "resource://gre/modules/SlowScriptDebug.sys.mjs\0"
    /* 0x3516 */ "resource://gre/modules/TaggingService.sys.mjs\0"
    /* 0x3544 */ "resource://gre/modules/TelemetryControllerContent.sys.mjs\0"
    /* 0x357e */ "resource://gre/modules/TelemetryStartup.sys.mjs\0"
    /* 0x35ae */ "resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs\0"
    /* 0x35fa */ "resource://gre/modules/TooltipTextProvider.sys.mjs\0"
    /* 0x362d */ "resource://gre/modules/TrackingDBService.sys.mjs\0"
    /* 0x365e */ "resource://gre/modules/URIFixup.sys.mjs\0"
    /* 0x3686 */ "resource://gre/modules/URLDecorationAnnotationsService.sys.mjs\0"
    /* 0x36c5 */ "resource://gre/modules/URLFormatter.sys.mjs\0"
    /* 0x36f1 */ "resource://gre/modules/URLQueryStrippingListService.sys.mjs\0"
    /* 0x372d */ "resource://gre/modules/UpdateTimerManager.sys.mjs\0"
    /* 0x375f */ "resource://gre/modules/UrlClassifierExceptionListService.sys.mjs\0"
    /* 0x37a0 */ "resource://gre/modules/UrlClassifierHashCompleter.sys.mjs\0"
    /* 0x37da */ "resource://gre/modules/UrlClassifierLib.sys.mjs\0"
    /* 0x380a */ "resource://gre/modules/UrlClassifierListManager.sys.mjs\0"
    /* 0x3842 */ "resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs\0"
    /* 0x3884 */ "resource://gre/modules/UserCharacteristicsPageService.sys.mjs\0"
    /* 0x38c2 */ "resource://gre/modules/WebHandlerApp.sys.mjs\0"
    /* 0x38ef */ "resource://gre/modules/WebVTTParserWrapper.sys.mjs\0"
    /* 0x3922 */ "resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs\0"
    /* 0x395d */ "resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs\0"
    /* 0x39a8 */ "resource://gre/modules/XULStore.sys.mjs\0"
    /* 0x39d0 */ "resource://gre/modules/amContentHandler.sys.mjs\0"
    /* 0x3a00 */ "resource://gre/modules/amManager.sys.mjs\0"
    /* 0x3a29 */ "resource://gre/modules/amWebAPI.sys.mjs\0"
    /* 0x3a51 */ "resource://gre/modules/crypto-SDR.sys.mjs\0"
    /* 0x3a7b */ "resource://gre/modules/media/PeerConnection.sys.mjs\0"
    /* 0x3aaf */ "resource://gre/modules/mozIntl.sys.mjs\0"
    /* 0x3ad6 */ "resource://gre/modules/nsAsyncShutdown.sys.mjs\0"
    /* 0x3b05 */ "resource://gre/modules/nsCrashMonitor.sys.mjs\0"
    /* 0x3b33 */ "resource://gre/modules/pdfjs.sys.mjs\0"
    /* 0x3b58 */ "resource://gre/modules/psm/ClientAuthDialogService.sys.mjs\0"
    /* 0x3b93 */ "resource://services-settings/RemoteSettingsComponents.sys.mjs\0"
    /* 0x3bd1 */ "resource://testing-common/TestProtocol.sys.mjs\0"
    /* 0x3c00 */ "@mozilla.org/xre/app-info;1\0"
    /* 0x3c1c */ "@mozilla.org/embedcomp/window-watcher;1\0"
    /* 0x3c44 */ "@mozilla.org/contentanalysis;1\0"
    /* 0x3c63 */ "@mozilla.org/system-info;1\0"
    /* 0x3c7e */ "@mozilla.org/alerts-service;1\0"
    /* 0x3c9c */ "@mozilla.org/widget/clipboard;1\0"
    /* 0x3cbc */ "@mozilla.org/io/arraybuffer-input-stream;1\0"
    /* 0x3ce7 */ "@mozilla.org/streamconv;1?from=uncompressed&to=gzip\0"
    /* 0x3d1b */ "@mozilla.org/streamconv;1?from=x-gzip&to=uncompressed\0"
    /* 0x3d51 */ "@mozilla.org/user_cert_picker;1\0"
    /* 0x3d71 */ "@mozilla.org/alert-notification;1\0"
    /* 0x3d93 */ "@mozilla.org/mail/folder-factory;1?name=ews\0"
    /* 0x3dbf */ "@mozilla.org/network/protocol/about;1?what=buildconfig\0"
    /* 0x3df6 */ "@mozilla.org/network/serialization-helper;1\0"
    /* 0x3e22 */ "@mozilla.org/network/dashboard;1\0"
    /* 0x3e43 */ "@mozilla.org/msgDatabase/downloadSettings;1\0"
    /* 0x3e6f */ "@mozilla.org/addons/policy-service;1\0"
    /* 0x3e94 */ "@mozilla.org/content/dropped-link-handler;1\0"
    /* 0x3ec0 */ "@mozilla.org/messenger/mailboxservice;1\0"
    /* 0x3ee8 */ "@mozilla.org/messenger/msgdbview;1?type=search\0"
    /* 0x3f17 */ "@mozilla.org/dom/sessionStorage-manager;1\0"
    /* 0x3f41 */ "@mozilla.org/network/protocol/about;1?what=networking\0"
    /* 0x3f77 */ "@mozilla.org/browser/tagging-service;1\0"
    /* 0x3f9e */ "@mozilla.org/network/captive-portal-service;1\0"
    /* 0x3fcc */ "@mozilla.org/calendar/datetime;1\0"
    /* 0x3fed */ "@mozilla.org/gfx/printerlist;1\0"
    /* 0x400c */ "@mozilla.org/browser/favicon-service;1\0"
    /* 0x4033 */ "@mozilla.org/gfx/info;1\0"
    /* 0x404b */ "@mozilla.org/async-shutdown-service;1\0"
    /* 0x4071 */ "@mozilla.org/nsCMSMessage;1\0"
    /* 0x408d */ "@mozilla.org/layout/contentserializer;1?mimetype=application/vnd.mozilla.xul+xml\0"
    /* 0x40de */ "@mozilla.org/process/util;1\0"
    /* 0x40fa */ "@mozilla.org/devicesensors;1\0"
    /* 0x4117 */ "@mozilla.org/mail/oauth2-module;1\0"
    /* 0x4139 */ "@mozilla.org/messenger/filter-plugin;1?name=bayesianfilter\0"
    /* 0x4174 */ "@mozilla.org/calendar/recurrence-rule;1\0"
    /* 0x419c */ "@mozilla.org/contentsecuritymanager;1\0"
    /* 0x41c2 */ "@mozilla.org/pipe;1\0"
    /* 0x41d6 */ "@mozilla.org/sandbox/sandbox-settings;1\0"
    /* 0x41fe */ "@mozilla.org/content/filepicker;1\0"
    /* 0x4220 */ "@mozilla.org/netwerk/cache-storage-service;1\0"
    /* 0x424d */ "@mozilla.org/widget/transferable;1\0"
    /* 0x4270 */ "@mozilla.org/messenger/protocol/info;1?type=pop3\0"
    /* 0x42a1 */ "@mozilla.org/userinfo;1\0"
    /* 0x42b9 */ "@mozilla.org/xpcom/ini-parser-factory;1\0"
    /* 0x42e1 */ "@mozilla.org/security/hash;1\0"
    /* 0x42fe */ "@mozilla.org/calendar/attachment;1\0"
    /* 0x4321 */ "@mozilla.org/messenger/messageservice;1?type=ews-message\0"
    /* 0x435a */ "@mozilla.org/network/protocol/about;1?what=crashextensions\0"
    /* 0x4395 */ "@mozilla.org/security/publickeypinningservice;1\0"
    /* 0x43c5 */ "@mozilla.org/calendar/ics-parser;1\0"
    /* 0x43e8 */ "@mozilla.org/boolean-expression/condition-string;1\0"
    /* 0x441b */ "@mozilla.org/messenger/mimeheaders;1\0"
    /* 0x4440 */ "@mozilla.org/globalmessagemanager;1\0"
    /* 0x4464 */ "@mozilla.org/supports-PRUint16;1\0"
    /* 0x4485 */ "@mozilla.org/uriloader/handler-service-parent;1\0"
    /* 0x44b5 */ "@mozilla.org/login-manager/loginInfo;1\0"
    /* 0x44dc */ "@mozilla.org/network/server-socket;1\0"
    /* 0x4501 */ "@mozilla.org/supports-interface-pointer;1\0"
    /* 0x452b */ "@mozilla.org/messenger/server;1?type=imap\0"
    /* 0x4555 */ "@mozilla.org/parserutils;1\0"
    /* 0x4570 */ "@mozilla.org/accessibilityService;1\0"
    /* 0x4594 */ "@mozilla.org/messenger/server;1?type=pop3\0"
    /* 0x45be */ "@mozilla.org/uriloader/content-handler;1?type=x-application-imapfolder\0"
    /* 0x4605 */ "@mozilla.org/layout/contentserializer;1?mimetype=application/xhtml+xml\0"
    /* 0x464c */ "@mozilla.org/tracking-url-decoration-service;1\0"
    /* 0x467b */ "@mozilla.org/widget/content/dragservice;1\0"
    /* 0x46a5 */ "@mozilla.org/network/protocol;1?name=https\0"
    /* 0x46d0 */ "@mozilla.org/intl/texttosuburi;1\0"
    /* 0x46f1 */ "@mozilla.org/network/throttlequeue;1\0"
    /* 0x4716 */ "@mozilla.org/dom/peerconnectionmanager;1\0"
    /* 0x473f */ "@mozilla.org/chat/matrix;1\0"
    /* 0x475a */ "@mozilla.org/streamconv;1?from=application/pdf&to=*/*\0"
    /* 0x4790 */ "@mozilla.org/dom/sdb-connection;1\0"
    /* 0x47b2 */ "@mozilla.org/messenger/server;1?type=ews\0"
    /* 0x47db */ "@mozilla.org/network/file-output-stream;1\0"
    /* 0x4805 */ "@mozilla.org/calendar/calendar;1?type=storage\0"
    /* 0x4833 */ "@mozilla.org/nsCertPickDialogs;1\0"
    /* 0x4854 */ "@mozilla.org/network/protocol;1?name=snews\0"
    /* 0x487f */ "@mozilla.org/network/protocol/about;1?what=credits\0"
    /* 0x48b2 */ "@mozilla.org/network/background-file-saver;1?mode=streamlistener\0"
    /* 0x48f3 */ "@mozilla.org/dom/peerconnectionstatic;1\0"
    /* 0x491b */ "@mozilla.org/calendar/itip-transport;1?type=email\0"
    /* 0x494d */ "@mozilla.org/url-classifier/exception-list-entry;1\0"
    /* 0x4980 */ "@mozilla.org/backgroundtasks;1\0"
    /* 0x499f */ "@mozilla.org/scriptsecuritymanager;1\0"
    /* 0x49c4 */ "@mozilla.org/url-classifier/dbservice;1\0"
    /* 0x49ec */ "@mozilla.org/messenger/server;1?type=rss\0"
    /* 0x4a15 */ "@mozilla.org/toolkit/finalizationwitness;1\0"
    /* 0x4a40 */ "@mozilla.org/scripterror;1\0"
    /* 0x4a5b */ "@mozilla.org/io-util;1\0"
    /* 0x4a72 */ "@mozilla.org/messengercompose/composeparams;1\0"
    /* 0x4aa0 */ "@mozilla.org/network/simple-uri-mutator;1\0"
    /* 0x4aca */ "@mozilla.org/network/protocol/about;1?what=support\0"
    /* 0x4afd */ "@mozilla.org/dom/localStorage-manager;1\0"
    /* 0x4b25 */ "@mozilla.org/network/downloader;1\0"
    /* 0x4b47 */ "@mozilla.org/variant;1\0"
    /* 0x4b5e */ "@mozilla.org/hash-property-bag;1\0"
    /* 0x4b7f */ "@mozilla.org/mime;1\0"
    /* 0x4b93 */ "@mozilla.org/supports-PRUint64;1\0"
    /* 0x4bb4 */ "@mozilla.org/messenger/account-manager;1\0"
    /* 0x4bdd */ "@mozilla.org/autocomplete/search;1?name=mydomain\0"
    /* 0x4c0e */ "@mozilla.org/network/ldap-connection;1\0"
    /* 0x4c35 */ "@mozilla.org/messenger/server;1?type=none\0"
    /* 0x4c5f */ "@mozilla.org/integritypolicy;1\0"
    /* 0x4c7e */ "@mozilla.org/nsMsgDatabase/msgDB-mailbox\0"
    /* 0x4ca7 */ "@mozilla.org/messenger/mimeobject;1\0"
    /* 0x4ccb */ "@mozilla.org/parentprocessmessagemanager;1\0"
    /* 0x4cf6 */ "@mozilla.org/addressbook/cardproperty;1\0"
    /* 0x4d1e */ "@mozilla.org/messenger/services/filters;1\0"
    /* 0x4d48 */ "@mozilla.org/peerconnection;1\0"
    /* 0x4d66 */ "@mozilla.org/webvttParserWrapper;1\0"
    /* 0x4d89 */ "@mozilla.org/spellchecker/personaldictionary;1\0"
    /* 0x4db8 */ "@mozilla.org/txttohtmlconv;1\0"
    /* 0x4dd5 */ "@mozilla.org/addressbook/abldifservice;1\0"
    /* 0x4dfe */ "@mozilla.org/imap/offlinesync;1\0"
    /* 0x4e1e */ "@mozilla.org/uriloader/content-handler;1?type=text/plain\0"
    /* 0x4e57 */ "@mozilla.org/nsCertificateDialogs;1\0"
    /* 0x4e7b */ "@mozilla.org/dom/indexeddb/manager;1\0"
    /* 0x4ea0 */ "@mozilla.org/mime/pgp-mime-js-decrypt;1\0"
    /* 0x4ec8 */ "@mozilla.org/inspector/deep-tree-walker;1\0"
    /* 0x4ef2 */ "@mozilla.org/network/default-uri-mutator;1\0"
    /* 0x4f1d */ "@mozilla.org/security/certstorage;1\0"
    /* 0x4f41 */ "@mozilla.org/network/mime-input-stream;1\0"
    /* 0x4f6a */ "@mozilla.org/network/protocol/about;1?what=memory\0"
    /* 0x4f9c */ "@mozilla.org/dom/rtpsender;1\0"
    /* 0x4fb9 */ "@mozilla.org/security/sdr;1\0"
    /* 0x4fd5 */ "@mozilla.org/base/telemetry-startup;1\0"
    /* 0x4ffb */ "@mozilla.org/network/http-activity-distributor;1\0"
    /* 0x502c */ "@mozilla.org/webspeech/service;1?name=fake\0"
    /* 0x5057 */ "@mozilla.org/browser/synced-bookmarks-merger;1\0"
    /* 0x5086 */ "@mozilla.org/base/telemetry;1\0"
    /* 0x50a4 */ "@mozilla.org/network/protocol;1?name=moz-src\0"
    /* 0x50d1 */ "@mozilla.org/network/file-input-stream;1\0"
    /* 0x50fa */ "@mozilla.org/xpcom/debug;1\0"
    /* 0x5115 */ "@mozilla.org/supports-PRInt32;1\0"
    /* 0x5135 */ "@mozilla.org/toolkit/download-platform;1\0"
    /* 0x515e */ "@mozilla.org/geolocation/mls-provider;1\0"
    /* 0x5186 */ "@mozilla.org/messenger/messageservice;1?type=mailbox\0"
    /* 0x51bb */ "@mozilla.org/categorymanager;1\0"
    /* 0x51da */ "@mozilla.org/file/local;1\0"
    /* 0x51f4 */ "@mozilla.org/autocomplete/search;1?name=ldap\0"
    /* 0x5221 */ "@mozilla.org/network/protocol/about;1?what=cache-entry\0"
    /* 0x5258 */ "@mozilla.org/messenger/messagecopyservice;1\0"
    /* 0x5284 */ "@mozilla.org/stopwatch;1\0"
    /* 0x529d */ "@mozilla.org/streamconv;1?from=zstd&to=uncompressed\0"
    /* 0x52d1 */ "@mozilla.org/content-pref/service;1\0"
    /* 0x52f5 */ "@mozilla.org/messenger/ews-client;1\0"
    /* 0x5319 */ "@mozilla.org/mail/clh;1\0"
    /* 0x5331 */ "@mozilla.org/messenger/msgAsyncPrompter;1\0"
    /* 0x535b */ "@mozilla.org/calendar/timezone-service;1\0"
    /* 0x5384 */ "@mozilla.org/calendar/duration;1\0"
    /* 0x53a5 */ "@mozilla.org/network/protocol;1?name=moz-cal-handle-itip\0"
    /* 0x53de */ "@mozilla.org/webnavigation-info;1\0"
    /* 0x5400 */ "@mozilla.org/network/tls-server-socket;1\0"
    /* 0x5429 */ "@mozilla.org/messenger/messageservice;1?type=mailbox-message\0"
    /* 0x5466 */ "@mozilla.org/network/protocol/about;1?what=neterror\0"
    /* 0x549a */ "@mozilla.org/cookie-banner-rule;1\0"
    /* 0x54bc */ "@mozilla.org/network/protocol/about;1?what=addons\0"
    /* 0x54ee */ "@mozilla.org/messenger/pop3-sink;1\0"
    /* 0x5511 */ "@mozilla.org/jsctypes;1\0"
    /* 0x5529 */ "@mozilla.org/cookieService;1\0"
    /* 0x5546 */ "@mozilla.org/messengercompose/compose;1\0"
    /* 0x556e */ "@mozilla.org/network/network-connectivity-service;1\0"
    /* 0x55a2 */ "@mozilla.org/intl/converter-output-stream;1\0"
    /* 0x55ce */ "@mozilla.org/network/replaced-http-response;1\0"
    /* 0x55fc */ "@mozilla.org/network/protocol/about;1?what=rights\0"
    /* 0x562e */ "@mozilla.org/messenger/msgshutdownservice;1\0"
    /* 0x565a */ "@mozilla.org/messenger/imaphostsessionlist;1\0"
    /* 0x5687 */ "@mozilla.org/network/protocol;1?name=chrome\0"
    /* 0x56b3 */ "@mozilla.org/network/binary-http;1\0"
    /* 0x56d6 */ "@mozilla.org/security/clientAuthRememberService;1\0"
    /* 0x5708 */ "@mozilla.org/media/wmfcdm-origins-list;1\0"
    /* 0x5731 */ "@mozilla.org/network/url-parser;1?auth=yes\0"
    /* 0x575c */ "@mozilla.org/url-classifier/channel-classifier-service;1\0"
    /* 0x5795 */ "@mozilla.org/import/import-ab-file;1?type=mab\0"
    /* 0x57c3 */ "@mozilla.org/tools/profiler;1\0"
    /* 0x57e1 */ "@mozilla.org/supports-PRInt16;1\0"
    /* 0x5801 */ "@mozilla.org/messenger-mdn/generator;1\0"
    /* 0x5828 */ "@mozilla.org/network/stream-loader;1\0"
    /* 0x584d */ "@mozilla.org/third-party-cookie-blocking-exception-list-service;1\0"
    /* 0x588f */ "@mozilla.org/network/protocol;1?name=moz-page-thumb\0"
    /* 0x58c3 */ "@mozilla.org/chat/yahoo;1\0"
    /* 0x58dd */ "@mozilla.org/network/oblivious-http-service;1\0"
    /* 0x590b */ "@mozilla.org/supports-float;1\0"
    /* 0x5929 */ "@mozilla.org/network/protocol/about;1?what=mozilla\0"
    /* 0x595c */ "@mozilla.org/addons/integration;1\0"
    /* 0x597e */ "@mozilla.org/filepicker;1\0"
    /* 0x5998 */ "@mozilla.org/storage/service;1\0"
    /* 0x59b7 */ "@mozilla.org/network/protocol;1?name=pop\0"
    /* 0x59e0 */ "@mozilla.org/network/protocol;1?name=page-icon\0"
    /* 0x5a0f */ "@mozilla.org/network/sync-stream-listener;1\0"
    /* 0x5a3b */ "@mozilla.org/uriloader/content-handler;1?type=application/x-mailto\0"
    /* 0x5a7e */ "@mozilla.org/nsCMSDecoderJS;1\0"
    /* 0x5a9c */ "@mozilla.org/network/protocol;1?name=cid\0"
    /* 0x5ac5 */ "@mozilla.org/security/x509certdb;1\0"
    /* 0x5ae8 */ "@mozilla.org/chat/twitter;1\0"
    /* 0x5b04 */ "@mozilla.org/mail/shell-service;1\0"
    /* 0x5b26 */ "@mozilla.org/streamconv;1?from=multipart/mixed&to=*/*\0"
    /* 0x5b5c */ "@mozilla.org/network/protocol;1?name=file\0"
    /* 0x5b86 */ "@mozilla.org/calendar/ics-serializer;1\0"
    /* 0x5bad */ "@mozilla.org/messenger/outgoing/server;1?type=ews\0"
    /* 0x5bdf */ "@mozilla.org/messenger/msgAuthPrompt;1\0"
    /* 0x5c06 */ "@mozilla.org/addressbook/directory;1?type=jsaddrbook\0"
    /* 0x5c3b */ "@mozilla.org/power/powermanagerservice;1\0"
    /* 0x5c64 */ "@mozilla.org/messenger/noneservice;1\0"
    /* 0x5c89 */ "@mozilla.org/messengercompose/attachmentdata;1\0"
    /* 0x5cb8 */ "@mozilla.org/calendar/acl-manager;1?type=default\0"
    /* 0x5ce9 */ "@mozilla.org/autocomplete/search;1?name=form-fill-controller\0"
    /* 0x5d26 */ "@mozilla.org/services/settings;1\0"
    /* 0x5d47 */ "@mozilla.org/messenger/msgwindow;1\0"
    /* 0x5d6a */ "@mozilla.org/calendar/weekinfo-service;1\0"
    /* 0x5d93 */ "@mozilla.org/messenger/protocol/info;1?type=im\0"
    /* 0x5dc2 */ "@mozilla.org/addressbook/jsaddrbookcard;1\0"
    /* 0x5dec */ "@mozilla.org/calendar/manager;1\0"
    /* 0x5e0c */ "@mozilla.org/network/url-parser;1?auth=maybe\0"
    /* 0x5e39 */ "@mozilla.org/psm;1\0"
    /* 0x5e4c */ "@mozilla.org/colorpicker;1\0"
    /* 0x5e67 */ "@mozilla.org/xpcom/version-comparator;1\0"
    /* 0x5e8f */ "@mozilla.org/private-attribution;1\0"
    /* 0x5eb2 */ "@mozilla.org/messenger/structuredheaders;1\0"
    /* 0x5edd */ "@mozilla.org/network/http-auth-manager;1\0"
    /* 0x5f06 */ "@mozilla.org/wifi/monitor;1\0"
    /* 0x5f22 */ "@mozilla.org/network/socket-transport-service;1\0"
    /* 0x5f52 */ "@mozilla.org/gio-service;1\0"
    /* 0x5f6d */ "@mozilla.org/messenger/msgdbview;1?type=watchedthreadswithunread\0"
    /* 0x5fae */ "@mozilla.org/messenger/offline-manager;1\0"
    /* 0x5fd7 */ "@mozilla.org/imap/autosyncmgr;1\0"
    /* 0x5ff7 */ "@mozilla.org/applicationchooser;1\0"
    /* 0x6019 */ "@mozilla.org/addressbook/ldap-attribute-map;1\0"
    /* 0x6047 */ "@mozilla.org/network/protocol/about;1?what=newserror\0"
    /* 0x607c */ "@mozilla.org/network/protocol/about;1?what=cache\0"
    /* 0x60ad */ "@mozilla.org/url-classifier/hashcompleter;1\0"
    /* 0x60d9 */ "@mozilla.org/btp-remote-exception-list;1\0"
    /* 0x6102 */ "@mozilla.org/layout/contentserializer;1?mimetype=application/xml\0"
    /* 0x6143 */ "@mozilla.org/network/protocol;1?name=indexeddb\0"
    /* 0x6172 */ "@mozilla.org/messengercompose/mailtourl;1\0"
    /* 0x619c */ "@mozilla.org/network/protocol/about;1?what=fingerprintingprotection\0"
    /* 0x61e0 */ "@mozilla.org/sandbox/syscall-reporter;1\0"
    /* 0x6208 */ "@mozilla.org/zipwriter;1\0"
    /* 0x6221 */ "@mozilla.org/addressbook/directory/query-arguments;1\0"
    /* 0x6256 */ "@mozilla.org/mimecth;1?type=multipart/encrypted\0"
    /* 0x6286 */ "@mozilla.org/network/protocol/about;1?what=devtools-toolbox\0"
    /* 0x62c2 */ "@mozilla.org/messenger/protocol/info;1?type=ews\0"
    /* 0x62f2 */ "@mozilla.org/messenger/msgdbview;1?type=threaded\0"
    /* 0x6323 */ "@mozilla.org/toolkit/app-startup;1\0"
    /* 0x6346 */ "@mozilla.org/typeaheadfind;1\0"
    /* 0x6363 */ "@mozilla.org/image/request;1\0"
    /* 0x6380 */ "@mozilla.org/messengercompose/composeprogressparameters;1\0"
    /* 0x63ba */ "@mozilla.org/chat/mochitest;1\0"
    /* 0x63d8 */ "@mozilla.org/intl/stringbundle;1\0"
    /* 0x63f9 */ "@mozilla.org/widget/parent/clipboard;1\0"
    /* 0x6420 */ "@mozilla.org/appshell/component/browser-status-filter;1\0"
    /* 0x6458 */ "@mozilla.org/network/background-file-saver;1?mode=outputstream\0"
    /* 0x6497 */ "@mozilla.org/thumbnails/pagethumbs-service;1\0"
    /* 0x64c4 */ "@mozilla.org/security/pk11tokendb;1\0"
    /* 0x64e8 */ "@mozilla.org/timer;1\0"
    /* 0x64fd */ "@mozilla.org/mail/folder-factory;1?name=imap\0"
    /* 0x652a */ "@mozilla.org/network/protocol;1?name=view-source\0"
    /* 0x655b */ "@mozilla.org/network/protocol/about;1?what=glean\0"
    /* 0x658c */ "@mozilla.org/messenger/messageservice;1?type=ews\0"
    /* 0x65bd */ "@mozilla.org/widget/printdialog-service;1\0"
    /* 0x65e7 */ "@mozilla.org/transactionmanager;1\0"
    /* 0x6609 */ "@mozilla.org/systemprincipal;1\0"
    /* 0x6628 */ "@mozilla.org/security/oskeystore;1\0"
    /* 0x664b */ "@mozilla.org/dom/rtcstatsreport;1\0"
    /* 0x666d */ "@mozilla.org/streamconv;1?from=multipart/byteranges&to=*/*\0"
    /* 0x66a8 */ "@mozilla.org/msgDBView/msgDBViewService;1\0"
    /* 0x66d2 */ "@mozilla.org/main-process-singleton;1\0"
    /* 0x66f8 */ "@mozilla.org/dom/rtcdtmfsender;1\0"
    /* 0x6719 */ "@mozilla.org/messenger/services/session;1\0"
    /* 0x6743 */ "@mozilla.org/autocomplete/search;1?name=login-doorhanger-password\0"
    /* 0x6785 */ "@mozilla.org/websocketevent/service;1\0"
    /* 0x67ab */ "@mozilla.org/network/protocol/about;1?what=url-classifier\0"
    /* 0x67e5 */ "@mozilla.org/network/protocol/about;1?what=crashcontent\0"
    /* 0x681d */ "@mozilla.org/toolkit/URLFormatterService;1\0"
    /* 0x6848 */ "@mozilla.org/autocomplete/simple-result;1\0"
    /* 0x6872 */ "@mozilla.org/network/protocol;1?name=http\0"
    /* 0x689c */ "@mozilla.org/supports-PRTime;1\0"
    /* 0x68bb */ "@mozilla.org/uriloader/handler-service;1\0"
    /* 0x68e4 */ "@mozilla.org/layout/contentserializer;1?mimetype=text/html\0"
    /* 0x691f */ "@mozilla.org/calendar/alarm-service;1\0"
    /* 0x6945 */ "@mozilla.org/network/protocol;1?name=moz-icon\0"
    /* 0x6973 */ "@mozilla.org/network/protocol/about;1?what=crashgpu\0"
    /* 0x69a7 */ "@mozilla.org/calendar/relation;1\0"
    /* 0x69c8 */ "@mozilla.org/messenger/rssservice;1\0"
    /* 0x69ec */ "@mozilla.org/appshell/appShellService;1\0"
    /* 0x6a14 */ "@mozilla.org/messenger/statusfeedback;1\0"
    /* 0x6a3c */ "@mozilla.org/browser/identity-credential-storage-service;1\0"
    /* 0x6a77 */ "@mozilla.org/messengercompose/outgoingserverservice;1\0"
    /* 0x6aad */ "@mozilla.org/uriloader/dbus-handler-app;1\0"
    /* 0x6ad7 */ "@mozilla.org/url-classifier/listmanager;1\0"
    /* 0x6b01 */ "@mozilla.org/gfx/content/screenmanager;1\0"
    /* 0x6b2a */ "@mozilla.org/dom/createofferrequest;1\0"
    /* 0x6b50 */ "@mozilla.org/messenger/mailviewlist;1\0"
    /* 0x6b76 */ "@mozilla.org/network/ldap-url-parser;1\0"
    /* 0x6b9d */ "@mozilla.org/calendar/freebusy-service;1\0"
    /* 0x6bc6 */ "@mozilla.org/sound;1\0"
    /* 0x6bdb */ "@mozilla.org/network/protocol/about;1?what=blank\0"
    /* 0x6c0c */ "@mozilla.org/network/dns-service;1\0"
    /* 0x6c2f */ "@mozilla.org/messenger/outgoing/server;1?type=smtp\0"
    /* 0x6c62 */ "@mozilla.org/memory-info-dumper;1\0"
    /* 0x6c84 */ "@mozilla.org/intl/converter-input-stream;1\0"
    /* 0x6caf */ "@mozilla.org/dom/quota-utils-service;1\0"
    /* 0x6cd6 */ "@mozilla.org/content/plugin/document-loader-factory;1\0"
    /* 0x6d0c */ "@mozilla.org/widget/content/clipboard;1\0"
    /* 0x6d34 */ "@mozilla.org/network/protocol;1?name=ldaps\0"
    /* 0x6d5f */ "@mozilla.org/network/udp-filter-handler;1?name=stun\0"
    /* 0x6d93 */ "@mozilla.org/focus-manager;1\0"
    /* 0x6db0 */ "@mozilla.org/autocomplete/search;1?name=search-autocomplete\0"
    /* 0x6dec */ "@mozilla.org/chat/xmpp;1\0"
    /* 0x6e05 */ "@mozilla.org/supports-cstring;1\0"
    /* 0x6e25 */ "@mozilla.org/messenger/purgeService;1\0"
    /* 0x6e4b */ "@mozilla.org/streamconv;1?from=application/vnd.mozilla.webext.unlocalized&to=text/css\0"
    /* 0x6ea1 */ "@mozilla.org/storagestream;1\0"
    /* 0x6ebe */ "@mozilla.org/network/load-group;1\0"
    /* 0x6ee0 */ "@mozilla.org/url-classifier/jslib;1\0"
    /* 0x6f04 */ "@mozilla.org/network/cors-preflight-cache;1\0"
    /* 0x6f30 */ "@mozilla.org/clear-data-service;1\0"
    /* 0x6f52 */ "@mozilla.org/streamconv;1?from=uncompressed&to=x-gzip\0"
    /* 0x6f88 */ "@mozilla.org/streamconv;1?from=application/pdf&to=text/html\0"
    /* 0x6fc4 */ "@mozilla.org/streamconv;1?from=message/rfc822&to=text/html\0"
    /* 0x6fff */ "@mozilla.org/security/certoverride;1\0"
    /* 0x7024 */ "@mozilla.org/widget/clipboardhelper;1\0"
    /* 0x704a */ "@mozilla.org/reputationservice/application-reputation-service;1\0"
    /* 0x708a */ "@mozilla.org/messengercompose/send;1\0"
    /* 0x70af */ "@mozilla.org/network/protocol/about;1?what=serviceworkers\0"
    /* 0x70e9 */ "@mozilla.org/network/protocol;1?name=smtps\0"
    /* 0x7114 */ "@mozilla.org/browser/history;1\0"
    /* 0x7133 */ "@mozilla.org/messengercompose/composesendlistener;1\0"
    /* 0x7167 */ "@mozilla.org/embedcomp/rangefind;1\0"
    /* 0x718a */ "@mozilla.org/messenger/imapurl;1\0"
    /* 0x71ab */ "@mozilla.org/messenger/osintegration;1\0"
    /* 0x71d2 */ "@mozilla.org/system-alerts-service;1\0"
    /* 0x71f7 */ "@mozilla.org/streamConverters;1\0"
    /* 0x7217 */ "@mozilla.org/network/protocol;1?name=about\0"
    /* 0x7242 */ "@mozilla.org/push/PushManager;1\0"
    /* 0x7262 */ "@mozilla.org/network/io-service;1\0"
    /* 0x7284 */ "@mozilla.org/embedding/browser/nsWebBrowserPersist;1\0"
    /* 0x72b9 */ "@mozilla.org/browser/credentialchooserservice;1\0"
    /* 0x72e9 */ "@mozilla.org/network/protocol;1?name=news\0"
    /* 0x7313 */ "@mozilla.org/calendar/alarm-monitor;1\0"
    /* 0x7339 */ "@mozilla.org/calendar/event;1\0"
    /* 0x7357 */ "@mozilla.org/commandlinehandler/general-startup;1?type=compose\0"
    /* 0x7396 */ "@mozilla.org/messenger/msgdbview;1?type=group\0"
    /* 0x73c4 */ "@mozilla.org/referrer-info;1\0"
    /* 0x73e1 */ "@mozilla.org/content/colorpicker;1\0"
    /* 0x7404 */ "@mozilla.org/gfx/devicecontextspec;1\0"
    /* 0x7429 */ "@mozilla.org/chrome/chrome-registry;1\0"
    /* 0x744f */ "@mozilla.org/embedcomp/default-tooltiptextprovider;1\0"
    /* 0x7484 */ "@mozilla.org/calendar/itip-channel;1\0"
    /* 0x74a9 */ "@mozilla.org/streamconv;1?from=message/rfc822&to=application/xhtml+xml\0"
    /* 0x74f0 */ "@mozilla.org/network/protocol/about;1?what=debugging\0"
    /* 0x7525 */ "@mozilla.org/login-manager/autocompletesearch;1\0"
    /* 0x7555 */ "@mozilla.org/net/CachePurgeLock;1\0"
    /* 0x7577 */ "@mozilla.org/network/protocol/about;1?what=logging\0"
    /* 0x75aa */ "@mozilla.org/xpcom/memory-watcher;1\0"
    /* 0x75ce */ "@mozilla.org/network/stream-transport-service;1\0"
    /* 0x75fe */ "@mozilla.org/messengercompose/smtpurl;1\0"
    /* 0x7626 */ "@mozilla.org/content/style-sheet-service;1\0"
    /* 0x7651 */ "@mozilla.org/jacppcomposedelegator;1\0"
    /* 0x7676 */ "@mozilla.org/cookiemanager;1\0"
    /* 0x7693 */ "@mozilla.org/mail/mailglue;1\0"
    /* 0x76b0 */ "@mozilla.org/network/protocol/about;1?what=accountsetup\0"
    /* 0x76e8 */ "@mozilla.org/network/protocol;1?name=moz-extension\0"
    /* 0x771b */ "@mozilla.org/messengercompose/sendreport;1\0"
    /* 0x7746 */ "@mozilla.org/mail/folder-factory;1?name=mailbox\0"
    /* 0x7776 */ "@mozilla.org/network/protocol/about;1?what=downloads\0"
    /* 0x77ab */ "@mozilla.org/uriloader/content-handler;1?type=application/x-xpinstall\0"
    /* 0x77f1 */ "@mozilla.org/mozintlhelper;1\0"
    /* 0x780e */ "@mozilla.org/prefetch-service;1\0"
    /* 0x782e */ "@mozilla.org/network/protocol/about;1?what=srcdoc\0"
    /* 0x7860 */ "@mozilla.org/jsdebugger;1\0"
    /* 0x787a */ "@mozilla.org/widget/taskbarprogress/gtk;1\0"
    /* 0x78a4 */ "@mozilla.org/xre/runtime;1\0"
    /* 0x78bf */ "@mozilla.org/embedcomp/dialogparam;1\0"
    /* 0x78e4 */ "@mozilla.org/file/directory_service;1\0"
    /* 0x790a */ "@mozilla.org/intl/localeservice;1\0"
    /* 0x792c */ "@mozilla.org/network/protocol/about;1?what=policies\0"
    /* 0x7960 */ "@mozilla.org/network/protocol/about;1?what=accountsettings\0"
    /* 0x799b */ "@mozilla.org/network/protocol/about;1?what=performance\0"
    /* 0x79d2 */ "@mozilla.org/security/nsCertTree;1\0"
    /* 0x79f5 */ "@mozilla.org/partitioning/exception-list-service;1\0"
    /* 0x7a28 */ "@mozilla.org/messenger/protocol/info;1?type=testja\0"
    /* 0x7a5b */ "@mozilla.org/messenger/protocol/info;1?type=nntp\0"
    /* 0x7a8c */ "@mozilla.org/messenger/protocol/info;1?type=none\0"
    /* 0x7abd */ "@mozilla.org/docshell/structured-clone-container;1\0"
    /* 0x7af0 */ "@mozilla.org/autocomplete/search;1?name=places-tag-autocomplete\0"
    /* 0x7b30 */ "@mozilla.org/content-blocking-allow-list;1\0"
    /* 0x7b5b */ "@mozilla.org/network/standard-url-mutator;1\0"
    /* 0x7b87 */ "@mozilla.org/uriloader/content-handler;1?type=application/x-message-display\0"
    /* 0x7bd3 */ "@mozilla.org/remote;1\0"
    /* 0x7be9 */ "@mozilla.org/gfx/parent/screenmanager;1\0"
    /* 0x7c11 */ "@mozilla.org/mediaManagerService;1\0"
    /* 0x7c34 */ "@mozilla.org/binaryoutputstream;1\0"
    /* 0x7c56 */ "@mozilla.org/network/protocol/about;1?what=3pane\0"
    /* 0x7c87 */ "@mozilla.org/streamconv;1?from=compress&to=uncompressed\0"
    /* 0x7cbf */ "@mozilla.org/memory-reporter-manager;1\0"
    /* 0x7ce6 */ "@mozilla.org/messenger/server;1?type=nntp\0"
    /* 0x7d10 */ "@mozilla.org/dom/slow-script-debug;1\0"
    /* 0x7d35 */ "@mozilla.org/security/transportsecurityinfo;1\0"
    /* 0x7d63 */ "@mozilla.org/mail/auth-module;1\0"
    /* 0x7d83 */ "@mozilla.org/policycontainer;1\0"
    /* 0x7da2 */ "@mozilla.org/login-detection-service;1\0"
    /* 0x7dc9 */ "@mozilla.org/calendar/period;1\0"
    /* 0x7de8 */ "@mozilla.org/text-input-processor;1\0"
    /* 0x7e0c */ "@mozilla.org/permissiondelegatehandler;1\0"
    /* 0x7e35 */ "@mozilla.org/abmanager;1\0"
    /* 0x7e4e */ "@mozilla.org/messenger/msgnotificationservice;1\0"
    /* 0x7e7e */ "@mozilla.org/pref-override-map;1\0"
    /* 0x7e9f */ "@mozilla.org/system-proxy-settings;1\0"
    /* 0x7ec4 */ "@mozilla.org/streamconv;1?from=application/vnd.mozilla.json.view&to=*/*\0"
    /* 0x7f0c */ "@mozilla.org/cspcontext;1\0"
    /* 0x7f26 */ "@mozilla.org/layout/contentserializer;1?mimetype=image/svg+xml\0"
    /* 0x7f65 */ "@mozilla.org/login-manager/authprompter;1\0"
    /* 0x7f8f */ "@mozilla.org/geolocation/provider;1\0"
    /* 0x7fb3 */ "@mozilla.org/messenger/msgdbview;1?type=xfvf\0"
    /* 0x7fe0 */ "@mozilla.org/embedcomp/prompt-collection;1\0"
    /* 0x800b */ "@mozilla.org/jacppurldelegator;1\0"
    /* 0x802c */ "@mozilla.org/charset-converter-manager;1\0"
    /* 0x8055 */ "@mozilla.org/messenger/searchSession;1\0"
    /* 0x807c */ "@mozilla.org/addons/content-policy;1\0"
    /* 0x80a1 */ "@mozilla.org/messengercompose/msgcopy;1\0"
    /* 0x80c9 */ "@mozilla.org/process/environment;1\0"
    /* 0x80ec */ "@mozilla.org/prompter;1\0"
    /* 0x8104 */ "@mozilla.org/messenger/identity;1\0"
    /* 0x8126 */ "@mozilla.org/http-sfv-service;1\0"
    /* 0x8146 */ "@mozilla.org/login-manager;1\0"
    /* 0x8163 */ "@mozilla.org/streamconv;1?from=x-compress&to=uncompressed\0"
    /* 0x819d */ "@mozilla.org/network/native-dns-override;1\0"
    /* 0x81c8 */ "@mozilla.org/parental-controls-service;1\0"
    /* 0x81f1 */ "@mozilla.org/jacppincomingserverdelegator;1\0"
    /* 0x821d */ "@mozilla.org/ldapsyncquery;1\0"
    /* 0x823a */ "@mozilla.org/fingerprinting-override;1\0"
    /* 0x8261 */ "@mozilla.org/observer-service;1\0"
    /* 0x8281 */ "@mozilla.org/uriloader/web-handler-app;1\0"
    /* 0x82aa */ "@mozilla.org/messengercompose/sendlater;1\0"
    /* 0x82d4 */ "@mozilla.org/addressbook/directoryproperty;1\0"
    /* 0x8301 */ "@mozilla.org/network/network-link-service;1\0"
    /* 0x832d */ "@mozilla.org/network/well-known-opportunistic-utils;1\0"
    /* 0x8363 */ "@mozilla.org/thirdpartyutil;1\0"
    /* 0x8381 */ "@mozilla.org/processtools-service;1\0"
    /* 0x83a5 */ "@mozilla.org/messenger/tagservice;1\0"
    /* 0x83c9 */ "@mozilla.org/startupcacheinfo;1\0"
    /* 0x83e9 */ "@mozilla.org/network/protocol;1?name=mailto\0"
    /* 0x8415 */ "@mozilla.org/clear-by-site-entry;1\0"
    /* 0x8438 */ "@mozilla.org/messenger/mailboxurl;1\0"
    /* 0x845c */ "@mozilla.org/nsMsgDatabase/msgDB-news\0"
    /* 0x8482 */ "@mozilla.org/mail/folder-factory;1?name=news\0"
    /* 0x84af */ "@mozilla.org/network/url-parser;1?auth=no\0"
    /* 0x84d9 */ "@mozilla.org/supports-string;1\0"
    /* 0x84f8 */ "@mozilla.org/thread-manager;1\0"
    /* 0x8516 */ "@mozilla.org/streamconv;1?from=application/octet-stream&to=*/*\0"
    /* 0x8555 */ "@mozilla.org/network/protocol/about;1?what=logo\0"
    /* 0x8585 */ "@mozilla.org/dom/rtpreceiver;1\0"
    /* 0x85a4 */ "@mozilla.org/places/previews-helper;1\0"
    /* 0x85ca */ "@mozilla.org/url-classifier/utils;1\0"
    /* 0x85ee */ "@mozilla.org/supports-PRUint32;1\0"
    /* 0x860f */ "@mozilla.org/tracking-db-service;1\0"
    /* 0x8632 */ "@mozilla.org/gfx/printsettings-service;1\0"
    /* 0x865b */ "@mozilla.org/serviceworkers/manager;1\0"
    /* 0x8681 */ "@mozilla.org/layout/contentserializer;1?mimetype=text/plain\0"
    /* 0x86bd */ "@mozilla.org/network/input-stream-channel;1\0"
    /* 0x86e9 */ "@mozilla.org/addressbook/directory-query/proxy;1\0"
    /* 0x871a */ "@mozilla.org/msgFolder/msgFolderService;1\0"
    /* 0x8744 */ "@mozilla.org/nss_errors_service;1\0"
    /* 0x8766 */ "@mozilla.org/widget/parent/dragservice;1\0"
    /* 0x878f */ "@mozilla.org/push/Notifier;1\0"
    /* 0x87ac */ "@mozilla.org/uriloader/content-handler;1?type=application/x-itip-internal\0"
    /* 0x87f6 */ "@mozilla.org/calendar/alarm;1\0"
    /* 0x8814 */ "@mozilla.org/scriptableinputstream;1\0"
    /* 0x8839 */ "@mozilla.org/dom/peerconnectionobserver;1\0"
    /* 0x8863 */ "@mozilla.org/calendar/itip-item;1\0"
    /* 0x8885 */ "@mozilla.org/network/tcp-filter-handler;1?name=stun\0"
    /* 0x88b9 */ "@mozilla.org/messenger/nntpservice;1\0"
    /* 0x88de */ "@mozilla.org/activity-manager-ui;1\0"
    /* 0x8901 */ "@mozilla.org/url-classifier/list-service;1\0"
    /* 0x892c */ "@mozilla.org/network/protocol/about;1?what=httpsonlyerror\0"
    /* 0x8966 */ "@mozilla.org/messenger/imapmockchannel;1\0"
    /* 0x898f */ "@mozilla.org/eventlistenerservice;1\0"
    /* 0x89b3 */ "@mozilla.org/securityconsole/message;1\0"
    /* 0x89da */ "@mozilla.org/binaryinputstream;1\0"
    /* 0x89fb */ "@mozilla.org/network/protocol/about;1?what=checkerboard\0"
    /* 0x8a33 */ "@mozilla.org/addressbook/msgvcardservice;1\0"
    /* 0x8a5e */ "@mozilla.org/network/safe-file-output-stream;1\0"
    /* 0x8a8d */ "@mozilla.org/key-value-service;1\0"
    /* 0x8aae */ "@mozilla.org/transfer;1\0"
    /* 0x8ac6 */ "@mozilla.org/activity-event;1\0"
    /* 0x8ae4 */ "@mozilla.org/passwordmanager/authpromptfactory;1\0"
    /* 0x8b15 */ "@mozilla.org/jsreflect;1\0"
    /* 0x8b2e */ "@mozilla.org/streamconv;1?from=application/x-unknown-content-type&to=*/*\0"
    /* 0x8b77 */ "@mozilla.org/network/protocol/about;1?what=import\0"
    /* 0x8ba9 */ "@mozilla.org/messengercompose/computils;1\0"
    /* 0x8bd3 */ "@mozilla.org/network/protocol;1?name=resource\0"
    /* 0x8c01 */ "@mozilla.org/uriloader/local-handler-app;1\0"
    /* 0x8c2c */ "@mozilla.org/network-error-logging;1\0"
    /* 0x8c51 */ "@mozilla.org/mime/pgp-mime-decrypt;1\0"
    /* 0x8c76 */ "@mozilla.org/streamconv;1?from=multipart/x-mixed-replace&to=*/*\0"
    /* 0x8cb6 */ "@mozilla.org/security/ClientAuthDialogService;1\0"
    /* 0x8ce6 */ "@mozilla.org/streamconv;1?from=application/octet-stream&to=text/html\0"
    /* 0x8d2b */ "@mozilla.org/security/random-generator;1\0"
    /* 0x8d54 */ "@mozilla.org/db/mork;1\0"
    /* 0x8d6b */ "@mozilla.org/security/CRLiteTimestamp;1\0"
    /* 0x8d93 */ "@mozilla.org/appshell/component/messenger;1\0"
    /* 0x8dbf */ "@mozilla.org/image/encoder;2?type=image/jpeg\0"
    /* 0x8dec */ "@mozilla.org/cascade-filter;1\0"
    /* 0x8e0a */ "@mozilla.org/network/protocol;1?name=moz-safe-about\0"
    /* 0x8e3e */ "@mozilla.org/io/string-input-stream;1\0"
    /* 0x8e64 */ "@mozilla.org/security/datastoragemanager;1\0"
    /* 0x8e8f */ "@mozilla.org/network/ldap-service;1\0"
    /* 0x8eb3 */ "@mozilla.org/layout/content-policy;1\0"
    /* 0x8ed8 */ "@mozilla.org/streamconv;1?from=br&to=uncompressed\0"
    /* 0x8f0a */ "@mozilla.org/network/simple-stream-listener;1\0"
    /* 0x8f38 */ "@mozilla.org/network/protocol;1?name=moz\0"
    /* 0x8f61 */ "@mozilla.org/moz/jssubscript-loader;1\0"
    /* 0x8f87 */ "@mozilla.org/activity-warning;1\0"
    /* 0x8fa7 */ "@mozilla.org/calendar/timezone-database;1\0"
    /* 0x8fd1 */ "@mozilla.org/synth-voice-registry;1\0"
    /* 0x8ff5 */ "@mozilla.org/calendar/recurrence-date;1\0"
    /* 0x901d */ "@mozilla.org/nsMsgDatabase/msgDB-imap\0"
    /* 0x9043 */ "@mozilla.org/consoleAPI-storage;1\0"
    /* 0x9065 */ "@mozilla.org/supports-PRBool;1\0"
    /* 0x9084 */ "@mozilla.org/uriclassifierservice\0"
    /* 0x90a6 */ "@mozilla.org/msgDatabase/retentionSettings;1\0"
    /* 0x90d3 */ "@mozilla.org/toolkit/profile-migrator;1\0"
    /* 0x90fb */ "@mozilla.org/streamconv;1?from=message/rfc822&to=*/*\0"
    /* 0x9130 */ "@mozilla.org/query-stripping-list-service;1\0"
    /* 0x915c */ "@mozilla.org/xre/directory-provider;1\0"
    /* 0x9182 */ "@mozilla.org/network/effective-tld-service;1\0"
    /* 0x91af */ "@mozilla.org/toolkit/profile-service;1\0"
    /* 0x91d6 */ "@mozilla.org/messenger/mimeconverter;1\0"
    /* 0x91fd */ "@mozilla.org/messenger/msgFolderCache;1\0"
    /* 0x9225 */ "@mozilla.org/network/protocol/about;1?what=profiles\0"
    /* 0x9259 */ "@mozilla.org/streamconv;1?from=uncompressed&to=rawdeflate\0"
    /* 0x9293 */ "@mozilla.org/third-party-cookie-exception-entry;1\0"
    /* 0x92c5 */ "@mozilla.org/mailnews/virtual-folder-wrapper;1\0"
    /* 0x92f4 */ "@mozilla.org/browser/identitycredentialpromptservice;1\0"
    /* 0x932b */ "@mozilla.org/supports-char;1\0"
    /* 0x9348 */ "@mozilla.org/timer-manager;1\0"
    /* 0x9365 */ "@mozilla.org/autocomplete/controller;1\0"
    /* 0x938c */ "@mozilla.org/security/nssversion;1\0"
    /* 0x93af */ "@mozilla.org/security/pkcs11moduledb;1\0"
    /* 0x93d6 */ "@mozilla.org/network/mock-network-controller;1\0"
    /* 0x9405 */ "@mozilla.org/mail/folder;1?name=mailbox\0"
    /* 0x942d */ "@mozilla.org/network/stream-listener-tee;1\0"
    /* 0x9458 */ "@mozilla.org/messengercompose/composefields;1\0"
    /* 0x9486 */ "@mozilla.org/messenger-smime/smime-encrypted-uris-service;1\0"
    /* 0x94c2 */ "@mozilla.org/messenger/popurl;1\0"
    /* 0x94e2 */ "@mozilla.org/gfx/fontenumerator;1\0"
    /* 0x9504 */ "@mozilla.org/network/protocol/about;1?what=about\0"
    /* 0x9535 */ "@mozilla.org/ssservice;1\0"
    /* 0x954e */ "@mozilla.org/supports-double;1\0"
    /* 0x956d */ "@mozilla.org/enterprisepolicies;1\0"
    /* 0x958f */ "@mozilla.org/webspeech/service;1?name=online\0"
    /* 0x95bc */ "@mozilla.org/network/protocol-proxy-service;1\0"
    /* 0x95ea */ "@mozilla.org/chat/facebook;1\0"
    /* 0x9607 */ "@mozilla.org/network/async-stream-copier;1\0"
    /* 0x9632 */ "@mozilla.org/messenger/biffManager;1\0"
    /* 0x9657 */ "@mozilla.org/ml-utils;1\0"
    /* 0x966f */ "@mozilla.org/dom/rtcsessiondescription;1\0"
    /* 0x9698 */ "@mozilla.org/uuid-generator;1\0"
    /* 0x96b6 */ "@mozilla.org/calendar/calendar;1?type=memory\0"
    /* 0x96e3 */ "@mozilla.org/array;1\0"
    /* 0x96f8 */ "@mozilla.org/layout/contentserializer;1?mimetype=text/xml\0"
    /* 0x9732 */ "@mozilla.org/messenger/msgdbview;1?type=threadswithunread\0"
    /* 0x976c */ "@mozilla.org/network/buffered-output-stream;1\0"
    /* 0x979a */ "@mozilla.org/network/atomic-file-output-stream;1\0"
    /* 0x97cb */ "@mozilla.org/cookieJarSettings;1\0"
    /* 0x97ec */ "@mozilla.org/calendar/recurrence-info;1\0"
    /* 0x9814 */ "@mozilla.org/image/encoder;2?type=image/png\0"
    /* 0x9840 */ "@mozilla.org/supports-PRUint8;1\0"
    /* 0x9860 */ "@mozilla.org/docloaderservice;1\0"
    /* 0x9880 */ "@mozilla.org/browser/nav-bookmarks-service;1\0"
    /* 0x98ad */ "@mozilla.org/permissionmanager;1\0"
    /* 0x98ce */ "@mozilla.org/webauthn/service;1\0"
    /* 0x98ee */ "@mozilla.org/network/idn-service;1\0"
    /* 0x9911 */ "@mozilla.org/helperapplauncherdialog;1\0"
    /* 0x9938 */ "@mozilla.org/addressbook/ldap-attribute-map-service;1\0"
    /* 0x996e */ "@mozilla.org/addressbook/directory;1?type=jscarddav\0"
    /* 0x99a2 */ "@mozilla.org/network/util;1\0"
    /* 0x99be */ "@mozilla.org/network/protocol;1?name=wss\0"
    /* 0x99e7 */ "@mozilla.org/messenger/protocol/info;1?type=imap\0"
    /* 0x9a18 */ "@mozilla.org/streamconv;1?from=uncompressed&to=deflate\0"
    /* 0x9a4f */ "@mozilla.org/login-manager/crypto/SDR;1\0"
    /* 0x9a77 */ "@mozilla.org/push/Service;1\0"
    /* 0x9a93 */ "@mozilla.org/chat/irc;1\0"
    /* 0x9aab */ "@mozilla.org/network/ldap-url;1\0"
    /* 0x9acb */ "@mozilla.org/notificationStorage;1\0"
    /* 0x9aee */ "@mozilla.org/consoleservice;1\0"
    /* 0x9b0c */ "@mozilla.org/network/incremental-stream-loader;1\0"
    /* 0x9b3d */ "@mozilla.org/dom/rtcicecandidate;1\0"
    /* 0x9b60 */ "@mozilla.org/libjar/zip-reader-cache;1\0"
    /* 0x9b87 */ "@mozilla.org/rdd-process-test;1\0"
    /* 0x9ba7 */ "@mozilla.org/dom/peerconnection;1\0"
    /* 0x9bc9 */ "@mozilla.org/io/multiplex-input-stream;1\0"
    /* 0x9bf2 */ "@mozilla.org/uriloader/external-helper-app-service;1\0"
    /* 0x9c27 */ "@mozilla.org/mail/folder-lookup;1\0"
    /* 0x9c49 */ "@mozilla.org/network/protocol/about;1?what=config\0"
    /* 0x9c7b */ "@mozilla.org/network/protocol;1?name=cached-favicon\0"
    /* 0x9caf */ "@mozilla.org/msgstore/maildirstore;1\0"
    /* 0x9cd4 */ "@mozilla.org/messenger/msgdbview;1?type=quicksearch\0"
    /* 0x9d08 */ "@mozilla.org/messenger/messageservice;1?type=x-moz-ews\0"
    /* 0x9d3f */ "@mozilla.org/scriptable-content-iterator;1\0"
    /* 0x9d6a */ "@mozilla.org/storage/activity-service;1\0"
    /* 0x9d92 */ "@mozilla.org/nsCertGen;1\0"
    /* 0x9dab */ "@mozilla.org/network/protocol/about;1?what=translations\0"
    /* 0x9de3 */ "@mozilla.org/docshell/uri-fixup;1\0"
    /* 0x9e05 */ "@mozilla.org/msg-trait-service;1\0"
    /* 0x9e26 */ "@mozilla.org/load-context-info-factory;1\0"
    /* 0x9e4f */ "@mozilla.org/chat/gtalk;1\0"
    /* 0x9e69 */ "@mozilla.org/messenger/account;1\0"
    /* 0x9e8a */ "@mozilla.org/addressbook/ldap-directory-query;1\0"
    /* 0x9eba */ "@mozilla.org/network/udp-socket;1\0"
    /* 0x9edc */ "@mozilla.org/streamconv;1?from=gzip&to=uncompressed\0"
    /* 0x9f10 */ "@mozilla.org/network/protocol/about;1?what=message\0"
    /* 0x9f43 */ "@mozilla.org/network/protocol;1?name=mailbox\0"
    /* 0x9f70 */ "@mozilla.org/backgroundtasksrunner;1\0"
    /* 0x9f95 */ "@mozilla.org/toolkit/shutdown-terminator;1\0"
    /* 0x9fc0 */ "@mozilla.org/find/find_service;1\0"
    /* 0x9fe1 */ "@mozilla.org/spellchecker/engine;1\0"
    /* 0xa004 */ "@mozilla.org/messenger/progress;1\0"
    /* 0xa026 */ "@mozilla.org/msgstore/berkeleystore;1\0"
    /* 0xa04c */ "@mozilla.org/network/protocol/about;1?what=preferences\0"
    /* 0xa083 */ "@mozilla.org/network/protocol/about;1?what=webauthn\0"
    /* 0xa0b7 */ "@mozilla.org/import/import-service;1\0"
    /* 0xa0dc */ "@mozilla.org/network/protocol/about;1?what=profiling\0"
    /* 0xa111 */ "@mozilla.org/network/buffered-input-stream;1\0"
    /* 0xa13e */ "@mozilla.org/addressbook/directory;1?type=moz-abldapdirectory\0"
    /* 0xa17c */ "@mozilla.org/mail/search/validityManager;1\0"
    /* 0xa1a7 */ "@mozilla.org/image/encoder;2?type=image/bmp\0"
    /* 0xa1d3 */ "@mozilla.org/jsinspector;1\0"
    /* 0xa1ee */ "@mozilla.org/image/encoder;2?type=image/webp\0"
    /* 0xa21b */ "@mozilla.org/addressbook/ldap-replication-service;1\0"
    /* 0xa24f */ "@mozilla.org/messenger/subscribableserver;1\0"
    /* 0xa27b */ "@mozilla.org/cookie-banner-list-service;1\0"
    /* 0xa2a5 */ "@mozilla.org/messenger/server;1?type=im\0"
    /* 0xa2cd */ "@mozilla.org/user-characteristics-page;1\0"
    /* 0xa2f6 */ "@mozilla.org/network/protocol;1?name=default\0"
    /* 0xa323 */ "@mozilla.org/calendar/todo;1\0"
    /* 0xa340 */ "@mozilla.org/network/protocol/about;1?what=certificate\0"
    /* 0xa377 */ "@mozilla.org/network/mime-hdrparam;1\0"
    /* 0xa39c */ "@mozilla.org/messenger/fts3tokenizer;1\0"
    /* 0xa3c3 */ "@mozilla.org/widget/appshell/gtk;1\0"
    /* 0xa3e6 */ "@mozilla.org/browser/search-service;1\0"
    /* 0xa40c */ "@mozilla.org/messengercompose/composesecure;1\0"
    /* 0xa43a */ "@mozilla.org/parent/filepicker;1\0"
    /* 0xa45b */ "@mozilla.org/network/protocol;1?name=data\0"
    /* 0xa485 */ "@mozilla.org/gecko-media-plugin-service;1\0"
    /* 0xa4af */ "@mozilla.org/calendar/calendar;1?type=caldav\0"
    /* 0xa4dc */ "@mozilla.org/login-manager/prompter;1\0"
    /* 0xa502 */ "@mozilla.org/geolocation;1\0"
    /* 0xa51d */ "@mozilla.org/network/protocol;1?name=blob\0"
    /* 0xa547 */ "@mozilla.org/widget/dragservice;1\0"
    /* 0xa569 */ "@mozilla.org/image/tools;1\0"
    /* 0xa584 */ "@mozilla.org/url-classifier/exception-list;1\0"
    /* 0xa5b1 */ "@mozilla.org/messenger/windowservice;1\0"
    /* 0xa5d8 */ "@mozilla.org/network/protocol;1?name=ws\0"
    /* 0xa600 */ "@mozilla.org/network/protocol/about;1?what=telemetry\0"
    /* 0xa635 */ "@mozilla.org/autocomplete/search;1?name=gloda\0"
    /* 0xa663 */ "@mozilla.org/streamconv;1?from=deflate&to=uncompressed\0"
    /* 0xa69a */ "@mozilla.org/autocomplete/search;1?name=login-doorhanger-username\0"
    /* 0xa6dc */ "@mozilla.org/network/cache-storage-service;1\0"
    /* 0xa709 */ "@mozilla.org/dom/workers/workerdebuggermanager;1\0"
    /* 0xa73a */ "@mozilla.org/messenger/msgmailnewsurl;1\0"
    /* 0xa762 */ "@mozilla.org/intl/ospreferences;1\0"
    /* 0xa784 */ "@mozilla.org/chat/odnoklassniki;1\0"
    /* 0xa7a6 */ "@mozilla.org/memoryNotificationStorage;1\0"
    /* 0xa7cf */ "@mozilla.org/network/protocol/about;1?what=crashparent\0"
    /* 0xa806 */ "@mozilla.org/messenger/messageservice;1?type=news\0"
    /* 0xa838 */ "@mozilla.org/calendar/ics-service;1\0"
    /* 0xa85c */ "@mozilla.org/network/protocol;1?name=imap\0"
    /* 0xa886 */ "@mozilla.org/messengercompose/quoting;1\0"
    /* 0xa8ae */ "@mozilla.org/mail/default-mail-clh;1\0"
    /* 0xa8d3 */ "@mozilla.org/network/authprompt-adapter-factory;1\0"
    /* 0xa905 */ "@mozilla.org/nsCMSEncoder;1\0"
    /* 0xa921 */ "@mozilla.org/extensions/native-messaging-portal;1\0"
    /* 0xa953 */ "@mozilla.org/fingerprinting-webcompat-service;1\0"
    /* 0xa983 */ "@mozilla.org/toolkit/captive-detector;1\0"
    /* 0xa9ab */ "@mozilla.org/messenger/popservice;1\0"
    /* 0xa9cf */ "@mozilla.org/gfx/screenmanager;1\0"
    /* 0xa9f0 */ "@mozilla.org/messenger/imapservice;1\0"
    /* 0xaa15 */ "@mozilla.org/widget/htmlformatconverter;1\0"
    /* 0xaa3f */ "@mozilla.org/network/protocol;1?name=ldap\0"
    /* 0xaa69 */ "@mozilla.org/network/predictor;1\0"
    /* 0xaa8a */ "@mozilla.org/security/contentsignatureverifier;1\0"
    /* 0xaabb */ "@mozilla.org/uriloader/external-protocol-service;1\0"
    /* 0xaaee */ "@mozilla.org/network/input-stream-pump;1\0"
    /* 0xab17 */ "@mozilla.org/scriptablebase64encoder;1\0"
    /* 0xab3e */ "@mozilla.org/network/protocol/about;1?what=license\0"
    /* 0xab71 */ "@mozilla.org/newsblog-feed-downloader;1\0"
    /* 0xab99 */ "@mozilla.org/jacppmsgfolderdelegator;1\0"
    /* 0xabc0 */ "@mozilla.org/messenger/messageservice;1?type=imap\0"
    /* 0xabf2 */ "@mozilla.org/messenger;1\0"
    /* 0xac0b */ "@mozilla.org/supports-PRInt64;1\0"
    /* 0xac2b */ "@mozilla.org/parent/colorpicker;1\0"
    /* 0xac4d */ "@mozilla.org/ipc/processselector;1\0"
    /* 0xac70 */ "@mozilla.org/network/protocol;1?name=jar\0"
    /* 0xac99 */ "@mozilla.org/messenger/messageservice;1?type=news-message\0"
    /* 0xacd3 */ "@mozilla.org/eventsourceevent/service;1\0"
    /* 0xacfb */ "@mozilla.org/msgDatabase/msgDBService;1\0"
    /* 0xad23 */ "@mozilla.org/network/protocol/about;1?what=certerror\0"
    /* 0xad58 */ "@mozilla.org/network/file-random-access-stream;1\0"
    /* 0xad89 */ "@mozilla.org/base/daptelemetry;1\0"
    /* 0xadaa */ "@mozilla.org/network/protocol/about;1?what=addressbook\0"
    /* 0xade1 */ "@mozilla.org/nsTokenPasswordDialogs;1\0"
    /* 0xae07 */ "@mozilla.org/xul/xulstore;1\0"
    /* 0xae23 */ "@mozilla.org/dom/session-storage-service;1\0"
    /* 0xae4e */ "@mozilla.org/content-dispatch-chooser;1\0"
    /* 0xae76 */ "@mozilla.org/widget/useridleservice;1\0"
    /* 0xae9c */ "@mozilla.org/autocomplete/search;1?name=news\0"
    /* 0xaec9 */ "@mozilla.org/url-classifier/prefixset;1\0"
    /* 0xaef1 */ "@mozilla.org/url-classifier/streamupdater;1\0"
    /* 0xaf1d */ "@mozilla.org/sqlite-key-value-service;1\0"
    /* 0xaf45 */ "@mozilla.org/libjar/zip-reader;1\0"
    /* 0xaf66 */ "@mozilla.org/network/protocol/about;1?what=processes\0"
    /* 0xaf9b */ "@mozilla.org/nsCMSSecureMessage;1\0"
    /* 0xafbd */ "@mozilla.org/ospermissionrequest;1\0"
    /* 0xafe0 */ "@mozilla.org/docshell/uri-fixup-info;1\0"
    /* 0xb007 */ "@mozilla.org/network/ldap-operation;1\0"
    /* 0xb02d */ "@mozilla.org/messenger/searchTerm;1\0"
    /* 0xb051 */ "@mozilla.org/messengercompose/attachedfile;1\0"
    /* 0xb07e */ "@mozilla.org/mozintl;1\0"
    /* 0xb095 */ "@mozilla.org/messenger/messagestateparser;1\0"
    /* 0xb0c1 */ "@mozilla.org/calendar/attendee;1\0"
    /* 0xb0e2 */ "@mozilla.org/network/protocol;1?name=ews\0"
    /* 0xb10b */ "@mozilla.org/messengercompose/attachment;1\0"
    /* 0xb136 */ "@mozilla.org/messenger/messageservice;1?type=imap-message\0"
    /* 0xb170 */ "@mozilla.org/appshell/window-mediator;1\0"
    /* 0xb198 */ "@mozilla.org/streamconv;1?from=application/http-index-format&to=text/html\0"
    /* 0xb1e2 */ "@mozilla.org/utility-process-test;1\0"
    /* 0xb206 */ "@mozilla.org/activity-process;1\0"
    /* 0xb226 */ "@mozilla.org/uriloader;1\0"
    /* 0xb23f */ "@mozilla.org/addons/addon-manager-startup;1\0"
    /* 0xb26b */ "@mozilla.org/intl/scriptableunicodeconverter\0"
    /* 0xb298 */ "@mozilla.org/autocomplete/search;1?name=addrbook\0"
    /* 0xb2c9 */ "@mozilla.org/network/protocol;1?name=javascript\0"
    /* 0xb2f9 */ "@mozilla.org/messenger/spamsettings;1\0"
    /* 0xb31f */ "@mozilla.org/toolkit/glean;1\0"
    /* 0xb33c */ "@mozilla.org/network/protocol;1?name=webcal\0"
    /* 0xb368 */ "@mozilla.org/security/osreauthenticator;1\0"
    /* 0xb392 */ "@mozilla.org/network/protocol;1?name=smtp\0"
    /* 0xb3bc */ "@mozilla.org/jacppabdirectorydelegator;1\0"
    /* 0xb3e5 */ "@mozilla.org/addon-web-api/manager;1\0"
    /* 0xb40a */ "@mozilla.org/network/protocol/about;1?what=webrtc\0"
    /* 0xb43c */ "@mozilla.org/network/incremental-download;1\0"
    /* 0xb468 */ "@mozilla.org/messenger/headerparser;1\0"
    /* 0xb48e */ "@mozilla.org/activity-manager;1\0"
    /* 0xb4ae */ "@mozilla.org/preferences-service;1\0"
    /* 0xb4d1 */ "@mozilla.org/childprocessmessagemanager;1\0"
    /* 0xb4fb */ "@mozilla.org/calendar/calendar;1?type=ics\0"
    /* 0xb525 */ "@mozilla.org/messenger/protocol/info;1?type=rss\0"
    /* 0xb555 */ "@mozilla.org/extensions/blocklist;1\0"
    /* 0xb579 */ "@mozilla.org/nsCMSDecoder;1\0"
    /* 0xb595 */ "@mozilla.org/messengercompose/quotinglistener;1\0"
    /* 0xb5c5 */ "@mozilla.org/satchel/form-history-autocomplete;1\0"
    /* 0xb5f6 */ "@mozilla.org/image/encoder;2?type=image/vnd.microsoft.icon\0"
    /* 0xb631 */ "@mozilla.org/notification-handler;1\0"
    /* 0xb655 */ "@mozilla.org/network/oblivious-http;1\0"
    /* 0xb67b */ "@mozilla.org/boolean-expression/n-peer;1\0"
    /* 0xb6a4 */ "@mozilla.org/messenger/nntpurl;1\0"
    /* 0xb6c5 */ "@mozilla.org/network/protocol;1?name=webcals\0"
    /* 0xb6f2 */ "@mozilla.org/calendar/calendar;1?type=composite\0"
    /* 0xb722 */ "@mozilla.org/pref-localizedstring;1\0"
    /* 0xb746 */ "uuid\0"
    /* 0xb74b */ "domStorageManager\0"
    /* 0xb75d */ "telemetry\0"
    /* 0xb767 */ "els\0"
    /* 0xb76b */ "sysinfo\0"
    /* 0xb773 */ "obs\0"
    /* 0xb777 */ "intl\0"
    /* 0xb77c */ "rfp\0"
    /* 0xb780 */ "prefs\0"
    /* 0xb786 */ "DAPTelemetry\0"
    /* 0xb793 */ "appShell\0"
    /* 0xb79c */ "cookieBanners\0"
    /* 0xb7aa */ "vc\0"
    /* 0xb7ad */ "logins\0"
    /* 0xb7b4 */ "dns\0"
    /* 0xb7b8 */ "textToSubURI\0"
    /* 0xb7c5 */ "storage\0"
    /* 0xb7cd */ "xulStore\0"
    /* 0xb7d6 */ "blocklist\0"
    /* 0xb7e0 */ "urlFormatter\0"
    /* 0xb7ed */ "perms\0"
    /* 0xb7f3 */ "locale\0"
    /* 0xb7fa */ "sessionStorage\0"
    /* 0xb809 */ "clearData\0"
    /* 0xb813 */ "droppedLinkHandler\0"
    /* 0xb826 */ "scriptloader\0"
    /* 0xb833 */ "io\0"
    /* 0xb836 */ "focus\0"
    /* 0xb83c */ "policies\0"
    /* 0xb845 */ "fog\0"
    /* 0xb849 */ "profiler\0"
    /* 0xb852 */ "search\0"
    /* 0xb859 */ "qms\0"
    /* 0xb85d */ "strings\0"
    /* 0xb865 */ "env\0"
    /* 0xb869 */ "eTLD\0"
    /* 0xb86e */ "loadContextInfo\0"
    /* 0xb87e */ "ppmm\0"
    /* 0xb883 */ "appinfo\0"
    /* 0xb88b */ "prompt\0"
    /* 0xb892 */ "console\0"
    /* 0xb89a */ "ww\0"
    /* 0xb89d */ "uriFixup\0"
    /* 0xb8a6 */ "catMan\0"
    /* 0xb8ad */ "scriptSecurityManager\0"
    /* 0xb8c3 */ "clipboard\0"
    /* 0xb8cd */ "dirsvc\0"
    /* 0xb8d4 */ "wm\0"
    /* 0xb8d7 */ "tm\0"
    /* 0xb8da */ "cache2\0"
    /* 0xb8e1 */ "startup\0"
    /* 0xb8e9 */ "mm\0"
    /* 0xb8ec */ "cpmm\0"
    /* 0xb8f1 */ "cookies\0"
    /* 0xb8f9 */ "about\0"
    /* 0xb8ff */ "moz-cal-handle-itip\0"
    /* 0xb913 */ "https\0"
    /* 0xb919 */ "x-moz-ews\0"
    /* 0xb923 */ "ldaps\0"
    /* 0xb929 */ "data\0"
    /* 0xb92e */ "mailto\0"
    /* 0xb935 */ "moz-gio\0"
    /* 0xb93d */ "jar\0"
    /* 0xb941 */ "moz-src\0"
    /* 0xb949 */ "cid\0"
    /* 0xb94d */ "smtps\0"
    /* 0xb953 */ "ws\0"
    /* 0xb956 */ "moz-icon\0"
    /* 0xb95f */ "file\0"
    /* 0xb964 */ "wss\0"
    /* 0xb968 */ "cached-favicon\0"
    /* 0xb977 */ "webcal\0"
    /* 0xb97e */ "javascript\0"
    /* 0xb989 */ "moz-safe-about\0"
    /* 0xb998 */ "default\0"
    /* 0xb9a0 */ "webcals\0"
    /* 0xb9a8 */ "moz-page-thumb\0"
    /* 0xb9b7 */ "resource\0"
    /* 0xb9c0 */ "view-source\0"
    /* 0xb9cc */ "news\0"
    /* 0xb9d1 */ "blob\0"
    /* 0xb9d6 */ "smtp\0"
    /* 0xb9db */ "pop3\0"
    /* 0xb9e0 */ "page-icon\0"
    /* 0xb9ea */ "moz-extension\0"
    /* 0xb9f8 */ "http\0"
    /* 0xb9fd */ "moz\0"
    /* 0xba01 */ "indexeddb\0"
    /* 0xba0b */ "snews\0"
    /* 0xba11 */ "mailbox\0"
    /* 0xba19 */ "chrome\0"
    /* 0xba20 */ "ldap\0"
  "";

const StaticCategory gStaticCategories[kStaticCategoryCount] = {
  { { 0x0 } /* "@mozilla.org/streamconv;1" */,
    0, 11 },
  { { 0x191 } /* "Gecko-Content-Viewers" */,
    11, 27 },
  { { 0x3ca } /* "app-startup" */,
    38, 3 },
  { { 0x48b } /* "cal-exporters" */,
    41, 2 },
  { { 0x516 } /* "cal-importers" */,
    43, 1 },
  { { 0x55d } /* "command-line-handler" */,
    44, 8 },
  { { 0x705 } /* "command-line-validator" */,
    52, 1 },
  { { 0x726 } /* "content-policy" */,
    53, 8 },
  { { 0x882 } /* "content-process-ready-for-script" */,
    61, 1 },
  { { 0x8ef } /* "content-sniffing-services" */,
    62, 2 },
  { { 0x95d } /* "idle-daily" */,
    64, 7 },
  { { 0xb54 } /* "mailnews-accountmanager-extensions" */,
    71, 3 },
  { { 0xc54 } /* "mime-emitter" */,
    74, 5 },
  { { 0xd96 } /* "net-and-orb-content-sniffers" */,
    79, 3 },
  { { 0xde5 } /* "net-channel-event-sinks" */,
    82, 2 },
  { { 0xdfd } /* "net-content-sniffers" */,
    84, 3 },
  { { 0xe49 } /* "orb-content-sniffers" */,
    87, 2 },
  { { 0xe5e } /* "payment-request" */,
    89, 10 },
  { { 0x117f } /* "places-init-complete" */,
    99, 2 },
  { { 0x120f } /* "pref-config-startup" */,
    101, 1 },
  { { 0x124f } /* "profile-after-change" */,
    102, 16 },
  { { 0x15b1 } /* "push" */,
    118, 1 },
  { { 0x15f0 } /* "simple-mime-converters" */,
    119, 3 },
  { { 0x16a4 } /* "speech-synth-started" */,
    122, 2 },
  { { 0x1727 } /* "vacuum-participant" */,
    124, 1 },
  { { 0x176c } /* "xpcom-directory-providers" */,
    125, 1 },
  { { 0x17bf } /* "xpcom-startup" */,
    126, 1 },
};
const StaticCategoryEntry gStaticCategoryEntries[] = {
  /* "@mozilla.org/streamconv;1" */
  { { 0x1a } /* "?from=application/http-index-format&to=text/html" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x4c } /* "?from=application/x-unknown-content-type&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x7c } /* "?from=br&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x95 } /* "?from=compress&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xb4 } /* "?from=deflate&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xd2 } /* "?from=gzip&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xed } /* "?from=multipart/byteranges&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x10f } /* "?from=multipart/mixed&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x12c } /* "?from=multipart/x-mixed-replace&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x153 } /* "?from=x-compress&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x174 } /* "?from=x-gzip&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },

  /* "Gecko-Content-Viewers" */
  { { 0x1a7 } /* "application/http-index-format" */,
    { 0x1c5 } /* "@mozilla.org/content-viewers/http-index-format" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1f4 } /* "application/mathml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x23a } /* "application/rdf+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x24e } /* "application/vnd.wap.xhtml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x26c } /* "application/x-view-source" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x286 } /* "application/xhtml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x29c } /* "application/xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2ac } /* "image/apng" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2b7 } /* "image/bmp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2c1 } /* "image/gif" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2cb } /* "image/icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2d6 } /* "image/jpeg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2e1 } /* "image/jpg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2eb } /* "image/pjpeg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2f7 } /* "image/png" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x301 } /* "image/svg+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x30f } /* "image/vnd.microsoft.icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x328 } /* "image/webp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x333 } /* "image/x-icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x340 } /* "image/x-ms-bmp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x34f } /* "image/x-png" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x35b } /* "message/rfc822" */,
    { 0x36a } /* "@mozilla.org/mailnews/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x39a } /* "text/html" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x3a4 } /* "text/plain" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x3af } /* "text/rdf" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x3b8 } /* "text/vtt" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x3c1 } /* "text/xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "app-startup" */
  { { 0x3d6 } /* "ExtensionsChild" */,
    { 0x3e6 } /* "@mozilla.org/extensions/child;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x406 } /* "FormFillController" */,
    { 0x419 } /* "@mozilla.org/satchel/form-fill-controller;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x445 } /* "WebNavigationContent" */,
    { 0x45a } /* "@mozilla.org/extensions/web-navigation-content;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "cal-exporters" */
  { { 0x499 } /* "cal-html-list-exporter" */,
    { 0x4b0 } /* "@mozilla.org/calendar/export;1?type=htmllist" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x4dd } /* "cal-ics-exporter" */,
    { 0x4ee } /* "@mozilla.org/calendar/export;1?type=ics" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "cal-importers" */
  { { 0x524 } /* "cal-ics-importer" */,
    { 0x535 } /* "@mozilla.org/calendar/import;1?type=ics" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "command-line-handler" */
  { { 0x572 } /* "m-aaa-tb-devtools" */,
    { 0x584 } /* "@mozilla.org/messenger/devtools-startup-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x5b2 } /* "m-backgroundtasks" */,
    { 0x5c4 } /* "@mozilla.org/backgroundtasksmanager;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x5ea } /* "m-compose" */,
    { 0x5f4 } /* "@mozilla.org/messengercompose;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x614 } /* "m-devtools" */,
    { 0x61f } /* "@mozilla.org/devtools/startup-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x643 } /* "m-marionette" */,
    { 0x650 } /* "@mozilla.org/remote/marionette;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x671 } /* "m-remote" */,
    { 0x67a } /* "@mozilla.org/remote/agent;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x696 } /* "x-default" */,
    { 0x6a0 } /* "@mozilla.org/uriloader/content-handler;1?type=text/html" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x6d8 } /* "y-default" */,
    { 0x6e2 } /* "@mozilla.org/toolkit/default-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "command-line-validator" */
  { { 0x71c } /* "b-default" */,
    { 0x6a0 } /* "@mozilla.org/uriloader/content-handler;1?type=text/html" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "content-policy" */
  { { 0x735 } /* "@mozilla.org/data-document-content-policy;1" */,
    { 0x735 } /* "@mozilla.org/data-document-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x761 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
    { 0x761 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x791 } /* "@mozilla.org/image-blocker-content-policy;1" */,
    { 0x791 } /* "@mozilla.org/image-blocker-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x7bd } /* "@mozilla.org/integritypolicyservice;1" */,
    { 0x7bd } /* "@mozilla.org/integritypolicyservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x7e3 } /* "@mozilla.org/messenger/content-policy;1" */,
    { 0x7e3 } /* "@mozilla.org/messenger/content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x80b } /* "@mozilla.org/mixedcontentblocker;1" */,
    { 0x80b } /* "@mozilla.org/mixedcontentblocker;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x82e } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
    { 0x82e } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x85d } /* "CSPService" */,
    { 0x868 } /* "@mozilla.org/cspservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "content-process-ready-for-script" */
  { { 0x8a3 } /* "TelemetryControllerContent" */,
    { 0x8be } /* "@mozilla.org/base/telemetry-controller-content;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::CONTENT_PROCESS_ONLY },

  /* "content-sniffing-services" */
  { { 0x909 } /* "@mozilla.org/image/loader;1" */,
    { 0x925 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "idle-daily" */
  { { 0x968 } /* "BounceTrackingProtection" */,
    { 0x981 } /* "@mozilla.org/bounce-tracking-protection;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x9ab } /* "ContentBlockingTelemetryService" */,
    { 0x9cb } /* "@mozilla.org/content-blocking-telemetry-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x9fd } /* "MozStorage Vacuum Manager" */,
    { 0xa17 } /* "@mozilla.org/storage/vacuum;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa35 } /* "PlacesDBUtilsIdleMaintenance" */,
    { 0xa52 } /* "@mozilla.org/places/databaseUtilsIdleMaintenance;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa85 } /* "QuotaManagerService" */,
    { 0xa99 } /* "@mozilla.org/dom/quota-manager-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xac2 } /* "UrlClassifierExceptionListService" */,
    { 0xae4 } /* "@mozilla.org/url-classifier/exception-list-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xb19 } /* "nsCookieBannerService" */,
    { 0xb2f } /* "@mozilla.org/cookie-banner-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "mailnews-accountmanager-extensions" */
  { { 0xb77 } /* "e2e-account-manager-extension" */,
    { 0xb95 } /* "@mozilla.org/accountmanager/extension;1?name=e2e" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xbc6 } /* "mdn-account-manager-extension" */,
    { 0xbe4 } /* "@mozilla.org/accountmanager/extension;1?name=mdn" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xc15 } /* "newsblog" */,
    { 0xc1e } /* "@mozilla.org/accountmanager/extension;1?name=newsblog" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "mime-emitter" */
  { { 0xc61 } /* "@mozilla.org/messenger/mimeemitter;1?type=application/x-js-mime-message" */,
    { 0xca9 } /* "@mozilla.org/gloda/jsmimeemitter;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xccc } /* "@mozilla.org/messenger/mimeemitter;1?type=raw" */,
    { 0xccc } /* "@mozilla.org/messenger/mimeemitter;1?type=raw" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xcfa } /* "@mozilla.org/messenger/mimeemitter;1?type=text/html" */,
    { 0xcfa } /* "@mozilla.org/messenger/mimeemitter;1?type=text/html" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xd2e } /* "@mozilla.org/messenger/mimeemitter;1?type=text/plain" */,
    { 0xd2e } /* "@mozilla.org/messenger/mimeemitter;1?type=text/plain" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xd63 } /* "@mozilla.org/messenger/mimeemitter;1?type=text/xml" */,
    { 0xd63 } /* "@mozilla.org/messenger/mimeemitter;1?type=text/xml" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "net-and-orb-content-sniffers" */
  { { 0x909 } /* "@mozilla.org/image/loader;1" */,
    { 0x925 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xdb3 } /* "JSONView" */,
    { 0xdbc } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "net-channel-event-sinks" */
  { { 0x80b } /* "@mozilla.org/mixedcontentblocker;1" */,
    { 0x80b } /* "@mozilla.org/mixedcontentblocker;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x85d } /* "CSPService" */,
    { 0x868 } /* "@mozilla.org/cspservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "net-content-sniffers" */
  { { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xe12 } /* "Binary Detector" */,
    { 0xe22 } /* "@mozilla.org/network/binary-detector;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xdb3 } /* "JSONView" */,
    { 0xdbc } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "orb-content-sniffers" */
  { { 0x909 } /* "@mozilla.org/image/loader;1" */,
    { 0x925 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "payment-request" */
  { { 0xe6e } /* "BasicCardMethodChangeDetails" */,
    { 0xe8b } /* "@mozilla.org/dom/payments/basiccard-change-details;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xec0 } /* "BasicCardResponseData" */,
    { 0xed6 } /* "@mozilla.org/dom/payments/basiccard-response-data;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xf0a } /* "GeneralMethodChangeDetails" */,
    { 0xf25 } /* "@mozilla.org/dom/payments/general-change-details;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xf58 } /* "GeneralResponseData" */,
    { 0xf6c } /* "@mozilla.org/dom/payments/general-response-data;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xf9e } /* "PaymentAbortActionResponse" */,
    { 0xfb9 } /* "@mozilla.org/dom/payments/payment-abort-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xff3 } /* "PaymentAddress" */,
    { 0x1002 } /* "@mozilla.org/dom/payments/payment-address;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x102e } /* "PaymentCanMakeActionResponse" */,
    { 0x104b } /* "@mozilla.org/dom/payments/payment-canmake-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1087 } /* "PaymentCompleteActionResponse" */,
    { 0x10a5 } /* "@mozilla.org/dom/payments/payment-complete-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x10e2 } /* "PaymentRequestService" */,
    { 0x10f8 } /* "@mozilla.org/dom/payments/payment-request-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x112c } /* "PaymentShowActionResponse" */,
    { 0x1146 } /* "@mozilla.org/dom/payments/payment-show-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "places-init-complete" */
  { { 0x1194 } /* "PlacesFrecencyRecalculator" */,
    { 0x11af } /* "@mozilla.org/places/frecency-recalculator;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x11db } /* "nsPlacesExpiration" */,
    { 0x11ee } /* "@mozilla.org/places/expiration;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "pref-config-startup" */
  { { 0x1223 } /* "ReadConfig Module" */,
    { 0x1235 } /* "@mozilla.org/readconfig;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "profile-after-change" */
  { { 0x1264 } /* "CrashMonitor" */,
    { 0x1271 } /* "@mozilla.org/toolkit/crashmonitor;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1295 } /* "EssentialDomainsRemoteSettings" */,
    { 0x12b4 } /* "@mozilla.org/EssentialDomainsRemoteSettings;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x12e2 } /* "Marionette" */,
    { 0x650 } /* "@mozilla.org/remote/marionette;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x12ed } /* "Offline-startup" */,
    { 0x12fd } /* "@mozilla.org/offline-startup;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x131c } /* "PurgeTrackerService" */,
    { 0x1330 } /* "@mozilla.org/purge-tracker-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1355 } /* "RemoteAgent" */,
    { 0x67a } /* "@mozilla.org/remote/agent;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1361 } /* "RemotePermissionService" */,
    { 0x1379 } /* "@mozilla.org/remote-permission-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x13a2 } /* "SimpleURIUnknownSchemesRemoteObserver" */,
    { 0x13c8 } /* "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x13fd } /* "URLQueryStringStripper" */,
    { 0x1414 } /* "@mozilla.org/url-query-string-stripper;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x143d } /* "calendar-startup-service" */,
    { 0x1456 } /* "@mozilla.org/calendar/startup-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x147e } /* "deleted-items-manager" */,
    { 0x1494 } /* "@mozilla.org/calendar/deleted-items-manager;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x14c2 } /* "formHistoryStartup" */,
    { 0x14d5 } /* "@mozilla.org/satchel/form-history-startup;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xb19 } /* "nsCookieBannerService" */,
    { 0xb2f } /* "@mozilla.org/cookie-banner-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x1501 } /* "nsCookieBannerTelemetryService" */,
    { 0x1520 } /* "@mozilla.org/cookie-banner-telemetry-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x154f } /* "nsRFPService" */,
    { 0x155c } /* "@mozilla.org/rfp-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x1577 } /* "nsUpdateTimerManager" */,
    { 0x158c } /* "@mozilla.org/updates/timer-manager;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "push" */
  { { 0x15b6 } /* "chrome://fxa-device-update" */,
    { 0x15d1 } /* "@mozilla.org/fxaccounts/push;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "simple-mime-converters" */
  { { 0x1607 } /* "text/calendar" */,
    { 0x1615 } /* "@mozilla.org/calendar/mime-converter;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x163c } /* "text/vcard" */,
    { 0x1647 } /* "@mozilla.org/mimecth;1?type=text/vcard" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x166e } /* "text/x-vcard" */,
    { 0x167b } /* "@mozilla.org/mimecth;1?type=text/x-vcard" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "speech-synth-started" */
  { { 0x16b9 } /* "Fake Speech Synth" */,
    { 0x16cb } /* "@mozilla.org/fakesynth;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x16e4 } /* "SpeechDispatcher Speech Synth" */,
    { 0x1702 } /* "@mozilla.org/synthspeechdispatcher;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "vacuum-participant" */
  { { 0x173a } /* "Places" */,
    { 0x1741 } /* "@mozilla.org/browser/nav-history-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "xpcom-directory-providers" */
  { { 0x1786 } /* "mail-directory-provider" */,
    { 0x179e } /* "@mozilla.org/mail/dir-provider;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "xpcom-startup" */
  { { 0x17cd } /* "nsGIOProtocolHandler" */,
    { 0x17e2 } /* "@mozilla.org/network/protocol;1?name=moz-gio" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
};

const nsXPTInterface gInterfaces[] = {
  nsXPTInterface::calITimezoneDatabase,
  nsXPTInterface::nsIAbManager,
  nsXPTInterface::nsIMsgComposeService,
  nsXPTInterface::nsIMsgOutgoingServerService,
  nsXPTInterface::nsIMsgOutgoingServer,
  nsXPTInterface::nsIMsgDBService,
  nsXPTInterface::nsIImapService,
  nsXPTInterface::nsIImportService,
  nsXPTInterface::nsIMsgHeaderParser,
  nsXPTInterface::nsIMimeConverter,
  nsXPTInterface::nsIMsgFilterService,
  nsXPTInterface::nsIURIFixup,
  nsXPTInterface::nsIDroppedLinkHandler,
  nsXPTInterface::nsIIndexedDatabaseManager,
  nsXPTInterface::nsISessionStorageService,
  nsXPTInterface::nsIPermissionManager,
  nsXPTInterface::nsIStringBundleService,
  nsXPTInterface::mozILocaleService,
  nsXPTInterface::nsITextToSubURI,
  nsXPTInterface::mozIJSSubScriptLoader,
  nsXPTInterface::nsIPrefService,
  nsXPTInterface::nsIPrefBranch,
  nsXPTInterface::nsILoadContextInfoFactory,
  nsXPTInterface::nsICacheStorageService,
  nsXPTInterface::nsIDNSService,
  nsXPTInterface::nsIEffectiveTLDService,
  nsXPTInterface::nsIIOService,
  nsXPTInterface::nsISpeculativeConnect,
  nsXPTInterface::nsINetUtil,
  nsXPTInterface::nsICookieService,
  nsXPTInterface::nsICookieManager,
  nsXPTInterface::nsIObliviousHttpService,
  nsXPTInterface::nsIReplacedHttpResponse,
  nsXPTInterface::nsIUrlClassifierExceptionListEntry,
  nsXPTInterface::nsIUrlClassifierExceptionList,
  nsXPTInterface::mozIStorageService,
  nsXPTInterface::nsIBounceTrackingProtection,
  nsXPTInterface::nsIURLQueryStringStripper,
  nsXPTInterface::nsIAppStartup,
  nsXPTInterface::nsIClearDataService,
  nsXPTInterface::nsIClearBySiteEntry,
  nsXPTInterface::nsIContentBlockingAllowList,
  nsXPTInterface::nsICookieBannerService,
  nsXPTInterface::nsICookieBannerRule,
  nsXPTInterface::nsICookieBannerTelemetryService,
  nsXPTInterface::nsIIdentityCredentialStorageService,
  nsXPTInterface::nsIEnterprisePolicies,
  nsXPTInterface::nsIFOG,
  nsXPTInterface::nsIMLUtils,
  nsXPTInterface::mozIMozIntl,
  nsXPTInterface::nsILoginManager,
  nsXPTInterface::nsIPromptService,
  nsXPTInterface::nsIRFPService,
  nsXPTInterface::nsIRFPTargetSetIDL,
  nsXPTInterface::nsISearchService,
  nsXPTInterface::nsITelemetry,
  nsXPTInterface::nsIDAPTelemetry,
  nsXPTInterface::nsIURLFormatter,
  nsXPTInterface::nsIXULStore,
  nsXPTInterface::nsIBlocklistService,
  nsXPTInterface::nsIXULRuntime,
  nsXPTInterface::nsIXULAppInfo,
  nsXPTInterface::nsICrashReporter,
  nsXPTInterface::nsIWindowWatcher,
  nsXPTInterface::nsIProfiler,
  nsXPTInterface::nsIClipboard,
  nsXPTInterface::nsIClipboard,
  nsXPTInterface::nsIConsoleService,
  nsXPTInterface::nsIPropertyBag2,
  nsXPTInterface::nsISystemInfo,
  nsXPTInterface::nsIThreadManager,
  nsXPTInterface::nsIUUIDGenerator,
  nsXPTInterface::nsIVersionComparator,
  nsXPTInterface::nsICategoryManager,
  nsXPTInterface::nsIObserverService,
  nsXPTInterface::nsIDirectoryService,
  nsXPTInterface::nsIProperties,
  nsXPTInterface::nsIEnvironment,
  nsXPTInterface::nsIAppShellService,
  nsXPTInterface::nsIWindowMediator,
  nsXPTInterface::nsIDOMStorageManager,
  nsXPTInterface::nsILocalStorageManager,
  nsXPTInterface::nsIQuotaManagerService,
  nsXPTInterface::nsIEventListenerService,
  nsXPTInterface::nsIFocusManager,
  nsXPTInterface::nsIScriptSecurityManager,
};

const StringOffset gComponentESModules[] = {
 { 0x180f } /* "chrome://remote/content/components/Marionette.sys.mjs" */,
 { 0x1845 } /* "chrome://remote/content/components/RemoteAgent.sys.mjs" */,
 { 0x187c } /* "moz-src:///comm/mail/components/devtools/devtools-loader.sys.mjs" */,
 { 0x18bd } /* "moz-src:///dom/notification/NotificationStorage.sys.mjs" */,
 { 0x18f5 } /* "resource:///modules/AME2E.sys.mjs" */,
 { 0x1917 } /* "resource:///modules/AbAutoCompleteMyDomain.sys.mjs" */,
 { 0x194a } /* "resource:///modules/AbAutoCompleteSearch.sys.mjs" */,
 { 0x197b } /* "resource:///modules/AbLDAPAttributeMap.sys.mjs" */,
 { 0x19aa } /* "resource:///modules/AbLDAPAutoCompleteSearch.sys.mjs" */,
 { 0x19df } /* "resource:///modules/AboutDebuggingRegistration.sys.mjs" */,
 { 0x1a16 } /* "resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs" */,
 { 0x1a53 } /* "resource:///modules/AboutRedirector.sys.mjs" */,
 { 0x1a7f } /* "resource:///modules/Activity.sys.mjs" */,
 { 0x1aa4 } /* "resource:///modules/ActivityManager.sys.mjs" */,
 { 0x1ad0 } /* "resource:///modules/ActivityManagerUI.sys.mjs" */,
 { 0x1afe } /* "resource:///modules/AddrBookCard.sys.mjs" */,
 { 0x1b27 } /* "resource:///modules/AddrBookManager.sys.mjs" */,
 { 0x1b53 } /* "resource:///modules/CalAlarm.sys.mjs" */,
 { 0x1b78 } /* "resource:///modules/CalAlarmMonitor.sys.mjs" */,
 { 0x1ba4 } /* "resource:///modules/CalAlarmService.sys.mjs" */,
 { 0x1bd0 } /* "resource:///modules/CalAttachment.sys.mjs" */,
 { 0x1bfa } /* "resource:///modules/CalAttendee.sys.mjs" */,
 { 0x1c22 } /* "resource:///modules/CalCalendarManager.sys.mjs" */,
 { 0x1c51 } /* "resource:///modules/CalCompositeCalendar.sys.mjs" */,
 { 0x1c82 } /* "resource:///modules/CalDateTime.sys.mjs" */,
 { 0x1caa } /* "resource:///modules/CalDavCalendar.sys.mjs" */,
 { 0x1cd5 } /* "resource:///modules/CalDefaultACLManager.sys.mjs" */,
 { 0x1d06 } /* "resource:///modules/CalDeletedItems.sys.mjs" */,
 { 0x1d32 } /* "resource:///modules/CalDuration.sys.mjs" */,
 { 0x1d5a } /* "resource:///modules/CalEvent.sys.mjs" */,
 { 0x1d7f } /* "resource:///modules/CalFreeBusyService.sys.mjs" */,
 { 0x1dae } /* "resource:///modules/CalHtmlExport.sys.mjs" */,
 { 0x1dd8 } /* "resource:///modules/CalICSCalendar.sys.mjs" */,
 { 0x1e03 } /* "resource:///modules/CalICSService.sys.mjs" */,
 { 0x1e2d } /* "resource:///modules/CalIcsImportExport.sys.mjs" */,
 { 0x1e5c } /* "resource:///modules/CalIcsParser.sys.mjs" */,
 { 0x1e85 } /* "resource:///modules/CalIcsSerializer.sys.mjs" */,
 { 0x1eb2 } /* "resource:///modules/CalItipEmailTransport.sys.mjs" */,
 { 0x1ee4 } /* "resource:///modules/CalItipItem.sys.mjs" */,
 { 0x1f0c } /* "resource:///modules/CalItipProtocolHandler.sys.mjs" */,
 { 0x1f3f } /* "resource:///modules/CalMemoryCalendar.sys.mjs" */,
 { 0x1f6d } /* "resource:///modules/CalMimeConverter.sys.mjs" */,
 { 0x1f9a } /* "resource:///modules/CalPeriod.sys.mjs" */,
 { 0x1fc0 } /* "resource:///modules/CalProtocolHandler.sys.mjs" */,
 { 0x1fef } /* "resource:///modules/CalRecurrenceDate.sys.mjs" */,
 { 0x201d } /* "resource:///modules/CalRecurrenceInfo.sys.mjs" */,
 { 0x204b } /* "resource:///modules/CalRecurrenceRule.sys.mjs" */,
 { 0x2079 } /* "resource:///modules/CalRelation.sys.mjs" */,
 { 0x20a1 } /* "resource:///modules/CalStartupService.sys.mjs" */,
 { 0x20cf } /* "resource:///modules/CalStorageCalendar.sys.mjs" */,
 { 0x20fe } /* "resource:///modules/CalTimezoneService.sys.mjs" */,
 { 0x212d } /* "resource:///modules/CalTodo.sys.mjs" */,
 { 0x2151 } /* "resource:///modules/CalWeekInfoService.sys.mjs" */,
 { 0x2180 } /* "resource:///modules/CardDAVDirectory.sys.mjs" */,
 { 0x21ad } /* "resource:///modules/DevToolsStartup.sys.mjs" */,
 { 0x21d9 } /* "resource:///modules/GlodaAutoComplete.sys.mjs" */,
 { 0x2207 } /* "resource:///modules/IMIncomingServer.sys.mjs" */,
 { 0x2234 } /* "resource:///modules/IMProtocolInfo.sys.mjs" */,
 { 0x225f } /* "resource:///modules/LDAPConnection.sys.mjs" */,
 { 0x228a } /* "resource:///modules/LDAPDirectory.sys.mjs" */,
 { 0x22b4 } /* "resource:///modules/LDAPDirectoryQuery.sys.mjs" */,
 { 0x22e3 } /* "resource:///modules/LDAPOperation.sys.mjs" */,
 { 0x230d } /* "resource:///modules/LDAPProtocolHandler.sys.mjs" */,
 { 0x233d } /* "resource:///modules/LDAPReplicationService.sys.mjs" */,
 { 0x2370 } /* "resource:///modules/LDAPService.sys.mjs" */,
 { 0x2398 } /* "resource:///modules/LDAPSyncQuery.sys.mjs" */,
 { 0x23c2 } /* "resource:///modules/LDAPURLParser.sys.mjs" */,
 { 0x23ec } /* "resource:///modules/MDNService.sys.mjs" */,
 { 0x2413 } /* "resource:///modules/MailGlue.sys.mjs" */,
 { 0x2438 } /* "resource:///modules/MailtoProtocolHandler.sys.mjs" */,
 { 0x246a } /* "resource:///modules/MessageSend.sys.mjs" */,
 { 0x2492 } /* "resource:///modules/MessengerContentHandler.sys.mjs" */,
 { 0x24c6 } /* "resource:///modules/MimeJSComponents.sys.mjs" */,
 { 0x24f3 } /* "resource:///modules/MimeMessageEmitter.sys.mjs" */,
 { 0x2522 } /* "resource:///modules/MsgAsyncPrompter.sys.mjs" */,
 { 0x254f } /* "resource:///modules/MsgTraitService.sys.mjs" */,
 { 0x257b } /* "resource:///modules/NewsAutoCompleteSearch.sys.mjs" */,
 { 0x25ae } /* "resource:///modules/NewsBlog.sys.mjs" */,
 { 0x25d3 } /* "resource:///modules/NntpIncomingServer.sys.mjs" */,
 { 0x2602 } /* "resource:///modules/NntpMessageService.sys.mjs" */,
 { 0x2631 } /* "resource:///modules/NntpProtocolHandler.sys.mjs" */,
 { 0x2661 } /* "resource:///modules/NntpProtocolInfo.sys.mjs" */,
 { 0x268e } /* "resource:///modules/NntpService.sys.mjs" */,
 { 0x26b6 } /* "resource:///modules/OAuth2Module.sys.mjs" */,
 { 0x26df } /* "resource:///modules/OfflineStartup.sys.mjs" */,
 { 0x270a } /* "resource:///modules/OutgoingServerService.sys.mjs" */,
 { 0x273c } /* "resource:///modules/PgpMimeHandler.sys.mjs" */,
 { 0x2767 } /* "resource:///modules/Pop3IncomingServer.sys.mjs" */,
 { 0x2796 } /* "resource:///modules/Pop3ProtocolHandler.sys.mjs" */,
 { 0x27c6 } /* "resource:///modules/Pop3ProtocolInfo.sys.mjs" */,
 { 0x27f3 } /* "resource:///modules/Pop3Service.sys.mjs" */,
 { 0x281b } /* "resource:///modules/PromptCollection.sys.mjs" */,
 { 0x2848 } /* "resource:///modules/SMTPProtocolHandler.sys.mjs" */,
 { 0x2878 } /* "resource:///modules/SQLiteDirectory.sys.mjs" */,
 { 0x28a4 } /* "resource:///modules/SmtpServer.sys.mjs" */,
 { 0x28cb } /* "resource:///modules/VCardUtils.sys.mjs" */,
 { 0x28f2 } /* "resource:///modules/VirtualFolderWrapper.sys.mjs" */,
 { 0x2923 } /* "resource:///modules/facebook.sys.mjs" */,
 { 0x2948 } /* "resource:///modules/gtalk.sys.mjs" */,
 { 0x296a } /* "resource:///modules/irc.sys.mjs" */,
 { 0x298a } /* "resource:///modules/jsaccount/TestJaMsgProtocolInfoComponent.sys.mjs" */,
 { 0x29cf } /* "resource:///modules/matrix.sys.mjs" */,
 { 0x29f2 } /* "resource:///modules/odnoklassniki.sys.mjs" */,
 { 0x2a1c } /* "resource:///modules/twitter.sys.mjs" */,
 { 0x2a40 } /* "resource:///modules/xmpp.sys.mjs" */,
 { 0x2a61 } /* "resource:///modules/yahoo.sys.mjs" */,
 { 0x2a83 } /* "resource://devtools/client/jsonview/Converter.sys.mjs" */,
 { 0x2ab9 } /* "resource://devtools/client/jsonview/Sniffer.sys.mjs" */,
 { 0x2aed } /* "resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs" */,
 { 0x2b25 } /* "resource://gre/modules/BTPRemoteExceptionList.sys.mjs" */,
 { 0x2b5b } /* "resource://gre/modules/BackgroundTasksManager.sys.mjs" */,
 { 0x2b91 } /* "resource://gre/modules/CaptiveDetect.sys.mjs" */,
 { 0x2bbe } /* "resource://gre/modules/ClearBySiteEntry.sys.mjs" */,
 { 0x2bee } /* "resource://gre/modules/ClearDataService.sys.mjs" */,
 { 0x2c1e } /* "resource://gre/modules/ConsoleAPIStorage.sys.mjs" */,
 { 0x2c4f } /* "resource://gre/modules/ContentAreaDropListener.sys.mjs" */,
 { 0x2c86 } /* "resource://gre/modules/ContentDispatchChooser.sys.mjs" */,
 { 0x2cbc } /* "resource://gre/modules/ContentPrefService2.sys.mjs" */,
 { 0x2cef } /* "resource://gre/modules/CookieBannerListService.sys.mjs" */,
 { 0x2d26 } /* "resource://gre/modules/CredentialChooserService.sys.mjs" */,
 { 0x2d5e } /* "resource://gre/modules/DefaultCLH.sys.mjs" */,
 { 0x2d88 } /* "resource://gre/modules/DownloadLegacy.sys.mjs" */,
 { 0x2db6 } /* "resource://gre/modules/EnterprisePolicies.sys.mjs" */,
 { 0x2de8 } /* "resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs" */,
 { 0x2e26 } /* "resource://gre/modules/ExtHandlerService.sys.mjs" */,
 { 0x2e57 } /* "resource://gre/modules/FingerprintingWebCompatService.sys.mjs" */,
 { 0x2e95 } /* "resource://gre/modules/FormHistoryAutoComplete.sys.mjs" */,
 { 0x2ecc } /* "resource://gre/modules/FormHistoryStartup.sys.mjs" */,
 { 0x2efe } /* "resource://gre/modules/FxAccountsPush.sys.mjs" */,
 { 0x2f2c } /* "resource://gre/modules/HelperAppDlg.sys.mjs" */,
 { 0x2f58 } /* "resource://gre/modules/IdentityCredentialPromptService.sys.mjs" */,
 { 0x2f97 } /* "resource://gre/modules/LoginAutoComplete.sys.mjs" */,
 { 0x2fc8 } /* "resource://gre/modules/LoginInfo.sys.mjs" */,
 { 0x2ff1 } /* "resource://gre/modules/LoginManager.sys.mjs" */,
 { 0x301d } /* "resource://gre/modules/LoginManagerAuthPrompter.sys.mjs" */,
 { 0x3055 } /* "resource://gre/modules/LoginManagerPrompter.sys.mjs" */,
 { 0x3089 } /* "resource://gre/modules/MainProcessSingleton.sys.mjs" */,
 { 0x30bd } /* "resource://gre/modules/MozProtocolHandler.sys.mjs" */,
 { 0x30ef } /* "resource://gre/modules/NetworkErrorLogging.sys.mjs" */,
 { 0x3122 } /* "resource://gre/modules/NetworkGeolocationProvider.sys.mjs" */,
 { 0x315c } /* "resource://gre/modules/PageThumbsStorageService.sys.mjs" */,
 { 0x3194 } /* "resource://gre/modules/PartitioningExceptionListService.sys.mjs" */,
 { 0x31d4 } /* "resource://gre/modules/PlacesDBUtils.sys.mjs" */,
 { 0x3201 } /* "resource://gre/modules/PlacesExpiration.sys.mjs" */,
 { 0x3231 } /* "resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs" */,
 { 0x326b } /* "resource://gre/modules/PlacesPreviews.sys.mjs" */,
 { 0x3299 } /* "resource://gre/modules/PrivateAttributionService.sys.mjs" */,
 { 0x32d2 } /* "resource://gre/modules/ProcessSelector.sys.mjs" */,
 { 0x3301 } /* "resource://gre/modules/Prompter.sys.mjs" */,
 { 0x3329 } /* "resource://gre/modules/PurgeTrackerService.sys.mjs" */,
 { 0x335c } /* "resource://gre/modules/Push.sys.mjs" */,
 { 0x3380 } /* "resource://gre/modules/PushComponents.sys.mjs" */,
 { 0x33ae } /* "resource://gre/modules/QuotaUtilsService.sys.mjs" */,
 { 0x33df } /* "resource://gre/modules/RemotePermissionService.sys.mjs" */,
 { 0x3416 } /* "resource://gre/modules/SearchService.sys.mjs" */,
 { 0x3443 } /* "resource://gre/modules/SearchSuggestions.sys.mjs" */,
 { 0x3474 } /* "resource://gre/modules/SimpleServices.sys.mjs" */,
 { 0x34a2 } /* "resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs" */,
 { 0x34e7 } /* "resource://gre/modules/SlowScriptDebug.sys.mjs" */,
 { 0x3516 } /* "resource://gre/modules/TaggingService.sys.mjs" */,
 { 0x3544 } /* "resource://gre/modules/TelemetryControllerContent.sys.mjs" */,
 { 0x357e } /* "resource://gre/modules/TelemetryStartup.sys.mjs" */,
 { 0x35ae } /* "resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs" */,
 { 0x35fa } /* "resource://gre/modules/TooltipTextProvider.sys.mjs" */,
 { 0x362d } /* "resource://gre/modules/TrackingDBService.sys.mjs" */,
 { 0x365e } /* "resource://gre/modules/URIFixup.sys.mjs" */,
 { 0x3686 } /* "resource://gre/modules/URLDecorationAnnotationsService.sys.mjs" */,
 { 0x36c5 } /* "resource://gre/modules/URLFormatter.sys.mjs" */,
 { 0x36f1 } /* "resource://gre/modules/URLQueryStrippingListService.sys.mjs" */,
 { 0x372d } /* "resource://gre/modules/UpdateTimerManager.sys.mjs" */,
 { 0x375f } /* "resource://gre/modules/UrlClassifierExceptionListService.sys.mjs" */,
 { 0x37a0 } /* "resource://gre/modules/UrlClassifierHashCompleter.sys.mjs" */,
 { 0x37da } /* "resource://gre/modules/UrlClassifierLib.sys.mjs" */,
 { 0x380a } /* "resource://gre/modules/UrlClassifierListManager.sys.mjs" */,
 { 0x3842 } /* "resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs" */,
 { 0x3884 } /* "resource://gre/modules/UserCharacteristicsPageService.sys.mjs" */,
 { 0x38c2 } /* "resource://gre/modules/WebHandlerApp.sys.mjs" */,
 { 0x38ef } /* "resource://gre/modules/WebVTTParserWrapper.sys.mjs" */,
 { 0x3922 } /* "resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs" */,
 { 0x395d } /* "resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs" */,
 { 0x39a8 } /* "resource://gre/modules/XULStore.sys.mjs" */,
 { 0x39d0 } /* "resource://gre/modules/amContentHandler.sys.mjs" */,
 { 0x3a00 } /* "resource://gre/modules/amManager.sys.mjs" */,
 { 0x3a29 } /* "resource://gre/modules/amWebAPI.sys.mjs" */,
 { 0x3a51 } /* "resource://gre/modules/crypto-SDR.sys.mjs" */,
 { 0x3a7b } /* "resource://gre/modules/media/PeerConnection.sys.mjs" */,
 { 0x3aaf } /* "resource://gre/modules/mozIntl.sys.mjs" */,
 { 0x3ad6 } /* "resource://gre/modules/nsAsyncShutdown.sys.mjs" */,
 { 0x3b05 } /* "resource://gre/modules/nsCrashMonitor.sys.mjs" */,
 { 0x3b33 } /* "resource://gre/modules/pdfjs.sys.mjs" */,
 { 0x3b58 } /* "resource://gre/modules/psm/ClientAuthDialogService.sys.mjs" */,
 { 0x3b93 } /* "resource://services-settings/RemoteSettingsComponents.sys.mjs" */,
 { 0x3bd1 } /* "resource://testing-common/TestProtocol.sys.mjs" */,
};

/**
 * Returns a nsCString corresponding to the given entry in the `gStrings` string
 * table. The resulting nsCString points directly to static storage, and does
 * not incur any memory allocation overhead.
 */
static inline nsCString GetString(const StringOffset& aOffset) {
  const char* str = &gStrings[aOffset.mOffset];
  nsCString result;
  result.AssignLiteral(str, strlen(str));
  return result;
}

nsCString ContractEntry::ContractID() const {
  return GetString(mContractID);
}

bool ContractEntry::Matches(const nsACString& aContractID) const {
  return aContractID == ContractID() && Module().Active();
}

static nsresult ConstructESModuleComponent(const nsACString& aURI,
                                      const char* aConstructor,
                                      nsISupports** aResult) {
  if (!nsComponentManagerImpl::JSLoaderReady()) {
    return NS_ERROR_NOT_AVAILABLE;
  }

  AutoJSAPI jsapi;
  MOZ_ALWAYS_TRUE(jsapi.Init(xpc::PrivilegedJunkScope()));
  JSContext* cx = jsapi.cx();

  JS::Rooted<JSObject*> exports(cx);
  MOZ_TRY(mozJSModuleLoader::Get()->ImportESModule(cx, aURI, &exports));

  JS::Rooted<JS::Value> ctor(cx);
  if (!JS_GetProperty(cx, exports, aConstructor, &ctor) ||
      !ctor.isObject()) {
    return NS_ERROR_XPC_JSOBJECT_HAS_NO_FUNCTION_NAMED;
  }

  JS::Rooted<JSObject*> inst(cx);
  if (!JS::Construct(cx, ctor, JS::HandleValueArray::empty(), &inst)) {
    return NS_ERROR_FAILURE;
  }

  return nsContentUtils::XPConnect()->WrapJS(cx, inst, NS_GET_IID(nsISupports),
                                             (void**)aResult);
}

const StaticModule gStaticModules[] = {
  
          /* Anonymous042 */ {
            /* {38a224c1-6748-49a9-8ab2-efc362b1000d} */
            { 0x38a224c1, 0x6748, 0x49a9, { 0x8a, 0xb2, 0xef, 0xc3, 0x62, 0xb1, 0x00, 0x0d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous054 */ {
            /* {8cc51368-6aa0-43e8-b762-bde9b9fd828c} */
            { 0x8cc51368, 0x6aa0, 0x43e8, { 0xb7, 0x62, 0xbd, 0xe9, 0xb9, 0xfd, 0x82, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Console */ {
            /* {7e3ff85c-1dd2-11b2-8d4b-eb452cb0ff40} */
            { 0x7e3ff85c, 0x1dd2, 0x11b2, { 0x8d, 0x4b, 0xeb, 0x45, 0x2c, 0xb0, 0xff, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous199 */ {
            /* {eed38573-d01b-4c13-9f9d-f69963095a4d} */
            { 0xeed38573, 0xd01b, 0x4c13, { 0x9f, 0x9d, 0xf6, 0x99, 0x63, 0x09, 0x5a, 0x4d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous509 */ {
            /* {d38926e0-29c1-11eb-8588-0800200c9a66} */
            { 0xd38926e0, 0x29c1, 0x11eb, { 0x85, 0x88, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous409 */ {
            /* {1ee0cc18-c968-4105-a895-bdea08e187eb} */
            { 0x1ee0cc18, 0xc968, 0x4105, { 0xa8, 0x95, 0xbd, 0xea, 0x08, 0xe1, 0x87, 0xeb } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous171 */ {
            /* {a0134d58-018f-4d40-a099-fa079e5024a6} */
            { 0xa0134d58, 0x18f, 0x4d40, { 0xa0, 0x99, 0xfa, 0x07, 0x9e, 0x50, 0x24, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous034 */ {
            /* {6e957006-b4ce-11d9-b053-001124736b74} */
            { 0x6e957006, 0xb4ce, 0x11d9, { 0xb0, 0x53, 0x00, 0x11, 0x24, 0x73, 0x6b, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous339 */ {
            /* {6eae857e-4ba9-11e3-9b39-b4036188709b} */
            { 0x6eae857e, 0x4ba9, 0x11e3, { 0x9b, 0x39, 0xb4, 0x03, 0x61, 0x88, 0x70, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous478 */ {
            /* {0c797702-1c60-4051-9dd7-4d7405605642} */
            { 0xc797702, 0x1c60, 0x4051, { 0x9d, 0xd7, 0x4d, 0x74, 0x05, 0x60, 0x56, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Predictor */ {
            /* {969adfdf-7221-4419-aecf-05f8faf00c9b} */
            { 0x969adfdf, 0x7221, 0x4419, { 0xae, 0xcf, 0x05, 0xf8, 0xfa, 0xf0, 0x0c, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous550 */ {
            /* {471f4944-1dd2-11b2-87ac-90be0a51d609} */
            { 0x471f4944, 0x1dd2, 0x11b2, { 0x87, 0xac, 0x90, 0xbe, 0x0a, 0x51, 0xd6, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous312 */ {
            /* {20557898-1dd2-11b2-8f65-9c462ee2bc95} */
            { 0x20557898, 0x1dd2, 0x11b2, { 0x8f, 0x65, 0x9c, 0x46, 0x2e, 0xe2, 0xbc, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous605 */ {
            /* {acf8dc4b-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4b, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous207 */ {
            /* {1f993eda-7dd9-11df-819a-6257dfd72085} */
            { 0x1f993eda, 0x7dd9, 0x11df, { 0x81, 0x9a, 0x62, 0x57, 0xdf, 0xd7, 0x20, 0x85 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous029 */ {
            /* {1e3e33dc-445a-49de-b2b6-15b2a050bb9d} */
            { 0x1e3e33dc, 0x445a, 0x49de, { 0xb2, 0xb6, 0x15, 0xb2, 0xa0, 0x50, 0xbb, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous282 */ {
            /* {acf6e493-0092-4b26-b172-241e375c57ab} */
            { 0xacf6e493, 0x92, 0x4b26, { 0xb1, 0x72, 0x24, 0x1e, 0x37, 0x5c, 0x57, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous237 */ {
            /* {053d0b1b-5ee9-49aa-a9ac-a4a8933fdf28} */
            { 0x53d0b1b, 0x5ee9, 0x49aa, { 0xa9, 0xac, 0xa4, 0xa8, 0x93, 0x3f, 0xdf, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous585 */ {
            /* {cb6cdb94-e417-4601-b4a5-f991bf41453d} */
            { 0xcb6cdb94, 0xe417, 0x4601, { 0xb4, 0xa5, 0xf9, 0x91, 0xbf, 0x41, 0x45, 0x3d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous213 */ {
            /* {815c4fbe-0e7c-45b6-8324-f7044c7252ac} */
            { 0x815c4fbe, 0xe7c, 0x45b6, { 0x83, 0x24, 0xf7, 0x04, 0x4c, 0x72, 0x52, 0xac } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous344 */ {
            /* {9868b4ce-da08-11d3-8cda-0060b0fc14a3} */
            { 0x9868b4ce, 0xda08, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous270 */ {
            /* {3610c242-654e-11e6-8ec0-6d1be389a607} */
            { 0x3610c242, 0x654e, 0x11e6, { 0x8e, 0xc0, 0x6d, 0x1b, 0xe3, 0x89, 0xa6, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous489 */ {
            /* {a2568d74-be41-46a5-abfc-6dbab0b80f95} */
            { 0xa2568d74, 0xbe41, 0x46a5, { 0xab, 0xfc, 0x6d, 0xba, 0xb0, 0xb8, 0x0f, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous188 */ {
            /* {3c1c0163-9bd0-11d3-9d09-0050040007b2} */
            { 0x3c1c0163, 0x9bd0, 0x11d3, { 0x9d, 0x09, 0x00, 0x50, 0x04, 0x00, 0x07, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous313 */ {
            /* {3d8fa16d-c9e1-4b50-bdef-2c7ae249967a} */
            { 0x3d8fa16d, 0xc9e1, 0x4b50, { 0xbd, 0xef, 0x2c, 0x7a, 0xe2, 0x49, 0x96, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous536 */ {
            /* {1980624c-c50b-4b46-a91c-dfaba7792706} */
            { 0x1980624c, 0xc50b, 0x4b46, { 0xa9, 0x1c, 0xdf, 0xab, 0xa7, 0x79, 0x27, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous047 */ {
            /* {dde786d1-6f59-43d0-9bc8-b505a757fb30} */
            { 0xdde786d1, 0x6f59, 0x43d0, { 0x9b, 0xc8, 0xb5, 0x05, 0xa7, 0x57, 0xfb, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous330 */ {
            /* {19d9161b-a2a9-4518-b2c9-fcb8296d6dcd} */
            { 0x19d9161b, 0xa2a9, 0x4518, { 0xb2, 0xc9, 0xfc, 0xb8, 0x29, 0x6d, 0x6d, 0xcd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Prefetch */ {
            /* {6b8bdffc-3394-417d-be83-a81b7c0f63bf} */
            { 0x6b8bdffc, 0x3394, 0x417d, { 0xbe, 0x83, 0xa8, 0x1b, 0x7c, 0x0f, 0x63, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous240 */ {
            /* {e9a7cd70-0303-11d3-a50a-0060b0fc04b7} */
            { 0xe9a7cd70, 0x303, 0x11d3, { 0xa5, 0x0a, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous661 */ {
            /* {e7c2aaf5-c11a-4954-9dbf-e28edec1fd91} */
            { 0xe7c2aaf5, 0xc11a, 0x4954, { 0x9d, 0xbf, 0xe2, 0x8e, 0xde, 0xc1, 0xfd, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous294 */ {
            /* {cccd665f-edf3-41fc-ab9b-fc55b37340aa} */
            { 0xcccd665f, 0xedf3, 0x41fc, { 0xab, 0x9b, 0xfc, 0x55, 0xb3, 0x73, 0x40, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ServiceWorkerManager */ {
            /* {c74bde32-bcc7-4840-8430-c733351b212a} */
            { 0xc74bde32, 0xbcc7, 0x4840, { 0x84, 0x30, 0xc7, 0x33, 0x35, 0x1b, 0x21, 0x2a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous028 */ {
            /* {c70acb08-464e-4e55-899d-b2c84c5409fa} */
            { 0xc70acb08, 0x464e, 0x4e55, { 0x89, 0x9d, 0xb2, 0xc8, 0x4c, 0x54, 0x09, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous594 */ {
            /* {fb97e4f5-32dd-497a-baa2-7d1e55079910} */
            { 0xfb97e4f5, 0x32dd, 0x497a, { 0xba, 0xa2, 0x7d, 0x1e, 0x55, 0x07, 0x99, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous101 */ {
            /* {4a85a5d0-cddd-11d2-b7f6-00805f05ffa5} */
            { 0x4a85a5d0, 0xcddd, 0x11d2, { 0xb7, 0xf6, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* RFPService */ {
            /* {20093b2e-d5d5-4ce0-8355-96b8d2dc7ff5} */
            { 0x20093b2e, 0xd5d5, 0x4ce0, { 0x83, 0x55, 0x96, 0xb8, 0xd2, 0xdc, 0x7f, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous150 */ {
            /* {b14c2b67-8680-4c11-8d63-9403c7d4f757} */
            { 0xb14c2b67, 0x8680, 0x4c11, { 0x8d, 0x63, 0x94, 0x03, 0xc7, 0xd4, 0xf7, 0x57 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AppStartup */ {
            /* {7dd4d320-c84b-4624-8d45-7bb9b2356977} */
            { 0x7dd4d320, 0xc84b, 0x4624, { 0x8d, 0x45, 0x7b, 0xb9, 0xb2, 0x35, 0x69, 0x77 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous170 */ {
            /* {54976882-7421-4286-8ecc-46373f15d7b5} */
            { 0x54976882, 0x7421, 0x4286, { 0x8e, 0xcc, 0x46, 0x37, 0x3f, 0x15, 0xd7, 0xb5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous480 */ {
            /* {49e8d8ef-a713-492a-a3d2-5c9dad4ce2e5} */
            { 0x49e8d8ef, 0xa713, 0x492a, { 0xa3, 0xd2, 0x5c, 0x9d, 0xad, 0x4c, 0xe2, 0xe5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous611 */ {
            /* {acf8dc48-4a25-11d3-9890-006008962422} */
            { 0xacf8dc48, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous645 */ {
            /* {ecba5203-77da-465a-865e-78b7af10d8f7} */
            { 0xecba5203, 0x77da, 0x465a, { 0x86, 0x5e, 0x78, 0xb7, 0xaf, 0x10, 0xd8, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous090 */ {
            /* {6fd8ec67-3965-11d3-a316-001083003d0c} */
            { 0x6fd8ec67, 0x3965, 0x11d3, { 0xa3, 0x16, 0x00, 0x10, 0x83, 0x00, 0x3d, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous165 */ {
            /* {e007d92e-1dd1-11b2-a61e-dc962c9b8571} */
            { 0xe007d92e, 0x1dd1, 0x11b2, { 0xa6, 0x1e, 0xdc, 0x96, 0x2c, 0x9b, 0x85, 0x71 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous406 */ {
            /* {962dbf40-2c3f-4c1f-8ae8-90e8c9d85368} */
            { 0x962dbf40, 0x2c3f, 0x4c1f, { 0x8a, 0xe8, 0x90, 0xe8, 0xc9, 0xd8, 0x53, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous022 */ {
            /* {04027036-5884-4a30-b4af-f2cad79f6edf} */
            { 0x4027036, 0x5884, 0x4a30, { 0xb4, 0xaf, 0xf2, 0xca, 0xd7, 0x9f, 0x6e, 0xdf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous387 */ {
            /* {cf0f71fd-fafd-4e2b-9fdc-134d972e16e2} */
            { 0xcf0f71fd, 0xfafd, 0x4e2b, { 0x9f, 0xdc, 0x13, 0x4d, 0x97, 0x2e, 0x16, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous506 */ {
            /* {bbc23860-2553-479d-8b78-94d9038334f7} */
            { 0xbbc23860, 0x2553, 0x479d, { 0x8b, 0x78, 0x94, 0xd9, 0x03, 0x83, 0x34, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous420 */ {
            /* {807535bf-018e-4300-b8d3-4a6405fb9f65} */
            { 0x807535bf, 0x18e, 0x4300, { 0xb8, 0xd3, 0x4a, 0x64, 0x05, 0xfb, 0x9f, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AddonContentPolicy */ {
            /* {c26a8241-ecf4-4aed-9f3c-f1f5c713b9a5} */
            { 0xc26a8241, 0xecf4, 0x4aed, { 0x9f, 0x3c, 0xf1, 0xf5, 0xc7, 0x13, 0xb9, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous629 */ {
            /* {574ce83e-fe9f-4095-b85c-7909abbf7c37} */
            { 0x574ce83e, 0xfe9f, 0x4095, { 0xb8, 0x5c, 0x79, 0x09, 0xab, 0xbf, 0x7c, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* GfxInfo */ {
            /* {d755a760-9f27-11df-0800-200c9a664242} */
            { 0xd755a760, 0x9f27, 0x11df, { 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66, 0x42, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_PROCESS,
          },
  
          /* Anonymous334 */ {
            /* {064d9cee-1dd2-11b2-83e3-d25ab0193c26} */
            { 0x64d9cee, 0x1dd2, 0x11b2, { 0x83, 0xe3, 0xd2, 0x5a, 0xb0, 0x19, 0x3c, 0x26 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous462 */ {
            /* {17a59a6b-92b8-42e5-bce0-ab434c7a7135} */
            { 0x17a59a6b, 0x92b8, 0x42e5, { 0xbc, 0xe0, 0xab, 0x43, 0x4c, 0x7a, 0x71, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous393 */ {
            /* {56388dad-287b-4240-a785-85c394012503} */
            { 0x56388dad, 0x287b, 0x4240, { 0xa7, 0x85, 0x85, 0xc3, 0x94, 0x01, 0x25, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous092 */ {
            /* {ca1944a9-527e-4c77-895d-d0466dd41cf5} */
            { 0xca1944a9, 0x527e, 0x4c77, { 0x89, 0x5d, 0xd0, 0x46, 0x6d, 0xd4, 0x1c, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous278 */ {
            /* {74b2122d-65a8-4824-aa9e-3d664cb75dc2} */
            { 0x74b2122d, 0x65a8, 0x4824, { 0xaa, 0x9e, 0x3d, 0x66, 0x4c, 0xb7, 0x5d, 0xc2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous417 */ {
            /* {7a6da992-dbce-4943-b463-5a2dd011fa1a} */
            { 0x7a6da992, 0xdbce, 0x4943, { 0xb4, 0x63, 0x5a, 0x2d, 0xd0, 0x11, 0xfa, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous122 */ {
            /* {dbfcfdf0-4489-4faa-8122-190fd1efa16c} */
            { 0xdbfcfdf0, 0x4489, 0x4faa, { 0x81, 0x22, 0x19, 0x0f, 0xd1, 0xef, 0xa1, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IDN */ {
            /* {62b778a6-bce3-456b-8c31-2865fbb68c91} */
            { 0x62b778a6, 0xbce3, 0x456b, { 0x8c, 0x31, 0x28, 0x65, 0xfb, 0xb6, 0x8c, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous127 */ {
            /* {9c8f9601-801a-11d2-98ba-00805f297d89} */
            { 0x9c8f9601, 0x801a, 0x11d2, { 0x98, 0xba, 0x00, 0x80, 0x5f, 0x29, 0x7d, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous052 */ {
            /* {8aa5972e-19cb-41cc-9696-645f8a8d1a06} */
            { 0x8aa5972e, 0x19cb, 0x41cc, { 0x96, 0x96, 0x64, 0x5f, 0x8a, 0x8d, 0x1a, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Locale */ {
            /* {92735ff4-6384-4ad6-8508-757010e149ee} */
            { 0x92735ff4, 0x6384, 0x4ad6, { 0x85, 0x08, 0x75, 0x70, 0x10, 0xe1, 0x49, 0xee } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous418 */ {
            /* {b9f4fd03-9d87-4bfd-9958-85a821750ddc} */
            { 0xb9f4fd03, 0x9d87, 0x4bfd, { 0x99, 0x58, 0x85, 0xa8, 0x21, 0x75, 0x0d, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous160 */ {
            /* {1bd976d6-df44-11d4-a5b6-0060b0fc04b7} */
            { 0x1bd976d6, 0xdf44, 0x11d4, { 0xa5, 0xb6, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous291 */ {
            /* {49a02241-7e48-477a-9345-9f246925dcb3} */
            { 0x49a02241, 0x7e48, 0x477a, { 0x93, 0x45, 0x9f, 0x24, 0x69, 0x25, 0xdc, 0xb3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous163 */ {
            /* {a67d724d-0015-4e2e-8cad-b84775330924} */
            { 0xa67d724d, 0x15, 0x4e2e, { 0x8c, 0xad, 0xb8, 0x47, 0x75, 0x33, 0x09, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StreamTransport */ {
            /* {0885d4f8-f7b8-4cda-902e-94ba38bc256e} */
            { 0x885d4f8, 0xf7b8, 0x4cda, { 0x90, 0x2e, 0x94, 0xba, 0x38, 0xbc, 0x25, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous206 */ {
            /* {36358199-a0e4-4b68-929f-77c01de34c67} */
            { 0x36358199, 0xa0e4, 0x4b68, { 0x92, 0x9f, 0x77, 0xc0, 0x1d, 0xe3, 0x4c, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous522 */ {
            /* {895db6c7-dbdf-40ea-9f64-b175033243dc} */
            { 0x895db6c7, 0xdbdf, 0x40ea, { 0x9f, 0x64, 0xb1, 0x75, 0x03, 0x32, 0x43, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous268 */ {
            /* {bdc2e533-b308-4708-ac8e-a8bfade6d851} */
            { 0xbdc2e533, 0xb308, 0x4708, { 0xac, 0x8e, 0xa8, 0xbf, 0xad, 0xe6, 0xd8, 0x51 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous500 */ {
            /* {dc185a77-ba88-4caa-8f16-465253f7599a} */
            { 0xdc185a77, 0xba88, 0x4caa, { 0x8f, 0x16, 0x46, 0x52, 0x53, 0xf7, 0x59, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous072 */ {
            /* {dafab386-bd4c-4238-bb48-228fbc98ba29} */
            { 0xdafab386, 0xbd4c, 0x4238, { 0xbb, 0x48, 0x22, 0x8f, 0xbc, 0x98, 0xba, 0x29 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous372 */ {
            /* {a181af0d-68b8-4308-94db-d4f859058215} */
            { 0xa181af0d, 0x68b8, 0x4308, { 0x94, 0xdb, 0xd4, 0xf8, 0x59, 0x05, 0x82, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous684 */ {
            /* {3b265b69-f813-48ff-880d-d88d101af404} */
            { 0x3b265b69, 0xf813, 0x48ff, { 0x88, 0x0d, 0xd8, 0x8d, 0x10, 0x1a, 0xf4, 0x04 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous323 */ {
            /* {ff8780a5-bbb1-4bc5-8ee7-057e7bc5c925} */
            { 0xff8780a5, 0xbbb1, 0x4bc5, { 0x8e, 0xe7, 0x05, 0x7e, 0x7b, 0xc5, 0xc9, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous277 */ {
            /* {d974b814-8fde-411c-8c45-b86791b81030} */
            { 0xd974b814, 0x8fde, 0x411c, { 0x8c, 0x45, 0xb8, 0x67, 0x91, 0xb8, 0x10, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous005 */ {
            /* {7a9200dd-6a64-4fff-a798-c5802186e2cc} */
            { 0x7a9200dd, 0x6a64, 0x4fff, { 0xa7, 0x98, 0xc5, 0x80, 0x21, 0x86, 0xe2, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous049 */ {
            /* {b2c036a3-f7ce-401c-95ee-9c21505167fd} */
            { 0xb2c036a3, 0xf7ce, 0x401c, { 0x95, 0xee, 0x9c, 0x21, 0x50, 0x51, 0x67, 0xfd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous128 */ {
            /* {14c13684-1dd2-11b2-9463-bb10ba742554} */
            { 0x14c13684, 0x1dd2, 0x11b2, { 0x94, 0x63, 0xbb, 0x10, 0xba, 0x74, 0x25, 0x54 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous075 */ {
            /* {8683e821-f1b0-476d-ac15-07771c79bb11} */
            { 0x8683e821, 0xf1b0, 0x476d, { 0xac, 0x15, 0x07, 0x77, 0x1c, 0x79, 0xbb, 0x11 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous413 */ {
            /* {b43b3f73-8160-4ab2-9f5d-4129a9708081} */
            { 0xb43b3f73, 0x8160, 0x4ab2, { 0x9f, 0x5d, 0x41, 0x29, 0xa9, 0x70, 0x80, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous035 */ {
            /* {47c31f2b-b4de-11d9-bfe6-001124736b74} */
            { 0x47c31f2b, 0xb4de, 0x11d9, { 0xbf, 0xe6, 0x00, 0x11, 0x24, 0x73, 0x6b, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URIFixup */ {
            /* {c6cf88b7-452e-47eb-bdc9-86e3561648ef} */
            { 0xc6cf88b7, 0x452e, 0x47eb, { 0xbd, 0xc9, 0x86, 0xe3, 0x56, 0x16, 0x48, 0xef } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous215 */ {
            /* {c560806a-425f-4f0f-bf69-397c58c599a7} */
            { 0xc560806a, 0x425f, 0x4f0f, { 0xbf, 0x69, 0x39, 0x7c, 0x58, 0xc5, 0x99, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous535 */ {
            /* {9111de73-9322-4bfc-8b65-2b727f3e6ec8} */
            { 0x9111de73, 0x9322, 0x4bfc, { 0x8b, 0x65, 0x2b, 0x72, 0x7f, 0x3e, 0x6e, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous665 */ {
            /* {daf1461b-bf29-4f88-8d0e-4bcdf332c862} */
            { 0xdaf1461b, 0xbf29, 0x4f88, { 0x8d, 0x0e, 0x4b, 0xcd, 0xf3, 0x32, 0xc8, 0x62 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous421 */ {
            /* {8f685a9d-8181-46d6-a71d-869289099c6d} */
            { 0x8f685a9d, 0x8181, 0x46d6, { 0xa7, 0x1d, 0x86, 0x92, 0x89, 0x09, 0x9c, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous517 */ {
            /* {d5cce16c-7b6b-4bae-9597-08670d1eeaaa} */
            { 0xd5cce16c, 0x7b6b, 0x4bae, { 0x95, 0x97, 0x08, 0x67, 0x0d, 0x1e, 0xea, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous086 */ {
            /* {4ed7d5e1-8800-40da-9e78-c4f509d7ac5e} */
            { 0x4ed7d5e1, 0x8800, 0x40da, { 0x9e, 0x78, 0xc4, 0xf5, 0x09, 0xd7, 0xac, 0x5e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous469 */ {
            /* {0c06583d-7dd8-4293-b1a5-912205f779aa} */
            { 0xc06583d, 0x7dd8, 0x4293, { 0xb1, 0xa5, 0x91, 0x22, 0x05, 0xf7, 0x79, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous572 */ {
            /* {1940fed5-7d02-4122-8acf-7abaac698983} */
            { 0x1940fed5, 0x7d02, 0x4122, { 0x8a, 0xcf, 0x7a, 0xba, 0xac, 0x69, 0x89, 0x83 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous261 */ {
            /* {96cf7855-dfa9-4c6d-8276-f9705b4890f2} */
            { 0x96cf7855, 0xdfa9, 0x4c6d, { 0x82, 0x76, 0xf9, 0x70, 0x5b, 0x48, 0x90, 0xf2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous004 */ {
            /* {4b7ae030-ed79-11d9-8cd6-0800200c9a66} */
            { 0x4b7ae030, 0xed79, 0x11d9, { 0x8c, 0xd6, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous608 */ {
            /* {acf8dc49-4a25-11d3-9890-006008962422} */
            { 0xacf8dc49, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous300 */ {
            /* {b6f2f870-b0bc-4a1a-9c40-02cc171adb5b} */
            { 0xb6f2f870, 0xb0bc, 0x4a1a, { 0x9c, 0x40, 0x02, 0xcc, 0x17, 0x1a, 0xdb, 0x5b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous216 */ {
            /* {403b0540-b7c3-11d2-b35e-525400e2d63a} */
            { 0x403b0540, 0xb7c3, 0x11d2, { 0xb3, 0x5e, 0x52, 0x54, 0x00, 0xe2, 0xd6, 0x3a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous316 */ {
            /* {ac2bb8fe-eeeb-4572-b40f-be03932b56e0} */
            { 0xac2bb8fe, 0xeeeb, 0x4572, { 0xb4, 0x0f, 0xbe, 0x03, 0x93, 0x2b, 0x56, 0xe0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ProtocolProxy */ {
            /* {e9b301c0-e0e4-11d3-a1a8-0050041caf44} */
            { 0xe9b301c0, 0xe0e4, 0x11d3, { 0xa1, 0xa8, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous373 */ {
            /* {d6ef593d-a429-4b14-a887-d9e2f765d9ed} */
            { 0xd6ef593d, 0xa429, 0x4b14, { 0xa8, 0x87, 0xd9, 0xe2, 0xf7, 0x65, 0xd9, 0xed } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Copy */ {
            /* {c766e666-29bd-11d3-afb3-001083002da8} */
            { 0xc766e666, 0x29bd, 0x11d3, { 0xaf, 0xb3, 0x00, 0x10, 0x83, 0x00, 0x2d, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous164 */ {
            /* {a0258267-44fd-4886-a858-8192615178ec} */
            { 0xa0258267, 0x44fd, 0x4886, { 0xa8, 0x58, 0x81, 0x92, 0x61, 0x51, 0x78, 0xec } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous001 */ {
            /* {fcbadec9-aab7-49e2-a20a-8e93f41d68d1} */
            { 0xfcbadec9, 0xaab7, 0x49e2, { 0xa2, 0x0a, 0x8e, 0x93, 0xf4, 0x1d, 0x68, 0xd1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous602 */ {
            /* {cbf86870-4ac0-11d3-baea-00805f8a5dd7} */
            { 0xcbf86870, 0x4ac0, 0x11d3, { 0xba, 0xea, 0x00, 0x80, 0x5f, 0x8a, 0x5d, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous360 */ {
            /* {7fa5237d-b0eb-438f-9e50-ca0166e63788} */
            { 0x7fa5237d, 0xb0eb, 0x438f, { 0x9e, 0x50, 0xca, 0x01, 0x66, 0xe6, 0x37, 0x88 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous027 */ {
            /* {2547331f-34c0-4a4b-b93c-b503538ba6d6} */
            { 0x2547331f, 0x34c0, 0x4a4b, { 0xb9, 0x3c, 0xb5, 0x03, 0x53, 0x8b, 0xa6, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* XULRuntime */ {
            /* {95d89e3e-a169-41a3-8e56-719978e15b12} */
            { 0x95d89e3e, 0xa169, 0x41a3, { 0x8e, 0x56, 0x71, 0x99, 0x78, 0xe1, 0x5b, 0x12 } },
            { 0x3c00 } /* "@mozilla.org/xre/app-info;1" */,
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous368 */ {
            /* {4abd60aa-6b7d-4f3b-bf52-d7ce8ae6dd36} */
            { 0x4abd60aa, 0x6b7d, 0x4f3b, { 0xbf, 0x52, 0xd7, 0xce, 0x8a, 0xe6, 0xdd, 0x36 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous220 */ {
            /* {e8892265-7653-46c5-a290-307f3404d0f3} */
            { 0xe8892265, 0x7653, 0x46c5, { 0xa2, 0x90, 0x30, 0x7f, 0x34, 0x04, 0xd0, 0xf3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous359 */ {
            /* {9158c470-86e4-11d4-9be2-00e09872a416} */
            { 0x9158c470, 0x86e4, 0x11d4, { 0x9b, 0xe2, 0x00, 0xe0, 0x98, 0x72, 0xa4, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous432 */ {
            /* {67ba681d-5485-4fff-952c-2ee337ffdcd6} */
            { 0x67ba681d, 0x5485, 0x4fff, { 0x95, 0x2c, 0x2e, 0xe3, 0x37, 0xff, 0xdc, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous331 */ {
            /* {608b7f6f-4b60-40d6-87ed-d933bf53d8c1} */
            { 0x608b7f6f, 0x4b60, 0x40d6, { 0x87, 0xed, 0xd9, 0x33, 0xbf, 0x53, 0xd8, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous676 */ {
            /* {69da374a-fda3-4a93-9fbc-d9304f66a7fe} */
            { 0x69da374a, 0xfda3, 0x4a93, { 0x9f, 0xbc, 0xd9, 0x30, 0x4f, 0x66, 0xa7, 0xfe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous308 */ {
            /* {7ef52eaf-b7e1-462b-87e2-5d1dbaca9048} */
            { 0x7ef52eaf, 0xb7e1, 0x462b, { 0x87, 0xe2, 0x5d, 0x1d, 0xba, 0xca, 0x90, 0x48 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous423 */ {
            /* {518e071f-1dd2-11b2-937e-c45f14def778} */
            { 0x518e071f, 0x1dd2, 0x11b2, { 0x93, 0x7e, 0xc4, 0x5f, 0x14, 0xde, 0xf7, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* RandomGenerator */ {
            /* {be65e2b7-fe46-4e0f-88e0-4b385db4d68a} */
            { 0xbe65e2b7, 0xfe46, 0x4e0f, { 0x88, 0xe0, 0x4b, 0x38, 0x5d, 0xb4, 0xd6, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous100 */ {
            /* {37246055-3596-4bfa-911f-3d2977e8d284} */
            { 0x37246055, 0x3596, 0x4bfa, { 0x91, 0x1f, 0x3d, 0x29, 0x77, 0xe8, 0xd2, 0x84 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous415 */ {
            /* {b1f08d56-fca6-4290-9500-d5168dc9d8c3} */
            { 0xb1f08d56, 0xfca6, 0x4290, { 0x95, 0x00, 0xd5, 0x16, 0x8d, 0xc9, 0xd8, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous063 */ {
            /* {7913837c-9623-11ea-bb37-0242ac130002} */
            { 0x7913837c, 0x9623, 0x11ea, { 0xbb, 0x37, 0x02, 0x42, 0xac, 0x13, 0x00, 0x02 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous023 */ {
            /* {df19281a-5389-4146-b941-798cb93a7f0d} */
            { 0xdf19281a, 0x5389, 0x4146, { 0xb9, 0x41, 0x79, 0x8c, 0xb9, 0x3a, 0x7f, 0x0d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous525 */ {
            /* {7319788a-fe93-4db3-9f39-818cf08f4256} */
            { 0x7319788a, 0xfe93, 0x4db3, { 0x9f, 0x39, 0x81, 0x8c, 0xf0, 0x8f, 0x42, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous527 */ {
            /* {117b219f-92fe-4bd2-a21b-95a342a9d474} */
            { 0x117b219f, 0x92fe, 0x4bd2, { 0xa2, 0x1b, 0x95, 0xa3, 0x42, 0xa9, 0xd4, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous530 */ {
            /* {58a4c579-d2dd-46b7-9c3b-6881a1c36c6a} */
            { 0x58a4c579, 0xd2dd, 0x46b7, { 0x9c, 0x3b, 0x68, 0x81, 0xa1, 0xc3, 0x6c, 0x6a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous107 */ {
            /* {bcdca970-3b22-11d3-8d76-0080f58a6617} */
            { 0xbcdca970, 0x3b22, 0x11d3, { 0x8d, 0x76, 0x00, 0x80, 0xf5, 0x8a, 0x66, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous293 */ {
            /* {62c01e69-9ca4-4060-99e4-b95f628c8e6d} */
            { 0x62c01e69, 0x9ca4, 0x4060, { 0x99, 0xe4, 0xb9, 0x5f, 0x62, 0x8c, 0x8e, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous419 */ {
            /* {8753a413-3ed6-4a61-a1dc-b31a7e69b796} */
            { 0x8753a413, 0x3ed6, 0x4a61, { 0xa1, 0xdc, 0xb3, 0x1a, 0x7e, 0x69, 0xb7, 0x96 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous484 */ {
            /* {98d0e975-9cad-4ce3-ae2f-f878b8be6307} */
            { 0x98d0e975, 0x9cad, 0x4ce3, { 0xae, 0x2f, 0xf8, 0x78, 0xb8, 0xbe, 0x63, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous450 */ {
            /* {3c9c43b6-09eb-4ed2-9b87-e29f4221eef0} */
            { 0x3c9c43b6, 0x9eb, 0x4ed2, { 0x9b, 0x87, 0xe2, 0x9f, 0x42, 0x21, 0xee, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous512 */ {
            /* {1141fd31-4c1a-48eb-8f1a-2f05fad94085} */
            { 0x1141fd31, 0x4c1a, 0x48eb, { 0x8f, 0x1a, 0x2f, 0x05, 0xfa, 0xd9, 0x40, 0x85 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AuthPromptAdapter */ {
            /* {6e134924-6c3a-4d86-81ac-69432dd971dc} */
            { 0x6e134924, 0x6c3a, 0x4d86, { 0x81, 0xac, 0x69, 0x43, 0x2d, 0xd9, 0x71, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous381 */ {
            /* {4c39159c-cd90-4dd3-97a7-06af5e6d84c4} */
            { 0x4c39159c, 0xcd90, 0x4dd3, { 0x97, 0xa7, 0x06, 0xaf, 0x5e, 0x6d, 0x84, 0xc4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous448 */ {
            /* {3b667ee0-d2da-4ccc-9c3d-95f2ca6a8b4c} */
            { 0x3b667ee0, 0xd2da, 0x4ccc, { 0x9c, 0x3d, 0x95, 0xf2, 0xca, 0x6a, 0x8b, 0x4c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CredentialChooserService */ {
            /* {673ddc19-03e2-4b30-a868-06297e8fed89} */
            { 0x673ddc19, 0x3e2, 0x4b30, { 0xa8, 0x68, 0x06, 0x29, 0x7e, 0x8f, 0xed, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous520 */ {
            /* {ce3e9659-e311-49fb-b18b-7f27c6659b23} */
            { 0xce3e9659, 0xe311, 0x49fb, { 0xb1, 0x8b, 0x7f, 0x27, 0xc6, 0x65, 0x9b, 0x23 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous601 */ {
            /* {cbf86871-4ac0-11d3-baea-00805f8a5dd7} */
            { 0xcbf86871, 0x4ac0, 0x11d3, { 0xba, 0xea, 0x00, 0x80, 0x5f, 0x8a, 0x5d, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous634 */ {
            /* {f5475c51-59a7-4757-b3d9-e211a9410872} */
            { 0xf5475c51, 0x59a7, 0x4757, { 0xb3, 0xd9, 0xe2, 0x11, 0xa9, 0x41, 0x08, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous132 */ {
            /* {0b63fb80-bbba-11d4-9daa-91b657eb313c} */
            { 0xb63fb80, 0xbbba, 0x11d4, { 0x9d, 0xaa, 0x91, 0xb6, 0x57, 0xeb, 0x31, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous178 */ {
            /* {732494e4-ac6b-4bab-8c61-88af4a9b8215} */
            { 0x732494e4, 0xac6b, 0x4bab, { 0x8c, 0x61, 0x88, 0xaf, 0x4a, 0x9b, 0x82, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierStreamUpdater */ {
            /* {e1797597-f4d6-4dd3-a1e1-745ad352cd80} */
            { 0xe1797597, 0xf4d6, 0x4dd3, { 0xa1, 0xe1, 0x74, 0x5a, 0xd3, 0x52, 0xcd, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous342 */ {
            /* {a2027ec6-ba0d-4c72-805d-148233f5f33c} */
            { 0xa2027ec6, 0xba0d, 0x4c72, { 0x80, 0x5d, 0x14, 0x82, 0x33, 0xf5, 0xf3, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous328 */ {
            /* {c7e410d4-85f2-11d3-9f63-006008a6efe9} */
            { 0xc7e410d4, 0x85f2, 0x11d3, { 0x9f, 0x63, 0x00, 0x60, 0x08, 0xa6, 0xef, 0xe9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous498 */ {
            /* {dc6c2976-0f73-4f1f-b9ff-3d72b4e28309} */
            { 0xdc6c2976, 0xf73, 0x4f1f, { 0xb9, 0xff, 0x3d, 0x72, 0xb4, 0xe2, 0x83, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous014 */ {
            /* {6fe88047-75b6-4874-80e8-5f5800f14984} */
            { 0x6fe88047, 0x75b6, 0x4874, { 0x80, 0xe8, 0x5f, 0x58, 0x00, 0xf1, 0x49, 0x84 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous071 */ {
            /* {e9fb36ec-c980-4a77-9f68-0eb10491eda8} */
            { 0xe9fb36ec, 0xc980, 0x4a77, { 0x9f, 0x68, 0x0e, 0xb1, 0x04, 0x91, 0xed, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous453 */ {
            /* {ab94809d-33f0-4f28-af38-01efbd3baf22} */
            { 0xab94809d, 0x33f0, 0x4f28, { 0xaf, 0x38, 0x01, 0xef, 0xbd, 0x3b, 0xaf, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous551 */ {
            /* {7e677795-c582-4cd1-9e8d-8271b3474d2a} */
            { 0x7e677795, 0xc582, 0x4cd1, { 0x9e, 0x8d, 0x82, 0x71, 0xb3, 0x47, 0x4d, 0x2a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous606 */ {
            /* {acf8dc4c-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4c, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous076 */ {
            /* {5ad5d311-1a50-43db-a03c-63d45f443903} */
            { 0x5ad5d311, 0x1a50, 0x43db, { 0xa0, 0x3c, 0x63, 0xd4, 0x5f, 0x44, 0x39, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous581 */ {
            /* {d3f69889-e13a-4321-980c-a39332e21f34} */
            { 0xd3f69889, 0xe13a, 0x4321, { 0x98, 0x0c, 0xa3, 0x93, 0x32, 0xe2, 0x1f, 0x34 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous157 */ {
            /* {a86c86ae-e97f-11d2-a506-0060b0fc04b7} */
            { 0xa86c86ae, 0xe97f, 0x11d2, { 0xa5, 0x06, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous655 */ {
            /* {7b121f7e-ebe4-43ab-9410-dc9087a1dba6} */
            { 0x7b121f7e, 0xebe4, 0x43ab, { 0x94, 0x10, 0xdc, 0x90, 0x87, 0xa1, 0xdb, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous241 */ {
            /* {e1da397d-fdc5-4b23-a6fe-d46a034d80b3} */
            { 0xe1da397d, 0xfdc5, 0x4b23, { 0xa6, 0xfe, 0xd4, 0x6a, 0x03, 0x4d, 0x80, 0xb3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous324 */ {
            /* {0a698c44-3bff-11d4-9649-00c0ca135b4e} */
            { 0xa698c44, 0x3bff, 0x11d4, { 0x96, 0x49, 0x00, 0xc0, 0xca, 0x13, 0x5b, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous562 */ {
            /* {8b5314bb-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314bb, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous374 */ {
            /* {2ec62893-3b35-48fa-ab1d-5e68a9f45f08} */
            { 0x2ec62893, 0x3b35, 0x48fa, { 0xab, 0x1d, 0x5e, 0x68, 0xa9, 0xf4, 0x5f, 0x08 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous232 */ {
            /* {6eaa0a24-78f6-4ad7-a28a-077d24022cd2} */
            { 0x6eaa0a24, 0x78f6, 0x4ad7, { 0xa2, 0x8a, 0x07, 0x7d, 0x24, 0x02, 0x2c, 0xd2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous320 */ {
            /* {1460df3b-774c-4205-8349-838e507c3ef9} */
            { 0x1460df3b, 0x774c, 0x4205, { 0x83, 0x49, 0x83, 0x8e, 0x50, 0x7c, 0x3e, 0xf9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DBusHandlerApp */ {
            /* {6c3c274b-4cbf-4bb5-a635-05ad2cbb6535} */
            { 0x6c3c274b, 0x4cbf, 0x4bb5, { 0xa6, 0x35, 0x05, 0xad, 0x2c, 0xbb, 0x65, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous424 */ {
            /* {23ad3531-11d2-4e8e-805a-6a752e91681a} */
            { 0x23ad3531, 0x11d2, 0x4e8e, { 0x80, 0x5a, 0x6a, 0x75, 0x2e, 0x91, 0x68, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous590 */ {
            /* {678c50b8-6bcb-4ad0-b9b8-c81175955199} */
            { 0x678c50b8, 0x6bcb, 0x4ad0, { 0xb9, 0xb8, 0xc8, 0x11, 0x75, 0x95, 0x51, 0x99 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous396 */ {
            /* {b3cfeb91-332a-46c9-ad97-93ff39841494} */
            { 0xb3cfeb91, 0x332a, 0x46c9, { 0xad, 0x97, 0x93, 0xff, 0x39, 0x84, 0x14, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous367 */ {
            /* {e64f152a-9f07-11d3-8cda-0060b0fc14a3} */
            { 0xe64f152a, 0x9f07, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous592 */ {
            /* {2e23e220-60be-11d3-8c4a-000064657374} */
            { 0x2e23e220, 0x60be, 0x11d3, { 0x8c, 0x4a, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Directory */ {
            /* {f00152d0-b40b-11d3-8c9c-000064657374} */
            { 0xf00152d0, 0xb40b, 0x11d3, { 0x8c, 0x9c, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous589 */ {
            /* {61ba33c0-3031-11d3-8cd0-0060b0fc14a3} */
            { 0x61ba33c0, 0x3031, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CaptivePortal */ {
            /* {bdbe0555-fc3d-4f7b-9205-c309ceb2d641} */
            { 0xbdbe0555, 0xfc3d, 0x4f7b, { 0x92, 0x05, 0xc3, 0x09, 0xce, 0xb2, 0xd6, 0x41 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PlacesPreviewsHelper */ {
            /* {bd0a4d3b-ff26-4d4d-9a62-a513e1c1bf92} */
            { 0xbd0a4d3b, 0xff26, 0x4d4d, { 0x9a, 0x62, 0xa5, 0x13, 0xe1, 0xc1, 0xbf, 0x92 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous582 */ {
            /* {06beec76-a183-4d9f-85dd-085f26da565a} */
            { 0x6beec76, 0xa183, 0x4d9f, { 0x85, 0xdd, 0x08, 0x5f, 0x26, 0xda, 0x56, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous375 */ {
            /* {fb8cbf4e-4701-4ba1-b1d6-5388e041fb67} */
            { 0xfb8cbf4e, 0x4701, 0x4ba1, { 0xb1, 0xd6, 0x53, 0x88, 0xe0, 0x41, 0xfb, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous538 */ {
            /* {ded150e3-c92e-4077-a396-0dba9953e39f} */
            { 0xded150e3, 0xc92e, 0x4077, { 0xa3, 0x96, 0x0d, 0xba, 0x99, 0x53, 0xe3, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous285 */ {
            /* {c1faff54-7ca2-424e-b36f-3c6020b578e7} */
            { 0xc1faff54, 0x7ca2, 0x424e, { 0xb3, 0x6f, 0x3c, 0x60, 0x20, 0xb5, 0x78, 0xe7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous321 */ {
            /* {65944815-e9ae-48bd-a2bf-f1108720950c} */
            { 0x65944815, 0xe9ae, 0x48bd, { 0xa2, 0xbf, 0xf1, 0x10, 0x87, 0x20, 0x95, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous348 */ {
            /* {c272fee0-c7e9-11d3-8cda-0060b0fc14a3} */
            { 0xc272fee0, 0xc7e9, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous286 */ {
            /* {5296f79e-15ea-40c3-8196-19cfa64d328c} */
            { 0x5296f79e, 0x15ea, 0x40c3, { 0x81, 0x96, 0x19, 0xcf, 0xa6, 0x4d, 0x32, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous087 */ {
            /* {227e6482-fe9f-441f-9b7d-7b60375e7449} */
            { 0x227e6482, 0xfe9f, 0x441f, { 0x9b, 0x7d, 0x7b, 0x60, 0x37, 0x5e, 0x74, 0x49 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous146 */ {
            /* {ceb0dca2-5e7d-4204-94d4-2ab925921fae} */
            { 0xceb0dca2, 0x5e7d, 0x4204, { 0x94, 0xd4, 0x2a, 0xb9, 0x25, 0x92, 0x1f, 0xae } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous404 */ {
            /* {86606ba1-de17-4df4-9013-e571ab94fd94} */
            { 0x86606ba1, 0xde17, 0x4df4, { 0x90, 0x13, 0xe5, 0x71, 0xab, 0x94, 0xfd, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous394 */ {
            /* {9c4e9d49-ce64-4ca3-acef-3075c5e5aba7} */
            { 0x9c4e9d49, 0xce64, 0x4ca3, { 0xac, 0xef, 0x30, 0x75, 0xc5, 0xe5, 0xab, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous068 */ {
            /* {1143991d-31cd-4ea6-9c97-c587d990d724} */
            { 0x1143991d, 0x31cd, 0x4ea6, { 0x9c, 0x97, 0xc5, 0x87, 0xd9, 0x90, 0xd7, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous302 */ {
            /* {77da64d3-7458-4920-9491-86cc9914f904} */
            { 0x77da64d3, 0x7458, 0x4920, { 0x94, 0x91, 0x86, 0xcc, 0x99, 0x14, 0xf9, 0x04 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous481 */ {
            /* {db82286d-d649-47fb-8599-ba31673a58c5} */
            { 0xdb82286d, 0xd649, 0x47fb, { 0x85, 0x99, 0xba, 0x31, 0x67, 0x3a, 0x58, 0xc5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous672 */ {
            /* {653e0e4d-3ee4-45fa-b272-97c20bc01eb8} */
            { 0x653e0e4d, 0x3ee4, 0x45fa, { 0xb2, 0x72, 0x97, 0xc2, 0x0b, 0xc0, 0x1e, 0xb8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous549 */ {
            /* {0fa3158c-d5a7-43de-9181-a285e74cf1d4} */
            { 0xfa3158c, 0xd5a7, 0x43de, { 0x91, 0x81, 0xa2, 0x85, 0xe7, 0x4c, 0xf1, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ScriptSecurityManager */ {
            /* {7ee2a4c0-4b93-17d3-ba18-0060b0f199a2} */
            { 0x7ee2a4c0, 0x4b93, 0x17d3, { 0xba, 0x18, 0x00, 0x60, 0xb0, 0xf1, 0x99, 0xa2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Import */ {
            /* {5df96d60-1726-11d3-a206-00a0cc26da63} */
            { 0x5df96d60, 0x1726, 0x11d3, { 0xa2, 0x06, 0x00, 0xa0, 0xcc, 0x26, 0xda, 0x63 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous226 */ {
            /* {9cefbe67-5966-4f8a-b7b0-cedd60a02c8e} */
            { 0x9cefbe67, 0x5966, 0x4f8a, { 0xb7, 0xb0, 0xce, 0xdd, 0x60, 0xa0, 0x2c, 0x8e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous515 */ {
            /* {1c978d25-b37f-43a8-a2d6-0c7a239ead87} */
            { 0x1c978d25, 0xb37f, 0x43a8, { 0xa2, 0xd6, 0x0c, 0x7a, 0x23, 0x9e, 0xad, 0x87 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous265 */ {
            /* {b93af7a1-3411-44a8-bd0a-8af3dde4d8d8} */
            { 0xb93af7a1, 0x3411, 0x44a8, { 0xbd, 0x0a, 0x8a, 0xf3, 0xdd, 0xe4, 0xd8, 0xd8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PermissionManager */ {
            /* {4f6b5e00-0c36-11d5-a535-0010a401eb10} */
            { 0x4f6b5e00, 0xc36, 0x11d5, { 0xa5, 0x35, 0x00, 0x10, 0xa4, 0x01, 0xeb, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous167 */ {
            /* {5c124537-adca-4456-b2b5-641ab687d1f6} */
            { 0x5c124537, 0xadca, 0x4456, { 0xb2, 0xb5, 0x64, 0x1a, 0xb6, 0x87, 0xd1, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous304 */ {
            /* {07611dc6-bf4d-4d8a-a64b-f3a5904dddc7} */
            { 0x7611dc6, 0xbf4d, 0x4d8a, { 0xa6, 0x4b, 0xf3, 0xa5, 0x90, 0x4d, 0xdd, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous357 */ {
            /* {2693457e-3ba5-4455-991f-5350946adb12} */
            { 0x2693457e, 0x3ba5, 0x4455, { 0x99, 0x1f, 0x53, 0x50, 0x94, 0x6a, 0xdb, 0x12 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous229 */ {
            /* {1895016d-5302-46a9-b3f5-9c47694d9eca} */
            { 0x1895016d, 0x5302, 0x46a9, { 0xb3, 0xf5, 0x9c, 0x47, 0x69, 0x4d, 0x9e, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous380 */ {
            /* {9879908a-2972-40c0-890b-a91dd7dfb954} */
            { 0x9879908a, 0x2972, 0x40c0, { 0x89, 0x0b, 0xa9, 0x1d, 0xd7, 0xdf, 0xb9, 0x54 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous084 */ {
            /* {2f946df9-114c-41fe-8899-81f10daf4f0c} */
            { 0x2f946df9, 0x114c, 0x41fe, { 0x88, 0x99, 0x81, 0xf1, 0x0d, 0xaf, 0x4f, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous247 */ {
            /* {9e9a9283-0ce9-4e4a-8f1c-ba129a032c32} */
            { 0x9e9a9283, 0xce9, 0x4e4a, { 0x8f, 0x1c, 0xba, 0x12, 0x9a, 0x03, 0x2c, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous354 */ {
            /* {ccd0e960-7947-4635-b70e-4c661b63d675} */
            { 0xccd0e960, 0x7947, 0x4635, { 0xb7, 0x0e, 0x4c, 0x66, 0x1b, 0x63, 0xd6, 0x75 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous142 */ {
            /* {be59dbf0-2812-11d3-80a3-006008128c4e} */
            { 0xbe59dbf0, 0x2812, 0x11d3, { 0x80, 0xa3, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous610 */ {
            /* {acf8dc47-4a25-11d3-9890-006008962422} */
            { 0xacf8dc47, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous505 */ {
            /* {88cecbb7-6c63-4b3b-8cd4-84f3b8228c69} */
            { 0x88cecbb7, 0x6c63, 0x4b3b, { 0x8c, 0xd4, 0x84, 0xf3, 0xb8, 0x22, 0x8c, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous431 */ {
            /* {45a5fe2f-c350-4b86-962d-02d5aaaa955a} */
            { 0x45a5fe2f, 0xc350, 0x4b86, { 0x96, 0x2d, 0x02, 0xd5, 0xaa, 0xaa, 0x95, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous096 */ {
            /* {a30be08c-afc8-4fed-9af7-79778a23db23} */
            { 0xa30be08c, 0xafc8, 0x4fed, { 0x9a, 0xf7, 0x79, 0x77, 0x8a, 0x23, 0xdb, 0x23 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous625 */ {
            /* {5ff24248-1dd2-11b2-8427-fbab44f29bc8} */
            { 0x5ff24248, 0x1dd2, 0x11b2, { 0x84, 0x27, 0xfb, 0xab, 0x44, 0xf2, 0x9b, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* FileProtocolHandler */ {
            /* {fbc81170-1f69-11d3-9344-00104ba0fd40} */
            { 0xfbc81170, 0x1f69, 0x11d3, { 0x93, 0x44, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous474 */ {
            /* {eb1904db-e0d1-4760-a721-db76b1ca3e94} */
            { 0xeb1904db, 0xe0d1, 0x4760, { 0xa7, 0x21, 0xdb, 0x76, 0xb1, 0xca, 0x3e, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous683 */ {
            /* {48c345e7-9929-4f9a-a563-f478222dabcd} */
            { 0x48c345e7, 0x9929, 0x4f9a, { 0xa5, 0x63, 0xf4, 0x78, 0x22, 0x2d, 0xab, 0xcd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous327 */ {
            /* {88e2fd0b-f7f4-480c-9483-7846b00e8dad} */
            { 0x88e2fd0b, 0xf7f4, 0x480c, { 0x94, 0x83, 0x78, 0x46, 0xb0, 0x0e, 0x8d, 0xad } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous569 */ {
            /* {e9537f8f-c07e-4435-8ab3-83f1ad6e3bbf} */
            { 0xe9537f8f, 0xc07e, 0x4435, { 0x8a, 0xb3, 0x83, 0xf1, 0xad, 0x6e, 0x3b, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_AND_MAIN_PROCESS,
          },
  
          /* Anonymous362 */ {
            /* {b6ed3030-6183-11d3-a178-0050041caf44} */
            { 0xb6ed3030, 0x6183, 0x11d3, { 0xa1, 0x78, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous297 */ {
            /* {cde1d019-fad8-4044-b141-65fb4fb7a245} */
            { 0xcde1d019, 0xfad8, 0x4044, { 0xb1, 0x41, 0x65, 0xfb, 0x4f, 0xb7, 0xa2, 0x45 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous082 */ {
            /* {53d16809-1114-44e2-b585-41a2abb18f66} */
            { 0x53d16809, 0x1114, 0x44e2, { 0xb5, 0x85, 0x41, 0xa2, 0xab, 0xb1, 0x8f, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous061 */ {
            /* {9dd7f36b-5960-4f0a-8789-f5f516bd083d} */
            { 0x9dd7f36b, 0x5960, 0x4f0a, { 0x87, 0x89, 0xf5, 0xf5, 0x16, 0xbd, 0x08, 0x3d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous016 */ {
            /* {c61cb903-4408-41b3-bc22-da0b27efdfe1} */
            { 0xc61cb903, 0x4408, 0x41b3, { 0xbc, 0x22, 0xda, 0x0b, 0x27, 0xef, 0xdf, 0xe1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous258 */ {
            /* {c616fcfd-9737-41f1-aa74-cee72a38f91b} */
            { 0xc616fcfd, 0x9737, 0x41f1, { 0xaa, 0x74, 0xce, 0xe7, 0x2a, 0x38, 0xf9, 0x1b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous192 */ {
            /* {d6bd81fa-b1d4-424a-88ea-bb3ea8381d50} */
            { 0xd6bd81fa, 0xb1d4, 0x424a, { 0x88, 0xea, 0xbb, 0x3e, 0xa8, 0x38, 0x1d, 0x50 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous228 */ {
            /* {24220ecd-cb05-4676-8a47-fa1da7b86e6e} */
            { 0x24220ecd, 0xcb05, 0x4676, { 0x8a, 0x47, 0xfa, 0x1d, 0xa7, 0xb8, 0x6e, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous311 */ {
            /* {f6fcd651-164b-4416-b001-9c8c393fd93b} */
            { 0xf6fcd651, 0x164b, 0x4416, { 0xb0, 0x01, 0x9c, 0x8c, 0x39, 0x3f, 0xd9, 0x3b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous214 */ {
            /* {d1258011-f391-44fd-992e-c6f4b461a42f} */
            { 0xd1258011, 0xf391, 0x44fd, { 0x99, 0x2e, 0xc6, 0xf4, 0xb4, 0x61, 0xa4, 0x2f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous173 */ {
            /* {9dcef3a4-a3bc-11d5-ba47-00108303b117} */
            { 0x9dcef3a4, 0xa3bc, 0x11d5, { 0xba, 0x47, 0x00, 0x10, 0x83, 0x03, 0xb1, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous471 */ {
            /* {6ebc941a-f2ff-4d56-b3b6-f7d0b9d73344} */
            { 0x6ebc941a, 0xf2ff, 0x4d56, { 0xb3, 0xb6, 0xf7, 0xd0, 0xb9, 0xd7, 0x33, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous410 */ {
            /* {8200e12c-416c-42eb-8af5-db9745d2e527} */
            { 0x8200e12c, 0x416c, 0x42eb, { 0x8a, 0xf5, 0xdb, 0x97, 0x45, 0xd2, 0xe5, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous566 */ {
            /* {c401eb80-f9ea-11d3-bb6f-e732b73ebe7c} */
            { 0xc401eb80, 0xf9ea, 0x11d3, { 0xbb, 0x6f, 0xe7, 0x32, 0xb7, 0x3e, 0xbe, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous526 */ {
            /* {aa892eb4-ffbf-477d-9f9a-06c995ae9f27} */
            { 0xaa892eb4, 0xffbf, 0x477d, { 0x9f, 0x9a, 0x06, 0xc9, 0x95, 0xae, 0x9f, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous521 */ {
            /* {6c072f47-f25c-484f-add8-051b07789593} */
            { 0x6c072f47, 0xf25c, 0x484f, { 0xad, 0xd8, 0x05, 0x1b, 0x07, 0x78, 0x95, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous256 */ {
            /* {a7f800e0-4306-11d4-98d0-001083010e9b} */
            { 0xa7f800e0, 0x4306, 0x11d4, { 0x98, 0xd0, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous059 */ {
            /* {089694e9-106a-4704-abf7-62a88545e194} */
            { 0x89694e9, 0x106a, 0x4704, { 0xab, 0xf7, 0x62, 0xa8, 0x85, 0x45, 0xe1, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Folder */ {
            /* {0c8ec907-49c7-49bc-8bdf-b16e29bd6c47} */
            { 0xc8ec907, 0x49c7, 0x49bc, { 0x8b, 0xdf, 0xb1, 0x6e, 0x29, 0xbd, 0x6c, 0x47 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous031 */ {
            /* {72d9ab35-9b1b-442a-8cd0-ae49f00b159b} */
            { 0x72d9ab35, 0x9b1b, 0x442a, { 0x8c, 0xd0, 0xae, 0x49, 0xf0, 0x0b, 0x15, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous533 */ {
            /* {26a4a019-2827-4a89-a85c-5931a678823a} */
            { 0x26a4a019, 0x2827, 0x4a89, { 0xa8, 0x5c, 0x59, 0x31, 0xa6, 0x78, 0x82, 0x3a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous292 */ {
            /* {52fc3f9f-c0cb-4874-b3d4-ee4b6e9cbe9c} */
            { 0x52fc3f9f, 0xc0cb, 0x4874, { 0xb3, 0xd4, 0xee, 0x4b, 0x6e, 0x9c, 0xbe, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous439 */ {
            /* {9676cfc4-6e84-11ec-a30d-d3cd0af86e01} */
            { 0x9676cfc4, 0x6e84, 0x11ec, { 0xa3, 0x0d, 0xd3, 0xcd, 0x0a, 0xf8, 0x6e, 0x01 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous508 */ {
            /* {705a423f-2f69-42f3-b9fe-1517e0dee56f} */
            { 0x705a423f, 0x2f69, 0x42f3, { 0xb9, 0xfe, 0x15, 0x17, 0xe0, 0xde, 0xe5, 0x6f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IO */ {
            /* {9ac9e770-18bc-11d3-9337-00104ba0fd40} */
            { 0x9ac9e770, 0x18bc, 0x11d3, { 0x93, 0x37, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous326 */ {
            /* {929814d6-1dd2-11b2-8e08-82fa0a339b00} */
            { 0x929814d6, 0x1dd2, 0x11b2, { 0x8e, 0x08, 0x82, 0xfa, 0x0a, 0x33, 0x9b, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* BounceTrackingProtection */ {
            /* {4866f748-29da-4c10-8eaa-ed2f7851e6b1} */
            { 0x4866f748, 0x29da, 0x4c10, { 0x8e, 0xaa, 0xed, 0x2f, 0x78, 0x51, 0xe6, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous604 */ {
            /* {acf8dc43-4a25-11d3-9890-006008962422} */
            { 0xacf8dc43, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous662 */ {
            /* {9d3f70da-86e9-11d4-95ec-00b0d03e37b7} */
            { 0x9d3f70da, 0x86e9, 0x11d4, { 0x95, 0xec, 0x00, 0xb0, 0xd0, 0x3e, 0x37, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous238 */ {
            /* {ce71772d-2925-4496-be82-8b16b7b74d8f} */
            { 0xce71772d, 0x2925, 0x4496, { 0xbe, 0x82, 0x8b, 0x16, 0xb7, 0xb7, 0x4d, 0x8f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous370 */ {
            /* {dc01db59-a513-4c90-824b-085cce06c0aa} */
            { 0xdc01db59, 0xa513, 0x4c90, { 0x82, 0x4b, 0x08, 0x5c, 0xce, 0x06, 0xc0, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous529 */ {
            /* {aea477f2-b3a2-469c-aa29-0a82d132b829} */
            { 0xaea477f2, 0xb3a2, 0x469c, { 0xaa, 0x29, 0x0a, 0x82, 0xd1, 0x32, 0xb8, 0x29 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous048 */ {
            /* {50ea817e-5d79-4657-91ae-aa0a52bdb98c} */
            { 0x50ea817e, 0x5d79, 0x4657, { 0x91, 0xae, 0xaa, 0x0a, 0x52, 0xbd, 0xb9, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous556 */ {
            /* {220cc253-b60f-41f6-b9cf-fdcb325f970f} */
            { 0x220cc253, 0xb60f, 0x41f6, { 0xb9, 0xcf, 0xfd, 0xcb, 0x32, 0x5f, 0x97, 0x0f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous156 */ {
            /* {36d90300-27f5-11d3-8d74-00805f8a6617} */
            { 0x36d90300, 0x27f5, 0x11d3, { 0x8d, 0x74, 0x00, 0x80, 0x5f, 0x8a, 0x66, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous062 */ {
            /* {a4617631-b8b8-4053-8afa-5c4c43498280} */
            { 0xa4617631, 0xb8b8, 0x4053, { 0x8a, 0xfa, 0x5c, 0x4c, 0x43, 0x49, 0x82, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StreamConverter */ {
            /* {892ffeb0-3f80-11d3-a16c-0050041caf44} */
            { 0x892ffeb0, 0x3f80, 0x11d3, { 0xa1, 0x6c, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous395 */ {
            /* {b0054ef3-b096-483d-8242-4ee36b7b2115} */
            { 0xb0054ef3, 0xb096, 0x483d, { 0x82, 0x42, 0x4e, 0xe3, 0x6b, 0x7b, 0x21, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous488 */ {
            /* {3fdd6c28-5b87-4e3e-8b57-8e83c23c1a6d} */
            { 0x3fdd6c28, 0x5b87, 0x4e3e, { 0x8b, 0x57, 0x8e, 0x83, 0xc2, 0x3c, 0x1a, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous025 */ {
            /* {7af51168-6abe-4a31-984d-6f8a3989212d} */
            { 0x7af51168, 0x6abe, 0x4a31, { 0x98, 0x4d, 0x6f, 0x8a, 0x39, 0x89, 0x21, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous133 */ {
            /* {eb5bdaf8-bbc6-11d2-a6ec-0060b0eb39b5} */
            { 0xeb5bdaf8, 0xbbc6, 0x11d2, { 0xa6, 0xec, 0x00, 0x60, 0xb0, 0xeb, 0x39, 0xb5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous245 */ {
            /* {ec5aa99c-7abb-4142-ac5f-aab2419e38e2} */
            { 0xec5aa99c, 0x7abb, 0x4142, { 0xac, 0x5f, 0xaa, 0xb2, 0x41, 0x9e, 0x38, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous274 */ {
            /* {7fe6e18b-0da3-4056-bf3b-440ef3809e06} */
            { 0x7fe6e18b, 0xda3, 0x4056, { 0xbf, 0x3b, 0x44, 0x0e, 0xf3, 0x80, 0x9e, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous619 */ {
            /* {35c66fd1-95e9-4e0a-80c5-c3bd2b375481} */
            { 0x35c66fd1, 0x95e9, 0x4e0a, { 0x80, 0xc5, 0xc3, 0xbd, 0x2b, 0x37, 0x54, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous306 */ {
            /* {ba5bc4c6-1dd1-11b2-bb89-b844c6ec0339} */
            { 0xba5bc4c6, 0x1dd1, 0x11b2, { 0xbb, 0x89, 0xb8, 0x44, 0xc6, 0xec, 0x03, 0x39 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous659 */ {
            /* {0e3afd3d-eb60-4c2b-963b-56d7c439f124} */
            { 0xe3afd3d, 0xeb60, 0x4c2b, { 0x96, 0x3b, 0x56, 0xd7, 0xc4, 0x39, 0xf1, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous614 */ {
            /* {7a4204c6-e45a-4c37-8ebb-6709a22c917c} */
            { 0x7a4204c6, 0xe45a, 0x4c37, { 0x8e, 0xbb, 0x67, 0x09, 0xa2, 0x2c, 0x91, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* MimeHeaderParam */ {
            /* {1f4dbcf7-245c-4c8c-943d-8a1da0495e8a} */
            { 0x1f4dbcf7, 0x245c, 0x4c8c, { 0x94, 0x3d, 0x8a, 0x1d, 0xa0, 0x49, 0x5e, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous037 */ {
            /* {aeff788d-63b0-4996-91fb-40a7654c6224} */
            { 0xaeff788d, 0x63b0, 0x4996, { 0x91, 0xfb, 0x40, 0xa7, 0x65, 0x4c, 0x62, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous032 */ {
            /* {d4d7b59e-c9e0-4a7a-b5e8-5958f85515f0} */
            { 0xd4d7b59e, 0xc9e0, 0x4a7a, { 0xb5, 0xe8, 0x59, 0x58, 0xf8, 0x55, 0x15, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous584 */ {
            /* {a6cf9129-15b3-11d2-932e-00805f8add32} */
            { 0xa6cf9129, 0x15b3, 0x11d2, { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* ChromeRegistry */ {
            /* {47049e42-1d87-482a-984d-56ae185e367a} */
            { 0x47049e42, 0x1d87, 0x482a, { 0x98, 0x4d, 0x56, 0xae, 0x18, 0x5e, 0x36, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous670 */ {
            /* {2a058404-fb85-44ec-8cfd-e8cbdc988dc1} */
            { 0x2a058404, 0xfb85, 0x44ec, { 0x8c, 0xfd, 0xe8, 0xcb, 0xdc, 0x98, 0x8d, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous123 */ {
            /* {483c8abb-ecf9-48a3-a394-2c604b603bd5} */
            { 0x483c8abb, 0xecf9, 0x48a3, { 0xa3, 0x94, 0x2c, 0x60, 0x4b, 0x60, 0x3b, 0xd5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous537 */ {
            /* {e6156350-2be8-11db-a98b-0800200c9a66} */
            { 0xe6156350, 0x2be8, 0x11db, { 0xa9, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous586 */ {
            /* {68bf4793-5204-45cf-9ee2-69adffbc2e38} */
            { 0x68bf4793, 0x5204, 0x45cf, { 0x9e, 0xe2, 0x69, 0xad, 0xff, 0xbc, 0x2e, 0x38 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous222 */ {
            /* {e9bb3330-ac7e-11de-8a39-0800200c9a66} */
            { 0xe9bb3330, 0xac7e, 0x11de, { 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* WindowWatcher */ {
            /* {a21bfa01-f349-4394-a84c-8de5cf0737d0} */
            { 0xa21bfa01, 0xf349, 0x4394, { 0xa8, 0x4c, 0x8d, 0xe5, 0xcf, 0x07, 0x37, 0xd0 } },
            { 0x3c1c } /* "@mozilla.org/embedcomp/window-watcher;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous272 */ {
            /* {1775081b-b62d-4954-8ffe-a067bbf508a7} */
            { 0x1775081b, 0xb62d, 0x4954, { 0x8f, 0xfe, 0xa0, 0x67, 0xbb, 0xf5, 0x08, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous260 */ {
            /* {e740ddb4-18b4-4aac-8ae1-9b0f4320769d} */
            { 0xe740ddb4, 0x18b4, 0x4aac, { 0x8a, 0xe1, 0x9b, 0x0f, 0x43, 0x20, 0x76, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous596 */ {
            /* {aaf68860-f849-40ee-bb7a-b229bce036a3} */
            { 0xaaf68860, 0xf849, 0x40ee, { 0xbb, 0x7a, 0xb2, 0x29, 0xbc, 0xe0, 0x36, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous641 */ {
            /* {4812ff32-1bff-423b-97fc-40a5696dad22} */
            { 0x4812ff32, 0x1bff, 0x423b, { 0x97, 0xfc, 0x40, 0xa5, 0x69, 0x6d, 0xad, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous554 */ {
            /* {5f5e59ce-27bc-47eb-9d1f-b09ca9049836} */
            { 0x5f5e59ce, 0x27bc, 0x47eb, { 0x9d, 0x1f, 0xb0, 0x9c, 0xa9, 0x04, 0x98, 0x36 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ApplicationReputation */ {
            /* {d21b4c33-716f-4117-8041-2770b59ff8a6} */
            { 0xd21b4c33, 0x716f, 0x4117, { 0x80, 0x41, 0x27, 0x70, 0xb5, 0x9f, 0xf8, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous577 */ {
            /* {f55f5d31-dbb7-4d0d-9f6f-a4f4cd8e8ef1} */
            { 0xf55f5d31, 0xdbb7, 0x4d0d, { 0x9f, 0x6f, 0xa4, 0xf4, 0xcd, 0x8e, 0x8e, 0xf1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous664 */ {
            /* {abc622ea-9655-4123-80d9-22621bdd5465} */
            { 0xabc622ea, 0x9655, 0x4123, { 0x80, 0xd9, 0x22, 0x62, 0x1b, 0xdd, 0x54, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous209 */ {
            /* {2b79ac51-1459-11d3-8097-006008128c4e} */
            { 0x2b79ac51, 0x1459, 0x11d3, { 0x80, 0x97, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous438 */ {
            /* {4ea60761-31d6-491d-9e34-4b53a26c416c} */
            { 0x4ea60761, 0x31d6, 0x491d, { 0x9e, 0x34, 0x4b, 0x53, 0xa2, 0x6c, 0x41, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous571 */ {
            /* {4364de1a-798e-419c-a6f5-ca28866b6d5f} */
            { 0x4364de1a, 0x798e, 0x419c, { 0xa6, 0xf5, 0xca, 0x28, 0x86, 0x6b, 0x6d, 0x5f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous382 */ {
            /* {1813cbb4-c98e-4622-8c7d-839167f3f272} */
            { 0x1813cbb4, 0xc98e, 0x4622, { 0x8c, 0x7d, 0x83, 0x91, 0x67, 0xf3, 0xf2, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous455 */ {
            /* {afff16f0-3fd2-4153-9ccd-c6d9abd879e4} */
            { 0xafff16f0, 0x3fd2, 0x4153, { 0x9c, 0xcd, 0xc6, 0xd9, 0xab, 0xd8, 0x79, 0xe4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous623 */ {
            /* {0abb0835-5000-4790-af28-61b3ba17c295} */
            { 0xabb0835, 0x5000, 0x4790, { 0xaf, 0x28, 0x61, 0xb3, 0xba, 0x17, 0xc2, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* CategoryManager */ {
            /* {16d222a6-1dd2-11b2-b693-f38b02c021b2} */
            { 0x16d222a6, 0x1dd2, 0x11b2, { 0xb6, 0x93, 0xf3, 0x8b, 0x02, 0xc0, 0x21, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous503 */ {
            /* {984e3259-9266-49cf-b605-60b022a00756} */
            { 0x984e3259, 0x9266, 0x49cf, { 0xb6, 0x05, 0x60, 0xb0, 0x22, 0xa0, 0x07, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous153 */ {
            /* {3a75f5ea-651e-4696-9813-848c03da8bbd} */
            { 0x3a75f5ea, 0x651e, 0x4696, { 0x98, 0x13, 0x84, 0x8c, 0x03, 0xda, 0x8b, 0xbd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous392 */ {
            /* {2f277c00-0eaf-4ddb-b936-41326ba48aae} */
            { 0x2f277c00, 0xeaf, 0x4ddb, { 0xb9, 0x36, 0x41, 0x32, 0x6b, 0xa4, 0x8a, 0xae } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous567 */ {
            /* {b2cdd51c-4277-417b-a931-08306c7814c3} */
            { 0xb2cdd51c, 0x4277, 0x417b, { 0xa9, 0x31, 0x08, 0x30, 0x6c, 0x78, 0x14, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous468 */ {
            /* {c8d0b0b3-17f8-458b-9264-7b67b288fe79} */
            { 0xc8d0b0b3, 0x17f8, 0x458b, { 0x92, 0x64, 0x7b, 0x67, 0xb2, 0x88, 0xfe, 0x79 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierDB */ {
            /* {7a258022-6765-11e5-b379-b37b1f2354be} */
            { 0x7a258022, 0x6765, 0x11e5, { 0xb3, 0x79, 0xb3, 0x7b, 0x1f, 0x23, 0x54, 0xbe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StringBundle */ {
            /* {d85a17c1-aa7c-11d2-9b8c-00805f8a16d9} */
            { 0xd85a17c1, 0xaa7c, 0x11d2, { 0x9b, 0x8c, 0x00, 0x80, 0x5f, 0x8a, 0x16, 0xd9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous211 */ {
            /* {3a874285-5520-41a0-bcda-a3dee3dbf4f3} */
            { 0x3a874285, 0x5520, 0x41a0, { 0xbc, 0xda, 0xa3, 0xde, 0xe3, 0xdb, 0xf4, 0xf3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous172 */ {
            /* {5fb907e0-1dd2-11b2-a7c0-f14c416a62a1} */
            { 0x5fb907e0, 0x1dd2, 0x11b2, { 0xa7, 0xc0, 0xf1, 0x4c, 0x41, 0x6a, 0x62, 0xa1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous675 */ {
            /* {1950539a-90f0-4d22-b5af-71329c68fa35} */
            { 0x1950539a, 0x90f0, 0x4d22, { 0xb5, 0xaf, 0x71, 0x32, 0x9c, 0x68, 0xfa, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous070 */ {
            /* {e2e0f615-bc5a-4441-a16b-a26e75949376} */
            { 0xe2e0f615, 0xbc5a, 0x4441, { 0xa1, 0x6b, 0xa2, 0x6e, 0x75, 0x94, 0x93, 0x76 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous036 */ {
            /* {a35fc6ea-3d92-11d9-89f9-00045ace3b8d} */
            { 0xa35fc6ea, 0x3d92, 0x11d9, { 0x89, 0xf9, 0x00, 0x04, 0x5a, 0xce, 0x3b, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous152 */ {
            /* {af314bd9-0b28-4f69-9bea-592ab4dc6811} */
            { 0xaf314bd9, 0xb28, 0x4f69, { 0x9b, 0xea, 0x59, 0x2a, 0xb4, 0xdc, 0x68, 0x11 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous463 */ {
            /* {15686f9d-483e-4361-98cd-37f1e8f1e61d} */
            { 0x15686f9d, 0x483e, 0x4361, { 0x98, 0xcd, 0x37, 0xf1, 0xe8, 0xf1, 0xe6, 0x1d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous378 */ {
            /* {ce7d7da0-fb28-44a3-8c7b-000c165918f4} */
            { 0xce7d7da0, 0xfb28, 0x44a3, { 0x8c, 0x7b, 0x00, 0x0c, 0x16, 0x59, 0x18, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous217 */ {
            /* {faf4f9a6-60ad-11d3-989a-001083010e9b} */
            { 0xfaf4f9a6, 0x60ad, 0x11d3, { 0x98, 0x9a, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous637 */ {
            /* {0ddf4df8-4dbb-4133-8b79-9afb966514f5} */
            { 0xddf4df8, 0x4dbb, 0x4133, { 0x8b, 0x79, 0x9a, 0xfb, 0x96, 0x65, 0x14, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HttpHandler */ {
            /* {4f47e42e-4d23-4dd3-bfda-eb29255e9ea3} */
            { 0x4f47e42e, 0x4d23, 0x4dd3, { 0xbf, 0xda, 0xeb, 0x29, 0x25, 0x5e, 0x9e, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous263 */ {
            /* {1a26a7b7-d06e-4f45-8b45-d7ad60f7a9ab} */
            { 0x1a26a7b7, 0xd06e, 0x4f45, { 0x8b, 0x45, 0xd7, 0xad, 0x60, 0xf7, 0xa9, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous443 */ {
            /* {5118a6f9-2493-4f97-9552-620663e03cb3} */
            { 0x5118a6f9, 0x2493, 0x4f97, { 0x95, 0x52, 0x62, 0x06, 0x63, 0xe0, 0x3c, 0xb3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous389 */ {
            /* {66230b2b-17fa-4bd3-abf4-07986151022d} */
            { 0x66230b2b, 0x17fa, 0x4bd3, { 0xab, 0xf4, 0x07, 0x98, 0x61, 0x51, 0x02, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous194 */ {
            /* {74b9b9c3-9594-41c4-b9f0-326e5daac2e0} */
            { 0x74b9b9c3, 0x9594, 0x41c4, { 0xb9, 0xf0, 0x32, 0x6e, 0x5d, 0xaa, 0xc2, 0xe0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous053 */ {
            /* {5fa5974e-09cb-40cc-9696-643f8a8d9a06} */
            { 0x5fa5974e, 0x9cb, 0x40cc, { 0x96, 0x96, 0x64, 0x3f, 0x8a, 0x8d, 0x9a, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous114 */ {
            /* {aeac118c-0823-11d5-a5bf-0060b0fc04b7} */
            { 0xaeac118c, 0x823, 0x11d5, { 0xa5, 0xbf, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous186 */ {
            /* {64fa0a31-a494-4f4b-ac4d-b29910d6ccd6} */
            { 0x64fa0a31, 0xa494, 0x4f4b, { 0xac, 0x4d, 0xb2, 0x99, 0x10, 0xd6, 0xcc, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous504 */ {
            /* {9de95a0c-39a4-4d64-9a53-17940dd7cabb} */
            { 0x9de95a0c, 0x39a4, 0x4d64, { 0x9a, 0x53, 0x17, 0x94, 0x0d, 0xd7, 0xca, 0xbb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous612 */ {
            /* {acf8dc44-4a25-11d3-9890-006008962422} */
            { 0xacf8dc44, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous267 */ {
            /* {3e43ee93-829e-4ea6-a34e-62d9e4c9f993} */
            { 0x3e43ee93, 0x829e, 0x4ea6, { 0xa3, 0x4e, 0x62, 0xd9, 0xe4, 0xc9, 0xf9, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous021 */ {
            /* {806b6423-3aaa-4b26-afa3-de60563e9cec} */
            { 0x806b6423, 0x3aaa, 0x4b26, { 0xaf, 0xa3, 0xde, 0x60, 0x56, 0x3e, 0x9c, 0xec } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous236 */ {
            /* {c3d44b68-11f1-421f-8f4b-706df13df64a} */
            { 0xc3d44b68, 0x11f1, 0x421f, { 0x8f, 0x4b, 0x70, 0x6d, 0xf1, 0x3d, 0xf6, 0x4a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous593 */ {
            /* {00bd71fb-7f09-4ec3-96af-a0b522b77969} */
            { 0xbd71fb, 0x7f09, 0x4ec3, { 0x96, 0xaf, 0xa0, 0xb5, 0x22, 0xb7, 0x79, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous009 */ {
            /* {36783242-ec94-4d8a-9248-d2679edd55b9} */
            { 0x36783242, 0xec94, 0x4d8a, { 0x92, 0x48, 0xd2, 0x67, 0x9e, 0xdd, 0x55, 0xb9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous115 */ {
            /* {2dd9d0fe-b609-11d6-bacc-00108335748d} */
            { 0x2dd9d0fe, 0xb609, 0x11d6, { 0xba, 0xcc, 0x00, 0x10, 0x83, 0x35, 0x74, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* OutgoingServer */ {
            /* {acda6039-8b17-46c1-a8ed-ad50aa80f412} */
            { 0xacda6039, 0x8b17, 0x46c1, { 0xa8, 0xed, 0xad, 0x50, 0xaa, 0x80, 0xf4, 0x12 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous159 */ {
            /* {9e4b07ee-e980-11d2-a506-0060b0fc04b7} */
            { 0x9e4b07ee, 0xe980, 0x11d2, { 0xa5, 0x06, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous276 */ {
            /* {4fff5d46-d827-4cd4-a970-8fd53977440e} */
            { 0x4fff5d46, 0xd827, 0x4cd4, { 0xa9, 0x70, 0x8f, 0xd5, 0x39, 0x77, 0x44, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous113 */ {
            /* {597e1ffe-0123-11d5-a5be-0060b0fc04b7} */
            { 0x597e1ffe, 0x123, 0x11d5, { 0xa5, 0xbe, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous317 */ {
            /* {38d1592e-b81e-432b-86f8-471878bbfe07} */
            { 0x38d1592e, 0xb81e, 0x432b, { 0x86, 0xf8, 0x47, 0x18, 0x78, 0xbb, 0xfe, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous298 */ {
            /* {daaa8d73-677e-4233-8acd-2c404bd01658} */
            { 0xdaaa8d73, 0x677e, 0x4233, { 0x8a, 0xcd, 0x2c, 0x40, 0x4b, 0xd0, 0x16, 0x58 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous175 */ {
            /* {a15789aa-8903-462b-81e9-4aa2cff4d5cb} */
            { 0xa15789aa, 0x8903, 0x462b, { 0x81, 0xe9, 0x4a, 0xa2, 0xcf, 0xf4, 0xd5, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous108 */ {
            /* {bd85a417-5433-11d3-8ac5-0060b0fc04d2} */
            { 0xbd85a417, 0x5433, 0x11d3, { 0x8a, 0xc5, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xd2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous056 */ {
            /* {44346520-c5d2-44e5-a1ec-034e04d7fac4} */
            { 0x44346520, 0xc5d2, 0x44e5, { 0xa1, 0xec, 0x03, 0x4e, 0x04, 0xd7, 0xfa, 0xc4 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous161 */ {
            /* {4e3dae5a-157a-11d5-a5c0-0060b0fc04b7} */
            { 0x4e3dae5a, 0x157a, 0x11d5, { 0xa5, 0xc0, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous422 */ {
            /* {786a1369-dca5-4adc-8486-33d23c88010a} */
            { 0x786a1369, 0xdca5, 0x4adc, { 0x84, 0x86, 0x33, 0xd2, 0x3c, 0x88, 0x01, 0x0a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous460 */ {
            /* {8cd92fce-1ec3-470a-ad09-c0de9d98497e} */
            { 0x8cd92fce, 0x1ec3, 0x470a, { 0xad, 0x09, 0xc0, 0xde, 0x9d, 0x98, 0x49, 0x7e } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous105 */ {
            /* {4a374e7e-190f-11d3-8a88-0060b0fc04d2} */
            { 0x4a374e7e, 0x190f, 0x11d3, { 0x8a, 0x88, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xd2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous325 */ {
            /* {0a4478f4-c5ae-4fb1-8686-d5b09fb99afb} */
            { 0xa4478f4, 0xc5ae, 0x4fb1, { 0x86, 0x86, 0xd5, 0xb0, 0x9f, 0xb9, 0x9a, 0xfb } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous513 */ {
            /* {0636a680-45cb-11e4-916c-0800200c9a66} */
            { 0x636a680, 0x45cb, 0x11e4, { 0x91, 0x6c, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* UrlClassifierUtils */ {
            /* {b7b2ccec-7912-4ea6-a548-b038447004bd} */
            { 0xb7b2ccec, 0x7912, 0x4ea6, { 0xa5, 0x48, 0xb0, 0x38, 0x44, 0x70, 0x04, 0xbd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous007 */ {
            /* {5c8dcaa3-170c-4a73-8142-d531156f664d} */
            { 0x5c8dcaa3, 0x170c, 0x4a73, { 0x81, 0x42, 0xd5, 0x31, 0x15, 0x6f, 0x66, 0x4d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous561 */ {
            /* {11a77259-9d16-4386-8ac8-94338ee22f78} */
            { 0x11a77259, 0x9d16, 0x4386, { 0x8a, 0xc8, 0x94, 0x33, 0x8e, 0xe2, 0x2f, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous485 */ {
            /* {6cc1a0a8-af97-4d41-9b4a-58dcec46ebce} */
            { 0x6cc1a0a8, 0xaf97, 0x4d41, { 0x9b, 0x4a, 0x58, 0xdc, 0xec, 0x46, 0xeb, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous244 */ {
            /* {d8c9acee-dec5-11e4-8c75-1681e6b88ec1} */
            { 0xd8c9acee, 0xdec5, 0x11e4, { 0x8c, 0x75, 0x16, 0x81, 0xe6, 0xb8, 0x8e, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous140 */ {
            /* {ef173501-4e14-42b9-ae1f-7770de235c29} */
            { 0xef173501, 0x4e14, 0x42b9, { 0xae, 0x1f, 0x77, 0x70, 0xde, 0x23, 0x5c, 0x29 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous649 */ {
            /* {5a75c25a-5e7e-4d90-8f7c-07eb15cc0aa8} */
            { 0x5a75c25a, 0x5e7e, 0x4d90, { 0x8f, 0x7c, 0x07, 0xeb, 0x15, 0xcc, 0x0a, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous548 */ {
            /* {84e11f80-ca55-11dd-ad8b-0800200c9a66} */
            { 0x84e11f80, 0xca55, 0x11dd, { 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous352 */ {
            /* {5d6352a3-b9c3-4fa3-87aa-b2a3c6e5a501} */
            { 0x5d6352a3, 0xb9c3, 0x4fa3, { 0x87, 0xaa, 0xb2, 0xa3, 0xc6, 0xe5, 0xa5, 0x01 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous262 */ {
            /* {b43964aa-a078-44b2-b06b-fd4d1b172e66} */
            { 0xb43964aa, 0xa078, 0x44b2, { 0xb0, 0x6b, 0xfd, 0x4d, 0x1b, 0x17, 0x2e, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous511 */ {
            /* {7d47b41d-7cc5-4882-b293-d8f3f3b48b46} */
            { 0x7d47b41d, 0x7cc5, 0x4882, { 0xb2, 0x93, 0xd8, 0xf3, 0xf3, 0xb4, 0x8b, 0x46 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous020 */ {
            /* {bdf71224-365d-4493-856a-a7e74026f766} */
            { 0xbdf71224, 0x365d, 0x4493, { 0x85, 0x6a, 0xa7, 0xe7, 0x40, 0x26, 0xf7, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous078 */ {
            /* {e8b59b32-f83f-4d5f-8eb5-e3c1e5de0d47} */
            { 0xe8b59b32, 0xf83f, 0x4d5f, { 0x8e, 0xb5, 0xe3, 0xc1, 0xe5, 0xde, 0x0d, 0x47 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous679 */ {
            /* {31689828-da66-49a6-870c-df62b83fe789} */
            { 0x31689828, 0xda66, 0x49a6, { 0x87, 0x0c, 0xdf, 0x62, 0xb8, 0x3f, 0xe7, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous350 */ {
            /* {36b63ef3-e0fa-4c49-9fd4-e065e85568f4} */
            { 0x36b63ef3, 0xe0fa, 0x4c49, { 0x9f, 0xd4, 0xe0, 0x65, 0xe8, 0x55, 0x68, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IdentityCredentialStorageService */ {
            /* {029823d0-0448-46c5-af1f-25cd4501d0d7} */
            { 0x29823d0, 0x448, 0x46c5, { 0xaf, 0x1f, 0x25, 0xcd, 0x45, 0x01, 0xd0, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* CORSPreflightCache */ {
            /* {e764a6ec-4eff-45e8-9241-024521d9413f} */
            { 0xe764a6ec, 0x4eff, 0x45e8, { 0x92, 0x41, 0x02, 0x45, 0x21, 0xd9, 0x41, 0x3f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous657 */ {
            /* {130b016f-fad7-4526-bc7f-827dabf79265} */
            { 0x130b016f, 0xfad7, 0x4526, { 0xbc, 0x7f, 0x82, 0x7d, 0xab, 0xf7, 0x92, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous246 */ {
            /* {0365cbd5-d46e-4e94-a39f-83b63cd1a963} */
            { 0x365cbd5, 0xd46e, 0x4e94, { 0xa3, 0x9f, 0x83, 0xb6, 0x3c, 0xd1, 0xa9, 0x63 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous181 */ {
            /* {4eca51df-6734-11d3-989a-001083010e9b} */
            { 0x4eca51df, 0x6734, 0x11d3, { 0x98, 0x9a, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous425 */ {
            /* {0c4f1ddc-1dd2-11b2-9d95-f2fdf113044b} */
            { 0xc4f1ddc, 0x1dd2, 0x11b2, { 0x9d, 0x95, 0xf2, 0xfd, 0xf1, 0x13, 0x04, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous307 */ {
            /* {56c778e4-1bee-45f3-a689-886692a97fe7} */
            { 0x56c778e4, 0x1bee, 0x45f3, { 0xa6, 0x89, 0x88, 0x66, 0x92, 0xa9, 0x7f, 0xe7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous445 */ {
            /* {5e756573-234a-49ea-bbe4-59ec7a70657d} */
            { 0x5e756573, 0x234a, 0x49ea, { 0xbb, 0xe4, 0x59, 0xec, 0x7a, 0x70, 0x65, 0x7d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous250 */ {
            /* {33d75835-722f-42c0-89cc-44f328e56a86} */
            { 0x33d75835, 0x722f, 0x42c0, { 0x89, 0xcc, 0x44, 0xf3, 0x28, 0xe5, 0x6a, 0x86 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous074 */ {
            /* {a6f94ca4-cd2d-4983-bcf2-fe936190955c} */
            { 0xa6f94ca4, 0xcd2d, 0x4983, { 0xbc, 0xf2, 0xfe, 0x93, 0x61, 0x90, 0x95, 0x5c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous532 */ {
            /* {f376627f-0bbc-47b8-887e-fc92574cc91f} */
            { 0xf376627f, 0xbbc, 0x47b8, { 0x88, 0x7e, 0xfc, 0x92, 0x57, 0x4c, 0xc9, 0x1f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous635 */ {
            /* {fe0ff7c3-8e97-448b-9a8a-86afdb9fbbb6} */
            { 0xfe0ff7c3, 0x8e97, 0x448b, { 0x9a, 0x8a, 0x86, 0xaf, 0xdb, 0x9f, 0xbb, 0xb6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous224 */ {
            /* {7d71db22-0624-4c9f-8d70-dea6ab3ff076} */
            { 0x7d71db22, 0x624, 0x4c9f, { 0x8d, 0x70, 0xde, 0xa6, 0xab, 0x3f, 0xf0, 0x76 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AsyncShutdown */ {
            /* {35c496de-a115-475d-93b5-ffa3f3ae6fe3} */
            { 0x35c496de, 0xa115, 0x475d, { 0x93, 0xb5, 0xff, 0xa3, 0xf3, 0xae, 0x6f, 0xe3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous195 */ {
            /* {060e684a-0acd-41f1-b36b-12de686f201e} */
            { 0x60e684a, 0xacd, 0x41f1, { 0xb3, 0x6b, 0x12, 0xde, 0x68, 0x6f, 0x20, 0x1e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AccountManager */ {
            /* {d2876e50-e62c-11d2-b7fc-00805f05ffa5} */
            { 0xd2876e50, 0xe62c, 0x11d2, { 0xb7, 0xfc, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous145 */ {
            /* {683728ac-88df-11d3-989d-001083010e9b} */
            { 0x683728ac, 0x88df, 0x11d3, { 0x98, 0x9d, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous079 */ {
            /* {50ca73fa-7deb-42b9-9eec-e219e31e6d4b} */
            { 0x50ca73fa, 0x7deb, 0x42b9, { 0x9e, 0xec, 0xe2, 0x19, 0xe3, 0x1e, 0x6d, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous363 */ {
            /* {dccbe7e4-7750-466b-a557-5ea36c8ff24e} */
            { 0xdccbe7e4, 0x7750, 0x466b, { 0xa5, 0x57, 0x5e, 0xa3, 0x6c, 0x8f, 0xf2, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous219 */ {
            /* {977e418f-e392-11d2-a2ac-00a024a7d144} */
            { 0x977e418f, 0xe392, 0x11d2, { 0xa2, 0xac, 0x00, 0xa0, 0x24, 0xa7, 0xd1, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous674 */ {
            /* {f68037ec-2790-44c5-8e5f-df5da58b93a7} */
            { 0xf68037ec, 0x2790, 0x44c5, { 0x8e, 0x5f, 0xdf, 0x5d, 0xa5, 0x8b, 0x93, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous502 */ {
            /* {e8b8bdb7-c96c-4d82-9c6f-2b3c585ec7ea} */
            { 0xe8b8bdb7, 0xc96c, 0x4d82, { 0x9c, 0x6f, 0x2b, 0x3c, 0x58, 0x5e, 0xc7, 0xea } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous609 */ {
            /* {acf8dc46-4a25-11d3-9890-006008962422} */
            { 0xacf8dc46, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous205 */ {
            /* {e490d22c-cd67-11d2-8cca-0060b0fc14a3} */
            { 0xe490d22c, 0xcd67, 0x11d2, { 0x8c, 0xca, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous402 */ {
            /* {e1676f84-e6e5-45d0-a4bf-d9905efc5b2e} */
            { 0xe1676f84, 0xe6e5, 0x45d0, { 0xa4, 0xbf, 0xd9, 0x90, 0x5e, 0xfc, 0x5b, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous633 */ {
            /* {bbe50ef2-80eb-469d-b70d-02858275389f} */
            { 0xbbe50ef2, 0x80eb, 0x469d, { 0xb7, 0x0d, 0x02, 0x85, 0x82, 0x75, 0x38, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous083 */ {
            /* {5b259db2-e451-4de9-8a6f-cfba91402973} */
            { 0x5b259db2, 0xe451, 0x4de9, { 0x8a, 0x6f, 0xcf, 0xba, 0x91, 0x40, 0x29, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous271 */ {
            /* {02b9970c-433d-4cc2-923d-f7028ac66073} */
            { 0x2b9970c, 0x433d, 0x4cc2, { 0x92, 0x3d, 0xf7, 0x02, 0x8a, 0xc6, 0x60, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* TypeAheadFind */ {
            /* {e7f70966-9a37-48d7-8aeb-35998f31090e} */
            { 0xe7f70966, 0x9a37, 0x48d7, { 0x8a, 0xeb, 0x35, 0x99, 0x8f, 0x31, 0x09, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous570 */ {
            /* {a9339876-0027-430f-b953-84c9c11c2da3} */
            { 0xa9339876, 0x27, 0x430f, { 0xb9, 0x53, 0x84, 0xc9, 0xc1, 0x1c, 0x2d, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous497 */ {
            /* {0f2f347c-1e4f-40cc-8efd-792dea70a85e} */
            { 0xf2f347c, 0x1e4f, 0x40cc, { 0x8e, 0xfd, 0x79, 0x2d, 0xea, 0x70, 0xa8, 0x5e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous019 */ {
            /* {1153c73a-39be-46aa-9ba9-656d188865ca} */
            { 0x1153c73a, 0x39be, 0x46aa, { 0x9b, 0xa9, 0x65, 0x6d, 0x18, 0x88, 0x65, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous041 */ {
            /* {1d1d0bc5-610c-472f-b2cb-4b89857d80dc} */
            { 0x1d1d0bc5, 0x610c, 0x472f, { 0xb2, 0xcb, 0x4b, 0x89, 0x85, 0x7d, 0x80, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IdentityCredentialPromptService */ {
            /* {936007db-a957-4f1d-a23d-f7d9403223e6} */
            { 0x936007db, 0xa957, 0x4f1d, { 0xa2, 0x3d, 0xf7, 0xd9, 0x40, 0x32, 0x23, 0xe6 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous376 */ {
            /* {2be14592-28d4-4a83-8fe9-08e778849f6e} */
            { 0x2be14592, 0x28d4, 0x4a83, { 0x8f, 0xe9, 0x08, 0xe7, 0x78, 0x84, 0x9f, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous284 */ {
            /* {37f819b0-0b5c-11e3-8ffd-0800200c9a67} */
            { 0x37f819b0, 0xb5c, 0x11e3, { 0x8f, 0xfd, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous492 */ {
            /* {47a45e5f-691e-4799-8686-14f8d3fc0f8c} */
            { 0x47a45e5f, 0x691e, 0x4799, { 0x86, 0x86, 0x14, 0xf8, 0xd3, 0xfc, 0x0f, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous110 */ {
            /* {8510876a-1dd2-11b2-8253-91f71b348a25} */
            { 0x8510876a, 0x1dd2, 0x11b2, { 0x82, 0x53, 0x91, 0xf7, 0x1b, 0x34, 0x8a, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous495 */ {
            /* {2bdac17c-53f1-4896-a521-682ccdeef3a8} */
            { 0x2bdac17c, 0x53f1, 0x4896, { 0xa5, 0x21, 0x68, 0x2c, 0xcd, 0xee, 0xf3, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous351 */ {
            /* {a62af1ba-79b3-4896-8aaf-b148bfce4280} */
            { 0xa62af1ba, 0x79b3, 0x4896, { 0x8a, 0xaf, 0xb1, 0x48, 0xbf, 0xce, 0x42, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous347 */ {
            /* {be9a53ae-c7e9-11d3-8cda-0060b0fc14a3} */
            { 0xbe9a53ae, 0xc7e9, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous310 */ {
            /* {c1354898-e3fe-4602-88a7-c4520c21cb4e} */
            { 0xc1354898, 0xe3fe, 0x4602, { 0x88, 0xa7, 0xc4, 0x52, 0x0c, 0x21, 0xcb, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous668 */ {
            /* {ac9e3e82-bfbd-4f26-941e-f58c8ee178c1} */
            { 0xac9e3e82, 0xbfbd, 0x4f26, { 0x94, 0x1e, 0xf5, 0x8c, 0x8e, 0xe1, 0x78, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous430 */ {
            /* {36a1d3b3-d886-4317-96ff-87b0005cfef7} */
            { 0x36a1d3b3, 0xd886, 0x4317, { 0x96, 0xff, 0x87, 0xb0, 0x00, 0x5c, 0xfe, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous669 */ {
            /* {bd066e5f-146f-4472-8331-7bfd05b1ed90} */
            { 0xbd066e5f, 0x146f, 0x4472, { 0x83, 0x31, 0x7b, 0xfd, 0x05, 0xb1, 0xed, 0x90 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous279 */ {
            /* {12f7d302-5368-412d-bdc9-26d151518e6c} */
            { 0x12f7d302, 0x5368, 0x412d, { 0xbd, 0xc9, 0x26, 0xd1, 0x51, 0x51, 0x8e, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous102 */ {
            /* {f436a174-e2c0-4955-9afe-e3feb68aee56} */
            { 0xf436a174, 0xe2c0, 0x4955, { 0x9a, 0xfe, 0xe3, 0xfe, 0xb6, 0x8a, 0xee, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous017 */ {
            /* {f41392ab-dcad-4bad-818f-b3d1631c4d93} */
            { 0xf41392ab, 0xdcad, 0x4bad, { 0x81, 0x8f, 0xb3, 0xd1, 0x63, 0x1c, 0x4d, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous390 */ {
            /* {7584ce90-5b25-11d3-a175-0050041caf44} */
            { 0x7584ce90, 0x5b25, 0x11d3, { 0xa1, 0x75, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous343 */ {
            /* {9226888e-da08-11d3-8cda-0060b0fc14a3} */
            { 0x9226888e, 0xda08, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AlertNotification */ {
            /* {9a7b7a41-0b47-47f7-b61b-15a210d6f020} */
            { 0x9a7b7a41, 0xb47, 0x47f7, { 0xb6, 0x1b, 0x15, 0xa2, 0x10, 0xd6, 0xf0, 0x20 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous046 */ {
            /* {31082ff6-1de8-422b-ab60-ca0ac0b2af13} */
            { 0x31082ff6, 0x1de8, 0x422b, { 0xab, 0x60, 0xca, 0x0a, 0xc0, 0xb2, 0xaf, 0x13 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* nsIContentAnalysis */ {
            /* {61497587-2bba-4a88-acd3-3fbb2cedf163} */
            { 0x61497587, 0x2bba, 0x4a88, { 0xac, 0xd3, 0x3f, 0xbb, 0x2c, 0xed, 0xf1, 0x63 } },
            { 0x3c44 } /* "@mozilla.org/contentanalysis;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierPrefixSet */ {
            /* {3d8579f0-75fa-4e00-ba41-38661d5b5d17} */
            { 0x3d8579f0, 0x75fa, 0x4e00, { 0xba, 0x41, 0x38, 0x66, 0x1d, 0x5b, 0x5d, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous003 */ {
            /* {b8db7c7f-c168-4e11-becb-f26c1c4f5f8f} */
            { 0xb8db7c7f, 0xc168, 0x4e11, { 0xbe, 0xcb, 0xf2, 0x6c, 0x1c, 0x4f, 0x5f, 0x8f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CookieBannerService */ {
            /* {eac9cdc4-ecee-49f2-91da-7627e15c1f3c} */
            { 0xeac9cdc4, 0xecee, 0x49f2, { 0x91, 0xda, 0x76, 0x27, 0xe1, 0x5c, 0x1f, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous134 */ {
            /* {cb998a00-c079-11d4-9daa-8df64bab2efc} */
            { 0xcb998a00, 0xc079, 0x11d4, { 0x9d, 0xaa, 0x8d, 0xf6, 0x4b, 0xab, 0x2e, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous089 */ {
            /* {2b722171-2cea-11d3-9e0b-00a0c92b5f0d} */
            { 0x2b722171, 0x2cea, 0x11d3, { 0x9e, 0x0b, 0x00, 0xa0, 0xc9, 0x2b, 0x5f, 0x0d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous673 */ {
            /* {2fc2d3e3-020f-404e-b06a-6ecf3ea2334a} */
            { 0x2fc2d3e3, 0x20f, 0x404e, { 0xb0, 0x6a, 0x6e, 0xcf, 0x3e, 0xa2, 0x33, 0x4a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous296 */ {
            /* {18c2e238-3a0a-4153-89fc-166b3b1465a1} */
            { 0x18c2e238, 0x3a0a, 0x4153, { 0x89, 0xfc, 0x16, 0x6b, 0x3b, 0x14, 0x65, 0xa1 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_AND_SOCKET_PROCESS,
          },
  
          /* Anonymous121 */ {
            /* {b3db9392-1b15-48ba-a136-0cc3db13d87b} */
            { 0xb3db9392, 0x1b15, 0x48ba, { 0xa1, 0x36, 0x0c, 0xc3, 0xdb, 0x13, 0xd8, 0x7b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous518 */ {
            /* {07f45442-1806-44be-9230-12eb79de9bac} */
            { 0x7f45442, 0x1806, 0x44be, { 0x92, 0x30, 0x12, 0xeb, 0x79, 0xde, 0x9b, 0xac } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous660 */ {
            /* {4aef38b7-6364-4e23-a5e7-12f837fbbd9c} */
            { 0x4aef38b7, 0x6364, 0x4e23, { 0xa5, 0xe7, 0x12, 0xf8, 0x37, 0xfb, 0xbd, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous496 */ {
            /* {8aa66d77-1bbb-45a6-991e-b8f47751c291} */
            { 0x8aa66d77, 0x1bbb, 0x45a6, { 0x99, 0x1e, 0xb8, 0xf4, 0x77, 0x51, 0xc2, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous235 */ {
            /* {6b13e9a8-1009-41fe-b9f4-70eb312f0d10} */
            { 0x6b13e9a8, 0x1009, 0x41fe, { 0xb9, 0xf4, 0x70, 0xeb, 0x31, 0x2f, 0x0d, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous104 */ {
            /* {8fbf6ac0-ebcc-11d2-b7fc-00805f05ffa5} */
            { 0x8fbf6ac0, 0xebcc, 0x11d2, { 0xb7, 0xfc, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous191 */ {
            /* {7aa11dd3-5590-4e01-bd87-91f60272d01a} */
            { 0x7aa11dd3, 0x5590, 0x4e01, { 0xbd, 0x87, 0x91, 0xf6, 0x02, 0x72, 0xd0, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous033 */ {
            /* {643e0328-36f6-411d-a107-16238dff9cd7} */
            { 0x643e0328, 0x36f6, 0x411d, { 0xa1, 0x07, 0x16, 0x23, 0x8d, 0xff, 0x9c, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous583 */ {
            /* {841387c8-72e6-484b-9296-bf6eea80d58a} */
            { 0x841387c8, 0x72e6, 0x484b, { 0x92, 0x96, 0xbf, 0x6e, 0xea, 0x80, 0xd5, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous578 */ {
            /* {77221d5a-1dd2-11b2-8c69-c710f15d2ed5} */
            { 0x77221d5a, 0x1dd2, 0x11b2, { 0x8c, 0x69, 0xc7, 0x10, 0xf1, 0x5d, 0x2e, 0xd5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous280 */ {
            /* {8817b1cf-5ada-43bf-bd73-607657703d0d} */
            { 0x8817b1cf, 0x5ada, 0x43bf, { 0xbd, 0x73, 0x60, 0x76, 0x57, 0x70, 0x3d, 0x0d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous491 */ {
            /* {35ec195a-e8d0-4300-83af-c8a2cc84b4a3} */
            { 0x35ec195a, 0xe8d0, 0x4300, { 0x83, 0xaf, 0xc8, 0xa2, 0xcc, 0x84, 0xb4, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous177 */ {
            /* {735959a1-af01-447e-b02d-56e968fa52b4} */
            { 0x735959a1, 0xaf01, 0x447e, { 0xb0, 0x2d, 0x56, 0xe9, 0x68, 0xfa, 0x52, 0xb4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous442 */ {
            /* {5516303d-9007-45a0-94b9-940ef134a6e2} */
            { 0x5516303d, 0x9007, 0x45a0, { 0x94, 0xb9, 0x94, 0x0e, 0xf1, 0x34, 0xa6, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous179 */ {
            /* {21a89611-dc0d-11d2-806c-006008128c4e} */
            { 0x21a89611, 0xdc0d, 0x11d2, { 0x80, 0x6c, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous182 */ {
            /* {479ce8fc-e725-11d2-a505-0060b0fc04b7} */
            { 0x479ce8fc, 0xe725, 0x11d2, { 0xa5, 0x05, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous399 */ {
            /* {50d50ddf-f16a-4652-8705-936b19c3763b} */
            { 0x50d50ddf, 0xf16a, 0x4652, { 0x87, 0x05, 0x93, 0x6b, 0x19, 0xc3, 0x76, 0x3b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous671 */ {
            /* {af7b24cb-893f-41bb-961f-5a69388e27c3} */
            { 0xaf7b24cb, 0x893f, 0x41bb, { 0x96, 0x1f, 0x5a, 0x69, 0x38, 0x8e, 0x27, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous176 */ {
            /* {a4557478-ae16-11d5-ba4b-00108303b117} */
            { 0xa4557478, 0xae16, 0x11d5, { 0xba, 0x4b, 0x00, 0x10, 0x83, 0x03, 0xb1, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* SystemInfo */ {
            /* {d962398a-99e5-49b2-857a-c159049c7f6c} */
            { 0xd962398a, 0x99e5, 0x49b2, { 0x85, 0x7a, 0xc1, 0x59, 0x04, 0x9c, 0x7f, 0x6c } },
            { 0x3c63 } /* "@mozilla.org/system-info;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous519 */ {
            /* {e7b1da06-2594-4670-aea4-131070baca4c} */
            { 0xe7b1da06, 0x2594, 0x4670, { 0xae, 0xa4, 0x13, 0x10, 0x70, 0xba, 0xca, 0x4c } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous064 */ {
            /* {bddef0f4-5e2d-4846-bdec-86d0781d8ded} */
            { 0xbddef0f4, 0x5e2d, 0x4846, { 0xbd, 0xec, 0x86, 0xd0, 0x78, 0x1d, 0x8d, 0xed } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous065 */ {
            /* {d7aad508-991c-401a-8b3f-7e4e055e1e2b} */
            { 0xd7aad508, 0x991c, 0x401a, { 0x8b, 0x3f, 0x7e, 0x4e, 0x05, 0x5e, 0x1e, 0x2b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous437 */ {
            /* {f64432b9-e8c6-41b4-b2da-8eb004344bba} */
            { 0xf64432b9, 0xe8c6, 0x41b4, { 0xb2, 0xda, 0x8e, 0xb0, 0x04, 0x34, 0x4b, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous013 */ {
            /* {29c56cd5-d36e-453a-acde-0083bd4fe6d3} */
            { 0x29c56cd5, 0xd36e, 0x453a, { 0xac, 0xde, 0x00, 0x83, 0xbd, 0x4f, 0xe6, 0xd3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* FindService */ {
            /* {5060b803-340e-11d5-be5b-b3e063ec6a3c} */
            { 0x5060b803, 0x340e, 0x11d5, { 0xbe, 0x5b, 0xb3, 0xe0, 0x63, 0xec, 0x6a, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous447 */ {
            /* {bbbb1d61-438f-4436-92ed-8308e5830fb0} */
            { 0xbbbb1d61, 0x438f, 0x4436, { 0x92, 0xed, 0x83, 0x08, 0xe5, 0x83, 0x0f, 0xb0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous638 */ {
            /* {3b55e72e-ab7e-431b-89c0-3b06a8b14016} */
            { 0x3b55e72e, 0xab7e, 0x431b, { 0x89, 0xc0, 0x3b, 0x06, 0xa8, 0xb1, 0x40, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous168 */ {
            /* {e109c05f-d304-4ca5-8c44-6de1bfaf1f74} */
            { 0xe109c05f, 0xd304, 0x4ca5, { 0x8c, 0x44, 0x6d, 0xe1, 0xbf, 0xaf, 0x1f, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous309 */ {
            /* {a6cf9115-15b3-11d2-932e-00805f8add32} */
            { 0xa6cf9115, 0x15b3, 0x11d2, { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous073 */ {
            /* {f87b71b5-2a0f-4b37-8e4f-3c899f6b8432} */
            { 0xf87b71b5, 0x2a0f, 0x4b37, { 0x8e, 0x4f, 0x3c, 0x89, 0x9f, 0x6b, 0x84, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous427 */ {
            /* {ff9fbcd7-9517-4334-b97a-ceed78909974} */
            { 0xff9fbcd7, 0x9517, 0x4334, { 0xb9, 0x7a, 0xce, 0xed, 0x78, 0x90, 0x99, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous470 */ {
            /* {e50161b0-3a69-4ec0-add9-6480850b8a98} */
            { 0xe50161b0, 0x3a69, 0x4ec0, { 0xad, 0xd9, 0x64, 0x80, 0x85, 0x0b, 0x8a, 0x98 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous648 */ {
            /* {64e4bf03-773e-408e-939a-e11652fdfd28} */
            { 0x64e4bf03, 0x773e, 0x408e, { 0x93, 0x9a, 0xe1, 0x16, 0x52, 0xfd, 0xfd, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous252 */ {
            /* {95790842-75a0-430d-98bf-f5ce3788ea6d} */
            { 0x95790842, 0x75a0, 0x430d, { 0x98, 0xbf, 0xf5, 0xce, 0x37, 0x88, 0xea, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous109 */ {
            /* {bb460dff-8bf0-11d3-8afe-0060b0fc04d2} */
            { 0xbb460dff, 0x8bf0, 0x11d3, { 0x8a, 0xfe, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xd2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous135 */ {
            /* {acc72781-2cea-11d5-9daa-bacdeac1eefc} */
            { 0xacc72781, 0x2cea, 0x11d5, { 0x9d, 0xaa, 0xba, 0xcd, 0xea, 0xc1, 0xee, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous136 */ {
            /* {1e0e7c01-3e4c-11d5-9daa-f88d288130fc} */
            { 0x1e0e7c01, 0x3e4c, 0x11d5, { 0x9d, 0xaa, 0xf8, 0x8d, 0x28, 0x81, 0x30, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous682 */ {
            /* {0ff5ce56-5b09-4db8-adc6-8266af95f864} */
            { 0xff5ce56, 0x5b09, 0x4db8, { 0xad, 0xc6, 0x82, 0x66, 0xaf, 0x95, 0xf8, 0x64 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous434 */ {
            /* {57972956-5718-42d2-8070-b3fc72212eaf} */
            { 0x57972956, 0x5718, 0x42d2, { 0x80, 0x70, 0xb3, 0xfc, 0x72, 0x21, 0x2e, 0xaf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous403 */ {
            /* {4ce234f1-52e8-47a9-8c8d-b02f815733c7} */
            { 0x4ce234f1, 0x52e8, 0x47a9, { 0x8c, 0x8d, 0xb0, 0x2f, 0x81, 0x57, 0x33, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous426 */ {
            /* {b084a2ce-1dd1-11b2-bf10-8324f8e065cc} */
            { 0xb084a2ce, 0x1dd1, 0x11b2, { 0xbf, 0x10, 0x83, 0x24, 0xf8, 0xe0, 0x65, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous677 */ {
            /* {4a6212db-accb-11d3-b765-0060b0b6cecb} */
            { 0x4a6212db, 0xaccb, 0x11d3, { 0xb7, 0x65, 0x00, 0x60, 0xb0, 0xb6, 0xce, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous069 */ {
            /* {1fa9941a-07d5-4a6f-9673-15327fc2b9ab} */
            { 0x1fa9941a, 0x7d5, 0x4a6f, { 0x96, 0x73, 0x15, 0x32, 0x7f, 0xc2, 0xb9, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous412 */ {
            /* {b4f96c89-5238-450c-8bda-e12c26f1d150} */
            { 0xb4f96c89, 0x5238, 0x450c, { 0x8b, 0xda, 0xe1, 0x2c, 0x26, 0xf1, 0xd1, 0x50 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous653 */ {
            /* {e8ee88b0-5571-4086-a45b-39a716906bdb} */
            { 0xe8ee88b0, 0x5571, 0x4086, { 0xa4, 0x5b, 0x39, 0xa7, 0x16, 0x90, 0x6b, 0xdb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous433 */ {
            /* {16786594-0296-4471-8096-8f84497ca428} */
            { 0x16786594, 0x296, 0x4471, { 0x80, 0x96, 0x8f, 0x84, 0x49, 0x7c, 0xa4, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous630 */ {
            /* {58f089ee-512a-42d2-a935-d0c874128930} */
            { 0x58f089ee, 0x512a, 0x42d2, { 0xa9, 0x35, 0xd0, 0xc8, 0x74, 0x12, 0x89, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous479 */ {
            /* {1b4c85df-cbdd-4bb6-b04e-613caece083c} */
            { 0x1b4c85df, 0xcbdd, 0x4bb6, { 0xb0, 0x4e, 0x61, 0x3c, 0xae, 0xce, 0x08, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DocLoader */ {
            /* {057b04d0-0ccf-11d2-beba-00805f8a66dc} */
            { 0x57b04d0, 0xccf, 0x11d2, { 0xbe, 0xba, 0x00, 0x80, 0x5f, 0x8a, 0x66, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous251 */ {
            /* {56ebedd4-6ccf-48e8-bdae-adc77f044567} */
            { 0x56ebedd4, 0x6ccf, 0x48e8, { 0xbd, 0xae, 0xad, 0xc7, 0x7f, 0x04, 0x45, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous208 */ {
            /* {ca5ffe7e-5f47-11d3-9a51-004005263078} */
            { 0xca5ffe7e, 0x5f47, 0x11d3, { 0x9a, 0x51, 0x00, 0x40, 0x05, 0x26, 0x30, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous349 */ {
            /* {648705e9-757a-4d4b-a5bf-0248e512c309} */
            { 0x648705e9, 0x757a, 0x4d4b, { 0xa5, 0xbf, 0x02, 0x48, 0xe5, 0x12, 0xc3, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous560 */ {
            /* {0f872c8c-3ee6-46bd-92a2-69652c6b474e} */
            { 0xf872c8c, 0x3ee6, 0x46bd, { 0x92, 0xa2, 0x69, 0x65, 0x2c, 0x6b, 0x47, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous097 */ {
            /* {49b04761-23dd-45d7-903d-619418a4d319} */
            { 0x49b04761, 0x23dd, 0x45d7, { 0x90, 0x3d, 0x61, 0x94, 0x18, 0xa4, 0xd3, 0x19 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous428 */ {
            /* {660a3226-915c-4ffb-bb20-8985a632df05} */
            { 0x660a3226, 0x915c, 0x4ffb, { 0xbb, 0x20, 0x89, 0x85, 0xa6, 0x32, 0xdf, 0x05 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous184 */ {
            /* {fa32d000-f6a0-11d2-af8d-001083002da8} */
            { 0xfa32d000, 0xf6a0, 0x11d2, { 0xaf, 0x8d, 0x00, 0x10, 0x83, 0x00, 0x2d, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous335 */ {
            /* {72ec5df0-b5af-47a7-93b7-e9495f662ab2} */
            { 0x72ec5df0, 0xb5af, 0x47a7, { 0x93, 0xb7, 0xe9, 0x49, 0x5f, 0x66, 0x2a, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous119 */ {
            /* {9f4dd201-3b1f-11d5-9daa-c345c9453d3c} */
            { 0x9f4dd201, 0x3b1f, 0x11d5, { 0x9d, 0xaa, 0xc3, 0x45, 0xc9, 0x45, 0x3d, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous435 */ {
            /* {4fe082ae-6ff0-4b41-b24f-eaa664f6e46a} */
            { 0x4fe082ae, 0x6ff0, 0x4b41, { 0xb2, 0x4f, 0xea, 0xa6, 0x64, 0xf6, 0xe4, 0x6a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DB */ {
            /* {03223c50-1e88-45e8-ba1a-7ce792dc3fc3} */
            { 0x3223c50, 0x1e88, 0x45e8, { 0xba, 0x1a, 0x7c, 0xe7, 0x92, 0xdc, 0x3f, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous544 */ {
            /* {8866d8e3-4ea5-48b7-a891-13ba0ac15235} */
            { 0x8866d8e3, 0x4ea5, 0x48b7, { 0xa8, 0x91, 0x13, 0xba, 0x0a, 0xc1, 0x52, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NSSComponent */ {
            /* {4cb64dfd-ca98-4e24-befd-0d9285a33bcb} */
            { 0x4cb64dfd, 0xca98, 0x4e24, { 0xbe, 0xfd, 0x0d, 0x92, 0x85, 0xa3, 0x3b, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* History */ {
            /* {0937a705-91a6-417a-8292-b22eb10da86c} */
            { 0x937a705, 0x91a6, 0x417a, { 0x82, 0x92, 0xb2, 0x2e, 0xb1, 0x0d, 0xa8, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous458 */ {
            /* {cdc33a1f-e8ae-4a4f-85d0-6ec633fe872c} */
            { 0xcdc33a1f, 0xe8ae, 0x4a4f, { 0x85, 0xd0, 0x6e, 0xc6, 0x33, 0xfe, 0x87, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous030 */ {
            /* {a6a524ce-adff-4a0f-bb7d-d1aaad4adc60} */
            { 0xa6a524ce, 0xadff, 0x4a0f, { 0xbb, 0x7d, 0xd1, 0xaa, 0xad, 0x4a, 0xdc, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous275 */ {
            /* {0fb47c47-a205-4583-a9fc-cbadf8c95880} */
            { 0xfb47c47, 0xa205, 0x4583, { 0xa9, 0xfc, 0xcb, 0xad, 0xf8, 0xc9, 0x58, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous377 */ {
            /* {04445aa0-fd27-4c99-bd41-6be6318ae92c} */
            { 0x4445aa0, 0xfd27, 0x4c99, { 0xbd, 0x41, 0x6b, 0xe6, 0x31, 0x8a, 0xe9, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous465 */ {
            /* {580530e5-118c-4bc7-ab88-bc2cd2b97223} */
            { 0x580530e5, 0x118c, 0x4bc7, { 0xab, 0x88, 0xbc, 0x2c, 0xd2, 0xb9, 0x72, 0x23 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous620 */ {
            /* {565e3a2c-1dd2-11b2-8da1-b4cef17e568d} */
            { 0x565e3a2c, 0x1dd2, 0x11b2, { 0x8d, 0xa1, 0xb4, 0xce, 0xf1, 0x7e, 0x56, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous542 */ {
            /* {66354bc9-7ed1-4692-ae1d-8da97d6b205e} */
            { 0x66354bc9, 0x7ed1, 0x4692, { 0xae, 0x1d, 0x8d, 0xa9, 0x7d, 0x6b, 0x20, 0x5e } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous333 */ {
            /* {430d416c-a722-4ad1-be98-d9a445f85e3f} */
            { 0x430d416c, 0xa722, 0x4ad1, { 0xbe, 0x98, 0xd9, 0xa4, 0x45, 0xf8, 0x5e, 0x3f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous391 */ {
            /* {77c0e42a-1dd2-11b2-8ebf-edc6606f2f4b} */
            { 0x77c0e42a, 0x1dd2, 0x11b2, { 0x8e, 0xbf, 0xed, 0xc6, 0x60, 0x6f, 0x2f, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous288 */ {
            /* {e031267e-bec8-4f3c-b0b1-396b77ca260c} */
            { 0xe031267e, 0xbec8, 0x4f3c, { 0xb0, 0xb1, 0x39, 0x6b, 0x77, 0xca, 0x26, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* SiteSecurity */ {
            /* {16955eee-6c48-4152-9309-c42a465138a1} */
            { 0x16955eee, 0x6c48, 0x4152, { 0x93, 0x09, 0xc4, 0x2a, 0x46, 0x51, 0x38, 0xa1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous253 */ {
            /* {c4b6fb7c-bfb1-49dc-a65f-035796524b53} */
            { 0xc4b6fb7c, 0xbfb1, 0x49dc, { 0xa6, 0x5f, 0x03, 0x57, 0x96, 0x52, 0x4b, 0x53 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PrivateAttribution */ {
            /* {57d16147-1deb-46ac-8f1c-1140b5e1ddfd} */
            { 0x57d16147, 0x1deb, 0x46ac, { 0x8f, 0x1c, 0x11, 0x40, 0xb5, 0xe1, 0xdd, 0xfd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous131 */ {
            /* {d9e45fee-1dd1-11b2-938c-9147855ed837} */
            { 0xd9e45fee, 0x1dd1, 0x11b2, { 0x93, 0x8c, 0x91, 0x47, 0x85, 0x5e, 0xd8, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous600 */ {
            /* {acf8dc4a-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4a, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous663 */ {
            /* {6030f7ef-32ed-46a7-9a63-6a5d3f90445f} */
            { 0x6030f7ef, 0x32ed, 0x46a7, { 0x9a, 0x63, 0x6a, 0x5d, 0x3f, 0x90, 0x44, 0x5f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous151 */ {
            /* {057d0997-9e3a-411e-b4ee-2602f53fe05f} */
            { 0x57d0997, 0x9e3a, 0x411e, { 0xb4, 0xee, 0x26, 0x02, 0xf5, 0x3f, 0xe0, 0x5f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous461 */ {
            /* {f66bc334-1dd1-11b2-bab2-90e04fe15c19} */
            { 0xf66bc334, 0x1dd1, 0x11b2, { 0xba, 0xb2, 0x90, 0xe0, 0x4f, 0xe1, 0x5c, 0x19 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous094 */ {
            /* {e162e335-541b-43b4-aaea-fe591e240caf} */
            { 0xe162e335, 0x541b, 0x43b4, { 0xaa, 0xea, 0xfe, 0x59, 0x1e, 0x24, 0x0c, 0xaf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous185 */ {
            /* {c358c568-47b2-42b2-8146-3c0f8d1fad6e} */
            { 0xc358c568, 0x47b2, 0x42b2, { 0x81, 0x46, 0x3c, 0x0f, 0x8d, 0x1f, 0xad, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous607 */ {
            /* {acf8dc4d-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4d, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous587 */ {
            /* {c521a612-2aad-46db-b6ab-3b821fb150b1} */
            { 0xc521a612, 0x2aad, 0x46db, { 0xb6, 0xab, 0x3b, 0x82, 0x1f, 0xb1, 0x50, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous010 */ {
            /* {8e6799af-e7e9-4e6c-9a82-a2413e86d8c3} */
            { 0x8e6799af, 0xe7e9, 0x4e6c, { 0x9a, 0x82, 0xa2, 0x41, 0x3e, 0x86, 0xd8, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous632 */ {
            /* {f4fecc26-02fe-46dc-935c-4d6f9acb18a6} */
            { 0xf4fecc26, 0x2fe, 0x46dc, { 0x93, 0x5c, 0x4d, 0x6f, 0x9a, 0xcb, 0x18, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous541 */ {
            /* {f68578eb-6ec2-4169-ae19-8c6243f0abe1} */
            { 0xf68578eb, 0x6ec2, 0x4169, { 0xae, 0x19, 0x8c, 0x62, 0x43, 0xf0, 0xab, 0xe1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous318 */ {
            /* {a8e5a8e5-bebf-4512-9f50-e41e4748ce28} */
            { 0xa8e5a8e5, 0xbebf, 0x4512, { 0x9f, 0x50, 0xe4, 0x1e, 0x47, 0x48, 0xce, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous118 */ {
            /* {ac6c518a-09b2-11d5-a5bf-0060b0fc04b7} */
            { 0xac6c518a, 0x9b2, 0x11d5, { 0xa5, 0xbf, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NSSCertificateDB */ {
            /* {fb0bbc5c-452e-4783-b32c-80124693d871} */
            { 0xfb0bbc5c, 0x452e, 0x4783, { 0xb3, 0x2c, 0x80, 0x12, 0x46, 0x93, 0xd8, 0x71 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous646 */ {
            /* {38bd0634-0fd4-46f0-b85f-13ced889eeec} */
            { 0x38bd0634, 0xfd4, 0x46f0, { 0xb8, 0x5f, 0x13, 0xce, 0xd8, 0x89, 0xee, 0xec } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous067 */ {
            /* {e96ee804-0bd3-472f-81a6-8a9d65277ad3} */
            { 0xe96ee804, 0xbd3, 0x472f, { 0x81, 0xa6, 0x8a, 0x9d, 0x65, 0x27, 0x7a, 0xd3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous303 */ {
            /* {ebe8a51d-bd54-4838-b031-cd2289990e14} */
            { 0xebe8a51d, 0xbd54, 0x4838, { 0xb0, 0x31, 0xcd, 0x22, 0x89, 0x99, 0x0e, 0x14 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous615 */ {
            /* {0d6ea1d0-879c-11d5-90ef-0010a4e73d9a} */
            { 0xd6ea1d0, 0x879c, 0x11d5, { 0x90, 0xef, 0x00, 0x10, 0xa4, 0xe7, 0x3d, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HeaderParser */ {
            /* {96bd8769-2d0e-4440-963d-22b97fb3ba77} */
            { 0x96bd8769, 0x2d0e, 0x4440, { 0x96, 0x3d, 0x22, 0xb9, 0x7f, 0xb3, 0xba, 0x77 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous077 */ {
            /* {dbe204e8-ae09-11eb-b4c8-a7e4b3e6e82e} */
            { 0xdbe204e8, 0xae09, 0x11eb, { 0xb4, 0xc8, 0xa7, 0xe4, 0xb3, 0xe6, 0xe8, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous555 */ {
            /* {25db9b8e-8123-4de1-b66d-8bbbedf2cdf4} */
            { 0x25db9b8e, 0x8123, 0x4de1, { 0xb6, 0x6d, 0x8b, 0xbb, 0xed, 0xf2, 0xcd, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous398 */ {
            /* {dea9657c-18cf-4984-bde9-ccef5d8ab473} */
            { 0xdea9657c, 0x18cf, 0x4984, { 0xbd, 0xe9, 0xcc, 0xef, 0x5d, 0x8a, 0xb4, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous266 */ {
            /* {9fea635a-2fc2-4d08-9721-d238d3f52f92} */
            { 0x9fea635a, 0x2fc2, 0x4d08, { 0x97, 0x21, 0xd2, 0x38, 0xd3, 0xf5, 0x2f, 0x92 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous364 */ {
            /* {aea16cd0-f020-4138-b068-0716c4a15b5a} */
            { 0xaea16cd0, 0xf020, 0x4138, { 0xb0, 0x68, 0x07, 0x16, 0xc4, 0xa1, 0x5b, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous227 */ {
            /* {4cae5569-2c72-4910-9f3d-774f9e939df8} */
            { 0x4cae5569, 0x2c72, 0x4910, { 0x9f, 0x3d, 0x77, 0x4f, 0x9e, 0x93, 0x9d, 0xf8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous540 */ {
            /* {6f46b6f4-c8b1-4bd4-a4fa-9ebbed0753ea} */
            { 0x6f46b6f4, 0xc8b1, 0x4bd4, { 0xa4, 0xfa, 0x9e, 0xbb, 0xed, 0x07, 0x53, 0xea } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous098 */ {
            /* {26ebf3a7-3e52-4b7a-a89b-fa7c0b7506f9} */
            { 0x26ebf3a7, 0x3e52, 0x4b7a, { 0xa8, 0x9b, 0xfa, 0x7c, 0x0b, 0x75, 0x06, 0xf9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous678 */ {
            /* {caaab47f-1e31-478e-8919-970904e9cb72} */
            { 0xcaaab47f, 0x1e31, 0x478e, { 0x89, 0x19, 0x97, 0x09, 0x04, 0xe9, 0xcb, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous405 */ {
            /* {82b09188-8809-44c5-b41e-d8b85b8c2743} */
            { 0x82b09188, 0x8809, 0x44c5, { 0xb4, 0x1e, 0xd8, 0xb8, 0x5b, 0x8c, 0x27, 0x43 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* ThirdPartyUtil */ {
            /* {08c6cc8b-cfb0-421d-b1f7-683ff2989681} */
            { 0x8c6cc8b, 0xcfb0, 0x421d, { 0xb1, 0xf7, 0x68, 0x3f, 0xf2, 0x98, 0x96, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous441 */ {
            /* {d7d2490d-2640-411b-9f09-a538803c11ee} */
            { 0xd7d2490d, 0x2640, 0x411b, { 0x9f, 0x09, 0xa5, 0x38, 0x80, 0x3c, 0x11, 0xee } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous242 */ {
            /* {1510faee-ad1a-4194-8039-33de32d5a882} */
            { 0x1510faee, 0xad1a, 0x4194, { 0x80, 0x39, 0x33, 0xde, 0x32, 0xd5, 0xa8, 0x82 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous636 */ {
            /* {fc886801-e768-11d4-9885-00c04fa0cf4b} */
            { 0xfc886801, 0xe768, 0x11d4, { 0x98, 0x85, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous197 */ {
            /* {1e8f21c3-32c3-4114-9ea4-3d74006fb351} */
            { 0x1e8f21c3, 0x32c3, 0x4114, { 0x9e, 0xa4, 0x3d, 0x74, 0x00, 0x6f, 0xb3, 0x51 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous345 */ {
            /* {4ffae79e-57bd-4d7a-a0c9-0045a17b3615} */
            { 0x4ffae79e, 0x57bd, 0x4d7a, { 0xa0, 0xc9, 0x00, 0x45, 0xa1, 0x7b, 0x36, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous483 */ {
            /* {acb22042-2b6c-427b-b550-b9f407c6fff6} */
            { 0xacb22042, 0x2b6c, 0x427b, { 0xb5, 0x50, 0xb9, 0xf4, 0x07, 0xc6, 0xff, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous154 */ {
            /* {3bbe4d77-3f70-4252-9500-bc00c26f476d} */
            { 0x3bbe4d77, 0x3f70, 0x4252, { 0x95, 0x00, 0xbc, 0x00, 0xc2, 0x6f, 0x47, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous319 */ {
            /* {d0f9db12-249c-11d5-9905-001083010e9b} */
            { 0xd0f9db12, 0x249c, 0x11d5, { 0x99, 0x05, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous355 */ {
            /* {e1c61582-2a84-11d3-8cce-0060b0fc14a3} */
            { 0xe1c61582, 0x2a84, 0x11d3, { 0x8c, 0xce, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous120 */ {
            /* {ce6038ae-e5e0-4372-9cff-2a6633333b2b} */
            { 0xce6038ae, 0xe5e0, 0x4372, { 0x9c, 0xff, 0x2a, 0x66, 0x33, 0x33, 0x3b, 0x2b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous337 */ {
            /* {62d4b190-3642-4450-b019-d1c1fba56025} */
            { 0x62d4b190, 0x3642, 0x4450, { 0xb0, 0x19, 0xd1, 0xc1, 0xfb, 0xa5, 0x60, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous314 */ {
            /* {13a5320c-4c91-4fa4-bd16-b081a3ba8c0b} */
            { 0x13a5320c, 0x4c91, 0x4fa4, { 0xbd, 0x16, 0xb0, 0x81, 0xa3, 0xba, 0x8c, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Filter */ {
            /* {5cbb0700-04bc-11d3-a50a-0060b0fc04b7} */
            { 0x5cbb0700, 0x4bc, 0x11d3, { 0xa5, 0x0a, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous523 */ {
            /* {23530265-31d1-4ee9-864c-c081975fb7bc} */
            { 0x23530265, 0x31d1, 0x4ee9, { 0x86, 0x4c, 0xc0, 0x81, 0x97, 0x5f, 0xb7, 0xbc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous329 */ {
            /* {245abae2-b947-4ded-a46d-9829d3cca462} */
            { 0x245abae2, 0xb947, 0x4ded, { 0xa4, 0x6d, 0x98, 0x29, 0xd3, 0xcc, 0xa4, 0x62 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* SocketTransport */ {
            /* {ad56b25f-e6bb-4db3-9f7b-5b7db33fd2b1} */
            { 0xad56b25f, 0xe6bb, 0x4db3, { 0x9f, 0x7b, 0x5b, 0x7d, 0xb3, 0x3f, 0xd2, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous196 */ {
            /* {f99fdbf7-2e79-4ce3-9d94-7af3763b82fc} */
            { 0xf99fdbf7, 0x2e79, 0x4ce3, { 0x9d, 0x94, 0x7a, 0xf3, 0x76, 0x3b, 0x82, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PageThumbsStorage */ {
            /* {97943eec-0e48-49ef-b7b7-cf4aa0109bb6} */
            { 0x97943eec, 0xe48, 0x49ef, { 0xb7, 0xb7, 0xcf, 0x4a, 0xa0, 0x10, 0x9b, 0xb6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous269 */ {
            /* {d1748d4c-7f6a-4dc5-add6-d55b7678537e} */
            { 0xd1748d4c, 0x7f6a, 0x4dc5, { 0xad, 0xd6, 0xd5, 0x5b, 0x76, 0x78, 0x53, 0x7e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous112 */ {
            /* {ca79a00e-010d-11d5-a5be-0060b0fc04b7} */
            { 0xca79a00e, 0x10d, 0x11d5, { 0xa5, 0xbe, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous124 */ {
            /* {03f9bb53-a680-4349-8de9-d26864d9ffd9} */
            { 0x3f9bb53, 0xa680, 0x4349, { 0x8d, 0xe9, 0xd2, 0x68, 0x64, 0xd9, 0xff, 0xd9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous652 */ {
            /* {baa34652-f1f1-4185-b224-244ee82a413a} */
            { 0xbaa34652, 0xf1f1, 0x4185, { 0xb2, 0x24, 0x24, 0x4e, 0xe8, 0x2a, 0x41, 0x3a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous408 */ {
            /* {72da39cc-0b9b-4fff-8ff9-d3b9a41d0dc4} */
            { 0x72da39cc, 0xb9b, 0x4fff, { 0x8f, 0xf9, 0xd3, 0xb9, 0xa4, 0x1d, 0x0d, 0xc4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous576 */ {
            /* {e221df9b-3d66-4045-9a66-5720949f8d10} */
            { 0xe221df9b, 0x3d66, 0x4045, { 0x9a, 0x66, 0x57, 0x20, 0x94, 0x9f, 0x8d, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous088 */ {
            /* {cb7c67f8-0053-4072-89e9-501cbd1b35ab} */
            { 0xcb7c67f8, 0x53, 0x4072, { 0x89, 0xe9, 0x50, 0x1c, 0xbd, 0x1b, 0x35, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous616 */ {
            /* {c6e47036-ca94-4be3-963a-9abd8705f7a8} */
            { 0xc6e47036, 0xca94, 0x4be3, { 0x96, 0x3a, 0x9a, 0xbd, 0x87, 0x05, 0xf7, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous259 */ {
            /* {2dc08eaf-6eef-4394-b1df-a3a927c1290b} */
            { 0x2dc08eaf, 0x6eef, 0x4394, { 0xb1, 0xdf, 0xa3, 0xa9, 0x27, 0xc1, 0x29, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous383 */ {
            /* {c9f74572-7b8e-4fec-bb4a-03c0d3021bd6} */
            { 0xc9f74572, 0x7b8e, 0x4fec, { 0xbb, 0x4a, 0x03, 0xc0, 0xd3, 0x02, 0x1b, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous273 */ {
            /* {7293e901-2be3-4c02-b4bd-cbef6fc24f78} */
            { 0x7293e901, 0x2be3, 0x4c02, { 0xb4, 0xbd, 0xcb, 0xef, 0x6f, 0xc2, 0x4f, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous680 */ {
            /* {abfbb785-5a44-49cf-88db-2f300bf727c9} */
            { 0xabfbb785, 0x5a44, 0x49cf, { 0x88, 0xdb, 0x2f, 0x30, 0x0b, 0xf7, 0x27, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous301 */ {
            /* {7ec4bc82-5022-4d32-8e98-ffbceadb692c} */
            { 0x7ec4bc82, 0x5022, 0x4d32, { 0x8e, 0x98, 0xff, 0xbc, 0xea, 0xdb, 0x69, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous564 */ {
            /* {bd57cee8-1dd1-11b2-9fe7-95cf4709aea3} */
            { 0xbd57cee8, 0x1dd1, 0x11b2, { 0x9f, 0xe7, 0x95, 0xcf, 0x47, 0x09, 0xae, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous254 */ {
            /* {bc0017e3-2438-47be-a567-41db58f17627} */
            { 0xbc0017e3, 0x2438, 0x47be, { 0xa5, 0x67, 0x41, 0xdb, 0x58, 0xf1, 0x76, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous466 */ {
            /* {2e59cc70-f83a-412f-89d4-453885837217} */
            { 0x2e59cc70, 0xf83a, 0x412f, { 0x89, 0xd4, 0x45, 0x38, 0x85, 0x83, 0x72, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous552 */ {
            /* {5573967d-f6cf-4c63-8e0e-9ac06e04d62b} */
            { 0x5573967d, 0xf6cf, 0x4c63, { 0x8e, 0x0e, 0x9a, 0xc0, 0x6e, 0x04, 0xd6, 0x2b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous451 */ {
            /* {5874af6d-5719-4e1b-b155-ef4eae7fcb32} */
            { 0x5874af6d, 0x5719, 0x4e1b, { 0xb1, 0x55, 0xef, 0x4e, 0xae, 0x7f, 0xcb, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* DBView */ {
            /* {bcf6afbe-7d4f-11ec-9092-eb4fed0a5aaa} */
            { 0xbcf6afbe, 0x7d4f, 0x11ec, { 0x90, 0x92, 0xeb, 0x4f, 0xed, 0x0a, 0x5a, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous656 */ {
            /* {01e1c3ff-094a-d048-44b4-62d29c7b4f39} */
            { 0x1e1c3ff, 0x94a, 0xd048, { 0x44, 0xb4, 0x62, 0xd2, 0x9c, 0x7b, 0x4f, 0x39 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous248 */ {
            /* {1060afaf-dc9e-43da-8646-23a2faf48493} */
            { 0x1060afaf, 0xdc9e, 0x43da, { 0x86, 0x46, 0x23, 0xa2, 0xfa, 0xf4, 0x84, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous385 */ {
            /* {78804a84-8173-42b6-bb94-789f0816a810} */
            { 0x78804a84, 0x8173, 0x42b6, { 0xbb, 0x94, 0x78, 0x9f, 0x08, 0x16, 0xa8, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous111 */ {
            /* {52f860e0-1dd2-11b2-aa72-bb751981bd00} */
            { 0x52f860e0, 0x1dd2, 0x11b2, { 0xaa, 0x72, 0xbb, 0x75, 0x19, 0x81, 0xbd, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous187 */ {
            /* {a6629718-9a97-4073-ab48-442fcceaea5d} */
            { 0xa6629718, 0x9a97, 0x4073, { 0xab, 0x48, 0x44, 0x2f, 0xcc, 0xea, 0xea, 0x5d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous580 */ {
            /* {6987230e-0098-4e78-bc5f-1493ee7519fa} */
            { 0x6987230e, 0x98, 0x4e78, { 0xbc, 0x5f, 0x14, 0x93, 0xee, 0x75, 0x19, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous139 */ {
            /* {9e16958d-d9e9-4cae-b723-a5bccf104998} */
            { 0x9e16958d, 0xd9e9, 0x4cae, { 0xb7, 0x23, 0xa5, 0xbc, 0xcf, 0x10, 0x49, 0x98 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous353 */ {
            /* {6ddb050c-0d04-11d4-986e-00c04fa0cf4a} */
            { 0x6ddb050c, 0xd04, 0x11d4, { 0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous060 */ {
            /* {13118758-dad2-418c-a03d-1acbfed0cd01} */
            { 0x13118758, 0xdad2, 0x418c, { 0xa0, 0x3d, 0x1a, 0xcb, 0xfe, 0xd0, 0xcd, 0x01 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous534 */ {
            /* {ca168834-cc00-48f9-b83c-fd018e58cae3} */
            { 0xca168834, 0xcc00, 0x48f9, { 0xb8, 0x3c, 0xfd, 0x01, 0x8e, 0x58, 0xca, 0xe3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous473 */ {
            /* {e3f772f3-023f-4b32-b074-36cf0fd5d414} */
            { 0xe3f772f3, 0x23f, 0x4b32, { 0xb0, 0x74, 0x36, 0xcf, 0x0f, 0xd5, 0xd4, 0x14 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous499 */ {
            /* {c47ff942-9678-44a5-bc9b-05e0d676c79c} */
            { 0xc47ff942, 0x9678, 0x44a5, { 0xbc, 0x9b, 0x05, 0xe0, 0xd6, 0x76, 0xc7, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous621 */ {
            /* {e4a0ee4e-0775-457b-9118-b3ae97a7c758} */
            { 0xe4a0ee4e, 0x775, 0x457b, { 0x91, 0x18, 0xb3, 0xae, 0x97, 0xa7, 0xc7, 0x58 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous476 */ {
            /* {56197e18-d144-45b5-9f77-84102f064462} */
            { 0x56197e18, 0xd144, 0x45b5, { 0x9f, 0x77, 0x84, 0x10, 0x2f, 0x06, 0x44, 0x62 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous099 */ {
            /* {b63d8e4c-bf60-439b-be0e-7c9f67291042} */
            { 0xb63d8e4c, 0xbf60, 0x439b, { 0xbe, 0x0e, 0x7c, 0x9f, 0x67, 0x29, 0x10, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous346 */ {
            /* {510a86bb-6019-4ed1-bb4f-965cffd23ece} */
            { 0x510a86bb, 0x6019, 0x4ed1, { 0xbb, 0x4f, 0x96, 0x5c, 0xff, 0xd2, 0x3e, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous559 */ {
            /* {c0ed2a75-96f8-4166-91d4-2fe8774448dc} */
            { 0xc0ed2a75, 0x96f8, 0x4166, { 0x91, 0xd4, 0x2f, 0xe8, 0x77, 0x44, 0x48, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous539 */ {
            /* {742ad274-34c5-43d1-a8b7-293eaf8962d6} */
            { 0x742ad274, 0x34c5, 0x43d1, { 0xa8, 0xb7, 0x29, 0x3e, 0xaf, 0x89, 0x62, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous201 */ {
            /* {3fdae3ab-4ac1-4ad4-b28a-28d0fa363929} */
            { 0x3fdae3ab, 0x4ac1, 0x4ad4, { 0xb2, 0x8a, 0x28, 0xd0, 0xfa, 0x36, 0x39, 0x29 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* FolderNotification */ {
            /* {f1f7cbcd-d5e3-45a0-aa2d-cecf1a95ab03} */
            { 0xf1f7cbcd, 0xd5e3, 0x45a0, { 0xaa, 0x2d, 0xce, 0xcf, 0x1a, 0x95, 0xab, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous008 */ {
            /* {f42585e7-e736-4600-985d-9624c1c51992} */
            { 0xf42585e7, 0xe736, 0x4600, { 0x98, 0x5d, 0x96, 0x24, 0xc1, 0xc5, 0x19, 0x92 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous647 */ {
            /* {656db07c-aa80-49e4-bce8-e431baae697d} */
            { 0x656db07c, 0xaa80, 0x49e4, { 0xbc, 0xe8, 0xe4, 0x31, 0xba, 0xae, 0x69, 0x7d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous568 */ {
            /* {2d96b3df-c051-11d1-a827-0040959a28c9} */
            { 0x2d96b3df, 0xc051, 0x11d1, { 0xa8, 0x27, 0x00, 0x40, 0x95, 0x9a, 0x28, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* DNS */ {
            /* {b0ff4572-dae4-4bef-a092-83c1b88f6be9} */
            { 0xb0ff4572, 0xdae4, 0x4bef, { 0xa0, 0x92, 0x83, 0xc1, 0xb8, 0x8f, 0x6b, 0xe9 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous305 */ {
            /* {a4b1b3b1-b68a-4129-aa2f-eb086162a8c7} */
            { 0xa4b1b3b1, 0xb68a, 0x4129, { 0xaa, 0x2f, 0xeb, 0x08, 0x61, 0x62, 0xa8, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* CacheStorage */ {
            /* {ea70b098-5014-4e21-aee1-75e6b2c4b8e0} */
            { 0xea70b098, 0x5014, 0x4e21, { 0xae, 0xe1, 0x75, 0xe6, 0xb2, 0xc4, 0xb8, 0xe0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous546 */ {
            /* {e35d5067-95bc-4029-8432-e8f1e431148d} */
            { 0xe35d5067, 0x95bc, 0x4029, { 0x84, 0x32, 0xe8, 0xf1, 0xe4, 0x31, 0x14, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous531 */ {
            /* {b322a5c0-a419-484e-96ba-d7182163899f} */
            { 0xb322a5c0, 0xa419, 0x484e, { 0x96, 0xba, 0xd7, 0x18, 0x21, 0x63, 0x89, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Alerts */ {
            /* {a0ccaaf8-09da-44d8-b250-9ac3e93c8117} */
            { 0xa0ccaaf8, 0x9da, 0x44d8, { 0xb2, 0x50, 0x9a, 0xc3, 0xe9, 0x3c, 0x81, 0x17 } },
            { 0x3c7e } /* "@mozilla.org/alerts-service;1" */,
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* EffectiveTLD */ {
            /* {cb9abbae-66b6-4609-8594-5c4ff300888e} */
            { 0xcb9abbae, 0x66b6, 0x4609, { 0x85, 0x94, 0x5c, 0x4f, 0xf3, 0x00, 0x88, 0x8e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous547 */ {
            /* {e3a1f3c9-3ae1-4b40-a5e0-7b457fc9a9ad} */
            { 0xe3a1f3c9, 0x3ae1, 0x4b40, { 0xa5, 0xe0, 0x7b, 0x45, 0x7f, 0xc9, 0xa9, 0xad } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous588 */ {
            /* {86c37b9a-74e7-4672-844e-6e7dd83ba484} */
            { 0x86c37b9a, 0x74e7, 0x4672, { 0x84, 0x4e, 0x6e, 0x7d, 0xd8, 0x3b, 0xa4, 0x84 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous050 */ {
            /* {87aaeb20-89d9-4b95-9542-3bf72405cab2} */
            { 0x87aaeb20, 0x89d9, 0x4b95, { 0x95, 0x42, 0x3b, 0xf7, 0x24, 0x05, 0xca, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous166 */ {
            /* {ec917b13-8f73-4d4d-9146-d7f7aafe9076} */
            { 0xec917b13, 0x8f73, 0x4d4d, { 0x91, 0x46, 0xd7, 0xf7, 0xaa, 0xfe, 0x90, 0x76 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous457 */ {
            /* {2ee3039b-2de4-43d9-93b0-649beacff39a} */
            { 0x2ee3039b, 0x2de4, 0x43d9, { 0x93, 0xb0, 0x64, 0x9b, 0xea, 0xcf, 0xf3, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous322 */ {
            /* {2bc2ad62-ad5d-4b7b-a9db-f74ae203c527} */
            { 0x2bc2ad62, 0xad5d, 0x4b7b, { 0xa9, 0xdb, 0xf7, 0x4a, 0xe2, 0x03, 0xc5, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous015 */ {
            /* {207a6682-8ff1-4203-9160-729ec28c8766} */
            { 0x207a6682, 0x8ff1, 0x4203, { 0x91, 0x60, 0x72, 0x9e, 0xc2, 0x8c, 0x87, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous006 */ {
            /* {5f76b352-ab75-4c2b-82c9-9206dbbf8571} */
            { 0x5f76b352, 0xab75, 0x4c2b, { 0x82, 0xc9, 0x92, 0x06, 0xdb, 0xbf, 0x85, 0x71 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous203 */ {
            /* {ea1b0a11-e6f4-11d2-8070-006008128c4e} */
            { 0xea1b0a11, 0xe6f4, 0x11d2, { 0x80, 0x70, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous289 */ {
            /* {b986773e-2b30-4ed2-b8fe-6a96631c8000} */
            { 0xb986773e, 0x2b30, 0x4ed2, { 0xb8, 0xfe, 0x6a, 0x96, 0x63, 0x1c, 0x80, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous401 */ {
            /* {c375fa80-150f-11d6-a618-0010a401eb10} */
            { 0xc375fa80, 0x150f, 0x11d6, { 0xa6, 0x18, 0x00, 0x10, 0xa4, 0x01, 0xeb, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous093 */ {
            /* {2c2e75c8-6f56-4a50-af1c-72af5d0e8d41} */
            { 0x2c2e75c8, 0x6f56, 0x4a50, { 0xaf, 0x1c, 0x72, 0xaf, 0x5d, 0x0e, 0x8d, 0x41 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous487 */ {
            /* {a9b28d1f-7e11-4c5f-85a0-4fd39db1f7c9} */
            { 0xa9b28d1f, 0x7e11, 0x4c5f, { 0x85, 0xa0, 0x4f, 0xd3, 0x9d, 0xb1, 0xf7, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous018 */ {
            /* {394a281f-7299-45f7-8b1f-cce21258972f} */
            { 0x394a281f, 0x7299, 0x45f7, { 0x8b, 0x1f, 0xcc, 0xe2, 0x12, 0x58, 0x97, 0x2f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous644 */ {
            /* {1147d32c-215b-4014-b180-07fe7aedf915} */
            { 0x1147d32c, 0x215b, 0x4014, { 0xb1, 0x80, 0x07, 0xfe, 0x7a, 0xed, 0xf9, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous137 */ {
            /* {e64b0f51-0d7b-4e2f-8c60-3862ee8c174f} */
            { 0xe64b0f51, 0xd7b, 0x4e2f, { 0x8c, 0x60, 0x38, 0x62, 0xee, 0x8c, 0x17, 0x4f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous528 */ {
            /* {efc1415c-5708-41cc-8226-82bf1d3bee16} */
            { 0xefc1415c, 0x5708, 0x41cc, { 0x82, 0x26, 0x82, 0xbf, 0x1d, 0x3b, 0xee, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* ContentSecurityManager */ {
            /* {cdcc1ab8-3cea-4e6c-a294-a651fa35227f} */
            { 0xcdcc1ab8, 0x3cea, 0x4e6c, { 0xa2, 0x94, 0xa6, 0x51, 0xfa, 0x35, 0x22, 0x7f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous225 */ {
            /* {b13db263-a219-4168-aeaf-8266f001087e} */
            { 0xb13db263, 0xa219, 0x4168, { 0xae, 0xaf, 0x82, 0x66, 0xf0, 0x01, 0x08, 0x7e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous640 */ {
            /* {8d2f40b2-4875-4c95-97d9-3f7dca2cb460} */
            { 0x8d2f40b2, 0x4875, 0x4c95, { 0x97, 0xd9, 0x3f, 0x7d, 0xca, 0x2c, 0xb4, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous627 */ {
            /* {0099907d-123c-4853-a46a-43098b5fb68c} */
            { 0x99907d, 0x123c, 0x4853, { 0xa4, 0x6a, 0x43, 0x09, 0x8b, 0x5f, 0xb6, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous456 */ {
            /* {f6d5ebbd-34f4-487d-9d10-3d34123e3eb9} */
            { 0xf6d5ebbd, 0x34f4, 0x487d, { 0x9d, 0x10, 0x3d, 0x34, 0x12, 0x3e, 0x3e, 0xb9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous510 */ {
            /* {60a1f7c6-4ff9-4a42-84d3-5a185faa6f32} */
            { 0x60a1f7c6, 0x4ff9, 0x4a42, { 0x84, 0xd3, 0x5a, 0x18, 0x5f, 0xaa, 0x6f, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous106 */ {
            /* {a687b474-afd8-418f-8ad9-f362202ae9a9} */
            { 0xa687b474, 0xafd8, 0x418f, { 0x8a, 0xd9, 0xf3, 0x62, 0x20, 0x2a, 0xe9, 0xa9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* MimeConverter */ {
            /* {93f8c049-80ed-4dda-9000-94ad8daba44c} */
            { 0x93f8c049, 0x80ed, 0x4dda, { 0x90, 0x00, 0x94, 0xad, 0x8d, 0xab, 0xa4, 0x4c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous597 */ {
            /* {43ebf210-8a7b-4ddb-a83d-b87c51a058db} */
            { 0x43ebf210, 0x8a7b, 0x4ddb, { 0xa8, 0x3d, 0xb8, 0x7c, 0x51, 0xa0, 0x58, 0xdb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous416 */ {
            /* {067cb318-9b67-4442-9c1c-93e62dac8a7c} */
            { 0x67cb318, 0x9b67, 0x4442, { 0x9c, 0x1c, 0x93, 0xe6, 0x2d, 0xac, 0x8a, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous138 */ {
            /* {27b8d045-8d9f-4fa8-bfb6-8a0f8d09ce89} */
            { 0x27b8d045, 0x8d9f, 0x4fa8, { 0xbf, 0xb6, 0x8a, 0x0f, 0x8d, 0x09, 0xce, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* WifiMonitor */ {
            /* {3ff8fb9f-ee63-48df-89f0-dace0242fd82} */
            { 0x3ff8fb9f, 0xee63, 0x48df, { 0x89, 0xf0, 0xda, 0xce, 0x02, 0x42, 0xfd, 0x82 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous290 */ {
            /* {8c72bcdb-0c37-4786-a9e5-510afa2f8ede} */
            { 0x8c72bcdb, 0xc37, 0x4786, { 0xa9, 0xe5, 0x51, 0x0a, 0xfa, 0x2f, 0x8e, 0xde } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous231 */ {
            /* {4ace448a-f6d4-11d2-880d-004005263078} */
            { 0x4ace448a, 0xf6d4, 0x11d2, { 0x88, 0x0d, 0x00, 0x40, 0x05, 0x26, 0x30, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous341 */ {
            /* {208de7fc-a781-4031-bbae-cc0de539f61a} */
            { 0x208de7fc, 0xa781, 0x4031, { 0xbb, 0xae, 0xcc, 0x0d, 0xe5, 0x39, 0xf6, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous340 */ {
            /* {62147d1e-ef6a-40e8-aaf8-d039f5caaa81} */
            { 0x62147d1e, 0xef6a, 0x40e8, { 0xaa, 0xf8, 0xd0, 0x39, 0xf5, 0xca, 0xaa, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous125 */ {
            /* {6ef7eafd-72d0-4c56-9409-67e16d0f255b} */
            { 0x6ef7eafd, 0x72d0, 0x4c56, { 0x94, 0x09, 0x67, 0xe1, 0x6d, 0x0f, 0x25, 0x5b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous147 */ {
            /* {0874c3b5-317d-11d3-8efb-00a024a7d144} */
            { 0x874c3b5, 0x317d, 0x11d3, { 0x8e, 0xfb, 0x00, 0xa0, 0x24, 0xa7, 0xd1, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous243 */ {
            /* {4148c488-dca1-49fc-a621-2a0097a62422} */
            { 0x4148c488, 0xdca1, 0x49fc, { 0xa6, 0x21, 0x2a, 0x00, 0x97, 0xa6, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous361 */ {
            /* {9e3b6c90-2f75-11d3-8cd0-0060b0fc14a3} */
            { 0x9e3b6c90, 0x2f75, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous212 */ {
            /* {212f415f-f8b5-11d2-ffe0-00af19a7d144} */
            { 0x212f415f, 0xf8b5, 0x11d2, { 0xff, 0xe0, 0x00, 0xaf, 0x19, 0xa7, 0xd1, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous613 */ {
            /* {acf8dc42-4a25-11d3-9890-006008962422} */
            { 0xacf8dc42, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous141 */ {
            /* {e15c83f1-1cf4-11d3-8ef0-00a024a7d144} */
            { 0xe15c83f1, 0x1cf4, 0x11d3, { 0x8e, 0xf0, 0x00, 0xa0, 0x24, 0xa7, 0xd1, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous454 */ {
            /* {42906796-d16a-44a1-b518-0f108ab38eba} */
            { 0x42906796, 0xd16a, 0x44a1, { 0xb5, 0x18, 0x0f, 0x10, 0x8a, 0xb3, 0x8e, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous283 */ {
            /* {37f819b0-0b5c-11e3-8ffd-0800200c9a66} */
            { 0x37f819b0, 0xb5c, 0x11e3, { 0x8f, 0xfd, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous230 */ {
            /* {196b4b30-e18c-11d2-806e-006008128c4e} */
            { 0x196b4b30, 0xe18c, 0x11d2, { 0x80, 0x6e, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous044 */ {
            /* {e9653ac6-a671-11e6-bf84-60a44c717042} */
            { 0xe9653ac6, 0xa671, 0x11e6, { 0xbf, 0x84, 0x60, 0xa4, 0x4c, 0x71, 0x70, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous295 */ {
            /* {184385cb-2d35-4b99-a9a3-7c780bf66b9b} */
            { 0x184385cb, 0x2d35, 0x4b99, { 0xa9, 0xa3, 0x7c, 0x78, 0x0b, 0xf6, 0x6b, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URLQueryStringStripper */ {
            /* {6b42a890-2624-4560-99c4-b25380e8cd77} */
            { 0x6b42a890, 0x2624, 0x4560, { 0x99, 0xc4, 0xb2, 0x53, 0x80, 0xe8, 0xcd, 0x77 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous452 */ {
            /* {90d1fd17-2018-4e16-b73c-a04a26fa6dd4} */
            { 0x90d1fd17, 0x2018, 0x4e16, { 0xb7, 0x3c, 0xa0, 0x4a, 0x26, 0xfa, 0x6d, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous055 */ {
            /* {eb239c82-fac9-431e-98d7-11cacd0f71b8} */
            { 0xeb239c82, 0xfac9, 0x431e, { 0x98, 0xd7, 0x11, 0xca, 0xcd, 0x0f, 0x71, 0xb8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous475 */ {
            /* {1d8d9470-97d3-4885-a108-44a5c4fb36e2} */
            { 0x1d8d9470, 0x97d3, 0x4885, { 0xa1, 0x08, 0x44, 0xa5, 0xc4, 0xfb, 0x36, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous126 */ {
            /* {de0f34a9-a87f-4f4c-b978-6187db187b90} */
            { 0xde0f34a9, 0xa87f, 0x4f4c, { 0xb9, 0x78, 0x61, 0x87, 0xdb, 0x18, 0x7b, 0x90 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous371 */ {
            /* {dc01dbbb-a5bb-4cbb-82bb-085cce06c0bb} */
            { 0xdc01dbbb, 0xa5bb, 0x4cbb, { 0x82, 0xbb, 0x08, 0x5c, 0xce, 0x06, 0xc0, 0xbb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous011 */ {
            /* {7436f480-c6fc-4085-9655-330b1ee22288} */
            { 0x7436f480, 0xc6fc, 0x4085, { 0x96, 0x55, 0x33, 0x0b, 0x1e, 0xe2, 0x22, 0x88 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous494 */ {
            /* {749e62f4-60ae-4569-a8a2-de78b649660e} */
            { 0x749e62f4, 0x60ae, 0x4569, { 0xa8, 0xa2, 0xde, 0x78, 0xb6, 0x49, 0x66, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous117 */ {
            /* {e4603d6c-0a74-47c5-b69e-2f8876990304} */
            { 0xe4603d6c, 0xa74, 0x47c5, { 0xb6, 0x9e, 0x2f, 0x88, 0x76, 0x99, 0x03, 0x04 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous400 */ {
            /* {e0da1d70-2f7b-11d3-8cd0-0060b0fc14a3} */
            { 0xe0da1d70, 0x2f7b, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous249 */ {
            /* {11342911-3135-45a8-8d71-737a2b0ad469} */
            { 0x11342911, 0x3135, 0x45a8, { 0x8d, 0x71, 0x73, 0x7a, 0x2b, 0x0a, 0xd4, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous507 */ {
            /* {1dcc23b0-d4cb-11dc-9ad6-479d56d89593} */
            { 0x1dcc23b0, 0xd4cb, 0x11dc, { 0x9a, 0xd6, 0x47, 0x9d, 0x56, 0xd8, 0x95, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HttpActivityDistributor */ {
            /* {15629ada-a41c-4a09-961f-6553cd60b1a2} */
            { 0x15629ada, 0xa41c, 0x4a09, { 0x96, 0x1f, 0x65, 0x53, 0xcd, 0x60, 0xb1, 0xa2 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous365 */ {
            /* {450a2b55-620a-44b3-9f67-839b3b0c329c} */
            { 0x450a2b55, 0x620a, 0x44b3, { 0x9f, 0x67, 0x83, 0x9b, 0x3b, 0x0c, 0x32, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous066 */ {
            /* {7514cbeb-2bfd-4b2c-829b-1a4691fa0ac8} */
            { 0x7514cbeb, 0x2bfd, 0x4b2c, { 0x82, 0x9b, 0x1a, 0x46, 0x91, 0xfa, 0x0a, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous464 */ {
            /* {6356aa16-7916-4215-a825-cbc2692ca87a} */
            { 0x6356aa16, 0x7916, 0x4215, { 0xa8, 0x25, 0xcb, 0xc2, 0x69, 0x2c, 0xa8, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous058 */ {
            /* {b3c78baf-3a52-41d2-9718-c319bef9affc} */
            { 0xb3c78baf, 0x3a52, 0x41d2, { 0x97, 0x18, 0xc3, 0x19, 0xbe, 0xf9, 0xaf, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous617 */ {
            /* {dfac10a9-dd24-43cf-a095-6ffa2e4b6a6c} */
            { 0xdfac10a9, 0xdd24, 0x43cf, { 0xa0, 0x95, 0x6f, 0xfa, 0x2e, 0x4b, 0x6a, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous095 */ {
            /* {db6f46da-8de3-478d-b539-801398656cf6} */
            { 0xdb6f46da, 0x8de3, 0x478d, { 0xb5, 0x39, 0x80, 0x13, 0x98, 0x65, 0x6c, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous573 */ {
            /* {948a0023-e3a7-11d2-96cf-0060b0fb9956} */
            { 0x948a0023, 0xe3a7, 0x11d2, { 0x96, 0xcf, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous162 */ {
            /* {f1070bfa-d539-11d6-90ca-00039310a47a} */
            { 0xf1070bfa, 0xd539, 0x11d6, { 0x90, 0xca, 0x00, 0x03, 0x93, 0x10, 0xa4, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous444 */ {
            /* {1b7db999-2ecd-4abf-bb95-a726896798ca} */
            { 0x1b7db999, 0x2ecd, 0x4abf, { 0xbb, 0x95, 0xa7, 0x26, 0x89, 0x67, 0x98, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous436 */ {
            /* {16e5c837-f877-4e23-9c64-eddf905e30e6} */
            { 0x16e5c837, 0xf877, 0x4e23, { 0x9c, 0x64, 0xed, 0xdf, 0x90, 0x5e, 0x30, 0xe6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous143 */ {
            /* {05bab5e7-9c7d-11d3-98a3-001083010e9b} */
            { 0x5bab5e7, 0x9c7d, 0x11d3, { 0x98, 0xa3, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous388 */ {
            /* {7d7008a0-c49a-11d3-9b22-0080c7cb1080} */
            { 0x7d7008a0, 0xc49a, 0x11d3, { 0x9b, 0x22, 0x00, 0x80, 0xc7, 0xcb, 0x10, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous299 */ {
            /* {3e65d9b5-5b41-4c18-ac7b-681b9df9df97} */
            { 0x3e65d9b5, 0x5b41, 0x4c18, { 0xac, 0x7b, 0x68, 0x1b, 0x9d, 0xf9, 0xdf, 0x97 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous414 */ {
            /* {d581149e-3319-4563-b95e-46c64af5c4e8} */
            { 0xd581149e, 0x3319, 0x4563, { 0xb9, 0x5e, 0x46, 0xc6, 0x4a, 0xf5, 0xc4, 0xe8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous603 */ {
            /* {a99febba-1dd1-11b2-a943-b02334a6d083} */
            { 0xa99febba, 0x1dd1, 0x11b2, { 0xa9, 0x43, 0xb0, 0x23, 0x34, 0xa6, 0xd0, 0x83 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous667 */ {
            /* {bfc310d2-38a0-11d3-8cd3-0060b0fc14a3} */
            { 0xbfc310d2, 0x38a0, 0x11d3, { 0x8c, 0xd3, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous658 */ {
            /* {bfcb82c2-5611-4318-90d6-baf4a7864252} */
            { 0xbfcb82c2, 0x5611, 0x4318, { 0x90, 0xd6, 0xba, 0xf4, 0xa7, 0x86, 0x42, 0x52 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous051 */ {
            /* {968bac9e-798b-4952-b384-86b21b8cc71e} */
            { 0x968bac9e, 0x798b, 0x4952, { 0xb3, 0x84, 0x86, 0xb2, 0x1b, 0x8c, 0xc7, 0x1e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous446 */ {
            /* {a6b2f8b0-7438-11ea-bc55-0242ac130003} */
            { 0xa6b2f8b0, 0x7438, 0x11ea, { 0xbc, 0x55, 0x02, 0x42, 0xac, 0x13, 0x00, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous129 */ {
            /* {439400d3-6f23-43db-8b06-8aafe1869bd8} */
            { 0x439400d3, 0x6f23, 0x43db, { 0x8b, 0x06, 0x8a, 0xaf, 0xe1, 0x86, 0x9b, 0xd8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous666 */ {
            /* {041a129f-10ce-4bda-a60d-e027a26d5ed0} */
            { 0x41a129f, 0x10ce, 0x4bda, { 0xa6, 0x0d, 0xe0, 0x27, 0xa2, 0x6d, 0x5e, 0xd0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous085 */ {
            /* {127b341a-bdda-4270-85e1-edff569a9b85} */
            { 0x127b341a, 0xbdda, 0x4270, { 0x85, 0xe1, 0xed, 0xff, 0x56, 0x9a, 0x9b, 0x85 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous642 */ {
            /* {3662958c-0e34-4f57-bc6d-2accdeb4342e} */
            { 0x3662958c, 0xe34, 0x4f57, { 0xbc, 0x6d, 0x2a, 0xcc, 0xde, 0xb4, 0x34, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* MailSession */ {
            /* {d5124441-d59e-11d2-806a-006080128c4e} */
            { 0xd5124441, 0xd59e, 0x11d2, { 0x80, 0x6a, 0x00, 0x60, 0x80, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous477 */ {
            /* {d9d75e86-8f17-4c57-993e-f738f0d86d42} */
            { 0xd9d75e86, 0x8f17, 0x4c57, { 0x99, 0x3e, 0xf7, 0x38, 0xf0, 0xd8, 0x6d, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous081 */ {
            /* {c85a5ef2-9c56-445f-b029-76889f2dd29b} */
            { 0xc85a5ef2, 0x9c56, 0x445f, { 0xb0, 0x29, 0x76, 0x88, 0x9f, 0x2d, 0xd2, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous384 */ {
            /* {ff41913b-546a-4bff-9201-dc9b2c032eba} */
            { 0xff41913b, 0x546a, 0x4bff, { 0x92, 0x01, 0xdc, 0x9b, 0x2c, 0x03, 0x2e, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous654 */ {
            /* {cf7fd51f-aba2-44c1-9ff0-11f7508efcd4} */
            { 0xcf7fd51f, 0xaba2, 0x44c1, { 0x9f, 0xf0, 0x11, 0xf7, 0x50, 0x8e, 0xfc, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous579 */ {
            /* {0ba77e04-2adb-422f-af01-5a57b8013100} */
            { 0xba77e04, 0x2adb, 0x422f, { 0xaf, 0x01, 0x5a, 0x57, 0xb8, 0x01, 0x31, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous000 */ {
            /* {7463258c-6ef3-40a2-89a9-bb349596e927} */
            { 0x7463258c, 0x6ef3, 0x40a2, { 0x89, 0xa9, 0xbb, 0x34, 0x95, 0x96, 0xe9, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous221 */ {
            /* {f0a8af16-dcff-11d2-a411-00805f613c79} */
            { 0xf0a8af16, 0xdcff, 0x11d2, { 0xa4, 0x11, 0x00, 0x80, 0x5f, 0x61, 0x3c, 0x79 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URILoader */ {
            /* {9f6d5d40-90e7-11d3-af80-00a024ffc08c} */
            { 0x9f6d5d40, 0x90e7, 0x11d3, { 0xaf, 0x80, 0x00, 0xa0, 0x24, 0xff, 0xc0, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous411 */ {
            /* {ee706783-3af8-4d19-9e84-e2ebfe213480} */
            { 0xee706783, 0x3af8, 0x4d19, { 0x9e, 0x84, 0xe2, 0xeb, 0xfe, 0x21, 0x34, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous198 */ {
            /* {7689942f-cbd1-42ad-87b9-44128354f55d} */
            { 0x7689942f, 0xcbd1, 0x42ad, { 0x87, 0xb9, 0x44, 0x12, 0x83, 0x54, 0xf5, 0x5d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous524 */ {
            /* {3a0012eb-007f-4bb8-aa81-a07385f77a25} */
            { 0x3a0012eb, 0x7f, 0x4bb8, { 0xaa, 0x81, 0xa0, 0x73, 0x85, 0xf7, 0x7a, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous149 */ {
            /* {028b9c1e-8d0a-4518-80c2-842e07846eaa} */
            { 0x28b9c1e, 0x8d0a, 0x4518, { 0x80, 0xc2, 0x84, 0x2e, 0x07, 0x84, 0x6e, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DownloadPlatform */ {
            /* {649a14c9-fe5c-48ec-9c85-00cad9ccf32e} */
            { 0x649a14c9, 0xfe5c, 0x48ec, { 0x9c, 0x85, 0x00, 0xca, 0xd9, 0xcc, 0xf3, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous024 */ {
            /* {76810fae-abad-4019-917a-08e95d5bbd68} */
            { 0x76810fae, 0xabad, 0x4019, { 0x91, 0x7a, 0x08, 0xe9, 0x5d, 0x5b, 0xbd, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous622 */ {
            /* {7225c040-a9bf-11d3-a197-0050041caf44} */
            { 0x7225c040, 0xa9bf, 0x11d3, { 0xa1, 0x97, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous155 */ {
            /* {8cddbbbc-7ced-46b0-a936-8cddd1928c24} */
            { 0x8cddbbbc, 0x7ced, 0x46b0, { 0xa9, 0x36, 0x8c, 0xdd, 0xd1, 0x92, 0x8c, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous264 */ {
            /* {91fdaa4e-eba4-4ed3-831c-ce05c142822d} */
            { 0x91fdaa4e, 0xeba4, 0x4ed3, { 0x83, 0x1c, 0xce, 0x05, 0xc1, 0x42, 0x82, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous397 */ {
            /* {de9472d0-8034-11d3-9399-00104ba0fd40} */
            { 0xde9472d0, 0x8034, 0x11d3, { 0x93, 0x99, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous575 */ {
            /* {8b5314bc-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314bc, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* TextToSubURI */ {
            /* {8b042e22-6f87-11d3-b3c8-00805f8a6670} */
            { 0x8b042e22, 0x6f87, 0x11d3, { 0xb3, 0xc8, 0x00, 0x80, 0x5f, 0x8a, 0x66, 0x70 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous190 */ {
            /* {cfcd1caa-00d9-40d0-831e-673820e04fc6} */
            { 0xcfcd1caa, 0xd9, 0x40d0, { 0x83, 0x1e, 0x67, 0x38, 0x20, 0xe0, 0x4f, 0xc6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous218 */ {
            /* {f0a8af16-dcce-11d2-a411-00805f613c79} */
            { 0xf0a8af16, 0xdcce, 0x11d2, { 0xa4, 0x11, 0x00, 0x80, 0x5f, 0x61, 0x3c, 0x79 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous239 */ {
            /* {a2e95f4f-da72-4a41-9493-661ad353c00a} */
            { 0xa2e95f4f, 0xda72, 0x4a41, { 0x94, 0x93, 0x66, 0x1a, 0xd3, 0x53, 0xc0, 0x0a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous598 */ {
            /* {669a9795-6ff7-4ed4-9150-c34ce2971b63} */
            { 0x669a9795, 0x6ff7, 0x4ed4, { 0x91, 0x50, 0xc3, 0x4c, 0xe2, 0x97, 0x1b, 0x63 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous103 */ {
            /* {68b25510-e641-11d2-b7fc-00805f05ffa5} */
            { 0x68b25510, 0xe641, 0x11d2, { 0xb7, 0xfc, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ExternalProtocolHandler */ {
            /* {bd6390c8-fbea-11d4-98f6-001083010e9b} */
            { 0xbd6390c8, 0xfbea, 0x11d4, { 0x98, 0xf6, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous516 */ {
            /* {1a817186-357a-47cd-8aea-2850d60e959e} */
            { 0x1a817186, 0x357a, 0x47cd, { 0x8a, 0xea, 0x28, 0x50, 0xd6, 0x0e, 0x95, 0x9e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous202 */ {
            /* {eef82462-cb69-11d2-8065-006008128c4e} */
            { 0xeef82462, 0xcb69, 0x11d2, { 0x80, 0x65, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous651 */ {
            /* {62ec8731-55ad-4246-b2ea-f26c1fe19d2d} */
            { 0x62ec8731, 0x55ad, 0x4246, { 0xb2, 0xea, 0xf2, 0x6c, 0x1f, 0xe1, 0x9d, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Preferences */ {
            /* {91ca2441-050f-4f7c-9df8-75b40ea40156} */
            { 0x91ca2441, 0x50f, 0x4f7c, { 0x9d, 0xf8, 0x75, 0xb4, 0x0e, 0xa4, 0x01, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous223 */ {
            /* {dc4ad42f-bc98-4193-a469-0cfa95ed9bcb} */
            { 0xdc4ad42f, 0xbc98, 0x4193, { 0xa4, 0x69, 0x0c, 0xfa, 0x95, 0xed, 0x9b, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NetworkErrorLogging */ {
            /* {ce24d145-19f5-43ed-a0d1-09385850b1cc} */
            { 0xce24d145, 0x19f5, 0x43ed, { 0xa0, 0xd1, 0x09, 0x38, 0x58, 0x50, 0xb1, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous386 */ {
            /* {275d800e-3f60-4896-adb7-d7f390ce0e42} */
            { 0x275d800e, 0x3f60, 0x4896, { 0xad, 0xb7, 0xd7, 0xf3, 0x90, 0xce, 0x0e, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous558 */ {
            /* {8b5314ba-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314ba, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0x3c9c } /* "@mozilla.org/widget/clipboard;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Compose */ {
            /* {588595fe-1ada-11d3-a715-0060b0eb39b5} */
            { 0x588595fe, 0x1ada, 0x11d3, { 0xa7, 0x15, 0x00, 0x60, 0xb0, 0xeb, 0x39, 0xb5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous628 */ {
            /* {79a2b7cc-f05b-4605-bfa0-fac54f27eec8} */
            { 0x79a2b7cc, 0xf05b, 0x4605, { 0xbf, 0xa0, 0xfa, 0xc5, 0x4f, 0x27, 0xee, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous618 */ {
            /* {91775d60-d5dc-11d2-92fb-00e09805570f} */
            { 0x91775d60, 0xd5dc, 0x11d2, { 0x92, 0xfb, 0x00, 0xe0, 0x98, 0x05, 0x57, 0x0f } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous038 */ {
            /* {f8438bff-a3c9-4ed5-b23f-2663b5469abf} */
            { 0xf8438bff, 0xa3c9, 0x4ed5, { 0xb2, 0x3f, 0x26, 0x63, 0xb5, 0x46, 0x9a, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous012 */ {
            /* {974339d5-ab86-4491-aaaf-2b2ca177c12b} */
            { 0x974339d5, 0xab86, 0x4491, { 0xaa, 0xaf, 0x2b, 0x2c, 0xa1, 0x77, 0xc1, 0x2b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous315 */ {
            /* {92ae3ab2-8968-41b1-8709-b6123bceaf21} */
            { 0x92ae3ab2, 0x8968, 0x41b1, { 0x87, 0x09, 0xb6, 0x12, 0x3b, 0xce, 0xaf, 0x21 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous650 */ {
            /* {ae2793c0-2ba3-4adb-9c5e-c23525812c64} */
            { 0xae2793c0, 0x2ba3, 0x4adb, { 0x9c, 0x5e, 0xc2, 0x35, 0x25, 0x81, 0x2c, 0x64 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous234 */ {
            /* {1bcd08c0-37ce-455c-87ea-49809189484e} */
            { 0x1bcd08c0, 0x37ce, 0x455c, { 0x87, 0xea, 0x49, 0x80, 0x91, 0x89, 0x48, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous490 */ {
            /* {b43c96be-2b3a-4dc4-90e9-b06d34219b68} */
            { 0xb43c96be, 0x2b3a, 0x4dc4, { 0x90, 0xe9, 0xb0, 0x6d, 0x34, 0x21, 0x9b, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous287 */ {
            /* {0d55a5e6-d185-44f0-b992-a8e1321e4bce} */
            { 0xd55a5e6, 0xd185, 0x44f0, { 0xb9, 0x92, 0xa8, 0xe1, 0x32, 0x1e, 0x4b, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous626 */ {
            /* {d39a8904-2e09-4a3a-a273-c3bec7db2bfe} */
            { 0xd39a8904, 0x2e09, 0x4a3a, { 0xa2, 0x73, 0xc3, 0xbe, 0xc7, 0xdb, 0x2b, 0xfe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous204 */ {
            /* {75b63b46-1dd2-11b2-9873-bb375e1550fa} */
            { 0x75b63b46, 0x1dd2, 0x11b2, { 0x98, 0x73, 0xbb, 0x37, 0x5e, 0x15, 0x50, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous486 */ {
            /* {994c0350-84a1-4d62-86ff-712e769a6638} */
            { 0x994c0350, 0x84a1, 0x4d62, { 0x86, 0xff, 0x71, 0x2e, 0x76, 0x9a, 0x66, 0x38 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous366 */ {
            /* {1423e739-782c-4081-b5d8-fe6fba68c0ef} */
            { 0x1423e739, 0x782c, 0x4081, { 0xb5, 0xd8, 0xfe, 0x6f, 0xba, 0x68, 0xc0, 0xef } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous449 */ {
            /* {06f13674-fb28-4dfc-bf25-342c83705b2f} */
            { 0x6f13674, 0xfb28, 0x4dfc, { 0xbf, 0x25, 0x34, 0x2c, 0x83, 0x70, 0x5b, 0x2f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous180 */ {
            /* {8c0c40d1-e173-11d2-806e-006008128c4e} */
            { 0x8c0c40d1, 0xe173, 0x11d2, { 0x80, 0x6e, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous043 */ {
            /* {607b2c0b-9504-483f-ad62-41de09238aec} */
            { 0x607b2c0b, 0x9504, 0x483f, { 0xad, 0x62, 0x41, 0xde, 0x09, 0x23, 0x8a, 0xec } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous174 */ {
            /* {fb62c8ed-b875-488a-be35-ab9764bcad25} */
            { 0xfb62c8ed, 0xb875, 0x488a, { 0xbe, 0x35, 0xab, 0x97, 0x64, 0xbc, 0xad, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous080 */ {
            /* {b3de9249-b0e5-4c12-8d91-c9a434fd80f5} */
            { 0xb3de9249, 0xb0e5, 0x4c12, { 0x8d, 0x91, 0xc9, 0xa4, 0x34, 0xfd, 0x80, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous002 */ {
            /* {e736f2bd-7640-4715-ab35-887dc866c587} */
            { 0xe736f2bd, 0x7640, 0x4715, { 0xab, 0x35, 0x88, 0x7d, 0xc8, 0x66, 0xc5, 0x87 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Observer */ {
            /* {d07f5195-e3d1-11d2-8acd-00105a1b8860} */
            { 0xd07f5195, 0xe3d1, 0x11d2, { 0x8a, 0xcd, 0x00, 0x10, 0x5a, 0x1b, 0x88, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous379 */ {
            /* {831f8f13-7aa8-485f-b02e-77c881cc5773} */
            { 0x831f8f13, 0x7aa8, 0x485f, { 0xb0, 0x2e, 0x77, 0xc8, 0x81, 0xcc, 0x57, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous429 */ {
            /* {1dbc6eb6-0972-4bdb-9dc4-acd0abf72369} */
            { 0x1dbc6eb6, 0x972, 0x4bdb, { 0x9d, 0xc4, 0xac, 0xd0, 0xab, 0xf7, 0x23, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous338 */ {
            /* {e746a8b1-c97a-4fc5-baa4-66607521bd08} */
            { 0xe746a8b1, 0xc97a, 0x4fc5, { 0xba, 0xa4, 0x66, 0x60, 0x75, 0x21, 0xbd, 0x08 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Imap */ {
            /* {c5852b22-ebe2-11d2-95ad-000064657374} */
            { 0xc5852b22, 0xebe2, 0x11d2, { 0x95, 0xad, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous091 */ {
            /* {f7dc2aeb-8e62-4750-965c-24b9e09ed8d2} */
            { 0xf7dc2aeb, 0x8e62, 0x4750, { 0x96, 0x5c, 0x24, 0xb9, 0xe0, 0x9e, 0xd8, 0xd2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous183 */ {
            /* {8d3675e0-ed46-11d2-8077-006008128c4e} */
            { 0x8d3675e0, 0xed46, 0x11d2, { 0x80, 0x77, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AbManager */ {
            /* {224d3ef9-d81c-4d94-8826-a79a5835af93} */
            { 0x224d3ef9, 0xd81c, 0x4d94, { 0x88, 0x26, 0xa7, 0x9a, 0x58, 0x35, 0xaf, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous332 */ {
            /* {461cd5dd-73c6-47a4-8cc3-603b37d84a61} */
            { 0x461cd5dd, 0x73c6, 0x47a4, { 0x8c, 0xc3, 0x60, 0x3b, 0x37, 0xd8, 0x4a, 0x61 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous599 */ {
            /* {acf8dc41-4a25-11d3-9890-006008962422} */
            { 0xacf8dc41, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous493 */ {
            /* {cb9e0de8-3598-4ed7-857b-827f011ad5d8} */
            { 0xcb9e0de8, 0x3598, 0x4ed7, { 0x85, 0x7b, 0x82, 0x7f, 0x01, 0x1a, 0xd5, 0xd8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous026 */ {
            /* {6877bbdd-f336-46f5-98ce-fe86d0285cc1} */
            { 0x6877bbdd, 0xf336, 0x46f5, { 0x98, 0xce, 0xfe, 0x86, 0xd0, 0x28, 0x5c, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous467 */ {
            /* {d9cd00ba-aa4d-47b1-8792-b1fe0cd35060} */
            { 0xd9cd00ba, 0xaa4d, 0x47b1, { 0x87, 0x92, 0xb1, 0xfe, 0x0c, 0xd3, 0x50, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous501 */ {
            /* {d0c5195d-e798-49d4-b1d3-9324328b2291} */
            { 0xd0c5195d, 0xe798, 0x49d4, { 0xb1, 0xd3, 0x93, 0x24, 0x32, 0x8b, 0x22, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous557 */ {
            /* {8b1ae382-51a9-4972-b930-56977a57919d} */
            { 0x8b1ae382, 0x51a9, 0x4972, { 0xb9, 0x30, 0x56, 0x97, 0x7a, 0x57, 0x91, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous514 */ {
            /* {79a13656-a472-4713-b0e1-ab39a15cf790} */
            { 0x79a13656, 0xa472, 0x4713, { 0xb0, 0xe1, 0xab, 0x39, 0xa1, 0x5c, 0xf7, 0x90 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous233 */ {
            /* {2b5b6cbc-f517-4e2b-a31f-4dce5a0b9f48} */
            { 0x2b5b6cbc, 0xf517, 0x4e2b, { 0xa3, 0x1f, 0x4d, 0xce, 0x5a, 0x0b, 0x9f, 0x48 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous369 */ {
            /* {9c7ec5d1-23f9-11d5-aea8-8fcc0793e97f} */
            { 0x9c7ec5d1, 0x23f9, 0x11d5, { 0xae, 0xa8, 0x8f, 0xcc, 0x07, 0x93, 0xe9, 0x7f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous193 */ {
            /* {1a0b778c-2fe6-4012-b4f3-e81c0c116409} */
            { 0x1a0b778c, 0x2fe6, 0x4012, { 0xb4, 0xf3, 0xe8, 0x1c, 0x0c, 0x11, 0x64, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Tag */ {
            /* {b897da55-8256-4cf5-892b-32e77bc7c50b} */
            { 0xb897da55, 0x8256, 0x4cf5, { 0x89, 0x2b, 0x32, 0xe7, 0x7b, 0xc7, 0xc5, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous563 */ {
            /* {28be18ae-73ee-494f-8c6d-5d14b7c998c7} */
            { 0x28be18ae, 0x73ee, 0x494f, { 0x8c, 0x6d, 0x5d, 0x14, 0xb7, 0xc9, 0x98, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous595 */ {
            /* {7b4eeb20-d781-11d4-8a83-0010a4e0c9ca} */
            { 0x7b4eeb20, 0xd781, 0x11d4, { 0x8a, 0x83, 0x00, 0x10, 0xa4, 0xe0, 0xc9, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous639 */ {
            /* {09d9ed1a-e5d4-4004-bfe0-27ceb923d9ac} */
            { 0x9d9ed1a, 0xe5d4, 0x4004, { 0xbf, 0xe0, 0x27, 0xce, 0xb9, 0x23, 0xd9, 0xac } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous130 */ {
            /* {717c9f39-8103-4116-a896-7ff22b6d269d} */
            { 0x717c9f39, 0x8103, 0x4116, { 0xa8, 0x96, 0x7f, 0xf2, 0x2b, 0x6d, 0x26, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous257 */ {
            /* {1f34bc80-1bc7-11d6-a384-d705dd0746fc} */
            { 0x1f34bc80, 0x1bc7, 0x11d6, { 0xa3, 0x84, 0xd7, 0x05, 0xdd, 0x07, 0x46, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous681 */ {
            /* {7090524d-5574-4492-a77f-d8d558ced59d} */
            { 0x7090524d, 0x5574, 0x4492, { 0xa7, 0x7f, 0xd8, 0xd5, 0x58, 0xce, 0xd5, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous574 */ {
            /* {b148eed2-236d-11d3-b35c-00a0cc3c1cde} */
            { 0xb148eed2, 0x236d, 0x11d3, { 0xb3, 0x5c, 0x00, 0xa0, 0xcc, 0x3c, 0x1c, 0xde } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous553 */ {
            /* {4e4aae11-8901-46cc-8217-dad7c5415873} */
            { 0x4e4aae11, 0x8901, 0x46cc, { 0x82, 0x17, 0xda, 0xd7, 0xc5, 0x41, 0x58, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous358 */ {
            /* {3decd6c8-30ef-11d3-8cd0-0060b0fc14a3} */
            { 0x3decd6c8, 0x30ef, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous440 */ {
            /* {71b49926-fd4e-43e2-ab8d-d9b049413c0b} */
            { 0x71b49926, 0xfd4e, 0x43e2, { 0xab, 0x8d, 0xd9, 0xb0, 0x49, 0x41, 0x3c, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous356 */ {
            /* {58a1c31c-1dd2-11b2-a3f6-d36949d48268} */
            { 0x58a1c31c, 0x1dd2, 0x11b2, { 0xa3, 0xf6, 0xd3, 0x69, 0x49, 0xd4, 0x82, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous158 */ {
            /* {36414aa0-e980-11d2-a506-0060b0fc04b7} */
            { 0x36414aa0, 0xe980, 0x11d2, { 0xa5, 0x06, 0x00, 0x60, 0xb0, 0xfc, 0x04, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous407 */ {
            /* {75a500a2-0030-40f7-86f8-63f225b940ae} */
            { 0x75a500a2, 0x30, 0x40f7, { 0x86, 0xf8, 0x63, 0xf2, 0x25, 0xb9, 0x40, 0xae } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous040 */ {
            /* {b3eaa1c4-5dfe-4c0a-b62a-b3a514218461} */
            { 0xb3eaa1c4, 0x5dfe, 0x4c0a, { 0xb6, 0x2a, 0xb3, 0xa5, 0x14, 0x21, 0x84, 0x61 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous057 */ {
            /* {048227f7-852a-473c-b9b5-7748684b57e2} */
            { 0x48227f7, 0x852a, 0x473c, { 0xb9, 0xb5, 0x77, 0x48, 0x68, 0x4b, 0x57, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous624 */ {
            /* {03d68f92-9513-4e25-9be9-7cb239874172} */
            { 0x3d68f92, 0x9513, 0x4e25, { 0x9b, 0xe9, 0x7c, 0xb2, 0x39, 0x87, 0x41, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous545 */ {
            /* {7beb3ba8-6ec3-41b4-b67c-da89b8518922} */
            { 0x7beb3ba8, 0x6ec3, 0x41b4, { 0xb6, 0x7c, 0xda, 0x89, 0xb8, 0x51, 0x89, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UUIDGenerator */ {
            /* {706d36bb-bf79-4293-81f2-8f6828c18f9d} */
            { 0x706d36bb, 0xbf79, 0x4293, { 0x81, 0xf2, 0x8f, 0x68, 0x28, 0xc1, 0x8f, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous189 */ {
            /* {77b5592c-5018-436d-a466-c4e5443a1669} */
            { 0x77b5592c, 0x5018, 0x436d, { 0xa4, 0x66, 0xc4, 0xe5, 0x44, 0x3a, 0x16, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous148 */ {
            /* {e5872045-a87b-4ea0-b366-45ebd7dc89d9} */
            { 0xe5872045, 0xa87b, 0x4ea0, { 0xb3, 0x66, 0x45, 0xeb, 0xd7, 0xdc, 0x89, 0xd9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous472 */ {
            /* {00ed5d73-9de5-42cf-868c-e739a94f6b37} */
            { 0xed5d73, 0x9de5, 0x42cf, { 0x86, 0x8c, 0xe7, 0x39, 0xa9, 0x4f, 0x6b, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Dashboard */ {
            /* {c79eb3c6-091a-45a6-8544-5a8d1ab79537} */
            { 0xc79eb3c6, 0x91a, 0x45a6, { 0x85, 0x44, 0x5a, 0x8d, 0x1a, 0xb7, 0x95, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous459 */ {
            /* {4d48c536-e16f-4699-8f9c-add4f28f92f0} */
            { 0x4d48c536, 0xe16f, 0x4699, { 0x8f, 0x9c, 0xad, 0xd4, 0xf2, 0x8f, 0x92, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous281 */ {
            /* {e7d52d9e-c148-47d8-ab2a-95d7f40ea53d} */
            { 0xe7d52d9e, 0xc148, 0x47d8, { 0xab, 0x2a, 0x95, 0xd7, 0xf4, 0x0e, 0xa5, 0x3d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous591 */ {
            /* {eb833911-4f49-4623-845f-e58a8e6de4c2} */
            { 0xeb833911, 0x4f49, 0x4623, { 0x84, 0x5f, 0xe5, 0x8a, 0x8e, 0x6d, 0xe4, 0xc2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous543 */ {
            /* {4399533d-08d1-458c-a87a-235f74451cfa} */
            { 0x4399533d, 0x8d1, 0x458c, { 0xa8, 0x7a, 0x23, 0x5f, 0x74, 0x45, 0x1c, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous039 */ {
            /* {bda0dd7f-0a2f-4fcf-ba08-5517e6fbf133} */
            { 0xbda0dd7f, 0xa2f, 0x4fcf, { 0xba, 0x08, 0x55, 0x17, 0xe6, 0xfb, 0xf1, 0x33 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous116 */ {
            /* {2af6e050-04f6-495a-8387-86b0aeb1863c} */
            { 0x2af6e050, 0x4f6, 0x495a, { 0x83, 0x87, 0x86, 0xb0, 0xae, 0xb1, 0x86, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ExtensionPolicy */ {
            /* {562de129-8338-482c-bb96-a1ff09ee53cc} */
            { 0x562de129, 0x8338, 0x482c, { 0xbb, 0x96, 0xa1, 0xff, 0x09, 0xee, 0x53, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous336 */ {
            /* {3014dde6-aa1c-41db-87d0-48764a3710f6} */
            { 0x3014dde6, 0xaa1c, 0x41db, { 0x87, 0xd0, 0x48, 0x76, 0x4a, 0x37, 0x10, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous200 */ {
            /* {46efcb10-cb6d-11d2-8065-006008128c4e} */
            { 0x46efcb10, 0xcb6d, 0x11d2, { 0x80, 0x65, 0x00, 0x60, 0x08, 0x12, 0x8c, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous045 */ {
            /* {29b09a83-81c1-2032-11e2-6d9bc4f8e969} */
            { 0x29b09a83, 0x81c1, 0x2032, { 0x11, 0xe2, 0x6d, 0x9b, 0xc4, 0xf8, 0xe9, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous631 */ {
            /* {48118355-e9a5-4452-ab18-59cc426fb817} */
            { 0x48118355, 0xe9a5, 0x4452, { 0xab, 0x18, 0x59, 0xcc, 0x42, 0x6f, 0xb8, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous144 */ {
            /* {1c7abf0c-21e5-11d3-8ef1-00a024a7d144} */
            { 0x1c7abf0c, 0x21e5, 0x11d3, { 0x8e, 0xf1, 0x00, 0xa0, 0x24, 0xa7, 0xd1, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous643 */ {
            /* {c9da865e-c3d7-4aa1-a271-0f571f013c30} */
            { 0xc9da865e, 0xc3d7, 0x4aa1, { 0xa2, 0x71, 0x0f, 0x57, 0x1f, 0x01, 0x3c, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NSSErrors */ {
            /* {9ef18451-a157-4d17-8132-47afef213689} */
            { 0x9ef18451, 0xa157, 0x4d17, { 0x81, 0x32, 0x47, 0xaf, 0xef, 0x21, 0x36, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous565 */ {
            /* {40fd47f2-463a-4e4a-a33f-27eb148bfee4} */
            { 0x40fd47f2, 0x463a, 0x4e4a, { 0xa3, 0x3f, 0x27, 0xeb, 0x14, 0x8b, 0xfe, 0xe4 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous210 */ {
            /* {44aef4ce-475b-42e3-bc42-7730d5ce7365} */
            { 0x44aef4ce, 0x475b, 0x42e3, { 0xbc, 0x42, 0x77, 0x30, 0xd5, 0xce, 0x73, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous482 */ {
            /* {8a9a1406-d700-4221-8615-1d84b0d213fb} */
            { 0x8a9a1406, 0xd700, 0x4221, { 0x86, 0x15, 0x1d, 0x84, 0xb0, 0xd2, 0x13, 0xfb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous169 */ {
            /* {3028a3c8-2165-42a4-b878-398da5d32736} */
            { 0x3028a3c8, 0x2165, 0x42a4, { 0xb8, 0x78, 0x39, 0x8d, 0xa5, 0xd3, 0x27, 0x36 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous255 */ {
            /* {f30bc0a2-958b-4287-bf62-ce38ba0c811e} */
            { 0xf30bc0a2, 0x958b, 0x4287, { 0xbf, 0x62, 0xce, 0x38, 0xba, 0x0c, 0x81, 0x1e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          }
};



const StaticModule*
ModuleByCID(const nsID& aKey)
{
  static const uint16_t BASES[] = {
       0,   4,   1,   1,   9,   0,   0,   3,   1,   2,   7,   1,   6,   0,   1,   1,
       0,   3,   2,   2,   1,   1,   0,   7,   1,   2,  10,   1,   1,   3,   6,   0,
       1,   0,   2,   3,   1,   0,   4,   0,   1,   1,   0,   3,   1,   9,  10,   1,
       0,   1,   1,   1,   1,   1,   0,   5,   1,  11,   0,  10,   4,   3,   0,   1,
       1,   1,   0,   6,   0,   0,  21,   2,   1,  12,   2,   3,   0,   5,   1,   0,
       2,   0,   1,   2,   0,   1,   0,   8,   3,   8,   4,   1,   0,   5,   1,   3,
       4,   0,   2,   0,   2,   1,   0,   3,   0,   9,   2,   8,   3,   0,  12,  16,
       1,   1,   2,   7,  19,   0,   9,   3,   9,   4,   4,   1,  13,   2,   0,   1,
       0,   3,   2,   0,   0,   4,   2,   2,   2,   7,   1,   0,   2,   4,   5,   0,
      10,   4,   6,  24,   4,   2,   2,   4,   0,   6,   0,   6,   3,   6,   0,   3,
       3,   5,   0,   6,   6,   6,   2,   0,   9,   5,   1,   2,   2,   2,   4,   7,
       4,  17,   0,   0,   2,   2,   1,   4,   8,   0,   2,  23,   1,   3,  10,   7,
       3,   3,   3,   1,   3,   1,   0,   9,  30,   0,   4,  10,   2,   5,   2,  18,
       2,   0,   2,   7,   4,  12,   3,   1,   0,   0,   8,   5,   5,  27,   6,   3,
       2,  24,  13,   3,   6,   1,   7,  14,   4,   2,   0,   1,   0,   7,  24,   5,
       1,   0,   7,   0,   1,   3,   6,   0,   0,  16,   4,  11,   2,   1,   7,   0,
       3,   0,   0,   1,   4,   2,  19,  13,   1,   1,   6,   3,   7,   2,   0,   0,
       5,  12,   4,   4,   1,   0,   9,   1,   4,   0,   0,   9,  31,   0,   0,   0,
       0,   2,   1,  22,   6,   0,   3,   1,   6,   6,   2,  17,   0,   5,  22,   2,
       6,  21,  16,  42,  20,  17,   2,  18,   1,   0,   1,   1,   2,  14,   0,  13,
       1,   6,  40,   1,   2,   1,   0,   0,   0,   0,   9,   4,  18,  41,   9,   7,
       0,   3,   8,   1,   0,  16,   1,  18,   2,   1,   1,  30,   0,  94,   3,   2,
      11,   1,   1,   0,   4,   1,   0,   5,   8,   1,   4,   3,   5,  10,   4,  12,
       0,   3,  12,  18,  45,   0,   0,   9,  23,   2,   1,   0,  12,  20,   1,  22,
      17,   3,  25,  15,  11,   0,  93,  24,  15,   1,   9,   6,   3,  33,   0,   4,
       3,   3,   0,   0,   0,  28,   2,  20, 106,  11,   5,  21,   2,   7,  19,   0,
      11,   0,   0,  22,   1,   4,  18, 116,   5,   0,   0,   8,  20,  10,   0,  95,
      19,   5,   0,   5,  42,   0,  18,   0,   2,  12,  29,   1,   8,   2,   0,  32,
       1,  17,  17,  47,   0,   0,  16,  10,  33,   8,   4,  40,  16,   0,  11,   0,
       0,   0,  39,   0,   0,   5, 107,  29,  41,  20,   9,   1, 293,   0,  24,   0,
       5,   9,  24,   3,   0,  35,   1,   0,   0,  45,  11,  37,  13,  29,   0,   8,
       0,  54,  85,  52, 209, 111,   6,  44, 265,   3, 336,   0,   4,   7,  10, 436,
  };
  

  const char* bytes = reinterpret_cast<const char*>(&aKey);
  size_t length = sizeof(nsID);
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gStaticModules);
  return entry.CID().Equals(aKey) && entry.Active() ? &entry : nullptr;
}

const ContractEntry gContractEntries[] = {
  
          {
            { 0x3cbc } /* "@mozilla.org/io/arraybuffer-input-stream;1" */,
            ModuleID::Anonymous336,
          },
  
          {
            { 0x3ce7 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=gzip" */,
            ModuleID::Anonymous332,
          },
  
          {
            { 0x3d1b } /* "@mozilla.org/streamconv;1?from=x-gzip&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x3d51 } /* "@mozilla.org/user_cert_picker;1" */,
            ModuleID::Anonymous177,
          },
  
          {
            { 0x3d71 } /* "@mozilla.org/alert-notification;1" */,
            ModuleID::AlertNotification,
          },
  
          {
            { 0x3d93 } /* "@mozilla.org/mail/folder-factory;1?name=ews" */,
            ModuleID::Anonymous235,
          },
  
          {
            { 0x3dbf } /* "@mozilla.org/network/protocol/about;1?what=buildconfig" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x3df6 } /* "@mozilla.org/network/serialization-helper;1" */,
            ModuleID::Anonymous373,
          },
  
          {
            { 0x3e22 } /* "@mozilla.org/network/dashboard;1" */,
            ModuleID::Dashboard,
          },
  
          {
            { 0x11ee } /* "@mozilla.org/places/expiration;1" */,
            ModuleID::Anonymous508,
          },
  
          {
            { 0x3e43 } /* "@mozilla.org/msgDatabase/downloadSettings;1" */,
            ModuleID::Anonymous161,
          },
  
          {
            { 0x3e6f } /* "@mozilla.org/addons/policy-service;1" */,
            ModuleID::ExtensionPolicy,
          },
  
          {
            { 0xcfa } /* "@mozilla.org/messenger/mimeemitter;1?type=text/html" */,
            ModuleID::Anonymous218,
          },
  
          {
            { 0x3e94 } /* "@mozilla.org/content/dropped-link-handler;1" */,
            ModuleID::Anonymous257,
          },
  
          {
            { 0x3ec0 } /* "@mozilla.org/messenger/mailboxservice;1" */,
            ModuleID::Anonymous202,
          },
  
          {
            { 0x3ee8 } /* "@mozilla.org/messenger/msgdbview;1?type=search" */,
            ModuleID::Anonymous114,
          },
  
          {
            { 0xa17 } /* "@mozilla.org/storage/vacuum;1" */,
            ModuleID::Anonymous448,
          },
  
          {
            { 0x3f17 } /* "@mozilla.org/dom/sessionStorage-manager;1" */,
            ModuleID::Anonymous648,
          },
  
          {
            { 0x3f41 } /* "@mozilla.org/network/protocol/about;1?what=networking" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x3f77 } /* "@mozilla.org/browser/tagging-service;1" */,
            ModuleID::Anonymous506,
          },
  
          {
            { 0x3f9e } /* "@mozilla.org/network/captive-portal-service;1" */,
            ModuleID::CaptivePortal,
          },
  
          {
            { 0x3fcc } /* "@mozilla.org/calendar/datetime;1" */,
            ModuleID::Anonymous009,
          },
  
          {
            { 0x3fed } /* "@mozilla.org/gfx/printerlist;1" */,
            ModuleID::Anonymous584,
          },
  
          {
            { 0x400c } /* "@mozilla.org/browser/favicon-service;1" */,
            ModuleID::Anonymous503,
          },
  
          {
            { 0x4033 } /* "@mozilla.org/gfx/info;1" */,
            ModuleID::GfxInfo,
          },
  
          {
            { 0x404b } /* "@mozilla.org/async-shutdown-service;1" */,
            ModuleID::AsyncShutdown,
          },
  
          {
            { 0x4071 } /* "@mozilla.org/nsCMSMessage;1" */,
            ModuleID::Anonymous176,
          },
  
          {
            { 0x408d } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/vnd.mozilla.xul+xml" */,
            ModuleID::Anonymous660,
          },
  
          {
            { 0x40de } /* "@mozilla.org/process/util;1" */,
            ModuleID::Anonymous595,
          },
  
          {
            { 0x40fa } /* "@mozilla.org/devicesensors;1" */,
            ModuleID::Anonymous645,
          },
  
          {
            { 0x4117 } /* "@mozilla.org/mail/oauth2-module;1" */,
            ModuleID::Anonymous099,
          },
  
          {
            { 0x4139 } /* "@mozilla.org/messenger/filter-plugin;1?name=bayesianfilter" */,
            ModuleID::Anonymous162,
          },
  
          {
            { 0x4174 } /* "@mozilla.org/calendar/recurrence-rule;1" */,
            ModuleID::Anonymous023,
          },
  
          {
            { 0x419c } /* "@mozilla.org/contentsecuritymanager;1" */,
            ModuleID::ContentSecurityManager,
          },
  
          {
            { 0x41c2 } /* "@mozilla.org/pipe;1" */,
            ModuleID::Anonymous621,
          },
  
          {
            { 0x41d6 } /* "@mozilla.org/sandbox/sandbox-settings;1" */,
            ModuleID::Anonymous442,
          },
  
          {
            { 0x41fe } /* "@mozilla.org/content/filepicker;1" */,
            ModuleID::Anonymous565,
          },
  
          {
            { 0x4220 } /* "@mozilla.org/netwerk/cache-storage-service;1" */,
            ModuleID::CacheStorage,
          },
  
          {
            { 0x424d } /* "@mozilla.org/widget/transferable;1" */,
            ModuleID::Anonymous575,
          },
  
          {
            { 0x4270 } /* "@mozilla.org/messenger/protocol/info;1?type=pop3" */,
            ModuleID::Anonymous198,
          },
  
          {
            { 0x42a1 } /* "@mozilla.org/userinfo;1" */,
            ModuleID::Anonymous128,
          },
  
          {
            { 0x42b9 } /* "@mozilla.org/xpcom/ini-parser-factory;1" */,
            ModuleID::Anonymous617,
          },
  
          {
            { 0x42e1 } /* "@mozilla.org/security/hash;1" */,
            ModuleID::Anonymous430,
          },
  
          {
            { 0x42fe } /* "@mozilla.org/calendar/attachment;1" */,
            ModuleID::Anonymous006,
          },
  
          {
            { 0x4321 } /* "@mozilla.org/messenger/messageservice;1?type=ews-message" */,
            ModuleID::Anonymous236,
          },
  
          {
            { 0x435a } /* "@mozilla.org/network/protocol/about;1?what=crashextensions" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x4395 } /* "@mozilla.org/security/publickeypinningservice;1" */,
            ModuleID::Anonymous437,
          },
  
          {
            { 0x43c5 } /* "@mozilla.org/calendar/ics-parser;1" */,
            ModuleID::Anonymous014,
          },
  
          {
            { 0x10a5 } /* "@mozilla.org/dom/payments/payment-complete-action-response;1" */,
            ModuleID::Anonymous293,
          },
  
          {
            { 0x43e8 } /* "@mozilla.org/boolean-expression/condition-string;1" */,
            ModuleID::Anonymous092,
          },
  
          {
            { 0x441b } /* "@mozilla.org/messenger/mimeheaders;1" */,
            ModuleID::Anonymous214,
          },
  
          {
            { 0x4440 } /* "@mozilla.org/globalmessagemanager;1" */,
            ModuleID::Anonymous657,
          },
  
          {
            { 0x4464 } /* "@mozilla.org/supports-PRUint16;1" */,
            ModuleID::Anonymous609,
          },
  
          {
            { 0x4485 } /* "@mozilla.org/uriloader/handler-service-parent;1" */,
            ModuleID::Anonymous556,
          },
  
          {
            { 0x44b5 } /* "@mozilla.org/login-manager/loginInfo;1" */,
            ModuleID::Anonymous497,
          },
  
          {
            { 0x44dc } /* "@mozilla.org/network/server-socket;1" */,
            ModuleID::Anonymous374,
          },
  
          {
            { 0x4501 } /* "@mozilla.org/supports-interface-pointer;1" */,
            ModuleID::Anonymous603,
          },
  
          {
            { 0x452b } /* "@mozilla.org/messenger/server;1?type=imap" */,
            ModuleID::Anonymous183,
          },
  
          {
            { 0x4555 } /* "@mozilla.org/parserutils;1" */,
            ModuleID::Anonymous671,
          },
  
          {
            { 0x4570 } /* "@mozilla.org/accessibilityService;1" */,
            ModuleID::Anonymous684,
          },
  
          {
            { 0x4594 } /* "@mozilla.org/messenger/server;1?type=pop3" */,
            ModuleID::Anonymous196,
          },
  
          {
            { 0x45be } /* "@mozilla.org/uriloader/content-handler;1?type=x-application-imapfolder" */,
            ModuleID::Imap,
          },
  
          {
            { 0x4605 } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/xhtml+xml" */,
            ModuleID::Anonymous661,
          },
  
          {
            { 0x464c } /* "@mozilla.org/tracking-url-decoration-service;1" */,
            ModuleID::Anonymous451,
          },
  
          {
            { 0x467b } /* "@mozilla.org/widget/content/dragservice;1" */,
            ModuleID::Anonymous563,
          },
  
          {
            { 0x46a5 } /* "@mozilla.org/network/protocol;1?name=https" */,
            ModuleID::Anonymous363,
          },
  
          {
            { 0x925 } /* "@mozilla.org/image/cache;1" */,
            ModuleID::Anonymous310,
          },
  
          {
            { 0x46d0 } /* "@mozilla.org/intl/texttosuburi;1" */,
            ModuleID::TextToSubURI,
          },
  
          {
            { 0x46f1 } /* "@mozilla.org/network/throttlequeue;1" */,
            ModuleID::Anonymous381,
          },
  
          {
            { 0x3c63 } /* "@mozilla.org/system-info;1" */,
            ModuleID::SystemInfo,
          },
  
          {
            { 0x4716 } /* "@mozilla.org/dom/peerconnectionmanager;1" */,
            ModuleID::Anonymous273,
          },
  
          {
            { 0x473f } /* "@mozilla.org/chat/matrix;1" */,
            ModuleID::Anonymous044,
          },
  
          {
            { 0x475a } /* "@mozilla.org/streamconv;1?from=application/pdf&to=*\/\*" */,
            ModuleID::Anonymous501,
          },
  
          {
            { 0x4790 } /* "@mozilla.org/dom/sdb-connection;1" */,
            ModuleID::Anonymous650,
          },
  
          {
            { 0x47b2 } /* "@mozilla.org/messenger/server;1?type=ews" */,
            ModuleID::Anonymous232,
          },
  
          {
            { 0x47db } /* "@mozilla.org/network/file-output-stream;1" */,
            ModuleID::Anonymous348,
          },
  
          {
            { 0x4805 } /* "@mozilla.org/calendar/calendar;1?type=storage" */,
            ModuleID::Anonymous040,
          },
  
          {
            { 0x4833 } /* "@mozilla.org/nsCertPickDialogs;1" */,
            ModuleID::Anonymous177,
          },
  
          {
            { 0x4854 } /* "@mozilla.org/network/protocol;1?name=snews" */,
            ModuleID::Anonymous229,
          },
  
          {
            { 0x487f } /* "@mozilla.org/network/protocol/about;1?what=credits" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x48b2 } /* "@mozilla.org/network/background-file-saver;1?mode=streamlistener" */,
            ModuleID::Anonymous341,
          },
  
          {
            { 0x981 } /* "@mozilla.org/bounce-tracking-protection;1" */,
            ModuleID::BounceTrackingProtection,
          },
  
          {
            { 0x48f3 } /* "@mozilla.org/dom/peerconnectionstatic;1" */,
            ModuleID::Anonymous275,
          },
  
          {
            { 0x491b } /* "@mozilla.org/calendar/itip-transport;1?type=email" */,
            ModuleID::Anonymous032,
          },
  
          {
            { 0xa52 } /* "@mozilla.org/places/databaseUtilsIdleMaintenance;1" */,
            ModuleID::Anonymous509,
          },
  
          {
            { 0xa99 } /* "@mozilla.org/dom/quota-manager-service;1" */,
            ModuleID::Anonymous649,
          },
  
          {
            { 0x494d } /* "@mozilla.org/url-classifier/exception-list-entry;1" */,
            ModuleID::Anonymous419,
          },
  
          {
            { 0x4980 } /* "@mozilla.org/backgroundtasks;1" */,
            ModuleID::Anonymous458,
          },
  
          {
            { 0x499f } /* "@mozilla.org/scriptsecuritymanager;1" */,
            ModuleID::ScriptSecurityManager,
          },
  
          {
            { 0x49c4 } /* "@mozilla.org/url-classifier/dbservice;1" */,
            ModuleID::UrlClassifierDB,
          },
  
          {
            { 0x49ec } /* "@mozilla.org/messenger/server;1?type=rss" */,
            ModuleID::Anonymous211,
          },
  
          {
            { 0x4a15 } /* "@mozilla.org/toolkit/finalizationwitness;1" */,
            ModuleID::Anonymous463,
          },
  
          {
            { 0x4a40 } /* "@mozilla.org/scripterror;1" */,
            ModuleID::Anonymous675,
          },
  
          {
            { 0x4a5b } /* "@mozilla.org/io-util;1" */,
            ModuleID::Anonymous591,
          },
  
          {
            { 0x4a72 } /* "@mozilla.org/messengercompose/composeparams;1" */,
            ModuleID::Anonymous134,
          },
  
          {
            { 0x4aa0 } /* "@mozilla.org/network/simple-uri-mutator;1" */,
            ModuleID::Anonymous376,
          },
  
          {
            { 0x4aca } /* "@mozilla.org/network/protocol/about;1?what=support" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x4afd } /* "@mozilla.org/dom/localStorage-manager;1" */,
            ModuleID::Anonymous647,
          },
  
          {
            { 0x4b25 } /* "@mozilla.org/network/downloader;1" */,
            ModuleID::Anonymous346,
          },
  
          {
            { 0x4b47 } /* "@mozilla.org/variant;1" */,
            ModuleID::Anonymous615,
          },
  
          {
            { 0x4b5e } /* "@mozilla.org/hash-property-bag;1" */,
            ModuleID::Anonymous590,
          },
  
          {
            { 0x4b7f } /* "@mozilla.org/mime;1" */,
            ModuleID::Anonymous256,
          },
  
          {
            { 0x4b93 } /* "@mozilla.org/supports-PRUint64;1" */,
            ModuleID::Anonymous611,
          },
  
          {
            { 0x4bb4 } /* "@mozilla.org/messenger/account-manager;1" */,
            ModuleID::AccountManager,
          },
  
          {
            { 0x4bdd } /* "@mozilla.org/autocomplete/search;1?name=mydomain" */,
            ModuleID::Anonymous083,
          },
  
          {
            { 0x4c0e } /* "@mozilla.org/network/ldap-connection;1" */,
            ModuleID::Anonymous073,
          },
  
          {
            { 0x4c35 } /* "@mozilla.org/messenger/server;1?type=none" */,
            ModuleID::Anonymous208,
          },
  
          {
            { 0x4c5f } /* "@mozilla.org/integritypolicy;1" */,
            ModuleID::Anonymous641,
          },
  
          {
            { 0x4c7e } /* "@mozilla.org/nsMsgDatabase/msgDB-mailbox" */,
            ModuleID::Anonymous157,
          },
  
          {
            { 0x4ca7 } /* "@mozilla.org/messenger/mimeobject;1" */,
            ModuleID::Anonymous216,
          },
  
          {
            { 0x4ccb } /* "@mozilla.org/parentprocessmessagemanager;1" */,
            ModuleID::Anonymous670,
          },
  
          {
            { 0x4cf6 } /* "@mozilla.org/addressbook/cardproperty;1" */,
            ModuleID::Anonymous089,
          },
  
          {
            { 0x4d1e } /* "@mozilla.org/messenger/services/filters;1" */,
            ModuleID::Filter,
          },
  
          {
            { 0x4d48 } /* "@mozilla.org/peerconnection;1" */,
            ModuleID::Anonymous265,
          },
  
          {
            { 0x4d66 } /* "@mozilla.org/webvttParserWrapper;1" */,
            ModuleID::Anonymous282,
          },
  
          {
            { 0x4d89 } /* "@mozilla.org/spellchecker/personaldictionary;1" */,
            ModuleID::Anonymous308,
          },
  
          {
            { 0x4db8 } /* "@mozilla.org/txttohtmlconv;1" */,
            ModuleID::Anonymous391,
          },
  
          {
            { 0x4dd5 } /* "@mozilla.org/addressbook/abldifservice;1" */,
            ModuleID::Anonymous095,
          },
  
          {
            { 0x4dfe } /* "@mozilla.org/imap/offlinesync;1" */,
            ModuleID::Anonymous186,
          },
  
          {
            { 0x4e1e } /* "@mozilla.org/uriloader/content-handler;1?type=text/plain" */,
            ModuleID::Anonymous056,
          },
  
          {
            { 0x4e57 } /* "@mozilla.org/nsCertificateDialogs;1" */,
            ModuleID::Anonymous423,
          },
  
          {
            { 0x4e7b } /* "@mozilla.org/dom/indexeddb/manager;1" */,
            ModuleID::Anonymous263,
          },
  
          {
            { 0x4ea0 } /* "@mozilla.org/mime/pgp-mime-js-decrypt;1" */,
            ModuleID::Anonymous066,
          },
  
          {
            { 0x4ec8 } /* "@mozilla.org/inspector/deep-tree-walker;1" */,
            ModuleID::Anonymous658,
          },
  
          {
            { 0x4ef2 } /* "@mozilla.org/network/default-uri-mutator;1" */,
            ModuleID::Anonymous377,
          },
  
          {
            { 0x4f1d } /* "@mozilla.org/security/certstorage;1" */,
            ModuleID::Anonymous436,
          },
  
          {
            { 0x4f41 } /* "@mozilla.org/network/mime-input-stream;1" */,
            ModuleID::Anonymous356,
          },
  
          {
            { 0x4f6a } /* "@mozilla.org/network/protocol/about;1?what=memory" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x4f9c } /* "@mozilla.org/dom/rtpsender;1" */,
            ModuleID::Anonymous276,
          },
  
          {
            { 0x4fb9 } /* "@mozilla.org/security/sdr;1" */,
            ModuleID::Anonymous425,
          },
  
          {
            { 0x1002 } /* "@mozilla.org/dom/payments/payment-address;1" */,
            ModuleID::Anonymous291,
          },
  
          {
            { 0x4fd5 } /* "@mozilla.org/base/telemetry-startup;1" */,
            ModuleID::Anonymous527,
          },
  
          {
            { 0x4ffb } /* "@mozilla.org/network/http-activity-distributor;1" */,
            ModuleID::HttpActivityDistributor,
          },
  
          {
            { 0x502c } /* "@mozilla.org/webspeech/service;1?name=fake" */,
            ModuleID::Anonymous683,
          },
  
          {
            { 0x5057 } /* "@mozilla.org/browser/synced-bookmarks-merger;1" */,
            ModuleID::Anonymous511,
          },
  
          {
            { 0x1647 } /* "@mozilla.org/mimecth;1?type=text/vcard" */,
            ModuleID::Anonymous071,
          },
  
          {
            { 0x5086 } /* "@mozilla.org/base/telemetry;1" */,
            ModuleID::Anonymous529,
          },
  
          {
            { 0x50a4 } /* "@mozilla.org/network/protocol;1?name=moz-src" */,
            ModuleID::Anonymous368,
          },
  
          {
            { 0x50d1 } /* "@mozilla.org/network/file-input-stream;1" */,
            ModuleID::Anonymous347,
          },
  
          {
            { 0x50fa } /* "@mozilla.org/xpcom/debug;1" */,
            ModuleID::Anonymous585,
          },
  
          {
            { 0x5115 } /* "@mozilla.org/supports-PRInt32;1" */,
            ModuleID::Anonymous606,
          },
  
          {
            { 0x5135 } /* "@mozilla.org/toolkit/download-platform;1" */,
            ModuleID::DownloadPlatform,
          },
  
          {
            { 0x515e } /* "@mozilla.org/geolocation/mls-provider;1" */,
            ModuleID::Anonymous302,
          },
  
          {
            { 0x5186 } /* "@mozilla.org/messenger/messageservice;1?type=mailbox" */,
            ModuleID::Anonymous202,
          },
  
          {
            { 0x51bb } /* "@mozilla.org/categorymanager;1" */,
            ModuleID::CategoryManager,
          },
  
          {
            { 0x51da } /* "@mozilla.org/file/local;1" */,
            ModuleID::Anonymous592,
          },
  
          {
            { 0x51f4 } /* "@mozilla.org/autocomplete/search;1?name=ldap" */,
            ModuleID::Anonymous087,
          },
  
          {
            { 0x5221 } /* "@mozilla.org/network/protocol/about;1?what=cache-entry" */,
            ModuleID::Anonymous360,
          },
  
          {
            { 0x5258 } /* "@mozilla.org/messenger/messagecopyservice;1" */,
            ModuleID::Copy,
          },
  
          {
            { 0x5284 } /* "@mozilla.org/stopwatch;1" */,
            ModuleID::Anonymous125,
          },
  
          {
            { 0x529d } /* "@mozilla.org/streamconv;1?from=zstd&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x52d1 } /* "@mozilla.org/content-pref/service;1" */,
            ModuleID::Anonymous473,
          },
  
          {
            { 0x52f5 } /* "@mozilla.org/messenger/ews-client;1" */,
            ModuleID::Anonymous234,
          },
  
          {
            { 0x5319 } /* "@mozilla.org/mail/clh;1" */,
            ModuleID::Anonymous056,
          },
  
          {
            { 0x5331 } /* "@mozilla.org/messenger/msgAsyncPrompter;1" */,
            ModuleID::Anonymous097,
          },
  
          {
            { 0x535b } /* "@mozilla.org/calendar/timezone-service;1" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0xf6c } /* "@mozilla.org/dom/payments/general-response-data;1" */,
            ModuleID::Anonymous289,
          },
  
          {
            { 0x5384 } /* "@mozilla.org/calendar/duration;1" */,
            ModuleID::Anonymous011,
          },
  
          {
            { 0x53a5 } /* "@mozilla.org/network/protocol;1?name=moz-cal-handle-itip" */,
            ModuleID::Anonymous034,
          },
  
          {
            { 0x53de } /* "@mozilla.org/webnavigation-info;1" */,
            ModuleID::Anonymous255,
          },
  
          {
            { 0x5400 } /* "@mozilla.org/network/tls-server-socket;1" */,
            ModuleID::Anonymous382,
          },
  
          {
            { 0x5429 } /* "@mozilla.org/messenger/messageservice;1?type=mailbox-message" */,
            ModuleID::Anonymous202,
          },
  
          {
            { 0x5466 } /* "@mozilla.org/network/protocol/about;1?what=neterror" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x549a } /* "@mozilla.org/cookie-banner-rule;1" */,
            ModuleID::Anonymous474,
          },
  
          {
            { 0x54bc } /* "@mozilla.org/network/protocol/about;1?what=addons" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x54ee } /* "@mozilla.org/messenger/pop3-sink;1" */,
            ModuleID::Anonymous195,
          },
  
          {
            { 0x5511 } /* "@mozilla.org/jsctypes;1" */,
            ModuleID::Anonymous478,
          },
  
          {
            { 0x5529 } /* "@mozilla.org/cookieService;1" */,
            ModuleID::Anonymous401,
          },
  
          {
            { 0x5546 } /* "@mozilla.org/messengercompose/compose;1" */,
            ModuleID::Anonymous133,
          },
  
          {
            { 0x556e } /* "@mozilla.org/network/network-connectivity-service;1" */,
            ModuleID::Anonymous357,
          },
  
          {
            { 0x55a2 } /* "@mozilla.org/intl/converter-output-stream;1" */,
            ModuleID::Anonymous323,
          },
  
          {
            { 0x55ce } /* "@mozilla.org/network/replaced-http-response;1" */,
            ModuleID::Anonymous416,
          },
  
          {
            { 0x55fc } /* "@mozilla.org/network/protocol/about;1?what=rights" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x562e } /* "@mozilla.org/messenger/msgshutdownservice;1" */,
            ModuleID::Anonymous123,
          },
  
          {
            { 0x565a } /* "@mozilla.org/messenger/imaphostsessionlist;1" */,
            ModuleID::Anonymous182,
          },
  
          {
            { 0x5687 } /* "@mozilla.org/network/protocol;1?name=chrome" */,
            ModuleID::Anonymous589,
          },
  
          {
            { 0x56b3 } /* "@mozilla.org/network/binary-http;1" */,
            ModuleID::Anonymous413,
          },
  
          {
            { 0x7e3 } /* "@mozilla.org/messenger/content-policy;1" */,
            ModuleID::Anonymous122,
          },
  
          {
            { 0x56d6 } /* "@mozilla.org/security/clientAuthRememberService;1" */,
            ModuleID::Anonymous429,
          },
  
          {
            { 0x5708 } /* "@mozilla.org/media/wmfcdm-origins-list;1" */,
            ModuleID::Anonymous487,
          },
  
          {
            { 0x5731 } /* "@mozilla.org/network/url-parser;1?auth=yes" */,
            ModuleID::Anonymous386,
          },
  
          {
            { 0x575c } /* "@mozilla.org/url-classifier/channel-classifier-service;1" */,
            ModuleID::Anonymous417,
          },
  
          {
            { 0x5795 } /* "@mozilla.org/import/import-ab-file;1?type=mab" */,
            ModuleID::Anonymous187,
          },
  
          {
            { 0x1146 } /* "@mozilla.org/dom/payments/payment-show-action-response;1" */,
            ModuleID::Anonymous295,
          },
  
          {
            { 0x57c3 } /* "@mozilla.org/tools/profiler;1" */,
            ModuleID::Anonymous555,
          },
  
          {
            { 0xbe4 } /* "@mozilla.org/accountmanager/extension;1?name=mdn" */,
            ModuleID::Anonymous165,
          },
  
          {
            { 0x57e1 } /* "@mozilla.org/supports-PRInt16;1" */,
            ModuleID::Anonymous605,
          },
  
          {
            { 0x5801 } /* "@mozilla.org/messenger-mdn/generator;1" */,
            ModuleID::Anonymous166,
          },
  
          {
            { 0x5828 } /* "@mozilla.org/network/stream-loader;1" */,
            ModuleID::Anonymous380,
          },
  
          {
            { 0x584d } /* "@mozilla.org/third-party-cookie-blocking-exception-list-service;1" */,
            ModuleID::Anonymous409,
          },
  
          {
            { 0x588f } /* "@mozilla.org/network/protocol;1?name=moz-page-thumb" */,
            ModuleID::Anonymous365,
          },
  
          {
            { 0x58c3 } /* "@mozilla.org/chat/yahoo;1" */,
            ModuleID::Anonymous048,
          },
  
          {
            { 0x58dd } /* "@mozilla.org/network/oblivious-http-service;1" */,
            ModuleID::Anonymous415,
          },
  
          {
            { 0x590b } /* "@mozilla.org/supports-float;1" */,
            ModuleID::Anonymous602,
          },
  
          {
            { 0x12fd } /* "@mozilla.org/offline-startup;1" */,
            ModuleID::Anonymous169,
          },
  
          {
            { 0x5929 } /* "@mozilla.org/network/protocol/about;1?what=mozilla" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x595c } /* "@mozilla.org/addons/integration;1" */,
            ModuleID::Anonymous543,
          },
  
          {
            { 0x597e } /* "@mozilla.org/filepicker;1" */,
            ModuleID::Anonymous564,
          },
  
          {
            { 0x5998 } /* "@mozilla.org/storage/service;1" */,
            ModuleID::Anonymous447,
          },
  
          {
            { 0x59b7 } /* "@mozilla.org/network/protocol;1?name=pop" */,
            ModuleID::Anonymous199,
          },
  
          {
            { 0x59e0 } /* "@mozilla.org/network/protocol;1?name=page-icon" */,
            ModuleID::Anonymous510,
          },
  
          {
            { 0x5a0f } /* "@mozilla.org/network/sync-stream-listener;1" */,
            ModuleID::Anonymous129,
          },
  
          {
            { 0x5a3b } /* "@mozilla.org/uriloader/content-handler;1?type=application/x-mailto" */,
            ModuleID::Anonymous132,
          },
  
          {
            { 0x5a7e } /* "@mozilla.org/nsCMSDecoderJS;1" */,
            ModuleID::Anonymous174,
          },
  
          {
            { 0x5a9c } /* "@mozilla.org/network/protocol;1?name=cid" */,
            ModuleID::Anonymous121,
          },
  
          {
            { 0x5ac5 } /* "@mozilla.org/security/x509certdb;1" */,
            ModuleID::NSSCertificateDB,
          },
  
          {
            { 0x5ae8 } /* "@mozilla.org/chat/twitter;1" */,
            ModuleID::Anonymous046,
          },
  
          {
            { 0x5b04 } /* "@mozilla.org/mail/shell-service;1" */,
            ModuleID::Anonymous064,
          },
  
          {
            { 0x5b26 } /* "@mozilla.org/streamconv;1?from=multipart/mixed&to=*\/\*" */,
            ModuleID::Anonymous390,
          },
  
          {
            { 0x5b5c } /* "@mozilla.org/network/protocol;1?name=file" */,
            ModuleID::FileProtocolHandler,
          },
  
          {
            { 0x5b86 } /* "@mozilla.org/calendar/ics-serializer;1" */,
            ModuleID::Anonymous015,
          },
  
          {
            { 0x5bad } /* "@mozilla.org/messenger/outgoing/server;1?type=ews" */,
            ModuleID::Anonymous238,
          },
  
          {
            { 0x650 } /* "@mozilla.org/remote/marionette;1" */,
            ModuleID::Anonymous422,
          },
  
          {
            { 0x5bdf } /* "@mozilla.org/messenger/msgAuthPrompt;1" */,
            ModuleID::Anonymous098,
          },
  
          {
            { 0x5c06 } /* "@mozilla.org/addressbook/directory;1?type=jsaddrbook" */,
            ModuleID::Anonymous067,
          },
  
          {
            { 0x5c3b } /* "@mozilla.org/power/powermanagerservice;1" */,
            ModuleID::Anonymous296,
          },
  
          {
            { 0x5c64 } /* "@mozilla.org/messenger/noneservice;1" */,
            ModuleID::Anonymous204,
          },
  
          {
            { 0x5c89 } /* "@mozilla.org/messengercompose/attachmentdata;1" */,
            ModuleID::Anonymous139,
          },
  
          {
            { 0x5cb8 } /* "@mozilla.org/calendar/acl-manager;1?type=default" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0xb2f } /* "@mozilla.org/cookie-banner-service;1" */,
            ModuleID::CookieBannerService,
          },
  
          {
            { 0x5ce9 } /* "@mozilla.org/autocomplete/search;1?name=form-fill-controller" */,
            ModuleID::Anonymous522,
          },
  
          {
            { 0x167b } /* "@mozilla.org/mimecth;1?type=text/x-vcard" */,
            ModuleID::Anonymous072,
          },
  
          {
            { 0x5d26 } /* "@mozilla.org/services/settings;1" */,
            ModuleID::Anonymous445,
          },
  
          {
            { 0x5d47 } /* "@mozilla.org/messenger/msgwindow;1" */,
            ModuleID::Anonymous109,
          },
  
          {
            { 0x5d6a } /* "@mozilla.org/calendar/weekinfo-service;1" */,
            ModuleID::Anonymous026,
          },
  
          {
            { 0x5d93 } /* "@mozilla.org/messenger/protocol/info;1?type=im" */,
            ModuleID::Anonymous060,
          },
  
          {
            { 0xccc } /* "@mozilla.org/messenger/mimeemitter;1?type=raw" */,
            ModuleID::Anonymous221,
          },
  
          {
            { 0x5dc2 } /* "@mozilla.org/addressbook/jsaddrbookcard;1" */,
            ModuleID::Anonymous068,
          },
  
          {
            { 0x5dec } /* "@mozilla.org/calendar/manager;1" */,
            ModuleID::Anonymous008,
          },
  
          {
            { 0x5e0c } /* "@mozilla.org/network/url-parser;1?auth=maybe" */,
            ModuleID::Anonymous384,
          },
  
          {
            { 0x5e39 } /* "@mozilla.org/psm;1" */,
            ModuleID::NSSComponent,
          },
  
          {
            { 0x5e4c } /* "@mozilla.org/colorpicker;1" */,
            ModuleID::Anonymous560,
          },
  
          {
            { 0x5e67 } /* "@mozilla.org/xpcom/version-comparator;1" */,
            ModuleID::Anonymous616,
          },
  
          {
            { 0xc1e } /* "@mozilla.org/accountmanager/extension;1?name=newsblog" */,
            ModuleID::Anonymous168,
          },
  
          {
            { 0x5e8f } /* "@mozilla.org/private-attribution;1" */,
            ModuleID::PrivateAttribution,
          },
  
          {
            { 0x5eb2 } /* "@mozilla.org/messenger/structuredheaders;1" */,
            ModuleID::Anonymous215,
          },
  
          {
            { 0x5edd } /* "@mozilla.org/network/http-auth-manager;1" */,
            ModuleID::Anonymous350,
          },
  
          {
            { 0x5f06 } /* "@mozilla.org/wifi/monitor;1" */,
            ModuleID::WifiMonitor,
          },
  
          {
            { 0x5f22 } /* "@mozilla.org/network/socket-transport-service;1" */,
            ModuleID::SocketTransport,
          },
  
          {
            { 0x10f8 } /* "@mozilla.org/dom/payments/payment-request-service;1" */,
            ModuleID::Anonymous294,
          },
  
          {
            { 0x3c9c } /* "@mozilla.org/widget/clipboard;1" */,
            ModuleID::Anonymous558,
          },
  
          {
            { 0x5f52 } /* "@mozilla.org/gio-service;1" */,
            ModuleID::Anonymous547,
          },
  
          {
            { 0x5f6d } /* "@mozilla.org/messenger/msgdbview;1?type=watchedthreadswithunread" */,
            ModuleID::Anonymous113,
          },
  
          {
            { 0x5fae } /* "@mozilla.org/messenger/offline-manager;1" */,
            ModuleID::Anonymous118,
          },
  
          {
            { 0x5fd7 } /* "@mozilla.org/imap/autosyncmgr;1" */,
            ModuleID::Anonymous185,
          },
  
          {
            { 0x5ff7 } /* "@mozilla.org/applicationchooser;1" */,
            ModuleID::Anonymous576,
          },
  
          {
            { 0x6019 } /* "@mozilla.org/addressbook/ldap-attribute-map;1" */,
            ModuleID::Anonymous085,
          },
  
          {
            { 0x6047 } /* "@mozilla.org/network/protocol/about;1?what=newserror" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x607c } /* "@mozilla.org/network/protocol/about;1?what=cache" */,
            ModuleID::Anonymous359,
          },
  
          {
            { 0x60ad } /* "@mozilla.org/url-classifier/hashcompleter;1" */,
            ModuleID::Anonymous535,
          },
  
          {
            { 0x60d9 } /* "@mozilla.org/btp-remote-exception-list;1" */,
            ModuleID::Anonymous449,
          },
  
          {
            { 0x6102 } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/xml" */,
            ModuleID::Anonymous660,
          },
  
          {
            { 0x6143 } /* "@mozilla.org/network/protocol;1?name=indexeddb" */,
            ModuleID::Anonymous300,
          },
  
          {
            { 0x6172 } /* "@mozilla.org/messengercompose/mailtourl;1" */,
            ModuleID::Anonymous143,
          },
  
          {
            { 0x619c } /* "@mozilla.org/network/protocol/about;1?what=fingerprintingprotection" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x61e0 } /* "@mozilla.org/sandbox/syscall-reporter;1" */,
            ModuleID::Anonymous443,
          },
  
          {
            { 0x6208 } /* "@mozilla.org/zipwriter;1" */,
            ModuleID::Anonymous333,
          },
  
          {
            { 0x6221 } /* "@mozilla.org/addressbook/directory/query-arguments;1" */,
            ModuleID::Anonymous091,
          },
  
          {
            { 0x6256 } /* "@mozilla.org/mimecth;1?type=multipart/encrypted" */,
            ModuleID::Anonymous212,
          },
  
          {
            { 0x6286 } /* "@mozilla.org/network/protocol/about;1?what=devtools-toolbox" */,
            ModuleID::Anonymous249,
          },
  
          {
            { 0x62c2 } /* "@mozilla.org/messenger/protocol/info;1?type=ews" */,
            ModuleID::Anonymous233,
          },
  
          {
            { 0x62f2 } /* "@mozilla.org/messenger/msgdbview;1?type=threaded" */,
            ModuleID::Anonymous111,
          },
  
          {
            { 0x6323 } /* "@mozilla.org/toolkit/app-startup;1" */,
            ModuleID::AppStartup,
          },
  
          {
            { 0x6346 } /* "@mozilla.org/typeaheadfind;1" */,
            ModuleID::TypeAheadFind,
          },
  
          {
            { 0x6363 } /* "@mozilla.org/image/request;1" */,
            ModuleID::Anonymous312,
          },
  
          {
            { 0x6380 } /* "@mozilla.org/messengercompose/composeprogressparameters;1" */,
            ModuleID::Anonymous136,
          },
  
          {
            { 0x63ba } /* "@mozilla.org/chat/mochitest;1" */,
            ModuleID::Anonymous062,
          },
  
          {
            { 0x63d8 } /* "@mozilla.org/intl/stringbundle;1" */,
            ModuleID::StringBundle,
          },
  
          {
            { 0x12b4 } /* "@mozilla.org/EssentialDomainsRemoteSettings;1" */,
            ModuleID::Anonymous406,
          },
  
          {
            { 0x63f9 } /* "@mozilla.org/widget/parent/clipboard;1" */,
            ModuleID::Anonymous577,
          },
  
          {
            { 0x6420 } /* "@mozilla.org/appshell/component/browser-status-filter;1" */,
            ModuleID::Anonymous464,
          },
  
          {
            { 0x6458 } /* "@mozilla.org/network/background-file-saver;1?mode=outputstream" */,
            ModuleID::Anonymous340,
          },
  
          {
            { 0x6497 } /* "@mozilla.org/thumbnails/pagethumbs-service;1" */,
            ModuleID::PageThumbsStorage,
          },
  
          {
            { 0x64c4 } /* "@mozilla.org/security/pk11tokendb;1" */,
            ModuleID::Anonymous426,
          },
  
          {
            { 0x64e8 } /* "@mozilla.org/timer;1" */,
            ModuleID::Anonymous625,
          },
  
          {
            { 0x64fd } /* "@mozilla.org/mail/folder-factory;1?name=imap" */,
            ModuleID::Anonymous184,
          },
  
          {
            { 0x652a } /* "@mozilla.org/network/protocol;1?name=view-source" */,
            ModuleID::Anonymous369,
          },
  
          {
            { 0x1456 } /* "@mozilla.org/calendar/startup-service;1" */,
            ModuleID::Anonymous027,
          },
  
          {
            { 0x655b } /* "@mozilla.org/network/protocol/about;1?what=glean" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x658c } /* "@mozilla.org/messenger/messageservice;1?type=ews" */,
            ModuleID::Anonymous236,
          },
  
          {
            { 0x65bd } /* "@mozilla.org/widget/printdialog-service;1" */,
            ModuleID::Anonymous582,
          },
  
          {
            { 0x65e7 } /* "@mozilla.org/transactionmanager;1" */,
            ModuleID::Anonymous127,
          },
  
          {
            { 0x6609 } /* "@mozilla.org/systemprincipal;1" */,
            ModuleID::Anonymous677,
          },
  
          {
            { 0x6628 } /* "@mozilla.org/security/oskeystore;1" */,
            ModuleID::Anonymous434,
          },
  
          {
            { 0x664b } /* "@mozilla.org/dom/rtcstatsreport;1" */,
            ModuleID::Anonymous274,
          },
  
          {
            { 0x666d } /* "@mozilla.org/streamconv;1?from=multipart/byteranges&to=*\/\*" */,
            ModuleID::Anonymous390,
          },
  
          {
            { 0x66a8 } /* "@mozilla.org/msgDBView/msgDBViewService;1" */,
            ModuleID::DBView,
          },
  
          {
            { 0x66d2 } /* "@mozilla.org/main-process-singleton;1" */,
            ModuleID::Anonymous513,
          },
  
          {
            { 0x66f8 } /* "@mozilla.org/dom/rtcdtmfsender;1" */,
            ModuleID::Anonymous270,
          },
  
          {
            { 0x6719 } /* "@mozilla.org/messenger/services/session;1" */,
            ModuleID::MailSession,
          },
  
          {
            { 0x6743 } /* "@mozilla.org/autocomplete/search;1?name=login-doorhanger-password" */,
            ModuleID::Anonymous500,
          },
  
          {
            { 0x6785 } /* "@mozilla.org/websocketevent/service;1" */,
            ModuleID::Anonymous679,
          },
  
          {
            { 0x67ab } /* "@mozilla.org/network/protocol/about;1?what=url-classifier" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x67e5 } /* "@mozilla.org/network/protocol/about;1?what=crashcontent" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x681d } /* "@mozilla.org/toolkit/URLFormatterService;1" */,
            ModuleID::Anonymous537,
          },
  
          {
            { 0x6848 } /* "@mozilla.org/autocomplete/simple-result;1" */,
            ModuleID::Anonymous457,
          },
  
          {
            { 0x6872 } /* "@mozilla.org/network/protocol;1?name=http" */,
            ModuleID::HttpHandler,
          },
  
          {
            { 0x689c } /* "@mozilla.org/supports-PRTime;1" */,
            ModuleID::Anonymous608,
          },
  
          {
            { 0x68bb } /* "@mozilla.org/uriloader/handler-service;1" */,
            ModuleID::Anonymous253,
          },
  
          {
            { 0x68e4 } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/html" */,
            ModuleID::Anonymous662,
          },
  
          {
            { 0x691f } /* "@mozilla.org/calendar/alarm-service;1" */,
            ModuleID::Anonymous005,
          },
  
          {
            { 0x6945 } /* "@mozilla.org/network/protocol;1?name=moz-icon" */,
            ModuleID::Anonymous319,
          },
  
          {
            { 0x6973 } /* "@mozilla.org/network/protocol/about;1?what=crashgpu" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x69a7 } /* "@mozilla.org/calendar/relation;1" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x69c8 } /* "@mozilla.org/messenger/rssservice;1" */,
            ModuleID::Anonymous210,
          },
  
          {
            { 0x69ec } /* "@mozilla.org/appshell/appShellService;1" */,
            ModuleID::Anonymous627,
          },
  
          {
            { 0x6a14 } /* "@mozilla.org/messenger/statusfeedback;1" */,
            ModuleID::Anonymous108,
          },
  
          {
            { 0x6a3c } /* "@mozilla.org/browser/identity-credential-storage-service;1" */,
            ModuleID::IdentityCredentialStorageService,
          },
  
          {
            { 0x6a77 } /* "@mozilla.org/messengercompose/outgoingserverservice;1" */,
            ModuleID::OutgoingServer,
          },
  
          {
            { 0x6aad } /* "@mozilla.org/uriloader/dbus-handler-app;1" */,
            ModuleID::DBusHandlerApp,
          },
  
          {
            { 0x6ad7 } /* "@mozilla.org/url-classifier/listmanager;1" */,
            ModuleID::Anonymous534,
          },
  
          {
            { 0x6b01 } /* "@mozilla.org/gfx/content/screenmanager;1" */,
            ModuleID::Anonymous567,
          },
  
          {
            { 0x6b2a } /* "@mozilla.org/dom/createofferrequest;1" */,
            ModuleID::Anonymous278,
          },
  
          {
            { 0x6b50 } /* "@mozilla.org/messenger/mailviewlist;1" */,
            ModuleID::Anonymous164,
          },
  
          {
            { 0x6b76 } /* "@mozilla.org/network/ldap-url-parser;1" */,
            ModuleID::Anonymous079,
          },
  
          {
            { 0x5f4 } /* "@mozilla.org/messengercompose;1" */,
            ModuleID::Compose,
          },
  
          {
            { 0x6b9d } /* "@mozilla.org/calendar/freebusy-service;1" */,
            ModuleID::Anonymous013,
          },
  
          {
            { 0x6bc6 } /* "@mozilla.org/sound;1" */,
            ModuleID::Anonymous574,
          },
  
          {
            { 0x6bdb } /* "@mozilla.org/network/protocol/about;1?what=blank" */,
            ModuleID::Anonymous358,
          },
  
          {
            { 0x6c0c } /* "@mozilla.org/network/dns-service;1" */,
            ModuleID::DNS,
          },
  
          {
            { 0x6c2f } /* "@mozilla.org/messenger/outgoing/server;1?type=smtp" */,
            ModuleID::Anonymous153,
          },
  
          {
            { 0x6c62 } /* "@mozilla.org/memory-info-dumper;1" */,
            ModuleID::Anonymous593,
          },
  
          {
            { 0x6c84 } /* "@mozilla.org/intl/converter-input-stream;1" */,
            ModuleID::Anonymous322,
          },
  
          {
            { 0x6caf } /* "@mozilla.org/dom/quota-utils-service;1" */,
            ModuleID::Anonymous299,
          },
  
          {
            { 0x6cd6 } /* "@mozilla.org/content/plugin/document-loader-factory;1" */,
            ModuleID::Anonymous637,
          },
  
          {
            { 0x6d0c } /* "@mozilla.org/widget/content/clipboard;1" */,
            ModuleID::Anonymous559,
          },
  
          {
            { 0x6d34 } /* "@mozilla.org/network/protocol;1?name=ldaps" */,
            ModuleID::Anonymous081,
          },
  
          {
            { 0x6d5f } /* "@mozilla.org/network/udp-filter-handler;1?name=stun" */,
            ModuleID::Anonymous267,
          },
  
          {
            { 0x6d93 } /* "@mozilla.org/focus-manager;1" */,
            ModuleID::Anonymous654,
          },
  
          {
            { 0x6db0 } /* "@mozilla.org/autocomplete/search;1?name=search-autocomplete" */,
            ModuleID::Anonymous526,
          },
  
          {
            { 0x6dec } /* "@mozilla.org/chat/xmpp;1" */,
            ModuleID::Anonymous047,
          },
  
          {
            { 0x6e05 } /* "@mozilla.org/supports-cstring;1" */,
            ModuleID::Anonymous599,
          },
  
          {
            { 0x6e25 } /* "@mozilla.org/messenger/purgeService;1" */,
            ModuleID::Anonymous106,
          },
  
          {
            { 0x6e4b } /* "@mozilla.org/streamconv;1?from=application/vnd.mozilla.webext.unlocalized&to=text/css" */,
            ModuleID::Anonymous538,
          },
  
          {
            { 0x6ea1 } /* "@mozilla.org/storagestream;1" */,
            ModuleID::Anonymous598,
          },
  
          {
            { 0x6ebe } /* "@mozilla.org/network/load-group;1" */,
            ModuleID::Anonymous355,
          },
  
          {
            { 0x6ee0 } /* "@mozilla.org/url-classifier/jslib;1" */,
            ModuleID::Anonymous533,
          },
  
          {
            { 0x6f04 } /* "@mozilla.org/network/cors-preflight-cache;1" */,
            ModuleID::CORSPreflightCache,
          },
  
          {
            { 0x6f30 } /* "@mozilla.org/clear-data-service;1" */,
            ModuleID::Anonymous469,
          },
  
          {
            { 0x6f52 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=x-gzip" */,
            ModuleID::Anonymous332,
          },
  
          {
            { 0x6f88 } /* "@mozilla.org/streamconv;1?from=application/pdf&to=text/html" */,
            ModuleID::Anonymous501,
          },
  
          {
            { 0x6fc4 } /* "@mozilla.org/streamconv;1?from=message/rfc822&to=text/html" */,
            ModuleID::Anonymous217,
          },
  
          {
            { 0x6fff } /* "@mozilla.org/security/certoverride;1" */,
            ModuleID::Anonymous432,
          },
  
          {
            { 0x7024 } /* "@mozilla.org/widget/clipboardhelper;1" */,
            ModuleID::Anonymous578,
          },
  
          {
            { 0x1330 } /* "@mozilla.org/purge-tracker-service;1" */,
            ModuleID::Anonymous452,
          },
  
          {
            { 0x704a } /* "@mozilla.org/reputationservice/application-reputation-service;1" */,
            ModuleID::ApplicationReputation,
          },
  
          {
            { 0x708a } /* "@mozilla.org/messengercompose/send;1" */,
            ModuleID::Anonymous149,
          },
  
          {
            { 0x3c7e } /* "@mozilla.org/alerts-service;1" */,
            ModuleID::Alerts,
          },
  
          {
            { 0x70af } /* "@mozilla.org/network/protocol/about;1?what=serviceworkers" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x70e9 } /* "@mozilla.org/network/protocol;1?name=smtps" */,
            ModuleID::Anonymous151,
          },
  
          {
            { 0x7114 } /* "@mozilla.org/browser/history;1" */,
            ModuleID::History,
          },
  
          {
            { 0x7133 } /* "@mozilla.org/messengercompose/composesendlistener;1" */,
            ModuleID::Anonymous135,
          },
  
          {
            { 0x7167 } /* "@mozilla.org/embedcomp/rangefind;1" */,
            ModuleID::Anonymous550,
          },
  
          {
            { 0x718a } /* "@mozilla.org/messenger/imapurl;1" */,
            ModuleID::Anonymous179,
          },
  
          {
            { 0x71ab } /* "@mozilla.org/messenger/osintegration;1" */,
            ModuleID::Anonymous131,
          },
  
          {
            { 0x71d2 } /* "@mozilla.org/system-alerts-service;1" */,
            ModuleID::Anonymous548,
          },
  
          {
            { 0x71f7 } /* "@mozilla.org/streamConverters;1" */,
            ModuleID::StreamConverter,
          },
  
          {
            { 0x7217 } /* "@mozilla.org/network/protocol;1?name=about" */,
            ModuleID::Anonymous361,
          },
  
          {
            { 0x7242 } /* "@mozilla.org/push/PushManager;1" */,
            ModuleID::Anonymous297,
          },
  
          {
            { 0x7262 } /* "@mozilla.org/network/io-service;1" */,
            ModuleID::IO,
          },
  
          {
            { 0x7284 } /* "@mozilla.org/embedding/browser/nsWebBrowserPersist;1" */,
            ModuleID::Anonymous551,
          },
  
          {
            { 0x1520 } /* "@mozilla.org/cookie-banner-telemetry-service;1" */,
            ModuleID::Anonymous476,
          },
  
          {
            { 0x72b9 } /* "@mozilla.org/browser/credentialchooserservice;1" */,
            ModuleID::CredentialChooserService,
          },
  
          {
            { 0x82e } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
            ModuleID::Anonymous668,
          },
  
          {
            { 0x72e9 } /* "@mozilla.org/network/protocol;1?name=news" */,
            ModuleID::Anonymous228,
          },
  
          {
            { 0x7313 } /* "@mozilla.org/calendar/alarm-monitor;1" */,
            ModuleID::Anonymous004,
          },
  
          {
            { 0x1271 } /* "@mozilla.org/toolkit/crashmonitor;1" */,
            ModuleID::Anonymous477,
          },
  
          {
            { 0x7339 } /* "@mozilla.org/calendar/event;1" */,
            ModuleID::Anonymous012,
          },
  
          {
            { 0x7357 } /* "@mozilla.org/commandlinehandler/general-startup;1?type=compose" */,
            ModuleID::Compose,
          },
  
          {
            { 0x7396 } /* "@mozilla.org/messenger/msgdbview;1?type=group" */,
            ModuleID::Anonymous117,
          },
  
          {
            { 0x73c4 } /* "@mozilla.org/referrer-info;1" */,
            ModuleID::Anonymous666,
          },
  
          {
            { 0x73e1 } /* "@mozilla.org/content/colorpicker;1" */,
            ModuleID::Anonymous561,
          },
  
          {
            { 0x7404 } /* "@mozilla.org/gfx/devicecontextspec;1" */,
            ModuleID::Anonymous581,
          },
  
          {
            { 0x7429 } /* "@mozilla.org/chrome/chrome-registry;1" */,
            ModuleID::ChromeRegistry,
          },
  
          {
            { 0x744f } /* "@mozilla.org/embedcomp/default-tooltiptextprovider;1" */,
            ModuleID::Anonymous532,
          },
  
          {
            { 0x1741 } /* "@mozilla.org/browser/nav-history-service;1" */,
            ModuleID::Anonymous505,
          },
  
          {
            { 0x7484 } /* "@mozilla.org/calendar/itip-channel;1" */,
            ModuleID::Anonymous033,
          },
  
          {
            { 0x74a9 } /* "@mozilla.org/streamconv;1?from=message/rfc822&to=application/xhtml+xml" */,
            ModuleID::Anonymous217,
          },
  
          {
            { 0x74f0 } /* "@mozilla.org/network/protocol/about;1?what=debugging" */,
            ModuleID::Anonymous248,
          },
  
          {
            { 0x7525 } /* "@mozilla.org/login-manager/autocompletesearch;1" */,
            ModuleID::Anonymous495,
          },
  
          {
            { 0x7555 } /* "@mozilla.org/net/CachePurgeLock;1" */,
            ModuleID::Anonymous408,
          },
  
          {
            { 0x7577 } /* "@mozilla.org/network/protocol/about;1?what=logging" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x75aa } /* "@mozilla.org/xpcom/memory-watcher;1" */,
            ModuleID::Anonymous586,
          },
  
          {
            { 0x75ce } /* "@mozilla.org/network/stream-transport-service;1" */,
            ModuleID::StreamTransport,
          },
  
          {
            { 0x75fe } /* "@mozilla.org/messengercompose/smtpurl;1" */,
            ModuleID::Anonymous142,
          },
  
          {
            { 0x7626 } /* "@mozilla.org/content/style-sheet-service;1" */,
            ModuleID::Anonymous638,
          },
  
          {
            { 0x7651 } /* "@mozilla.org/jacppcomposedelegator;1" */,
            ModuleID::Anonymous190,
          },
  
          {
            { 0x7676 } /* "@mozilla.org/cookiemanager;1" */,
            ModuleID::Anonymous401,
          },
  
          {
            { 0x7693 } /* "@mozilla.org/mail/mailglue;1" */,
            ModuleID::Anonymous055,
          },
  
          {
            { 0x76b0 } /* "@mozilla.org/network/protocol/about;1?what=accountsetup" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x76e8 } /* "@mozilla.org/network/protocol;1?name=moz-extension" */,
            ModuleID::Anonymous364,
          },
  
          {
            { 0x771b } /* "@mozilla.org/messengercompose/sendreport;1" */,
            ModuleID::Anonymous148,
          },
  
          {
            { 0x7746 } /* "@mozilla.org/mail/folder-factory;1?name=mailbox" */,
            ModuleID::Anonymous205,
          },
  
          {
            { 0x7776 } /* "@mozilla.org/network/protocol/about;1?what=downloads" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x77ab } /* "@mozilla.org/uriloader/content-handler;1?type=application/x-xpinstall" */,
            ModuleID::Anonymous545,
          },
  
          {
            { 0x77f1 } /* "@mozilla.org/mozintlhelper;1" */,
            ModuleID::Anonymous490,
          },
  
          {
            { 0x780e } /* "@mozilla.org/prefetch-service;1" */,
            ModuleID::Prefetch,
          },
  
          {
            { 0x782e } /* "@mozilla.org/network/protocol/about;1?what=srcdoc" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x7860 } /* "@mozilla.org/jsdebugger;1" */,
            ModuleID::Anonymous246,
          },
  
          {
            { 0x787a } /* "@mozilla.org/widget/taskbarprogress/gtk;1" */,
            ModuleID::Anonymous570,
          },
  
          {
            { 0x78a4 } /* "@mozilla.org/xre/runtime;1" */,
            ModuleID::XULRuntime,
          },
  
          {
            { 0x78bf } /* "@mozilla.org/embedcomp/dialogparam;1" */,
            ModuleID::Anonymous553,
          },
  
          {
            { 0x78e4 } /* "@mozilla.org/file/directory_service;1" */,
            ModuleID::Directory,
          },
  
          {
            { 0x790a } /* "@mozilla.org/intl/localeservice;1" */,
            ModuleID::Locale,
          },
  
          {
            { 0x792c } /* "@mozilla.org/network/protocol/about;1?what=policies" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x7960 } /* "@mozilla.org/network/protocol/about;1?what=accountsettings" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x799b } /* "@mozilla.org/network/protocol/about;1?what=performance" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x79d2 } /* "@mozilla.org/security/nsCertTree;1" */,
            ModuleID::Anonymous438,
          },
  
          {
            { 0x791 } /* "@mozilla.org/image-blocker-content-policy;1" */,
            ModuleID::Anonymous311,
          },
  
          {
            { 0x79f5 } /* "@mozilla.org/partitioning/exception-list-service;1" */,
            ModuleID::Anonymous453,
          },
  
          {
            { 0x7a28 } /* "@mozilla.org/messenger/protocol/info;1?type=testja" */,
            ModuleID::Anonymous194,
          },
  
          {
            { 0x7a5b } /* "@mozilla.org/messenger/protocol/info;1?type=nntp" */,
            ModuleID::Anonymous224,
          },
  
          {
            { 0x7a8c } /* "@mozilla.org/messenger/protocol/info;1?type=none" */,
            ModuleID::Anonymous204,
          },
  
          {
            { 0x7abd } /* "@mozilla.org/docshell/structured-clone-container;1" */,
            ModuleID::Anonymous646,
          },
  
          {
            { 0x7af0 } /* "@mozilla.org/autocomplete/search;1?name=places-tag-autocomplete" */,
            ModuleID::Anonymous507,
          },
  
          {
            { 0x4b0 } /* "@mozilla.org/calendar/export;1?type=htmllist" */,
            ModuleID::Anonymous031,
          },
  
          {
            { 0x7b30 } /* "@mozilla.org/content-blocking-allow-list;1" */,
            ModuleID::Anonymous472,
          },
  
          {
            { 0x80b } /* "@mozilla.org/mixedcontentblocker;1" */,
            ModuleID::Anonymous665,
          },
  
          {
            { 0x45a } /* "@mozilla.org/extensions/web-navigation-content;1" */,
            ModuleID::Anonymous483,
          },
  
          {
            { 0x7b5b } /* "@mozilla.org/network/standard-url-mutator;1" */,
            ModuleID::Anonymous378,
          },
  
          {
            { 0x7b87 } /* "@mozilla.org/uriloader/content-handler;1?type=application/x-message-display" */,
            ModuleID::Anonymous057,
          },
  
          {
            { 0x7bd3 } /* "@mozilla.org/remote;1" */,
            ModuleID::Anonymous517,
          },
  
          {
            { 0x7be9 } /* "@mozilla.org/gfx/parent/screenmanager;1" */,
            ModuleID::Anonymous569,
          },
  
          {
            { 0x7c11 } /* "@mozilla.org/mediaManagerService;1" */,
            ModuleID::Anonymous664,
          },
  
          {
            { 0x7c34 } /* "@mozilla.org/binaryoutputstream;1" */,
            ModuleID::Anonymous588,
          },
  
          {
            { 0x7c56 } /* "@mozilla.org/network/protocol/about;1?what=3pane" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x7c87 } /* "@mozilla.org/streamconv;1?from=compress&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x7cbf } /* "@mozilla.org/memory-reporter-manager;1" */,
            ModuleID::Anonymous594,
          },
  
          {
            { 0x36a } /* "@mozilla.org/mailnews/document-loader-factory;1" */,
            ModuleID::Anonymous126,
          },
  
          {
            { 0x7ce6 } /* "@mozilla.org/messenger/server;1?type=nntp" */,
            ModuleID::Anonymous223,
          },
  
          {
            { 0x7d10 } /* "@mozilla.org/dom/slow-script-debug;1" */,
            ModuleID::Anonymous260,
          },
  
          {
            { 0x1615 } /* "@mozilla.org/calendar/mime-converter;1" */,
            ModuleID::Anonymous028,
          },
  
          {
            { 0x7d35 } /* "@mozilla.org/security/transportsecurityinfo;1" */,
            ModuleID::Anonymous433,
          },
  
          {
            { 0x7d63 } /* "@mozilla.org/mail/auth-module;1" */,
            ModuleID::Anonymous100,
          },
  
          {
            { 0x7d83 } /* "@mozilla.org/policycontainer;1" */,
            ModuleID::Anonymous643,
          },
  
          {
            { 0x7da2 } /* "@mozilla.org/login-detection-service;1" */,
            ModuleID::Anonymous264,
          },
  
          {
            { 0x7dc9 } /* "@mozilla.org/calendar/period;1" */,
            ModuleID::Anonymous018,
          },
  
          {
            { 0x7de8 } /* "@mozilla.org/text-input-processor;1" */,
            ModuleID::Anonymous678,
          },
  
          {
            { 0x7e0c } /* "@mozilla.org/permissiondelegatehandler;1" */,
            ModuleID::Anonymous304,
          },
  
          {
            { 0x7e35 } /* "@mozilla.org/abmanager;1" */,
            ModuleID::AbManager,
          },
  
          {
            { 0x7e4e } /* "@mozilla.org/messenger/msgnotificationservice;1" */,
            ModuleID::FolderNotification,
          },
  
          {
            { 0x7e7e } /* "@mozilla.org/pref-override-map;1" */,
            ModuleID::Anonymous335,
          },
  
          {
            { 0x7e9f } /* "@mozilla.org/system-proxy-settings;1" */,
            ModuleID::Anonymous549,
          },
  
          {
            { 0x7ec4 } /* "@mozilla.org/streamconv;1?from=application/vnd.mozilla.json.view&to=*\/\*" */,
            ModuleID::Anonymous244,
          },
  
          {
            { 0x7f0c } /* "@mozilla.org/cspcontext;1" */,
            ModuleID::Anonymous639,
          },
  
          {
            { 0xe8b } /* "@mozilla.org/dom/payments/basiccard-change-details;1" */,
            ModuleID::Anonymous286,
          },
  
          {
            { 0x7f26 } /* "@mozilla.org/layout/contentserializer;1?mimetype=image/svg+xml" */,
            ModuleID::Anonymous660,
          },
  
          {
            { 0x7f65 } /* "@mozilla.org/login-manager/authprompter;1" */,
            ModuleID::Anonymous496,
          },
  
          {
            { 0x7f8f } /* "@mozilla.org/geolocation/provider;1" */,
            ModuleID::Anonymous302,
          },
  
          {
            { 0x7fb3 } /* "@mozilla.org/messenger/msgdbview;1?type=xfvf" */,
            ModuleID::Anonymous116,
          },
  
          {
            { 0x7fe0 } /* "@mozilla.org/embedcomp/prompt-collection;1" */,
            ModuleID::Anonymous063,
          },
  
          {
            { 0x800b } /* "@mozilla.org/jacppurldelegator;1" */,
            ModuleID::Anonymous193,
          },
  
          {
            { 0xfb9 } /* "@mozilla.org/dom/payments/payment-abort-action-response;1" */,
            ModuleID::Anonymous290,
          },
  
          {
            { 0x802c } /* "@mozilla.org/charset-converter-manager;1" */,
            ModuleID::Anonymous188,
          },
  
          {
            { 0x8055 } /* "@mozilla.org/messenger/searchSession;1" */,
            ModuleID::Anonymous240,
          },
  
          {
            { 0x807c } /* "@mozilla.org/addons/content-policy;1" */,
            ModuleID::AddonContentPolicy,
          },
  
          {
            { 0x80a1 } /* "@mozilla.org/messengercompose/msgcopy;1" */,
            ModuleID::Anonymous147,
          },
  
          {
            { 0x80c9 } /* "@mozilla.org/process/environment;1" */,
            ModuleID::Anonymous624,
          },
  
          {
            { 0x80ec } /* "@mozilla.org/prompter;1" */,
            ModuleID::Anonymous515,
          },
  
          {
            { 0x8104 } /* "@mozilla.org/messenger/identity;1" */,
            ModuleID::Anonymous104,
          },
  
          {
            { 0x155c } /* "@mozilla.org/rfp-service;1" */,
            ModuleID::RFPService,
          },
  
          {
            { 0x8126 } /* "@mozilla.org/http-sfv-service;1" */,
            ModuleID::Anonymous402,
          },
  
          {
            { 0x8146 } /* "@mozilla.org/login-manager;1" */,
            ModuleID::Anonymous493,
          },
  
          {
            { 0x8163 } /* "@mozilla.org/streamconv;1?from=x-compress&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x819d } /* "@mozilla.org/network/native-dns-override;1" */,
            ModuleID::Anonymous345,
          },
  
          {
            { 0x81c8 } /* "@mozilla.org/parental-controls-service;1" */,
            ModuleID::Anonymous465,
          },
  
          {
            { 0x1414 } /* "@mozilla.org/url-query-string-stripper;1" */,
            ModuleID::URLQueryStringStripper,
          },
  
          {
            { 0x81f1 } /* "@mozilla.org/jacppincomingserverdelegator;1" */,
            ModuleID::Anonymous191,
          },
  
          {
            { 0x821d } /* "@mozilla.org/ldapsyncquery;1" */,
            ModuleID::Anonymous082,
          },
  
          {
            { 0x823a } /* "@mozilla.org/fingerprinting-override;1" */,
            ModuleID::Anonymous518,
          },
  
          {
            { 0x8261 } /* "@mozilla.org/observer-service;1" */,
            ModuleID::Observer,
          },
  
          {
            { 0x8281 } /* "@mozilla.org/uriloader/web-handler-app;1" */,
            ModuleID::Anonymous557,
          },
  
          {
            { 0x82aa } /* "@mozilla.org/messengercompose/sendlater;1" */,
            ModuleID::Anonymous141,
          },
  
          {
            { 0x82d4 } /* "@mozilla.org/addressbook/directoryproperty;1" */,
            ModuleID::Anonymous090,
          },
  
          {
            { 0x8301 } /* "@mozilla.org/network/network-link-service;1" */,
            ModuleID::Anonymous407,
          },
  
          {
            { 0x832d } /* "@mozilla.org/network/well-known-opportunistic-utils;1" */,
            ModuleID::Anonymous412,
          },
  
          {
            { 0x8363 } /* "@mozilla.org/thirdpartyutil;1" */,
            ModuleID::ThirdPartyUtil,
          },
  
          {
            { 0x8381 } /* "@mozilla.org/processtools-service;1" */,
            ModuleID::Anonymous514,
          },
  
          {
            { 0x83a5 } /* "@mozilla.org/messenger/tagservice;1" */,
            ModuleID::Tag,
          },
  
          {
            { 0x104b } /* "@mozilla.org/dom/payments/payment-canmake-action-response;1" */,
            ModuleID::Anonymous292,
          },
  
          {
            { 0x83c9 } /* "@mozilla.org/startupcacheinfo;1" */,
            ModuleID::Anonymous446,
          },
  
          {
            { 0x83e9 } /* "@mozilla.org/network/protocol;1?name=mailto" */,
            ModuleID::Anonymous152,
          },
  
          {
            { 0x8415 } /* "@mozilla.org/clear-by-site-entry;1" */,
            ModuleID::Anonymous470,
          },
  
          {
            { 0x8438 } /* "@mozilla.org/messenger/mailboxurl;1" */,
            ModuleID::Anonymous200,
          },
  
          {
            { 0x845c } /* "@mozilla.org/nsMsgDatabase/msgDB-news" */,
            ModuleID::Anonymous158,
          },
  
          {
            { 0x8482 } /* "@mozilla.org/mail/folder-factory;1?name=news" */,
            ModuleID::Anonymous231,
          },
  
          {
            { 0x84af } /* "@mozilla.org/network/url-parser;1?auth=no" */,
            ModuleID::Anonymous385,
          },
  
          {
            { 0x84d9 } /* "@mozilla.org/supports-string;1" */,
            ModuleID::Anonymous613,
          },
  
          {
            { 0x84f8 } /* "@mozilla.org/thread-manager;1" */,
            ModuleID::Anonymous614,
          },
  
          {
            { 0x8516 } /* "@mozilla.org/streamconv;1?from=application/octet-stream&to=*\/\*" */,
            ModuleID::Anonymous501,
          },
  
          {
            { 0x8be } /* "@mozilla.org/base/telemetry-controller-content;1" */,
            ModuleID::Anonymous528,
          },
  
          {
            { 0x8555 } /* "@mozilla.org/network/protocol/about;1?what=logo" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x8585 } /* "@mozilla.org/dom/rtpreceiver;1" */,
            ModuleID::Anonymous277,
          },
  
          {
            { 0x85a4 } /* "@mozilla.org/places/previews-helper;1" */,
            ModuleID::PlacesPreviewsHelper,
          },
  
          {
            { 0x85ca } /* "@mozilla.org/url-classifier/utils;1" */,
            ModuleID::UrlClassifierUtils,
          },
  
          {
            { 0x85ee } /* "@mozilla.org/supports-PRUint32;1" */,
            ModuleID::Anonymous610,
          },
  
          {
            { 0x860f } /* "@mozilla.org/tracking-db-service;1" */,
            ModuleID::Anonymous450,
          },
  
          {
            { 0x8632 } /* "@mozilla.org/gfx/printsettings-service;1" */,
            ModuleID::Anonymous583,
          },
  
          {
            { 0x865b } /* "@mozilla.org/serviceworkers/manager;1" */,
            ModuleID::ServiceWorkerManager,
          },
  
          {
            { 0x8681 } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/plain" */,
            ModuleID::Anonymous663,
          },
  
          {
            { 0x86bd } /* "@mozilla.org/network/input-stream-channel;1" */,
            ModuleID::Anonymous353,
          },
  
          {
            { 0x86e9 } /* "@mozilla.org/addressbook/directory-query/proxy;1" */,
            ModuleID::Anonymous094,
          },
  
          {
            { 0x871a } /* "@mozilla.org/msgFolder/msgFolderService;1" */,
            ModuleID::Folder,
          },
  
          {
            { 0x8744 } /* "@mozilla.org/nss_errors_service;1" */,
            ModuleID::NSSErrors,
          },
  
          {
            { 0x8766 } /* "@mozilla.org/widget/parent/dragservice;1" */,
            ModuleID::Anonymous579,
          },
  
          {
            { 0x878f } /* "@mozilla.org/push/Notifier;1" */,
            ModuleID::Anonymous673,
          },
  
          {
            { 0x87ac } /* "@mozilla.org/uriloader/content-handler;1?type=application/x-itip-internal" */,
            ModuleID::Anonymous035,
          },
  
          {
            { 0x87f6 } /* "@mozilla.org/calendar/alarm;1" */,
            ModuleID::Anonymous003,
          },
  
          {
            { 0x8814 } /* "@mozilla.org/scriptableinputstream;1" */,
            ModuleID::Anonymous622,
          },
  
          {
            { 0x8839 } /* "@mozilla.org/dom/peerconnectionobserver;1" */,
            ModuleID::Anonymous269,
          },
  
          {
            { 0x7bd } /* "@mozilla.org/integritypolicyservice;1" */,
            ModuleID::Anonymous642,
          },
  
          {
            { 0x8863 } /* "@mozilla.org/calendar/itip-item;1" */,
            ModuleID::Anonymous017,
          },
  
          {
            { 0x8885 } /* "@mozilla.org/network/tcp-filter-handler;1?name=stun" */,
            ModuleID::Anonymous266,
          },
  
          {
            { 0x88b9 } /* "@mozilla.org/messenger/nntpservice;1" */,
            ModuleID::Anonymous225,
          },
  
          {
            { 0x88de } /* "@mozilla.org/activity-manager-ui;1" */,
            ModuleID::Anonymous053,
          },
  
          {
            { 0x8901 } /* "@mozilla.org/url-classifier/list-service;1" */,
            ModuleID::Anonymous536,
          },
  
          {
            { 0x419 } /* "@mozilla.org/satchel/form-fill-controller;1" */,
            ModuleID::Anonymous522,
          },
  
          {
            { 0x892c } /* "@mozilla.org/network/protocol/about;1?what=httpsonlyerror" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x8966 } /* "@mozilla.org/messenger/imapmockchannel;1" */,
            ModuleID::Anonymous181,
          },
  
          {
            { 0x67a } /* "@mozilla.org/remote/agent;1" */,
            ModuleID::Anonymous421,
          },
  
          {
            { 0x1702 } /* "@mozilla.org/synthspeechdispatcher;1" */,
            ModuleID::Anonymous280,
          },
  
          {
            { 0x898f } /* "@mozilla.org/eventlistenerservice;1" */,
            ModuleID::Anonymous652,
          },
  
          {
            { 0x89b3 } /* "@mozilla.org/securityconsole/message;1" */,
            ModuleID::Anonymous597,
          },
  
          {
            { 0x89da } /* "@mozilla.org/binaryinputstream;1" */,
            ModuleID::Anonymous587,
          },
  
          {
            { 0xae4 } /* "@mozilla.org/url-classifier/exception-list-service;1" */,
            ModuleID::Anonymous418,
          },
  
          {
            { 0x89fb } /* "@mozilla.org/network/protocol/about;1?what=checkerboard" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x8a33 } /* "@mozilla.org/addressbook/msgvcardservice;1" */,
            ModuleID::Anonymous070,
          },
  
          {
            { 0x8a5e } /* "@mozilla.org/network/safe-file-output-stream;1" */,
            ModuleID::Anonymous372,
          },
  
          {
            { 0x8a8d } /* "@mozilla.org/key-value-service;1" */,
            ModuleID::Anonymous485,
          },
  
          {
            { 0x8aae } /* "@mozilla.org/transfer;1" */,
            ModuleID::Anonymous479,
          },
  
          {
            { 0x8ac6 } /* "@mozilla.org/activity-event;1" */,
            ModuleID::Anonymous050,
          },
  
          {
            { 0x8ae4 } /* "@mozilla.org/passwordmanager/authpromptfactory;1" */,
            ModuleID::Anonymous494,
          },
  
          {
            { 0x4ee } /* "@mozilla.org/calendar/export;1?type=ics" */,
            ModuleID::Anonymous030,
          },
  
          {
            { 0x8b15 } /* "@mozilla.org/jsreflect;1" */,
            ModuleID::Anonymous516,
          },
  
          {
            { 0x8b2e } /* "@mozilla.org/streamconv;1?from=application/x-unknown-content-type&to=*\/\*" */,
            ModuleID::Anonymous388,
          },
  
          {
            { 0x8b77 } /* "@mozilla.org/network/protocol/about;1?what=import" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x8ba9 } /* "@mozilla.org/messengercompose/computils;1" */,
            ModuleID::Anonymous146,
          },
  
          {
            { 0x8bd3 } /* "@mozilla.org/network/protocol;1?name=resource" */,
            ModuleID::Anonymous367,
          },
  
          {
            { 0x8c01 } /* "@mozilla.org/uriloader/local-handler-app;1" */,
            ModuleID::Anonymous254,
          },
  
          {
            { 0x8c2c } /* "@mozilla.org/network-error-logging;1" */,
            ModuleID::NetworkErrorLogging,
          },
  
          {
            { 0x9cb } /* "@mozilla.org/content-blocking-telemetry-service;1" */,
            ModuleID::Anonymous454,
          },
  
          {
            { 0x8c51 } /* "@mozilla.org/mime/pgp-mime-decrypt;1" */,
            ModuleID::Anonymous213,
          },
  
          {
            { 0x8c76 } /* "@mozilla.org/streamconv;1?from=multipart/x-mixed-replace&to=*\/\*" */,
            ModuleID::Anonymous390,
          },
  
          {
            { 0x8cb6 } /* "@mozilla.org/security/ClientAuthDialogService;1" */,
            ModuleID::Anonymous441,
          },
  
          {
            { 0x8ce6 } /* "@mozilla.org/streamconv;1?from=application/octet-stream&to=text/html" */,
            ModuleID::Anonymous501,
          },
  
          {
            { 0x8d2b } /* "@mozilla.org/security/random-generator;1" */,
            ModuleID::RandomGenerator,
          },
  
          {
            { 0x8d54 } /* "@mozilla.org/db/mork;1" */,
            ModuleID::Anonymous156,
          },
  
          {
            { 0x8d6b } /* "@mozilla.org/security/CRLiteTimestamp;1" */,
            ModuleID::Anonymous439,
          },
  
          {
            { 0x8d93 } /* "@mozilla.org/appshell/component/messenger;1" */,
            ModuleID::Anonymous101,
          },
  
          {
            { 0x8dbf } /* "@mozilla.org/image/encoder;2?type=image/jpeg" */,
            ModuleID::Anonymous316,
          },
  
          {
            { 0x8dec } /* "@mozilla.org/cascade-filter;1" */,
            ModuleID::Anonymous468,
          },
  
          {
            { 0x5c4 } /* "@mozilla.org/backgroundtasksmanager;1" */,
            ModuleID::Anonymous459,
          },
  
          {
            { 0x8e0a } /* "@mozilla.org/network/protocol;1?name=moz-safe-about" */,
            ModuleID::Anonymous366,
          },
  
          {
            { 0x16cb } /* "@mozilla.org/fakesynth;1" */,
            ModuleID::Anonymous281,
          },
  
          {
            { 0xca9 } /* "@mozilla.org/gloda/jsmimeemitter;1" */,
            ModuleID::Anonymous155,
          },
  
          {
            { 0x3e6 } /* "@mozilla.org/extensions/child;1" */,
            ModuleID::Anonymous481,
          },
  
          {
            { 0x8e3e } /* "@mozilla.org/io/string-input-stream;1" */,
            ModuleID::Anonymous623,
          },
  
          {
            { 0x8e64 } /* "@mozilla.org/security/datastoragemanager;1" */,
            ModuleID::Anonymous440,
          },
  
          {
            { 0x8e8f } /* "@mozilla.org/network/ldap-service;1" */,
            ModuleID::Anonymous078,
          },
  
          {
            { 0x8eb3 } /* "@mozilla.org/layout/content-policy;1" */,
            ModuleID::Anonymous659,
          },
  
          {
            { 0x8ed8 } /* "@mozilla.org/streamconv;1?from=br&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x8f0a } /* "@mozilla.org/network/simple-stream-listener;1" */,
            ModuleID::Anonymous375,
          },
  
          {
            { 0x8f38 } /* "@mozilla.org/network/protocol;1?name=moz" */,
            ModuleID::Anonymous492,
          },
  
          {
            { 0x8f61 } /* "@mozilla.org/moz/jssubscript-loader;1" */,
            ModuleID::Anonymous326,
          },
  
          {
            { 0x8f87 } /* "@mozilla.org/activity-warning;1" */,
            ModuleID::Anonymous051,
          },
  
          {
            { 0x8fa7 } /* "@mozilla.org/calendar/timezone-database;1" */,
            ModuleID::Anonymous001,
          },
  
          {
            { 0x8fd1 } /* "@mozilla.org/synth-voice-registry;1" */,
            ModuleID::Anonymous681,
          },
  
          {
            { 0x8ff5 } /* "@mozilla.org/calendar/recurrence-date;1" */,
            ModuleID::Anonymous021,
          },
  
          {
            { 0xdbc } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
            ModuleID::Anonymous243,
          },
  
          {
            { 0x901d } /* "@mozilla.org/nsMsgDatabase/msgDB-imap" */,
            ModuleID::Anonymous159,
          },
  
          {
            { 0x9043 } /* "@mozilla.org/consoleAPI-storage;1" */,
            ModuleID::Anonymous261,
          },
  
          {
            { 0x9065 } /* "@mozilla.org/supports-PRBool;1" */,
            ModuleID::Anonymous604,
          },
  
          {
            { 0x9084 } /* "@mozilla.org/uriclassifierservice" */,
            ModuleID::UrlClassifierDB,
          },
  
          {
            { 0x6a0 } /* "@mozilla.org/uriloader/content-handler;1?type=text/html" */,
            ModuleID::Anonymous056,
          },
  
          {
            { 0x90a6 } /* "@mozilla.org/msgDatabase/retentionSettings;1" */,
            ModuleID::Anonymous160,
          },
  
          {
            { 0x90d3 } /* "@mozilla.org/toolkit/profile-migrator;1" */,
            ModuleID::Anonymous058,
          },
  
          {
            { 0x90fb } /* "@mozilla.org/streamconv;1?from=message/rfc822&to=*\/\*" */,
            ModuleID::Anonymous217,
          },
  
          {
            { 0x9130 } /* "@mozilla.org/query-stripping-list-service;1" */,
            ModuleID::Anonymous455,
          },
  
          {
            { 0x915c } /* "@mozilla.org/xre/directory-provider;1" */,
            ModuleID::Anonymous552,
          },
  
          {
            { 0x9182 } /* "@mozilla.org/network/effective-tld-service;1" */,
            ModuleID::EffectiveTLD,
          },
  
          {
            { 0x91af } /* "@mozilla.org/toolkit/profile-service;1" */,
            ModuleID::Anonymous554,
          },
  
          {
            { 0x91d6 } /* "@mozilla.org/messenger/mimeconverter;1" */,
            ModuleID::MimeConverter,
          },
  
          {
            { 0x584 } /* "@mozilla.org/messenger/devtools-startup-clh;1" */,
            ModuleID::Anonymous059,
          },
  
          {
            { 0x179e } /* "@mozilla.org/mail/dir-provider;1" */,
            ModuleID::Anonymous124,
          },
  
          {
            { 0x91fd } /* "@mozilla.org/messenger/msgFolderCache;1" */,
            ModuleID::Anonymous107,
          },
  
          {
            { 0x9225 } /* "@mozilla.org/network/protocol/about;1?what=profiles" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x9259 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=rawdeflate" */,
            ModuleID::Anonymous332,
          },
  
          {
            { 0x9293 } /* "@mozilla.org/third-party-cookie-exception-entry;1" */,
            ModuleID::Anonymous410,
          },
  
          {
            { 0x92c5 } /* "@mozilla.org/mailnews/virtual-folder-wrapper;1" */,
            ModuleID::Anonymous130,
          },
  
          {
            { 0x92f4 } /* "@mozilla.org/browser/identitycredentialpromptservice;1" */,
            ModuleID::IdentityCredentialPromptService,
          },
  
          {
            { 0x932b } /* "@mozilla.org/supports-char;1" */,
            ModuleID::Anonymous600,
          },
  
          {
            { 0x9348 } /* "@mozilla.org/timer-manager;1" */,
            ModuleID::Anonymous626,
          },
  
          {
            { 0x9365 } /* "@mozilla.org/autocomplete/controller;1" */,
            ModuleID::Anonymous456,
          },
  
          {
            { 0x938c } /* "@mozilla.org/security/nssversion;1" */,
            ModuleID::Anonymous424,
          },
  
          {
            { 0x93af } /* "@mozilla.org/security/pkcs11moduledb;1" */,
            ModuleID::Anonymous427,
          },
  
          {
            { 0x93d6 } /* "@mozilla.org/network/mock-network-controller;1" */,
            ModuleID::Anonymous405,
          },
  
          {
            { 0x9405 } /* "@mozilla.org/mail/folder;1?name=mailbox" */,
            ModuleID::Anonymous205,
          },
  
          {
            { 0x1c5 } /* "@mozilla.org/content-viewers/http-index-format" */,
            ModuleID::Anonymous539,
          },
  
          {
            { 0x942d } /* "@mozilla.org/network/stream-listener-tee;1" */,
            ModuleID::Anonymous379,
          },
  
          {
            { 0x9458 } /* "@mozilla.org/messengercompose/composefields;1" */,
            ModuleID::Anonymous137,
          },
  
          {
            { 0x9486 } /* "@mozilla.org/messenger-smime/smime-encrypted-uris-service;1" */,
            ModuleID::Anonymous171,
          },
  
          {
            { 0x94c2 } /* "@mozilla.org/messenger/popurl;1" */,
            ModuleID::Anonymous203,
          },
  
          {
            { 0x17e2 } /* "@mozilla.org/network/protocol;1?name=moz-gio" */,
            ModuleID::Anonymous411,
          },
  
          {
            { 0x94e2 } /* "@mozilla.org/gfx/fontenumerator;1" */,
            ModuleID::Anonymous309,
          },
  
          {
            { 0xe22 } /* "@mozilla.org/network/binary-detector;1" */,
            ModuleID::Anonymous342,
          },
  
          {
            { 0x9504 } /* "@mozilla.org/network/protocol/about;1?what=about" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x9535 } /* "@mozilla.org/ssservice;1" */,
            ModuleID::SiteSecurity,
          },
  
          {
            { 0x14d5 } /* "@mozilla.org/satchel/form-history-startup;1" */,
            ModuleID::Anonymous524,
          },
  
          {
            { 0x954e } /* "@mozilla.org/supports-double;1" */,
            ModuleID::Anonymous601,
          },
  
          {
            { 0x956d } /* "@mozilla.org/enterprisepolicies;1" */,
            ModuleID::Anonymous480,
          },
  
          {
            { 0x958f } /* "@mozilla.org/webspeech/service;1?name=online" */,
            ModuleID::Anonymous682,
          },
  
          {
            { 0x95bc } /* "@mozilla.org/network/protocol-proxy-service;1" */,
            ModuleID::ProtocolProxy,
          },
  
          {
            { 0x95ea } /* "@mozilla.org/chat/facebook;1" */,
            ModuleID::Anonymous041,
          },
  
          {
            { 0x9607 } /* "@mozilla.org/network/async-stream-copier;1" */,
            ModuleID::Anonymous338,
          },
  
          {
            { 0x9632 } /* "@mozilla.org/messenger/biffManager;1" */,
            ModuleID::Anonymous105,
          },
  
          {
            { 0x9657 } /* "@mozilla.org/ml-utils;1" */,
            ModuleID::Anonymous489,
          },
  
          {
            { 0x966f } /* "@mozilla.org/dom/rtcsessiondescription;1" */,
            ModuleID::Anonymous272,
          },
  
          {
            { 0x9698 } /* "@mozilla.org/uuid-generator;1" */,
            ModuleID::UUIDGenerator,
          },
  
          {
            { 0x96b6 } /* "@mozilla.org/calendar/calendar;1?type=memory" */,
            ModuleID::Anonymous039,
          },
  
          {
            { 0x96e3 } /* "@mozilla.org/array;1" */,
            ModuleID::Anonymous619,
          },
  
          {
            { 0x96f8 } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/xml" */,
            ModuleID::Anonymous660,
          },
  
          {
            { 0x9732 } /* "@mozilla.org/messenger/msgdbview;1?type=threadswithunread" */,
            ModuleID::Anonymous112,
          },
  
          {
            { 0x976c } /* "@mozilla.org/network/buffered-output-stream;1" */,
            ModuleID::Anonymous344,
          },
  
          {
            { 0x11af } /* "@mozilla.org/places/frecency-recalculator;1" */,
            ModuleID::Anonymous512,
          },
  
          {
            { 0x979a } /* "@mozilla.org/network/atomic-file-output-stream;1" */,
            ModuleID::Anonymous339,
          },
  
          {
            { 0x97cb } /* "@mozilla.org/cookieJarSettings;1" */,
            ModuleID::Anonymous403,
          },
  
          {
            { 0x97ec } /* "@mozilla.org/calendar/recurrence-info;1" */,
            ModuleID::Anonymous022,
          },
  
          {
            { 0x9814 } /* "@mozilla.org/image/encoder;2?type=image/png" */,
            ModuleID::Anonymous317,
          },
  
          {
            { 0x9840 } /* "@mozilla.org/supports-PRUint8;1" */,
            ModuleID::Anonymous612,
          },
  
          {
            { 0x9860 } /* "@mozilla.org/docloaderservice;1" */,
            ModuleID::DocLoader,
          },
  
          {
            { 0x9880 } /* "@mozilla.org/browser/nav-bookmarks-service;1" */,
            ModuleID::Anonymous504,
          },
  
          {
            { 0x98ad } /* "@mozilla.org/permissionmanager;1" */,
            ModuleID::PermissionManager,
          },
  
          {
            { 0x98ce } /* "@mozilla.org/webauthn/service;1" */,
            ModuleID::Anonymous303,
          },
  
          {
            { 0x98ee } /* "@mozilla.org/network/idn-service;1" */,
            ModuleID::IDN,
          },
  
          {
            { 0x9911 } /* "@mozilla.org/helperapplauncherdialog;1" */,
            ModuleID::Anonymous541,
          },
  
          {
            { 0x9938 } /* "@mozilla.org/addressbook/ldap-attribute-map-service;1" */,
            ModuleID::Anonymous086,
          },
  
          {
            { 0x996e } /* "@mozilla.org/addressbook/directory;1?type=jscarddav" */,
            ModuleID::Anonymous069,
          },
  
          {
            { 0x99a2 } /* "@mozilla.org/network/util;1" */,
            ModuleID::IO,
          },
  
          {
            { 0x99be } /* "@mozilla.org/network/protocol;1?name=wss" */,
            ModuleID::Anonymous371,
          },
  
          {
            { 0x99e7 } /* "@mozilla.org/messenger/protocol/info;1?type=imap" */,
            ModuleID::Imap,
          },
  
          {
            { 0x9a18 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=deflate" */,
            ModuleID::Anonymous332,
          },
  
          {
            { 0x9a4f } /* "@mozilla.org/login-manager/crypto/SDR;1" */,
            ModuleID::Anonymous498,
          },
  
          {
            { 0x9a77 } /* "@mozilla.org/push/Service;1" */,
            ModuleID::Anonymous298,
          },
  
          {
            { 0x9a93 } /* "@mozilla.org/chat/irc;1" */,
            ModuleID::Anonymous043,
          },
  
          {
            { 0x9aab } /* "@mozilla.org/network/ldap-url;1" */,
            ModuleID::Anonymous088,
          },
  
          {
            { 0x9acb } /* "@mozilla.org/notificationStorage;1" */,
            ModuleID::Anonymous283,
          },
  
          {
            { 0x9aee } /* "@mozilla.org/consoleservice;1" */,
            ModuleID::Console,
          },
  
          {
            { 0xb95 } /* "@mozilla.org/accountmanager/extension;1?name=e2e" */,
            ModuleID::Anonymous065,
          },
  
          {
            { 0x9b0c } /* "@mozilla.org/network/incremental-stream-loader;1" */,
            ModuleID::Anonymous352,
          },
  
          {
            { 0x9b3d } /* "@mozilla.org/dom/rtcicecandidate;1" */,
            ModuleID::Anonymous271,
          },
  
          {
            { 0x9b60 } /* "@mozilla.org/libjar/zip-reader-cache;1" */,
            ModuleID::Anonymous331,
          },
  
          {
            { 0x9b87 } /* "@mozilla.org/rdd-process-test;1" */,
            ModuleID::Anonymous279,
          },
  
          {
            { 0x9ba7 } /* "@mozilla.org/dom/peerconnection;1" */,
            ModuleID::Anonymous268,
          },
  
          {
            { 0x9bc9 } /* "@mozilla.org/io/multiplex-input-stream;1" */,
            ModuleID::Anonymous620,
          },
  
          {
            { 0x9bf2 } /* "@mozilla.org/uriloader/external-helper-app-service;1" */,
            ModuleID::Anonymous256,
          },
  
          {
            { 0x9c27 } /* "@mozilla.org/mail/folder-lookup;1" */,
            ModuleID::Anonymous096,
          },
  
          {
            { 0x9c49 } /* "@mozilla.org/network/protocol/about;1?what=config" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x9c7b } /* "@mozilla.org/network/protocol;1?name=cached-favicon" */,
            ModuleID::Anonymous502,
          },
  
          {
            { 0x9caf } /* "@mozilla.org/msgstore/maildirstore;1" */,
            ModuleID::Anonymous207,
          },
  
          {
            { 0x9cd4 } /* "@mozilla.org/messenger/msgdbview;1?type=quicksearch" */,
            ModuleID::Anonymous115,
          },
  
          {
            { 0x9d08 } /* "@mozilla.org/messenger/messageservice;1?type=x-moz-ews" */,
            ModuleID::Anonymous236,
          },
  
          {
            { 0x9d3f } /* "@mozilla.org/scriptable-content-iterator;1" */,
            ModuleID::Anonymous674,
          },
  
          {
            { 0x9d6a } /* "@mozilla.org/storage/activity-service;1" */,
            ModuleID::Anonymous676,
          },
  
          {
            { 0x9d92 } /* "@mozilla.org/nsCertGen;1" */,
            ModuleID::Anonymous178,
          },
  
          {
            { 0x9dab } /* "@mozilla.org/network/protocol/about;1?what=translations" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x9de3 } /* "@mozilla.org/docshell/uri-fixup;1" */,
            ModuleID::URIFixup,
          },
  
          {
            { 0x9e05 } /* "@mozilla.org/msg-trait-service;1" */,
            ModuleID::Anonymous239,
          },
  
          {
            { 0x9e26 } /* "@mozilla.org/load-context-info-factory;1" */,
            ModuleID::Anonymous337,
          },
  
          {
            { 0x9e4f } /* "@mozilla.org/chat/gtalk;1" */,
            ModuleID::Anonymous042,
          },
  
          {
            { 0x9e69 } /* "@mozilla.org/messenger/account;1" */,
            ModuleID::Anonymous103,
          },
  
          {
            { 0x9e8a } /* "@mozilla.org/addressbook/ldap-directory-query;1" */,
            ModuleID::Anonymous076,
          },
  
          {
            { 0x9eba } /* "@mozilla.org/network/udp-socket;1" */,
            ModuleID::Anonymous383,
          },
  
          {
            { 0x3c1c } /* "@mozilla.org/embedcomp/window-watcher;1" */,
            ModuleID::WindowWatcher,
          },
  
          {
            { 0x9edc } /* "@mozilla.org/streamconv;1?from=gzip&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x9f10 } /* "@mozilla.org/network/protocol/about;1?what=message" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x9f43 } /* "@mozilla.org/network/protocol;1?name=mailbox" */,
            ModuleID::Anonymous202,
          },
  
          {
            { 0x9f70 } /* "@mozilla.org/backgroundtasksrunner;1" */,
            ModuleID::Anonymous460,
          },
  
          {
            { 0x9f95 } /* "@mozilla.org/toolkit/shutdown-terminator;1" */,
            ModuleID::Anonymous466,
          },
  
          {
            { 0x9fc0 } /* "@mozilla.org/find/find_service;1" */,
            ModuleID::FindService,
          },
  
          {
            { 0x9fe1 } /* "@mozilla.org/spellchecker/engine;1" */,
            ModuleID::Anonymous307,
          },
  
          {
            { 0xa004 } /* "@mozilla.org/messenger/progress;1" */,
            ModuleID::Anonymous119,
          },
  
          {
            { 0xa026 } /* "@mozilla.org/msgstore/berkeleystore;1" */,
            ModuleID::Anonymous206,
          },
  
          {
            { 0xa04c } /* "@mozilla.org/network/protocol/about;1?what=preferences" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0xa083 } /* "@mozilla.org/network/protocol/about;1?what=webauthn" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xa0b7 } /* "@mozilla.org/import/import-service;1" */,
            ModuleID::Import,
          },
  
          {
            { 0xa0dc } /* "@mozilla.org/network/protocol/about;1?what=profiling" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0xa111 } /* "@mozilla.org/network/buffered-input-stream;1" */,
            ModuleID::Anonymous343,
          },
  
          {
            { 0xa13e } /* "@mozilla.org/addressbook/directory;1?type=moz-abldapdirectory" */,
            ModuleID::Anonymous075,
          },
  
          {
            { 0xa17c } /* "@mozilla.org/mail/search/validityManager;1" */,
            ModuleID::Anonymous242,
          },
  
          {
            { 0xa1a7 } /* "@mozilla.org/image/encoder;2?type=image/bmp" */,
            ModuleID::Anonymous314,
          },
  
          {
            { 0xa1d3 } /* "@mozilla.org/jsinspector;1" */,
            ModuleID::Anonymous245,
          },
  
          {
            { 0xa1ee } /* "@mozilla.org/image/encoder;2?type=image/webp" */,
            ModuleID::Anonymous318,
          },
  
          {
            { 0xa21b } /* "@mozilla.org/addressbook/ldap-replication-service;1" */,
            ModuleID::Anonymous077,
          },
  
          {
            { 0xa24f } /* "@mozilla.org/messenger/subscribableserver;1" */,
            ModuleID::Anonymous110,
          },
  
          {
            { 0xa27b } /* "@mozilla.org/cookie-banner-list-service;1" */,
            ModuleID::Anonymous475,
          },
  
          {
            { 0xa2a5 } /* "@mozilla.org/messenger/server;1?type=im" */,
            ModuleID::Anonymous061,
          },
  
          {
            { 0xa2cd } /* "@mozilla.org/user-characteristics-page;1" */,
            ModuleID::Anonymous520,
          },
  
          {
            { 0xa2f6 } /* "@mozilla.org/network/protocol;1?name=default" */,
            ModuleID::ExternalProtocolHandler,
          },
  
          {
            { 0x15d1 } /* "@mozilla.org/fxaccounts/push;1" */,
            ModuleID::Anonymous444,
          },
  
          {
            { 0xa323 } /* "@mozilla.org/calendar/todo;1" */,
            ModuleID::Anonymous025,
          },
  
          {
            { 0x13c8 } /* "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1" */,
            ModuleID::Anonymous404,
          },
  
          {
            { 0xa340 } /* "@mozilla.org/network/protocol/about;1?what=certificate" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xa377 } /* "@mozilla.org/network/mime-hdrparam;1" */,
            ModuleID::MimeHeaderParam,
          },
  
          {
            { 0xa39c } /* "@mozilla.org/messenger/fts3tokenizer;1" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0xa3c3 } /* "@mozilla.org/widget/appshell/gtk;1" */,
            ModuleID::Anonymous568,
          },
  
          {
            { 0xa3e6 } /* "@mozilla.org/browser/search-service;1" */,
            ModuleID::Anonymous525,
          },
  
          {
            { 0xa40c } /* "@mozilla.org/messengercompose/composesecure;1" */,
            ModuleID::Anonymous170,
          },
  
          {
            { 0xa43a } /* "@mozilla.org/parent/filepicker;1" */,
            ModuleID::Anonymous572,
          },
  
          {
            { 0xa45b } /* "@mozilla.org/network/protocol;1?name=data" */,
            ModuleID::Anonymous362,
          },
  
          {
            { 0xa485 } /* "@mozilla.org/gecko-media-plugin-service;1" */,
            ModuleID::Anonymous655,
          },
  
          {
            { 0xa4af } /* "@mozilla.org/calendar/calendar;1?type=caldav" */,
            ModuleID::Anonymous036,
          },
  
          {
            { 0xa4dc } /* "@mozilla.org/login-manager/prompter;1" */,
            ModuleID::Anonymous499,
          },
  
          {
            { 0xa502 } /* "@mozilla.org/geolocation;1" */,
            ModuleID::Anonymous656,
          },
  
          {
            { 0xa51d } /* "@mozilla.org/network/protocol;1?name=blob" */,
            ModuleID::Anonymous262,
          },
  
          {
            { 0xa547 } /* "@mozilla.org/widget/dragservice;1" */,
            ModuleID::Anonymous562,
          },
  
          {
            { 0xa569 } /* "@mozilla.org/image/tools;1" */,
            ModuleID::Anonymous313,
          },
  
          {
            { 0xa584 } /* "@mozilla.org/url-classifier/exception-list;1" */,
            ModuleID::Anonymous420,
          },
  
          {
            { 0xa5b1 } /* "@mozilla.org/messenger/windowservice;1" */,
            ModuleID::Anonymous101,
          },
  
          {
            { 0xa5d8 } /* "@mozilla.org/network/protocol;1?name=ws" */,
            ModuleID::Anonymous370,
          },
  
          {
            { 0xa600 } /* "@mozilla.org/network/protocol/about;1?what=telemetry" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xa635 } /* "@mozilla.org/autocomplete/search;1?name=gloda" */,
            ModuleID::Anonymous154,
          },
  
          {
            { 0xa663 } /* "@mozilla.org/streamconv;1?from=deflate&to=uncompressed" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0xa69a } /* "@mozilla.org/autocomplete/search;1?name=login-doorhanger-username" */,
            ModuleID::Anonymous500,
          },
  
          {
            { 0x3c00 } /* "@mozilla.org/xre/app-info;1" */,
            ModuleID::XULRuntime,
          },
  
          {
            { 0xa6dc } /* "@mozilla.org/network/cache-storage-service;1" */,
            ModuleID::CacheStorage,
          },
  
          {
            { 0xa709 } /* "@mozilla.org/dom/workers/workerdebuggermanager;1" */,
            ModuleID::Anonymous651,
          },
  
          {
            { 0xa73a } /* "@mozilla.org/messenger/msgmailnewsurl;1" */,
            ModuleID::Anonymous201,
          },
  
          {
            { 0xa762 } /* "@mozilla.org/intl/ospreferences;1" */,
            ModuleID::Anonymous321,
          },
  
          {
            { 0xa784 } /* "@mozilla.org/chat/odnoklassniki;1" */,
            ModuleID::Anonymous045,
          },
  
          {
            { 0xa7a6 } /* "@mozilla.org/memoryNotificationStorage;1" */,
            ModuleID::Anonymous284,
          },
  
          {
            { 0x868 } /* "@mozilla.org/cspservice;1" */,
            ModuleID::Anonymous640,
          },
  
          {
            { 0xa7cf } /* "@mozilla.org/network/protocol/about;1?what=crashparent" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xa806 } /* "@mozilla.org/messenger/messageservice;1?type=news" */,
            ModuleID::Anonymous227,
          },
  
          {
            { 0xa838 } /* "@mozilla.org/calendar/ics-service;1" */,
            ModuleID::Anonymous016,
          },
  
          {
            { 0xa85c } /* "@mozilla.org/network/protocol;1?name=imap" */,
            ModuleID::Imap,
          },
  
          {
            { 0xa886 } /* "@mozilla.org/messengercompose/quoting;1" */,
            ModuleID::Anonymous144,
          },
  
          {
            { 0xa8ae } /* "@mozilla.org/mail/default-mail-clh;1" */,
            ModuleID::Anonymous056,
          },
  
          {
            { 0xa8d3 } /* "@mozilla.org/network/authprompt-adapter-factory;1" */,
            ModuleID::AuthPromptAdapter,
          },
  
          {
            { 0xa905 } /* "@mozilla.org/nsCMSEncoder;1" */,
            ModuleID::Anonymous175,
          },
  
          {
            { 0xa921 } /* "@mozilla.org/extensions/native-messaging-portal;1" */,
            ModuleID::Anonymous482,
          },
  
          {
            { 0xa953 } /* "@mozilla.org/fingerprinting-webcompat-service;1" */,
            ModuleID::Anonymous519,
          },
  
          {
            { 0xa983 } /* "@mozilla.org/toolkit/captive-detector;1" */,
            ModuleID::Anonymous467,
          },
  
          {
            { 0xa9ab } /* "@mozilla.org/messenger/popservice;1" */,
            ModuleID::Anonymous197,
          },
  
          {
            { 0x735 } /* "@mozilla.org/data-document-content-policy;1" */,
            ModuleID::Anonymous644,
          },
  
          {
            { 0x61f } /* "@mozilla.org/devtools/startup-clh;1" */,
            ModuleID::Anonymous247,
          },
  
          {
            { 0xa9cf } /* "@mozilla.org/gfx/screenmanager;1" */,
            ModuleID::Anonymous566,
          },
  
          {
            { 0xa9f0 } /* "@mozilla.org/messenger/imapservice;1" */,
            ModuleID::Imap,
          },
  
          {
            { 0xaa15 } /* "@mozilla.org/widget/htmlformatconverter;1" */,
            ModuleID::Anonymous573,
          },
  
          {
            { 0xaa3f } /* "@mozilla.org/network/protocol;1?name=ldap" */,
            ModuleID::Anonymous080,
          },
  
          {
            { 0xaa69 } /* "@mozilla.org/network/predictor;1" */,
            ModuleID::Predictor,
          },
  
          {
            { 0xaa8a } /* "@mozilla.org/security/contentsignatureverifier;1" */,
            ModuleID::Anonymous431,
          },
  
          {
            { 0xaabb } /* "@mozilla.org/uriloader/external-protocol-service;1" */,
            ModuleID::Anonymous256,
          },
  
          {
            { 0xaaee } /* "@mozilla.org/network/input-stream-pump;1" */,
            ModuleID::Anonymous354,
          },
  
          {
            { 0xab17 } /* "@mozilla.org/scriptablebase64encoder;1" */,
            ModuleID::Anonymous596,
          },
  
          {
            { 0x761 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
            ModuleID::Anonymous461,
          },
  
          {
            { 0xd63 } /* "@mozilla.org/messenger/mimeemitter;1?type=text/xml" */,
            ModuleID::Anonymous219,
          },
  
          {
            { 0x6e2 } /* "@mozilla.org/toolkit/default-clh;1" */,
            ModuleID::Anonymous471,
          },
  
          {
            { 0x1379 } /* "@mozilla.org/remote-permission-service;1" */,
            ModuleID::Anonymous305,
          },
  
          {
            { 0x940 } /* "@mozilla.org/media/sniffer;1" */,
            ModuleID::Anonymous488,
          },
  
          {
            { 0xab3e } /* "@mozilla.org/network/protocol/about;1?what=license" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xab71 } /* "@mozilla.org/newsblog-feed-downloader;1" */,
            ModuleID::Anonymous167,
          },
  
          {
            { 0x3c44 } /* "@mozilla.org/contentanalysis;1" */,
            ModuleID::nsIContentAnalysis,
          },
  
          {
            { 0xab99 } /* "@mozilla.org/jacppmsgfolderdelegator;1" */,
            ModuleID::Anonymous192,
          },
  
          {
            { 0xabc0 } /* "@mozilla.org/messenger/messageservice;1?type=imap" */,
            ModuleID::Imap,
          },
  
          {
            { 0xabf2 } /* "@mozilla.org/messenger;1" */,
            ModuleID::Anonymous102,
          },
  
          {
            { 0xac0b } /* "@mozilla.org/supports-PRInt64;1" */,
            ModuleID::Anonymous607,
          },
  
          {
            { 0xac2b } /* "@mozilla.org/parent/colorpicker;1" */,
            ModuleID::Anonymous571,
          },
  
          {
            { 0xac4d } /* "@mozilla.org/ipc/processselector;1" */,
            ModuleID::Anonymous259,
          },
  
          {
            { 0xac70 } /* "@mozilla.org/network/protocol;1?name=jar" */,
            ModuleID::Anonymous328,
          },
  
          {
            { 0xac99 } /* "@mozilla.org/messenger/messageservice;1?type=news-message" */,
            ModuleID::Anonymous226,
          },
  
          {
            { 0xacd3 } /* "@mozilla.org/eventsourceevent/service;1" */,
            ModuleID::Anonymous680,
          },
  
          {
            { 0xacfb } /* "@mozilla.org/msgDatabase/msgDBService;1" */,
            ModuleID::DB,
          },
  
          {
            { 0xad23 } /* "@mozilla.org/network/protocol/about;1?what=certerror" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0xad58 } /* "@mozilla.org/network/file-random-access-stream;1" */,
            ModuleID::Anonymous349,
          },
  
          {
            { 0xd2e } /* "@mozilla.org/messenger/mimeemitter;1?type=text/plain" */,
            ModuleID::Anonymous220,
          },
  
          {
            { 0xad89 } /* "@mozilla.org/base/daptelemetry;1" */,
            ModuleID::Anonymous530,
          },
  
          {
            { 0xadaa } /* "@mozilla.org/network/protocol/about;1?what=addressbook" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0xade1 } /* "@mozilla.org/nsTokenPasswordDialogs;1" */,
            ModuleID::Anonymous423,
          },
  
          {
            { 0xae07 } /* "@mozilla.org/xul/xulstore;1" */,
            ModuleID::Anonymous540,
          },
  
          {
            { 0xae23 } /* "@mozilla.org/dom/session-storage-service;1" */,
            ModuleID::Anonymous301,
          },
  
          {
            { 0xae4e } /* "@mozilla.org/content-dispatch-chooser;1" */,
            ModuleID::Anonymous546,
          },
  
          {
            { 0xae76 } /* "@mozilla.org/widget/useridleservice;1" */,
            ModuleID::Anonymous580,
          },
  
          {
            { 0xae9c } /* "@mozilla.org/autocomplete/search;1?name=news" */,
            ModuleID::Anonymous222,
          },
  
          {
            { 0x158c } /* "@mozilla.org/updates/timer-manager;1" */,
            ModuleID::Anonymous531,
          },
  
          {
            { 0xaec9 } /* "@mozilla.org/url-classifier/prefixset;1" */,
            ModuleID::UrlClassifierPrefixSet,
          },
  
          {
            { 0xaef1 } /* "@mozilla.org/url-classifier/streamupdater;1" */,
            ModuleID::UrlClassifierStreamUpdater,
          },
  
          {
            { 0xaf1d } /* "@mozilla.org/sqlite-key-value-service;1" */,
            ModuleID::Anonymous486,
          },
  
          {
            { 0xaf45 } /* "@mozilla.org/libjar/zip-reader;1" */,
            ModuleID::Anonymous327,
          },
  
          {
            { 0xaf66 } /* "@mozilla.org/network/protocol/about;1?what=processes" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xaf9b } /* "@mozilla.org/nsCMSSecureMessage;1" */,
            ModuleID::Anonymous172,
          },
  
          {
            { 0xafbd } /* "@mozilla.org/ospermissionrequest;1" */,
            ModuleID::Anonymous252,
          },
  
          {
            { 0xafe0 } /* "@mozilla.org/docshell/uri-fixup-info;1" */,
            ModuleID::Anonymous250,
          },
  
          {
            { 0xb007 } /* "@mozilla.org/network/ldap-operation;1" */,
            ModuleID::Anonymous074,
          },
  
          {
            { 0xb02d } /* "@mozilla.org/messenger/searchTerm;1" */,
            ModuleID::Anonymous241,
          },
  
          {
            { 0x1235 } /* "@mozilla.org/readconfig;1" */,
            ModuleID::Anonymous306,
          },
  
          {
            { 0xb051 } /* "@mozilla.org/messengercompose/attachedfile;1" */,
            ModuleID::Anonymous140,
          },
  
          {
            { 0xb07e } /* "@mozilla.org/mozintl;1" */,
            ModuleID::Anonymous491,
          },
  
          {
            { 0xb095 } /* "@mozilla.org/messenger/messagestateparser;1" */,
            ModuleID::Anonymous209,
          },
  
          {
            { 0xb0c1 } /* "@mozilla.org/calendar/attendee;1" */,
            ModuleID::Anonymous007,
          },
  
          {
            { 0xb0e2 } /* "@mozilla.org/network/protocol;1?name=ews" */,
            ModuleID::Anonymous237,
          },
  
          {
            { 0xb10b } /* "@mozilla.org/messengercompose/attachment;1" */,
            ModuleID::Anonymous138,
          },
  
          {
            { 0x1494 } /* "@mozilla.org/calendar/deleted-items-manager;1" */,
            ModuleID::Anonymous010,
          },
  
          {
            { 0xb136 } /* "@mozilla.org/messenger/messageservice;1?type=imap-message" */,
            ModuleID::Imap,
          },
  
          {
            { 0xb170 } /* "@mozilla.org/appshell/window-mediator;1" */,
            ModuleID::Anonymous628,
          },
  
          {
            { 0xb198 } /* "@mozilla.org/streamconv;1?from=application/http-index-format&to=text/html" */,
            ModuleID::Anonymous387,
          },
  
          {
            { 0xb1e2 } /* "@mozilla.org/utility-process-test;1" */,
            ModuleID::Anonymous325,
          },
  
          {
            { 0xb206 } /* "@mozilla.org/activity-process;1" */,
            ModuleID::Anonymous049,
          },
  
          {
            { 0xb226 } /* "@mozilla.org/uriloader;1" */,
            ModuleID::URILoader,
          },
  
          {
            { 0xb23f } /* "@mozilla.org/addons/addon-manager-startup;1" */,
            ModuleID::Anonymous462,
          },
  
          {
            { 0xb26b } /* "@mozilla.org/intl/scriptableunicodeconverter" */,
            ModuleID::Anonymous324,
          },
  
          {
            { 0xb298 } /* "@mozilla.org/autocomplete/search;1?name=addrbook" */,
            ModuleID::Anonymous084,
          },
  
          {
            { 0xb2c9 } /* "@mozilla.org/network/protocol;1?name=javascript" */,
            ModuleID::Anonymous667,
          },
  
          {
            { 0xed6 } /* "@mozilla.org/dom/payments/basiccard-response-data;1" */,
            ModuleID::Anonymous287,
          },
  
          {
            { 0xb2f9 } /* "@mozilla.org/messenger/spamsettings;1" */,
            ModuleID::Anonymous120,
          },
  
          {
            { 0xb31f } /* "@mozilla.org/toolkit/glean;1" */,
            ModuleID::Anonymous484,
          },
  
          {
            { 0xb33c } /* "@mozilla.org/network/protocol;1?name=webcal" */,
            ModuleID::Anonymous019,
          },
  
          {
            { 0xb368 } /* "@mozilla.org/security/osreauthenticator;1" */,
            ModuleID::Anonymous435,
          },
  
          {
            { 0x535 } /* "@mozilla.org/calendar/import;1?type=ics" */,
            ModuleID::Anonymous029,
          },
  
          {
            { 0xb392 } /* "@mozilla.org/network/protocol;1?name=smtp" */,
            ModuleID::Anonymous150,
          },
  
          {
            { 0xb3bc } /* "@mozilla.org/jacppabdirectorydelegator;1" */,
            ModuleID::Anonymous189,
          },
  
          {
            { 0xb3e5 } /* "@mozilla.org/addon-web-api/manager;1" */,
            ModuleID::Anonymous544,
          },
  
          {
            { 0xb40a } /* "@mozilla.org/network/protocol/about;1?what=webrtc" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0xb43c } /* "@mozilla.org/network/incremental-download;1" */,
            ModuleID::Anonymous351,
          },
  
          {
            { 0xb468 } /* "@mozilla.org/messenger/headerparser;1" */,
            ModuleID::HeaderParser,
          },
  
          {
            { 0xb48e } /* "@mozilla.org/activity-manager;1" */,
            ModuleID::Anonymous052,
          },
  
          {
            { 0xb4ae } /* "@mozilla.org/preferences-service;1" */,
            ModuleID::Preferences,
          },
  
          {
            { 0xb4d1 } /* "@mozilla.org/childprocessmessagemanager;1" */,
            ModuleID::Anonymous635,
          },
  
          {
            { 0xb4fb } /* "@mozilla.org/calendar/calendar;1?type=ics" */,
            ModuleID::Anonymous038,
          },
  
          {
            { 0xf25 } /* "@mozilla.org/dom/payments/general-change-details;1" */,
            ModuleID::Anonymous288,
          },
  
          {
            { 0xb525 } /* "@mozilla.org/messenger/protocol/info;1?type=rss" */,
            ModuleID::Anonymous210,
          },
  
          {
            { 0xb555 } /* "@mozilla.org/extensions/blocklist;1" */,
            ModuleID::Anonymous542,
          },
  
          {
            { 0xb579 } /* "@mozilla.org/nsCMSDecoder;1" */,
            ModuleID::Anonymous173,
          },
  
          {
            { 0xb595 } /* "@mozilla.org/messengercompose/quotinglistener;1" */,
            ModuleID::Anonymous145,
          },
  
          {
            { 0xb5c5 } /* "@mozilla.org/satchel/form-history-autocomplete;1" */,
            ModuleID::Anonymous523,
          },
  
          {
            { 0xb5f6 } /* "@mozilla.org/image/encoder;2?type=image/vnd.microsoft.icon" */,
            ModuleID::Anonymous315,
          },
  
          {
            { 0xb631 } /* "@mozilla.org/notification-handler;1" */,
            ModuleID::Anonymous285,
          },
  
          {
            { 0xb655 } /* "@mozilla.org/network/oblivious-http;1" */,
            ModuleID::Anonymous414,
          },
  
          {
            { 0xb67b } /* "@mozilla.org/boolean-expression/n-peer;1" */,
            ModuleID::Anonymous093,
          },
  
          {
            { 0xb6a4 } /* "@mozilla.org/messenger/nntpurl;1" */,
            ModuleID::Anonymous230,
          },
  
          {
            { 0xb6c5 } /* "@mozilla.org/network/protocol;1?name=webcals" */,
            ModuleID::Anonymous020,
          },
  
          {
            { 0xb6f2 } /* "@mozilla.org/calendar/calendar;1?type=composite" */,
            ModuleID::Anonymous037,
          },
  
          {
            { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
            ModuleID::Anonymous636,
          },
  
          {
            { 0xb722 } /* "@mozilla.org/pref-localizedstring;1" */,
            ModuleID::Anonymous334,
          },
  
          {
            { 0x909 } /* "@mozilla.org/image/loader;1" */,
            ModuleID::Anonymous310,
          }
};



const ContractEntry*
LookupContractID(const nsACString& aKey)
{
  static const uint16_t BASES[] = {
       1,   2,   1,   3,   5,   8,   4,   7,  10,   2,   1,   5,   0,   1,   1,   1,
       6,   1,   0,   4,   2,   2,   3,   8,   3,   3,  15,   6,   5,   0,   8,   1,
       0,   1,   1,   5,   6,   2,   1,   1,   0,   2,   8,   1,   8,   4,   6,   4,
       0,   1,   3,  13,   1,  16,   0,  12,   1,   0,   2,   5,   0,   1,   2,  10,
       2,   1,   1,   2,   2,   8,   5,   0,   0,   0,   6,   3,   0,   2,  14,   5,
       2,   2,   5,   1,   5,   0,   3,  13,   8,   9,   1,   0,   3,   6,   3,  11,
       3,   4,   2,   4,   0,   7,   4,   6,   6,   1,   2,   1,   1,  22,   2,   3,
       9,  26,   6,   1,   0,   1,   4,   0,   0,   5,   4,   1,   3,   0,   7,  34,
       6,   1,   6,   0,  12,   0,   1,   0,   1,   3,   5,   0,   3,  20,  21,   0,
       2,   6,   8,   0,  11,   7,   1,   0,   8,   6,   1,   0,   2,   0,   3,   1,
       0,   4,   9,  22,   2,   7,   1,  12,  17,   5,  12,   3,   4,   2,   1,   0,
       4,   1,   7,   1,   0,   1,   6,  19,   3,   3,  12,   1,   6,  13,  10,   5,
       1,   2,  23,   5,   2,   6,   1,  21,   2,   5,   1,   4,   5,   0,  11,   2,
       7,   8,   1,   2,  15,  16,   5,  14,   0,   7,   2,   1,  10,  12,   6,   1,
       6,  13,  11,   2,   1,   2,   8,   0,   1,   1,   5,   0,   1,   1,   8,  28,
       8,   5,  18,   6,   3,   5,   0,   5,   2,   8,   5,  12,   2,   0,   0,   7,
       0,   0,  16,   2,  25,   0,   0,   2,   0,  24,  13,   3,   1,   1,  13,   8,
       3,   1,   0,   9,   5,  10,   1,   4,   0,   1,  16,   1,   2,   2,   2,   8,
       2,   1,   3,   0,  11,   3,   4,  12,   1,   0,   3,  20,   5,   1,   3,   8,
       3,   7,   8,   8,   0,   1,   0,  15,   0,  22,   0,   0,   6,   7,   8,   9,
       1,   0,   3,   0,  23,  23,   1,   1,   0,   4,  32,  13,  13,   1,  11,   2,
       1,  32,  13,   6,   2,   9,   0,  14,   1,   0,   0,  12,   6,  29,  15,  15,
      10,   0,  18,  13,   0,  10,   2,  11,  11,  16,  23,   0,  32,   5,   0,  25,
      21,  14,  30,   2,   9,  16,   0,  14,   1,   4,   1,  21,  13,   0,   6,   2,
       4,   2,   4,   5,  26,   2,   0,   6,  22,   0,   1,  47,  34,  40,  16,  11,
       8,   0,   2,   0,  28,   7,   8,   4,  24,   7,   2,  23,  71,   7,   1,   1,
       0,  35,  12,   7,  22,   0,   9,   6,   2,  29,  14,  78,   0,   0,   2,   1,
       0,  27,   1,  29,   0,  98,   8,  16,   9,  31,   2,  16,   7,   0,  55,  50,
      37,  69,  37,   1,   6,   1,  13,   2,  61,   4,   6,   1,   7,   5,   5,  57,
       9,   0,   0,  11,   6,   1,   0,  63,   3,  20,   0,   7,  23,   4,  11,  37,
      11,   7,  14,  33, 138,   1,   0, 151,  37,   1, 111,   0,   1,   2, 284,   2,
       0,   2,   2,   5,   2,  30,   9, 119,  14, 231,  94,  28,   1,   1,   0, 136,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gContractEntries);
  return entry.Matches(aKey) ? &entry : nullptr;
}

const JSServiceEntry gJSServices[] = {
  
          {
            { 0xb746 } /* "uuid" */,
            ModuleID::UUIDGenerator,
            { 71 },
            1
          },
  
          {
            { 0xb74b } /* "domStorageManager" */,
            ModuleID::Anonymous647,
            { 80 },
            2
          },
  
          {
            { 0xb75d } /* "telemetry" */,
            ModuleID::Anonymous529,
            { 55 },
            1
          },
  
          {
            { 0xb767 } /* "els" */,
            ModuleID::Anonymous652,
            { 83 },
            1
          },
  
          {
            { 0xb76b } /* "sysinfo" */,
            ModuleID::SystemInfo,
            { 68 },
            2
          },
  
          {
            { 0xb773 } /* "obs" */,
            ModuleID::Observer,
            { 74 },
            1
          },
  
          {
            { 0xb777 } /* "intl" */,
            ModuleID::Anonymous491,
            { 49 },
            1
          },
  
          {
            { 0xb77c } /* "rfp" */,
            ModuleID::RFPService,
            { 52 },
            1
          },
  
          {
            { 0xb780 } /* "prefs" */,
            ModuleID::Preferences,
            { 20 },
            2
          },
  
          {
            { 0xb786 } /* "DAPTelemetry" */,
            ModuleID::Anonymous530,
            { 56 },
            1
          },
  
          {
            { 0xb793 } /* "appShell" */,
            ModuleID::Anonymous627,
            { 78 },
            1
          },
  
          {
            { 0xb79c } /* "cookieBanners" */,
            ModuleID::CookieBannerService,
            { 42 },
            1
          },
  
          {
            { 0xb7aa } /* "vc" */,
            ModuleID::Anonymous616,
            { 72 },
            1
          },
  
          {
            { 0xb7ad } /* "logins" */,
            ModuleID::Anonymous493,
            { 50 },
            1
          },
  
          {
            { 0xb7b4 } /* "dns" */,
            ModuleID::DNS,
            { 24 },
            1
          },
  
          {
            { 0xb7b8 } /* "textToSubURI" */,
            ModuleID::TextToSubURI,
            { 18 },
            1
          },
  
          {
            { 0xb7c5 } /* "storage" */,
            ModuleID::Anonymous447,
            { 35 },
            1
          },
  
          {
            { 0xb7cd } /* "xulStore" */,
            ModuleID::Anonymous540,
            { 58 },
            1
          },
  
          {
            { 0xb7d6 } /* "blocklist" */,
            ModuleID::Anonymous542,
            { 59 },
            1
          },
  
          {
            { 0xb7e0 } /* "urlFormatter" */,
            ModuleID::Anonymous537,
            { 57 },
            1
          },
  
          {
            { 0xb7ed } /* "perms" */,
            ModuleID::PermissionManager,
            { 15 },
            1
          },
  
          {
            { 0xb7f3 } /* "locale" */,
            ModuleID::Locale,
            { 17 },
            1
          },
  
          {
            { 0xb7fa } /* "sessionStorage" */,
            ModuleID::Anonymous301,
            { 14 },
            1
          },
  
          {
            { 0xb809 } /* "clearData" */,
            ModuleID::Anonymous469,
            { 39 },
            1
          },
  
          {
            { 0xb813 } /* "droppedLinkHandler" */,
            ModuleID::Anonymous257,
            { 12 },
            1
          },
  
          {
            { 0xb826 } /* "scriptloader" */,
            ModuleID::Anonymous326,
            { 19 },
            1
          },
  
          {
            { 0xb833 } /* "io" */,
            ModuleID::IO,
            { 26 },
            3
          },
  
          {
            { 0xb836 } /* "focus" */,
            ModuleID::Anonymous654,
            { 84 },
            1
          },
  
          {
            { 0xb83c } /* "policies" */,
            ModuleID::Anonymous480,
            { 46 },
            1
          },
  
          {
            { 0xb845 } /* "fog" */,
            ModuleID::Anonymous484,
            { 47 },
            1
          },
  
          {
            { 0xb849 } /* "profiler" */,
            ModuleID::Anonymous555,
            { 64 },
            1
          },
  
          {
            { 0xb852 } /* "search" */,
            ModuleID::Anonymous525,
            { 54 },
            1
          },
  
          {
            { 0xb859 } /* "qms" */,
            ModuleID::Anonymous649,
            { 82 },
            1
          },
  
          {
            { 0xb85d } /* "strings" */,
            ModuleID::StringBundle,
            { 16 },
            1
          },
  
          {
            { 0xb865 } /* "env" */,
            ModuleID::Anonymous624,
            { 77 },
            1
          },
  
          {
            { 0xb869 } /* "eTLD" */,
            ModuleID::EffectiveTLD,
            { 25 },
            1
          },
  
          {
            { 0xb86e } /* "loadContextInfo" */,
            ModuleID::Anonymous337,
            { 22 },
            1
          },
  
          {
            { 0xb87e } /* "ppmm" */,
            ModuleID::Anonymous670,
            { 85 },
            0
          },
  
          {
            { 0xb883 } /* "appinfo" */,
            ModuleID::XULRuntime,
            { 60 },
            3
          },
  
          {
            { 0xb88b } /* "prompt" */,
            ModuleID::Anonymous515,
            { 51 },
            1
          },
  
          {
            { 0xb892 } /* "console" */,
            ModuleID::Console,
            { 67 },
            1
          },
  
          {
            { 0xb89a } /* "ww" */,
            ModuleID::WindowWatcher,
            { 63 },
            1
          },
  
          {
            { 0xb89d } /* "uriFixup" */,
            ModuleID::URIFixup,
            { 11 },
            1
          },
  
          {
            { 0xb8a6 } /* "catMan" */,
            ModuleID::CategoryManager,
            { 73 },
            1
          },
  
          {
            { 0xb8ad } /* "scriptSecurityManager" */,
            ModuleID::ScriptSecurityManager,
            { 85 },
            1
          },
  
          {
            { 0xb8c3 } /* "clipboard" */,
            ModuleID::Anonymous558,
            { 65 },
            1
          },
  
          {
            { 0xb8cd } /* "dirsvc" */,
            ModuleID::Directory,
            { 75 },
            2
          },
  
          {
            { 0xb8d4 } /* "wm" */,
            ModuleID::Anonymous628,
            { 79 },
            1
          },
  
          {
            { 0xb8d7 } /* "tm" */,
            ModuleID::Anonymous614,
            { 70 },
            1
          },
  
          {
            { 0xb8da } /* "cache2" */,
            ModuleID::CacheStorage,
            { 23 },
            1
          },
  
          {
            { 0xb8e1 } /* "startup" */,
            ModuleID::AppStartup,
            { 38 },
            1
          },
  
          {
            { 0xb8e9 } /* "mm" */,
            ModuleID::Anonymous657,
            { 85 },
            0
          },
  
          {
            { 0xb8ec } /* "cpmm" */,
            ModuleID::Anonymous635,
            { 80 },
            0
          },
  
          {
            { 0xb8f1 } /* "cookies" */,
            ModuleID::Anonymous401,
            { 29 },
            2
          }
};



const JSServiceEntry*
LookupJSService(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
       1,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   2,   1,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   3,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   1,   0,   0,   6,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  13,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
       0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
      11,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  10,   0,   0,   0,   0,
       0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   9,   0,   0,   0,  22,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,  12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gJSServices);
  return entry.Name() == aKey ? &entry : nullptr;
}

const StaticProtocolHandler gStaticProtocolHandlers[] = {
  
          {
            .mScheme = { 0xb8f9 } /* "about" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_SCHEME_NOT_SELF_LINKABLE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous361,
            .mHasDynamicFlags = true,
          },
  
          {
            .mScheme = { 0xb8ff } /* "moz-cal-handle-itip" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous034,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb913 } /* "https" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous363,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb919 } /* "x-moz-ews" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS | nsIProtocolHandler::ORIGIN_IS_FULL_SPEC,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous237,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb923 } /* "ldaps" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::ALLOWS_PROXY,
            .mDefaultPort = 636,
            .mModuleID = ModuleID::Anonymous081,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb929 } /* "data" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_INHERITS_SECURITY_CONTEXT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_SYNC_LOAD_IS_OK,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous362,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb92e } /* "mailto" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous152,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb935 } /* "moz-gio" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous411,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb93d } /* "jar" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous328,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb941 } /* "moz-src" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous368,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb949 } /* "cid" */,
            .mProtocolFlags = nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous121,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb94d } /* "smtps" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT,
            .mDefaultPort = 465,
            .mModuleID = ModuleID::Anonymous151,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb953 } /* "ws" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 80,
            .mModuleID = ModuleID::Anonymous370,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb956 } /* "moz-icon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = 0,
            .mModuleID = ModuleID::Anonymous319,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb95f } /* "file" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_IS_LOCAL_FILE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::FileProtocolHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb964 } /* "wss" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous371,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb968 } /* "cached-favicon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous502,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb977 } /* "webcal" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = 80,
            .mModuleID = ModuleID::Anonymous019,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb97e } /* "javascript" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_INHERITS_SECURITY_CONTEXT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_OPENING_EXECUTES_SCRIPT,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous667,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb989 } /* "moz-safe-about" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous366,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb998 } /* "default" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA,
            .mDefaultPort = 0,
            .mModuleID = ModuleID::ExternalProtocolHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9a0 } /* "webcals" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous020,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9a8 } /* "moz-page-thumb" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous365,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9b7 } /* "resource" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous367,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9c0 } /* "view-source" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_NON_PERSISTABLE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous369,
            .mHasDynamicFlags = true,
          },
  
          {
            .mScheme = { 0xb9cc } /* "news" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS | nsIProtocolHandler::ORIGIN_IS_FULL_SPEC,
            .mDefaultPort = 119,
            .mModuleID = ModuleID::Anonymous228,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9d1 } /* "blob" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_SUBSUMERS | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous262,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9d6 } /* "smtp" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT,
            .mDefaultPort = 25,
            .mModuleID = ModuleID::Anonymous150,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9db } /* "pop3" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS,
            .mDefaultPort = 110,
            .mModuleID = ModuleID::Anonymous199,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9e0 } /* "page-icon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous510,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9ea } /* "moz-extension" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN | nsIProtocolHandler::URI_IS_WEBEXTENSION_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous364,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9f8 } /* "http" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 80,
            .mModuleID = ModuleID::HttpHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xb9fd } /* "moz" */,
            .mProtocolFlags = nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous492,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xba01 } /* "indexeddb" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous300,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xba0b } /* "snews" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS | nsIProtocolHandler::ORIGIN_IS_FULL_SPEC,
            .mDefaultPort = 563,
            .mModuleID = ModuleID::Anonymous229,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xba11 } /* "mailbox" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_FORBIDS_AUTOMATIC_DOCUMENT_REPLACEMENT | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_FORBIDS_COOKIE_ACCESS | nsIProtocolHandler::ORIGIN_IS_FULL_SPEC,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous202,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xba19 } /* "chrome" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous589,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0xba20 } /* "ldap" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::ALLOWS_PROXY,
            .mDefaultPort = 389,
            .mModuleID = ModuleID::Anonymous080,
            .mHasDynamicFlags = false,
          }
};



const StaticProtocolHandler*
LookupProtocolHandler(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   1,   7,   8,  46,   1,   2,   0,  16,  38,   3,   1,  94,   2,   5, 172,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gStaticProtocolHandlers);
  return entry.Scheme() == aKey ? &entry : nullptr;
}

static inline bool CalledInit(size_t aIdx) {
  return GetBit(gInitCalled, aIdx);
}

static nsresult CallInitFunc(size_t aIdx) {
  if (CalledInit(aIdx)) {
    return NS_OK;
  }

  nsresult rv = NS_OK;
  switch (aIdx) {
    case 0:
      mozilla::InitDocShellModule();
      break;
    case 1:
      mozilla::image::EnsureModuleInitialized();
      break;
    case 2:
      /* empty */
      break;
    case 3:
      nsNetStartup();
      break;
    case 4:
      /* empty */
      break;
    case 5:
      nsWidgetGtk2ModuleCtor();
      break;
    case 6:
      /* empty */
      break;
  }

  SetBit(gInitCalled, aIdx);

  MOZ_ASSERT(NS_SUCCEEDED(rv));
  return rv;
}

static void CallUnloadFuncs() {
  if (CalledInit(0)) {
    mozilla::UnloadDocShellModule();
  }
  if (CalledInit(2)) {
    mozilla::UnloadPrefsModule();
  }
  if (CalledInit(3)) {
    nsNetShutdown();
  }
  if (CalledInit(4)) {
    mozilla::Telemetry::ShutdownTelemetry();
  }
  if (CalledInit(5)) {
    nsWidgetGtk2ModuleDtor();
  }
  if (CalledInit(6)) {
    nsLayoutModuleDtor();
  }
}

nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult) {
  // The full set of constructors for all static modules.
  // This switch statement will be compiled to a relative address jump table
  // with no runtime relocations and a single indirect jump.
  switch (aID) {
    case ModuleID::Anonymous042: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/gtalk.sys.mjs"),
                                         "GTalkProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous054: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutRedirector.sys.mjs"),
                                         "AboutRedirector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Console: {
      RefPtr<nsConsoleService> inst = new nsConsoleService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous199: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Pop3ProtocolHandler.sys.mjs"),
                                         "Pop3ProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous509: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesDBUtils.sys.mjs"),
                                         "PlacesDBUtilsIdleMaintenance",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous409: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs"),
                                         "ThirdPartyCookieBlockingExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous171: {
      RefPtr<nsEncryptedSMIMEURIsService> inst = new nsEncryptedSMIMEURIsService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous034: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalItipProtocolHandler.sys.mjs"),
                                         "ItipProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous339: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAtomicFileOutputStream> inst = new nsAtomicFileOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous478: {
      RefPtr<mozilla::ctypes::Module> inst = new mozilla::ctypes::Module();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Predictor: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::Predictor::Create(aIID, aResult);
    }
    case ModuleID::Anonymous550: {
      RefPtr<nsFind> inst = new nsFind();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous312: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<imgRequestProxy> inst = new imgRequestProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous605: {
      RefPtr<nsSupportsPRInt16> inst = new nsSupportsPRInt16();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous207: {
      RefPtr<nsMsgMaildirStore> inst = new nsMsgMaildirStore();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous029: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalIcsImportExport.sys.mjs"),
                                         "CalIcsImporter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous282: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WebVTTParserWrapper.sys.mjs"),
                                         "WebVTTParserWrapper",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous237: {
      RefPtr<EwsProtocolHandler> inst = new EwsProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous585: {
      return /* legacy */ nsDebugImpl::Create(aIID, aResult);
    }
    case ModuleID::Anonymous213: {
      RefPtr<nsPgpMimeProxy> inst = new nsPgpMimeProxy();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous344: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsBufferedOutputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous270: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCDTMFSender",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous489: {
      RefPtr<mozilla::ml::MLUtils> inst = new mozilla::ml::MLUtils();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous188: {
      RefPtr<nsCharsetConverterManager> inst = new nsCharsetConverterManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous313: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<mozilla::image::imgTools> inst = new mozilla::image::imgTools();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous536: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs"),
                                         "UrlClassifierRemoteSettingsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous047: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/xmpp.sys.mjs"),
                                         "XMPPProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous330: {
      RefPtr<nsJARURI::Mutator> inst = new nsJARURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Prefetch: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsPrefetchService> inst = new nsPrefetchService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous240: {
      RefPtr<nsMsgSearchSession> inst = new nsMsgSearchSession();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous661: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateXHTMLContentSerializer(aIID, aResult);
    }
    case ModuleID::Anonymous294: {
      RefPtr<mozilla::dom::PaymentRequestService> inst = mozilla::dom::PaymentRequestService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::PaymentRequestService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::PaymentRequestService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::PaymentRequestService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ServiceWorkerManager: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::ServiceWorkerManager> inst = mozilla::dom::ServiceWorkerManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::ServiceWorkerManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::ServiceWorkerManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::ServiceWorkerManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous028: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalMimeConverter.sys.mjs"),
                                         "CalMimeConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous594: {
      RefPtr<nsMemoryReporterManager> inst = new nsMemoryReporterManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous101: {
      RefPtr<nsMessengerBootstrap> inst = new nsMessengerBootstrap();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::RFPService: {
      RefPtr<mozilla::nsRFPService> inst = mozilla::nsRFPService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsRFPService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsRFPService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsRFPService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous150: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/SMTPProtocolHandler.sys.mjs"),
                                         "SMTPProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AppStartup: {
      RefPtr<nsAppStartup> inst = new nsAppStartup();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous170: {
      RefPtr<nsMsgComposeSecure> inst = new nsMsgComposeSecure();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous480: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/EnterprisePolicies.sys.mjs"),
                                         "EnterprisePolicies",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous611: {
      RefPtr<nsSupportsPRUint64> inst = new nsSupportsPRUint64();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous645: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsDeviceSensors> inst = new nsDeviceSensors();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous090: {
      RefPtr<nsAbDirProperty> inst = new nsAbDirProperty();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous165: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MDNService.sys.mjs"),
                                         "MDNService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous406: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs"),
                                         "EssentialDomainsRemoteSettings",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous022: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalRecurrenceInfo.sys.mjs"),
                                         "CalRecurrenceInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous387: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsIndexedToHTML::Create(aIID, aResult);
    }
    case ModuleID::Anonymous506: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TaggingService.sys.mjs"),
                                         "TaggingService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous420: {
      RefPtr<mozilla::net::UrlClassifierExceptionList> inst = new mozilla::net::UrlClassifierExceptionList();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AddonContentPolicy: {
      RefPtr<AddonContentPolicy> inst = new AddonContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous629: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSURI::Mutator> inst = new nsJSURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::GfxInfo: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<mozilla::widget::GfxInfo> inst = new mozilla::widget::GfxInfo();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous334: {
      MOZ_TRY(CallInitFunc(2));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsPrefLocalizedString>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous462: {
      RefPtr<mozilla::AddonManagerStartup> inst = mozilla::AddonManagerStartup::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::AddonManagerStartup::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::AddonManagerStartup::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::AddonManagerStartup, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous393: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleNestedURI::Mutator> inst = new mozilla::net::nsSimpleNestedURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous092: {
      RefPtr<nsAbBooleanConditionString> inst = new nsAbBooleanConditionString();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous278: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "CreateOfferRequest",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous417: {
      RefPtr<nsIChannelClassifierService> inst = mozilla::net::ChannelClassifierService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ChannelClassifierService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ChannelClassifierService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIChannelClassifierService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous122: {
      RefPtr<nsMsgContentPolicy> inst = new nsMsgContentPolicy();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IDN: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIDNService> inst = new nsIDNService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous127: {
      RefPtr<TransactionManager> inst = new TransactionManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous052: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/ActivityManager.sys.mjs"),
                                         "ActivityManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Locale: {
      RefPtr<mozilla::intl::LocaleService> inst = mozilla::intl::LocaleService::GetInstanceAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::intl::LocaleService::GetInstanceAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::intl::LocaleService::GetInstanceAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::intl::LocaleService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous418: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierExceptionListService.sys.mjs"),
                                         "UrlClassifierExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous160: {
      RefPtr<nsMsgRetentionSettings> inst = new nsMsgRetentionSettings();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous291: {
      RefPtr<mozilla::dom::payments::PaymentAddress> inst = new mozilla::dom::payments::PaymentAddress();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous163: {
      RefPtr<nsFts3Tokenizer> inst = new nsFts3Tokenizer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::StreamTransport: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStreamTransportService> inst = new mozilla::net::nsStreamTransportService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous206: {
      RefPtr<nsMsgBrkMBoxStore> inst = new nsMsgBrkMBoxStore();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous522: {
      RefPtr<nsFormFillController> inst = nsFormFillController::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFormFillController::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFormFillController::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsFormFillController, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous268: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCPeerConnection",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous500: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs"),
                                         "AutoCompleteSimpleSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous072: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/VCardUtils.sys.mjs"),
                                         "VCardMimeConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous372: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsSafeFileOutputStream> inst = new nsSafeFileOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous684: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIAccessibilityService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous323: {
      RefPtr<nsConverterOutputStream> inst = new nsConverterOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous277: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCRtpReceiver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous005: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalAlarmService.sys.mjs"),
                                         "CalAlarmService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous049: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Activity.sys.mjs"),
                                         "ActivityProcess",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous128: {
      RefPtr<nsUserInfo> inst = new nsUserInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous075: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPDirectory.sys.mjs"),
                                         "LDAPDirectory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous413: {
      return /* legacy */ binary_http_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous035: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalItipEmailTransport.sys.mjs"),
                                         "ItipContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::URIFixup: {
      MOZ_TRY(CallInitFunc(0));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URIFixup.sys.mjs"),
                                         "URIFixup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous215: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MimeJSComponents.sys.mjs"),
                                         "MimeWritableStructuredHeaders",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous535: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierHashCompleter.sys.mjs"),
                                         "HashCompleter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous665: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsMixedContentBlocker> inst = new nsMixedContentBlocker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous421: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("chrome://remote/content/components/RemoteAgent.sys.mjs"),
                                         "RemoteAgentFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous517: {
      RefPtr<nsIRemoteService> inst = GetRemoteService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(GetRemoteService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(GetRemoteService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIRemoteService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous086: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AbLDAPAttributeMap.sys.mjs"),
                                         "AbLDAPAttributeMapService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous469: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ClearDataService.sys.mjs"),
                                         "ClearDataService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous572: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsFilePicker> inst = new nsFilePicker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous261: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ConsoleAPIStorage.sys.mjs"),
                                         "ConsoleAPIStorageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous004: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalAlarmMonitor.sys.mjs"),
                                         "CalAlarmMonitor",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous608: {
      RefPtr<nsSupportsPRTime> inst = new nsSupportsPRTime();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous300: {
      RefPtr<nsIndexedDBProtocolHandler> inst = new nsIndexedDBProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous216: {
      RefPtr<nsMimeObjectClassAccess> inst = new nsMimeObjectClassAccess();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous316: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsJPEGEncoder> inst = new nsJPEGEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ProtocolProxy: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsProtocolProxyService> inst = new mozilla::net::nsProtocolProxyService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous373: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsSerializationHelper> inst = new nsSerializationHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Copy: {
      RefPtr<nsMsgCopyService> inst = new nsMsgCopyService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous164: {
      RefPtr<nsMsgMailViewList> inst = new nsMsgMailViewList();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous001: {
      RefPtr<TimezoneDatabase> inst = new TimezoneDatabase();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous602: {
      RefPtr<nsSupportsFloat> inst = new nsSupportsFloat();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous360: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAboutCacheEntry> inst = new nsAboutCacheEntry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous027: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalStartupService.sys.mjs"),
                                         "CalStartupService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::XULRuntime: {
      return /* legacy */ mozilla::AppInfoConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous368: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::MozSrcProtocolHandler> inst = mozilla::net::MozSrcProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::MozSrcProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::MozSrcProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::MozSrcProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous220: {
      RefPtr<nsMimePlainEmitter> inst = new nsMimePlainEmitter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous359: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsAboutCache::Create(aIID, aResult);
    }
    case ModuleID::Anonymous432: {
      RefPtr<nsCertOverrideService> inst = new nsCertOverrideService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous331: {
      RefPtr<nsZipReaderCache> inst = new nsZipReaderCache();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous676: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::StorageActivityService> inst = mozilla::dom::StorageActivityService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::StorageActivityService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::StorageActivityService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::StorageActivityService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous308: {
      RefPtr<mozPersonalDictionary> inst = new mozPersonalDictionary();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous423: {
      RefPtr<nsNSSDialogs> inst = new nsNSSDialogs();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::RandomGenerator: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsRandomGenerator>(aIID, aResult);
    }
    case ModuleID::Anonymous100: {
      RefPtr<nsMailAuthModule> inst = new nsMailAuthModule();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous415: {
      RefPtr<mozilla::net::ObliviousHttpService> inst = new mozilla::net::ObliviousHttpService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous063: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/PromptCollection.sys.mjs"),
                                         "PromptCollection",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous023: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalRecurrenceRule.sys.mjs"),
                                         "CalRecurrenceRule",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous525: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SearchService.sys.mjs"),
                                         "SearchService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous527: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TelemetryStartup.sys.mjs"),
                                         "TelemetryStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous530: {
      RefPtr<mozilla::DAPTelemetry> inst = new mozilla::DAPTelemetry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous107: {
      RefPtr<nsMsgFolderCache> inst = new nsMsgFolderCache();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous293: {
      RefPtr<mozilla::dom::PaymentCompleteActionResponse> inst = new mozilla::dom::PaymentCompleteActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous419: {
      RefPtr<mozilla::net::UrlClassifierExceptionListEntry> inst = new mozilla::net::UrlClassifierExceptionListEntry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous484: {
      RefPtr<mozilla::FOG> inst = mozilla::FOG::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::FOG::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::FOG::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::FOG, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous450: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TrackingDBService.sys.mjs"),
                                         "TrackingDBService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous512: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs"),
                                         "PlacesFrecencyRecalculator",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AuthPromptAdapter: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Prompter.sys.mjs"),
                                         "AuthPromptAdapterFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous381: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIInputChannelThrottleQueue> inst = mozilla::net::ThrottleQueue::Create();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ThrottleQueue::Create())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ThrottleQueue::Create())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIInputChannelThrottleQueue, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous448: {
      RefPtr<mozilla::storage::VacuumManager> inst = mozilla::storage::VacuumManager::getSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::storage::VacuumManager::getSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::storage::VacuumManager::getSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::storage::VacuumManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CredentialChooserService: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CredentialChooserService.sys.mjs"),
                                         "CredentialChooserService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous520: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UserCharacteristicsPageService.sys.mjs"),
                                         "UserCharacteristicsPageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous601: {
      RefPtr<nsSupportsDouble> inst = new nsSupportsDouble();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous634: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::BlobURL::Mutator> inst = new mozilla::dom::BlobURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous132: {
      RefPtr<nsMsgComposeContentHandler> inst = new nsMsgComposeContentHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous178: {
      RefPtr<nsCertGen> inst = new nsCertGen();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierStreamUpdater: {
      RefPtr<nsUrlClassifierStreamUpdater> inst = new nsUrlClassifierStreamUpdater();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous342: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewBinaryDetectorFactory(aIID, aResult);
    }
    case ModuleID::Anonymous328: {
      RefPtr<nsJARProtocolHandler> inst = nsJARProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsJARProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsJARProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsJARProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous498: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/crypto-SDR.sys.mjs"),
                                         "LoginManagerCrypto_SDR",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous014: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalIcsParser.sys.mjs"),
                                         "CalIcsParser",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous071: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/VCardUtils.sys.mjs"),
                                         "VCardMimeConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous453: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PartitioningExceptionListService.sys.mjs"),
                                         "PartitioningExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous551: {
      RefPtr<nsWebBrowserPersist> inst = new nsWebBrowserPersist();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous606: {
      RefPtr<nsSupportsPRInt32> inst = new nsSupportsPRInt32();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous076: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPDirectoryQuery.sys.mjs"),
                                         "LDAPDirectoryQuery",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous581: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsDeviceContextSpecGTK> inst = new nsDeviceContextSpecGTK();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous157: {
      RefPtr<nsMailDatabase> inst = new nsMailDatabase();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous655: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::gmp::GeckoMediaPluginService> inst = mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::gmp::GeckoMediaPluginService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous241: {
      RefPtr<nsMsgSearchTerm> inst = new nsMsgSearchTerm();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous324: {
      RefPtr<nsScriptableUnicodeConverter> inst = new nsScriptableUnicodeConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous562: {
      RefPtr<nsISupports> inst = nsDragServiceSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDragServiceSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDragServiceSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous374: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsServerSocket> inst = new mozilla::net::nsServerSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous232: {
      RefPtr<EwsIncomingServer> inst = new EwsIncomingServer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous320: {
      RefPtr<nsMozIconURI::Mutator> inst = new nsMozIconURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DBusHandlerApp: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsDBusHandlerApp> inst = new nsDBusHandlerApp();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous424: {
      RefPtr<nsNSSVersion> inst = new nsNSSVersion();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous590: {
      RefPtr<nsHashPropertyBagCC> inst = new nsHashPropertyBagCC();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous396: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingURL::Mutator> inst = new mozilla::net::SubstitutingURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous367: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsResProtocolHandler> inst = nsResProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsResProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsResProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsResProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous592: {
      return /* legacy */ nsLocalFileConstructor(aIID, aResult);
    }
    case ModuleID::Directory: {
      return /* legacy */ nsDirectoryService::Create(aIID, aResult);
    }
    case ModuleID::Anonymous589: {
      RefPtr<nsChromeProtocolHandler> inst = new nsChromeProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CaptivePortal: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICaptivePortalService> inst = mozilla::net::CaptivePortalService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CaptivePortalService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CaptivePortalService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICaptivePortalService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PlacesPreviewsHelper: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesPreviews.sys.mjs"),
                                         "PlacesPreviewsHelperService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous582: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrintDialogServiceGTK> inst = new nsPrintDialogServiceGTK();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous375: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleStreamListener> inst = new mozilla::net::nsSimpleStreamListener();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous538: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleServices.sys.mjs"),
                                         "AddonLocalizationConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous285: {
      RefPtr<mozilla::dom::notification::NotificationHandler> inst = mozilla::dom::notification::NotificationHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::notification::NotificationHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::notification::NotificationHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::notification::NotificationHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous321: {
      RefPtr<mozilla::intl::OSPreferences> inst = mozilla::intl::OSPreferences::GetInstanceAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::intl::OSPreferences::GetInstanceAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::intl::OSPreferences::GetInstanceAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::intl::OSPreferences, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous348: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileOutputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous286: {
      RefPtr<mozilla::dom::BasicCardMethodChangeDetails> inst = new mozilla::dom::BasicCardMethodChangeDetails();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous087: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AbLDAPAutoCompleteSearch.sys.mjs"),
                                         "AbLDAPAutoCompleteSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous146: {
      RefPtr<nsMsgCompUtils> inst = new nsMsgCompUtils();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous404: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs"),
                                         "SimpleURIUnknownSchemesRemoteObserver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous394: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleNestedURI::Mutator> inst = new mozilla::net::nsSimpleNestedURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous068: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AddrBookCard.sys.mjs"),
                                         "AddrBookCard",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous302: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/NetworkGeolocationProvider.sys.mjs"),
                                         "NetworkGeolocationProvider",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous481: {
      RefPtr<mozilla::extensions::ExtensionsChild> inst = mozilla::extensions::ExtensionsChild::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::ExtensionsChild::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::ExtensionsChild::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::ExtensionsChild, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous672: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::ContentPrincipal::Deserializer> inst = new mozilla::ContentPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous549: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsUnixSystemProxySettings>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ScriptSecurityManager: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ Construct_nsIScriptSecurityManager(aIID, aResult);
    }
    case ModuleID::Import: {
      RefPtr<nsImportService> inst = new nsImportService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous226: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpMessageService.sys.mjs"),
                                         "NntpMessageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous515: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Prompter.sys.mjs"),
                                         "Prompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous265: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::PeerConnectionImpl>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PermissionManager: {
      RefPtr<nsIPermissionManager> inst = mozilla::PermissionManager::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::PermissionManager::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::PermissionManager::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIPermissionManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous167: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NewsBlog.sys.mjs"),
                                         "FeedDownloader",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous304: {
      RefPtr<PermissionDelegateHandler> inst = new PermissionDelegateHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous357: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsINetworkConnectivityService> inst = mozilla::net::NetworkConnectivityService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::NetworkConnectivityService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::NetworkConnectivityService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsINetworkConnectivityService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous229: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpProtocolHandler.sys.mjs"),
                                         "SnewsProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous380: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::nsStreamLoader::Create(aIID, aResult);
    }
    case ModuleID::Anonymous084: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AbAutoCompleteSearch.sys.mjs"),
                                         "AbAutoCompleteSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous247: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/DevToolsStartup.sys.mjs"),
                                         "DevToolsStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous354: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsInputStreamPump> inst = new nsInputStreamPump();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous142: {
      RefPtr<nsSmtpUrl> inst = new nsSmtpUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous610: {
      RefPtr<nsSupportsPRUint32> inst = new nsSupportsPRUint32();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous505: {
      RefPtr<nsNavHistory> inst = nsNavHistory::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsNavHistory::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsNavHistory::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsNavHistory, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous431: {
      return /* legacy */ mozilla::psm::NSSConstructor<ContentSignatureVerifier>(aIID, aResult);
    }
    case ModuleID::Anonymous096: {
      RefPtr<FolderLookupService> inst = new FolderLookupService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous625: {
      return /* legacy */ nsTimer::XPCOMConstructor(aIID, aResult);
    }
    case ModuleID::FileProtocolHandler: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsFileProtocolHandler> inst = new nsFileProtocolHandler();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous474: {
      RefPtr<mozilla::nsCookieBannerRule> inst = new mozilla::nsCookieBannerRule();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous683: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::FakeSpeechRecognitionService> inst = new mozilla::FakeSpeechRecognitionService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous327: {
      RefPtr<nsJAR> inst = new nsJAR();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous569: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<mozilla::widget::ScreenManager> inst = mozilla::widget::ScreenManager::GetAddRefedSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::widget::ScreenManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous362: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsDataHandler::Create(aIID, aResult);
    }
    case ModuleID::Anonymous297: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Push.sys.mjs"),
                                         "Push",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous082: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPSyncQuery.sys.mjs"),
                                         "LDAPSyncQuery",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous061: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/IMIncomingServer.sys.mjs"),
                                         "IMIncomingServer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous016: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalICSService.sys.mjs"),
                                         "CalICSService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous258: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ProcessSelector.sys.mjs"),
                                         "RandomSelector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous192: {
      RefPtr<mailnews::JaCppMsgFolderDelegator> inst = new mailnews::JaCppMsgFolderDelegator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous228: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpProtocolHandler.sys.mjs"),
                                         "NewsProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous311: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<mozilla::image::ImageBlocker> inst = new mozilla::image::ImageBlocker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous214: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MimeJSComponents.sys.mjs"),
                                         "MimeHeaders",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous173: {
      RefPtr<nsCMSDecoder> inst = new nsCMSDecoder();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous471: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/DefaultCLH.sys.mjs"),
                                         "nsDefaultCLH",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous410: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs"),
                                         "ThirdPartyCookieExceptionEntry",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous566: {
      RefPtr<nsISupports> inst = nsScreenManagerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsScreenManagerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsScreenManagerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous526: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SearchSuggestions.sys.mjs"),
                                         "SearchSuggestAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous521: {
      RefPtr<mozilla::nsRFPTargetSetIDL> inst = new mozilla::nsRFPTargetSetIDL();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous256: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsExternalHelperAppService> inst = nsExternalHelperAppService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsExternalHelperAppService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsExternalHelperAppService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsExternalHelperAppService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous059: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///comm/mail/components/devtools/devtools-loader.sys.mjs"),
                                         "DevToolsStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Folder: {
      RefPtr<nsMsgFolderService> inst = new nsMsgFolderService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous031: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalHtmlExport.sys.mjs"),
                                         "CalHtmlExporter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous533: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierLib.sys.mjs"),
                                         "UrlClassifierLib",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous292: {
      RefPtr<mozilla::dom::PaymentCanMakeActionResponse> inst = new mozilla::dom::PaymentCanMakeActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous439: {
      RefPtr<mozilla::psm::CRLiteTimestamp> inst = new mozilla::psm::CRLiteTimestamp();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous508: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesExpiration.sys.mjs"),
                                         "nsPlacesExpiration",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IO: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsIOService> inst = mozilla::net::nsIOService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::nsIOService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::nsIOService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::nsIOService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous326: {
      RefPtr<mozJSSubScriptLoader> inst = new mozJSSubScriptLoader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::BounceTrackingProtection: {
      RefPtr<mozilla::BounceTrackingProtection> inst = mozilla::BounceTrackingProtection::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::BounceTrackingProtection::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::BounceTrackingProtection::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::BounceTrackingProtection, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous604: {
      RefPtr<nsSupportsPRBool> inst = new nsSupportsPRBool();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous662: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateHTMLContentSerializer(aIID, aResult);
    }
    case ModuleID::Anonymous238: {
      return /* legacy */ nsEwsOutgoingServerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous370: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::WebSocketChannelConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous529: {
      MOZ_TRY(CallInitFunc(4));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsITelemetry>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous048: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/yahoo.sys.mjs"),
                                         "YahooProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous556: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ExtHandlerService.sys.mjs"),
                                         "HandlerService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous156: {
      RefPtr<nsMorkFactoryService> inst = new nsMorkFactoryService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous062: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://testing-common/TestProtocol.sys.mjs"),
                                         "TestProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::StreamConverter: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewStreamConvServiceFactory(aIID, aResult);
    }
    case ModuleID::Anonymous395: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsNestedAboutURI::Mutator> inst = new mozilla::net::nsNestedAboutURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous488: {
      RefPtr<nsMediaSniffer> inst = new nsMediaSniffer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous025: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalTodo.sys.mjs"),
                                         "CalTodo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous133: {
      RefPtr<nsMsgCompose> inst = new nsMsgCompose();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous245: {
      RefPtr<mozilla::jsinspector::nsJSInspector> inst = new mozilla::jsinspector::nsJSInspector();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous274: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCStatsReport",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous619: {
      return /* legacy */ nsArrayBase::XPCOMConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous306: {
      RefPtr<nsReadConfig> inst = new nsReadConfig();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous659: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateContentPolicy(aIID, aResult);
    }
    case ModuleID::Anonymous614: {
      return /* legacy */ nsThreadManagerGetSingleton(aIID, aResult);
    }
    case ModuleID::MimeHeaderParam: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsMIMEHeaderParamImpl> inst = new nsMIMEHeaderParamImpl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous037: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalCompositeCalendar.sys.mjs"),
                                         "CalCompositeCalendar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous032: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalItipEmailTransport.sys.mjs"),
                                         "CalItipEmailTransport",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous584: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrinterListCUPS> inst = new nsPrinterListCUPS();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ChromeRegistry: {
      RefPtr<nsChromeRegistry> inst = nsChromeRegistry::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsChromeRegistry::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsChromeRegistry::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsChromeRegistry, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous670: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateParentMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous123: {
      RefPtr<nsMsgShutdownService> inst = new nsMsgShutdownService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous537: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLFormatter.sys.mjs"),
                                         "nsURLFormatterService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous586: {
      RefPtr<mozilla::nsAvailableMemoryWatcherBase> inst = mozilla::nsAvailableMemoryWatcherBase::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsAvailableMemoryWatcherBase::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsAvailableMemoryWatcherBase::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsAvailableMemoryWatcherBase, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous222: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NewsAutoCompleteSearch.sys.mjs"),
                                         "NewsAutoCompleteSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::WindowWatcher: {
      RefPtr<nsWindowWatcher> inst = new nsWindowWatcher();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous272: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCSessionDescription",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous260: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SlowScriptDebug.sys.mjs"),
                                         "SlowScriptDebug",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous596: {
      RefPtr<nsScriptableBase64Encoder> inst = new nsScriptableBase64Encoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous641: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::IntegrityPolicy> inst = new mozilla::dom::IntegrityPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous554: {
      RefPtr<nsToolkitProfileService> inst = NS_GetToolkitProfileService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(NS_GetToolkitProfileService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(NS_GetToolkitProfileService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsToolkitProfileService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ApplicationReputation: {
      RefPtr<ApplicationReputationService> inst = ApplicationReputationService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(ApplicationReputationService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(ApplicationReputationService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<ApplicationReputationService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous577: {
      MOZ_TRY(CallInitFunc(5));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIClipboard>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous664: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsIMediaManagerService> inst = mozilla::MediaManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::MediaManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::MediaManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIMediaManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous209: {
      RefPtr<nsParseMailMessageState> inst = new nsParseMailMessageState();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous438: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsCertTree>(aIID, aResult);
    }
    case ModuleID::Anonymous571: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsColorPicker> inst = new nsColorPicker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous382: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::TLSServerSocket> inst = new mozilla::net::TLSServerSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous455: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLQueryStrippingListService.sys.mjs"),
                                         "URLQueryStrippingListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous623: {
      return /* legacy */ nsStringInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::CategoryManager: {
      return /* legacy */ nsCategoryManager::Create(aIID, aResult);
    }
    case ModuleID::Anonymous503: {
      RefPtr<nsFaviconService> inst = nsFaviconService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFaviconService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFaviconService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsFaviconService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous153: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/SmtpServer.sys.mjs"),
                                         "SmtpServer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous392: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsNestedAboutURI::Mutator> inst = new mozilla::net::nsNestedAboutURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous567: {
      RefPtr<mozilla::widget::ScreenManager> inst = mozilla::widget::ScreenManager::GetAddRefedSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::widget::ScreenManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous468: {
      RefPtr<nsICascadeFilter> inst = mozilla::ConstructCascadeFilter();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ConstructCascadeFilter())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ConstructCascadeFilter())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICascadeFilter, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierDB: {
      return /* legacy */ nsUrlClassifierDBServiceConstructor(aIID, aResult);
    }
    case ModuleID::StringBundle: {
      RefPtr<nsStringBundleService> inst = new nsStringBundleService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous211: {
      RefPtr<nsRssIncomingServer> inst = new nsRssIncomingServer();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous172: {
      RefPtr<nsCMSSecureMessage> inst = new nsCMSSecureMessage();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous675: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsScriptError> inst = new nsScriptError();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous070: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/VCardUtils.sys.mjs"),
                                         "VCardService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous036: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalDavCalendar.sys.mjs"),
                                         "CalDavCalendar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous152: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MailtoProtocolHandler.sys.mjs"),
                                         "MailtoProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous463: {
      RefPtr<mozilla::FinalizationWitnessService> inst = new mozilla::FinalizationWitnessService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous378: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStandardURL::Mutator> inst = new mozilla::net::nsStandardURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous217: {
      RefPtr<nsStreamConverter> inst = new nsStreamConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous637: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentLoaderFactory>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HttpHandler: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::net::nsHttpHandler>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous263: {
      RefPtr<mozilla::dom::IndexedDatabaseManager> inst = mozilla::dom::IndexedDatabaseManager::FactoryCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::IndexedDatabaseManager::FactoryCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::IndexedDatabaseManager::FactoryCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::IndexedDatabaseManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous443: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozISandboxReporter>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous389: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewHTTPCompressConvFactory(aIID, aResult);
    }
    case ModuleID::Anonymous194: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/jsaccount/TestJaMsgProtocolInfoComponent.sys.mjs"),
                                         "TestJaMsgProtocolInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous053: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/ActivityManagerUI.sys.mjs"),
                                         "ActivityManagerUI",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous114: {
      RefPtr<nsMsgSearchDBView> inst = new nsMsgSearchDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous186: {
      RefPtr<nsImapOfflineSync> inst = new nsImapOfflineSync();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous504: {
      RefPtr<nsNavBookmarks> inst = nsNavBookmarks::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsNavBookmarks::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsNavBookmarks::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsNavBookmarks, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous612: {
      RefPtr<nsSupportsPRUint8> inst = new nsSupportsPRUint8();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous267: {
      RefPtr<nsStunUDPSocketFilterHandler> inst = new nsStunUDPSocketFilterHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous021: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalRecurrenceDate.sys.mjs"),
                                         "CalRecurrenceDate",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous236: {
      RefPtr<EwsService> inst = new EwsService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous593: {
      RefPtr<nsMemoryInfoDumper> inst = new nsMemoryInfoDumper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous009: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalDateTime.sys.mjs"),
                                         "CalDateTime",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous115: {
      RefPtr<nsMsgQuickSearchDBView> inst = new nsMsgQuickSearchDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::OutgoingServer: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/OutgoingServerService.sys.mjs"),
                                         "OutgoingServerService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous159: {
      RefPtr<nsImapMailDatabase> inst = new nsImapMailDatabase();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous276: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCRtpSender",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous113: {
      RefPtr<nsMsgWatchedThreadsWithUnreadDBView> inst = new nsMsgWatchedThreadsWithUnreadDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous317: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsPNGEncoder> inst = new nsPNGEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous298: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PushComponents.sys.mjs"),
                                         "Service",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous175: {
      RefPtr<nsCMSEncoder> inst = new nsCMSEncoder();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous108: {
      RefPtr<nsMsgStatusFeedback> inst = new nsMsgStatusFeedback();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous056: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MessengerContentHandler.sys.mjs"),
                                         "MessengerContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous161: {
      RefPtr<nsMsgDownloadSettings> inst = new nsMsgDownloadSettings();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous422: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("chrome://remote/content/components/Marionette.sys.mjs"),
                                         "MarionetteFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous460: {
      RefPtr<BackgroundTasksRunner> inst = new BackgroundTasksRunner();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous105: {
      RefPtr<nsMsgBiffManager> inst = new nsMsgBiffManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous325: {
      RefPtr<mozilla::ipc::UtilityProcessTest> inst = new mozilla::ipc::UtilityProcessTest();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous513: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/MainProcessSingleton.sys.mjs"),
                                         "MainProcessSingleton",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierUtils: {
      RefPtr<nsUrlClassifierUtils> inst = nsUrlClassifierUtils::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsUrlClassifierUtils::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsUrlClassifierUtils::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsUrlClassifierUtils, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous007: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalAttendee.sys.mjs"),
                                         "CalAttendee",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous561: {
      RefPtr<nsColorPickerProxy> inst = new nsColorPickerProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous485: {
      return /* legacy */ nsKeyValueServiceConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous244: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://devtools/client/jsonview/Converter.sys.mjs"),
                                         "Converter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous140: {
      RefPtr<nsMsgAttachedFile> inst = new nsMsgAttachedFile();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous649: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::quota::QuotaManagerService> inst = mozilla::dom::quota::QuotaManagerService::FactoryCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::quota::QuotaManagerService::FactoryCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::quota::QuotaManagerService::FactoryCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::quota::QuotaManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous548: {
      RefPtr<nsSystemAlertsService> inst = new nsSystemAlertsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous352: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsIncrementalStreamLoader::Create(aIID, aResult);
    }
    case ModuleID::Anonymous262: {
      RefPtr<mozilla::dom::BlobURLProtocolHandler> inst = new mozilla::dom::BlobURLProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous511: {
      RefPtr<mozISyncedBookmarksMerger> inst = mozilla::places::NewSyncedBookmarksMerger();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::NewSyncedBookmarksMerger())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::NewSyncedBookmarksMerger())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozISyncedBookmarksMerger, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous020: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalProtocolHandler.sys.mjs"),
                                         "CalProtocolHandlerWebcals",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous078: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPService.sys.mjs"),
                                         "LDAPService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous679: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::net::WebSocketEventService> inst = mozilla::net::WebSocketEventService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::WebSocketEventService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::WebSocketEventService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::WebSocketEventService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous350: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsHttpAuthManager> inst = new mozilla::net::nsHttpAuthManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IdentityCredentialStorageService: {
      RefPtr<mozilla::IdentityCredentialStorageService> inst = mozilla::IdentityCredentialStorageService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::IdentityCredentialStorageService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::IdentityCredentialStorageService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::IdentityCredentialStorageService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CORSPreflightCache: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICORSPreflightCache> inst = nsCORSListenerProxy::GetCORSPreflightSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsCORSListenerProxy::GetCORSPreflightSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsCORSListenerProxy::GetCORSPreflightSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICORSPreflightCache, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous657: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateGlobalMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous246: {
      RefPtr<mozilla::jsdebugger::JSDebugger> inst = new mozilla::jsdebugger::JSDebugger();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous181: {
      RefPtr<nsImapMockChannel> inst = new nsImapMockChannel();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous425: {
      return /* legacy */ mozilla::psm::NSSConstructor<SecretDecoderRing>(aIID, aResult);
    }
    case ModuleID::Anonymous307: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozHunspell>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous445: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://services-settings/RemoteSettingsComponents.sys.mjs"),
                                         "RemoteSettingsTimer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous250: {
      MOZ_TRY(CallInitFunc(0));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URIFixup.sys.mjs"),
                                         "URIFixupInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous074: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPOperation.sys.mjs"),
                                         "LDAPOperation",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous532: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TooltipTextProvider.sys.mjs"),
                                         "TooltipTextProvider",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous635: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateChildMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous224: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpProtocolInfo.sys.mjs"),
                                         "NntpProtocolInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AsyncShutdown: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/nsAsyncShutdown.sys.mjs"),
                                         "nsAsyncShutdownService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous195: {
      RefPtr<nsPop3Sink> inst = new nsPop3Sink();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AccountManager: {
      RefPtr<nsMsgAccountManager> inst = new nsMsgAccountManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous145: {
      RefPtr<nsMsgQuoteListener> inst = new nsMsgQuoteListener();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous079: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPURLParser.sys.mjs"),
                                         "LDAPURLParser",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous363: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::net::nsHttpsHandler>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous219: {
      RefPtr<nsMimeXmlEmitter> inst = new nsMimeXmlEmitter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous674: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ScriptableContentIterator> inst = new ScriptableContentIterator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous502: {
      RefPtr<nsCachedFaviconProtocolHandler> inst = new nsCachedFaviconProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous609: {
      RefPtr<nsSupportsPRUint16> inst = new nsSupportsPRUint16();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous205: {
      RefPtr<nsMsgLocalMailFolder> inst = new nsMsgLocalMailFolder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous402: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsISupports> inst = mozilla::net::GetSFVService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::GetSFVService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::GetSFVService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous633: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::BlobURL::Mutator> inst = new mozilla::dom::BlobURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous083: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AbAutoCompleteMyDomain.sys.mjs"),
                                         "AbAutoCompleteMyDomain",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous271: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCIceCandidate",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::TypeAheadFind: {
      RefPtr<nsTypeAheadFind> inst = new nsTypeAheadFind();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous570: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<TaskbarProgress> inst = new TaskbarProgress();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous497: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginInfo.sys.mjs"),
                                         "nsLoginInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous019: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalProtocolHandler.sys.mjs"),
                                         "CalProtocolHandlerWebcal",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous041: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/facebook.sys.mjs"),
                                         "FacebookProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IdentityCredentialPromptService: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/IdentityCredentialPromptService.sys.mjs"),
                                         "IdentityCredentialPromptService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous376: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleURI::Mutator> inst = new mozilla::net::nsSimpleURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous284: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///dom/notification/NotificationStorage.sys.mjs"),
                                         "MemoryNotificationStorage",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous492: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/MozProtocolHandler.sys.mjs"),
                                         "MozProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous110: {
      RefPtr<nsSubscribableServer> inst = new nsSubscribableServer();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous495: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginAutoComplete.sys.mjs"),
                                         "LoginAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous351: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ net_NewIncrementalDownload(aIID, aResult);
    }
    case ModuleID::Anonymous347: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileInputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous310: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<imgLoader> inst = new imgLoader();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous668: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsNoDataProtocolContentPolicy> inst = new nsNoDataProtocolContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous430: {
      return /* legacy */ crypto_hash_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous669: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::NullPrincipal::Deserializer> inst = new mozilla::NullPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous279: {
      RefPtr<mozilla::RddProcessTest> inst = new mozilla::RddProcessTest();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous102: {
      RefPtr<nsMessenger> inst = new nsMessenger();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous017: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalItipItem.sys.mjs"),
                                         "CalItipItem",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous390: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewMultiMixedConvFactory(aIID, aResult);
    }
    case ModuleID::Anonymous343: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsBufferedInputStream::Create(aIID, aResult);
    }
    case ModuleID::AlertNotification: {
      RefPtr<mozilla::AlertNotification> inst = new mozilla::AlertNotification();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous046: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/twitter.sys.mjs"),
                                         "TwitterProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::nsIContentAnalysis: {
      RefPtr<mozilla::contentanalysis::ContentAnalysis> inst = new mozilla::contentanalysis::ContentAnalysis();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierPrefixSet: {
      RefPtr<nsUrlClassifierPrefixSet> inst = new nsUrlClassifierPrefixSet();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous003: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalAlarm.sys.mjs"),
                                         "CalAlarm",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CookieBannerService: {
      RefPtr<mozilla::nsCookieBannerService> inst = mozilla::nsCookieBannerService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsCookieBannerService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsCookieBannerService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsCookieBannerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous134: {
      RefPtr<nsMsgComposeParams> inst = new nsMsgComposeParams();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous089: {
      RefPtr<nsAbCardProperty> inst = new nsAbCardProperty();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous673: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::PushNotifier> inst = new mozilla::dom::PushNotifier();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous296: {
      RefPtr<mozilla::dom::power::PowerManagerService> inst = mozilla::dom::power::PowerManagerService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::power::PowerManagerService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::power::PowerManagerService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::power::PowerManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous121: {
      RefPtr<nsCidProtocolHandler> inst = new nsCidProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous518: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FingerprintingWebCompatService.sys.mjs"),
                                         "FingerprintingOverride",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous660: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateXMLContentSerializer(aIID, aResult);
    }
    case ModuleID::Anonymous496: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerAuthPrompter.sys.mjs"),
                                         "LoginManagerAuthPrompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous235: {
      RefPtr<EwsFolder> inst = new EwsFolder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous104: {
      RefPtr<nsMsgIdentity> inst = new nsMsgIdentity();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous191: {
      RefPtr<mailnews::JaCppIncomingServerDelegator> inst = new mailnews::JaCppIncomingServerDelegator();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous033: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalItipProtocolHandler.sys.mjs"),
                                         "ItipChannel",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous583: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrintSettingsServiceGTK> inst = new nsPrintSettingsServiceGTK();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous578: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsClipboardHelper> inst = new nsClipboardHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous280: {
      RefPtr<mozilla::dom::SpeechDispatcherService> inst = mozilla::dom::SpeechDispatcherService::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::SpeechDispatcherService::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::SpeechDispatcherService::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::SpeechDispatcherService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous491: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/mozIntl.sys.mjs"),
                                         "MozIntl",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous177: {
      RefPtr<nsCertPicker> inst = new nsCertPicker();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous442: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozISandboxSettings>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous179: {
      RefPtr<nsImapUrl> inst = new nsImapUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous182: {
      RefPtr<nsImapHostSessionList> inst = new nsImapHostSessionList();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous399: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingJARURI> inst = new mozilla::net::SubstitutingJARURI();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous671: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsParserUtils> inst = new nsParserUtils();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous176: {
      RefPtr<nsCMSMessage> inst = new nsCMSMessage();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::SystemInfo: {
      RefPtr<nsSystemInfo> inst = new nsSystemInfo();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous519: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FingerprintingWebCompatService.sys.mjs"),
                                         "FingerprintingWebCompatService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous064: {
      RefPtr<nsGNOMEShellService> inst = new nsGNOMEShellService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous065: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AME2E.sys.mjs"),
                                         "E2EService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous437: {
      RefPtr<psm::PublicKeyPinningService> inst = new psm::PublicKeyPinningService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous013: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalFreeBusyService.sys.mjs"),
                                         "CalFreeBusyService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::FindService: {
      RefPtr<nsFindService> inst = new nsFindService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous447: {
      RefPtr<mozilla::storage::Service> inst = mozilla::storage::Service::getSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::storage::Service::getSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::storage::Service::getSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::storage::Service, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous638: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsStyleSheetService> inst = new nsStyleSheetService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous168: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NewsBlog.sys.mjs"),
                                         "FeedAcctMgrExtension",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous309: {
      RefPtr<nsThebesFontEnumerator> inst = new nsThebesFontEnumerator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous073: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPConnection.sys.mjs"),
                                         "LDAPConnection",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous427: {
      return /* legacy */ mozilla::psm::NSSConstructor<mozilla::psm::PKCS11ModuleDB>(aIID, aResult);
    }
    case ModuleID::Anonymous470: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ClearBySiteEntry.sys.mjs"),
                                         "ClearBySiteEntry",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous648: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ SessionStorageManagerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous252: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsOSPermissionRequest> inst = new nsOSPermissionRequest();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous109: {
      RefPtr<nsMsgWindow> inst = new nsMsgWindow();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous135: {
      RefPtr<nsMsgComposeSendListener> inst = new nsMsgComposeSendListener();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous136: {
      RefPtr<nsMsgComposeProgressParams> inst = new nsMsgComposeProgressParams();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous682: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::OnlineSpeechRecognitionService> inst = new mozilla::OnlineSpeechRecognitionService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous434: {
      return /* legacy */ mozilla::psm::NSSConstructor<OSKeyStore>(aIID, aResult);
    }
    case ModuleID::Anonymous403: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICookieJarSettings> inst = mozilla::net::CookieJarSettings::CreateForXPCOM();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CookieJarSettings::CreateForXPCOM())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CookieJarSettings::CreateForXPCOM())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICookieJarSettings, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous426: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsPK11TokenDB>(aIID, aResult);
    }
    case ModuleID::Anonymous677: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsIPrincipal> inst = nsScriptSecurityManager::SystemPrincipalSingletonConstructor();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsScriptSecurityManager::SystemPrincipalSingletonConstructor())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsScriptSecurityManager::SystemPrincipalSingletonConstructor())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIPrincipal, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous069: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CardDAVDirectory.sys.mjs"),
                                         "CardDAVDirectory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous412: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs"),
                                         "WellKnownOpportunisticUtils",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous653: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ExpandedPrincipal::Deserializer> inst = new ExpandedPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous433: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::psm::TransportSecurityInfo>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous630: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSURI::Mutator> inst = new nsJSURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous479: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/DownloadLegacy.sys.mjs"),
                                         "DownloadLegacyTransfer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DocLoader: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsDocLoader> inst = new nsDocLoader();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous251: {
      MOZ_TRY(CallInitFunc(0));
      return /* legacy */ nsAboutRedirector::Create(aIID, aResult);
    }
    case ModuleID::Anonymous208: {
      RefPtr<nsNoIncomingServer> inst = new nsNoIncomingServer();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous349: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileRandomAccessStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous560: {
      RefPtr<nsISupports> inst = nsColorPickerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsColorPickerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsColorPickerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous097: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MsgAsyncPrompter.sys.mjs"),
                                         "MsgAsyncPrompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous428: {
      RefPtr<nsNSSCertificate> inst = new nsNSSCertificate();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous184: {
      RefPtr<nsImapMailFolder> inst = new nsImapMailFolder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous335: {
      MOZ_TRY(CallInitFunc(2));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsPrefOverrideMap>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous119: {
      RefPtr<nsMsgProgress> inst = new nsMsgProgress();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous435: {
      return /* legacy */ mozilla::psm::NSSConstructor<OSReauthenticator>(aIID, aResult);
    }
    case ModuleID::DB: {
      RefPtr<nsMsgDBService> inst = new nsMsgDBService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous544: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amWebAPI.sys.mjs"),
                                         "WebAPI",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NSSComponent: {
      RefPtr<nsNSSComponent> inst = new nsNSSComponent();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::History: {
      RefPtr<mozilla::places::History> inst = mozilla::places::History::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::History::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::History::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::places::History, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous458: {
      RefPtr<BackgroundTasks> inst = BackgroundTasks::GetSingletonAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(BackgroundTasks::GetSingletonAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(BackgroundTasks::GetSingletonAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<BackgroundTasks, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous030: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalIcsImportExport.sys.mjs"),
                                         "CalIcsExporter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous275: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCPeerConnectionStatic",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous377: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::DefaultURI::Mutator> inst = new mozilla::net::DefaultURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous465: {
      RefPtr<nsParentalControlsService> inst = new nsParentalControlsService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous620: {
      return /* legacy */ nsMultiplexInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous542: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amManager.sys.mjs"),
                                         "BlocklistService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous333: {
      RefPtr<nsZipWriter> inst = new nsZipWriter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous391: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewTXTToHTMLConvFactory(aIID, aResult);
    }
    case ModuleID::Anonymous288: {
      RefPtr<mozilla::dom::GeneralMethodChangeDetails> inst = new mozilla::dom::GeneralMethodChangeDetails();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::SiteSecurity: {
      RefPtr<nsSiteSecurityService> inst = new nsSiteSecurityService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous253: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsIHandlerService> inst = mozilla::dom::ContentHandlerService::Create();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::ContentHandlerService::Create())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::ContentHandlerService::Create())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIHandlerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PrivateAttribution: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PrivateAttributionService.sys.mjs"),
                                         "PrivateAttributionService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous131: {
      return /* legacy */ nsLinuxSysTrayHandlerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous600: {
      RefPtr<nsSupportsChar> inst = new nsSupportsChar();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous663: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreatePlainTextSerializer(aIID, aResult);
    }
    case ModuleID::Anonymous151: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/SMTPProtocolHandler.sys.mjs"),
                                         "SMTPSProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous461: {
      RefPtr<nsWebBrowserContentPolicy> inst = new nsWebBrowserContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous094: {
      RefPtr<nsAbDirectoryQueryProxy> inst = new nsAbDirectoryQueryProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous185: {
      RefPtr<nsAutoSyncManager> inst = new nsAutoSyncManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous607: {
      RefPtr<nsSupportsPRInt64> inst = new nsSupportsPRInt64();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous587: {
      RefPtr<nsBinaryInputStream> inst = new nsBinaryInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous010: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalDeletedItems.sys.mjs"),
                                         "CalDeletedItems",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous632: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsOpenWindowInfo> inst = new nsOpenWindowInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous541: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/HelperAppDlg.sys.mjs"),
                                         "nsUnknownContentTypeDialog",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous318: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsWebPEncoder> inst = new nsWebPEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous118: {
      RefPtr<nsMsgOfflineManager> inst = new nsMsgOfflineManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NSSCertificateDB: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsNSSCertificateDB>(aIID, aResult);
    }
    case ModuleID::Anonymous646: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsStructuredCloneContainer> inst = new nsStructuredCloneContainer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous067: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/SQLiteDirectory.sys.mjs"),
                                         "SQLiteDirectory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous303: {
      RefPtr<nsISupports> inst = mozilla::dom::NewWebAuthnService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::NewWebAuthnService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::NewWebAuthnService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous615: {
      RefPtr<nsVariantCC> inst = new nsVariantCC();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HeaderParser: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MimeJSComponents.sys.mjs"),
                                         "MimeAddressParser",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous077: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPReplicationService.sys.mjs"),
                                         "LDAPReplicationService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous555: {
      RefPtr<nsProfiler> inst = new nsProfiler();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous398: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingURL::Mutator> inst = new mozilla::net::SubstitutingURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous266: {
      RefPtr<nsStunTCPSocketFilterHandler> inst = new nsStunTCPSocketFilterHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous364: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::ExtensionProtocolHandler> inst = mozilla::net::ExtensionProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ExtensionProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ExtensionProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::ExtensionProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous227: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpMessageService.sys.mjs"),
                                         "NewsMessageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous540: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/XULStore.sys.mjs"),
                                         "XULStore",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous098: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MsgAsyncPrompter.sys.mjs"),
                                         "MsgAuthPrompt",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous678: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::TextInputProcessor> inst = new mozilla::TextInputProcessor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous405: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIMockNetworkLayerController> inst = mozilla::net::MockNetworkLayerController::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::MockNetworkLayerController::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::MockNetworkLayerController::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIMockNetworkLayerController, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ThirdPartyUtil: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ThirdPartyUtil> inst = new ThirdPartyUtil();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous441: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/psm/ClientAuthDialogService.sys.mjs"),
                                         "ClientAuthDialogService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous242: {
      RefPtr<nsMsgSearchValidityManager> inst = new nsMsgSearchValidityManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous636: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentLoaderFactory>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous197: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Pop3Service.sys.mjs"),
                                         "Pop3Service",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous345: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsINativeDNSResolverOverride> inst = mozilla::net::NativeDNSResolverOverride::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::NativeDNSResolverOverride::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::NativeDNSResolverOverride::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsINativeDNSResolverOverride, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous483: {
      RefPtr<mozilla::extensions::WebNavigationContent> inst = mozilla::extensions::WebNavigationContent::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::WebNavigationContent::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::WebNavigationContent::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::WebNavigationContent, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous154: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/GlodaAutoComplete.sys.mjs"),
                                         "GlodaAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous319: {
      RefPtr<nsIconProtocolHandler> inst = new nsIconProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous355: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsLoadGroupConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous120: {
      RefPtr<nsSpamSettings> inst = new nsSpamSettings();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous337: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::LoadContextInfoFactory> inst = new mozilla::net::LoadContextInfoFactory();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous314: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsBMPEncoder> inst = new nsBMPEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Filter: {
      RefPtr<nsMsgFilterService> inst = new nsMsgFilterService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous523: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FormHistoryAutoComplete.sys.mjs"),
                                         "FormHistoryAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous329: {
      RefPtr<nsJARURI::Mutator> inst = new nsJARURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::SocketTransport: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSocketTransportService> inst = new mozilla::net::nsSocketTransportService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous196: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Pop3IncomingServer.sys.mjs"),
                                         "Pop3IncomingServer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PageThumbsStorage: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PageThumbsStorageService.sys.mjs"),
                                         "PageThumbsStorageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous269: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "PeerConnectionObserver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous112: {
      RefPtr<nsMsgThreadsWithUnreadDBView> inst = new nsMsgThreadsWithUnreadDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous124: {
      RefPtr<nsMailDirProvider> inst = new nsMailDirProvider();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous652: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIEventListenerService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous408: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::CachePurgeLock> inst = new mozilla::net::CachePurgeLock();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous576: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsApplicationChooser> inst = new nsApplicationChooser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous088: {
      RefPtr<nsLDAPURL> inst = new nsLDAPURL();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous616: {
      RefPtr<nsVersionComparatorImpl> inst = new nsVersionComparatorImpl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous259: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ProcessSelector.sys.mjs"),
                                         "MinTabSelector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous383: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsUDPSocket> inst = new mozilla::net::nsUDPSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous273: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "GlobalPCList",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous680: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::EventSourceEventService> inst = mozilla::dom::EventSourceEventService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::EventSourceEventService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::EventSourceEventService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::EventSourceEventService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous301: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsISessionStorageService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous564: {
      RefPtr<nsISupports> inst = nsFilePickerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFilePickerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFilePickerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous254: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<PlatformLocalHandlerApp_t> inst = new PlatformLocalHandlerApp_t();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous466: {
      RefPtr<mozilla::nsTerminator> inst = new mozilla::nsTerminator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous552: {
      RefPtr<nsXREDirProvider> inst = nsXREDirProvider::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsXREDirProvider::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsXREDirProvider::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsXREDirProvider, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous451: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLDecorationAnnotationsService.sys.mjs"),
                                         "URLDecorationAnnotationsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DBView: {
      RefPtr<nsMsgDBViewService> inst = new nsMsgDBViewService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous656: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::Geolocation> inst = mozilla::dom::Geolocation::NonWindowSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::Geolocation::NonWindowSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::Geolocation::NonWindowSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::Geolocation, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous248: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutDebuggingRegistration.sys.mjs"),
                                         "AboutDebugging",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous385: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsNoAuthURLParser> inst = new nsNoAuthURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous111: {
      RefPtr<nsMsgThreadedDBView> inst = new nsMsgThreadedDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous187: {
      RefPtr<nsImportABFromMab> inst = new nsImportABFromMab();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous580: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsUserIdleService> inst = nsUserIdleServiceGTK::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsUserIdleServiceGTK::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsUserIdleServiceGTK::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsUserIdleService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous139: {
      RefPtr<nsMsgAttachmentData> inst = new nsMsgAttachmentData();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous353: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsInputStreamChannel> inst = new mozilla::net::nsInputStreamChannel();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous060: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/IMProtocolInfo.sys.mjs"),
                                         "IMProtocolInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous534: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierListManager.sys.mjs"),
                                         "RegistrationData",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous473: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentPrefService2.sys.mjs"),
                                         "ContentPrefService2",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous499: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerPrompter.sys.mjs"),
                                         "LoginManagerPrompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous621: {
      return /* legacy */ nsPipeConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous476: {
      RefPtr<mozilla::nsCookieBannerTelemetryService> inst = mozilla::nsCookieBannerTelemetryService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsCookieBannerTelemetryService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsCookieBannerTelemetryService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsCookieBannerTelemetryService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous099: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/OAuth2Module.sys.mjs"),
                                         "OAuth2Module",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous346: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsDownloader> inst = new nsDownloader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous559: {
      RefPtr<nsClipboardProxy> inst = new nsClipboardProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous539: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleServices.sys.mjs"),
                                         "HttpIndexViewer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous201: {
      RefPtr<nsMsgMailNewsUrl> inst = new nsMsgMailNewsUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::FolderNotification: {
      RefPtr<nsMsgFolderNotificationService> inst = new nsMsgFolderNotificationService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous008: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalCalendarManager.sys.mjs"),
                                         "CalCalendarManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous647: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ LocalStorageManagerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous568: {
      MOZ_TRY(CallInitFunc(5));
      return /* legacy */ nsAppShellConstructor(aIID, aResult);
    }
    case ModuleID::DNS: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIDNSService> inst = nsDNSService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDNSService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDNSService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIDNSService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous305: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/RemotePermissionService.sys.mjs"),
                                         "RemotePermissionService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CacheStorage: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::CacheStorageService> inst = new mozilla::net::CacheStorageService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous546: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentDispatchChooser.sys.mjs"),
                                         "nsContentDispatchChooser",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous531: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UpdateTimerManager.sys.mjs"),
                                         "TimerManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Alerts: {
      RefPtr<nsAlertsService> inst = new nsAlertsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::EffectiveTLD: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIEffectiveTLDService> inst = nsEffectiveTLDService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsEffectiveTLDService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsEffectiveTLDService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIEffectiveTLDService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous547: {
      RefPtr<nsGIOService> inst = new nsGIOService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous588: {
      RefPtr<nsBinaryOutputStream> inst = new nsBinaryOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous050: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Activity.sys.mjs"),
                                         "ActivityEvent",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous166: {
      RefPtr<nsMsgMdnGenerator> inst = new nsMsgMdnGenerator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous457: {
      RefPtr<nsAutoCompleteSimpleResult> inst = new nsAutoCompleteSimpleResult();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous322: {
      RefPtr<nsConverterInputStream> inst = new nsConverterInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous015: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalIcsSerializer.sys.mjs"),
                                         "CalIcsSerializer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous006: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalAttachment.sys.mjs"),
                                         "CalAttachment",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous203: {
      RefPtr<nsPop3URL> inst = new nsPop3URL();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous289: {
      RefPtr<mozilla::dom::GeneralResponseData> inst = new mozilla::dom::GeneralResponseData();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous401: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICookieService> inst = mozilla::net::CookieService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CookieService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CookieService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICookieService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous093: {
      RefPtr<nsAbBooleanExpression> inst = new nsAbBooleanExpression();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous487: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs"),
                                         "WindowsMediaFoundationCDMOriginsListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous018: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalPeriod.sys.mjs"),
                                         "CalPeriod",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous644: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsDataDocumentContentPolicy> inst = new nsDataDocumentContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous137: {
      RefPtr<nsMsgCompFields> inst = new nsMsgCompFields();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous528: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TelemetryControllerContent.sys.mjs"),
                                         "getTelemetryController",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ContentSecurityManager: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsContentSecurityManager> inst = new nsContentSecurityManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous225: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpService.sys.mjs"),
                                         "NntpService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous640: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<CSPService> inst = new CSPService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous627: {
      RefPtr<nsAppShellService> inst = new nsAppShellService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous456: {
      RefPtr<nsAutoCompleteController> inst = new nsAutoCompleteController();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous510: {
      RefPtr<mozilla::places::PageIconProtocolHandler> inst = mozilla::places::PageIconProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::PageIconProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::PageIconProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::places::PageIconProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous106: {
      RefPtr<nsMsgPurgeService> inst = new nsMsgPurgeService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::MimeConverter: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MimeJSComponents.sys.mjs"),
                                         "MimeConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous597: {
      RefPtr<nsSecurityConsoleMessage> inst = new nsSecurityConsoleMessage();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous416: {
      RefPtr<mozilla::net::ReplacedHttpResponse> inst = new mozilla::net::ReplacedHttpResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous138: {
      RefPtr<nsMsgAttachment> inst = new nsMsgAttachment();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::WifiMonitor: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsWifiMonitor> inst = new nsWifiMonitor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous290: {
      RefPtr<mozilla::dom::PaymentAbortActionResponse> inst = new mozilla::dom::PaymentAbortActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous231: {
      RefPtr<nsMsgNewsFolder> inst = new nsMsgNewsFolder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous341: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::BackgroundFileSaverStreamListener> inst = new mozilla::net::BackgroundFileSaverStreamListener();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous340: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::BackgroundFileSaverOutputStream> inst = new mozilla::net::BackgroundFileSaverOutputStream();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous125: {
      RefPtr<nsStopwatch> inst = new nsStopwatch();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous147: {
      RefPtr<nsMsgCopy> inst = new nsMsgCopy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous243: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://devtools/client/jsonview/Sniffer.sys.mjs"),
                                         "Sniffer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous361: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsAboutProtocolHandler> inst = new mozilla::net::nsAboutProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous212: {
      return /* legacy */ nsPgpMimeMimeContentTypeHandlerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous613: {
      RefPtr<nsSupportsString> inst = new nsSupportsString();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous141: {
      RefPtr<nsMsgSendLater> inst = new nsMsgSendLater();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous454: {
      RefPtr<mozilla::ContentBlockingTelemetryService> inst = mozilla::ContentBlockingTelemetryService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ContentBlockingTelemetryService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ContentBlockingTelemetryService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::ContentBlockingTelemetryService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous283: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///dom/notification/NotificationStorage.sys.mjs"),
                                         "NotificationStorage",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous230: {
      RefPtr<nsNntpUrl> inst = new nsNntpUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous044: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/matrix.sys.mjs"),
                                         "MatrixProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous295: {
      RefPtr<mozilla::dom::PaymentShowActionResponse> inst = new mozilla::dom::PaymentShowActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::URLQueryStringStripper: {
      RefPtr<mozilla::URLQueryStringStripper> inst = mozilla::URLQueryStringStripper::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::URLQueryStringStripper::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::URLQueryStringStripper::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::URLQueryStringStripper, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous452: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PurgeTrackerService.sys.mjs"),
                                         "PurgeTrackerService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous055: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MailGlue.sys.mjs"),
                                         "MailGlue",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous475: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CookieBannerListService.sys.mjs"),
                                         "CookieBannerListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous126: {
      RefPtr<mailnews::MailNewsDLF> inst = new mailnews::MailNewsDLF();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous371: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::WebSocketSSLChannelConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous011: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalDuration.sys.mjs"),
                                         "CalDuration",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous494: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerAuthPrompter.sys.mjs"),
                                         "LoginManagerAuthPromptFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous117: {
      RefPtr<nsMsgGroupView> inst = new nsMsgGroupView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous400: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleURI::Mutator> inst = new mozilla::net::nsSimpleURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous249: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs"),
                                         "AboutDevtoolsToolbox",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous507: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TaggingService.sys.mjs"),
                                         "TagAutoCompleteSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HttpActivityDistributor: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsHttpActivityDistributor> inst = new mozilla::net::nsHttpActivityDistributor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous365: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::PageThumbProtocolHandler> inst = mozilla::net::PageThumbProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::PageThumbProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::PageThumbProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::PageThumbProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous066: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/PgpMimeHandler.sys.mjs"),
                                         "PgpMimeHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous464: {
      RefPtr<nsBrowserStatusFilter> inst = new nsBrowserStatusFilter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous058: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MessengerContentHandler.sys.mjs"),
                                         "MessengerProfileMigrator",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous617: {
      RefPtr<nsINIParserFactory> inst = new nsINIParserFactory();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous095: {
      RefPtr<nsAbLDIFService> inst = new nsAbLDIFService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous573: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsHTMLFormatConverter> inst = new nsHTMLFormatConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous162: {
      RefPtr<nsBayesianFilter> inst = new nsBayesianFilter();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous444: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FxAccountsPush.sys.mjs"),
                                         "FxAccountsPushService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous436: {
      return /* legacy */ cert_storage_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous143: {
      RefPtr<nsMailtoUrl> inst = new nsMailtoUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous388: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewUnknownDecoderFactory(aIID, aResult);
    }
    case ModuleID::Anonymous299: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/QuotaUtilsService.sys.mjs"),
                                         "QuotaUtilsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous414: {
      return /* legacy */ oblivious_http_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous603: {
      RefPtr<nsSupportsInterfacePointer> inst = new nsSupportsInterfacePointer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous667: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSProtocolHandler> inst = new nsJSProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous658: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<inDeepTreeWalker> inst = new inDeepTreeWalker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous051: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Activity.sys.mjs"),
                                         "ActivityWarning",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous446: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIStartupCacheInfo>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous129: {
      RefPtr<nsISupports> inst = SyncStreamListenerCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(SyncStreamListenerCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(SyncStreamListenerCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous666: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::ReferrerInfo> inst = new mozilla::dom::ReferrerInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous085: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AbLDAPAttributeMap.sys.mjs"),
                                         "AbLDAPAttributeMap",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous642: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::IntegrityPolicyService> inst = new mozilla::dom::IntegrityPolicyService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::MailSession: {
      RefPtr<nsMsgMailSession> inst = new nsMsgMailSession();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous477: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/nsCrashMonitor.sys.mjs"),
                                         "CrashMonitor",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous081: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPProtocolHandler.sys.mjs"),
                                         "LDAPSProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous384: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsStdURLParser> inst = new nsStdURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous654: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIFocusManager>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous579: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsDragService> inst = nsDragService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDragService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDragService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsDragService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous000: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalDefaultACLManager.sys.mjs"),
                                         "CalDefaultACLManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous221: {
      RefPtr<nsMimeRawEmitter> inst = new nsMimeRawEmitter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::URILoader: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsURILoader> inst = new nsURILoader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous411: {
      RefPtr<nsGIOProtocolHandler> inst = nsGIOProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsGIOProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsGIOProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsGIOProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous198: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/Pop3ProtocolInfo.sys.mjs"),
                                         "Pop3ProtocolInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous524: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FormHistoryStartup.sys.mjs"),
                                         "FormHistoryStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous149: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MessageSend.sys.mjs"),
                                         "MessageSend",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DownloadPlatform: {
      RefPtr<DownloadPlatform> inst = new DownloadPlatform();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous024: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalRelation.sys.mjs"),
                                         "CalRelation",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous622: {
      return /* legacy */ nsScriptableInputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous155: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MimeMessageEmitter.sys.mjs"),
                                         "MimeMessageEmitter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous264: {
      RefPtr<mozilla::dom::LoginDetectionService> inst = mozilla::dom::LoginDetectionService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::LoginDetectionService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::LoginDetectionService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::LoginDetectionService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous397: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStandardURL::Mutator> inst = new mozilla::net::nsStandardURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous575: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsTransferable> inst = new nsTransferable();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::TextToSubURI: {
      RefPtr<nsTextToSubURI> inst = new nsTextToSubURI();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous190: {
      RefPtr<mailnews::JaCppComposeDelegator> inst = new mailnews::JaCppComposeDelegator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous218: {
      RefPtr<nsMimeHtmlDisplayEmitter> inst = new nsMimeHtmlDisplayEmitter();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous239: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MsgTraitService.sys.mjs"),
                                         "MsgTraitService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous598: {
      RefPtr<nsStorageStream> inst = new nsStorageStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous103: {
      RefPtr<nsMsgAccount> inst = new nsMsgAccount();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ExternalProtocolHandler: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsExternalProtocolHandler> inst = new nsExternalProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous516: {
      RefPtr<mozilla::reflect::Module> inst = new mozilla::reflect::Module();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous202: {
      RefPtr<nsMailboxService> inst = new nsMailboxService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous651: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::WorkerDebuggerManager> inst = mozilla::dom::WorkerDebuggerManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::WorkerDebuggerManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::WorkerDebuggerManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::WorkerDebuggerManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Preferences: {
      MOZ_TRY(CallInitFunc(2));
      RefPtr<mozilla::Preferences> inst = mozilla::Preferences::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::Preferences::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::Preferences::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::Preferences, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous223: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/NntpIncomingServer.sys.mjs"),
                                         "NntpIncomingServer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NetworkErrorLogging: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/NetworkErrorLogging.sys.mjs"),
                                         "NetworkErrorLogging",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous386: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAuthURLParser> inst = new nsAuthURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous558: {
      RefPtr<nsISupports> inst = nsClipboardSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsClipboardSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsClipboardSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Compose: {
      RefPtr<nsMsgComposeService> inst = new nsMsgComposeService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous628: {
      RefPtr<nsWindowMediator> inst = new nsWindowMediator();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous618: {
      return /* legacy */ nsComponentManagerImpl::Create(aIID, aResult);
    }
    case ModuleID::Anonymous038: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalICSCalendar.sys.mjs"),
                                         "CalICSCalendar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous012: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalEvent.sys.mjs"),
                                         "CalEvent",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous315: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsICOEncoder> inst = new nsICOEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous650: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ mozilla::dom::SDBConnection::Create(aIID, aResult);
    }
    case ModuleID::Anonymous234: {
      return /* legacy */ NS_CreateEwsClient(aIID, aResult);
    }
    case ModuleID::Anonymous490: {
      RefPtr<mozilla::MozIntlHelper> inst = new mozilla::MozIntlHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous287: {
      RefPtr<mozilla::dom::BasicCardResponseData> inst = new mozilla::dom::BasicCardResponseData();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous626: {
      RefPtr<nsTimerManager> inst = new nsTimerManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous204: {
      RefPtr<nsNoneService> inst = new nsNoneService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous486: {
      return /* legacy */ nsSQLiteKeyValueServiceConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous366: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSafeAboutProtocolHandler> inst = new mozilla::net::nsSafeAboutProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous449: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/BTPRemoteExceptionList.sys.mjs"),
                                         "BTPRemoteExceptionList",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous180: {
      RefPtr<nsImapProtocol> inst = new nsImapProtocol();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous043: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/irc.sys.mjs"),
                                         "ircProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous174: {
      RefPtr<nsCMSDecoderJS> inst = new nsCMSDecoderJS();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous080: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/LDAPProtocolHandler.sys.mjs"),
                                         "LDAPProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous002: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalTimezoneService.sys.mjs"),
                                         "CalTimezoneService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Observer: {
      return /* legacy */ nsObserverService::Create(aIID, aResult);
    }
    case ModuleID::Anonymous379: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStreamListenerTee> inst = new mozilla::net::nsStreamListenerTee();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous429: {
      RefPtr<nsClientAuthRememberService> inst = new nsClientAuthRememberService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous338: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAsyncStreamCopier> inst = new nsAsyncStreamCopier();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Imap: {
      RefPtr<nsImapService> inst = new nsImapService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous091: {
      RefPtr<nsAbDirectoryQueryArguments> inst = new nsAbDirectoryQueryArguments();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous183: {
      RefPtr<nsImapIncomingServer> inst = new nsImapIncomingServer();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AbManager: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AddrBookManager.sys.mjs"),
                                         "AddrBookManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous332: {
      RefPtr<nsDeflateConverter> inst = new nsDeflateConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous599: {
      RefPtr<nsSupportsCString> inst = new nsSupportsCString();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous493: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManager.sys.mjs"),
                                         "LoginManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous026: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalWeekInfoService.sys.mjs"),
                                         "CalWeekInfoService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous467: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CaptiveDetect.sys.mjs"),
                                         "CaptivePortalDetector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous501: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/pdfjs.sys.mjs"),
                                         "StreamConverterFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous557: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WebHandlerApp.sys.mjs"),
                                         "nsWebHandlerApp",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous514: {
      RefPtr<nsIProcessToolsService> inst = GetProcessToolsService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(GetProcessToolsService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(GetProcessToolsService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIProcessToolsService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous233: {
      RefPtr<EwsProtocolInfo> inst = new EwsProtocolInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous369: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsViewSourceHandler> inst = new mozilla::net::nsViewSourceHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous193: {
      RefPtr<mailnews::JaCppUrlDelegator> inst = new mailnews::JaCppUrlDelegator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Tag: {
      RefPtr<nsMsgTagService> inst = new nsMsgTagService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous563: {
      RefPtr<nsDragServiceProxy> inst = new nsDragServiceProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous595: {
      RefPtr<nsProcess> inst = new nsProcess();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous639: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsCSPContext> inst = new nsCSPContext();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous130: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/VirtualFolderWrapper.sys.mjs"),
                                         "VirtualFolderWrapper",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous257: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentAreaDropListener.sys.mjs"),
                                         "ContentAreaDropListener",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous681: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::nsSynthVoiceRegistry> inst = mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::nsSynthVoiceRegistry, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous574: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsISound> inst = nsSound::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsSound::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsSound::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISound, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous553: {
      RefPtr<nsDialogParamBlock> inst = new nsDialogParamBlock();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous358: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsAboutBlank::Create(aIID, aResult);
    }
    case ModuleID::Anonymous440: {
      RefPtr<mozilla::DataStorageManager> inst = new mozilla::DataStorageManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous356: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsMIMEInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous158: {
      RefPtr<nsNewsDatabase> inst = new nsNewsDatabase();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous407: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsNetworkLinkService> inst = new nsNetworkLinkService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous040: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalStorageCalendar.sys.mjs"),
                                         "CalStorageCalendar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous057: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/MessengerContentHandler.sys.mjs"),
                                         "MessageDisplayContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous624: {
      return /* legacy */ nsEnvironment::Create(aIID, aResult);
    }
    case ModuleID::Anonymous545: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amContentHandler.sys.mjs"),
                                         "amContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UUIDGenerator: {
      RefPtr<nsUUIDGenerator> inst = new nsUUIDGenerator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous189: {
      RefPtr<mailnews::JaCppAbDirectoryDelegator> inst = new mailnews::JaCppAbDirectoryDelegator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous148: {
      RefPtr<nsMsgSendReport> inst = new nsMsgSendReport();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous472: {
      RefPtr<mozilla::ContentBlockingAllowList> inst = new mozilla::ContentBlockingAllowList();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Dashboard: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::Dashboard> inst = new mozilla::net::Dashboard();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous459: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/BackgroundTasksManager.sys.mjs"),
                                         "BackgroundTasksManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous281: {
      RefPtr<mozilla::dom::nsFakeSynthServices> inst = mozilla::dom::nsFakeSynthServices::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::nsFakeSynthServices::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::nsFakeSynthServices::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::nsFakeSynthServices, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous591: {
      RefPtr<nsIOUtil> inst = new nsIOUtil();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous543: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amManager.sys.mjs"),
                                         "amManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous039: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/CalMemoryCalendar.sys.mjs"),
                                         "CalMemoryCalendar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous116: {
      RefPtr<nsMsgXFVirtualFolderDBView> inst = new nsMsgXFVirtualFolderDBView();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ExtensionPolicy: {
      RefPtr<mozilla::ExtensionPolicyService> inst = mozilla::ExtensionPolicyService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ExtensionPolicyService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ExtensionPolicyService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::ExtensionPolicyService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous336: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<ArrayBufferInputStream> inst = new ArrayBufferInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous200: {
      RefPtr<nsMailboxUrl> inst = new nsMailboxUrl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous045: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/odnoklassniki.sys.mjs"),
                                         "OdnoklassnikiProtocol",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous631: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentViewer>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous144: {
      RefPtr<nsMsgQuote> inst = new nsMsgQuote();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous643: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<PolicyContainer> inst = new PolicyContainer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NSSErrors: {
      RefPtr<mozilla::psm::NSSErrorsService> inst = new mozilla::psm::NSSErrorsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous565: {
      RefPtr<nsFilePickerProxy> inst = new nsFilePickerProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous210: {
      RefPtr<nsRssService> inst = new nsRssService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous482: {
      RefPtr<mozilla::extensions::NativeMessagingPortal> inst = mozilla::extensions::NativeMessagingPortal::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::NativeMessagingPortal::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::NativeMessagingPortal::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::NativeMessagingPortal, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous169: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/OfflineStartup.sys.mjs"),
                                         "OfflineStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous255: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsWebNavigationInfo> inst = new nsWebNavigationInfo();
      return inst->QueryInterface(aIID, aResult);
    }
  }

  MOZ_ASSERT_UNREACHABLE("Constructor didn't return");
  return NS_ERROR_FAILURE;
}


namespace {

class StaticModuleFactory final : public nsIFactory {
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFACTORY

  explicit StaticModuleFactory(ModuleID aID) : mID(aID) {}

private:
  ~StaticModuleFactory() = default;

  const ModuleID mID;
};

NS_IMPL_ISUPPORTS(StaticModuleFactory, nsIFactory)

NS_IMETHODIMP StaticModuleFactory::CreateInstance(const nsIID& aIID,
                                                  void** aResult) {
  return CreateInstanceImpl(mID, aIID, aResult);
}

}  // anonymous namespace


already_AddRefed<nsIFactory> StaticModule::GetFactory() const {
  return do_AddRef(new StaticModuleFactory(ID()));
}

bool StaticModule::Active() const {
  return FastProcessSelectorMatches(mProcessSelector);
}

bool StaticModule::Overridable() const {
  return mContractID.mOffset != kNoContractID;
}

nsCString StaticModule::ContractID() const {
  MOZ_ASSERT(Overridable());
  return GetString(mContractID);
}

nsresult StaticModule::CreateInstance(const nsIID& aIID, void** aResult) const {
  return CreateInstanceImpl(ID(), aIID, aResult);
}

GetServiceHelper StaticModule::GetService() const {
  return { ID(), nullptr };
}

GetServiceHelper StaticModule::GetService(nsresult* aRv) const {
  return { ID(), aRv };
}


nsISupports* StaticModule::ServiceInstance() const {
  return gServiceInstances[Idx()];
}

void StaticModule::SetServiceInstance(
    already_AddRefed<nsISupports> aInst) const {
  gServiceInstances[Idx()] = aInst;
}


nsCString StaticCategoryEntry::Entry() const {
  return GetString(mEntry);
}

nsCString StaticCategoryEntry::Value() const {
  return GetString(mValue);
}

bool StaticCategoryEntry::Active() const {
  if (!FastProcessSelectorMatches(mProcessSelector)) {
    return false;
  }
#ifdef MOZ_BACKGROUNDTASKS
  if (MOZ_UNLIKELY(BackgroundTasks::IsBackgroundTaskMode())) {
    return mBackgroundTasksSelector != Module::BackgroundTasksSelector::NO_TASKS;
  }
#endif /* MOZ_BACKGROUNDTASKS */
  return true;
}

nsCString StaticCategory::Name() const {
  return GetString(mName);
}

nsCString JSServiceEntry::Name() const {
  return GetString(mName);
}

JSServiceEntry::InterfaceList JSServiceEntry::Interfaces() const {
  InterfaceList iids;
  iids.SetCapacity(mInterfaceCount);

  for (size_t i = 0; i < mInterfaceCount; i++) {
    nsXPTInterface ifaceID = gInterfaces[mInterfaceOffset.mOffset + i];
    iids.AppendElement(&nsXPTInterfaceInfo::Get(ifaceID)->IID());
  }
  return iids;
}


/* static */
const JSServiceEntry* JSServiceEntry::Lookup(const nsACString& aName) {
  return LookupJSService(aName);
}

nsCString StaticProtocolHandler::Scheme() const {
  return GetString(mScheme);
}

/* static */
const StaticProtocolHandler* StaticProtocolHandler::Lookup(const nsACString& aScheme) {
  return LookupProtocolHandler(aScheme);
}

/* static */ const StaticModule* StaticComponents::LookupByCID(
    const nsID& aCID) {
  return ModuleByCID(aCID);
}

/* static */ const StaticModule* StaticComponents::LookupByContractID(
    const nsACString& aContractID) {
  if (const ContractEntry* entry = LookupContractID(aContractID)) {
    if (!entry->Invalid()) {
      return &entry->Module();
    }
  }
  return nullptr;
}

/* static */ bool StaticComponents::InvalidateContractID(
    const nsACString& aContractID, bool aInvalid) {
  if (const ContractEntry* entry = LookupContractID(aContractID)) {
    entry->SetInvalid(aInvalid);
    return true;
  }
  return false;
}

/* static */ already_AddRefed<nsIUTF8StringEnumerator>
StaticComponents::GetComponentESModules() {
  auto esModules = MakeUnique<nsTArray<nsCString>>(std::size(gComponentESModules));

  for (const auto& entry : gComponentESModules) {
    esModules->AppendElement(GetString(entry));
  }

  nsCOMPtr<nsIUTF8StringEnumerator> result;
  MOZ_ALWAYS_SUCCEEDS(NS_NewAdoptingUTF8StringEnumerator(getter_AddRefs(result),
                                                         esModules.release()));
  return result.forget();
}

/* static */ Span<const JSServiceEntry> StaticComponents::GetJSServices() {
  return { gJSServices, std::size(gJSServices) };
}

/* static */ void StaticComponents::Shutdown() {
  CallUnloadFuncs();
}

/* static */ const nsID& Components::GetCID(ModuleID aID) {
  return gStaticModules[size_t(aID)].CID();
}

nsresult GetServiceHelper::operator()(const nsIID& aIID, void** aResult) const {
  nsresult rv =
      nsComponentManagerImpl::gComponentManager->GetService(mId, aIID, aResult);
  return SetResult(rv);
}

nsresult CreateInstanceHelper::operator()(const nsIID& aIID,
                                          void** aResult) const {
  const auto& entry = gStaticModules[size_t(mId)];
  if (!entry.Active()) {
    return SetResult(NS_ERROR_FACTORY_NOT_REGISTERED);
  }

  nsresult rv = entry.CreateInstance(aIID, aResult);
  return SetResult(rv);
}

}  // namespace xpcom
}  // namespace mozilla
