/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "iio-sensor-proxy-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface net.hadess.SensorProxy
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MsDBusSensorProxy
 * @title: MsDBusSensorProxy
 * @short_description: Generated C code for the net.hadess.SensorProxy D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link> D-Bus interface in C.
 */

/* ---- Introspection data for net.hadess.SensorProxy ---- */

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_claim_accelerometer =
{
  {
    -1,
    (gchar *) "ClaimAccelerometer",
    NULL,
    NULL,
    NULL
  },
  "handle-claim-accelerometer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_release_accelerometer =
{
  {
    -1,
    (gchar *) "ReleaseAccelerometer",
    NULL,
    NULL,
    NULL
  },
  "handle-release-accelerometer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_claim_light =
{
  {
    -1,
    (gchar *) "ClaimLight",
    NULL,
    NULL,
    NULL
  },
  "handle-claim-light",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_release_light =
{
  {
    -1,
    (gchar *) "ReleaseLight",
    NULL,
    NULL,
    NULL
  },
  "handle-release-light",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_claim_proximity =
{
  {
    -1,
    (gchar *) "ClaimProximity",
    NULL,
    NULL,
    NULL
  },
  "handle-claim-proximity",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_method_info_release_proximity =
{
  {
    -1,
    (gchar *) "ReleaseProximity",
    NULL,
    NULL,
    NULL
  },
  "handle-release-proximity",
  FALSE
};

static const GDBusMethodInfo * const _ms_dbus_sensor_proxy_method_info_pointers[] =
{
  &_ms_dbus_sensor_proxy_method_info_claim_accelerometer.parent_struct,
  &_ms_dbus_sensor_proxy_method_info_release_accelerometer.parent_struct,
  &_ms_dbus_sensor_proxy_method_info_claim_light.parent_struct,
  &_ms_dbus_sensor_proxy_method_info_release_light.parent_struct,
  &_ms_dbus_sensor_proxy_method_info_claim_proximity.parent_struct,
  &_ms_dbus_sensor_proxy_method_info_release_proximity.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_has_accelerometer =
{
  {
    -1,
    (gchar *) "HasAccelerometer",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-accelerometer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_accelerometer_orientation =
{
  {
    -1,
    (gchar *) "AccelerometerOrientation",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "accelerometer-orientation",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_has_ambient_light =
{
  {
    -1,
    (gchar *) "HasAmbientLight",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-ambient-light",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_light_level_unit =
{
  {
    -1,
    (gchar *) "LightLevelUnit",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "light-level-unit",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_light_level =
{
  {
    -1,
    (gchar *) "LightLevel",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "light-level",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_has_proximity =
{
  {
    -1,
    (gchar *) "HasProximity",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-proximity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_property_info_proximity_near =
{
  {
    -1,
    (gchar *) "ProximityNear",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "proximity-near",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ms_dbus_sensor_proxy_property_info_pointers[] =
{
  &_ms_dbus_sensor_proxy_property_info_has_accelerometer.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_accelerometer_orientation.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_has_ambient_light.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_light_level_unit.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_light_level.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_has_proximity.parent_struct,
  &_ms_dbus_sensor_proxy_property_info_proximity_near.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ms_dbus_sensor_proxy_interface_info =
{
  {
    -1,
    (gchar *) "net.hadess.SensorProxy",
    (GDBusMethodInfo **) &_ms_dbus_sensor_proxy_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_ms_dbus_sensor_proxy_property_info_pointers,
    NULL
  },
  "sensor-proxy",
};


/**
 * ms_dbus_sensor_proxy_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ms_dbus_sensor_proxy_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct;
}

/**
 * ms_dbus_sensor_proxy_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MsDBusSensorProxy interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ms_dbus_sensor_proxy_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "has-accelerometer");
  g_object_class_override_property (klass, property_id_begin++, "accelerometer-orientation");
  g_object_class_override_property (klass, property_id_begin++, "has-ambient-light");
  g_object_class_override_property (klass, property_id_begin++, "light-level-unit");
  g_object_class_override_property (klass, property_id_begin++, "light-level");
  g_object_class_override_property (klass, property_id_begin++, "has-proximity");
  g_object_class_override_property (klass, property_id_begin++, "proximity-near");
  return property_id_begin - 1;
}


inline static void
ms_dbus_sensor_proxy_method_marshal_claim_accelerometer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_method_marshal_release_accelerometer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_method_marshal_claim_light (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_method_marshal_release_light (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_method_marshal_claim_proximity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_method_marshal_release_proximity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MsDBusSensorProxy:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link>.
 */

/**
 * MsDBusSensorProxyIface:
 * @parent_iface: The parent interface.
 * @handle_claim_accelerometer: Handler for the #MsDBusSensorProxy::handle-claim-accelerometer signal.
 * @handle_claim_light: Handler for the #MsDBusSensorProxy::handle-claim-light signal.
 * @handle_claim_proximity: Handler for the #MsDBusSensorProxy::handle-claim-proximity signal.
 * @handle_release_accelerometer: Handler for the #MsDBusSensorProxy::handle-release-accelerometer signal.
 * @handle_release_light: Handler for the #MsDBusSensorProxy::handle-release-light signal.
 * @handle_release_proximity: Handler for the #MsDBusSensorProxy::handle-release-proximity signal.
 * @get_accelerometer_orientation: Getter for the #MsDBusSensorProxy:accelerometer-orientation property.
 * @get_has_accelerometer: Getter for the #MsDBusSensorProxy:has-accelerometer property.
 * @get_has_ambient_light: Getter for the #MsDBusSensorProxy:has-ambient-light property.
 * @get_has_proximity: Getter for the #MsDBusSensorProxy:has-proximity property.
 * @get_light_level: Getter for the #MsDBusSensorProxy:light-level property.
 * @get_light_level_unit: Getter for the #MsDBusSensorProxy:light-level-unit property.
 * @get_proximity_near: Getter for the #MsDBusSensorProxy:proximity-near property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link>.
 */

typedef MsDBusSensorProxyIface MsDBusSensorProxyInterface;
G_DEFINE_INTERFACE (MsDBusSensorProxy, ms_dbus_sensor_proxy, G_TYPE_OBJECT)

static void
ms_dbus_sensor_proxy_default_init (MsDBusSensorProxyIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MsDBusSensorProxy::handle-claim-accelerometer:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimAccelerometer">ClaimAccelerometer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_claim_accelerometer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-claim-accelerometer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_claim_accelerometer),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_claim_accelerometer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxy::handle-release-accelerometer:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseAccelerometer">ReleaseAccelerometer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_release_accelerometer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-accelerometer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_release_accelerometer),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_release_accelerometer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxy::handle-claim-light:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimLight">ClaimLight()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_claim_light() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-claim-light",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_claim_light),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_claim_light,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxy::handle-release-light:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseLight">ReleaseLight()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_release_light() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-light",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_release_light),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_release_light,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxy::handle-claim-proximity:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimProximity">ClaimProximity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_claim_proximity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-claim-proximity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_claim_proximity),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_claim_proximity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxy::handle-release-proximity:
   * @object: A #MsDBusSensorProxy.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseProximity">ReleaseProximity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_complete_release_proximity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-proximity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyIface, handle_release_proximity),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_method_marshal_release_proximity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * MsDBusSensorProxy:has-accelerometer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.HasAccelerometer">"HasAccelerometer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-accelerometer", "HasAccelerometer", "HasAccelerometer", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:accelerometer-orientation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.AccelerometerOrientation">"AccelerometerOrientation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("accelerometer-orientation", "AccelerometerOrientation", "AccelerometerOrientation", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:has-ambient-light:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.HasAmbientLight">"HasAmbientLight"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-ambient-light", "HasAmbientLight", "HasAmbientLight", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:light-level-unit:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevelUnit">"LightLevelUnit"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("light-level-unit", "LightLevelUnit", "LightLevelUnit", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:light-level:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevel">"LightLevel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("light-level", "LightLevel", "LightLevel", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:has-proximity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.HasProximity">"HasProximity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-proximity", "HasProximity", "HasProximity", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxy:proximity-near:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy.ProximityNear">"ProximityNear"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("proximity-near", "ProximityNear", "ProximityNear", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ms_dbus_sensor_proxy_get_has_accelerometer: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.HasAccelerometer">"HasAccelerometer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ms_dbus_sensor_proxy_get_has_accelerometer (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), FALSE);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_has_accelerometer (object);
}

/**
 * ms_dbus_sensor_proxy_set_has_accelerometer: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.HasAccelerometer">"HasAccelerometer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_has_accelerometer (MsDBusSensorProxy *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-accelerometer", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_accelerometer_orientation: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.AccelerometerOrientation">"AccelerometerOrientation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ms_dbus_sensor_proxy_dup_accelerometer_orientation() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ms_dbus_sensor_proxy_get_accelerometer_orientation (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), NULL);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_accelerometer_orientation (object);
}

/**
 * ms_dbus_sensor_proxy_dup_accelerometer_orientation: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets a copy of the <link linkend="gdbus-property-net-hadess-SensorProxy.AccelerometerOrientation">"AccelerometerOrientation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ms_dbus_sensor_proxy_dup_accelerometer_orientation (MsDBusSensorProxy *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "accelerometer-orientation", &value, NULL);
  return value;
}

/**
 * ms_dbus_sensor_proxy_set_accelerometer_orientation: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.AccelerometerOrientation">"AccelerometerOrientation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_accelerometer_orientation (MsDBusSensorProxy *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "accelerometer-orientation", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_has_ambient_light: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.HasAmbientLight">"HasAmbientLight"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ms_dbus_sensor_proxy_get_has_ambient_light (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), FALSE);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_has_ambient_light (object);
}

/**
 * ms_dbus_sensor_proxy_set_has_ambient_light: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.HasAmbientLight">"HasAmbientLight"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_has_ambient_light (MsDBusSensorProxy *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-ambient-light", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_light_level_unit: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevelUnit">"LightLevelUnit"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ms_dbus_sensor_proxy_dup_light_level_unit() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ms_dbus_sensor_proxy_get_light_level_unit (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), NULL);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_light_level_unit (object);
}

/**
 * ms_dbus_sensor_proxy_dup_light_level_unit: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets a copy of the <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevelUnit">"LightLevelUnit"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ms_dbus_sensor_proxy_dup_light_level_unit (MsDBusSensorProxy *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "light-level-unit", &value, NULL);
  return value;
}

/**
 * ms_dbus_sensor_proxy_set_light_level_unit: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevelUnit">"LightLevelUnit"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_light_level_unit (MsDBusSensorProxy *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "light-level-unit", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_light_level: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevel">"LightLevel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
ms_dbus_sensor_proxy_get_light_level (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), 0.0);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_light_level (object);
}

/**
 * ms_dbus_sensor_proxy_set_light_level: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.LightLevel">"LightLevel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_light_level (MsDBusSensorProxy *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "light-level", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_has_proximity: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.HasProximity">"HasProximity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ms_dbus_sensor_proxy_get_has_proximity (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), FALSE);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_has_proximity (object);
}

/**
 * ms_dbus_sensor_proxy_set_has_proximity: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.HasProximity">"HasProximity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_has_proximity (MsDBusSensorProxy *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-proximity", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_get_proximity_near: (skip)
 * @object: A #MsDBusSensorProxy.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy.ProximityNear">"ProximityNear"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ms_dbus_sensor_proxy_get_proximity_near (MsDBusSensorProxy *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY (object), FALSE);

  return MS_DBUS_SENSOR_PROXY_GET_IFACE (object)->get_proximity_near (object);
}

/**
 * ms_dbus_sensor_proxy_set_proximity_near: (skip)
 * @object: A #MsDBusSensorProxy.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy.ProximityNear">"ProximityNear"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_set_proximity_near (MsDBusSensorProxy *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "proximity-near", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_call_claim_accelerometer:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimAccelerometer">ClaimAccelerometer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_claim_accelerometer_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_claim_accelerometer_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_claim_accelerometer (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClaimAccelerometer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_claim_accelerometer_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_claim_accelerometer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_claim_accelerometer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_accelerometer_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_claim_accelerometer_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimAccelerometer">ClaimAccelerometer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_claim_accelerometer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_accelerometer_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClaimAccelerometer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_accelerometer:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseAccelerometer">ReleaseAccelerometer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_release_accelerometer_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_release_accelerometer_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_release_accelerometer (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseAccelerometer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_release_accelerometer_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_release_accelerometer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_release_accelerometer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_accelerometer_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_accelerometer_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseAccelerometer">ReleaseAccelerometer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_release_accelerometer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_accelerometer_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseAccelerometer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_claim_light:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimLight">ClaimLight()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_claim_light_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_claim_light_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_claim_light (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClaimLight",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_claim_light_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_claim_light().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_claim_light().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_light_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_claim_light_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimLight">ClaimLight()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_claim_light() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_light_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClaimLight",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_light:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseLight">ReleaseLight()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_release_light_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_release_light_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_release_light (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseLight",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_release_light_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_release_light().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_release_light().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_light_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_light_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseLight">ReleaseLight()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_release_light() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_light_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseLight",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_claim_proximity:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimProximity">ClaimProximity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_claim_proximity_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_claim_proximity_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_claim_proximity (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClaimProximity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_claim_proximity_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_claim_proximity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_claim_proximity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_proximity_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_claim_proximity_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimProximity">ClaimProximity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_claim_proximity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_claim_proximity_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClaimProximity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_proximity:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseProximity">ReleaseProximity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_call_release_proximity_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_call_release_proximity_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_call_release_proximity (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseProximity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_call_release_proximity_finish:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_call_release_proximity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_call_release_proximity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_proximity_finish (
    MsDBusSensorProxy *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_call_release_proximity_sync:
 * @proxy: A #MsDBusSensorProxyProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseProximity">ReleaseProximity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_call_release_proximity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_call_release_proximity_sync (
    MsDBusSensorProxy *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseProximity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_complete_claim_accelerometer:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimAccelerometer">ClaimAccelerometer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_claim_accelerometer (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_complete_release_accelerometer:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseAccelerometer">ReleaseAccelerometer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_release_accelerometer (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_complete_claim_light:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimLight">ClaimLight()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_claim_light (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_complete_release_light:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseLight">ReleaseLight()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_release_light (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_complete_claim_proximity:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ClaimProximity">ClaimProximity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_claim_proximity (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_complete_release_proximity:
 * @object: A #MsDBusSensorProxy.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy.ReleaseProximity">ReleaseProximity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_complete_release_proximity (
    MsDBusSensorProxy *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MsDBusSensorProxyProxy:
 *
 * The #MsDBusSensorProxyProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MsDBusSensorProxyProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MsDBusSensorProxyProxy.
 */

struct _MsDBusSensorProxyProxyPrivate
{
  GData *qdata;
};

static void ms_dbus_sensor_proxy_proxy_iface_init (MsDBusSensorProxyIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyProxy, ms_dbus_sensor_proxy_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MsDBusSensorProxyProxy)
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY, ms_dbus_sensor_proxy_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyProxy, ms_dbus_sensor_proxy_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY, ms_dbus_sensor_proxy_proxy_iface_init))

#endif
static void
ms_dbus_sensor_proxy_proxy_finalize (GObject *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ms_dbus_sensor_proxy_proxy_parent_class)->finalize (object);
}

static void
ms_dbus_sensor_proxy_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ms_dbus_sensor_proxy_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface net.hadess.SensorProxy: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ms_dbus_sensor_proxy_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "net.hadess.SensorProxy", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ms_dbus_sensor_proxy_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ms_dbus_sensor_proxy_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MS_DBUS_TYPE_SENSOR_PROXY);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MS_DBUS_TYPE_SENSOR_PROXY);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ms_dbus_sensor_proxy_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
ms_dbus_sensor_proxy_proxy_get_has_accelerometer (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasAccelerometer");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ms_dbus_sensor_proxy_proxy_get_accelerometer_orientation (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AccelerometerOrientation");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_proxy_get_has_ambient_light (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasAmbientLight");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ms_dbus_sensor_proxy_proxy_get_light_level_unit (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LightLevelUnit");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
ms_dbus_sensor_proxy_proxy_get_light_level (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LightLevel");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_proxy_get_has_proximity (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasProximity");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_proxy_get_proximity_near (MsDBusSensorProxy *object)
{
  MsDBusSensorProxyProxy *proxy = MS_DBUS_SENSOR_PROXY_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ProximityNear");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
ms_dbus_sensor_proxy_proxy_init (MsDBusSensorProxyProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ms_dbus_sensor_proxy_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MS_DBUS_TYPE_SENSOR_PROXY_PROXY, MsDBusSensorProxyProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ms_dbus_sensor_proxy_interface_info ());
}

static void
ms_dbus_sensor_proxy_proxy_class_init (MsDBusSensorProxyProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ms_dbus_sensor_proxy_proxy_finalize;
  gobject_class->get_property = ms_dbus_sensor_proxy_proxy_get_property;
  gobject_class->set_property = ms_dbus_sensor_proxy_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ms_dbus_sensor_proxy_proxy_g_signal;
  proxy_class->g_properties_changed = ms_dbus_sensor_proxy_proxy_g_properties_changed;

  ms_dbus_sensor_proxy_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MsDBusSensorProxyProxyPrivate));
#endif
}

static void
ms_dbus_sensor_proxy_proxy_iface_init (MsDBusSensorProxyIface *iface)
{
  iface->get_has_accelerometer = ms_dbus_sensor_proxy_proxy_get_has_accelerometer;
  iface->get_accelerometer_orientation = ms_dbus_sensor_proxy_proxy_get_accelerometer_orientation;
  iface->get_has_ambient_light = ms_dbus_sensor_proxy_proxy_get_has_ambient_light;
  iface->get_light_level_unit = ms_dbus_sensor_proxy_proxy_get_light_level_unit;
  iface->get_light_level = ms_dbus_sensor_proxy_proxy_get_light_level;
  iface->get_has_proximity = ms_dbus_sensor_proxy_proxy_get_has_proximity;
  iface->get_proximity_near = ms_dbus_sensor_proxy_proxy_get_proximity_near;
}

/**
 * ms_dbus_sensor_proxy_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_proxy_new_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ms_dbus_sensor_proxy_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MS_DBUS_TYPE_SENSOR_PROXY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy", NULL);
}

/**
 * ms_dbus_sensor_proxy_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_proxy_new().
 *
 * Returns: (transfer full) (type MsDBusSensorProxyProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxy *
ms_dbus_sensor_proxy_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY (ret);
  else
    return NULL;
}

/**
 * ms_dbus_sensor_proxy_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MsDBusSensorProxyProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxy *
ms_dbus_sensor_proxy_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MS_DBUS_TYPE_SENSOR_PROXY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy", NULL);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY (ret);
  else
    return NULL;
}


/**
 * ms_dbus_sensor_proxy_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ms_dbus_sensor_proxy_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ms_dbus_sensor_proxy_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MS_DBUS_TYPE_SENSOR_PROXY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy", NULL);
}

/**
 * ms_dbus_sensor_proxy_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MsDBusSensorProxyProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxy *
ms_dbus_sensor_proxy_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY (ret);
  else
    return NULL;
}

/**
 * ms_dbus_sensor_proxy_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ms_dbus_sensor_proxy_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MsDBusSensorProxyProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxy *
ms_dbus_sensor_proxy_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MS_DBUS_TYPE_SENSOR_PROXY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy", NULL);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MsDBusSensorProxySkeleton:
 *
 * The #MsDBusSensorProxySkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MsDBusSensorProxySkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MsDBusSensorProxySkeleton.
 */

struct _MsDBusSensorProxySkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ms_dbus_sensor_proxy_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MS_DBUS_TYPE_SENSOR_PROXY);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MS_DBUS_TYPE_SENSOR_PROXY);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ms_dbus_sensor_proxy_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ms_dbus_sensor_proxy_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ms_dbus_sensor_proxy_skeleton_vtable =
{
  _ms_dbus_sensor_proxy_skeleton_handle_method_call,
  _ms_dbus_sensor_proxy_skeleton_handle_get_property,
  _ms_dbus_sensor_proxy_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ms_dbus_sensor_proxy_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ms_dbus_sensor_proxy_interface_info ();
}

static GDBusInterfaceVTable *
ms_dbus_sensor_proxy_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ms_dbus_sensor_proxy_skeleton_vtable;
}

static GVariant *
ms_dbus_sensor_proxy_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ms_dbus_sensor_proxy_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ms_dbus_sensor_proxy_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ms_dbus_sensor_proxy_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ms_dbus_sensor_proxy_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.hadess.SensorProxy", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ms_dbus_sensor_proxy_emit_changed (gpointer user_data);

static void
ms_dbus_sensor_proxy_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ms_dbus_sensor_proxy_emit_changed (skeleton);
}

static void ms_dbus_sensor_proxy_skeleton_iface_init (MsDBusSensorProxyIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxySkeleton, ms_dbus_sensor_proxy_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MsDBusSensorProxySkeleton)
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY, ms_dbus_sensor_proxy_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxySkeleton, ms_dbus_sensor_proxy_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY, ms_dbus_sensor_proxy_skeleton_iface_init))

#endif
static void
ms_dbus_sensor_proxy_skeleton_finalize (GObject *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ms_dbus_sensor_proxy_skeleton_parent_class)->finalize (object);
}

static void
ms_dbus_sensor_proxy_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ms_dbus_sensor_proxy_emit_changed (gpointer user_data)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "net.hadess.SensorProxy",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ms_dbus_sensor_proxy_schedule_emit_changed (MsDBusSensorProxySkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ms_dbus_sensor_proxy_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ms_dbus_sensor_proxy_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ms_dbus_sensor_proxy_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ms_dbus_sensor_proxy_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ms_dbus_sensor_proxy_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ms_dbus_sensor_proxy_skeleton_init (MsDBusSensorProxySkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ms_dbus_sensor_proxy_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MS_DBUS_TYPE_SENSOR_PROXY_SKELETON, MsDBusSensorProxySkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static gboolean 
ms_dbus_sensor_proxy_skeleton_get_has_accelerometer (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ms_dbus_sensor_proxy_skeleton_get_accelerometer_orientation (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_skeleton_get_has_ambient_light (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ms_dbus_sensor_proxy_skeleton_get_light_level_unit (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
ms_dbus_sensor_proxy_skeleton_get_light_level (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_skeleton_get_has_proximity (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
ms_dbus_sensor_proxy_skeleton_get_proximity_near (MsDBusSensorProxy *object)
{
  MsDBusSensorProxySkeleton *skeleton = MS_DBUS_SENSOR_PROXY_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ms_dbus_sensor_proxy_skeleton_class_init (MsDBusSensorProxySkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ms_dbus_sensor_proxy_skeleton_finalize;
  gobject_class->get_property = ms_dbus_sensor_proxy_skeleton_get_property;
  gobject_class->set_property = ms_dbus_sensor_proxy_skeleton_set_property;
  gobject_class->notify       = ms_dbus_sensor_proxy_skeleton_notify;


  ms_dbus_sensor_proxy_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ms_dbus_sensor_proxy_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ms_dbus_sensor_proxy_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ms_dbus_sensor_proxy_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ms_dbus_sensor_proxy_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MsDBusSensorProxySkeletonPrivate));
#endif
}

static void
ms_dbus_sensor_proxy_skeleton_iface_init (MsDBusSensorProxyIface *iface)
{
  iface->get_has_accelerometer = ms_dbus_sensor_proxy_skeleton_get_has_accelerometer;
  iface->get_accelerometer_orientation = ms_dbus_sensor_proxy_skeleton_get_accelerometer_orientation;
  iface->get_has_ambient_light = ms_dbus_sensor_proxy_skeleton_get_has_ambient_light;
  iface->get_light_level_unit = ms_dbus_sensor_proxy_skeleton_get_light_level_unit;
  iface->get_light_level = ms_dbus_sensor_proxy_skeleton_get_light_level;
  iface->get_has_proximity = ms_dbus_sensor_proxy_skeleton_get_has_proximity;
  iface->get_proximity_near = ms_dbus_sensor_proxy_skeleton_get_proximity_near;
}

/**
 * ms_dbus_sensor_proxy_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy.top_of_page">net.hadess.SensorProxy</link>.
 *
 * Returns: (transfer full) (type MsDBusSensorProxySkeleton): The skeleton object.
 */
MsDBusSensorProxy *
ms_dbus_sensor_proxy_skeleton_new (void)
{
  return MS_DBUS_SENSOR_PROXY (g_object_new (MS_DBUS_TYPE_SENSOR_PROXY_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface net.hadess.SensorProxy.Compass
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MsDBusSensorProxyCompass
 * @title: MsDBusSensorProxyCompass
 * @short_description: Generated C code for the net.hadess.SensorProxy.Compass D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link> D-Bus interface in C.
 */

/* ---- Introspection data for net.hadess.SensorProxy.Compass ---- */

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_compass_method_info_claim_compass =
{
  {
    -1,
    (gchar *) "ClaimCompass",
    NULL,
    NULL,
    NULL
  },
  "handle-claim-compass",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ms_dbus_sensor_proxy_compass_method_info_release_compass =
{
  {
    -1,
    (gchar *) "ReleaseCompass",
    NULL,
    NULL,
    NULL
  },
  "handle-release-compass",
  FALSE
};

static const GDBusMethodInfo * const _ms_dbus_sensor_proxy_compass_method_info_pointers[] =
{
  &_ms_dbus_sensor_proxy_compass_method_info_claim_compass.parent_struct,
  &_ms_dbus_sensor_proxy_compass_method_info_release_compass.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_compass_property_info_has_compass =
{
  {
    -1,
    (gchar *) "HasCompass",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-compass",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ms_dbus_sensor_proxy_compass_property_info_compass_heading =
{
  {
    -1,
    (gchar *) "CompassHeading",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "compass-heading",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ms_dbus_sensor_proxy_compass_property_info_pointers[] =
{
  &_ms_dbus_sensor_proxy_compass_property_info_has_compass.parent_struct,
  &_ms_dbus_sensor_proxy_compass_property_info_compass_heading.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ms_dbus_sensor_proxy_compass_interface_info =
{
  {
    -1,
    (gchar *) "net.hadess.SensorProxy.Compass",
    (GDBusMethodInfo **) &_ms_dbus_sensor_proxy_compass_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_ms_dbus_sensor_proxy_compass_property_info_pointers,
    NULL
  },
  "sensor-proxy-compass",
};


/**
 * ms_dbus_sensor_proxy_compass_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ms_dbus_sensor_proxy_compass_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct;
}

/**
 * ms_dbus_sensor_proxy_compass_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MsDBusSensorProxyCompass interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ms_dbus_sensor_proxy_compass_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "has-compass");
  g_object_class_override_property (klass, property_id_begin++, "compass-heading");
  return property_id_begin - 1;
}


inline static void
ms_dbus_sensor_proxy_compass_method_marshal_claim_compass (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ms_dbus_sensor_proxy_compass_method_marshal_release_compass (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MsDBusSensorProxyCompass:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link>.
 */

/**
 * MsDBusSensorProxyCompassIface:
 * @parent_iface: The parent interface.
 * @handle_claim_compass: Handler for the #MsDBusSensorProxyCompass::handle-claim-compass signal.
 * @handle_release_compass: Handler for the #MsDBusSensorProxyCompass::handle-release-compass signal.
 * @get_compass_heading: Getter for the #MsDBusSensorProxyCompass:compass-heading property.
 * @get_has_compass: Getter for the #MsDBusSensorProxyCompass:has-compass property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link>.
 */

typedef MsDBusSensorProxyCompassIface MsDBusSensorProxyCompassInterface;
G_DEFINE_INTERFACE (MsDBusSensorProxyCompass, ms_dbus_sensor_proxy_compass, G_TYPE_OBJECT)

static void
ms_dbus_sensor_proxy_compass_default_init (MsDBusSensorProxyCompassIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MsDBusSensorProxyCompass::handle-claim-compass:
   * @object: A #MsDBusSensorProxyCompass.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ClaimCompass">ClaimCompass()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_compass_complete_claim_compass() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-claim-compass",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyCompassIface, handle_claim_compass),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_compass_method_marshal_claim_compass,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MsDBusSensorProxyCompass::handle-release-compass:
   * @object: A #MsDBusSensorProxyCompass.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ReleaseCompass">ReleaseCompass()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ms_dbus_sensor_proxy_compass_complete_release_compass() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-compass",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MsDBusSensorProxyCompassIface, handle_release_compass),
    g_signal_accumulator_true_handled,
    NULL,
      ms_dbus_sensor_proxy_compass_method_marshal_release_compass,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * MsDBusSensorProxyCompass:has-compass:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.HasCompass">"HasCompass"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-compass", "HasCompass", "HasCompass", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MsDBusSensorProxyCompass:compass-heading:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.CompassHeading">"CompassHeading"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("compass-heading", "CompassHeading", "CompassHeading", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ms_dbus_sensor_proxy_compass_get_has_compass: (skip)
 * @object: A #MsDBusSensorProxyCompass.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.HasCompass">"HasCompass"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ms_dbus_sensor_proxy_compass_get_has_compass (MsDBusSensorProxyCompass *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY_COMPASS (object), FALSE);

  return MS_DBUS_SENSOR_PROXY_COMPASS_GET_IFACE (object)->get_has_compass (object);
}

/**
 * ms_dbus_sensor_proxy_compass_set_has_compass: (skip)
 * @object: A #MsDBusSensorProxyCompass.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.HasCompass">"HasCompass"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_compass_set_has_compass (MsDBusSensorProxyCompass *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-compass", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_compass_get_compass_heading: (skip)
 * @object: A #MsDBusSensorProxyCompass.
 *
 * Gets the value of the <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.CompassHeading">"CompassHeading"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
ms_dbus_sensor_proxy_compass_get_compass_heading (MsDBusSensorProxyCompass *object)
{
  g_return_val_if_fail (MS_DBUS_IS_SENSOR_PROXY_COMPASS (object), 0.0);

  return MS_DBUS_SENSOR_PROXY_COMPASS_GET_IFACE (object)->get_compass_heading (object);
}

/**
 * ms_dbus_sensor_proxy_compass_set_compass_heading: (skip)
 * @object: A #MsDBusSensorProxyCompass.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-net-hadess-SensorProxy-Compass.CompassHeading">"CompassHeading"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ms_dbus_sensor_proxy_compass_set_compass_heading (MsDBusSensorProxyCompass *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "compass-heading", value, NULL);
}

/**
 * ms_dbus_sensor_proxy_compass_call_claim_compass:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ClaimCompass">ClaimCompass()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_compass_call_claim_compass_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_compass_call_claim_compass_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_compass_call_claim_compass (
    MsDBusSensorProxyCompass *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ClaimCompass",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_compass_call_claim_compass_finish:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_compass_call_claim_compass().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_compass_call_claim_compass().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_compass_call_claim_compass_finish (
    MsDBusSensorProxyCompass *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_call_claim_compass_sync:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ClaimCompass">ClaimCompass()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_compass_call_claim_compass() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_compass_call_claim_compass_sync (
    MsDBusSensorProxyCompass *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ClaimCompass",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_call_release_compass:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ReleaseCompass">ReleaseCompass()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_compass_call_release_compass_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_compass_call_release_compass_sync() for the synchronous, blocking version of this method.
 */
void
ms_dbus_sensor_proxy_compass_call_release_compass (
    MsDBusSensorProxyCompass *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseCompass",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ms_dbus_sensor_proxy_compass_call_release_compass_finish:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_compass_call_release_compass().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_compass_call_release_compass().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_compass_call_release_compass_finish (
    MsDBusSensorProxyCompass *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_call_release_compass_sync:
 * @proxy: A #MsDBusSensorProxyCompassProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ReleaseCompass">ReleaseCompass()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_compass_call_release_compass() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ms_dbus_sensor_proxy_compass_call_release_compass_sync (
    MsDBusSensorProxyCompass *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseCompass",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_complete_claim_compass:
 * @object: A #MsDBusSensorProxyCompass.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ClaimCompass">ClaimCompass()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_compass_complete_claim_compass (
    MsDBusSensorProxyCompass *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ms_dbus_sensor_proxy_compass_complete_release_compass:
 * @object: A #MsDBusSensorProxyCompass.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-net-hadess-SensorProxy-Compass.ReleaseCompass">ReleaseCompass()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ms_dbus_sensor_proxy_compass_complete_release_compass (
    MsDBusSensorProxyCompass *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MsDBusSensorProxyCompassProxy:
 *
 * The #MsDBusSensorProxyCompassProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MsDBusSensorProxyCompassProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MsDBusSensorProxyCompassProxy.
 */

struct _MsDBusSensorProxyCompassProxyPrivate
{
  GData *qdata;
};

static void ms_dbus_sensor_proxy_compass_proxy_iface_init (MsDBusSensorProxyCompassIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyCompassProxy, ms_dbus_sensor_proxy_compass_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MsDBusSensorProxyCompassProxy)
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS, ms_dbus_sensor_proxy_compass_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyCompassProxy, ms_dbus_sensor_proxy_compass_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS, ms_dbus_sensor_proxy_compass_proxy_iface_init))

#endif
static void
ms_dbus_sensor_proxy_compass_proxy_finalize (GObject *object)
{
  MsDBusSensorProxyCompassProxy *proxy = MS_DBUS_SENSOR_PROXY_COMPASS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ms_dbus_sensor_proxy_compass_proxy_parent_class)->finalize (object);
}

static void
ms_dbus_sensor_proxy_compass_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_compass_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ms_dbus_sensor_proxy_compass_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface net.hadess.SensorProxy.Compass: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ms_dbus_sensor_proxy_compass_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_compass_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "net.hadess.SensorProxy.Compass", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ms_dbus_sensor_proxy_compass_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ms_dbus_sensor_proxy_compass_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MS_DBUS_TYPE_SENSOR_PROXY_COMPASS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MS_DBUS_TYPE_SENSOR_PROXY_COMPASS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ms_dbus_sensor_proxy_compass_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MsDBusSensorProxyCompassProxy *proxy = MS_DBUS_SENSOR_PROXY_COMPASS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
ms_dbus_sensor_proxy_compass_proxy_get_has_compass (MsDBusSensorProxyCompass *object)
{
  MsDBusSensorProxyCompassProxy *proxy = MS_DBUS_SENSOR_PROXY_COMPASS_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasCompass");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
ms_dbus_sensor_proxy_compass_proxy_get_compass_heading (MsDBusSensorProxyCompass *object)
{
  MsDBusSensorProxyCompassProxy *proxy = MS_DBUS_SENSOR_PROXY_COMPASS_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CompassHeading");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
ms_dbus_sensor_proxy_compass_proxy_init (MsDBusSensorProxyCompassProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ms_dbus_sensor_proxy_compass_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_PROXY, MsDBusSensorProxyCompassProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ms_dbus_sensor_proxy_compass_interface_info ());
}

static void
ms_dbus_sensor_proxy_compass_proxy_class_init (MsDBusSensorProxyCompassProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ms_dbus_sensor_proxy_compass_proxy_finalize;
  gobject_class->get_property = ms_dbus_sensor_proxy_compass_proxy_get_property;
  gobject_class->set_property = ms_dbus_sensor_proxy_compass_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ms_dbus_sensor_proxy_compass_proxy_g_signal;
  proxy_class->g_properties_changed = ms_dbus_sensor_proxy_compass_proxy_g_properties_changed;

  ms_dbus_sensor_proxy_compass_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MsDBusSensorProxyCompassProxyPrivate));
#endif
}

static void
ms_dbus_sensor_proxy_compass_proxy_iface_init (MsDBusSensorProxyCompassIface *iface)
{
  iface->get_has_compass = ms_dbus_sensor_proxy_compass_proxy_get_has_compass;
  iface->get_compass_heading = ms_dbus_sensor_proxy_compass_proxy_get_compass_heading;
}

/**
 * ms_dbus_sensor_proxy_compass_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_compass_proxy_new_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_compass_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ms_dbus_sensor_proxy_compass_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy.Compass", NULL);
}

/**
 * ms_dbus_sensor_proxy_compass_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_compass_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_compass_proxy_new().
 *
 * Returns: (transfer full) (type MsDBusSensorProxyCompassProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxyCompass *
ms_dbus_sensor_proxy_compass_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY_COMPASS (ret);
  else
    return NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_compass_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MsDBusSensorProxyCompassProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxyCompass *
ms_dbus_sensor_proxy_compass_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy.Compass", NULL);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY_COMPASS (ret);
  else
    return NULL;
}


/**
 * ms_dbus_sensor_proxy_compass_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ms_dbus_sensor_proxy_compass_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ms_dbus_sensor_proxy_compass_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ms_dbus_sensor_proxy_compass_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ms_dbus_sensor_proxy_compass_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy.Compass", NULL);
}

/**
 * ms_dbus_sensor_proxy_compass_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ms_dbus_sensor_proxy_compass_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ms_dbus_sensor_proxy_compass_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MsDBusSensorProxyCompassProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxyCompass *
ms_dbus_sensor_proxy_compass_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY_COMPASS (ret);
  else
    return NULL;
}

/**
 * ms_dbus_sensor_proxy_compass_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ms_dbus_sensor_proxy_compass_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ms_dbus_sensor_proxy_compass_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MsDBusSensorProxyCompassProxy): The constructed proxy object or %NULL if @error is set.
 */
MsDBusSensorProxyCompass *
ms_dbus_sensor_proxy_compass_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "net.hadess.SensorProxy.Compass", NULL);
  if (ret != NULL)
    return MS_DBUS_SENSOR_PROXY_COMPASS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MsDBusSensorProxyCompassSkeleton:
 *
 * The #MsDBusSensorProxyCompassSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MsDBusSensorProxyCompassSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MsDBusSensorProxyCompassSkeleton.
 */

struct _MsDBusSensorProxyCompassSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ms_dbus_sensor_proxy_compass_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MS_DBUS_TYPE_SENSOR_PROXY_COMPASS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MS_DBUS_TYPE_SENSOR_PROXY_COMPASS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ms_dbus_sensor_proxy_compass_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ms_dbus_sensor_proxy_compass_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ms_dbus_sensor_proxy_compass_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ms_dbus_sensor_proxy_compass_skeleton_vtable =
{
  _ms_dbus_sensor_proxy_compass_skeleton_handle_method_call,
  _ms_dbus_sensor_proxy_compass_skeleton_handle_get_property,
  _ms_dbus_sensor_proxy_compass_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ms_dbus_sensor_proxy_compass_interface_info ();
}

static GDBusInterfaceVTable *
ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ms_dbus_sensor_proxy_compass_skeleton_vtable;
}

static GVariant *
ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ms_dbus_sensor_proxy_compass_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ms_dbus_sensor_proxy_compass_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ms_dbus_sensor_proxy_compass_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ms_dbus_sensor_proxy_compass_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "net.hadess.SensorProxy.Compass", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ms_dbus_sensor_proxy_compass_emit_changed (gpointer user_data);

static void
ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ms_dbus_sensor_proxy_compass_emit_changed (skeleton);
}

static void ms_dbus_sensor_proxy_compass_skeleton_iface_init (MsDBusSensorProxyCompassIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyCompassSkeleton, ms_dbus_sensor_proxy_compass_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MsDBusSensorProxyCompassSkeleton)
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS, ms_dbus_sensor_proxy_compass_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MsDBusSensorProxyCompassSkeleton, ms_dbus_sensor_proxy_compass_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS, ms_dbus_sensor_proxy_compass_skeleton_iface_init))

#endif
static void
ms_dbus_sensor_proxy_compass_skeleton_finalize (GObject *object)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ms_dbus_sensor_proxy_compass_skeleton_parent_class)->finalize (object);
}

static void
ms_dbus_sensor_proxy_compass_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ms_dbus_sensor_proxy_compass_emit_changed (gpointer user_data)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "net.hadess.SensorProxy.Compass",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ms_dbus_sensor_proxy_compass_schedule_emit_changed (MsDBusSensorProxyCompassSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ms_dbus_sensor_proxy_compass_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ms_dbus_sensor_proxy_compass_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ms_dbus_sensor_proxy_compass_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ms_dbus_sensor_proxy_compass_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ms_dbus_sensor_proxy_compass_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ms_dbus_sensor_proxy_compass_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ms_dbus_sensor_proxy_compass_skeleton_init (MsDBusSensorProxyCompassSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ms_dbus_sensor_proxy_compass_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_SKELETON, MsDBusSensorProxyCompassSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_DOUBLE);
}

static gboolean 
ms_dbus_sensor_proxy_compass_skeleton_get_has_compass (MsDBusSensorProxyCompass *object)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
ms_dbus_sensor_proxy_compass_skeleton_get_compass_heading (MsDBusSensorProxyCompass *object)
{
  MsDBusSensorProxyCompassSkeleton *skeleton = MS_DBUS_SENSOR_PROXY_COMPASS_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ms_dbus_sensor_proxy_compass_skeleton_class_init (MsDBusSensorProxyCompassSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ms_dbus_sensor_proxy_compass_skeleton_finalize;
  gobject_class->get_property = ms_dbus_sensor_proxy_compass_skeleton_get_property;
  gobject_class->set_property = ms_dbus_sensor_proxy_compass_skeleton_set_property;
  gobject_class->notify       = ms_dbus_sensor_proxy_compass_skeleton_notify;


  ms_dbus_sensor_proxy_compass_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ms_dbus_sensor_proxy_compass_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MsDBusSensorProxyCompassSkeletonPrivate));
#endif
}

static void
ms_dbus_sensor_proxy_compass_skeleton_iface_init (MsDBusSensorProxyCompassIface *iface)
{
  iface->get_has_compass = ms_dbus_sensor_proxy_compass_skeleton_get_has_compass;
  iface->get_compass_heading = ms_dbus_sensor_proxy_compass_skeleton_get_compass_heading;
}

/**
 * ms_dbus_sensor_proxy_compass_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-net-hadess-SensorProxy-Compass.top_of_page">net.hadess.SensorProxy.Compass</link>.
 *
 * Returns: (transfer full) (type MsDBusSensorProxyCompassSkeleton): The skeleton object.
 */
MsDBusSensorProxyCompass *
ms_dbus_sensor_proxy_compass_skeleton_new (void)
{
  return MS_DBUS_SENSOR_PROXY_COMPASS (g_object_new (MS_DBUS_TYPE_SENSOR_PROXY_COMPASS_SKELETON, NULL));
}

