// ClientServer wrapper for vtkPVGeneralSettings object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPVGeneralSettings.h"
#include "vtkSystemIncludes.h"
#include "vtkStdString.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkPVGeneralSettingsClientServerNewCommand(void* /*ctx*/)
{
  return vtkPVGeneralSettings::New();
}


static int vtkPVGeneralSettingsCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkPVGeneralSettings *op = vtkPVGeneralSettings::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkPVGeneralSettings.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPVGeneralSettings  *temp20;
      {
      temp20 = vtkPVGeneralSettings::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkPVGeneralSettings::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkPVGeneralSettings  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkPVGeneralSettings::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPVGeneralSettings  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkPVGeneralSettings::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPVGeneralSettings  *temp20;
      {
      temp20 = vtkPVGeneralSettings::GetInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAutoConvertProperties",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAutoConvertProperties(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAutoConvertProperties",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAutoConvertProperties();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("AutoConvertPropertiesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AutoConvertPropertiesOn();
      return 1;
      }
    }
  if (!strcmp("AutoConvertPropertiesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->AutoConvertPropertiesOff();
      return 1;
      }
    }
  if (!strcmp("GetBlockColorsDistinctValues",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetBlockColorsDistinctValues();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetBlockColorsDistinctValues",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetBlockColorsDistinctValues(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAutoApply",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAutoApply();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAutoApply",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAutoApply(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAutoApplyDelay",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetAutoApplyDelay();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAutoApplyDelay",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAutoApplyDelay(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAutoApplyActiveOnly",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAutoApplyActiveOnly();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAutoApplyActiveOnly",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAutoApplyActiveOnly(temp0);
      return 1;
      }
    }
  if (!strcmp("GetPreservePropertyValues",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetPreservePropertyValues();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetPreservePropertyValues",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPreservePropertyValues(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDefaultViewType",method) && msg.GetNumberOfArguments(0) == 2)
    {
    std::string   temp20;
      {
      temp20 = (op)->GetDefaultViewType();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetDefaultViewType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *  temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetDefaultViewType(static_cast<std::string>(vtkStdString(temp0)));
      return 1;
      }
    }
  if (!strcmp("GetInterfaceLanguage",method) && msg.GetNumberOfArguments(0) == 2)
    {
    std::string   temp20;
      {
      temp20 = (op)->GetInterfaceLanguage();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetInterfaceLanguage",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *  temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetInterfaceLanguage(static_cast<std::string>(vtkStdString(temp0)));
      return 1;
      }
    }
  if (!strcmp("SetScalarBarMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetScalarBarMode(temp0);
      return 1;
      }
    }
  if (!strcmp("GetScalarBarMode",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetScalarBarMode();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetCacheGeometryForAnimation",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetCacheGeometryForAnimation(temp0);
      return 1;
      }
    }
  if (!strcmp("GetCacheGeometryForAnimation",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetCacheGeometryForAnimation();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("CacheGeometryForAnimationOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CacheGeometryForAnimationOn();
      return 1;
      }
    }
  if (!strcmp("CacheGeometryForAnimationOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->CacheGeometryForAnimationOff();
      return 1;
      }
    }
  if (!strcmp("SetAnimationGeometryCacheLimit",method) && msg.GetNumberOfArguments(0) == 3)
    {
    unsigned long     temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAnimationGeometryCacheLimit(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAnimationGeometryCacheLimit",method) && msg.GetNumberOfArguments(0) == 2)
    {
    unsigned long     temp20;
      {
      temp20 = (op)->GetAnimationGeometryCacheLimit();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAnimationTimeNotation",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAnimationTimeNotation(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAnimationTimeNotation",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetAnimationTimeNotation();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAnimationTimeShortestAccuratePrecision",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAnimationTimeShortestAccuratePrecision(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAnimationTimeShortestAccuratePrecision",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetAnimationTimeShortestAccuratePrecision();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetAnimationTimePrecision",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetAnimationTimePrecision(temp0);
      return 1;
      }
    }
  if (!strcmp("GetAnimationTimePrecision",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetAnimationTimePrecision();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetShowAnimationShortcuts",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetShowAnimationShortcuts(temp0);
      return 1;
      }
    }
  if (!strcmp("GetShowAnimationShortcuts",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetShowAnimationShortcuts();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ShowAnimationShortcutsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ShowAnimationShortcutsOn();
      return 1;
      }
    }
  if (!strcmp("ShowAnimationShortcutsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ShowAnimationShortcutsOff();
      return 1;
      }
    }
  if (!strcmp("SetResetDisplayEmptyViews",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetResetDisplayEmptyViews(temp0);
      return 1;
      }
    }
  if (!strcmp("GetResetDisplayEmptyViews",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetResetDisplayEmptyViews();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ResetDisplayEmptyViewsOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetDisplayEmptyViewsOn();
      return 1;
      }
    }
  if (!strcmp("ResetDisplayEmptyViewsOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ResetDisplayEmptyViewsOff();
      return 1;
      }
    }
  if (!strcmp("SetRealNumberDisplayedNotation",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetRealNumberDisplayedNotation(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRealNumberDisplayedNotation",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetRealNumberDisplayedNotation();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetRealNumberDisplayedShortestAccuratePrecision",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetRealNumberDisplayedShortestAccuratePrecision(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRealNumberDisplayedShortestAccuratePrecision",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetRealNumberDisplayedShortestAccuratePrecision();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetRealNumberDisplayedPrecision",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetRealNumberDisplayedPrecision(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRealNumberDisplayedPrecision",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetRealNumberDisplayedPrecision();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetFullNotationLowExponent",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFullNotationLowExponent(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFullNotationLowExponent",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFullNotationLowExponent();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetFullNotationHighExponent",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetFullNotationHighExponent(temp0);
      return 1;
      }
    }
  if (!strcmp("GetFullNotationHighExponent",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetFullNotationHighExponent();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetInheritRepresentationProperties",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetInheritRepresentationProperties(temp0);
      return 1;
      }
    }
  if (!strcmp("GetInheritRepresentationProperties",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetInheritRepresentationProperties();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("InheritRepresentationPropertiesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->InheritRepresentationPropertiesOn();
      return 1;
      }
    }
  if (!strcmp("InheritRepresentationPropertiesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->InheritRepresentationPropertiesOff();
      return 1;
      }
    }
  if (!strcmp("SetIgnoreNegativeLogAxisWarning",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetIgnoreNegativeLogAxisWarning(temp0);
      return 1;
      }
    }
  if (!strcmp("GetIgnoreNegativeLogAxisWarning",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetIgnoreNegativeLogAxisWarning();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IgnoreNegativeLogAxisWarningOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->IgnoreNegativeLogAxisWarningOn();
      return 1;
      }
    }
  if (!strcmp("IgnoreNegativeLogAxisWarningOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->IgnoreNegativeLogAxisWarningOff();
      return 1;
      }
    }
  if (!strcmp("SetPropertiesPanelMode",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPropertiesPanelMode(temp0);
      return 1;
      }
    }
  if (!strcmp("GetPropertiesPanelMode",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetPropertiesPanelMode();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetLockPanels",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLockPanels(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLockPanels",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetLockPanels();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetLoadAllVariables",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLoadAllVariables(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLoadAllVariables",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetLoadAllVariables();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LoadAllVariablesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadAllVariablesOn();
      return 1;
      }
    }
  if (!strcmp("LoadAllVariablesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadAllVariablesOff();
      return 1;
      }
    }
  if (!strcmp("SetLoadNoChartVariables",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLoadNoChartVariables(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLoadNoChartVariables",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetLoadNoChartVariables();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LoadNoChartVariablesOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadNoChartVariablesOn();
      return 1;
      }
    }
  if (!strcmp("LoadNoChartVariablesOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LoadNoChartVariablesOff();
      return 1;
      }
    }
  if (!strcmp("SetGUIFontSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGUIFontSize(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGUIFontSizeMinValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetGUIFontSizeMinValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetGUIFontSizeMaxValue",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetGUIFontSizeMaxValue();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetGUIFontSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetGUIFontSize();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetGUIOverrideFont",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetGUIOverrideFont(temp0);
      return 1;
      }
    }
  if (!strcmp("GetGUIOverrideFont",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetGUIOverrideFont();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetColorByBlockColorsOnApply",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetColorByBlockColorsOnApply(temp0);
      return 1;
      }
    }
  if (!strcmp("GetColorByBlockColorsOnApply",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetColorByBlockColorsOnApply();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetEnableStreaming",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetEnableStreaming(temp0);
      return 1;
      }
    }
  if (!strcmp("GetEnableStreaming",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetEnableStreaming();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("EnableStreamingOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->EnableStreamingOn();
      return 1;
      }
    }
  if (!strcmp("EnableStreamingOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->EnableStreamingOff();
      return 1;
      }
    }
  if (!strcmp("SetUseAcceleratedFilters",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetUseAcceleratedFilters(temp0);
      return 1;
      }
    }
  if (!strcmp("GetUseAcceleratedFilters",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetUseAcceleratedFilters();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("UseAcceleratedFiltersOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->UseAcceleratedFiltersOn();
      return 1;
      }
    }
  if (!strcmp("UseAcceleratedFiltersOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->UseAcceleratedFiltersOff();
      return 1;
      }
    }
  if (!strcmp("GetSelectOnClickMultiBlockInspector",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetSelectOnClickMultiBlockInspector();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetSelectOnClickMultiBlockInspector",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetSelectOnClickMultiBlockInspector(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfCallbackThreads",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = vtkPVGeneralSettings::GetNumberOfCallbackThreads();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetNumberOfCallbackThreads",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      vtkPVGeneralSettings::SetNumberOfCallbackThreads(temp0);
      return 1;
      }
    }
  if (!strcmp("GetNumberOfSMPThreads",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = vtkPVGeneralSettings::GetNumberOfSMPThreads();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetNumberOfSMPThreads",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      vtkPVGeneralSettings::SetNumberOfSMPThreads(temp0);
      return 1;
      }
    }

  {
    const char* commandName = "vtkObject";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkPVGeneralSettings, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkPVGeneralSettings_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkPVGeneralSettings", vtkPVGeneralSettingsClientServerNewCommand);
    csi->AddCommandFunction("vtkPVGeneralSettings", vtkPVGeneralSettingsCommand);
    }
}
}
