#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkXdmf3ArrayKeeper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3ArraySelection_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3DataSet_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3HeavyDataHandler_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3LightDataHandler_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3Reader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3SILBuilder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkXdmf3Writer_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOXdmf3CS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkXdmf3ArrayKeeper_Init(csi);
  vtkXdmf3ArraySelection_Init(csi);
  vtkXdmf3DataSet_Init(csi);
  vtkXdmf3HeavyDataHandler_Init(csi);
  vtkXdmf3LightDataHandler_Init(csi);
  vtkXdmf3Reader_Init(csi);
  vtkXdmf3SILBuilder_Init(csi);
  vtkXdmf3Writer_Init(csi);
}
