/* SourceHoldingTank.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceHoldingTank.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* A SourceHoldingTank is similar to the holding tank used by ContainerSourceCollection, but for*/
/* non-ContainerSources to be held offline from their natural SourceCollection (i.e. PhotoSources*/
/* being held in a trashcan, for example).  It is *not* a DataCollection (important!), but rather*/
/* a signalled collection that moves DataSources to and from their SourceCollection.*/
/**/
/* DataSources can be shuttled from their SourceCollection to the SourceHoldingTank manually*/
/* (via unlink_and_hold) or can be automatically moved by installing a HoldingPredicate.*/
/* Only one HoldingConditional may be installed.  Because of assertions in the methods, it's unwise*/
/* to use more than one method.  add () and add_many () should ONLY be used for DataSources not*/
/* first installed in their SourceCollection (i.e. they're born in the SourceHoldingTank).*/
/**/
/* NOTE: DataSources should never be in more than one SourceHoldingTank.  No tests are performed*/
/* here to verify this.  This is why a filter/predicate method (which could automatically move*/
/* them in as they're altered) is not offered; there's no easy way to keep DataSources from being*/
/* moved into more than one holding tank, or which should have preference.  The CheckToRemove*/
/* predicate is offered only to know when to release them.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecSourceHoldingTank ParamSpecSourceHoldingTank;
enum  {
	SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL,
	SOURCE_HOLDING_TANK_NUM_SIGNALS
};
static guint source_holding_tank_signals[SOURCE_HOLDING_TANK_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SourceHoldingTankPrivate {
	SourceCollection* sources;
	SourceHoldingTankCheckToKeep check_to_keep;
	gpointer check_to_keep_target;
	DataSet* tank;
	GeeHashSet* relinks;
	GeeHashSet* unlinking;
	gint64 ordinal;
};

struct _ParamSpecSourceHoldingTank {
	GParamSpec parent_instance;
};

static gint SourceHoldingTank_private_offset;
static gpointer source_holding_tank_parent_class = NULL;

static void source_holding_tank_on_source_destroyed (SourceHoldingTank* self,
                                              DataSource* source);
static void _source_holding_tank_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                DataSource* source,
                                                                                gpointer self);
static void source_holding_tank_on_source_collection_thawed (SourceHoldingTank* self);
static void _source_holding_tank_on_source_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                              gpointer self);
static void source_holding_tank_real_notify_contents_altered (SourceHoldingTank* self,
                                                       GeeCollection* added,
                                                       GeeCollection* removed);
static void source_holding_tank_real_contents_altered (SourceHoldingTank* self,
                                                GeeCollection* added,
                                                GeeCollection* removed);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void source_holding_tank_finalize (SourceHoldingTank * obj);
static GType source_holding_tank_get_type_once (void);

static inline gpointer
source_holding_tank_get_instance_private (SourceHoldingTank* self)
{
	return G_STRUCT_MEMBER_P (self, SourceHoldingTank_private_offset);
}

static void
_source_holding_tank_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                           DataSource* source,
                                                                           gpointer self)
{
	source_holding_tank_on_source_destroyed ((SourceHoldingTank*) self, source);
}

static void
_source_holding_tank_on_source_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                         gpointer self)
{
	source_holding_tank_on_source_collection_thawed ((SourceHoldingTank*) self);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

SourceHoldingTank*
source_holding_tank_construct (GType object_type,
                               SourceCollection* sources,
                               SourceHoldingTankCheckToKeep check_to_keep,
                               gpointer check_to_keep_target)
{
	SourceHoldingTank* self = NULL;
	SourceCollection* _tmp0_;
	SourceCollection* _tmp1_;
	SourceCollection* _tmp2_;
	g_return_val_if_fail (sources != NULL, NULL);
	self = (SourceHoldingTank*) g_type_create_instance (object_type);
	_tmp0_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	self->priv->check_to_keep = check_to_keep;
	self->priv->check_to_keep_target = check_to_keep_target;
	_tmp1_ = self->priv->sources;
	g_signal_connect (_tmp1_, "item-destroyed", (GCallback) _source_holding_tank_on_source_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = self->priv->sources;
	g_signal_connect ((DataCollection*) _tmp2_, "thawed", (GCallback) _source_holding_tank_on_source_collection_thawed_data_collection_thawed, self);
	return self;
}

SourceHoldingTank*
source_holding_tank_new (SourceCollection* sources,
                         SourceHoldingTankCheckToKeep check_to_keep,
                         gpointer check_to_keep_target)
{
	return source_holding_tank_construct (TYPE_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target);
}

static void
source_holding_tank_real_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed)
{
	if (added != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
			_source_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				DataSource* _tmp4_;
				_tmp1_ = _source_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _source_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				source = (DataSource*) _tmp3_;
				_tmp4_ = source;
				data_source_notify_held_in_tank (_tmp4_, self);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) removed);
			_source_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				DataSource* source = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				DataSource* _tmp9_;
				_tmp6_ = _source_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _source_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				source = (DataSource*) _tmp8_;
				_tmp9_ = source;
				data_source_notify_held_in_tank (_tmp9_, NULL);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	g_signal_emit (self, source_holding_tank_signals[SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL], 0, added, removed);
}

void
source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                             GeeCollection* added,
                                             GeeCollection* removed)
{
	SourceHoldingTankClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SOURCE_HOLDING_TANK_GET_CLASS (self);
	if (_klass_->notify_contents_altered) {
		_klass_->notify_contents_altered (self, added, removed);
	}
}

gint
source_holding_tank_get_count (SourceHoldingTank* self)
{
	DataSet* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tank;
	result = data_set_get_count (_tmp0_);
	return result;
}

GeeCollection*
source_holding_tank_get_all (SourceHoldingTank* self)
{
	DataSet* _tmp0_;
	GeeList* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tank;
	_tmp1_ = data_set_get_all (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

gboolean
source_holding_tank_contains (SourceHoldingTank* self,
                              DataSource* source)
{
	gboolean _tmp0_ = FALSE;
	DataSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp1_ = self->priv->tank;
	if (data_set_contains (_tmp1_, (DataObject*) source)) {
		_tmp0_ = TRUE;
	} else {
		GeeHashSet* _tmp2_;
		_tmp2_ = self->priv->unlinking;
		_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp2_, source);
	}
	result = _tmp0_;
	return result;
}

void
source_holding_tank_add_many (SourceHoldingTank* self,
                              GeeCollection* many)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (many != NULL);
	_tmp0_ = gee_collection_get_size (many);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) many);
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* _tmp6_;
			gint64 _tmp7_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (DataSource*) _tmp5_;
			_tmp6_ = source;
			_tmp7_ = self->priv->ordinal;
			self->priv->ordinal = _tmp7_ + 1;
			data_object_internal_set_ordinal ((DataObject*) _tmp6_, _tmp7_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp8_ = self->priv->tank;
	added = data_set_add_many (_tmp8_, many);
	_vala_assert (added, "added");
	source_holding_tank_notify_contents_altered (self, many, NULL);
}

void
source_holding_tank_unlink_and_hold (SourceHoldingTank* self,
                                     GeeCollection* unlink)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeHashSet* _tmp2_;
	SourceCollection* _tmp3_;
	SourceCollection* _tmp4_;
	Marker* _tmp5_;
	Marker* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	gboolean added = FALSE;
	DataSet* _tmp15_;
	GeeHashSet* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlink != NULL);
	_tmp0_ = gee_collection_get_size (unlink);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = self->priv->unlinking;
	gee_collection_add_all ((GeeCollection*) _tmp2_, unlink);
	_tmp3_ = self->priv->sources;
	_tmp4_ = self->priv->sources;
	_tmp5_ = data_collection_mark_many ((DataCollection*) _tmp4_, unlink);
	_tmp6_ = _tmp5_;
	_tmp7_ = source_collection_unlink_marked (_tmp3_, _tmp6_, NULL, NULL);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp9_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) unlink);
		_source_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataSource* source = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataSource* _tmp13_;
			gint64 _tmp14_;
			_tmp10_ = _source_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _source_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			source = (DataSource*) _tmp12_;
			_tmp13_ = source;
			_tmp14_ = self->priv->ordinal;
			self->priv->ordinal = _tmp14_ + 1;
			data_object_internal_set_ordinal ((DataObject*) _tmp13_, _tmp14_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp15_ = self->priv->tank;
	added = data_set_add_many (_tmp15_, unlink);
	_vala_assert (added, "added");
	_tmp16_ = self->priv->unlinking;
	gee_collection_remove_all ((GeeCollection*) _tmp16_, unlink);
	source_holding_tank_notify_contents_altered (self, unlink, NULL);
}

gboolean
source_holding_tank_has_backlink (SourceHoldingTank* self,
                                  SourceBacklink* backlink)
{
	gint count = 0;
	DataSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (backlink != NULL, FALSE);
	_tmp0_ = self->priv->tank;
	count = data_set_get_count (_tmp0_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				DataSet* _tmp3_;
				DataObject* _tmp4_;
				DataSource* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp3_ = self->priv->tank;
				_tmp4_ = data_set_get_at (_tmp3_, ctr);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource);
				_tmp6_ = data_source_has_backlink (_tmp5_, backlink);
				_g_object_unref0 (_tmp5_);
				if (_tmp6_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
source_holding_tank_remove_backlink (SourceHoldingTank* self,
                                     SourceBacklink* backlink)
{
	gint count = 0;
	DataSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backlink != NULL);
	_tmp0_ = self->priv->tank;
	count = data_set_get_count (_tmp0_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				DataSet* _tmp3_;
				DataObject* _tmp4_;
				DataSource* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp3_ = self->priv->tank;
				_tmp4_ = data_set_get_at (_tmp3_, ctr);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource);
				data_source_remove_backlink (_tmp5_, backlink);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
}

void
source_holding_tank_destroy_orphans (SourceHoldingTank* self,
                                     GeeList* destroy,
                                     gboolean delete_backing,
                                     ProgressMonitor monitor,
                                     gpointer monitor_target,
                                     GeeList* not_removed)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean removed = FALSE;
	DataSet* _tmp2_;
	gint count = 0;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destroy != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) destroy);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = self->priv->tank;
	removed = data_set_remove_many (_tmp2_, (GeeCollection*) destroy);
	_vala_assert (removed, "removed");
	source_holding_tank_notify_contents_altered (self, NULL, (GeeCollection*) destroy);
	_tmp3_ = gee_collection_get_size ((GeeCollection*) destroy);
	_tmp4_ = _tmp3_;
	count = _tmp4_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				DataSource* source = NULL;
				gpointer _tmp7_;
				DataSource* _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = ctr;
					ctr = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp7_ = gee_list_get (destroy, ctr);
				source = (DataSource*) _tmp7_;
				_tmp8_ = source;
				if (!data_source_destroy_orphan (_tmp8_, delete_backing)) {
					if (NULL != not_removed) {
						DataSource* _tmp9_;
						_tmp9_ = source;
						gee_collection_add ((GeeCollection*) not_removed, _tmp9_);
					}
				}
				if (monitor != NULL) {
					monitor ((guint64) (ctr + 1), (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (source);
			}
		}
	}
}

static void
source_holding_tank_on_source_destroyed (SourceHoldingTank* self,
                                         DataSource* source)
{
	DataSet* _tmp0_;
	gboolean removed = FALSE;
	DataSet* _tmp1_;
	SingletonCollection* _tmp2_;
	SingletonCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->tank;
	if (!data_set_contains (_tmp0_, (DataObject*) source)) {
		return;
	}
	_tmp1_ = self->priv->tank;
	removed = data_set_remove (_tmp1_, (DataObject*) source);
	_vala_assert (removed, "removed");
	_tmp2_ = singleton_collection_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, source);
	_tmp3_ = _tmp2_;
	source_holding_tank_notify_contents_altered (self, NULL, (GeeCollection*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}

void
source_holding_tank_internal_notify_altered (SourceHoldingTank* self,
                                             DataSource* source,
                                             Alteration* alteration)
{
	DataSet* _tmp0_;
	SourceHoldingTankCheckToKeep _tmp5_;
	gpointer _tmp5__target;
	gboolean removed = FALSE;
	DataSet* _tmp6_;
	SourceCollection* _tmp7_;
	SingletonCollection* _tmp9_;
	SingletonCollection* _tmp10_;
	SourceCollection* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (alteration != NULL);
	_tmp0_ = self->priv->tank;
	if (!data_set_contains (_tmp0_, (DataObject*) source)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = data_object_to_string ((DataObject*) source);
		_tmp2_ = _tmp1_;
		_tmp3_ = source_holding_tank_to_string (self);
		_tmp4_ = _tmp3_;
		g_debug ("SourceHoldingTank.vala:181: SourceHoldingTank.internal_notify_altered " \
"called for %s not stored in %s", _tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	_tmp5_ = self->priv->check_to_keep;
	_tmp5__target = self->priv->check_to_keep_target;
	if (_tmp5_ (source, alteration, _tmp5__target)) {
		return;
	}
	_tmp6_ = self->priv->tank;
	removed = data_set_remove (_tmp6_, (DataObject*) source);
	_vala_assert (removed, "removed");
	_tmp7_ = self->priv->sources;
	if (data_collection_are_notifications_frozen ((DataCollection*) _tmp7_)) {
		GeeHashSet* _tmp8_;
		_tmp8_ = self->priv->relinks;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, source);
		return;
	}
	_tmp9_ = singleton_collection_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, source);
	_tmp10_ = _tmp9_;
	source_holding_tank_notify_contents_altered (self, NULL, (GeeCollection*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->sources;
	source_collection_relink (_tmp11_, source);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
source_holding_tank_on_source_collection_thawed (SourceHoldingTank* self)
{
	GeeHashSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeHashSet* copy = NULL;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	SourceCollection* _tmp7_;
	GeeHashSet* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->relinks;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->relinks;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	copy = _tmp4_;
	_tmp5_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->relinks);
	self->priv->relinks = _tmp5_;
	_tmp6_ = copy;
	source_holding_tank_notify_contents_altered (self, NULL, (GeeCollection*) _tmp6_);
	_tmp7_ = self->priv->sources;
	_tmp8_ = copy;
	source_collection_relink_many (_tmp7_, (GeeCollection*) _tmp8_);
	_g_object_unref0 (copy);
}

gchar*
source_holding_tank_to_string (SourceHoldingTank* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("SourceHoldingTank @ 0x%p", self);
	result = _tmp0_;
	return result;
}

static void
source_holding_tank_real_contents_altered (SourceHoldingTank* self,
                                           GeeCollection* added,
                                           GeeCollection* removed)
{
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
value_source_holding_tank_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_source_holding_tank_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		source_holding_tank_unref (value->data[0].v_pointer);
	}
}

static void
value_source_holding_tank_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = source_holding_tank_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_source_holding_tank_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_source_holding_tank_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SourceHoldingTank * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = source_holding_tank_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_source_holding_tank_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	SourceHoldingTank ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = source_holding_tank_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_source_holding_tank (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecSourceHoldingTank* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOURCE_HOLDING_TANK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_source_holding_tank (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_source_holding_tank (GValue* value,
                               gpointer v_object)
{
	SourceHoldingTank * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_HOLDING_TANK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		source_holding_tank_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_holding_tank_unref (old);
	}
}

void
value_take_source_holding_tank (GValue* value,
                                gpointer v_object)
{
	SourceHoldingTank * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOURCE_HOLDING_TANK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOURCE_HOLDING_TANK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		source_holding_tank_unref (old);
	}
}

static void
source_holding_tank_class_init (SourceHoldingTankClass * klass,
                                gpointer klass_data)
{
	source_holding_tank_parent_class = g_type_class_peek_parent (klass);
	((SourceHoldingTankClass *) klass)->finalize = source_holding_tank_finalize;
	g_type_class_adjust_private_offset (klass, &SourceHoldingTank_private_offset);
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank*, GeeCollection*, GeeCollection*)) source_holding_tank_real_notify_contents_altered;
	((SourceHoldingTankClass *) klass)->contents_altered = source_holding_tank_real_contents_altered;
	source_holding_tank_signals[SOURCE_HOLDING_TANK_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("contents-altered", TYPE_SOURCE_HOLDING_TANK, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceHoldingTankClass, contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_COLLECTION, GEE_TYPE_COLLECTION);
}

static void
source_holding_tank_instance_init (SourceHoldingTank * self,
                                   gpointer klass)
{
	DataSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	self->priv = source_holding_tank_get_instance_private (self);
	_tmp0_ = data_set_new ();
	self->priv->tank = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->relinks = _tmp1_;
	_tmp2_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->unlinking = _tmp2_;
	self->priv->ordinal = (gint64) 0;
	self->ref_count = 1;
}

static void
source_holding_tank_finalize (SourceHoldingTank * obj)
{
	SourceHoldingTank * self;
	SourceCollection* _tmp0_;
	guint _tmp1_;
	SourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->sources;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _source_holding_tank_on_source_destroyed_source_collection_item_destroyed, self);
	_tmp2_ = self->priv->sources;
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _source_holding_tank_on_source_collection_thawed_data_collection_thawed, self);
	_data_collection_unref0 (self->priv->sources);
	_data_set_unref0 (self->priv->tank);
	_g_object_unref0 (self->priv->relinks);
	_g_object_unref0 (self->priv->unlinking);
}

static GType
source_holding_tank_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_source_holding_tank_init, value_source_holding_tank_free_value, value_source_holding_tank_copy_value, value_source_holding_tank_peek_pointer, "p", value_source_holding_tank_collect_value, "p", value_source_holding_tank_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceHoldingTank), 0, (GInstanceInitFunc) source_holding_tank_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType source_holding_tank_type_id;
	source_holding_tank_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SourceHoldingTank", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SourceHoldingTank_private_offset = g_type_add_instance_private (source_holding_tank_type_id, sizeof (SourceHoldingTankPrivate));
	return source_holding_tank_type_id;
}

GType
source_holding_tank_get_type (void)
{
	static volatile gsize source_holding_tank_type_id__once = 0;
	if (g_once_init_enter (&source_holding_tank_type_id__once)) {
		GType source_holding_tank_type_id;
		source_holding_tank_type_id = source_holding_tank_get_type_once ();
		g_once_init_leave (&source_holding_tank_type_id__once, source_holding_tank_type_id);
	}
	return source_holding_tank_type_id__once;
}

gpointer
source_holding_tank_ref (gpointer instance)
{
	SourceHoldingTank * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
source_holding_tank_unref (gpointer instance)
{
	SourceHoldingTank * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOURCE_HOLDING_TANK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

